/* util-cache.c generated by valac 0.56.3, the Vala compiler
 * generated from util-cache.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "geary-engine.h"
#include <gobject/gvaluecollector.h>

#define UTIL_CACHE_LRU_TYPE_CACHE_ENTRY (util_cache_lru_cache_entry_get_type ())
#define UTIL_CACHE_LRU_CACHE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, UtilCacheLruCacheEntry))
#define UTIL_CACHE_LRU_CACHE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, UtilCacheLruCacheEntryClass))
#define UTIL_CACHE_LRU_IS_CACHE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UTIL_CACHE_LRU_TYPE_CACHE_ENTRY))
#define UTIL_CACHE_LRU_IS_CACHE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UTIL_CACHE_LRU_TYPE_CACHE_ENTRY))
#define UTIL_CACHE_LRU_CACHE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, UtilCacheLruCacheEntryClass))

typedef struct _UtilCacheLruCacheEntry UtilCacheLruCacheEntry;
typedef struct _UtilCacheLruCacheEntryClass UtilCacheLruCacheEntryClass;
enum  {
	UTIL_CACHE_LRU_0_PROPERTY,
	UTIL_CACHE_LRU_T_TYPE,
	UTIL_CACHE_LRU_T_DUP_FUNC,
	UTIL_CACHE_LRU_T_DESTROY_FUNC,
	UTIL_CACHE_LRU_MAX_SIZE_PROPERTY,
	UTIL_CACHE_LRU_IS_EMPTY_PROPERTY,
	UTIL_CACHE_LRU_SIZE_PROPERTY,
	UTIL_CACHE_LRU_NUM_PROPERTIES
};
static GParamSpec* util_cache_lru_properties[UTIL_CACHE_LRU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
typedef struct _UtilCacheLruCacheEntryPrivate UtilCacheLruCacheEntryPrivate;
#define _util_cache_lru_cache_entry_unref0(var) ((var == NULL) ? NULL : (var = (util_cache_lru_cache_entry_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UtilCacheLruParamSpecCacheEntry UtilCacheLruParamSpecCacheEntry;

struct _UtilCacheLruPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	guint _max_size;
	GeeMap* cache;
	GSequence* ordering;
};

struct _UtilCacheLruCacheEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* key;
	gpointer value;
	gint64 last_used;
	UtilCacheLruCacheEntryPrivate * priv;
};

struct _UtilCacheLruCacheEntryClass {
	GTypeClass parent_class;
	void (*finalize) (UtilCacheLruCacheEntry *self);
};

struct _UtilCacheLruCacheEntryPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
};

struct _UtilCacheLruParamSpecCacheEntry {
	GParamSpec parent_instance;
};

static gint UtilCacheLru_private_offset;
static gpointer util_cache_lru_parent_class = NULL;
static gint UtilCacheLruCacheEntry_private_offset;
static gpointer util_cache_lru_cache_entry_parent_class = NULL;

static gpointer util_cache_lru_cache_entry_ref (gpointer instance);
static void util_cache_lru_cache_entry_unref (gpointer instance);
static GParamSpec* util_cache_lru_param_spec_cache_entry (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void util_cache_lru_value_set_cache_entry (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void util_cache_lru_value_take_cache_entry (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer util_cache_lru_value_get_cache_entry (const GValue* value) G_GNUC_UNUSED ;
static GType util_cache_lru_cache_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _util_cache_lru_cache_entry_unref0_ (gpointer var);
static UtilCacheLruCacheEntry* util_cache_lru_cache_entry_new (GType t_type,
                                                        GBoxedCopyFunc t_dup_func,
                                                        GDestroyNotify t_destroy_func,
                                                        const gchar* key,
                                                        gconstpointer value,
                                                        gint64 last_used);
static UtilCacheLruCacheEntry* util_cache_lru_cache_entry_construct (GType object_type,
                                                              GType t_type,
                                                              GBoxedCopyFunc t_dup_func,
                                                              GDestroyNotify t_destroy_func,
                                                              const gchar* key,
                                                              gconstpointer value,
                                                              gint64 last_used);
static gint util_cache_lru_cache_entry_lru_compare (UtilCacheLruCacheEntry* a,
                                             UtilCacheLruCacheEntry* b);
static gint _util_cache_lru_cache_entry_lru_compare_gcompare_data_func (gconstpointer a,
                                                                 gconstpointer b,
                                                                 gpointer self);
static void util_cache_lru_cache_entry_finalize (UtilCacheLruCacheEntry * obj);
static GType util_cache_lru_cache_entry_get_type_once (void);
static void util_cache_lru_finalize (GObject * obj);
static GType util_cache_lru_get_type_once (void);
static void _vala_util_cache_lru_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_util_cache_lru_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
util_cache_lru_get_instance_private (UtilCacheLru* self)
{
	return G_STRUCT_MEMBER_P (self, UtilCacheLru_private_offset);
}

guint
util_cache_lru_get_max_size (UtilCacheLru* self)
{
	guint result;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), 0U);
	result = self->priv->_max_size;
	return result;
}

void
util_cache_lru_set_max_size (UtilCacheLru* self,
                             guint value)
{
	guint old_value;
	g_return_if_fail (UTIL_CACHE_IS_LRU (self));
	old_value = util_cache_lru_get_max_size (self);
	if (old_value != value) {
		self->priv->_max_size = value;
		g_object_notify_by_pspec ((GObject *) self, util_cache_lru_properties[UTIL_CACHE_LRU_MAX_SIZE_PROPERTY]);
	}
}

gboolean
util_cache_lru_get_is_empty (UtilCacheLru* self)
{
	gboolean result;
	GeeMap* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), FALSE);
	_tmp0_ = self->priv->cache;
	_tmp1_ = gee_map_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint
util_cache_lru_get_size (UtilCacheLru* self)
{
	guint result;
	GeeMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), 0U);
	_tmp0_ = self->priv->cache;
	_tmp1_ = gee_map_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static void
_util_cache_lru_cache_entry_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (util_cache_lru_cache_entry_unref (var), NULL));
}

/**
     * Creates a new least-recently-used cache with the given size.
     */
UtilCacheLru*
util_cache_lru_construct (GType object_type,
                          GType t_type,
                          GBoxedCopyFunc t_dup_func,
                          GDestroyNotify t_destroy_func,
                          guint max_size)
{
	UtilCacheLru * self = NULL;
	self = (UtilCacheLru*) geary_base_object_construct (object_type);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	util_cache_lru_set_max_size (self, max_size);
	return self;
}

UtilCacheLru*
util_cache_lru_new (GType t_type,
                    GBoxedCopyFunc t_dup_func,
                    GDestroyNotify t_destroy_func,
                    guint max_size)
{
	return util_cache_lru_construct (UTIL_CACHE_TYPE_LRU, t_type, t_dup_func, t_destroy_func, max_size);
}

/**
     * Determines if the given key exists in the cache.
     */
gboolean
util_cache_lru_has_key (UtilCacheLru* self,
                        const gchar* key)
{
	GeeMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->cache;
	result = gee_map_has_key (_tmp0_, key);
	return result;
}

/**
     * Sets an entry in the cache, replacing any existing entry.
     *
     * The entry is added to the back of the removal queue. If adding
     * the entry causes the size of the cache to exceed the maximum,
     * the entry at the front of the queue will be evicted.
     */
static gpointer
_util_cache_lru_cache_entry_ref0 (gpointer self)
{
	return self ? util_cache_lru_cache_entry_ref (self) : NULL;
}

void
util_cache_lru_set_entry (UtilCacheLru* self,
                          const gchar* key,
                          gconstpointer value)
{
	gint64 now = 0LL;
	UtilCacheLruCacheEntry* entry = NULL;
	UtilCacheLruCacheEntry* _tmp0_;
	GeeMap* _tmp1_;
	UtilCacheLruCacheEntry* _tmp2_;
	GSequence* _tmp3_;
	UtilCacheLruCacheEntry* _tmp4_;
	UtilCacheLruCacheEntry* _tmp5_;
	GSequenceIter* _tmp6_;
	GeeMap* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	guint _tmp10_;
	g_return_if_fail (UTIL_CACHE_IS_LRU (self));
	g_return_if_fail (key != NULL);
	now = g_get_monotonic_time ();
	_tmp0_ = util_cache_lru_cache_entry_new (self->priv->t_type, (GBoxedCopyFunc) self->priv->t_dup_func, (GDestroyNotify) self->priv->t_destroy_func, key, value, now);
	entry = _tmp0_;
	_tmp1_ = self->priv->cache;
	_tmp2_ = entry;
	gee_map_set (_tmp1_, key, _tmp2_);
	_tmp3_ = self->priv->ordering;
	_tmp4_ = entry;
	_tmp5_ = _util_cache_lru_cache_entry_ref0 (_tmp4_);
	_tmp6_ = g_sequence_append (_tmp3_, _tmp5_);
	_tmp7_ = self->priv->cache;
	_tmp8_ = gee_map_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_max_size;
	if (((guint) _tmp9_) > _tmp10_) {
		GSequenceIter* oldest = NULL;
		GSequence* _tmp11_;
		GSequenceIter* _tmp12_;
		GSequenceIter* _tmp13_;
		_tmp11_ = self->priv->ordering;
		_tmp12_ = g_sequence_get_begin_iter (_tmp11_);
		oldest = _tmp12_;
		_tmp13_ = oldest;
		if (_tmp13_ != NULL) {
			GeeMap* _tmp14_;
			GSequenceIter* _tmp15_;
			gconstpointer _tmp16_;
			const gchar* _tmp17_;
			GSequenceIter* _tmp18_;
			_tmp14_ = self->priv->cache;
			_tmp15_ = oldest;
			_tmp16_ = g_sequence_get (_tmp15_);
			_tmp17_ = ((UtilCacheLruCacheEntry*) _tmp16_)->key;
			gee_map_unset (_tmp14_, _tmp17_, NULL);
			_tmp18_ = oldest;
			g_sequence_remove (_tmp18_);
		}
	}
	_util_cache_lru_cache_entry_unref0 (entry);
}

/**
     * Returns the entry from the cache, if found.
     *
     * If the entry was found, it is move to the back of the removal
     * queue.
     */
static gint
_util_cache_lru_cache_entry_lru_compare_gcompare_data_func (gconstpointer a,
                                                            gconstpointer b,
                                                            gpointer self)
{
	gint result;
	result = util_cache_lru_cache_entry_lru_compare ((UtilCacheLruCacheEntry*) a, (UtilCacheLruCacheEntry*) b);
	return result;
}

gpointer
util_cache_lru_get_entry (UtilCacheLru* self,
                          const gchar* key)
{
	gint64 now = 0LL;
	UtilCacheLruCacheEntry* entry = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	gpointer value = NULL;
	UtilCacheLruCacheEntry* _tmp2_;
	gpointer result;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	now = g_get_monotonic_time ();
	_tmp0_ = self->priv->cache;
	_tmp1_ = gee_map_get (_tmp0_, key);
	entry = (UtilCacheLruCacheEntry*) _tmp1_;
	value = NULL;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		UtilCacheLruCacheEntry* _tmp3_;
		gconstpointer _tmp4_;
		gpointer _tmp5_;
		GSequenceIter* to_remove = NULL;
		GSequence* _tmp6_;
		UtilCacheLruCacheEntry* _tmp7_;
		GSequenceIter* _tmp8_;
		GSequenceIter* _tmp9_;
		UtilCacheLruCacheEntry* _tmp11_;
		GSequence* _tmp12_;
		UtilCacheLruCacheEntry* _tmp13_;
		UtilCacheLruCacheEntry* _tmp14_;
		GSequenceIter* _tmp15_;
		_tmp3_ = entry;
		_tmp4_ = _tmp3_->value;
		_tmp5_ = ((_tmp4_ != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
		((value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (value = (self->priv->t_destroy_func (value), NULL));
		value = _tmp5_;
		_tmp6_ = self->priv->ordering;
		_tmp7_ = entry;
		_tmp8_ = g_sequence_lookup (_tmp6_, _tmp7_, _util_cache_lru_cache_entry_lru_compare_gcompare_data_func, NULL);
		to_remove = _tmp8_;
		_tmp9_ = to_remove;
		if (_tmp9_ != NULL) {
			GSequenceIter* _tmp10_;
			_tmp10_ = to_remove;
			g_sequence_remove (_tmp10_);
		}
		_tmp11_ = entry;
		_tmp11_->last_used = now;
		_tmp12_ = self->priv->ordering;
		_tmp13_ = entry;
		_tmp14_ = _util_cache_lru_cache_entry_ref0 (_tmp13_);
		_tmp15_ = g_sequence_append (_tmp12_, _tmp14_);
	}
	result = value;
	_util_cache_lru_cache_entry_unref0 (entry);
	return result;
}

/** Removes an entry from the cache and returns it, if found. */
gpointer
util_cache_lru_remove_entry (UtilCacheLru* self,
                             const gchar* key)
{
	UtilCacheLruCacheEntry* entry = NULL;
	gpointer value = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	UtilCacheLruCacheEntry* _tmp2_;
	gpointer result;
	g_return_val_if_fail (UTIL_CACHE_IS_LRU (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	entry = NULL;
	value = NULL;
	_tmp0_ = self->priv->cache;
	gee_map_unset (_tmp0_, key, &_tmp1_);
	_util_cache_lru_cache_entry_unref0 (entry);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		GSequenceIter* to_remove = NULL;
		GSequence* _tmp3_;
		UtilCacheLruCacheEntry* _tmp4_;
		GSequenceIter* _tmp5_;
		GSequenceIter* _tmp6_;
		UtilCacheLruCacheEntry* _tmp8_;
		gconstpointer _tmp9_;
		gpointer _tmp10_;
		_tmp3_ = self->priv->ordering;
		_tmp4_ = entry;
		_tmp5_ = g_sequence_lookup (_tmp3_, _tmp4_, _util_cache_lru_cache_entry_lru_compare_gcompare_data_func, NULL);
		to_remove = _tmp5_;
		_tmp6_ = to_remove;
		if (_tmp6_ != NULL) {
			GSequenceIter* _tmp7_;
			_tmp7_ = to_remove;
			g_sequence_remove (_tmp7_);
		}
		_tmp8_ = entry;
		_tmp9_ = _tmp8_->value;
		_tmp10_ = ((_tmp9_ != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) _tmp9_) : ((gpointer) _tmp9_);
		((value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (value = (self->priv->t_destroy_func (value), NULL));
		value = _tmp10_;
	}
	result = value;
	_util_cache_lru_cache_entry_unref0 (entry);
	return result;
}

/** Evicts all entries in the cache. */
void
util_cache_lru_clear (UtilCacheLru* self)
{
	GeeMap* _tmp0_;
	GSequenceIter* first = NULL;
	GSequence* _tmp1_;
	GSequenceIter* _tmp2_;
	GSequenceIter* _tmp3_;
	g_return_if_fail (UTIL_CACHE_IS_LRU (self));
	_tmp0_ = self->priv->cache;
	gee_map_clear (_tmp0_);
	_tmp1_ = self->priv->ordering;
	_tmp2_ = g_sequence_get_begin_iter (_tmp1_);
	first = _tmp2_;
	_tmp3_ = first;
	if (_tmp3_ != NULL) {
		GSequenceIter* last = NULL;
		GSequence* _tmp4_;
		GSequenceIter* _tmp5_;
		GSequenceIter* _tmp6_;
		GSequenceIter* _tmp7_;
		_tmp4_ = self->priv->ordering;
		_tmp5_ = g_sequence_get_end_iter (_tmp4_);
		last = _tmp5_;
		_tmp6_ = first;
		_tmp7_ = last;
		g_sequence_remove_range (_tmp6_, _tmp7_);
	}
}

static inline gpointer
util_cache_lru_cache_entry_get_instance_private (UtilCacheLruCacheEntry* self)
{
	return G_STRUCT_MEMBER_P (self, UtilCacheLruCacheEntry_private_offset);
}

static gint
util_cache_lru_cache_entry_lru_compare (UtilCacheLruCacheEntry* a,
                                        UtilCacheLruCacheEntry* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GCompareFunc _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (UTIL_CACHE_LRU_IS_CACHE_ENTRY (a), 0);
	g_return_val_if_fail (UTIL_CACHE_LRU_IS_CACHE_ENTRY (b), 0);
	_tmp0_ = a->key;
	_tmp1_ = b->key;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		result = 0;
		return result;
	}
	if (a->last_used != b->last_used) {
		result = (gint) (a->last_used - b->last_used);
		return result;
	}
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = a->key;
	_tmp4_ = b->key;
	result = _tmp2_ (_tmp3_, _tmp4_);
	return result;
}

static UtilCacheLruCacheEntry*
util_cache_lru_cache_entry_construct (GType object_type,
                                      GType t_type,
                                      GBoxedCopyFunc t_dup_func,
                                      GDestroyNotify t_destroy_func,
                                      const gchar* key,
                                      gconstpointer value,
                                      gint64 last_used)
{
	UtilCacheLruCacheEntry* self = NULL;
	gchar* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	self = (UtilCacheLruCacheEntry*) g_type_create_instance (object_type);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = g_strdup (key);
	_g_free0 (self->key);
	self->key = _tmp0_;
	_tmp1_ = ((value != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) value) : ((gpointer) value);
	((self->value == NULL) || (t_destroy_func == NULL)) ? NULL : (self->value = (t_destroy_func (self->value), NULL));
	self->value = _tmp1_;
	self->last_used = last_used;
	return self;
}

static UtilCacheLruCacheEntry*
util_cache_lru_cache_entry_new (GType t_type,
                                GBoxedCopyFunc t_dup_func,
                                GDestroyNotify t_destroy_func,
                                const gchar* key,
                                gconstpointer value,
                                gint64 last_used)
{
	return util_cache_lru_cache_entry_construct (UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, t_type, t_dup_func, t_destroy_func, key, value, last_used);
}

static void
util_cache_lru_value_cache_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
util_cache_lru_value_cache_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		util_cache_lru_cache_entry_unref (value->data[0].v_pointer);
	}
}

static void
util_cache_lru_value_cache_entry_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = util_cache_lru_cache_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
util_cache_lru_value_cache_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
util_cache_lru_value_cache_entry_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UtilCacheLruCacheEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = util_cache_lru_cache_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
util_cache_lru_value_cache_entry_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	UtilCacheLruCacheEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = util_cache_lru_cache_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
util_cache_lru_param_spec_cache_entry (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	UtilCacheLruParamSpecCacheEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
util_cache_lru_value_get_cache_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
util_cache_lru_value_set_cache_entry (GValue* value,
                                      gpointer v_object)
{
	UtilCacheLruCacheEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		util_cache_lru_cache_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_cache_lru_cache_entry_unref (old);
	}
}

static void
util_cache_lru_value_take_cache_entry (GValue* value,
                                       gpointer v_object)
{
	UtilCacheLruCacheEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_cache_lru_cache_entry_unref (old);
	}
}

static void
util_cache_lru_cache_entry_class_init (UtilCacheLruCacheEntryClass * klass,
                                       gpointer klass_data)
{
	util_cache_lru_cache_entry_parent_class = g_type_class_peek_parent (klass);
	((UtilCacheLruCacheEntryClass *) klass)->finalize = util_cache_lru_cache_entry_finalize;
	g_type_class_adjust_private_offset (klass, &UtilCacheLruCacheEntry_private_offset);
}

static void
util_cache_lru_cache_entry_instance_init (UtilCacheLruCacheEntry * self,
                                          gpointer klass)
{
	self->priv = util_cache_lru_cache_entry_get_instance_private (self);
	self->ref_count = 1;
}

static void
util_cache_lru_cache_entry_finalize (UtilCacheLruCacheEntry * obj)
{
	UtilCacheLruCacheEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, UtilCacheLruCacheEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->key);
	((self->value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->value = (self->priv->t_destroy_func (self->value), NULL));
}

static GType
util_cache_lru_cache_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { util_cache_lru_value_cache_entry_init, util_cache_lru_value_cache_entry_free_value, util_cache_lru_value_cache_entry_copy_value, util_cache_lru_value_cache_entry_peek_pointer, "p", util_cache_lru_value_cache_entry_collect_value, "p", util_cache_lru_value_cache_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilCacheLruCacheEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_cache_lru_cache_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilCacheLruCacheEntry), 0, (GInstanceInitFunc) util_cache_lru_cache_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType util_cache_lru_cache_entry_type_id;
	util_cache_lru_cache_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UtilCacheLruCacheEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UtilCacheLruCacheEntry_private_offset = g_type_add_instance_private (util_cache_lru_cache_entry_type_id, sizeof (UtilCacheLruCacheEntryPrivate));
	return util_cache_lru_cache_entry_type_id;
}

static GType
util_cache_lru_cache_entry_get_type (void)
{
	static volatile gsize util_cache_lru_cache_entry_type_id__once = 0;
	if (g_once_init_enter (&util_cache_lru_cache_entry_type_id__once)) {
		GType util_cache_lru_cache_entry_type_id;
		util_cache_lru_cache_entry_type_id = util_cache_lru_cache_entry_get_type_once ();
		g_once_init_leave (&util_cache_lru_cache_entry_type_id__once, util_cache_lru_cache_entry_type_id);
	}
	return util_cache_lru_cache_entry_type_id__once;
}

static gpointer
util_cache_lru_cache_entry_ref (gpointer instance)
{
	UtilCacheLruCacheEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
util_cache_lru_cache_entry_unref (gpointer instance)
{
	UtilCacheLruCacheEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTIL_CACHE_LRU_CACHE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
util_cache_lru_class_init (UtilCacheLruClass * klass,
                           gpointer klass_data)
{
	util_cache_lru_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UtilCacheLru_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_util_cache_lru_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_util_cache_lru_set_property;
	G_OBJECT_CLASS (klass)->finalize = util_cache_lru_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/** Specifies the maximum number of cache entries to be stored. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_MAX_SIZE_PROPERTY, util_cache_lru_properties[UTIL_CACHE_LRU_MAX_SIZE_PROPERTY] = g_param_spec_uint ("max-size", "max-size", "max-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if the cache has any entries or not. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_IS_EMPTY_PROPERTY, util_cache_lru_properties[UTIL_CACHE_LRU_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines the current number of cache entries. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_CACHE_LRU_SIZE_PROPERTY, util_cache_lru_properties[UTIL_CACHE_LRU_SIZE_PROPERTY] = g_param_spec_uint ("size", "size", "size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
util_cache_lru_instance_init (UtilCacheLru * self,
                              gpointer klass)
{
	GeeHashMap* _tmp0_;
	GSequence* _tmp1_;
	self->priv = util_cache_lru_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, UTIL_CACHE_LRU_TYPE_CACHE_ENTRY, (GBoxedCopyFunc) util_cache_lru_cache_entry_ref, (GDestroyNotify) util_cache_lru_cache_entry_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cache = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = g_sequence_new (_util_cache_lru_cache_entry_unref0_);
	self->priv->ordering = _tmp1_;
}

static void
util_cache_lru_finalize (GObject * obj)
{
	UtilCacheLru * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_CACHE_TYPE_LRU, UtilCacheLru);
	_g_object_unref0 (self->priv->cache);
	_g_sequence_free0 (self->priv->ordering);
	G_OBJECT_CLASS (util_cache_lru_parent_class)->finalize (obj);
}

/** A simple least-recently-used cache. */
static GType
util_cache_lru_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UtilCacheLruClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_cache_lru_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilCacheLru), 0, (GInstanceInitFunc) util_cache_lru_instance_init, NULL };
	GType util_cache_lru_type_id;
	util_cache_lru_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "UtilCacheLru", &g_define_type_info, 0);
	UtilCacheLru_private_offset = g_type_add_instance_private (util_cache_lru_type_id, sizeof (UtilCacheLruPrivate));
	return util_cache_lru_type_id;
}

GType
util_cache_lru_get_type (void)
{
	static volatile gsize util_cache_lru_type_id__once = 0;
	if (g_once_init_enter (&util_cache_lru_type_id__once)) {
		GType util_cache_lru_type_id;
		util_cache_lru_type_id = util_cache_lru_get_type_once ();
		g_once_init_leave (&util_cache_lru_type_id__once, util_cache_lru_type_id);
	}
	return util_cache_lru_type_id__once;
}

static void
_vala_util_cache_lru_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	UtilCacheLru * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_CACHE_TYPE_LRU, UtilCacheLru);
	switch (property_id) {
		case UTIL_CACHE_LRU_MAX_SIZE_PROPERTY:
		g_value_set_uint (value, util_cache_lru_get_max_size (self));
		break;
		case UTIL_CACHE_LRU_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, util_cache_lru_get_is_empty (self));
		break;
		case UTIL_CACHE_LRU_SIZE_PROPERTY:
		g_value_set_uint (value, util_cache_lru_get_size (self));
		break;
		case UTIL_CACHE_LRU_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case UTIL_CACHE_LRU_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case UTIL_CACHE_LRU_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_util_cache_lru_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	UtilCacheLru * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_CACHE_TYPE_LRU, UtilCacheLru);
	switch (property_id) {
		case UTIL_CACHE_LRU_MAX_SIZE_PROPERTY:
		util_cache_lru_set_max_size (self, g_value_get_uint (value));
		break;
		case UTIL_CACHE_LRU_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case UTIL_CACHE_LRU_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case UTIL_CACHE_LRU_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

