/* db-result.c generated by valac 0.56.3, the Vala compiler
 * generated from db-result.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>
#include <stdarg.h>

enum  {
	GEARY_DB_RESULT_0_PROPERTY,
	GEARY_DB_RESULT_FINISHED_PROPERTY,
	GEARY_DB_RESULT_STATEMENT_PROPERTY,
	GEARY_DB_RESULT_ROW_PROPERTY,
	GEARY_DB_RESULT_LOGGING_PARENT_PROPERTY,
	GEARY_DB_RESULT_NUM_PROPERTIES
};
static GParamSpec* geary_db_result_properties[GEARY_DB_RESULT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyDbResultPrivate {
	gboolean _finished;
	GearyDbStatement* _statement;
	guint64 _row;
};

static gint GearyDbResult_private_offset;
static gpointer geary_db_result_parent_class = NULL;

VALA_EXTERN GearyDbResult* geary_db_context_get_result (GearyDbContext* self);
static void geary_db_result_on_query_finished (GearyDbResult* self);
static void _geary_db_result_on_query_finished_geary_db_statement_was_reset (GearyDbStatement* _sender,
                                                                      gpointer self);
static void _geary_db_result_on_query_finished_geary_db_statement_bindings_cleared (GearyDbStatement* _sender,
                                                                             gpointer self);
static void geary_db_result_set_finished (GearyDbResult* self,
                                   gboolean value);
static void geary_db_result_set_statement (GearyDbResult* self,
                                    GearyDbStatement* value);
static void geary_db_result_set_row (GearyDbResult* self,
                              guint64 value);
VALA_EXTERN GearyDbResult* geary_db_result_new (GearyDbStatement* statement,
                                    GCancellable* cancellable,
                                    GError** error);
VALA_EXTERN GearyDbResult* geary_db_result_construct (GType object_type,
                                          GearyDbStatement* statement,
                                          GCancellable* cancellable,
                                          GError** error);
VALA_EXTERN void geary_db_check_cancelled (const gchar* method,
                               GCancellable* cancellable,
                               GError** error);
static inline void geary_db_result_log_result (GearyDbResult* self,
                                 const gchar* fmt,
                                 ...)  G_GNUC_PRINTF(2,3) ;
static void geary_db_result_verify_at (GearyDbResult* self,
                                gint column,
                                GError** error);
static gint geary_db_result_convert_for (GearyDbResult* self,
                                  const gchar* name,
                                  GError** error);
static GearyLoggingState* geary_db_result_real_to_logging_state (GearyDbContext* base);
static GearyDbResult* geary_db_result_real_get_result (GearyDbContext* base);
static void geary_db_result_finalize (GObject * obj);
static GType geary_db_result_get_type_once (void);
static void _vala_geary_db_result_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_geary_db_result_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
geary_db_result_get_instance_private (GearyDbResult* self)
{
	return G_STRUCT_MEMBER_P (self, GearyDbResult_private_offset);
}

static void
_geary_db_result_on_query_finished_geary_db_statement_was_reset (GearyDbStatement* _sender,
                                                                 gpointer self)
{
	geary_db_result_on_query_finished ((GearyDbResult*) self);
}

static void
_geary_db_result_on_query_finished_geary_db_statement_bindings_cleared (GearyDbStatement* _sender,
                                                                        gpointer self)
{
	geary_db_result_on_query_finished ((GearyDbResult*) self);
}

gboolean
geary_db_result_get_finished (GearyDbResult* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	result = self->priv->_finished;
	return result;
}

static void
geary_db_result_set_finished (GearyDbResult* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	old_value = geary_db_result_get_finished (self);
	if (old_value != value) {
		self->priv->_finished = value;
		g_object_notify_by_pspec ((GObject *) self, geary_db_result_properties[GEARY_DB_RESULT_FINISHED_PROPERTY]);
	}
}

GearyDbStatement*
geary_db_result_get_statement (GearyDbResult* self)
{
	GearyDbStatement* result;
	GearyDbStatement* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	_tmp0_ = self->priv->_statement;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_db_result_set_statement (GearyDbResult* self,
                               GearyDbStatement* value)
{
	GearyDbStatement* old_value;
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	old_value = geary_db_result_get_statement (self);
	if (old_value != value) {
		GearyDbStatement* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_statement);
		self->priv->_statement = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_db_result_properties[GEARY_DB_RESULT_STATEMENT_PROPERTY]);
	}
}

guint64
geary_db_result_get_row (GearyDbResult* self)
{
	guint64 result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0ULL);
	result = self->priv->_row;
	return result;
}

static void
geary_db_result_set_row (GearyDbResult* self,
                         guint64 value)
{
	guint64 old_value;
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	old_value = geary_db_result_get_row (self);
	if (old_value != value) {
		self->priv->_row = value;
		g_object_notify_by_pspec ((GObject *) self, geary_db_result_properties[GEARY_DB_RESULT_ROW_PROPERTY]);
	}
}

static GearyLoggingSource*
geary_db_result_real_get_logging_parent (GearyDbContext* base)
{
	GearyLoggingSource* result;
	GearyDbResult* self;
	GearyDbStatement* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_RESULT, GearyDbResult);
	_tmp0_ = self->priv->_statement;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource);
	return result;
}

GearyDbResult*
geary_db_result_construct (GType object_type,
                           GearyDbStatement* statement,
                           GCancellable* cancellable,
                           GError** error)
{
	GearyDbResult * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (statement), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyDbResult*) geary_db_context_construct (object_type);
	geary_db_result_set_statement (self, statement);
	g_signal_connect_object (statement, "was-reset", (GCallback) _geary_db_result_on_query_finished_geary_db_statement_was_reset, self, 0);
	g_signal_connect_object (statement, "bindings-cleared", (GCallback) _geary_db_result_on_query_finished_geary_db_statement_bindings_cleared, self, 0);
	geary_db_result_next (self, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GearyDbResult*
geary_db_result_new (GearyDbStatement* statement,
                     GCancellable* cancellable,
                     GError** error)
{
	return geary_db_result_construct (GEARY_DB_TYPE_RESULT, statement, cancellable, error);
}

static void
geary_db_result_on_query_finished (GearyDbResult* self)
{
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	geary_db_result_set_finished (self, TRUE);
}

/**
     * Returns true if results are waiting, false if finished, or throws a DatabaseError.
     */
gboolean
geary_db_result_next (GearyDbResult* self,
                      GCancellable* cancellable,
                      GError** error)
{
	gboolean _tmp1_;
	gboolean _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), FALSE);
	geary_db_check_cancelled ("Result.next", cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	_tmp1_ = self->priv->_finished;
	if (!_tmp1_) {
		guint64 _tmp2_;
		GTimer* timer = NULL;
		GTimer* _tmp3_;
		gint _tmp4_ = 0;
		GearyDbStatement* _tmp5_;
		sqlite3_stmt* _tmp6_;
		GearyDbStatement* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GTimer* _tmp11_;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_;
		_tmp2_ = self->priv->_row;
		geary_db_result_set_row (self, _tmp2_ + 1);
		_tmp3_ = g_timer_new ();
		timer = _tmp3_;
		_tmp5_ = self->priv->_statement;
		_tmp6_ = _tmp5_->stmt;
		_tmp7_ = self->priv->_statement;
		_tmp8_ = geary_db_statement_get_sql (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Result.next", sqlite3_step (_tmp6_), _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_timer_destroy0 (timer);
			return _tmp10_;
		}
		geary_db_result_set_finished (self, _tmp4_ != SQLITE_ROW);
		_tmp11_ = timer;
		geary_db_context_check_elapsed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Result.next", _tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_timer_destroy0 (timer);
			return _tmp12_;
		}
		_tmp14_ = self->priv->_finished;
		if (_tmp14_) {
			_tmp13_ = "NO ROW";
		} else {
			_tmp13_ = "ROW";
		}
		geary_db_result_log_result (self, "%s", _tmp13_);
		_g_timer_destroy0 (timer);
	}
	_tmp15_ = self->priv->_finished;
	result = !_tmp15_;
	return result;
}

/**
     * column is zero-based.
     */
static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

gboolean
geary_db_result_is_null_at (GearyDbResult* self,
                            gint column,
                            GError** error)
{
	gboolean is_null = FALSE;
	GearyDbStatement* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	geary_db_result_verify_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp0_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gboolean _tmp1_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = self->priv->_statement;
	_tmp3_ = _tmp2_->stmt;
	is_null = sqlite3_column_type (_tmp3_, column) == SQLITE_NULL;
	_tmp4_ = bool_to_string (is_null);
	_tmp5_ = _tmp4_;
	geary_db_result_log_result (self, "is_null_at(%d) -> %s", column, _tmp5_);
	_g_free0 (_tmp5_);
	result = is_null;
	return result;
}

/**
     * column is zero-based.
     */
gdouble
geary_db_result_double_at (GearyDbResult* self,
                           gint column,
                           GError** error)
{
	gdouble d = 0.0;
	GearyDbStatement* _tmp2_;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0.0);
	geary_db_result_verify_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gdouble _tmp0_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gdouble _tmp1_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = self->priv->_statement;
	_tmp3_ = _tmp2_->stmt;
	d = sqlite3_column_double (_tmp3_, column);
	geary_db_result_log_result (self, "double_at(%d) -> %lf", column, d);
	result = d;
	return result;
}

/**
     * column is zero-based.
     */
gint
geary_db_result_int_at (GearyDbResult* self,
                        gint column,
                        GError** error)
{
	gint i = 0;
	GearyDbStatement* _tmp2_;
	sqlite3_stmt* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0);
	geary_db_result_verify_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp0_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gint _tmp1_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = self->priv->_statement;
	_tmp3_ = _tmp2_->stmt;
	i = sqlite3_column_int (_tmp3_, column);
	geary_db_result_log_result (self, "int_at(%d) -> %d", column, i);
	result = i;
	return result;
}

/**
     * column is zero-based.
     */
guint
geary_db_result_uint_at (GearyDbResult* self,
                         gint column,
                         GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	guint result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0U);
	_tmp0_ = geary_db_result_int64_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			guint _tmp1_ = 0U;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			guint _tmp2_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = (guint) _tmp0_;
	return result;
}

/**
     * column is zero-based.
     */
glong
geary_db_result_long_at (GearyDbResult* self,
                         gint column,
                         GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	glong result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0L);
	_tmp0_ = geary_db_result_int64_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			glong _tmp1_ = -1L;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			glong _tmp2_ = -1L;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = (glong) _tmp0_;
	return result;
}

/**
     * column is zero-based.
     */
gint64
geary_db_result_int64_at (GearyDbResult* self,
                          gint column,
                          GError** error)
{
	gint64 i64 = 0LL;
	GearyDbStatement* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0LL);
	geary_db_result_verify_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint64 _tmp0_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gint64 _tmp1_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = self->priv->_statement;
	_tmp3_ = _tmp2_->stmt;
	i64 = sqlite3_column_int64 (_tmp3_, column);
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, i64);
	_tmp5_ = _tmp4_;
	geary_db_result_log_result (self, "int64_at(%d) -> %s", column, _tmp5_);
	_g_free0 (_tmp5_);
	result = i64;
	return result;
}

/**
     * Returns the column value as a bool.  The value is treated as an int and converted into a
     * bool: false == 0, true == !0.
     *
     * column is zero-based.
     */
gboolean
geary_db_result_bool_at (GearyDbResult* self,
                         gint column,
                         GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	_tmp0_ = geary_db_result_int_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = _tmp0_ != 0;
	return result;
}

/**
     * column is zero-based.
     *
     * This is merely a front for int64_at().  It's provided to make the caller's code more verbose.
     */
gint64
geary_db_result_rowid_at (GearyDbResult* self,
                          gint column,
                          GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0LL);
	_tmp0_ = geary_db_result_int64_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint64 _tmp1_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint64 _tmp2_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = _tmp0_;
	return result;
}

/**
     * column is zero-based.
     *
     * Returns a null string if the element is NULL.
     *
     * @see nonnull_string_at
     */
const gchar*
geary_db_result_string_at (GearyDbResult* self,
                           gint column,
                           GError** error)
{
	const gchar* s = NULL;
	GearyDbStatement* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	geary_db_result_verify_at (self, column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = self->priv->_statement;
	_tmp1_ = _tmp0_->stmt;
	_tmp2_ = (const gchar*) sqlite3_column_text (_tmp1_, column);
	s = _tmp2_;
	_tmp4_ = s;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = s;
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = "(null)";
	}
	geary_db_result_log_result (self, "string_at(%d) -> %s", column, _tmp3_);
	_tmp6_ = s;
	result = _tmp6_;
	return result;
}

/**
     * column is zero-based.
     *
     * Returns an empty string if the element is NULL.
     *
     * @see string_at
     */
const gchar*
geary_db_result_nonnull_string_at (GearyDbResult* self,
                                   gint column,
                                   GError** error)
{
	const gchar* s = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	_tmp0_ = geary_db_result_string_at (self, column, &_inner_error0_);
	s = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (s != NULL) {
		_tmp1_ = s;
	} else {
		_tmp1_ = "";
	}
	result = _tmp1_;
	return result;
}

/**
     * column is zero-based.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

GearyMemoryBuffer*
geary_db_result_string_buffer_at (GearyDbResult* self,
                                  gint column,
                                  GError** error)
{
	GearyMemoryGrowableBuffer* buffer = NULL;
	GearyMemoryGrowableBuffer* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	_tmp0_ = geary_memory_growable_buffer_new ();
	buffer = _tmp0_;
	_tmp2_ = geary_db_result_nonnull_string_at (self, column, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (buffer);
			return NULL;
		} else {
			_g_object_unref0 (buffer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = string_get_data (_tmp1_, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	geary_memory_growable_buffer_append (buffer, _tmp5_, (gint) _tmp5__length1);
	result = G_TYPE_CHECK_INSTANCE_CAST (buffer, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
	return result;
}

static void
geary_db_result_verify_at (GearyDbResult* self,
                           gint column,
                           GError** error)
{
	gboolean _tmp0_;
	gint count = 0;
	GearyDbStatement* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	_tmp0_ = self->priv->_finished;
	if (_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_FINISHED, "Query finished");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (column < 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_LIMITS, "column %d < 0", column);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = self->priv->_statement;
	count = geary_db_statement_get_column_count (_tmp3_);
	if (column >= count) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_LIMITS, "column %d >= %d", column, count);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
gboolean
geary_db_result_is_null_for (GearyDbResult* self,
                             const gchar* name,
                             GError** error)
{
	gint _tmp0_ = 0;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_is_null_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
gdouble
geary_db_result_double_for (GearyDbResult* self,
                            const gchar* name,
                            GError** error)
{
	gint _tmp0_ = 0;
	gdouble _tmp3_ = 0.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gdouble _tmp1_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gdouble _tmp2_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_double_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gdouble _tmp4_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gdouble _tmp5_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
gint
geary_db_result_int_for (GearyDbResult* self,
                         const gchar* name,
                         GError** error)
{
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp1_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint _tmp2_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_int_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp4_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gint _tmp5_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
guint
geary_db_result_uint_for (GearyDbResult* self,
                          const gchar* name,
                          GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	guint result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0U);
	g_return_val_if_fail (name != NULL, 0U);
	_tmp0_ = geary_db_result_int64_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			guint _tmp1_ = 0U;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			guint _tmp2_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = (guint) _tmp0_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
glong
geary_db_result_long_for (GearyDbResult* self,
                          const gchar* name,
                          GError** error)
{
	gint _tmp0_ = 0;
	glong _tmp3_ = 0L;
	GError* _inner_error0_ = NULL;
	glong result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0L);
	g_return_val_if_fail (name != NULL, 0L);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			glong _tmp1_ = -1L;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			glong _tmp2_ = -1L;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_long_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			glong _tmp4_ = -1L;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			glong _tmp5_ = -1L;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
gint64
geary_db_result_int64_for (GearyDbResult* self,
                           const gchar* name,
                           GError** error)
{
	gint _tmp0_ = 0;
	gint64 _tmp3_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0LL);
	g_return_val_if_fail (name != NULL, 0LL);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint64 _tmp1_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint64 _tmp2_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_int64_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint64 _tmp4_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gint64 _tmp5_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     *
     * See bool_at() for information on how the column's value is converted to a bool.
     */
gboolean
geary_db_result_bool_for (GearyDbResult* self,
                          const gchar* name,
                          GError** error)
{
	gint _tmp0_ = 0;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = geary_db_result_bool_at (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = _tmp3_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     *
     * This is merely a front for int64_at().  It's provided to make the caller's code more verbose.
     */
gint64
geary_db_result_rowid_for (GearyDbResult* self,
                           const gchar* name,
                           GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0LL);
	g_return_val_if_fail (name != NULL, 0LL);
	_tmp0_ = geary_db_result_int64_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint64 _tmp1_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint64 _tmp2_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = _tmp0_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     *
     * Returns a null string if the element is NULL.
     *
     * @see nonnull_string_for
     */
const gchar*
geary_db_result_string_for (GearyDbResult* self,
                            const gchar* name,
                            GError** error)
{
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_db_result_string_at (self, _tmp0_, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     *
     * Returns an empty string if the element is NULL.
     *
     * @see string_for
     */
const gchar*
geary_db_result_nonnull_string_for (GearyDbResult* self,
                                    const gchar* name,
                                    GError** error)
{
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_db_result_nonnull_string_at (self, _tmp0_, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}

/**
     * name is the name of the column in the result set.  See Statement.get_column_index() for name
     * matching rules.
     */
GearyMemoryBuffer*
geary_db_result_string_buffer_for (GearyDbResult* self,
                                   const gchar* name,
                                   GError** error)
{
	gint _tmp0_ = 0;
	GearyMemoryBuffer* _tmp1_ = NULL;
	GearyMemoryBuffer* _tmp2_;
	GearyMemoryBuffer* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = geary_db_result_convert_for (self, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_db_result_string_buffer_at (self, _tmp0_, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp1_);
	return result;
}

static gint
geary_db_result_convert_for (GearyDbResult* self,
                             const gchar* name,
                             GError** error)
{
	gboolean _tmp0_;
	gint column = 0;
	GearyDbStatement* _tmp4_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (self), 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->_finished;
	if (_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_FINISHED, "Query finished");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp2_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp2_;
		} else {
			gint _tmp3_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->_statement;
	column = geary_db_statement_get_column_index (_tmp4_, name);
	if (column < 0) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_LIMITS, "column \"%s\" not in result set", name);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp6_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp6_;
		} else {
			gint _tmp7_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	result = column;
	return result;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_db_result_real_to_logging_state (GearyDbContext* base)
{
	GearyDbResult * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	guint64 _tmp2_;
	GearyLoggingState* _tmp3_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_RESULT, GearyDbResult);
	_tmp1_ = self->priv->_finished;
	if (_tmp1_) {
		_tmp0_ = "finished";
	} else {
		_tmp0_ = "!finished";
	}
	_tmp2_ = self->priv->_row;
	_tmp3_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%llu, %s", _tmp2_, _tmp0_);
	result = _tmp3_;
	return result;
}

static GearyDbResult*
geary_db_result_real_get_result (GearyDbContext* base)
{
	GearyDbResult * self;
	GearyDbResult* _tmp0_;
	GearyDbResult* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_RESULT, GearyDbResult);
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

static inline void
geary_db_result_log_result (GearyDbResult* self,
                            const gchar* fmt,
                            ...)
{
	g_return_if_fail (GEARY_DB_IS_RESULT (self));
	g_return_if_fail (fmt != NULL);
	if (geary_db_context_enable_result_logging) {
		va_list _tmp0_ = {0};
		gchar* _tmp1_;
		gchar* _tmp2_;
		va_start (_tmp0_, fmt);
		_tmp1_ = g_strdup_vprintf (fmt, _tmp0_);
		_tmp2_ = _tmp1_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp2_);
		_g_free0 (_tmp2_);
		va_end (_tmp0_);
	}
}

static void
geary_db_result_class_init (GearyDbResultClass * klass,
                            gpointer klass_data)
{
	geary_db_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyDbResult_private_offset);
	((GearyDbContextClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyDbContext*)) geary_db_result_real_to_logging_state;
	((GearyDbContextClass *) klass)->get_result = (GearyDbResult* (*) (GearyDbContext*)) geary_db_result_real_get_result;
	GEARY_DB_CONTEXT_CLASS (klass)->get_logging_parent = geary_db_result_real_get_logging_parent;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_db_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_db_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_db_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_RESULT_FINISHED_PROPERTY, geary_db_result_properties[GEARY_DB_RESULT_FINISHED_PROPERTY] = g_param_spec_boolean ("finished", "finished", "finished", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The statement this result was generated from. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_RESULT_STATEMENT_PROPERTY, geary_db_result_properties[GEARY_DB_RESULT_STATEMENT_PROPERTY] = g_param_spec_object ("statement", "statement", "statement", GEARY_DB_TYPE_STATEMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The current row represented by this result. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_RESULT_ROW_PROPERTY, geary_db_result_properties[GEARY_DB_RESULT_ROW_PROPERTY] = g_param_spec_uint64 ("row", "row", "row", 0, G_MAXUINT64, (guint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_RESULT_LOGGING_PARENT_PROPERTY, geary_db_result_properties[GEARY_DB_RESULT_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_db_result_instance_init (GearyDbResult * self,
                               gpointer klass)
{
	self->priv = geary_db_result_get_instance_private (self);
	self->priv->_finished = FALSE;
	self->priv->_row = (guint64) 0;
}

static void
geary_db_result_finalize (GObject * obj)
{
	GearyDbResult * self;
	GearyDbStatement* _tmp0_;
	guint _tmp1_;
	GearyDbStatement* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_DB_TYPE_RESULT, GearyDbResult);
	_tmp0_ = self->priv->_statement;
	g_signal_parse_name ("was-reset", GEARY_DB_TYPE_STATEMENT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _geary_db_result_on_query_finished_geary_db_statement_was_reset, self);
	_tmp2_ = self->priv->_statement;
	g_signal_parse_name ("bindings-cleared", GEARY_DB_TYPE_STATEMENT, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _geary_db_result_on_query_finished_geary_db_statement_bindings_cleared, self);
	_g_object_unref0 (self->priv->_statement);
	G_OBJECT_CLASS (geary_db_result_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_db_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyDbResult), 0, (GInstanceInitFunc) geary_db_result_instance_init, NULL };
	GType geary_db_result_type_id;
	geary_db_result_type_id = g_type_register_static (GEARY_DB_TYPE_CONTEXT, "GearyDbResult", &g_define_type_info, 0);
	GearyDbResult_private_offset = g_type_add_instance_private (geary_db_result_type_id, sizeof (GearyDbResultPrivate));
	return geary_db_result_type_id;
}

GType
geary_db_result_get_type (void)
{
	static gsize geary_db_result_type_id__once = 0;
	if (g_once_init_enter (&geary_db_result_type_id__once)) {
		GType geary_db_result_type_id;
		geary_db_result_type_id = geary_db_result_get_type_once ();
		g_once_init_leave (&geary_db_result_type_id__once, geary_db_result_type_id);
	}
	return geary_db_result_type_id__once;
}

static void
_vala_geary_db_result_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GearyDbResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_RESULT, GearyDbResult);
	switch (property_id) {
		case GEARY_DB_RESULT_FINISHED_PROPERTY:
		g_value_set_boolean (value, geary_db_result_get_finished (self));
		break;
		case GEARY_DB_RESULT_STATEMENT_PROPERTY:
		g_value_set_object (value, geary_db_result_get_statement (self));
		break;
		case GEARY_DB_RESULT_ROW_PROPERTY:
		g_value_set_uint64 (value, geary_db_result_get_row (self));
		break;
		case GEARY_DB_RESULT_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_db_context_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_db_result_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GearyDbResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_RESULT, GearyDbResult);
	switch (property_id) {
		case GEARY_DB_RESULT_FINISHED_PROPERTY:
		geary_db_result_set_finished (self, g_value_get_boolean (value));
		break;
		case GEARY_DB_RESULT_STATEMENT_PROPERTY:
		geary_db_result_set_statement (self, g_value_get_object (value));
		break;
		case GEARY_DB_RESULT_ROW_PROPERTY:
		geary_db_result_set_row (self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

