/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.util.BinaryDocument;
import javajs.util.Lst;
import javajs.util.Rdr;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;
import jspecview.source.JDXReader;
import jspecview.source.JDXSource;

public class BrukerReader {
    private static final int TYPE_INT = 0;
    boolean allowPhasing = false;

    public JDXSource readBrukerZip(byte[] byArray, String string) throws FileNotFoundException, Exception {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(byArray == null ? new FileInputStream(string) : new ByteArrayInputStream(byArray));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            byte[] byArray2 = new byte[]{};
            byte[] byArray3 = new byte[]{};
            byte[] byArray4 = new byte[]{};
            String string2 = null;
            String string3 = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                System.out.println(string4);
                int n = string4.lastIndexOf(47);
                String string5 = string4.substring(n + 1);
                if (string2 == null && (n = (string2 = string4.substring(0, n + 1)).indexOf("/pdata/")) >= 0) {
                    string2 = string2.substring(0, n + 1);
                }
                if (!string4.startsWith(string2)) break;
                boolean bl = false;
                if (string5.equals("title")) {
                    string3 = new String(this.getBytes(zipInputStream, (int)zipEntry.getSize(), false));
                    hashtable.put("##title", string3);
                    continue;
                }
                if (string5.equals("1r")) {
                    byArray2 = this.getBytes(zipInputStream, (int)zipEntry.getSize(), false);
                    continue;
                }
                if (string5.equals("1i")) {
                    if (!this.allowPhasing) continue;
                    byArray3 = this.getBytes(zipInputStream, (int)zipEntry.getSize(), false);
                    continue;
                }
                if (string5.equals("2rr")) {
                    byArray4 = this.getBytes(zipInputStream, (int)zipEntry.getSize(), false);
                    continue;
                }
                if (string5.equals("proc2s") || string5.equals("acqu2s")) {
                    JDXReader.getHeaderMapS(new ByteArrayInputStream(this.getBytes(zipInputStream, (int)zipEntry.getSize(), false)), hashtable, "_2");
                    continue;
                }
                if (!string5.equals("procs") && !(bl = string5.equals("acqus"))) continue;
                if (bl) {
                    string2 = string4.substring(0, n + 1);
                }
                JDXReader.getHeaderMap(new ByteArrayInputStream(this.getBytes(zipInputStream, (int)zipEntry.getSize(), false)), hashtable);
            }
            zipInputStream.close();
            hashtable.put("##TITLE", string3 == null ? "" : string3);
            return this.getSource(string, hashtable, byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JDXSource readBrukerDir(String string) throws FileNotFoundException, Exception {
        File file;
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            file2 = file2.getParentFile();
        }
        if (!(file = new File(file2, "procs")).exists()) {
            file = new File(file2, "pdata/1/procs");
        }
        File file3 = file.getParentFile();
        File file4 = file3.getParentFile().getParentFile();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.mapParameters(file4, "acqus", hashtable, null);
        this.mapParameters(file4, "acqu2s", hashtable, "_2");
        this.mapParameters(file3, "procs", hashtable, null);
        this.mapParameters(file3, "proc2s", hashtable, "_2");
        hashtable.put("##TITLE", new String(this.getFileContentsAsBytes(new File(file3, "title"))));
        byte[] byArray = this.getFileContentsAsBytes(new File(file.getParent(), "1r"));
        byte[] byArray2 = this.allowPhasing ? this.getFileContentsAsBytes(new File(file.getParent(), "1i")) : new byte[]{};
        byte[] byArray3 = this.getFileContentsAsBytes(new File(file.getParent(), "2rr"));
        return this.getSource(file4.toString(), hashtable, byArray, byArray2, byArray3);
    }

    private void mapParameters(File file, String string, Map<String, String> map, String string2) throws Exception {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file2);
        JDXReader.getHeaderMapS(fileInputStream, map, string2);
        ((InputStream)fileInputStream).close();
    }

    private JDXSource getSource(String string, Map<String, String> map, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        int n;
        int n2 = Integer.parseInt(map.get("##$DTYPP"));
        int n3 = n = n2 == 0 ? Integer.parseInt(map.get("##$BYTORDP")) : Integer.MAX_VALUE;
        if (n2 == Integer.MIN_VALUE || n == Integer.MIN_VALUE) {
            return null;
        }
        JDXSource jDXSource = null;
        if (byArray.length > 0) {
            jDXSource = new JDXSource(byArray2.length == 0 ? 0 : 2, string);
            this.setSource(this.getData(byArray, n2, n), this.getData(byArray2, n2, n), map, jDXSource, false);
        } else if (byArray3.length > 0) {
            jDXSource = new JDXSource(2, string);
            this.setSource(this.getData(byArray3, n2, n), null, map, jDXSource, true);
        }
        return jDXSource;
    }

    private void setSource(double[] dArray, double[] dArray2, Map<String, String> map, JDXSource jDXSource, boolean bl) {
        Lst<String[]> lst = new Lst<String[]>();
        Spectrum spectrum = new Spectrum();
        spectrum.setTitle(map.get("##TITLE"));
        spectrum.setJcampdx(bl ? "6.0" : "5.1");
        spectrum.setDataClass("XYDATA");
        spectrum.setDataType(bl ? "nD NMR SPECTRUM" : "NMR SPECTRUM");
        spectrum.setContinuous(true);
        spectrum.setIncreasing(false);
        spectrum.setLongDate(map.get("##$DATE"));
        spectrum.setOrigin("Bruker BioSpin GmbH/JSpecView");
        spectrum.setOwner(map.get("##OWNER"));
        double d = BrukerReader.parseDouble(map.get("##$SFO1"));
        double d2 = BrukerReader.parseDouble(map.get("##$ABSF1"));
        if (d2 == 0.0) {
            d2 = BrukerReader.parseDouble(map.get("##$OFFSET"));
        }
        String string = this.cleanJDXValue(map.get("##$NUC1"));
        String string2 = this.cleanJDXValue(map.get("##$NUC2"));
        if (string2.length() == 0) {
            string2 = string;
        }
        double d3 = BrukerReader.parseDouble(map.get("##$SWP"));
        double d4 = d3 / d;
        double d5 = d2 - d4;
        String string3 = this.cleanJDXValue(map.get("##$SOLVENT"));
        String string4 = "INTERNAL";
        JDXReader.addHeader(lst, "##.SHIFTREFERENCE", String.valueOf(string4) + ", " + string3 + ", 1, " + d2);
        JDXReader.addHeader(lst, "##.OBSERVEFREQUENCY", "" + d);
        JDXReader.addHeader(lst, "##.OBSERVENUCLEUS", string);
        JDXReader.addHeader(lst, "##SPECTROMETER/DATA SYSTEM", this.cleanJDXValue(map.get("##$INSTRUM")));
        spectrum.setHeaderTable(lst);
        spectrum.setObservedNucleus(string);
        spectrum.setObservedFreq(d);
        spectrum.setHZtoPPM(true);
        if (bl) {
            jDXSource.isCompoundSource = true;
            spectrum.setNumDim(2);
            spectrum.setNucleusAndFreq(string2, false);
            int n = Integer.parseInt(map.get("##$SI"));
            int n2 = Integer.parseInt(map.get("##$SI_2"));
            double d6 = BrukerReader.parseDouble(map.get("##$ABSF1_2"));
            if (d6 == 0.0) {
                d6 = BrukerReader.parseDouble(map.get("##$OFFSET"));
            }
            double d7 = BrukerReader.parseDouble(map.get("##$SFO1_2"));
            double d8 = BrukerReader.parseDouble(map.get("##$SWP_2"));
            int n3 = n;
            double d9 = d3 / (double)n3;
            double d10 = d8 / (double)n2;
            double d11 = d7;
            d7 = d6 * d7 - d10;
            spectrum.fileNPoints = n3;
            spectrum.fileFirstX = d3 - d9;
            spectrum.fileLastX = 0.0;
            double d12 = 1.0;
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                Spectrum spectrum2 = new Spectrum();
                spectrum.copyTo(spectrum2);
                spectrum2.setTitle(spectrum.getTitle());
                spectrum2.setY2D(d7);
                spectrum2.blockID = Math.random();
                spectrum.fileNPoints = n3;
                spectrum.fileFirstX = d3 - d9;
                spectrum.fileLastX = 0.0;
                spectrum2.setY2DUnits("HZ");
                spectrum2.setXFactor(1.0);
                spectrum2.setYFactor(1.0);
                spectrum2.setObservedNucleus(string2);
                spectrum2.setObservedFreq(d11);
                Coordinate[] coordinateArray = new Coordinate[n3];
                int n6 = 0;
                while (n6 < n3) {
                    coordinateArray[n3 - n6 - 1] = new Coordinate().set((double)(n3 - n6) * d9 / d + d5, dArray[n5++] * d12);
                    ++n6;
                }
                spectrum2.setXYCoords(coordinateArray);
                jDXSource.addJDXSpectrum(null, spectrum2, n4 > 0);
                d7 -= d10;
                ++n4;
            }
        } else {
            int n = dArray.length;
            double d13 = d3 / (double)n;
            spectrum.fileFirstX = d3 - d13;
            spectrum.fileLastX = 0.0;
            spectrum.fileNPoints = n;
            Coordinate[] coordinateArray = new Coordinate[n];
            int n7 = 0;
            while (n7 < n) {
                coordinateArray[n - n7 - 1] = new Coordinate().set((double)(n - n7 - 1) * d13 / d + d5, dArray[n7]);
                ++n7;
            }
            spectrum.setXYCoords(coordinateArray);
            spectrum.fileNPoints = n;
            spectrum.setXFactor(d13);
            spectrum.setYFactor(1.0);
            spectrum.setXUnits("ppm");
            spectrum.setYUnits("ARBITRARY UNITS");
            spectrum.setNumDim(1);
            if (spectrum.getMaxY() >= 10000.0) {
                spectrum.normalizeSimulation(1000.0);
            }
            jDXSource.addJDXSpectrum(null, spectrum, false);
        }
    }

    private static double parseDouble(String string) {
        return string == null || string.length() == 0 ? Double.NaN : Double.parseDouble(string);
    }

    private double[] getData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = byArray.length / (n == 0 ? 4 : 8);
        BinaryDocument binaryDocument = new BinaryDocument();
        binaryDocument.setStream(new BufferedInputStream(new ByteArrayInputStream(byArray)), n2 != 0);
        double[] dArray = new double[n3];
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        if (n == 0) {
            int n4 = 0;
            while (n4 < n3) {
                double d4 = 1.0;
                dArray[n4] = d = (double)binaryDocument.readInt() * d4;
                if (d < d2) {
                    d2 = d;
                }
                if (d > d3) {
                    d3 = d;
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                dArray[n5] = d = binaryDocument.readDouble();
                if (d < d2) {
                    d2 = d;
                }
                if (d > d3) {
                    d3 = d;
                }
                ++n5;
            }
        }
        binaryDocument.close();
        return dArray;
    }

    private String cleanJDXValue(String string) {
        String string2 = string == null ? "" : (string.startsWith("<") ? string.substring(1, string.length() - 1) : string);
        return string2.equals("off") ? "" : string2;
    }

    private byte[] getFileContentsAsBytes(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            return new byte[0];
        }
        int n = (int)file.length();
        return this.getBytes(new FileInputStream(file), n, true);
    }

    private byte[] getBytes(InputStream inputStream, int n, boolean bl) {
        try {
            return Rdr.getLimitedStreamBytes(inputStream, n);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }
}

