/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.ObservableList;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ListChangeEvt;
import eu.hansolo.toolbox.properties.BooleanProperty;
import eu.hansolo.toolbox.properties.DoubleProperty;
import eu.hansolo.toolbox.properties.IntegerProperty;
import eu.hansolo.toolbox.properties.ObjectProperty;
import eu.hansolo.toolbox.properties.ReadOnlyBooleanProperty;
import eu.hansolo.toolbox.properties.ReadOnlyDoubleProperty;
import eu.hansolo.toolbox.tuples.Pair;
import eu.hansolo.toolbox.tuples.Quartet;
import eu.hansolo.toolbox.tuples.Triplet;
import eu.hansolo.toolbox.unit.Category;
import eu.hansolo.toolbox.unit.Converter;
import eu.hansolo.toolbox.unit.UnitDefinition;
import java.util.Collection;
import java.util.List;

public class Demo {
    private PoJo pojo;
    private DoubleProperty doubleProperty;
    private ObjectProperty<String> objectProperty;
    private IntegerProperty integerProperty;
    private DoubleProperty doubleProperty1;
    private ReadOnlyDoubleProperty readOnlyDoubleProperty;

    public Demo() {
        this.propertiesDemo();
        this.tuplesDemo();
        this.converterDemo();
        this.observableListDemo();
    }

    private void propertiesDemo() {
        System.out.println("-------------------- properties demo --------------------");
        this.pojo = new PoJo();
        this.pojo.valueProperty().addObserver(evt -> System.out.println("Value changed from " + evt.getOldValue() + " to " + evt.getValue()));
        EvtObserver doubleChangeObserver = e -> System.out.println(e.getOldValue() + " -> " + e.getValue());
        this.doubleProperty = new DoubleProperty(){

            @Override
            protected void willChange(Double oldValue, Double newValue) {
                System.out.println("\nDoubleProperty will change from " + oldValue + " to " + newValue + "\n");
            }

            @Override
            protected void didChange(Double oldValue, Double newValue) {
                System.out.println("\nDoubleProperty changed from " + oldValue + " to " + newValue + "\n");
            }
        };
        this.doubleProperty.addOnChange(doubleChangeObserver);
        this.doubleProperty.removeListener(doubleChangeObserver);
        this.doubleProperty.removeAllObservers();
        this.objectProperty = new ObjectProperty();
        this.integerProperty = new IntegerProperty(10){

            @Override
            public void set(int VALUE) {
                super.set(VALUE);
            }

            @Override
            public int get() {
                return super.get();
            }

            @Override
            protected void didChange(Integer oldValue, Integer newValue) {
                System.out.println("Color changed to: " + newValue);
            }

            @Override
            public Object getBean() {
                return Demo.this;
            }

            @Override
            public String getName() {
                return "color";
            }
        };
        this.doubleProperty1 = new DoubleProperty((Object)this, "oldValue", 10.0);
        this.readOnlyDoubleProperty = new ReadOnlyDoubleProperty(5.0);
        this.pojo.doubleValueProperty().addOnChange(e -> System.out.println("DoubleProperty: " + e.getOldValue() + " -> " + e.getValue()));
        this.doubleProperty.addObserver(e -> System.out.println("DoubleProperty: " + e.getOldValue() + " -> " + e.getValue()));
        this.objectProperty.addObserver(e -> System.out.println("ObjectProperty<String>: " + (String)e.getOldValue() + " -> " + (String)e.getValue()));
        this.pojo.setDoubleValue(7.0);
        this.pojo.setValue(5.0);
        this.pojo.valueProperty().set(8.0);
        this.doubleProperty.set(20.0);
        this.objectProperty.set(new String("Hallo"));
        this.objectProperty.set(new String("Test"));
        this.objectProperty.set("Bla");
        System.out.println("\n\n---------- Unidirectional Binding ------------");
        DoubleProperty propertyA = new DoubleProperty(5.0);
        DoubleProperty propertyB = new DoubleProperty(10.0);
        System.out.println("Property A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyA.bind(propertyB)");
        propertyA.bind(propertyB);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(5)");
        propertyB.set(5.0);
        System.out.println("\npropertyB = " + propertyB.get());
        System.out.println("propertyA = " + propertyA.get());
        System.out.println("\npropertyA.set(20)");
        try {
            propertyA.set(20.0);
        }
        catch (IllegalArgumentException e2) {
            System.out.println("Error, a bound value cannot be set.");
        }
        System.out.println("\npropertyA.unbind()");
        propertyA.unbind();
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(15)");
        propertyB.set(15.0);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\nReadOnlyDoubleProperty: " + this.readOnlyDoubleProperty.getValue());
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Bind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.bind(this.readOnlyDoubleProperty);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Unbind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.unbind();
        System.out.println("Set DoubleProperty -> 13");
        this.doubleProperty.set(13.0);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("\n\n---------- Bidirectional Binding ------------");
        DoubleProperty propertyC = new DoubleProperty(0.0);
        DoubleProperty propertyD = new DoubleProperty(25.0);
        System.out.println("Property C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.bindBidirectional(propertyD)");
        propertyC.bindBidirectional(propertyD);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyC.set(20)");
        propertyC.set(20.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyD.unbind()");
        propertyD.unbind();
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.set(10)");
        propertyC.set(10.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
    }

    private void tuplesDemo() {
        System.out.println("-------------------- tuples demo --------------------");
        Pair<Double, Integer> pair = new Pair<Double, Integer>(5.0, 3);
        Triplet<Double, Integer, Integer> triplet = new Triplet<Double, Integer, Integer>(5.0, 3, 500);
        Quartet<Double, Integer, String, Integer> quartet = new Quartet<Double, Integer, String, Integer>(1.0, 5, "Test", 1000);
        System.out.println("Quartet size      : " + quartet.size());
        System.out.println("Quartet value at 2: " + quartet.getValueAt(2));
        System.out.println("Quartet type at 2 : " + quartet.getTypeAt(2));
    }

    private void converterDemo() {
        System.out.println("-------------------- converter demo --------------------");
        Converter temperatureConverter = new Converter(Category.TEMPERATURE, UnitDefinition.CELSIUS);
        double celsius = 32.0;
        double fahrenheit = temperatureConverter.convert(celsius, UnitDefinition.FAHRENHEIT);
        double kelvin = temperatureConverter.convert(celsius, UnitDefinition.KELVIN);
        System.out.println(celsius + "\u00b0C   =>   " + fahrenheit + "\u00b0F    =>   " + kelvin + "\u00b0K");
        Converter lengthConverter = new Converter(Category.LENGTH, UnitDefinition.METER);
        double meter = 1.0;
        double inches = lengthConverter.convert(meter, UnitDefinition.INCHES);
        double nanometer = lengthConverter.convert(inches, UnitDefinition.NANOMETER);
        System.out.println(meter + " " + lengthConverter.getUnitShort() + "   =>   " + inches + " in   =>   " + nanometer + " nm");
        Converter volumeConverter = new Converter(Category.VOLUME, UnitDefinition.CUBIC_METER);
        double cubicMeter = 3.0;
        double liters = volumeConverter.convert(cubicMeter, UnitDefinition.LITER);
        System.out.println(cubicMeter + " cubic meter -> " + liters + " liter");
        Converter literConverter = new Converter(Category.VOLUME, UnitDefinition.LITER);
        double liter = 3000.0;
        double cubicMeters = literConverter.convert(liter, UnitDefinition.CUBIC_METER);
        System.out.println(liter + " liter -> " + cubicMeters + " cubic meter");
        Converter glucoseConverter = new Converter(Category.BLOOD_GLUCOSE, UnitDefinition.MILLIMOL_PER_LITER);
        double millimolPerLiter = 6.0;
        double milligramPerDeciliter = glucoseConverter.convert(millimolPerLiter, UnitDefinition.MILLIGRAM_PER_DECILITER);
        System.out.println(millimolPerLiter + "mmol/l -> " + milligramPerDeciliter + "mg/dl");
        Converter mgdlConverter = new Converter(Category.BLOOD_GLUCOSE, UnitDefinition.MILLIGRAM_PER_DECILITER);
        double mgdl = 108.108108;
        double mmoll = mgdlConverter.convert(mgdl, UnitDefinition.MILLIMOL_PER_LITER);
        System.out.println(mgdl + " mg/dl -> " + mmoll + " mmol/l");
        System.out.println(lengthConverter.convertToString(meter, UnitDefinition.CENTIMETER));
        System.out.println(Converter.format(1500000.0, 1));
        System.out.println(Converter.format(1000000.0, 0));
    }

    private void observableListDemo() {
        System.out.println("-------------------- observable list demo --------------------");
        ObservableList<String> observableList = new ObservableList<String>();
        observableList.addListChangeObserver(ListChangeEvt.ANY, e -> {
            EvtType type = e.getEvtType();
            if (ListChangeEvt.CHANGED.equals(type)) {
                System.out.println("List changed");
            } else if (ListChangeEvt.ADDED.equals(type)) {
                e.getAddedItems().forEach(item -> System.out.println("Added: " + item));
            } else if (ListChangeEvt.REMOVED.equals(type)) {
                e.getRemovedItems().forEach(item -> System.out.println("Removed: " + item));
            }
        });
        System.out.println("---------- adding ----------");
        observableList.add("Gerrit");
        observableList.add("Sandra");
        observableList.add("Lilli");
        observableList.add("Anton");
        observableList.add("Neo");
        System.out.println("---------- remove 1 ----------");
        observableList.remove("Neo");
        System.out.println("---------- add list of 3 ----------");
        observableList.addAll((Collection<String>)List.of("Test", "Test2", "Test3"));
        System.out.println("---------- remove 1 ----------");
        observableList.remove("Test2");
        System.out.println("---------- add 1 ----------");
        observableList.add(2, "Neo");
        System.out.println("---------- print all ----------");
        observableList.forEach(item -> System.out.println((String)item));
        System.out.println("---------- retain all (Gerrit, Sandra, Lilli, Anton, Neo) ----------");
        List<String> keep = List.of("Gerrit", "Sandra", "Lilli", "Anton", "Neo");
        observableList.retainAll(keep);
        System.out.println("---------- clear ----------");
        observableList.clear();
    }

    public static void main(String[] args2) {
        new Demo();
    }

    public class PoJo {
        private double _value = 0.0;
        private DoubleProperty value;
        private DoubleProperty doubleValue = new DoubleProperty(3.0);
        private BooleanProperty booleanValue = new BooleanProperty(true);

        public double getValue() {
            return null == this.value ? this._value : this.value.get();
        }

        public void setValue(double value) {
            if (null == this.value) {
                this._value = value;
            } else {
                this.value.set(value);
            }
        }

        public DoubleProperty valueProperty() {
            if (null == this.value) {
                this.value = new DoubleProperty(this._value){

                    @Override
                    protected void willChange(Double oldValue, Double newValue) {
                        System.out.println("\nValue will change from " + oldValue + " to " + newValue + "\n");
                    }

                    @Override
                    protected void didChange(Double oldValue, Double newValue) {
                        System.out.println("\nValue changed from " + oldValue + " to " + newValue + "\n");
                    }
                };
            }
            return this.value;
        }

        public double getDoubleValue() {
            return this.doubleValue.get();
        }

        public void setDoubleValue(double value) {
            this.doubleValue.set(value);
        }

        public DoubleProperty doubleValueProperty() {
            return this.doubleValue;
        }

        public boolean isBooleanValue() {
            return this.booleanValue.get();
        }

        public ReadOnlyBooleanProperty booleanValueProperty() {
            return this.booleanValue;
        }
    }
}

