/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.unit;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.unit.Category;
import eu.hansolo.toolbox.unit.Unit;
import eu.hansolo.toolbox.unit.UnitDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Converter {
    public static final String[] ABBREVIATIONS = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
    public static final int MAX_NO_OF_DECIMALS = 12;
    private static final EnumMap<Category, UnitDefinition> BASE_UNITS = new EnumMap<Category, UnitDefinition>(Category.class){
        {
            this.put(Category.ACCELERATION, UnitDefinition.METER_PER_SQUARE_SECOND);
            this.put(Category.ANGLE, UnitDefinition.RADIAN);
            this.put(Category.AREA, UnitDefinition.SQUARE_METER);
            this.put(Category.CURRENT, UnitDefinition.AMPERE);
            this.put(Category.DATA, UnitDefinition.BIT);
            this.put(Category.ELECTRIC_CHARGE, UnitDefinition.ELEMENTARY_CHARGE);
            this.put(Category.ENERGY, UnitDefinition.JOULE);
            this.put(Category.FORCE, UnitDefinition.NEWTON);
            this.put(Category.HUMIDITY, UnitDefinition.PERCENTAGE);
            this.put(Category.LENGTH, UnitDefinition.METER);
            this.put(Category.LUMINANCE, UnitDefinition.CANDELA_SQUARE_METER);
            this.put(Category.LUMINOUS_FLUX, UnitDefinition.LUX);
            this.put(Category.MASS, UnitDefinition.KILOGRAM);
            this.put(Category.PRESSURE, UnitDefinition.PASCAL);
            this.put(Category.SPEED, UnitDefinition.METER_PER_SECOND);
            this.put(Category.TEMPERATURE, UnitDefinition.KELVIN);
            this.put(Category.TEMPERATURE_GRADIENT, UnitDefinition.KELVIN_PER_SECOND);
            this.put(Category.TIME, UnitDefinition.SECOND);
            this.put(Category.TORQUE, UnitDefinition.NEWTON_METER);
            this.put(Category.VOLUME, UnitDefinition.CUBIC_METER);
            this.put(Category.VOLTAGE, UnitDefinition.VOLT);
            this.put(Category.WORK, UnitDefinition.WATT);
            this.put(Category.BLOOD_GLUCOSE, UnitDefinition.MILLIMOL_PER_LITER);
        }
    };
    private UnitDefinition baseUnitDefinition;
    private Unit bean;
    private Locale locale;
    private int decimals;
    private String formatString;

    public Converter(Category category) {
        this(category, BASE_UNITS.get((Object)category));
    }

    public Converter(Category category, UnitDefinition baseUnitDefinition) {
        this.baseUnitDefinition = baseUnitDefinition;
        this.bean = Converter.BASE_UNITS.get((Object)((Object)category)).UNIT;
        this.locale = Locale.US;
        this.decimals = 2;
        this.formatString = "%.2f";
    }

    public Category getCategory() {
        return this.bean.getCategory();
    }

    public UnitDefinition getBaseUnitDefinition() {
        return this.baseUnitDefinition;
    }

    public void setBaseUnitDefinition(UnitDefinition baseUnitDefinition) {
        if (baseUnitDefinition.UNIT.getCategory() == this.getCategory()) {
            this.baseUnitDefinition = baseUnitDefinition;
        }
    }

    public BigDecimal getFactor() {
        return this.bean.getFactor();
    }

    public BigDecimal getOffset() {
        return this.bean.getOffset();
    }

    public String getUnitName() {
        return this.bean.getUnitName();
    }

    public String getUnitShort() {
        return this.bean.getUnitShort();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals < 0 ? 0 : (decimals > 12 ? 12 : decimals);
        this.formatString = "%." + this.decimals + "f";
    }

    public String getFormatString() {
        return this.formatString;
    }

    public final boolean isActive() {
        return this.bean.isActive();
    }

    public final void setActive(boolean active) {
        this.bean.setActive(active);
    }

    public final double convert(double value, UnitDefinition unitDefinition) {
        if (unitDefinition.UNIT.getCategory() != this.getCategory()) {
            throw new IllegalArgumentException("units have to be of the same type");
        }
        return ((value + this.baseUnitDefinition.UNIT.getOffset().doubleValue()) * this.baseUnitDefinition.UNIT.getFactor().doubleValue() + this.bean.getOffset().doubleValue()) * this.bean.getFactor().doubleValue() / unitDefinition.UNIT.getFactor().doubleValue() - unitDefinition.UNIT.getOffset().doubleValue();
    }

    public final String convertToString(double value, UnitDefinition unitDefinition) {
        return String.join((CharSequence)" ", String.format(this.locale, this.formatString, this.convert(value, unitDefinition)), unitDefinition.UNIT.getUnitShort());
    }

    public final double convertToBaseUnit(double value, UnitDefinition unitDefinition) {
        return ((value + unitDefinition.UNIT.getOffset().doubleValue()) * unitDefinition.UNIT.getFactor().doubleValue() + this.bean.getOffset().doubleValue()) * this.bean.getFactor().doubleValue() / this.baseUnitDefinition.UNIT.getFactor().doubleValue() - this.baseUnitDefinition.UNIT.getOffset().doubleValue();
    }

    public final Pattern getPattern() {
        StringBuilder PATTERN_BUILDER = new StringBuilder();
        PATTERN_BUILDER.append("^([-+]?\\d*\\.?\\d*)\\s?(");
        for (UnitDefinition unitDefinition : UnitDefinition.values()) {
            PATTERN_BUILDER.append(unitDefinition.UNIT.getUnitShort().replace("*", "\\*")).append("|");
        }
        PATTERN_BUILDER.deleteCharAt(PATTERN_BUILDER.length() - 1);
        PATTERN_BUILDER.append(")?$");
        return Pattern.compile(PATTERN_BUILDER.toString());
    }

    public final List<Unit> getAvailableUnits(Category category) {
        return this.getAllUnitDefinitions().get((Object)category).stream().map(unitDefinition -> unitDefinition.UNIT).toList();
    }

    public final EnumMap<Category, ArrayList<UnitDefinition>> getAllUnitDefinitions() {
        EnumMap<Category, ArrayList<UnitDefinition>> UNIT_TYPES = new EnumMap<Category, ArrayList<UnitDefinition>>(Category.class);
        ArrayList<Category> CATEGORY_LIST = new ArrayList<Category>(Category.values().length);
        CATEGORY_LIST.addAll(Arrays.asList(Category.values()));
        CATEGORY_LIST.forEach(category -> UNIT_TYPES.put((Category)((Object)category), new ArrayList()));
        for (UnitDefinition unitDefinition : UnitDefinition.values()) {
            UNIT_TYPES.get((Object)unitDefinition.UNIT.getCategory()).add(unitDefinition);
        }
        return UNIT_TYPES;
    }

    public final EnumMap<Category, ArrayList<UnitDefinition>> getAllActiveUnitDefinitions() {
        EnumMap<Category, ArrayList<UnitDefinition>> UNIT_DEFINITIONS = new EnumMap<Category, ArrayList<UnitDefinition>>(Category.class);
        ArrayList<Category> CATEGORY_LIST = new ArrayList<Category>(Category.values().length);
        CATEGORY_LIST.addAll(Arrays.asList(Category.values()));
        CATEGORY_LIST.forEach(category -> UNIT_DEFINITIONS.put((Category)((Object)category), new ArrayList()));
        for (UnitDefinition unitDefinition : UnitDefinition.values()) {
            if (!unitDefinition.UNIT.isActive()) continue;
            UNIT_DEFINITIONS.get((Object)unitDefinition.UNIT.getCategory()).add(unitDefinition);
        }
        return UNIT_DEFINITIONS;
    }

    public static final String format(double number, int decimals) {
        return Converter.format(number, Helper.clamp(0, 12, decimals), Locale.US);
    }

    public static final String format(double number, int decimals, Locale locale) {
        String formatString = "%." + Helper.clamp(0, 12, decimals) + "f";
        for (int i = ABBREVIATIONS.length - 1; i >= 0; --i) {
            double value = Math.pow(1000.0, (double)i + 1.0);
            if (Double.compare(number, -value) > 0 && Double.compare(number, value) < 0) continue;
            return String.format(locale, formatString, number / value) + ABBREVIATIONS[i];
        }
        return String.format(locale, formatString, number);
    }

    public String toString() {
        return "{" + "\"" + "category" + "\"" + ":" + "\"" + (Object)((Object)this.getCategory()) + "\"" + "}";
    }
}

