/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import net.osmand.plus.api.SettingsAPI;
import net.sourceforge.offroad.OsmWindow;

final class OffRoadSettings
implements SettingsAPI {
    private static final String OTHER_PROPERTIES_POSTFIX = ".priv.properties";
    private static final String OFFROAD_PROPERTIES = "offroad.properties";
    private OsmWindow mOsmWindow;
    private HashMap<String, Properties> mPreferencesHash = new HashMap();
    private static final String SHARED_PREFERENCES_NAME = "net.osmand.settings";

    public OffRoadSettings(OsmWindow ctx) {
        this.mOsmWindow = ctx;
        this.mPreferencesHash.put(SHARED_PREFERENCES_NAME, this.readDefaultPreferences());
        this.load();
    }

    public void load() {
        Path dir = Paths.get(this.mOsmWindow.getAppPath("").getAbsolutePath(), new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.priv.properties");){
            for (Path entry : stream) {
                Properties props = new Properties();
                try {
                    FileInputStream in = new FileInputStream(entry.toFile());
                    props.load(in);
                    ((InputStream)in).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("Panic! Error while loading offroad properties.");
                }
                String key = entry.toFile().getName().replaceFirst(OTHER_PROPERTIES_POSTFIX, "");
                System.out.println("Read file " + entry + " and put as " + key);
                this.mPreferencesHash.put(key, props);
            }
        }
        catch (IOException x) {
            System.err.println(x);
        }
    }

    public Properties readDefaultPreferences() {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.mOsmWindow.getAppPath(OFFROAD_PROPERTIES));
            props.load(in);
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Panic! Error while loading offroad properties.");
        }
        return props;
    }

    @Override
    public String getString(Object pPref, String pKey, String pDefValue) {
        String res = this.getPreferences(pPref).getProperty(pKey, pDefValue);
        return res;
    }

    private Properties getPreferences(Object pPref) {
        return (Properties)pPref;
    }

    @Override
    public Object getPreferenceObject(String pKey) {
        if (!this.mPreferencesHash.containsKey(pKey)) {
            System.out.println("Create prefs for " + pKey);
            this.mPreferencesHash.put(pKey, new Properties());
        }
        return this.mPreferencesHash.get(pKey);
    }

    @Override
    public long getLong(Object pPref, String pKey, long pDefValue) {
        try {
            return Long.parseLong(this.getString(pPref, pKey, "" + pDefValue));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return pDefValue;
        }
    }

    @Override
    public int getInt(Object pPref, String pKey, int pDefValue) {
        try {
            return Integer.parseInt(this.getString(pPref, pKey, "" + pDefValue));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return pDefValue;
        }
    }

    @Override
    public float getFloat(Object pPref, String pKey, float pDefValue) {
        try {
            return Float.parseFloat(this.getString(pPref, pKey, "" + pDefValue));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return pDefValue;
        }
    }

    @Override
    public boolean getBoolean(Object pPref, String pKey, boolean pDefValue) {
        try {
            return Boolean.parseBoolean(this.getString(pPref, pKey, "" + pDefValue));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return pDefValue;
        }
    }

    @Override
    public SettingsAPI.SettingsEditor edit(Object pPref) {
        Properties copy = new Properties();
        if (pPref instanceof Properties) {
            Properties props = (Properties)pPref;
            OffRoadSettings.copyProperties(props, copy);
        }
        return new OffRoadSettingsEditor(copy, this.getPreferences(pPref));
    }

    public static void copyProperties(Properties src_prop, Properties dest_prop) {
        Enumeration<?> propertyNames = src_prop.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            dest_prop.put(key, src_prop.get(key));
        }
    }

    @Override
    public boolean contains(Object pPref, String pKey) {
        return this.getPreferences(pPref).containsKey(pKey);
    }

    public void save() {
        try {
            FileOutputStream stream = new FileOutputStream(this.mOsmWindow.getAppPath(OFFROAD_PROPERTIES));
            this.mPreferencesHash.get(SHARED_PREFERENCES_NAME).store(stream, "");
            stream.close();
            for (String key : this.mPreferencesHash.keySet()) {
                if (key.equals(SHARED_PREFERENCES_NAME)) continue;
                FileOutputStream streamL = new FileOutputStream(this.mOsmWindow.getAppPath(key + OTHER_PROPERTIES_POSTFIX));
                this.mPreferencesHash.get(key).store(streamL, "");
                streamL.close();
            }
            System.out.println("Settings saved.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final class OffRoadSettingsEditor
    implements SettingsAPI.SettingsEditor {
        private Properties properties;
        private Properties mPref;

        public OffRoadSettingsEditor(Properties pCopy, Properties pPref) {
            this.properties = pCopy;
            this.mPref = pPref;
        }

        @Override
        public SettingsAPI.SettingsEditor putString(String pKey, String pValue) {
            if (pValue != null) {
                this.properties.setProperty(pKey, pValue);
            } else {
                this.properties.remove(pKey);
            }
            return this;
        }

        @Override
        public SettingsAPI.SettingsEditor putBoolean(String pKey, boolean pValue) {
            this.properties.setProperty(pKey, "" + pValue);
            return this;
        }

        @Override
        public SettingsAPI.SettingsEditor putFloat(String pKey, float pValue) {
            this.properties.setProperty(pKey, "" + pValue);
            return this;
        }

        @Override
        public SettingsAPI.SettingsEditor putInt(String pKey, int pValue) {
            this.properties.setProperty(pKey, "" + pValue);
            return this;
        }

        @Override
        public SettingsAPI.SettingsEditor putLong(String pKey, long pValue) {
            this.properties.setProperty(pKey, "" + pValue);
            return this;
        }

        @Override
        public SettingsAPI.SettingsEditor remove(String pKey) {
            this.properties.remove(pKey);
            return this;
        }

        @Override
        public boolean commit() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.properties.store(out, "");
                this.mPref.clear();
                this.mPref.load(new ByteArrayInputStream(out.toByteArray()));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

