"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiScreenReaderOnly", {
  enumerable: true,
  get: function get() {
    return _screen_reader.EuiScreenReaderOnly;
  }
});
exports.OuiScreenReaderOnly = void 0;

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _screen_reader = require("../../eui_components/accessibility/screen_reader");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var OuiScreenReaderOnly = function OuiScreenReaderOnly(_ref) {
  var children = _ref.children,
      showOnFocus = _ref.showOnFocus;
  var classes = (0, _classnames.default)({
    ouiScreenReaderOnly: !showOnFocus,
    'ouiScreenReaderOnly--showOnFocus': showOnFocus
  }, children.props.className);

  var props = _objectSpread(_objectSpread({}, children.props), {}, {
    className: classes
  });

  return /*#__PURE__*/(0, _react.cloneElement)(children, props);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiScreenReaderOnly = OuiScreenReaderOnly;
OuiScreenReaderOnly.propTypes = {
  /**
     * ReactElement to render as this component's content
     */
  children: _propTypes.default.element.isRequired,

  /**
     * For keyboard navigation, force content to display visually upon focus.
     */
  showOnFocus: _propTypes.default.bool
};