"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultUiPlugins = exports.getDefaultEuiMarkdownUiPlugins = exports.defaultProcessingPlugins = exports.getDefaultEuiMarkdownProcessingPlugins = exports.defaultParsingPlugins = exports.getDefaultEuiMarkdownParsingPlugins = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _all = _interopRequireDefault(require("mdast-util-to-hast/lib/all"));

var _rehypeReact = _interopRequireDefault(require("rehype-react"));

var _remarkParse = _interopRequireDefault(require("remark-parse"));

var _remarkEmoji = _interopRequireDefault(require("remark-emoji"));

var _remarkRehype = _interopRequireDefault(require("remark-rehype"));

var _remark_prismjs = _interopRequireDefault(require("./remark/remark_prismjs"));

var MarkdownTooltip = _interopRequireWildcard(require("./markdown_tooltip"));

var MarkdownCheckbox = _interopRequireWildcard(require("./markdown_checkbox"));

var _markdown_link_validator = require("./markdown_link_validator");

var _link = require("../../link");

var _code = require("../../code");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  return [[_remarkParse.default, {}], [_remark_prismjs.default, {}], [_remarkEmoji.default, {
    emoticon: true
  }], [MarkdownTooltip.parser, {}], [MarkdownCheckbox.parser, {}], [_markdown_link_validator.markdownLinkValidator, {}]];
};

exports.getDefaultEuiMarkdownParsingPlugins = getDefaultEuiMarkdownParsingPlugins;
var defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();
exports.defaultParsingPlugins = defaultParsingPlugins;

var unknownHandler = function unknownHandler(h, node) {
  return h(node, node.type, node, (0, _all.default)(h, node));
};

var getDefaultEuiMarkdownProcessingPlugins = function getDefaultEuiMarkdownProcessingPlugins() {
  return [[_remarkRehype.default, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to

  }], [_rehypeReact.default, {
    createElement: _react.createElement,
    components: {
      a: _link.EuiLink,
      code: function code(props) {
        return (// If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) ? /*#__PURE__*/_react.default.createElement(_code.EuiCodeBlock, (0, _extends2.default)({
            fontSize: "m",
            paddingSize: "s"
          }, props)) : /*#__PURE__*/_react.default.createElement(_code.EuiCode, props)
        );
      },
      tooltipPlugin: MarkdownTooltip.renderer,
      checkboxPlugin: MarkdownCheckbox.renderer
    }
  }]];
};

exports.getDefaultEuiMarkdownProcessingPlugins = getDefaultEuiMarkdownProcessingPlugins;
var defaultProcessingPlugins = getDefaultEuiMarkdownProcessingPlugins();
exports.defaultProcessingPlugins = defaultProcessingPlugins;

var getDefaultEuiMarkdownUiPlugins = function getDefaultEuiMarkdownUiPlugins() {
  var array = [MarkdownTooltip.plugin]; // @ts-ignore __originatedFromEui is a custom property

  array.__originatedFromEui = true;
  return array;
};

exports.getDefaultEuiMarkdownUiPlugins = getDefaultEuiMarkdownUiPlugins;
var defaultUiPlugins = getDefaultEuiMarkdownUiPlugins();
exports.defaultUiPlugins = defaultUiPlugins;