/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.opensearchapi;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.admin.indices.rollover.RolloverInfo;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a2\u0010\u000e\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\f\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013\u0018\u00010\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015\u001a.\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\"\u0010\u001f\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a0\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"0\u000f\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"*\u0010\u0012\u0004\u0012\u0002H!\u0012\u0006\u0012\u0004\u0018\u0001H\"0\u000f\u001a+\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u001e0\u0010*\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\u001a\f\u0010#\u001a\u0004\u0018\u00010\u0011*\u00020'\u001a\f\u0010(\u001a\u0004\u0018\u00010)*\u00020'\u001a\f\u0010*\u001a\u0004\u0018\u00010\u0007*\u00020'\u001a\n\u0010+\u001a\u00020\u001e*\u00020'\u001aA\u0010,\u001a \u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\f\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013\u0018\u00010\u00100\u0006*\u00020$2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "buildMgetMetadataRequest", "Lorg/opensearch/action/get/MultiGetRequest;", "indexUuids", "", "", "getUuidsForClosedIndices", "", "state", "Lorg/opensearch/cluster/ClusterState;", "defaultIndexMetadataService", "Lorg/opensearch/indexmanagement/indexstatemanagement/DefaultIndexMetadataService;", "mgetResponseToMap", "", "Lkotlin/Pair;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "mgetResponse", "Lorg/opensearch/action/get/MultiGetResponse;", "addObject", "Lorg/opensearch/common/xcontent/XContentBuilder;", "name", "metadata", "Lorg/opensearch/common/xcontent/ToXContentFragment;", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "forIndex", "", "buildMetadata", "filterNotNullValues", "K", "V", "getManagedIndexMetadata", "Lorg/opensearch/client/Client;", "indexUUID", "(Lorg/opensearch/client/Client;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "getOldestRolloverTime", "Ljava/time/Instant;", "getRolloverAlias", "getRolloverSkip", "mgetManagedIndexMetadata", "(Lorg/opensearch/client/Client;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class OpenSearchExtensionsKt {
    private static final Logger log = LogManager.getLogger((String)"Index Management Helper");

    @Nullable
    public static final String getRolloverAlias(@NotNull IndexMetadata $this$getRolloverAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$getRolloverAlias, (String)"<this>");
        CharSequence charSequence = $this$getRolloverAlias.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = $this$getRolloverAlias.getSettings().get(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (String)null : $this$getRolloverAlias.getSettings().get(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
        }
        return $this$getRolloverAlias.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
    }

    public static final boolean getRolloverSkip(@NotNull IndexMetadata $this$getRolloverSkip) {
        Intrinsics.checkNotNullParameter((Object)$this$getRolloverSkip, (String)"<this>");
        Object object = $this$getRolloverSkip.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey());
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            object = $this$getRolloverSkip.getSettings().getAsBoolean(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey(), Boolean.valueOf(false));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.settings.getAsBoole\u2026ROLLOVER_SKIP.key, false)");
            return (Boolean)object;
        }
        object = $this$getRolloverSkip.getSettings().getAsBoolean(ManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey(), Boolean.valueOf(false));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.settings.getAsBoole\u2026ROLLOVER_SKIP.key, false)");
        return (Boolean)object;
    }

    @Nullable
    public static final ManagedIndexMetaData getManagedIndexMetadata(@NotNull IndexMetadata $this$getManagedIndexMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$getManagedIndexMetadata, (String)"<this>");
        Map existingMetaDataMap = $this$getManagedIndexMetadata.getCustomData("managed_index_metadata");
        if (existingMetaDataMap != null) {
            return ManagedIndexMetaData.Companion.fromMap(existingMetaDataMap);
        }
        return null;
    }

    @NotNull
    public static final List<String> getUuidsForClosedIndices(@NotNull ClusterState state, @NotNull DefaultIndexMetadataService defaultIndexMetadataService) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)defaultIndexMetadataService, (String)"defaultIndexMetadataService");
        ImmutableOpenMap indexMetadatas2 = state.getMetadata().getIndices();
        List closeList = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)indexMetadatas2, (String)"indexMetadatas");
        Iterable $this$forEach$iv = (Iterable)indexMetadatas2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
            boolean bl = false;
            if (((IndexMetadata)it.value).getState() != IndexMetadata.State.CLOSE) continue;
            Object object = it.value;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value");
            closeList.add(defaultIndexMetadataService.getCustomIndexUUID((IndexMetadata)object));
        }
        return closeList;
    }

    @NotNull
    public static final <K, V> Map<K, V> filterNotNullValues(@NotNull Map<K, ? extends V> $this$filterNotNullValues) {
        Intrinsics.checkNotNullParameter($this$filterNotNullValues, (String)"<this>");
        Map<K, V> $this$filterValues$iv = $this$filterNotNullValues;
        boolean $i$f$filterValues = false;
        LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            V it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getManagedIndexMetadata(@NotNull Client var0, @NotNull String var1_1, @NotNull Continuation<? super Pair<ManagedIndexMetaData, Boolean>> var2_2) {
        if (!(var2_2 instanceof getManagedIndexMetadata.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSearchExtensionsKt.getManagedIndexMetadata(null, null, (Continuation<? super Pair<ManagedIndexMetaData, Boolean>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getRequest = new GetRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID((String)indexUUID)).routing((String)indexUUID);
                $continuation.label = 1;
                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getManagedIndexMetadata, (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var8_5) goto lbl19
lbl18:
                // 1 sources

                return var8_5;
lbl19:
                // 1 sources

                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                    return new Pair(null, (Object)Boxing.boxBoolean((boolean)true));
                }
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ManagedIndexMetaData>, Object>(getResponse, null){
                    int label;
                    final /* synthetic */ GetResponse $getResponse;
                    {
                        this.$getResponse = $getResponse;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)this.$getResponse.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                                String string = this.$getResponse.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResponse.id");
                                return ManagedIndexMetaData.Companion.parseWithType(xcp, string, this.$getResponse.getSeqNo(), this.$getResponse.getPrimaryTerm());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ManagedIndexMetaData> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var8_5) goto lbl31
lbl30:
                // 1 sources

                return var8_5;
lbl31:
                // 1 sources

                ** GOTO lbl37
            }
            case 2: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    metadata = (ManagedIndexMetaData)v1;
                    return new Pair((Object)metadata, (Object)Boxing.boxBoolean((boolean)true));
                }
                catch (Exception e) {
                    var4_9 = e;
                    if (var4_9 instanceof IndexNotFoundException != false ? true : var4_9 instanceof NoShardAvailableActionException) {
                        OpenSearchExtensionsKt.log.error("Failed to get metadata because no index or shard not available");
                    } else {
                        OpenSearchExtensionsKt.log.error("Failed to get metadata", (Throwable)e);
                    }
                    return new Pair(null, (Object)Boxing.boxBoolean((boolean)false));
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object mgetManagedIndexMetadata(@NotNull Client var0, @NotNull List<String> var1_1, @NotNull Continuation<? super List<? extends Pair<ManagedIndexMetaData, ? extends Exception>>> var2_2) {
        if (!(var2_2 instanceof mgetManagedIndexMetadata.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSearchExtensionsKt.mgetManagedIndexMetadata(null, null, (Continuation<? super List<? extends Pair<ManagedIndexMetaData, ? extends Exception>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                OpenSearchExtensionsKt.log.debug("trying to get back metadata for index [" + indexUuids + "]");
                if (indexUuids.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                mgetRequest = new MultiGetRequest();
                $this$forEach$iv = indexUuids;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-OpenSearchExtensionsKt$mgetManagedIndexMetadata$2 = false;
                    mgetRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID((String)it)).routing((String)it));
                }
                mgetMetadataList = CollectionsKt.emptyList();
                $continuation.L$0 = indexUuids;
                $continuation.L$1 = mgetMetadataList;
                $continuation.label = 1;
                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$mgetManagedIndexMetadata, (Function2)new Function2<Client, ActionListener<MultiGetResponse>, Unit>(mgetRequest){
                    final /* synthetic */ MultiGetRequest $mgetRequest;
                    {
                        this.$mgetRequest = $mgetRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<MultiGetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.multiGet(this.$mgetRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var18_5) goto lbl34
lbl33:
                // 1 sources

                return var18_5;
lbl34:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                mgetMetadataList = (List)$continuation.L$1;
                indexUuids = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl42:
                    // 2 sources

                    response = (MultiGetResponse)v0;
                    $this$map$iv = OpenSearchExtensionsKt.mgetResponseToMap(response);
                    $i$f$map = false;
                    it = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    $i$f$mapTo = false;
                    var11_19 = $this$mapTo$iv$iv.entrySet().iterator();
                    while (var11_19.hasNext()) {
                        var13_21 = item$iv$iv = var11_19.next();
                        var15_23 = destination$iv$iv;
                        $i$a$-map-OpenSearchExtensionsKt$mgetManagedIndexMetadata$3 = false;
                        var15_23.add((Pair)it.getValue());
                    }
                    mgetMetadataList = (List)destination$iv$iv;
                }
                catch (ActionRequestValidationException e) {
                    OpenSearchExtensionsKt.log.info("No managed index metadata for indices [" + indexUuids + "], " + e.getMessage());
                }
                catch (Exception e) {
                    OpenSearchExtensionsKt.log.error("Failed to multi-get managed index metadata for indices [" + indexUuids + "]", (Throwable)e);
                }
                return mgetMetadataList;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final Map<String, Pair<ManagedIndexMetaData, Exception>> mgetResponseToMap(@NotNull MultiGetResponse mgetResponse) {
        Intrinsics.checkNotNullParameter((Object)mgetResponse, (String)"mgetResponse");
        Map mgetMap = new LinkedHashMap();
        MultiGetItemResponse[] multiGetItemResponseArray = mgetResponse.getResponses();
        Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"mgetResponse.responses");
        Object[] $this$forEach$iv = multiGetItemResponseArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
            boolean bl = false;
            if (it.isFailed()) {
                string = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                mgetMap.put(string, new Pair(null, (Object)it.getFailure().getFailure()));
                continue;
            }
            if (it.getResponse() != null && !it.getResponse().isSourceEmpty()) {
                string = it.getResponse().getSourceAsBytesRef();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.response.sourceAsBytesRef");
                XContentParser xcp = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.contentParser((BytesReference)string);
                String string2 = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.id");
                String string3 = it.getResponse().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.response.id");
                mgetMap.put(string2, new Pair((Object)ManagedIndexMetaData.Companion.parseWithType(xcp, string3, it.getResponse().getSeqNo(), it.getResponse().getPrimaryTerm()), null));
                continue;
            }
            string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            mgetMap.put(string, null);
        }
        return mgetMap;
    }

    @NotNull
    public static final MultiGetRequest buildMgetMetadataRequest(@NotNull List<String> indexUuids) {
        Intrinsics.checkNotNullParameter(indexUuids, (String)"indexUuids");
        MultiGetRequest mgetMetadataRequest = new MultiGetRequest();
        Iterable $this$forEach$iv = indexUuids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            mgetMetadataRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(it)).routing(it));
        }
        return mgetMetadataRequest;
    }

    @NotNull
    public static final XContentBuilder addObject(@NotNull XContentBuilder $this$addObject, @NotNull String name, @Nullable ToXContentFragment metadata2, @NotNull ToXContent.Params params, boolean forIndex) {
        XContentBuilder xContentBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$addObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (metadata2 != null) {
            return OpenSearchExtensionsKt.buildMetadata($this$addObject, name, metadata2, params);
        }
        if (forIndex) {
            XContentBuilder xContentBuilder2 = $this$addObject.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"nullField(name)");
            xContentBuilder = xContentBuilder2;
        } else {
            xContentBuilder = $this$addObject;
        }
        return xContentBuilder;
    }

    public static /* synthetic */ XContentBuilder addObject$default(XContentBuilder xContentBuilder, String string, ToXContentFragment toXContentFragment, ToXContent.Params params, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return OpenSearchExtensionsKt.addObject(xContentBuilder, string, toXContentFragment, params, bl);
    }

    @NotNull
    public static final XContentBuilder buildMetadata(@NotNull XContentBuilder $this$buildMetadata, @NotNull String name, @NotNull ToXContentFragment metadata2, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)$this$buildMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        $this$buildMetadata.startObject(name);
        metadata2.toXContent($this$buildMetadata, params);
        $this$buildMetadata.endObject();
        return $this$buildMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Instant getOldestRolloverTime(@NotNull IndexMetadata $this$getOldestRolloverTime) {
        Instant instant;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getOldestRolloverTime, (String)"<this>");
        ObjectContainer objectContainer = $this$getOldestRolloverTime.getRolloverInfos().values();
        Intrinsics.checkNotNullExpressionValue((Object)objectContainer, (String)"this.rolloverInfos.values()");
        Iterable $this$map$iv = (Iterable)objectContainer;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ObjectCursor objectCursor = (ObjectCursor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((RolloverInfo)it.value).getTime());
        }
        Long l = (Long)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        if (l == null) {
            instant = null;
        } else {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.ofEpochMilli(it);
        }
        return instant;
    }
}

