/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.delete;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.indexmanagement.indexstatemanagement.step.delete.AttemptDeleteStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.snapshots.SnapshotInProgressException;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\f\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/delete/AttemptDeleteStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "()V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "handleException", "", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleSnapshotException", "Lorg/opensearch/snapshots/SnapshotInProgressException;", "isIdempotent", "", "Companion", "opensearch-index-management"})
public final class AttemptDeleteStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "attempt_delete";

    public AttemptDeleteStep() {
        super(name, false, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptDeleteStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(indexName){
                    final /* synthetic */ String $indexName;
                    {
                        this.$indexName = $indexName;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.delete(new DeleteIndexRequest(this.$indexName), it);
                    }
                }, $continuation);
                ** if (v1 != var8_4) goto lbl25
lbl24:
                // 1 sources

                return var8_4;
lbl25:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                indexName = (String)$continuation.L$1;
                this = (AttemptDeleteStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v1).isAcknowledged()) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptDeleteStep.Companion.getSuccessMessage(indexName)));
                    } else {
                        message = AttemptDeleteStep.Companion.getFailedMessage(indexName);
                        this.logger.warn(message);
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                    }
                }
                catch (RemoteTransportException e) {
                    cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof SnapshotInProgressException) {
                        this.handleSnapshotException(indexName, (SnapshotInProgressException)cause);
                    } else {
                        v2 = cause;
                        if (v2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        }
                        this.handleException(indexName, (Exception)v2);
                    }
                }
                catch (SnapshotInProgressException e) {
                    this.handleSnapshotException(indexName, e);
                }
                catch (Exception e) {
                    this.handleException(indexName, e);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleSnapshotException(String indexName, SnapshotInProgressException e) {
        String message = Companion.getSnapshotMessage(indexName);
        this.logger.warn(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
    }

    private final void handleException(String indexName, Exception e) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            Map map = mutableInfo;
            String string = "cause";
            map.put(string, errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (int)120575, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/delete/AttemptDeleteStep$Companion;", "", "()V", "name", "", "getFailedMessage", "indexName", "getSnapshotMessage", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String indexName) {
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            return "Failed to delete index [index=" + indexName + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String indexName) {
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            return "Successfully deleted index [index=" + indexName + "]";
        }

        @NotNull
        public final String getSnapshotMessage(@NotNull String indexName) {
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            return "Index had snapshot in progress, retrying deletion [index=" + indexName + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

