/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.jackson.ObjectMapperShim;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class JacksonAdapter
implements SerializerAdapter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonAdapter.class);
    private static boolean useAccessHelper = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_JACKSON_ADAPTER_USE_ACCESS_HELPER"));
    private final ObjectMapperShim mapper;
    private final ObjectMapperShim headerMapper;
    private ObjectMapper rawOuterMapper;
    private ObjectMapper rawInnerMapper;

    public JacksonAdapter() {
        this((outerMapper, innerMapper) -> {});
    }

    public JacksonAdapter(BiConsumer<ObjectMapper, ObjectMapper> configureSerialization) {
        Objects.requireNonNull(configureSerialization, "'configureSerialization' cannot be null.");
        this.headerMapper = ObjectMapperShim.createHeaderMapper();
        this.mapper = ObjectMapperShim.createJsonMapper(ObjectMapperShim.createSimpleMapper(), (outerMapper, innerMapper) -> this.captureRawMappersAndConfigure((ObjectMapper)outerMapper, (ObjectMapper)innerMapper, configureSerialization));
    }

    private void captureRawMappersAndConfigure(ObjectMapper outerMapper, ObjectMapper innerMapper, BiConsumer<ObjectMapper, ObjectMapper> configure) {
        this.rawOuterMapper = outerMapper;
        this.rawInnerMapper = innerMapper;
        configure.accept(outerMapper, innerMapper);
    }

    @Deprecated
    protected ObjectMapper simpleMapper() {
        return this.rawInnerMapper;
    }

    public static SerializerAdapter createDefaultSerializerAdapter() {
        return GlobalSerializerAdapter.SERIALIZER_ADAPTER.getSerializerAdapter();
    }

    @Deprecated
    public ObjectMapper serializer() {
        return this.rawOuterMapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        return (String)JacksonAdapter.useAccessHelper(() -> encoding == SerializerEncoding.XML ? this.getXmlMapper().writeValueAsString(object) : this.mapper.writeValueAsString(object));
    }

    @Override
    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        return (byte[])JacksonAdapter.useAccessHelper(() -> encoding == SerializerEncoding.XML ? this.getXmlMapper().writeValueAsBytes(object) : this.mapper.writeValueAsBytes(object));
    }

    @Override
    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        JacksonAdapter.useAccessHelper(() -> {
            if (encoding == SerializerEncoding.XML) {
                this.getXmlMapper().writeValue(outputStream, object);
            } else {
                this.mapper.writeValue(outputStream, object);
            }
            return null;
        });
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (String)JacksonAdapter.useAccessHelper(() -> {
                try {
                    return JacksonAdapter.removeLeadingAndTrailingQuotes(this.serialize(object, SerializerEncoding.JSON));
                }
                catch (IOException ex) {
                    LOGGER.warning("Failed to serialize {} to JSON.", object.getClass(), ex);
                    return null;
                }
            });
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }

    static String removeLeadingAndTrailingQuotes(String str) {
        int endOffset;
        int startOffset;
        int strLength = str.length();
        for (startOffset = 0; startOffset < strLength && str.charAt(startOffset) == '\"'; ++startOffset) {
        }
        if (startOffset == strLength) {
            return "";
        }
        for (endOffset = strLength - 1; endOffset >= 0 && str.charAt(endOffset) == '\"'; --endOffset) {
        }
        return str.substring(startOffset, endOffset + 1);
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        try {
            return (String)JacksonAdapter.useAccessHelper(() -> this.serializeIterable(list, format));
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    @Override
    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> encoding == SerializerEncoding.XML ? this.getXmlMapper().readValue(value, type) : this.mapper.readValue(value, type));
    }

    @Override
    public <T> T deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> encoding == SerializerEncoding.XML ? this.getXmlMapper().readValue(bytes, type) : this.mapper.readValue(bytes, type));
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> encoding == SerializerEncoding.XML ? this.getXmlMapper().readValue(inputStream, type) : this.mapper.readValue(inputStream, type));
    }

    @Override
    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        return (T)JacksonAdapter.useAccessHelper(() -> this.headerMapper.deserialize(headers, deserializedHeadersType));
    }

    @Override
    public <T> T deserializeHeader(Header header, Type type) throws IOException {
        return (T)JacksonAdapter.useAccessHelper(() -> this.headerMapper.readValue(header.getValue(), type));
    }

    private ObjectMapperShim getXmlMapper() {
        return GlobalXmlMapper.XML_MAPPER.getXmlMapper();
    }

    private static Object useAccessHelper(IOExceptionCallable serializationCall) throws IOException {
        if (useAccessHelper) {
            try {
                return AccessController.doPrivileged(serializationCall::call);
            }
            catch (PrivilegedActionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(cause));
            }
        }
        return serializationCall.call();
    }

    static boolean isUseAccessHelper() {
        return useAccessHelper;
    }

    static void setUseAccessHelper(boolean useAccessHelper) {
        JacksonAdapter.useAccessHelper = useAccessHelper;
    }

    private static enum GlobalSerializerAdapter {
        SERIALIZER_ADAPTER(new JacksonAdapter());

        private final SerializerAdapter serializerAdapter;

        private GlobalSerializerAdapter(SerializerAdapter serializerAdapter) {
            this.serializerAdapter = serializerAdapter;
        }

        private SerializerAdapter getSerializerAdapter() {
            return this.serializerAdapter;
        }
    }

    @FunctionalInterface
    private static interface IOExceptionCallable {
        public Object call() throws IOException;
    }

    private static enum GlobalXmlMapper {
        XML_MAPPER(ObjectMapperShim.createXmlMapper());

        private final ObjectMapperShim xmlMapper;

        private GlobalXmlMapper(ObjectMapperShim xmlMapper) {
            this.xmlMapper = xmlMapper;
        }

        private ObjectMapperShim getXmlMapper() {
            return this.xmlMapper;
        }
    }
}

