/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.user;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.CustomAttributesAware;

public class User
implements Serializable,
Writeable,
CustomAttributesAware {
    public static final User ANONYMOUS = new User("opendistro_security_anonymous", Lists.newArrayList((Object[])new String[]{"opendistro_security_anonymous_backendrole"}), null);
    public static final User DEFAULT_TRANSPORT_USER = new User("opendistro_security_default_transport_user", Lists.newArrayList((Object[])new String[]{"opendistro_security_default_transport_backendrole"}), null);
    private static final long serialVersionUID = -5500938501822658596L;
    private final String name;
    private final Set<String> roles = Collections.synchronizedSet(new HashSet());
    private final Set<String> securityRoles = Collections.synchronizedSet(new HashSet());
    private String requestedTenant;
    private Map<String, String> attributes = Collections.synchronizedMap(new HashMap());
    private boolean isInjected = false;

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.roles.addAll(in.readList(StreamInput::readString));
        this.requestedTenant = in.readString();
        this.attributes = Collections.synchronizedMap(in.readMap(StreamInput::readString, StreamInput::readString));
        this.securityRoles.addAll(in.readList(StreamInput::readString));
    }

    public User(String name, Collection<String> roles, AuthCredentials customAttributes) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        if (roles != null) {
            this.addRoles(roles);
        }
        if (customAttributes != null) {
            this.attributes.putAll(customAttributes.getAttributes());
        }
    }

    public User(String name) {
        this(name, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public final void addRole(String role) {
        this.roles.add(role);
    }

    public final void addRoles(Collection<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    public final boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public final void addAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public final String getRequestedTenant() {
        return this.requestedTenant;
    }

    public final void setRequestedTenant(String requestedTenant) {
        this.requestedTenant = requestedTenant;
    }

    public boolean isInjected() {
        return this.isInjected;
    }

    public void setInjected(boolean isInjected) {
        this.isInjected = isInjected;
    }

    public final String toStringWithAttributes() {
        return "User [name=" + this.name + ", backend_roles=" + this.roles + ", requestedTenant=" + this.requestedTenant + ", attributes=" + this.attributes + "]";
    }

    public final String toString() {
        return "User [name=" + this.name + ", backend_roles=" + this.roles + ", requestedTenant=" + this.requestedTenant + "]";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final void copyRolesFrom(User user) {
        if (user != null) {
            this.addRoles(user.getRoles());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(new ArrayList<String>(this.roles));
        out.writeString(this.requestedTenant);
        out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
        out.writeStringCollection((Collection)(this.securityRoles == null ? Collections.emptyList() : new ArrayList<String>(this.securityRoles)));
    }

    @Override
    public final synchronized Map<String, String> getCustomAttributesMap() {
        if (this.attributes == null) {
            this.attributes = Collections.synchronizedMap(new HashMap());
        }
        return this.attributes;
    }

    public final void addSecurityRoles(Collection<String> securityRoles) {
        if (securityRoles != null && this.securityRoles != null) {
            this.securityRoles.addAll(securityRoles);
        }
    }

    public final Set<String> getSecurityRoles() {
        return this.securityRoles == null ? Collections.synchronizedSet(Collections.emptySet()) : Collections.unmodifiableSet(this.securityRoles);
    }
}

