/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.sync;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class MLSyncUpInput
implements Writeable {
    private boolean getLoadedModels;
    private Map<String, String[]> addedWorkerNodes;
    private Map<String, String[]> removedWorkerNodes;
    private Map<String, Set<String>> modelRoutingTable;
    private Map<String, Set<String>> runningLoadModelTasks;
    private boolean clearRoutingTable;
    private boolean syncRunningLoadModelTasks;

    public MLSyncUpInput(boolean getLoadedModels, Map<String, String[]> addedWorkerNodes, Map<String, String[]> removedWorkerNodes, Map<String, Set<String>> modelRoutingTable, Map<String, Set<String>> runningLoadModelTasks, boolean clearRoutingTable, boolean syncRunningLoadModelTasks) {
        this.getLoadedModels = getLoadedModels;
        this.addedWorkerNodes = addedWorkerNodes;
        this.removedWorkerNodes = removedWorkerNodes;
        this.modelRoutingTable = modelRoutingTable;
        this.runningLoadModelTasks = runningLoadModelTasks;
        this.clearRoutingTable = clearRoutingTable;
        this.syncRunningLoadModelTasks = syncRunningLoadModelTasks;
    }

    public MLSyncUpInput() {
    }

    public MLSyncUpInput(StreamInput in) throws IOException {
        this.getLoadedModels = in.readBoolean();
        if (in.readBoolean()) {
            this.addedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.removedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.modelRoutingTable = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        if (in.readBoolean()) {
            this.runningLoadModelTasks = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        this.clearRoutingTable = in.readBoolean();
        this.syncRunningLoadModelTasks = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.getLoadedModels);
        if (this.addedWorkerNodes != null && this.addedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.addedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.removedWorkerNodes != null && this.removedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.removedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelRoutingTable != null && this.modelRoutingTable.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelRoutingTable, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        if (this.runningLoadModelTasks != null && this.runningLoadModelTasks.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.runningLoadModelTasks, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.clearRoutingTable);
        out.writeBoolean(this.syncRunningLoadModelTasks);
    }

    @Generated
    public static MLSyncUpInputBuilder builder() {
        return new MLSyncUpInputBuilder();
    }

    @Generated
    public boolean isGetLoadedModels() {
        return this.getLoadedModels;
    }

    @Generated
    public Map<String, String[]> getAddedWorkerNodes() {
        return this.addedWorkerNodes;
    }

    @Generated
    public Map<String, String[]> getRemovedWorkerNodes() {
        return this.removedWorkerNodes;
    }

    @Generated
    public Map<String, Set<String>> getModelRoutingTable() {
        return this.modelRoutingTable;
    }

    @Generated
    public Map<String, Set<String>> getRunningLoadModelTasks() {
        return this.runningLoadModelTasks;
    }

    @Generated
    public boolean isClearRoutingTable() {
        return this.clearRoutingTable;
    }

    @Generated
    public boolean isSyncRunningLoadModelTasks() {
        return this.syncRunningLoadModelTasks;
    }

    @Generated
    public void setGetLoadedModels(boolean getLoadedModels) {
        this.getLoadedModels = getLoadedModels;
    }

    @Generated
    public void setAddedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
        this.addedWorkerNodes = addedWorkerNodes;
    }

    @Generated
    public void setRemovedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
        this.removedWorkerNodes = removedWorkerNodes;
    }

    @Generated
    public void setModelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
        this.modelRoutingTable = modelRoutingTable;
    }

    @Generated
    public void setRunningLoadModelTasks(Map<String, Set<String>> runningLoadModelTasks) {
        this.runningLoadModelTasks = runningLoadModelTasks;
    }

    @Generated
    public void setClearRoutingTable(boolean clearRoutingTable) {
        this.clearRoutingTable = clearRoutingTable;
    }

    @Generated
    public void setSyncRunningLoadModelTasks(boolean syncRunningLoadModelTasks) {
        this.syncRunningLoadModelTasks = syncRunningLoadModelTasks;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLSyncUpInput)) {
            return false;
        }
        MLSyncUpInput other = (MLSyncUpInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGetLoadedModels() != other.isGetLoadedModels()) {
            return false;
        }
        if (this.isClearRoutingTable() != other.isClearRoutingTable()) {
            return false;
        }
        if (this.isSyncRunningLoadModelTasks() != other.isSyncRunningLoadModelTasks()) {
            return false;
        }
        Map<String, String[]> this$addedWorkerNodes = this.getAddedWorkerNodes();
        Map<String, String[]> other$addedWorkerNodes = other.getAddedWorkerNodes();
        if (this$addedWorkerNodes == null ? other$addedWorkerNodes != null : !((Object)this$addedWorkerNodes).equals(other$addedWorkerNodes)) {
            return false;
        }
        Map<String, String[]> this$removedWorkerNodes = this.getRemovedWorkerNodes();
        Map<String, String[]> other$removedWorkerNodes = other.getRemovedWorkerNodes();
        if (this$removedWorkerNodes == null ? other$removedWorkerNodes != null : !((Object)this$removedWorkerNodes).equals(other$removedWorkerNodes)) {
            return false;
        }
        Map<String, Set<String>> this$modelRoutingTable = this.getModelRoutingTable();
        Map<String, Set<String>> other$modelRoutingTable = other.getModelRoutingTable();
        if (this$modelRoutingTable == null ? other$modelRoutingTable != null : !((Object)this$modelRoutingTable).equals(other$modelRoutingTable)) {
            return false;
        }
        Map<String, Set<String>> this$runningLoadModelTasks = this.getRunningLoadModelTasks();
        Map<String, Set<String>> other$runningLoadModelTasks = other.getRunningLoadModelTasks();
        return !(this$runningLoadModelTasks == null ? other$runningLoadModelTasks != null : !((Object)this$runningLoadModelTasks).equals(other$runningLoadModelTasks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLSyncUpInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGetLoadedModels() ? 79 : 97);
        result = result * 59 + (this.isClearRoutingTable() ? 79 : 97);
        result = result * 59 + (this.isSyncRunningLoadModelTasks() ? 79 : 97);
        Map<String, String[]> $addedWorkerNodes = this.getAddedWorkerNodes();
        result = result * 59 + ($addedWorkerNodes == null ? 43 : ((Object)$addedWorkerNodes).hashCode());
        Map<String, String[]> $removedWorkerNodes = this.getRemovedWorkerNodes();
        result = result * 59 + ($removedWorkerNodes == null ? 43 : ((Object)$removedWorkerNodes).hashCode());
        Map<String, Set<String>> $modelRoutingTable = this.getModelRoutingTable();
        result = result * 59 + ($modelRoutingTable == null ? 43 : ((Object)$modelRoutingTable).hashCode());
        Map<String, Set<String>> $runningLoadModelTasks = this.getRunningLoadModelTasks();
        result = result * 59 + ($runningLoadModelTasks == null ? 43 : ((Object)$runningLoadModelTasks).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLSyncUpInput(getLoadedModels=" + this.isGetLoadedModels() + ", addedWorkerNodes=" + this.getAddedWorkerNodes() + ", removedWorkerNodes=" + this.getRemovedWorkerNodes() + ", modelRoutingTable=" + this.getModelRoutingTable() + ", runningLoadModelTasks=" + this.getRunningLoadModelTasks() + ", clearRoutingTable=" + this.isClearRoutingTable() + ", syncRunningLoadModelTasks=" + this.isSyncRunningLoadModelTasks() + ")";
    }

    @Generated
    public static class MLSyncUpInputBuilder {
        @Generated
        private boolean getLoadedModels;
        @Generated
        private Map<String, String[]> addedWorkerNodes;
        @Generated
        private Map<String, String[]> removedWorkerNodes;
        @Generated
        private Map<String, Set<String>> modelRoutingTable;
        @Generated
        private Map<String, Set<String>> runningLoadModelTasks;
        @Generated
        private boolean clearRoutingTable;
        @Generated
        private boolean syncRunningLoadModelTasks;

        @Generated
        MLSyncUpInputBuilder() {
        }

        @Generated
        public MLSyncUpInputBuilder getLoadedModels(boolean getLoadedModels) {
            this.getLoadedModels = getLoadedModels;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder addedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
            this.addedWorkerNodes = addedWorkerNodes;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder removedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
            this.removedWorkerNodes = removedWorkerNodes;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder modelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
            this.modelRoutingTable = modelRoutingTable;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder runningLoadModelTasks(Map<String, Set<String>> runningLoadModelTasks) {
            this.runningLoadModelTasks = runningLoadModelTasks;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder clearRoutingTable(boolean clearRoutingTable) {
            this.clearRoutingTable = clearRoutingTable;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder syncRunningLoadModelTasks(boolean syncRunningLoadModelTasks) {
            this.syncRunningLoadModelTasks = syncRunningLoadModelTasks;
            return this;
        }

        @Generated
        public MLSyncUpInput build() {
            return new MLSyncUpInput(this.getLoadedModels, this.addedWorkerNodes, this.removedWorkerNodes, this.modelRoutingTable, this.runningLoadModelTasks, this.clearRoutingTable, this.syncRunningLoadModelTasks);
        }

        @Generated
        public String toString() {
            return "MLSyncUpInput.MLSyncUpInputBuilder(getLoadedModels=" + this.getLoadedModels + ", addedWorkerNodes=" + this.addedWorkerNodes + ", removedWorkerNodes=" + this.removedWorkerNodes + ", modelRoutingTable=" + this.modelRoutingTable + ", runningLoadModelTasks=" + this.runningLoadModelTasks + ", clearRoutingTable=" + this.clearRoutingTable + ", syncRunningLoadModelTasks=" + this.syncRunningLoadModelTasks + ")";
        }
    }
}

