/* application-main-window.c generated by valac 0.56.3, the Vala compiler
 * generated from application-main-window.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2016, 2019-2021 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>

#define APPLICATION_MAIN_WINDOW_INNER_LEAFLET "inner_leaflet"
#define APPLICATION_MAIN_WINDOW_FOLDER_LIST "folder_list"
#define APPLICATION_MAIN_WINDOW_CONVERSATION_LIST "conversation_list"
#define APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER "conversation_viewer"
#define APPLICATION_MAIN_WINDOW_STATUS_BAR_HEIGHT 18
#define APPLICATION_MAIN_WINDOW_UPDATE_UI_INTERVAL 60
#define APPLICATION_MAIN_WINDOW_MIN_CONVERSATION_COUNT 50
#define CONVERSATION_EMAIL_REQUIRED_FOR_CONSTRUCT ((GEARY_EMAIL_FIELD_ENVELOPE | GEARY_EMAIL_FIELD_PREVIEW) | GEARY_EMAIL_FIELD_FLAGS)

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;
enum  {
	APPLICATION_MAIN_WINDOW_0_PROPERTY,
	APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY,
	APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY,
	APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY,
	APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY,
	APPLICATION_MAIN_WINDOW_IS_FOLDER_LIST_SHOWN_PROPERTY,
	APPLICATION_MAIN_WINDOW_IS_CONVERSATION_LIST_SHOWN_PROPERTY,
	APPLICATION_MAIN_WINDOW_IS_CONVERSATION_VIEWER_SHOWN_PROPERTY,
	APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY,
	APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_SUPPORTS_TRASH_PROPERTY,
	APPLICATION_MAIN_WINDOW_HAS_COMPOSER_PROPERTY,
	APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY,
	APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY,
	APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY,
	APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY,
	APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY,
	APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY,
	APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY,
	APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY,
	APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY,
	APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY,
	APPLICATION_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* application_main_window_properties[APPLICATION_MAIN_WINDOW_NUM_PROPERTIES];
typedef enum  {
	APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE,
	APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE,
	APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE
} ApplicationMainWindowConversationCount;

#define APPLICATION_MAIN_WINDOW_TYPE_CONVERSATION_COUNT (application_main_window_conversation_count_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;
typedef struct _ApplicationMainWindowSelectFolderData ApplicationMainWindowSelectFolderData;
typedef struct _ApplicationMainWindowShowConversationsData ApplicationMainWindowShowConversationsData;
typedef struct _ApplicationMainWindowShowEmailData ApplicationMainWindowShowEmailData;
typedef struct _Block15Data Block15Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationMainWindowRemoveAccountData ApplicationMainWindowRemoveAccountData;

#define TYPE_ALERT_DIALOG (alert_dialog_get_type ())
#define ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALERT_DIALOG, AlertDialog))
#define ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALERT_DIALOG, AlertDialogClass))
#define IS_ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALERT_DIALOG))
#define IS_ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALERT_DIALOG))
#define ALERT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALERT_DIALOG, AlertDialogClass))

typedef struct _AlertDialog AlertDialog;
typedef struct _AlertDialogClass AlertDialogClass;

#define TYPE_CONFIRMATION_DIALOG (confirmation_dialog_get_type ())
#define CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIRMATION_DIALOG, ConfirmationDialog))
#define CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIRMATION_DIALOG, ConfirmationDialogClass))
#define IS_CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIRMATION_DIALOG))
#define IS_CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIRMATION_DIALOG))
#define CONFIRMATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIRMATION_DIALOG, ConfirmationDialogClass))

typedef struct _ConfirmationDialog ConfirmationDialog;
typedef struct _ConfirmationDialogClass ConfirmationDialogClass;
typedef struct _Block16Data Block16Data;
typedef struct _ApplicationMainWindowUndoData ApplicationMainWindowUndoData;
typedef struct _Block17Data Block17Data;
typedef struct _ApplicationMainWindowRedoData ApplicationMainWindowRedoData;
typedef struct _ApplicationMainWindowLoadConversationsForEmailData ApplicationMainWindowLoadConversationsForEmailData;

#define COMPOSER_TYPE_APPLICATION_INTERFACE (composer_application_interface_get_type ())
#define COMPOSER_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface))
#define COMPOSER_IS_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE))
#define COMPOSER_APPLICATION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterfaceIface))

typedef struct _ComposerApplicationInterface ComposerApplicationInterface;
typedef struct _ComposerApplicationInterfaceIface ComposerApplicationInterfaceIface;
typedef struct _ApplicationMainWindowSelectConversationsData ApplicationMainWindowSelectConversationsData;
typedef struct _Block18Data Block18Data;
typedef struct _ApplicationMainWindowOpenConversationMonitorData ApplicationMainWindowOpenConversationMonitorData;
typedef struct _Block19Data Block19Data;
typedef struct _ApplicationMainWindowCreateComposerData ApplicationMainWindowCreateComposerData;
typedef struct _ApplicationMainWindowCreateComposerFromViewerData ApplicationMainWindowCreateComposerFromViewerData;
typedef struct _ApplicationMainWindowUpdateContextDependentActionsData ApplicationMainWindowUpdateContextDependentActionsData;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
enum  {
	APPLICATION_MAIN_WINDOW_RETRY_SERVICE_PROBLEM_SIGNAL,
	APPLICATION_MAIN_WINDOW_REPLY_CONVERSATION_SENDER_SIGNAL,
	APPLICATION_MAIN_WINDOW_REPLY_CONVERSATION_ALL_SIGNAL,
	APPLICATION_MAIN_WINDOW_FORWARD_CONVERSATION_SIGNAL,
	APPLICATION_MAIN_WINDOW_MARK_CONVERSATIONS_READ_SIGNAL,
	APPLICATION_MAIN_WINDOW_MARK_CONVERSATIONS_STARRED_SIGNAL,
	APPLICATION_MAIN_WINDOW_SHOW_COPY_MENU_SIGNAL,
	APPLICATION_MAIN_WINDOW_SHOW_MOVE_MENU_SIGNAL,
	APPLICATION_MAIN_WINDOW_ARCHIVE_CONVERSATIONS_SIGNAL,
	APPLICATION_MAIN_WINDOW_JUNK_CONVERSATIONS_SIGNAL,
	APPLICATION_MAIN_WINDOW_TRASH_CONVERSATIONS_SIGNAL,
	APPLICATION_MAIN_WINDOW_DELETE_CONVERSATIONS_SIGNAL,
	APPLICATION_MAIN_WINDOW_SEARCH_SIGNAL,
	APPLICATION_MAIN_WINDOW_FIND_SIGNAL,
	APPLICATION_MAIN_WINDOW_NAVIGATE_SIGNAL,
	APPLICATION_MAIN_WINDOW_NUM_SIGNALS
};
static guint application_main_window_signals[APPLICATION_MAIN_WINDOW_NUM_SIGNALS] = {0};

struct _ApplicationMainWindowPrivate {
	GearyAccount* _selected_account;
	GearyFolder* _selected_folder;
	GearyAppConversationMonitor* _conversations;
	ApplicationAttachmentManager* _attachments;
	gboolean _is_shift_down;
	gint _window_width;
	gint _window_height;
	gboolean _window_maximized;
	FolderListTree* _folder_list;
	SearchBar* _search_bar;
	ConversationListView* _conversation_list_view;
	ConversationViewer* _conversation_viewer;
	ComponentsInfoBarStack* _conversation_list_info_bars;
	StatusBar* _status_bar;
	ApplicationController* controller;
	MonitoredSpinner* spinner;
	GeeSet* accounts;
	GSimpleActionGroup* edit_actions;
	gboolean previous_selection_was_interactive;
	GearyFolder* previous_non_search_folder;
	GearyAggregateProgressMonitor* progress_monitor;
	GCancellable* action_update_cancellable;
	GCancellable* folder_open;
	GearyTimeoutManager* update_ui_timeout;
	gint64 update_ui_last;
	ComponentsApplicationHeaderBar* application_headerbar;
	ComponentsConversationListHeaderBar* conversation_list_headerbar;
	HdyLeaflet* outer_leaflet;
	HdyLeaflet* inner_leaflet;
	GtkBox* folder_box;
	GtkScrolledWindow* folder_list_scrolled;
	GtkBox* conversation_list_box;
	GtkScrolledWindow* conversation_list_scrolled;
	GtkRevealer* conversation_list_actions_revealer;
	ComponentsConversationActions* conversation_list_actions;
	GtkBox* conversation_viewer_box;
	GtkRevealer* conversation_viewer_actions_revealer;
	GtkOverlay* overlay;
	ComponentsInfoBarStack* info_bars;
	ComponentsConversationActions** folder_conversation_actions;
	gint folder_conversation_actions_length1;
	gint _folder_conversation_actions_size_;
	FolderPopover** folder_popovers;
	gint folder_popovers_length1;
	gint _folder_popovers_size_;
	ComponentsInfoBar* offline_infobar;
	ComponentsInfoBar* cert_problem_infobar;
	ComponentsInfoBar* auth_problem_infobar;
	ComponentsProblemReportInfoBar* service_problem_infobar;
};

struct _Block14Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	ApplicationClient* application;
};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

struct _ApplicationMainWindowSelectFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyFolder* to_select;
	gboolean is_interactive;
	gboolean inhibit_autoselect;
	GearyFolder* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GearyFolder* _tmp5_;
	FolderPopover** _tmp6_;
	gint _tmp6__length1;
	FolderPopover** menu_collection;
	gint menu_collection_length1;
	gint _menu_collection_size_;
	gint menu_it;
	FolderPopover* _tmp7_;
	FolderPopover* menu;
	FolderPopover* _tmp8_;
	GearyFolder* _tmp9_;
	GearyAggregateProgressMonitor* _tmp10_;
	GearyFolder* _tmp11_;
	GearyProgressMonitor* _tmp12_;
	GearyProgressMonitor* _tmp13_;
	GearyFolder* _tmp14_;
	GearyFolderProperties* _tmp15_;
	GearyFolderProperties* _tmp16_;
	guint _tmp17_;
	GearyAppConversationMonitor* _tmp18_;
	GearyAggregateProgressMonitor* _tmp19_;
	GearyAppConversationMonitor* _tmp20_;
	GearyProgressMonitor* _tmp21_;
	GearyProgressMonitor* _tmp22_;
	GearyAppConversationMonitor* _tmp23_;
	ConversationListStore* conversations_model;
	ConversationListView* _tmp24_;
	ConversationListStore* _tmp25_;
	ConversationListStore* _tmp26_;
	GearyAggregateProgressMonitor* _tmp27_;
	ConversationListStore* _tmp28_;
	GearyProgressMonitor* _tmp29_;
	GearyProgressMonitor* _tmp30_;
	ConversationListView* _tmp31_;
	ComponentsInfoBarStack* _tmp32_;
	GearyAccount* _tmp33_;
	GearyAccount* _tmp34_;
	GearyAccount* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GearyFolderSpecialUse _tmp38_;
	GearyFolderSpecialUse _tmp39_;
	FolderListTree* _tmp40_;
	GearyAccount* _tmp41_;
	GearyAccount* _tmp42_;
	FolderListTree* _tmp43_;
	FolderListTree* _tmp44_;
	ConversationViewer* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GearyAggregateProgressMonitor* _tmp49_;
	GearyProgressMonitor* _tmp50_;
	GearyProgressMonitor* _tmp51_;
	GearyFolderProperties* _tmp52_;
	GearyFolderProperties* _tmp53_;
	GearyAppConversationMonitor* _tmp54_;
	GearyAppConversationMonitor* _tmp55_;
	GearyAggregateProgressMonitor* _tmp56_;
	GearyAppConversationMonitor* _tmp57_;
	GearyProgressMonitor* _tmp58_;
	GearyProgressMonitor* _tmp59_;
	GearyAppConversationMonitor* _tmp60_;
	ApplicationClient* _tmp61_;
	ApplicationClient* _tmp62_;
	ApplicationConfiguration* _tmp63_;
	ApplicationConfiguration* _tmp64_;
	ConversationListStore* _tmp65_;
	GearyAggregateProgressMonitor* _tmp66_;
	ConversationListStore* _tmp67_;
	GearyProgressMonitor* _tmp68_;
	GearyProgressMonitor* _tmp69_;
	ConversationListView* _tmp70_;
	ConversationListView* _tmp71_;
	ConversationListStore* _tmp72_;
	FolderPopover** _tmp73_;
	gint _tmp73__length1;
	FolderPopover** _vala1_menu_collection;
	gint _vala1_menu_collection_length1;
	gint __vala1_menu_collection_size_;
	gint _vala1_menu_it;
	FolderPopover* _tmp74_;
	FolderPopover* _vala1_menu;
	FolderPopover* _tmp75_;
	GearyAppConversationMonitor* _tmp76_;
	GCancellable* _tmp77_;
	ApplicationController* _tmp78_;
};

struct _ApplicationMainWindowShowConversationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyFolder* location;
	GeeCollection* to_show;
	gboolean is_interactive;
	gboolean inhibit_autoselect;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GeeHashSet* latest_email;
	GeeHashSet* _tmp2_;
	GeeIterator* _stale_it;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GearyAppConversation* stale;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	GearyEmail* first;
	GearyAppConversation* _tmp7_;
	GearyEmail* _tmp8_;
	GearyEmail* _tmp9_;
	GeeHashSet* _tmp10_;
	GearyEmail* _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	GearyEmailIdentifier* _tmp13_;
	GeeCollection* loaded;
	GeeHashSet* _tmp14_;
	GeeCollection* _tmp15_;
	GeeCollection* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
};

struct _ApplicationMainWindowShowEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyFolder* location;
	GeeCollection* to_show;
	gboolean is_interactive;
	gboolean inhibit_autoselect;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* loaded;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GearyAppConversation* target;
	GeeCollection* _tmp6_;
	gpointer _tmp7_;
	ConversationListBox* current_list;
	ConversationViewer* _tmp8_;
	ConversationListBox* _tmp9_;
	ConversationListBox* _tmp10_;
	ConversationListBox* _tmp11_;
	gboolean _tmp12_;
	ConversationListBox* _tmp13_;
	ConversationListBox* _tmp14_;
	GearyAppConversation* _tmp15_;
	GearyAppConversation* _tmp16_;
	GearyAppConversation* _tmp17_;
	ConversationListBox* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
};

struct _Block15Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GeeCollection* referrants;
};

struct _ApplicationMainWindowRemoveAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	ApplicationAccountContext* to_remove;
	GearyFolder* to_select;
	GeeSet* _tmp0_;
	gboolean _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	gboolean is_account_search_active;
	GearyFolder* _tmp8_;
	GearyFolderSpecialUse _tmp9_;
	GearyFolderSpecialUse _tmp10_;
	SearchBar* _tmp11_;
	GtkSearchEntry* _tmp12_;
	GtkSearchEntry* _tmp13_;
	SearchBar* _tmp14_;
	ApplicationCommandStack* _tmp15_;
	ApplicationCommandStack* _tmp16_;
	guint _tmp17_;
	ApplicationCommandStack* _tmp18_;
	ApplicationCommandStack* _tmp19_;
	guint _tmp20_;
	ApplicationCommandStack* _tmp21_;
	ApplicationCommandStack* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	GearyAggregateProgressMonitor* _tmp26_;
	GearyAccount* _tmp27_;
	GearyAccount* _tmp28_;
	GearyProgressMonitor* _tmp29_;
	GearyProgressMonitor* _tmp30_;
	GearySmtpClientService* smtp;
	GearyAccount* _tmp31_;
	GearyAccount* _tmp32_;
	GearyClientService* _tmp33_;
	GearyClientService* _tmp34_;
	GearySmtpClientService* _tmp35_;
	GearySmtpClientService* _tmp36_;
	GearyAggregateProgressMonitor* _tmp37_;
	GearySmtpClientService* _tmp38_;
	GearyProgressMonitor* _tmp39_;
	GearyProgressMonitor* _tmp40_;
	GeeCollection* _tmp41_;
	GeeCollection* _tmp42_;
	FolderListTree* _tmp43_;
	GearyAccount* _tmp44_;
	GearyAccount* _tmp45_;
	GeeSet* _tmp46_;
};

struct _Block16Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	ApplicationAccountContext* selected;
	gpointer _async_data_;
};

struct _ApplicationMainWindowUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	Block16Data* _data16_;
	ApplicationAccountContext* _tmp0_;
	ApplicationAccountContext* _tmp1_;
	ApplicationAccountContext* _tmp2_;
	ApplicationCommandStack* _tmp3_;
	ApplicationCommandStack* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
};

struct _Block17Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	ApplicationAccountContext* selected;
	gpointer _async_data_;
};

struct _ApplicationMainWindowRedoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	Block17Data* _data17_;
	ApplicationAccountContext* _tmp0_;
	ApplicationAccountContext* _tmp1_;
	ApplicationAccountContext* _tmp2_;
	ApplicationCommandStack* _tmp3_;
	ApplicationCommandStack* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
};

struct _ApplicationMainWindowLoadConversationsForEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyFolder* location;
	GeeCollection* to_load;
	GeeCollection* result;
	gboolean was_loaded;
	gboolean _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	GearyAppConversationMonitor* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolder* _tmp4_;
	GearyAppConversationMonitor* _tmp5_;
	GCancellable* _tmp6_;
	GError* err;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GeeHashSet* loaded;
	GeeHashSet* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GearyAppConversationMonitor* _tmp12_;
	GearyAppConversationMonitor* _tmp13_;
	GearyFolder* _tmp14_;
	GearyFolder* _tmp15_;
	GeeIterator* _id_it;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	GearyEmailIdentifier* id;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	GearyAppConversation* conversation;
	GearyAppConversationMonitor* _tmp20_;
	GearyEmailIdentifier* _tmp21_;
	GearyAppConversation* _tmp22_;
	GearyAppConversation* _tmp23_;
	GeeHashSet* _tmp24_;
	GearyAppConversation* _tmp25_;
	GError* _inner_error0_;
};

struct _ComposerApplicationInterfaceIface {
	GTypeInterface parent_iface;
	void (*report_problem) (ComposerApplicationInterface* self, GearyProblemReport* report);
	void (*send_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*send_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*save_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*discard_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*discard_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
};

struct _ApplicationMainWindowSelectConversationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GeeCollection* to_select;
	GeeCollection* scroll_to;
	gboolean is_interactive;
	gboolean _tmp0_;
	gboolean start_mark_timer;
	ConversationListView* _tmp1_;
	ComponentsConversationActions* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ComponentsConversationHeaderBar* _tmp5_;
	ComponentsConversationActions* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ComponentsConversationHeaderBar* _tmp9_;
	ComponentsConversationActions* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	GearyFolder* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	ConversationViewer* _tmp19_;
	GearyAppConversation* convo;
	gpointer _tmp20_;
	ApplicationAccountContext* context;
	ApplicationAccountContext* _tmp21_;
	gboolean _tmp22_;
	ApplicationAccountContext* _tmp23_;
	GearyAppConversation* _tmp24_;
	ConversationViewer* _tmp25_;
	GearyAppConversation* _tmp26_;
	ApplicationAccountContext* _tmp27_;
	GearyAppEmailStore* _tmp28_;
	GearyAppEmailStore* _tmp29_;
	ApplicationAccountContext* _tmp30_;
	ApplicationContactStore* _tmp31_;
	ApplicationContactStore* _tmp32_;
	GError* err;
	GearyAppConversation* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GearyAppConversation* _tmp36_;
	GearyFolder* _tmp37_;
	GearyFolder* _tmp38_;
	GearyAccount* _tmp39_;
	GearyAccount* _tmp40_;
	GearyAccountInformation* _tmp41_;
	GearyAccountInformation* _tmp42_;
	GError* _tmp43_;
	GError* _vala1_err;
	GearyAppConversation* _tmp44_;
	GearyFolder* _tmp45_;
	GearyFolder* _tmp46_;
	GearyAccount* _tmp47_;
	GearyAccount* _tmp48_;
	GearyAccountInformation* _tmp49_;
	GearyAccountInformation* _tmp50_;
	GError* _tmp51_;
	ConversationViewer* _tmp52_;
	GError* _inner_error0_;
};

struct _Block18Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyAppConversationMonitor* to_open;
	gpointer _async_data_;
};

struct _ApplicationMainWindowOpenConversationMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyAppConversationMonitor* to_open;
	GCancellable* cancellable;
	Block18Data* _data18_;
};

struct _Block19Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyAppConversationMonitor* to_close;
};

struct _ApplicationMainWindowCreateComposerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	GearyAccount* send_context;
	ComposerWidgetContextType type;
	GearyEmail* context;
	gchar* quote;
	const gchar* _tmp0_;
	ComposerWidget* composer;
	ApplicationController* _tmp1_;
	ApplicationController* _tmp2_;
	GearyAccountInformation* _tmp3_;
	GearyAccountInformation* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	ApplicationAccountContext* _tmp6_;
	ComposerWidget* _tmp7_;
	ComposerWidget* _tmp8_;
	ApplicationController* _tmp9_;
};

struct _ApplicationMainWindowCreateComposerFromViewerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	ComposerWidgetContextType type;
	GearyAccount* account;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	ConversationEmail* email_view;
	ConversationListBox* list_view;
	ConversationViewer* _tmp2_;
	ConversationListBox* _tmp3_;
	ConversationListBox* _tmp4_;
	ConversationListBox* _tmp5_;
	ConversationListBox* _tmp6_;
	ConversationListBox* _tmp7_;
	ConversationEmail* _tmp8_;
	gboolean _tmp9_;
	GearyAccount* _tmp10_;
	ConversationEmail* _tmp11_;
	gchar* quote;
	ConversationEmail* _tmp12_;
	gchar* _tmp13_;
	GearyAccount* _tmp14_;
	ConversationEmail* _tmp15_;
	GearyEmail* _tmp16_;
	GearyEmail* _tmp17_;
	const gchar* _tmp18_;
};

struct _ApplicationMainWindowUpdateContextDependentActionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationMainWindow* self;
	gboolean sensitive;
	GCancellable* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GeeMultiMap* selected_operations;
	GearyFolder* _tmp4_;
	ApplicationAccountContext* context;
	ApplicationController* _tmp5_;
	GearyFolder* _tmp6_;
	GearyAccount* _tmp7_;
	GearyAccount* _tmp8_;
	GearyAccountInformation* _tmp9_;
	GearyAccountInformation* _tmp10_;
	ApplicationAccountContext* _tmp11_;
	ApplicationAccountContext* _tmp12_;
	GeeCollection* ids;
	GeeLinkedList* _tmp13_;
	GeeIterator* _convo_it;
	ConversationListView* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	GeeIterator* _tmp19_;
	GearyAppConversation* convo;
	GeeIterator* _tmp20_;
	gpointer _tmp21_;
	GeeCollection* _tmp22_;
	GearyAppConversation* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeMultiMap* _tmp26_;
	ApplicationAccountContext* _tmp27_;
	GearyAppEmailStore* _tmp28_;
	GearyAppEmailStore* _tmp29_;
	GeeCollection* _tmp30_;
	GCancellable* _tmp31_;
	GeeMultiMap* _tmp32_;
	GeeMultiMap* _tmp33_;
	GError* e;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GCancellable* _tmp36_;
	GeeHashSet* supported_operations;
	GeeHashSet* _tmp37_;
	GeeMultiMap* _tmp38_;
	GeeHashSet* _tmp39_;
	GeeMultiMap* _tmp40_;
	GeeCollection* _tmp41_;
	GeeCollection* _tmp42_;
	gboolean _tmp43_;
	GeeHashSet* _tmp44_;
	GSimpleAction* _tmp45_;
	GSimpleAction* _tmp46_;
	gboolean _tmp47_;
	GeeHashSet* _tmp48_;
	GSimpleAction* _tmp49_;
	GSimpleAction* _tmp50_;
	GError* _inner_error0_;
};

struct _Block20Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block21Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block22Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block23Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block24Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block25Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* source;
};

struct _Block26Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolderSupportMove* source;
};

struct _Block27Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolderSupportCopy* source;
};

struct _Block28Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* source;
};

struct _Block29Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* source;
};

struct _Block30Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolderSupportRemove* target;
};

struct _Block31Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* location;
};

struct _Block32Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolder* source;
};

struct _Block33Data {
	int _ref_count_;
	ApplicationMainWindow* self;
	GearyFolderSupportRemove* source;
};

static gint ApplicationMainWindow_private_offset;
static gpointer application_main_window_parent_class = NULL;
static GearyBaseInterfaceIface * application_main_window_geary_base_interface_parent_iface = NULL;

VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
static GType application_main_window_conversation_count_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ApplicationMainWindowConversationCount application_main_window_conversation_count_for_size (gint size);
static void application_main_window_on_undo (ApplicationMainWindow* self);
static void _application_main_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void application_main_window_on_redo (ApplicationMainWindow* self);
static void _application_main_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void application_main_window_on_close (ApplicationMainWindow* self);
static void _application_main_window_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void application_main_window_on_show_help_overlay (ApplicationMainWindow* self);
static void _application_main_window_on_show_help_overlay_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void application_main_window_on_show_window_menu (ApplicationMainWindow* self);
static void _application_main_window_on_show_window_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void application_main_window_on_find_in_conversation_action (ApplicationMainWindow* self);
static void _application_main_window_on_find_in_conversation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                               GVariant* parameter,
                                                                                               gpointer self);
static void application_main_window_on_search_activated (ApplicationMainWindow* self);
static void _application_main_window_on_search_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void application_main_window_on_select_inbox (ApplicationMainWindow* self,
                                              GSimpleAction* action,
                                              GVariant* parameter);
static void _application_main_window_on_select_inbox_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void application_main_window_focus_previous_pane (ApplicationMainWindow* self);
static void _application_main_window_focus_previous_pane_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void application_main_window_on_reply_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_reply_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void application_main_window_on_reply_all_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_reply_all_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                          GVariant* parameter,
                                                                                          gpointer self);
static void application_main_window_on_forward_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_forward_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void application_main_window_on_archive_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_archive_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void application_main_window_on_trash_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_trash_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void application_main_window_on_delete_conversation (ApplicationMainWindow* self);
static void _application_main_window_on_delete_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self);
static void application_main_window_on_show_copy_menu (ApplicationMainWindow* self);
static void _application_main_window_on_show_copy_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void application_main_window_on_show_move_menu (ApplicationMainWindow* self);
static void _application_main_window_on_show_move_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void application_main_window_on_conversation_up (ApplicationMainWindow* self);
static void _application_main_window_on_conversation_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void application_main_window_on_conversation_down (ApplicationMainWindow* self);
static void _application_main_window_on_conversation_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void application_main_window_on_mark_as_read (ApplicationMainWindow* self);
static void _application_main_window_on_mark_as_read_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void application_main_window_on_mark_as_unread (ApplicationMainWindow* self);
static void _application_main_window_on_mark_as_unread_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void application_main_window_on_mark_as_starred (ApplicationMainWindow* self);
static void _application_main_window_on_mark_as_starred_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void application_main_window_on_mark_as_unstarred (ApplicationMainWindow* self);
static void _application_main_window_on_mark_as_unstarred_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void application_main_window_on_mark_as_junk_toggle (ApplicationMainWindow* self);
static void _application_main_window_on_mark_as_junk_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self);
static void application_main_window_on_zoom (ApplicationMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* parameter);
static void _application_main_window_on_zoom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void application_main_window_set_selected_account (ApplicationMainWindow* self,
                                                   GearyAccount* value);
static void application_main_window_set_selected_folder (ApplicationMainWindow* self,
                                                  GearyFolder* value);
static void application_main_window_set_conversations (ApplicationMainWindow* self,
                                                GearyAppConversationMonitor* value);
static void application_main_window_set_attachments (ApplicationMainWindow* self,
                                              ApplicationAttachmentManager* value);
VALA_EXTERN gboolean application_controller_does_folder_support_trash (GearyFolder* target);
static void application_main_window_set_is_shift_down (ApplicationMainWindow* self,
                                                gboolean value);
static void application_main_window_set_folder_list (ApplicationMainWindow* self,
                                              FolderListTree* value);
static void application_main_window_set_search_bar (ApplicationMainWindow* self,
                                             SearchBar* value);
static void application_main_window_set_conversation_list_view (ApplicationMainWindow* self,
                                                         ConversationListView* value);
static void application_main_window_set_conversation_viewer (ApplicationMainWindow* self,
                                                      ConversationViewer* value);
static void application_main_window_set_conversation_list_info_bars (ApplicationMainWindow* self,
                                                              ComponentsInfoBarStack* value);
static void application_main_window_set_status_bar (ApplicationMainWindow* self,
                                             StatusBar* value);
static void application_main_window_real_reply_conversation_sender (ApplicationMainWindow* self);
static void application_main_window_activate_action (ApplicationMainWindow* self,
                                              GAction* action);
static GSimpleAction* application_main_window_get_window_action (ApplicationMainWindow* self,
                                                          const gchar* name);
static void application_main_window_real_reply_conversation_all (ApplicationMainWindow* self);
static void application_main_window_real_forward_conversation (ApplicationMainWindow* self);
static void application_main_window_real_mark_conversations_read (ApplicationMainWindow* self,
                                                           gboolean prefer_read);
static void application_main_window_real_mark_conversations_starred (ApplicationMainWindow* self,
                                                              gboolean prefer_starred);
static void application_main_window_real_show_copy_menu (ApplicationMainWindow* self);
static void application_main_window_real_show_move_menu (ApplicationMainWindow* self);
static void application_main_window_real_archive_conversations (ApplicationMainWindow* self);
static void application_main_window_real_junk_conversations (ApplicationMainWindow* self);
static void application_main_window_real_trash_conversations (ApplicationMainWindow* self);
static void application_main_window_real_delete_conversations (ApplicationMainWindow* self);
static void application_main_window_real_search (ApplicationMainWindow* self);
static void application_main_window_real_find (ApplicationMainWindow* self);
static void application_main_window_real_navigate (ApplicationMainWindow* self,
                                            GtkScrollType type);
static void application_main_window_focus_next_pane (ApplicationMainWindow* self);
VALA_EXTERN ApplicationMainWindow* application_main_window_new (ApplicationClient* application);
VALA_EXTERN ApplicationMainWindow* application_main_window_construct (GType object_type,
                                                          ApplicationClient* application);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
static void application_main_window_load_config (ApplicationMainWindow* self,
                                          ApplicationConfiguration* config);
static void application_main_window_restore_saved_window_state (ApplicationMainWindow* self);
static gboolean __lambda193_ (Block14Data* _data14_,
                       GtkWidget* w,
                       GdkEventFocus* e);
VALA_EXTERN void application_controller_window_focus_in (ApplicationController* self);
static gboolean ___lambda193__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean __lambda194_ (Block14Data* _data14_,
                       GtkWidget* w,
                       GdkEventFocus* e);
VALA_EXTERN void application_controller_window_focus_out (ApplicationController* self);
static gboolean ___lambda194__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static void application_main_window_setup_layout (ApplicationMainWindow* self,
                                           ApplicationConfiguration* config);
static void application_main_window_update_command_actions (ApplicationMainWindow* self);
static void application_main_window_update_conversation_actions (ApplicationMainWindow* self,
                                                          ApplicationMainWindowConversationCount count);
static void application_main_window_on_update_ui_timeout (ApplicationMainWindow* self);
static void _application_main_window_on_update_ui_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                       gpointer self);
VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
static void application_main_window_on_account_available (ApplicationMainWindow* self,
                                                   ApplicationAccountContext* account);
static void _application_main_window_on_account_available_application_account_interface_account_available (ApplicationAccountInterface* _sender,
                                                                                                    ApplicationAccountContext* context,
                                                                                                    gboolean is_startup,
                                                                                                    gpointer self);
static void application_main_window_on_account_unavailable (ApplicationMainWindow* self,
                                                     ApplicationAccountContext* account,
                                                     gboolean is_shutdown);
static void _application_main_window_on_account_unavailable_application_account_interface_account_unavailable (ApplicationAccountInterface* _sender,
                                                                                                        ApplicationAccountContext* context,
                                                                                                        gboolean is_shutdown,
                                                                                                        gpointer self);
VALA_EXTERN GeeCollection* application_account_interface_get_account_contexts (ApplicationAccountInterface* self);
static void application_main_window_add_account (ApplicationMainWindow* self,
                                          ApplicationAccountContext* to_add);
static void application_main_window_on_offline_infobar_response (ApplicationMainWindow* self);
static void _application_main_window_on_offline_infobar_response_components_info_bar_response (ComponentsInfoBar* _sender,
                                                                                        gint response_id,
                                                                                        gpointer self);
static void application_main_window_on_auth_problem_retry (ApplicationMainWindow* self);
static void _application_main_window_on_auth_problem_retry_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void application_main_window_on_cert_problem_retry (ApplicationMainWindow* self);
static void _application_main_window_on_cert_problem_retry_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void application_main_window_on_show_mark_menu (ApplicationMainWindow* self);
static void _application_main_window_on_show_mark_menu_components_conversation_actions_mark_message_button_toggled (ComponentsConversationActions* _sender,
                                                                                                             gpointer self);
static void application_main_window_real_destroy (GtkWidget* base);
static ApplicationAccountContext* application_main_window_get_selected_account_context (ApplicationMainWindow* self);
static void application_main_window_on_service_problem_retry (ApplicationMainWindow* self);
static void _application_main_window_on_service_problem_retry_components_problem_report_info_bar_retry (ComponentsProblemReportInfoBar* _sender,
                                                                                                 gpointer self);
static void application_main_window_select_folder_data_free (gpointer _data);
static gboolean application_main_window_select_folder_co (ApplicationMainWindowSelectFolderData* _data_);
static void application_main_window_update_headerbar (ApplicationMainWindow* self);
static void _application_main_window_update_headerbar_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void application_main_window_close_conversation_monitor (ApplicationMainWindow* self,
                                                         GearyAppConversationMonitor* to_close);
static void application_main_window_select_account (ApplicationMainWindow* self,
                                             GearyAccount* account);
static void application_main_window_update_trash_action (ApplicationMainWindow* self);
static void application_main_window_open_conversation_monitor (ApplicationMainWindow* self,
                                                        GearyAppConversationMonitor* to_open,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void application_main_window_open_conversation_monitor_finish (ApplicationMainWindow* self,
                                                               GAsyncResult* _res_);
static void application_main_window_select_folder_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN void application_controller_process_pending_composers (ApplicationController* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN void application_controller_process_pending_composers_finish (ApplicationController* self,
                                                              GAsyncResult* _res_);
static void application_main_window_show_conversations_data_free (gpointer _data);
static gboolean application_main_window_show_conversations_co (ApplicationMainWindowShowConversationsData* _data_);
static void application_main_window_show_conversations_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void application_main_window_load_conversations_for_email (ApplicationMainWindow* self,
                                                           GearyFolder* location,
                                                           GeeCollection* to_load,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static GeeCollection* application_main_window_load_conversations_for_email_finish (ApplicationMainWindow* self,
                                                                            GAsyncResult* _res_);
static void application_main_window_select_conversations (ApplicationMainWindow* self,
                                                   GeeCollection* to_select,
                                                   GeeCollection* scroll_to,
                                                   gboolean is_interactive,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void application_main_window_select_conversations_finish (ApplicationMainWindow* self,
                                                          GAsyncResult* _res_);
static void application_main_window_show_email_data_free (gpointer _data);
static gboolean application_main_window_show_email_co (ApplicationMainWindowShowEmailData* _data_);
static void application_main_window_show_email_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN void application_main_window_show_composer (ApplicationMainWindow* self,
                                            ComposerWidget* composer);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean ____lambda161_ (Block15Data* _data15_,
                         GearyEmail* email);
static gboolean _____lambda161__gee_predicate (gconstpointer g,
                                        gpointer self);
VALA_EXTERN gboolean application_main_window_close_composer (ApplicationMainWindow* self,
                                                 gboolean should_prompt,
                                                 gboolean is_shutdown);
VALA_EXTERN void application_main_window_start_search (ApplicationMainWindow* self,
                                           const gchar* query_text,
                                           gboolean is_interactive);
static inline void application_main_window_handle_error (ApplicationMainWindow* self,
                                           GearyAccountInformation* account,
                                           GError* _error_);
VALA_EXTERN void application_main_window_stop_search (ApplicationMainWindow* self,
                                          gboolean is_interactive);
VALA_EXTERN gboolean application_main_window_select_first_inbox (ApplicationMainWindow* self,
                                                     gboolean is_interactive);
static GearyFolder* application_main_window_get_first_inbox (ApplicationMainWindow* self);
static void application_main_window_on_folders_available (ApplicationMainWindow* self,
                                                   GeeCollection* available);
static void _application_main_window_on_folders_available_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                                  GeeCollection* available,
                                                                                                  gpointer self);
static void application_main_window_on_folders_unavailable (ApplicationMainWindow* self,
                                                     GeeCollection* unavailable);
static void _application_main_window_on_folders_unavailable_application_account_context_folders_unavailable (ApplicationAccountContext* _sender,
                                                                                                      GeeCollection* unavailable,
                                                                                                      gpointer self);
static void application_main_window_on_command_execute (ApplicationMainWindow* self,
                                                 ApplicationCommand* command);
static void _application_main_window_on_command_execute_application_command_stack_executed (ApplicationCommandStack* _sender,
                                                                                     ApplicationCommand* command,
                                                                                     gpointer self);
static void application_main_window_on_command_undo (ApplicationMainWindow* self,
                                              ApplicationCommand* command);
static void _application_main_window_on_command_undo_application_command_stack_undone (ApplicationCommandStack* _sender,
                                                                                ApplicationCommand* command,
                                                                                gpointer self);
static void application_main_window_on_command_redo (ApplicationMainWindow* self,
                                              ApplicationCommand* command);
static void _application_main_window_on_command_redo_application_command_stack_redone (ApplicationCommandStack* _sender,
                                                                                ApplicationCommand* command,
                                                                                gpointer self);
static void application_main_window_add_folders (ApplicationMainWindow* self,
                                          GeeCollection* to_add);
static void application_main_window_remove_account_data_free (gpointer _data);
static void application_main_window_remove_account (ApplicationMainWindow* self,
                                             ApplicationAccountContext* to_remove,
                                             GearyFolder* to_select,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void application_main_window_remove_account_finish (ApplicationMainWindow* self,
                                                    GAsyncResult* _res_);
static gboolean application_main_window_remove_account_co (ApplicationMainWindowRemoveAccountData* _data_);
static void application_main_window_remove_account_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _application_main_window_on_folders_unavailable_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                                    GeeCollection* available,
                                                                                                    gpointer self);
static void application_main_window_remove_folders (ApplicationMainWindow* self,
                                             GeeCollection* to_remove,
                                             gboolean update_selecton);
static void application_main_window_on_use_changed (ApplicationMainWindow* self,
                                             GearyFolder* folder,
                                             GearyFolderSpecialUse old_type,
                                             GearyFolderSpecialUse new_type);
static void _application_main_window_on_use_changed_geary_folder_use_changed (GearyFolder* _sender,
                                                                       GearyFolderSpecialUse old_use,
                                                                       GearyFolderSpecialUse new_use,
                                                                       gpointer self);
VALA_EXTERN ApplicationAccountContext* application_account_interface_get_context_for_account (ApplicationAccountInterface* self,
                                                                                  GearyAccountInformation* account);
static gboolean application_main_window_real_window_state_event (GtkWidget* base,
                                                          GdkEventWindowState* event);
static void application_main_window_real_size_allocate (GtkWidget* base,
                                                 GtkAllocation* allocation);
static void application_main_window_on_has_toplevel_focus (ApplicationMainWindow* self);
static void _application_main_window_on_has_toplevel_focus_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void application_main_window_on_search (ApplicationMainWindow* self,
                                        const gchar* text);
static void _application_main_window_on_search_search_bar_search_text_changed (SearchBar* _sender,
                                                                        const gchar* search_text,
                                                                        gpointer self);
static void application_main_window_on_folder_selected (ApplicationMainWindow* self,
                                                 GearyFolder* folder);
static void _application_main_window_on_folder_selected_folder_list_tree_folder_selected (FolderListTree* _sender,
                                                                                   GearyFolder* folder,
                                                                                   gpointer self);
static void application_main_window_on_move_conversation (ApplicationMainWindow* self,
                                                   GearyFolder* destination);
static void _application_main_window_on_move_conversation_folder_list_tree_move_conversation (FolderListTree* _sender,
                                                                                       GearyFolder* folder,
                                                                                       gpointer self);
static void application_main_window_on_copy_conversation (ApplicationMainWindow* self,
                                                   GearyFolder* destination);
static void _application_main_window_on_copy_conversation_folder_list_tree_copy_conversation (FolderListTree* _sender,
                                                                                       GearyFolder* folder,
                                                                                       gpointer self);
static void application_main_window_on_folder_activated (ApplicationMainWindow* self,
                                                  GearyFolder* folder);
static void _application_main_window_on_folder_activated_folder_list_tree_folder_activated (FolderListTree* _sender,
                                                                                     GearyFolder* folder,
                                                                                     gpointer self);
static void application_main_window_on_load_more (ApplicationMainWindow* self);
static void _application_main_window_on_load_more_conversation_list_view_load_more (ConversationListView* _sender,
                                                                             gpointer self);
static void application_main_window_on_mark_conversations (ApplicationMainWindow* self,
                                                    GeeCollection* conversations,
                                                    GearyNamedFlag* flag);
static void _application_main_window_on_mark_conversations_conversation_list_view_mark_conversations (ConversationListView* _sender,
                                                                                               GeeCollection* conversations,
                                                                                               GearyNamedFlag* flag,
                                                                                               gpointer self);
static void application_main_window_on_conversations_selected (ApplicationMainWindow* self,
                                                        GeeSet* selected);
static void _application_main_window_on_conversations_selected_conversation_list_view_conversations_selected (ConversationListView* _sender,
                                                                                                       GeeSet* selected,
                                                                                                       gpointer self);
static void application_main_window_on_conversation_activated (ApplicationMainWindow* self,
                                                        GearyAppConversation* activated,
                                                        gboolean single);
static void _application_main_window_on_conversation_activated_conversation_list_view_conversation_activated (ConversationListView* _sender,
                                                                                                       GearyAppConversation* activated,
                                                                                                       gboolean single,
                                                                                                       gpointer self);
static void application_main_window_on_visible_conversations_changed (ApplicationMainWindow* self,
                                                               GeeSet* visible);
static void _application_main_window_on_visible_conversations_changed_conversation_list_view_visible_conversations_changed (ConversationListView* _sender,
                                                                                                                     GeeSet* visible,
                                                                                                                     gpointer self);
static void application_main_window_on_conversation_view_added (ApplicationMainWindow* self,
                                                         ConversationListBox* list);
static void _application_main_window_on_conversation_view_added_conversation_viewer_conversation_added (ConversationViewer* _sender,
                                                                                                 ConversationListBox* list,
                                                                                                 gpointer self);
static void __lambda201_ (ApplicationMainWindow* self);
static void ___lambda201__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void _vala_array_add8 (FolderPopover** * array,
                       gint* length,
                       gint* size,
                       FolderPopover* value);
static void _application_main_window_on_move_conversation_folder_popover_folder_selected (FolderPopover* _sender,
                                                                                   GearyFolder* folder,
                                                                                   gpointer self);
static void _vala_array_add9 (FolderPopover** * array,
                       gint* length,
                       gint* size,
                       FolderPopover* value);
static void _application_main_window_on_copy_conversation_folder_popover_folder_selected (FolderPopover* _sender,
                                                                                   GearyFolder* folder,
                                                                                   gpointer self);
static gboolean application_main_window_real_key_press_event (GtkWidget* base,
                                                       GdkEventKey* event);
static inline void application_main_window_check_shift_event (ApplicationMainWindow* self,
                                                GdkEventKey* event);
static gboolean application_main_window_real_key_release_event (GtkWidget* base,
                                                         GdkEventKey* event);
VALA_EXTERN gboolean application_main_window_prompt_empty_folder (ApplicationMainWindow* self,
                                                      GearyFolderSpecialUse type);
VALA_EXTERN GType alert_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType confirmation_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ConfirmationDialog* confirmation_dialog_new (GtkWindow* parent,
                                             const gchar* title,
                                             const gchar* description,
                                             const gchar* ok_button,
                                             const gchar* ok_action_type);
VALA_EXTERN ConfirmationDialog* confirmation_dialog_construct (GType object_type,
                                                   GtkWindow* parent,
                                                   const gchar* title,
                                                   const gchar* description,
                                                   const gchar* ok_button,
                                                   const gchar* ok_action_type);
VALA_EXTERN void alert_dialog_use_secondary_markup (AlertDialog* self,
                                        gboolean markup);
VALA_EXTERN void alert_dialog_set_focus_response (AlertDialog* self,
                                      GtkResponseType response);
VALA_EXTERN GtkResponseType alert_dialog_run (AlertDialog* self);
static void application_main_window_undo_data_free (gpointer _data);
static void application_main_window_undo (ApplicationMainWindow* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void application_main_window_undo_finish (ApplicationMainWindow* self,
                                          GAsyncResult* _res_);
static gboolean application_main_window_undo_co (ApplicationMainWindowUndoData* _data_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ___lambda183_ (Block16Data* _data16_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda183__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void application_main_window_redo_data_free (gpointer _data);
static void application_main_window_redo (ApplicationMainWindow* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void application_main_window_redo_finish (ApplicationMainWindow* self,
                                          GAsyncResult* _res_);
static gboolean application_main_window_redo_co (ApplicationMainWindowRedoData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void ___lambda184_ (Block17Data* _data17_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda184__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static GSimpleAction* application_main_window_get_edit_action (ApplicationMainWindow* self,
                                                        const gchar* name);
static gboolean application_main_window_prompt_delete_conversations (ApplicationMainWindow* self,
                                                              gint count);
static gboolean application_main_window_prompt_delete_messages (ApplicationMainWindow* self,
                                                         gint count);
static void application_main_window_load_conversations_for_email_data_free (gpointer _data);
static gboolean application_main_window_load_conversations_for_email_co (ApplicationMainWindowLoadConversationsForEmailData* _data_);
static void application_main_window_load_conversations_for_email_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
VALA_EXTERN GType composer_application_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void composer_application_interface_report_problem (ComposerApplicationInterface* self,
                                                    GearyProblemReport* report);
static void application_main_window_update_ui (ApplicationMainWindow* self);
static void application_main_window_select_conversations_data_free (gpointer _data);
static gboolean application_main_window_select_conversations_co (ApplicationMainWindowSelectConversationsData* _data_);
static void application_main_window_select_conversations_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void application_main_window_open_conversation_monitor_data_free (gpointer _data);
static gboolean application_main_window_open_conversation_monitor_co (ApplicationMainWindowOpenConversationMonitorData* _data_);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void application_main_window_on_scan_completed (ApplicationMainWindow* self,
                                                GearyAppConversationMonitor* monitor);
static void _application_main_window_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                               gpointer self);
static void application_main_window_on_scan_error (ApplicationMainWindow* self,
                                            GearyAppConversationMonitor* monitor,
                                            GError* err);
static void _application_main_window_on_scan_error_geary_app_conversation_monitor_scan_error (GearyAppConversationMonitor* _sender,
                                                                                       GError* err,
                                                                                       gpointer self);
static void application_main_window_on_conversation_count_changed (ApplicationMainWindow* self);
static void _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                                           gpointer self);
static void _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                                GeeCollection* conversations,
                                                                                                                gpointer self);
static void _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                                  GeeCollection* conversations,
                                                                                                                  gpointer self);
static void __lambda160_ (Block18Data* _data18_,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda160__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda158_ (Block19Data* _data19_,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda158__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void application_main_window_create_composer_data_free (gpointer _data);
static void application_main_window_create_composer (ApplicationMainWindow* self,
                                              GearyAccount* send_context,
                                              ComposerWidgetContextType type,
                                              GearyEmail* context,
                                              const gchar* quote,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void application_main_window_create_composer_finish (ApplicationMainWindow* self,
                                                     GAsyncResult* _res_);
static gboolean application_main_window_create_composer_co (ApplicationMainWindowCreateComposerData* _data_);
VALA_EXTERN void application_controller_compose_with_context (ApplicationController* self,
                                                  ApplicationAccountContext* send_context,
                                                  ComposerWidgetContextType type,
                                                  GearyEmail* context,
                                                  const gchar* quote,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN ComposerWidget* application_controller_compose_with_context_finish (ApplicationController* self,
                                                                    GAsyncResult* _res_);
static void application_main_window_create_composer_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN void application_controller_present_composer (ApplicationController* self,
                                              ComposerWidget* composer);
static void application_main_window_create_composer_from_viewer_data_free (gpointer _data);
static void application_main_window_create_composer_from_viewer (ApplicationMainWindow* self,
                                                          ComposerWidgetContextType type,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void application_main_window_create_composer_from_viewer_finish (ApplicationMainWindow* self,
                                                                 GAsyncResult* _res_);
static gboolean application_main_window_create_composer_from_viewer_co (ApplicationMainWindowCreateComposerFromViewerData* _data_);
static void application_main_window_create_composer_from_viewer_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void application_main_window_load_more (ApplicationMainWindow* self);
static void application_main_window_update_context_dependent_actions (ApplicationMainWindow* self,
                                                               gboolean sensitive,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void application_main_window_update_context_dependent_actions_finish (ApplicationMainWindow* self,
                                                                      GAsyncResult* _res_);
static void application_main_window_update_context_dependent_actions_data_free (gpointer _data);
static gboolean application_main_window_update_context_dependent_actions_co (ApplicationMainWindowUpdateContextDependentActionsData* _data_);
static void application_main_window_update_context_dependent_actions_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void application_main_window_set_shift_key_down (ApplicationMainWindow* self,
                                                 gboolean down);
static void application_main_window_on_map (ApplicationMainWindow* self);
static void _application_main_window_on_map_gtk_widget_map (GtkWidget* _sender,
                                                     gpointer self);
static void application_main_window_on_unmap (ApplicationMainWindow* self);
static void _application_main_window_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                         gpointer self);
static gboolean application_main_window_on_focus_event (ApplicationMainWindow* self);
static gboolean _application_main_window_on_focus_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                             GdkEventFocus* event,
                                                                             gpointer self);
static gboolean application_main_window_on_delete_event (ApplicationMainWindow* self);
static void ___lambda202_ (ApplicationMainWindow* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda202__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static gboolean _application_main_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                           GdkEventAny* event,
                                                                           gpointer self);
static void application_main_window_on_outer_leaflet_changed (ApplicationMainWindow* self);
static void _application_main_window_on_outer_leaflet_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void application_main_window_on_inner_leaflet_changed (ApplicationMainWindow* self);
static void _application_main_window_on_inner_leaflet_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void application_main_window_on_email_loaded (ApplicationMainWindow* self,
                                              ConversationListBox* view,
                                              GearyEmail* loaded);
static void _application_main_window_on_email_loaded_conversation_list_box_email_loaded (ConversationListBox* _sender,
                                                                                  GearyEmail* email,
                                                                                  gpointer self);
static void application_main_window_on_email_mark (ApplicationMainWindow* self,
                                            ConversationListBox* view,
                                            GeeCollection* messages,
                                            GearyNamedFlag* to_add,
                                            GearyNamedFlag* to_remove);
static void _application_main_window_on_email_mark_conversation_list_box_mark_email (ConversationListBox* _sender,
                                                                              GeeCollection* email,
                                                                              GearyNamedFlag* to_add,
                                                                              GearyNamedFlag* to_remove,
                                                                              gpointer self);
static void application_main_window_on_email_reply_to_all (ApplicationMainWindow* self,
                                                    GearyEmail* target,
                                                    const gchar* quote);
static void _application_main_window_on_email_reply_to_all_conversation_list_box_reply_to_all_email (ConversationListBox* _sender,
                                                                                              GearyEmail* email,
                                                                                              const gchar* quote,
                                                                                              gpointer self);
static void application_main_window_on_email_reply_to_sender (ApplicationMainWindow* self,
                                                       GearyEmail* target,
                                                       const gchar* quote);
static void _application_main_window_on_email_reply_to_sender_conversation_list_box_reply_to_sender_email (ConversationListBox* _sender,
                                                                                                    GearyEmail* email,
                                                                                                    const gchar* quote,
                                                                                                    gpointer self);
static void application_main_window_on_email_forward (ApplicationMainWindow* self,
                                               GearyEmail* target,
                                               const gchar* quote);
static void _application_main_window_on_email_forward_conversation_list_box_forward_email (ConversationListBox* _sender,
                                                                                    GearyEmail* email,
                                                                                    const gchar* quote,
                                                                                    gpointer self);
static void application_main_window_on_email_trash (ApplicationMainWindow* self,
                                             ConversationListBox* view,
                                             GearyEmail* target);
static void _application_main_window_on_email_trash_conversation_list_box_trash_email (ConversationListBox* _sender,
                                                                                GearyEmail* email,
                                                                                gpointer self);
static void application_main_window_on_email_delete (ApplicationMainWindow* self,
                                              ConversationListBox* view,
                                              GearyEmail* target);
static void _application_main_window_on_email_delete_conversation_list_box_delete_email (ConversationListBox* _sender,
                                                                                  GearyEmail* email,
                                                                                  gpointer self);
VALA_EXTERN void application_controller_clear_new_messages (ApplicationController* self,
                                                GearyFolder* source,
                                                GeeSet* visible);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_mark_conversations (ApplicationController* self,
                                                GearyFolder* location,
                                                GeeCollection* conversations,
                                                GearyNamedFlag* flag,
                                                gboolean prefer_adding,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void application_controller_mark_conversations_finish (ApplicationController* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ___lambda197_ (Block20Data* _data20_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda197__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void ___lambda188_ (Block21Data* _data21_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda188__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void ___lambda189_ (Block22Data* _data22_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda189__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ___lambda190_ (Block23Data* _data23_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda190__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void ___lambda191_ (Block24Data* _data24_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda191__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_move_conversations_special (ApplicationController* self,
                                                        GearyFolder* source,
                                                        GearyFolderSpecialUse destination,
                                                        GeeCollection* conversations,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN void application_controller_move_conversations_special_finish (ApplicationController* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static void ___lambda192_ (Block25Data* _data25_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda192__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_move_conversations (ApplicationController* self,
                                                GearyFolderSupportMove* source,
                                                GearyFolder* destination,
                                                GeeCollection* conversations,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void application_controller_move_conversations_finish (ApplicationController* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ___lambda195_ (Block26Data* _data26_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda195__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_copy_conversations (ApplicationController* self,
                                                GearyFolderSupportCopy* source,
                                                GearyFolder* destination,
                                                GeeCollection* conversations,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void application_controller_copy_conversations_finish (ApplicationController* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ___lambda196_ (Block27Data* _data27_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda196__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void ___lambda185_ (Block28Data* _data28_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda185__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void ___lambda186_ (Block29Data* _data29_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda186__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_delete_conversations (ApplicationController* self,
                                                  GearyFolderSupportRemove* target,
                                                  GeeCollection* conversations,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void application_controller_delete_conversations_finish (ApplicationController* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void ___lambda187_ (Block30Data* _data30_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda187__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN void application_controller_email_loaded (ApplicationController* self,
                                          GearyAccountInformation* account,
                                          GearyEmail* loaded);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_mark_messages (ApplicationController* self,
                                           GearyFolder* location,
                                           GeeCollection* conversations,
                                           GeeCollection* messages,
                                           GearyEmailFlags* to_add,
                                           GearyEmailFlags* to_remove,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void application_controller_mark_messages_finish (ApplicationController* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void ___lambda198_ (Block31Data* _data31_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda198__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_move_messages_special (ApplicationController* self,
                                                   GearyFolder* source,
                                                   GearyFolderSpecialUse destination,
                                                   GeeCollection* conversations,
                                                   GeeCollection* messages,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void application_controller_move_messages_special_finish (ApplicationController* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static void ___lambda199_ (Block32Data* _data32_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda199__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
VALA_EXTERN void application_controller_delete_messages (ApplicationController* self,
                                             GearyFolderSupportRemove* target,
                                             GeeCollection* conversations,
                                             GeeCollection* messages,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void application_controller_delete_messages_finish (ApplicationController* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ___lambda200_ (Block33Data* _data33_,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda200__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void application_main_window_finalize (GObject * obj);
static GType application_main_window_get_type_once (void);
static void _vala_application_main_window_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_application_main_window_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_MAIN_WINDOW_EDIT_ACTIONS[2] = {{ACTION_EDIT_UNDO, _application_main_window_on_undo_gsimple_action_activate_callback}, {ACTION_EDIT_REDO, _application_main_window_on_redo_gsimple_action_activate_callback}};
static const GActionEntry APPLICATION_MAIN_WINDOW_WINDOW_ACTIONS[23] = {{ACTION_WINDOW_CLOSE, _application_main_window_on_close_gsimple_action_activate_callback}, {ACTION_WINDOW_SHOW_HELP_OVERLAY, _application_main_window_on_show_help_overlay_gsimple_action_activate_callback}, {ACTION_WINDOW_SHOW_MENU, _application_main_window_on_show_window_menu_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_FIND_IN_CONVERSATION, _application_main_window_on_find_in_conversation_action_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_SEARCH, _application_main_window_on_search_activated_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_SELECT_INBOX, _application_main_window_on_select_inbox_gsimple_action_activate_callback, "i"}, {APPLICATION_MAIN_WINDOW_ACTION_NAVIGATION_BACK, _application_main_window_focus_previous_pane_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_REPLY_CONVERSATION, _application_main_window_on_reply_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_REPLY_ALL_CONVERSATION, _application_main_window_on_reply_all_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_FORWARD_CONVERSATION, _application_main_window_on_forward_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_ARCHIVE_CONVERSATION, _application_main_window_on_archive_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION, _application_main_window_on_trash_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION, _application_main_window_on_delete_conversation_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_SHOW_COPY_MENU, _application_main_window_on_show_copy_menu_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_SHOW_MOVE_MENU, _application_main_window_on_show_move_menu_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_CONVERSATION_UP, _application_main_window_on_conversation_up_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_CONVERSATION_DOWN, _application_main_window_on_conversation_down_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_READ, _application_main_window_on_mark_as_read_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNREAD, _application_main_window_on_mark_as_unread_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_STARRED, _application_main_window_on_mark_as_starred_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNSTARRED, _application_main_window_on_mark_as_unstarred_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_TOGGLE_JUNK, _application_main_window_on_mark_as_junk_toggle_gsimple_action_activate_callback}, {APPLICATION_MAIN_WINDOW_ACTION_ZOOM, _application_main_window_on_zoom_gsimple_action_activate_callback, "s"}};

static inline gpointer
application_main_window_get_instance_private (ApplicationMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationMainWindow_private_offset);
}

static ApplicationMainWindowConversationCount
application_main_window_conversation_count_for_size (gint size)
{
	ApplicationMainWindowConversationCount _tmp0_ = 0;
	ApplicationMainWindowConversationCount result;
	if (size == 0) {
		_tmp0_ = APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE;
	} else {
		ApplicationMainWindowConversationCount _tmp1_ = 0;
		if (size == 1) {
			_tmp1_ = APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE;
		} else {
			_tmp1_ = APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static GType
application_main_window_conversation_count_get_type_once (void)
{
	static const GEnumValue values[] = {{APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE, "APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE", "none"}, {APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE, "APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE", "single"}, {APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE, "APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE", "multiple"}, {0, NULL, NULL}};
	GType application_main_window_conversation_count_type_id;
	application_main_window_conversation_count_type_id = g_enum_register_static ("ApplicationMainWindowConversationCount", values);
	return application_main_window_conversation_count_type_id;
}

static GType
application_main_window_conversation_count_get_type (void)
{
	static volatile gsize application_main_window_conversation_count_type_id__once = 0;
	if (g_once_init_enter (&application_main_window_conversation_count_type_id__once)) {
		GType application_main_window_conversation_count_type_id;
		application_main_window_conversation_count_type_id = application_main_window_conversation_count_get_type_once ();
		g_once_init_leave (&application_main_window_conversation_count_type_id__once, application_main_window_conversation_count_type_id);
	}
	return application_main_window_conversation_count_type_id__once;
}

static void
_application_main_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	application_main_window_on_undo ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	application_main_window_on_redo ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	application_main_window_on_close ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_show_help_overlay_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	application_main_window_on_show_help_overlay ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_show_window_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	application_main_window_on_show_window_menu ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_find_in_conversation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                          GVariant* parameter,
                                                                                          gpointer self)
{
	application_main_window_on_find_in_conversation_action ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_search_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	application_main_window_on_search_activated ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_select_inbox_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	application_main_window_on_select_inbox ((ApplicationMainWindow*) self, action, parameter);
}

static void
_application_main_window_focus_previous_pane_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	application_main_window_focus_previous_pane ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_reply_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	application_main_window_on_reply_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_reply_all_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self)
{
	application_main_window_on_reply_all_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_forward_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	application_main_window_on_forward_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_archive_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	application_main_window_on_archive_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_trash_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	application_main_window_on_trash_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_delete_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self)
{
	application_main_window_on_delete_conversation ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_show_copy_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	application_main_window_on_show_copy_menu ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_show_move_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	application_main_window_on_show_move_menu ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_conversation_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	application_main_window_on_conversation_up ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_conversation_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	application_main_window_on_conversation_down ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_as_read_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	application_main_window_on_mark_as_read ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_as_unread_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	application_main_window_on_mark_as_unread ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_as_starred_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	application_main_window_on_mark_as_starred ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_as_unstarred_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	application_main_window_on_mark_as_unstarred ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_as_junk_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self)
{
	application_main_window_on_mark_as_junk_toggle ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_zoom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	application_main_window_on_zoom ((ApplicationMainWindow*) self, action, parameter);
}

void
application_main_window_add_accelerators (ApplicationClient* owner)
{
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	g_return_if_fail (APPLICATION_IS_CLIENT (owner));
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i <= 9)) {
					break;
				}
				_tmp2_ = g_strdup_printf ("(%d)", i - 1);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat (APPLICATION_MAIN_WINDOW_ACTION_SELECT_INBOX, _tmp3_, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strdup_printf ("<ALT>%d", i);
				_tmp7_ = g_new0 (gchar*, 1 + 1);
				_tmp7_[0] = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp8__length1 = 1;
				application_client_add_window_accelerators (owner, _tmp5_, _tmp8_, (gint) 1, NULL);
				_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
			}
		}
	}
	_tmp9_ = g_strdup ("<Ctrl>equal");
	_tmp10_ = g_strdup ("<Ctrl>plus");
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	application_client_add_window_accelerators (owner, APPLICATION_MAIN_WINDOW_ACTION_ZOOM "('in')", _tmp12_, (gint) 2, NULL);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Ctrl>minus");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	application_client_add_window_accelerators (owner, APPLICATION_MAIN_WINDOW_ACTION_ZOOM "('out')", _tmp15_, (gint) 1, NULL);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("<Ctrl>0");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	application_client_add_window_accelerators (owner, APPLICATION_MAIN_WINDOW_ACTION_ZOOM "('normal')", _tmp18_, (gint) 1, NULL);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
}

ApplicationClient*
application_main_window_get_application (ApplicationMainWindow* self)
{
	ApplicationClient* result;
	GtkApplication* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_window_get_type (), GtkWindow));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, APPLICATION_TYPE_CLIENT, ApplicationClient);
	return result;
}

void
application_main_window_set_application (ApplicationMainWindow* self,
                                         ApplicationClient* value)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (value, gtk_application_get_type (), GtkApplication));
	g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY]);
}

GearyAccount*
application_main_window_get_selected_account (ApplicationMainWindow* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_selected_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_main_window_set_selected_account (ApplicationMainWindow* self,
                                              GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_selected_account (self);
	if (old_value != value) {
		GearyAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_account);
		self->priv->_selected_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY]);
	}
}

GearyFolder*
application_main_window_get_selected_folder (ApplicationMainWindow* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_selected_folder;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_selected_folder (ApplicationMainWindow* self,
                                             GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_selected_folder (self);
	if (old_value != value) {
		GearyFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_folder);
		self->priv->_selected_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY]);
	}
}

GearyAppConversationMonitor*
application_main_window_get_conversations (ApplicationMainWindow* self)
{
	GearyAppConversationMonitor* result;
	GearyAppConversationMonitor* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_conversations;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_conversations (ApplicationMainWindow* self,
                                           GearyAppConversationMonitor* value)
{
	GearyAppConversationMonitor* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_conversations (self);
	if (old_value != value) {
		GearyAppConversationMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_conversations);
		self->priv->_conversations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY]);
	}
}

gboolean
application_main_window_get_is_folder_list_shown (ApplicationMainWindow* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	HdyLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp2_ = self->priv->outer_leaflet;
	_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		HdyLeaflet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->outer_leaflet;
		_tmp6_ = hdy_leaflet_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp7_, APPLICATION_MAIN_WINDOW_INNER_LEAFLET) == 0;
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		HdyLeaflet* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->inner_leaflet;
		_tmp10_ = hdy_leaflet_get_folded (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			_tmp8_ = TRUE;
		} else {
			HdyLeaflet* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->inner_leaflet;
			_tmp13_ = hdy_leaflet_get_visible_child_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = g_strcmp0 (_tmp14_, APPLICATION_MAIN_WINDOW_FOLDER_LIST) == 0;
		}
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
application_main_window_get_is_conversation_list_shown (ApplicationMainWindow* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	HdyLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp2_ = self->priv->outer_leaflet;
	_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		HdyLeaflet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->outer_leaflet;
		_tmp6_ = hdy_leaflet_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp7_, APPLICATION_MAIN_WINDOW_INNER_LEAFLET) == 0;
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		HdyLeaflet* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->inner_leaflet;
		_tmp10_ = hdy_leaflet_get_folded (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			_tmp8_ = TRUE;
		} else {
			HdyLeaflet* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->inner_leaflet;
			_tmp13_ = hdy_leaflet_get_visible_child_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = g_strcmp0 (_tmp14_, APPLICATION_MAIN_WINDOW_CONVERSATION_LIST) == 0;
		}
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
application_main_window_get_is_conversation_viewer_shown (ApplicationMainWindow* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	HdyLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp2_ = self->priv->outer_leaflet;
	_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		HdyLeaflet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->outer_leaflet;
		_tmp6_ = hdy_leaflet_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp7_, APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER) == 0;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = application_main_window_get_has_composer (self);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

ApplicationAttachmentManager*
application_main_window_get_attachments (ApplicationMainWindow* self)
{
	ApplicationAttachmentManager* result;
	ApplicationAttachmentManager* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_attachments;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_attachments (ApplicationMainWindow* self,
                                         ApplicationAttachmentManager* value)
{
	ApplicationAttachmentManager* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_attachments (self);
	if (old_value != value) {
		ApplicationAttachmentManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attachments);
		self->priv->_attachments = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY]);
	}
}

gboolean
application_main_window_get_selected_folder_supports_trash (ApplicationMainWindow* self)
{
	gboolean result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp0_ = self->priv->_selected_folder;
	result = application_controller_does_folder_support_trash (_tmp0_);
	return result;
}

gboolean
application_main_window_get_has_composer (ApplicationMainWindow* self)
{
	gboolean result;
	ConversationViewer* _tmp0_;
	ComposerWidget* _tmp1_;
	ComposerWidget* _tmp2_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp0_ = self->priv->_conversation_viewer;
	_tmp1_ = conversation_viewer_get_current_composer (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != NULL;
	return result;
}

gboolean
application_main_window_get_is_shift_down (ApplicationMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	result = self->priv->_is_shift_down;
	return result;
}

static void
application_main_window_set_is_shift_down (ApplicationMainWindow* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_is_shift_down (self);
	if (old_value != value) {
		self->priv->_is_shift_down = value;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY]);
	}
}

gint
application_main_window_get_window_width (ApplicationMainWindow* self)
{
	gint result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), 0);
	result = self->priv->_window_width;
	return result;
}

void
application_main_window_set_window_width (ApplicationMainWindow* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_window_width (self);
	if (old_value != value) {
		self->priv->_window_width = value;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY]);
	}
}

gint
application_main_window_get_window_height (ApplicationMainWindow* self)
{
	gint result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), 0);
	result = self->priv->_window_height;
	return result;
}

void
application_main_window_set_window_height (ApplicationMainWindow* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_window_height (self);
	if (old_value != value) {
		self->priv->_window_height = value;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY]);
	}
}

gboolean
application_main_window_get_window_maximized (ApplicationMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	result = self->priv->_window_maximized;
	return result;
}

void
application_main_window_set_window_maximized (ApplicationMainWindow* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_window_maximized (self);
	if (old_value != value) {
		self->priv->_window_maximized = value;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY]);
	}
}

FolderListTree*
application_main_window_get_folder_list (ApplicationMainWindow* self)
{
	FolderListTree* result;
	FolderListTree* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_folder_list;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_folder_list (ApplicationMainWindow* self,
                                         FolderListTree* value)
{
	FolderListTree* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_folder_list (self);
	if (old_value != value) {
		FolderListTree* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder_list);
		self->priv->_folder_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY]);
	}
}

SearchBar*
application_main_window_get_search_bar (ApplicationMainWindow* self)
{
	SearchBar* result;
	SearchBar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_search_bar;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_search_bar (ApplicationMainWindow* self,
                                        SearchBar* value)
{
	SearchBar* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_search_bar (self);
	if (old_value != value) {
		SearchBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_bar);
		self->priv->_search_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY]);
	}
}

ConversationListView*
application_main_window_get_conversation_list_view (ApplicationMainWindow* self)
{
	ConversationListView* result;
	ConversationListView* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_conversation_list_view;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_conversation_list_view (ApplicationMainWindow* self,
                                                    ConversationListView* value)
{
	ConversationListView* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_conversation_list_view (self);
	if (old_value != value) {
		ConversationListView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_conversation_list_view);
		self->priv->_conversation_list_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY]);
	}
}

ConversationViewer*
application_main_window_get_conversation_viewer (ApplicationMainWindow* self)
{
	ConversationViewer* result;
	ConversationViewer* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_conversation_viewer;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_conversation_viewer (ApplicationMainWindow* self,
                                                 ConversationViewer* value)
{
	ConversationViewer* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_conversation_viewer (self);
	if (old_value != value) {
		ConversationViewer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_conversation_viewer);
		self->priv->_conversation_viewer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY]);
	}
}

ComponentsInfoBarStack*
application_main_window_get_conversation_list_info_bars (ApplicationMainWindow* self)
{
	ComponentsInfoBarStack* result;
	ComponentsInfoBarStack* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_conversation_list_info_bars;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_conversation_list_info_bars (ApplicationMainWindow* self,
                                                         ComponentsInfoBarStack* value)
{
	ComponentsInfoBarStack* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_conversation_list_info_bars (self);
	if (old_value != value) {
		ComponentsInfoBarStack* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_conversation_list_info_bars);
		self->priv->_conversation_list_info_bars = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY]);
	}
}

StatusBar*
application_main_window_get_status_bar (ApplicationMainWindow* self)
{
	StatusBar* result;
	StatusBar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_status_bar;
	result = _tmp0_;
	return result;
}

static void
application_main_window_set_status_bar (ApplicationMainWindow* self,
                                        StatusBar* value)
{
	StatusBar* old_value;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	old_value = application_main_window_get_status_bar (self);
	if (old_value != value) {
		StatusBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_status_bar);
		self->priv->_status_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_main_window_properties[APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY]);
	}
}

static void
application_main_window_real_reply_conversation_sender (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_REPLY_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_reply_conversation_all (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_REPLY_ALL_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_forward_conversation (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_FORWARD_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_mark_conversations_read (ApplicationMainWindow* self,
                                                      gboolean prefer_read)
{
	GSimpleAction* _tmp0_ = NULL;
	if (prefer_read) {
		GSimpleAction* _tmp1_;
		_tmp1_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_READ);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GSimpleAction* _tmp2_;
		_tmp2_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNREAD);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp0_);
}

static void
application_main_window_real_mark_conversations_starred (ApplicationMainWindow* self,
                                                         gboolean prefer_starred)
{
	GSimpleAction* _tmp0_ = NULL;
	if (prefer_starred) {
		GSimpleAction* _tmp1_;
		_tmp1_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_STARRED);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GSimpleAction* _tmp2_;
		_tmp2_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNSTARRED);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp0_);
}

static void
application_main_window_real_show_copy_menu (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_COPY_MENU);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_show_move_menu (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_MOVE_MENU);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_archive_conversations (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_ARCHIVE_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_junk_conversations (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_TOGGLE_JUNK);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_trash_conversations (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_ = NULL;
	gboolean _tmp1_;
	_tmp1_ = self->priv->_is_shift_down;
	if (!_tmp1_) {
		GSimpleAction* _tmp2_;
		_tmp2_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GSimpleAction* _tmp3_;
		_tmp3_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp0_);
}

static void
application_main_window_real_delete_conversations (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_search (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_SEARCH);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_find (ApplicationMainWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_FIND_IN_CONVERSATION);
	_tmp1_ = _tmp0_;
	application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_real_navigate (ApplicationMainWindow* self,
                                       GtkScrollType type)
{
	switch (type) {
		case GTK_SCROLL_PAGE_LEFT:
		{
			if (gtk_widget_get_direction (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) != GTK_TEXT_DIR_RTL) {
				application_main_window_focus_previous_pane (self);
			} else {
				application_main_window_focus_next_pane (self);
			}
			break;
		}
		case GTK_SCROLL_PAGE_RIGHT:
		{
			if (gtk_widget_get_direction (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) != GTK_TEXT_DIR_RTL) {
				application_main_window_focus_next_pane (self);
			} else {
				application_main_window_focus_previous_pane (self);
			}
			break;
		}
		case GTK_SCROLL_STEP_UP:
		{
			GSimpleAction* _tmp0_;
			GSimpleAction* _tmp1_;
			_tmp0_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_CONVERSATION_UP);
			_tmp1_ = _tmp0_;
			application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction));
			_g_object_unref0 (_tmp1_);
			break;
		}
		case GTK_SCROLL_STEP_DOWN:
		{
			GSimpleAction* _tmp2_;
			GSimpleAction* _tmp3_;
			_tmp2_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_CONVERSATION_DOWN);
			_tmp3_ = _tmp2_;
			application_main_window_activate_action (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_get_type (), GAction));
			_g_object_unref0 (_tmp3_);
			break;
		}
		default:
		{
			gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			break;
		}
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->application);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static gboolean
__lambda193_ (Block14Data* _data14_,
              GtkWidget* w,
              GdkEventFocus* e)
{
	ApplicationMainWindow* self;
	ApplicationController* _tmp0_;
	ApplicationController* _tmp1_;
	gboolean result;
	self = _data14_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = application_client_get_controller (_data14_->application);
	_tmp1_ = _tmp0_;
	application_controller_window_focus_in (_tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda193__gtk_widget_focus_in_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda193_ (self, _sender, event);
	return result;
}

static gboolean
__lambda194_ (Block14Data* _data14_,
              GtkWidget* w,
              GdkEventFocus* e)
{
	ApplicationMainWindow* self;
	ApplicationController* _tmp0_;
	ApplicationController* _tmp1_;
	gboolean result;
	self = _data14_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = application_client_get_controller (_data14_->application);
	_tmp1_ = _tmp0_;
	application_controller_window_focus_out (_tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda194__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda194_ (self, _sender, event);
	return result;
}

static void
_application_main_window_on_update_ui_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                  gpointer self)
{
	application_main_window_on_update_ui_timeout ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_account_available_application_account_interface_account_available (ApplicationAccountInterface* _sender,
                                                                                               ApplicationAccountContext* context,
                                                                                               gboolean is_startup,
                                                                                               gpointer self)
{
	application_main_window_on_account_available ((ApplicationMainWindow*) self, context);
}

static void
_application_main_window_on_account_unavailable_application_account_interface_account_unavailable (ApplicationAccountInterface* _sender,
                                                                                                   ApplicationAccountContext* context,
                                                                                                   gboolean is_shutdown,
                                                                                                   gpointer self)
{
	application_main_window_on_account_unavailable ((ApplicationMainWindow*) self, context, is_shutdown);
}

static void
_application_main_window_on_offline_infobar_response_components_info_bar_response (ComponentsInfoBar* _sender,
                                                                                   gint response_id,
                                                                                   gpointer self)
{
	application_main_window_on_offline_infobar_response ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_auth_problem_retry_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	application_main_window_on_auth_problem_retry ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_cert_problem_retry_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	application_main_window_on_cert_problem_retry ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_show_mark_menu_components_conversation_actions_mark_message_button_toggled (ComponentsConversationActions* _sender,
                                                                                                        gpointer self)
{
	application_main_window_on_show_mark_menu ((ApplicationMainWindow*) self);
}

ApplicationMainWindow*
application_main_window_construct (GType object_type,
                                   ApplicationClient* application)
{
	ApplicationMainWindow * self = NULL;
	Block14Data* _data14_;
	ApplicationClient* _tmp0_;
	ApplicationController* _tmp1_;
	ApplicationController* _tmp2_;
	ApplicationController* _tmp3_;
	GtkWindowGroup* group = NULL;
	GtkWindowGroup* _tmp4_;
	GtkWindowGroup* _tmp5_;
	ApplicationConfiguration* _tmp6_;
	ApplicationConfiguration* _tmp7_;
	ComponentsInfoBarStack* _tmp9_;
	ComponentsInfoBarStack* _tmp10_;
	GSimpleActionGroup* _tmp11_;
	GSimpleActionGroup* _tmp12_;
	ApplicationConfiguration* _tmp13_;
	ApplicationConfiguration* _tmp14_;
	GtkBox* _tmp15_;
	StatusBar* _tmp16_;
	ApplicationAttachmentManager* _tmp17_;
	ApplicationAttachmentManager* _tmp18_;
	GearyTimeoutManager* _tmp19_;
	GearyTimeoutManager* _tmp20_;
	ApplicationController* _tmp21_;
	ApplicationController* _tmp22_;
	ComponentsInfoBar* _tmp32_;
	ComponentsInfoBar* _tmp33_;
	ComponentsInfoBar* _tmp34_;
	ComponentsInfoBar* _tmp35_;
	GtkButton* auth_retry = NULL;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	ComponentsInfoBar* _tmp40_;
	GtkBox* _tmp41_;
	GtkBox* _tmp42_;
	GtkButton* _tmp43_;
	ComponentsInfoBar* _tmp44_;
	GtkButton* cert_retry = NULL;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	ComponentsInfoBar* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkButton* _tmp52_;
	ConversationListView* _tmp53_;
	ComponentsConversationActions** _tmp54_;
	gint _tmp54__length1;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (application), NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (application);
	_g_object_unref0 (_data14_->application);
	_data14_->application = _tmp0_;
	self = (ApplicationMainWindow*) g_object_new (object_type, "application", _data14_->application, "show-menubar", FALSE, NULL);
	_data14_->self = g_object_ref (self);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_tmp1_ = application_client_get_controller (_data14_->application);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp3_;
	_tmp4_ = gtk_window_group_new ();
	group = _tmp4_;
	_tmp5_ = group;
	gtk_window_group_add_window (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp6_ = application_client_get_config (_data14_->application);
	_tmp7_ = _tmp6_;
	application_main_window_load_config (self, _tmp7_);
	application_main_window_restore_saved_window_state (self);
	if (g_strcmp0 (_PROFILE, APPLICATION_CLIENT_PROFILE_RELEASE) != 0) {
		GtkStyleContext* _tmp8_;
		_tmp8_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp8_, "devel");
	}
	_tmp9_ = self->priv->info_bars;
	gtk_frame_set_shadow_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_frame_get_type (), GtkFrame), GTK_SHADOW_IN);
	_tmp10_ = self->priv->_conversation_list_info_bars;
	gtk_frame_set_shadow_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_frame_get_type (), GtkFrame), GTK_SHADOW_IN);
	_tmp11_ = self->priv->edit_actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_action_map_get_type (), GActionMap), APPLICATION_MAIN_WINDOW_EDIT_ACTIONS, (gint) G_N_ELEMENTS (APPLICATION_MAIN_WINDOW_EDIT_ACTIONS), self);
	_tmp12_ = self->priv->edit_actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), ACTION_EDIT_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_action_group_get_type (), GActionGroup));
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), APPLICATION_MAIN_WINDOW_WINDOW_ACTIONS, (gint) G_N_ELEMENTS (APPLICATION_MAIN_WINDOW_WINDOW_ACTIONS), self);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-in-event", (GCallback) ___lambda193__gtk_widget_focus_in_event, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) ___lambda194__gtk_widget_focus_out_event, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp13_ = application_client_get_config (_data14_->application);
	_tmp14_ = _tmp13_;
	application_main_window_setup_layout (self, _tmp14_);
	_tmp15_ = self->priv->folder_box;
	_tmp16_ = self->priv->_status_bar;
	gtk_box_pack_start (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	application_main_window_update_command_actions (self);
	application_main_window_update_conversation_actions (self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE);
	_tmp17_ = application_attachment_manager_new (self);
	_tmp18_ = _tmp17_;
	application_main_window_set_attachments (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = geary_timeout_manager_new_seconds ((guint) APPLICATION_MAIN_WINDOW_UPDATE_UI_INTERVAL, _application_main_window_on_update_ui_timeout_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->update_ui_timeout);
	self->priv->update_ui_timeout = _tmp19_;
	_tmp20_ = self->priv->update_ui_timeout;
	_tmp20_->repetition = GEARY_TIMEOUT_MANAGER_REPEAT_FOREVER;
	_tmp21_ = self->priv->controller;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), "account-available", (GCallback) _application_main_window_on_account_available_application_account_interface_account_available, self, 0);
	_tmp22_ = self->priv->controller;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), "account-unavailable", (GCallback) _application_main_window_on_account_unavailable_application_account_interface_account_unavailable, self, 0);
	{
		GeeIterator* _context_it = NULL;
		ApplicationController* _tmp23_;
		GeeCollection* _tmp24_;
		GeeCollection* _tmp25_;
		GeeIterator* _tmp26_;
		GeeIterator* _tmp27_;
		_tmp23_ = self->priv->controller;
		_tmp24_ = application_account_interface_get_account_contexts (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface));
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_context_it = _tmp27_;
		while (TRUE) {
			GeeIterator* _tmp28_;
			ApplicationAccountContext* context = NULL;
			GeeIterator* _tmp29_;
			gpointer _tmp30_;
			ApplicationAccountContext* _tmp31_;
			_tmp28_ = _context_it;
			if (!gee_iterator_next (_tmp28_)) {
				break;
			}
			_tmp29_ = _context_it;
			_tmp30_ = gee_iterator_get (_tmp29_);
			context = (ApplicationAccountContext*) _tmp30_;
			_tmp31_ = context;
			application_main_window_add_account (self, _tmp31_);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	_tmp32_ = components_info_bar_new (_ ("Working offline"), _ ("You will not be able to send or receive email until re-connected."));
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->offline_infobar);
	self->priv->offline_infobar = _tmp32_;
	_tmp33_ = self->priv->offline_infobar;
	components_info_bar_set_show_close_button (_tmp33_, TRUE);
	_tmp34_ = self->priv->offline_infobar;
	g_signal_connect_object (_tmp34_, "response", (GCallback) _application_main_window_on_offline_infobar_response_components_info_bar_response, self, 0);
	_tmp35_ = components_info_bar_new (_ ("Login problem"), _ ("An account has reported an incorrect login or password."));
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->auth_problem_infobar);
	self->priv->auth_problem_infobar = _tmp35_;
	_tmp36_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp36_);
	auth_retry = _tmp36_;
	_tmp37_ = auth_retry;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	_tmp38_ = auth_retry;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), _ ("Retry login, you will be prompted for your password"));
	_tmp39_ = auth_retry;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) _application_main_window_on_auth_problem_retry_gtk_button_clicked, self, 0);
	_tmp40_ = self->priv->auth_problem_infobar;
	_tmp41_ = components_info_bar_get_action_area (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = auth_retry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp42_);
	_tmp44_ = components_info_bar_new (_ ("Security problem"), _ ("An account has reported an untrusted server."));
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->cert_problem_infobar);
	self->priv->cert_problem_infobar = _tmp44_;
	_tmp45_ = (GtkButton*) gtk_button_new_with_label (_ ("Check"));
	g_object_ref_sink (_tmp45_);
	cert_retry = _tmp45_;
	_tmp46_ = cert_retry;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget));
	_tmp47_ = cert_retry;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), _ ("Check the security details for the connection"));
	_tmp48_ = cert_retry;
	g_signal_connect_object (_tmp48_, "clicked", (GCallback) _application_main_window_on_cert_problem_retry_gtk_button_clicked, self, 0);
	_tmp49_ = self->priv->cert_problem_infobar;
	_tmp50_ = components_info_bar_get_action_area (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = cert_retry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp51_);
	_tmp53_ = self->priv->_conversation_list_view;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	_tmp54_ = self->priv->folder_conversation_actions;
	_tmp54__length1 = self->priv->folder_conversation_actions_length1;
	{
		ComponentsConversationActions** actions_collection = NULL;
		gint actions_collection_length1 = 0;
		gint _actions_collection_size_ = 0;
		gint actions_it = 0;
		actions_collection = _tmp54_;
		actions_collection_length1 = _tmp54__length1;
		for (actions_it = 0; actions_it < actions_collection_length1; actions_it = actions_it + 1) {
			ComponentsConversationActions* _tmp55_;
			ComponentsConversationActions* actions = NULL;
			_tmp55_ = _g_object_ref0 (actions_collection[actions_it]);
			actions = _tmp55_;
			{
				ComponentsConversationActions* _tmp56_;
				_tmp56_ = actions;
				g_signal_connect_object (_tmp56_, "mark-message-button-toggled", (GCallback) _application_main_window_on_show_mark_menu_components_conversation_actions_mark_message_button_toggled, self, 0);
				_g_object_unref0 (actions);
			}
		}
	}
	_g_object_unref0 (cert_retry);
	_g_object_unref0 (auth_retry);
	_g_object_unref0 (group);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return self;
}

ApplicationMainWindow*
application_main_window_new (ApplicationClient* application)
{
	return application_main_window_construct (APPLICATION_TYPE_MAIN_WINDOW, application);
}

/** {@inheritDoc} */
static void
application_main_window_real_destroy (GtkWidget* base)
{
	ApplicationMainWindow * self;
	ApplicationClient* _tmp0_;
	ApplicationClient* _tmp1_;
	GearyTimeoutManager* _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	_tmp0_ = application_main_window_get_application (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ApplicationController* _tmp2_;
		guint _tmp3_;
		ApplicationController* _tmp4_;
		guint _tmp5_;
		_tmp2_ = self->priv->controller;
		g_signal_parse_name ("account-available", APPLICATION_TYPE_ACCOUNT_INTERFACE, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _application_main_window_on_account_available_application_account_interface_account_available, self);
		_tmp4_ = self->priv->controller;
		g_signal_parse_name ("account-unavailable", APPLICATION_TYPE_ACCOUNT_INTERFACE, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _application_main_window_on_account_unavailable_application_account_interface_account_unavailable, self);
	}
	_tmp6_ = self->priv->update_ui_timeout;
	geary_timeout_manager_reset (_tmp6_);
	GTK_WIDGET_CLASS (application_main_window_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_widget_get_type (), GtkWidget));
}

/** Updates the window's title and headerbar titles. */
void
application_main_window_update_title (ApplicationMainWindow* self)
{
	ApplicationAccountContext* account = NULL;
	ApplicationAccountContext* _tmp0_;
	ApplicationFolderContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ApplicationAccountContext* _tmp3_;
	ApplicationFolderContext* folder = NULL;
	ApplicationFolderContext* _tmp8_;
	gchar* title = NULL;
	gchar* _tmp9_;
	gchar* account_name = NULL;
	gchar* folder_name = NULL;
	gboolean _tmp10_ = FALSE;
	ApplicationAccountContext* _tmp11_;
	const gchar* _tmp28_;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_;
	ComponentsConversationListHeaderBar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_;
	ComponentsConversationListHeaderBar* _tmp34_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = application_main_window_get_selected_account_context (self);
	account = _tmp0_;
	_tmp3_ = account;
	if (_tmp3_ != NULL) {
		GearyFolder* _tmp4_;
		_tmp4_ = self->priv->_selected_folder;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ApplicationAccountContext* _tmp5_;
		GearyFolder* _tmp6_;
		ApplicationFolderContext* _tmp7_;
		_tmp5_ = account;
		_tmp6_ = self->priv->_selected_folder;
		_tmp7_ = application_account_context_get_folder (_tmp5_, _tmp6_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	_tmp8_ = _g_object_ref0 (_tmp1_);
	folder = _tmp8_;
	_tmp9_ = g_strdup (_ ("Geary"));
	title = _tmp9_;
	account_name = NULL;
	folder_name = NULL;
	_tmp11_ = account;
	if (_tmp11_ != NULL) {
		ApplicationFolderContext* _tmp12_;
		_tmp12_ = folder;
		_tmp10_ = _tmp12_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ApplicationAccountContext* _tmp13_;
		GearyAccount* _tmp14_;
		GearyAccount* _tmp15_;
		GearyAccountInformation* _tmp16_;
		GearyAccountInformation* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		ApplicationFolderContext* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp13_ = account;
		_tmp14_ = application_account_context_get_account (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = geary_account_get_information (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = geary_account_information_get_display_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (account_name);
		account_name = _tmp20_;
		_tmp21_ = folder;
		_tmp22_ = application_folder_context_get_display_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (folder_name);
		folder_name = _tmp24_;
		_tmp25_ = folder_name;
		_tmp26_ = account_name;
		_tmp27_ = g_strdup_printf (_ ("%s — %s"), _tmp25_, _tmp26_);
		_g_free0 (title);
		title = _tmp27_;
	}
	_tmp28_ = title;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp28_);
	_tmp30_ = account_name;
	_tmp29_ = _tmp30_;
	if (_tmp29_ == NULL) {
		_tmp29_ = "";
	}
	_tmp31_ = self->priv->conversation_list_headerbar;
	components_conversation_list_header_bar_set_account (_tmp31_, _tmp29_);
	_tmp33_ = folder_name;
	_tmp32_ = _tmp33_;
	if (_tmp32_ == NULL) {
		_tmp32_ = "";
	}
	_tmp34_ = self->priv->conversation_list_headerbar;
	components_conversation_list_header_bar_set_folder (_tmp34_, _tmp32_);
	_g_free0 (folder_name);
	_g_free0 (account_name);
	_g_free0 (title);
	_g_object_unref0 (folder);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (account);
}

/** Updates the window's account status info bars. */
static void
_application_main_window_on_service_problem_retry_components_problem_report_info_bar_retry (ComponentsProblemReportInfoBar* _sender,
                                                                                            gpointer self)
{
	application_main_window_on_service_problem_retry ((ApplicationMainWindow*) self);
}

void
application_main_window_update_account_status (ApplicationMainWindow* self,
                                               GearyAccountStatus status,
                                               gboolean has_auth_error,
                                               gboolean has_cert_error,
                                               GearyAccount* problem_source)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((problem_source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (problem_source, GEARY_TYPE_ACCOUNT));
	if (!geary_account_status_is_online (status)) {
		ComponentsInfoBarStack* _tmp0_;
		ComponentsInfoBar* _tmp1_;
		_tmp0_ = self->priv->info_bars;
		_tmp1_ = self->priv->offline_infobar;
		components_info_bar_stack_add (_tmp0_, _tmp1_);
	} else {
		if (geary_account_status_has_service_problem (status)) {
			GearyClientService* _tmp2_ = NULL;
			GearyClientService* _tmp3_;
			GearyClientService* _tmp4_;
			GearyErrorContext* _tmp5_;
			GearyErrorContext* _tmp6_;
			GearyClientService* service = NULL;
			GearyClientService* _tmp11_;
			GearyAccountInformation* _tmp12_;
			GearyAccountInformation* _tmp13_;
			GearyClientService* _tmp14_;
			GearyServiceInformation* _tmp15_;
			GearyServiceInformation* _tmp16_;
			GearyClientService* _tmp17_;
			GearyErrorContext* _tmp18_;
			GearyErrorContext* _tmp19_;
			GError* _tmp20_;
			GError* _tmp21_;
			GearyServiceProblemReport* _tmp22_;
			GearyServiceProblemReport* _tmp23_;
			ComponentsProblemReportInfoBar* _tmp24_;
			ComponentsProblemReportInfoBar* _tmp25_;
			ComponentsInfoBarStack* _tmp26_;
			ComponentsProblemReportInfoBar* _tmp27_;
			_tmp3_ = geary_account_get_incoming (problem_source);
			_tmp4_ = _tmp3_;
			_tmp5_ = geary_client_service_get_last_error (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_ != NULL) {
				GearyClientService* _tmp7_;
				GearyClientService* _tmp8_;
				_tmp7_ = geary_account_get_incoming (problem_source);
				_tmp8_ = _tmp7_;
				_tmp2_ = _tmp8_;
			} else {
				GearyClientService* _tmp9_;
				GearyClientService* _tmp10_;
				_tmp9_ = geary_account_get_outgoing (problem_source);
				_tmp10_ = _tmp9_;
				_tmp2_ = _tmp10_;
			}
			_tmp11_ = _g_object_ref0 (_tmp2_);
			service = _tmp11_;
			_tmp12_ = geary_account_get_information (problem_source);
			_tmp13_ = _tmp12_;
			_tmp14_ = service;
			_tmp15_ = geary_client_service_get_configuration (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = service;
			_tmp18_ = geary_client_service_get_last_error (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = geary_error_context_get_thrown (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = geary_service_problem_report_new (_tmp13_, _tmp16_, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = components_problem_report_info_bar_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
			g_object_ref_sink (_tmp24_);
			_g_object_unref0 (self->priv->service_problem_infobar);
			self->priv->service_problem_infobar = _tmp24_;
			_g_object_unref0 (_tmp23_);
			_tmp25_ = self->priv->service_problem_infobar;
			g_signal_connect_object (_tmp25_, "retry", (GCallback) _application_main_window_on_service_problem_retry_components_problem_report_info_bar_retry, self, 0);
			_tmp26_ = self->priv->info_bars;
			_tmp27_ = self->priv->service_problem_infobar;
			components_info_bar_stack_add (_tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar));
			_g_object_unref0 (service);
		} else {
			if (has_cert_error) {
				ComponentsInfoBarStack* _tmp28_;
				ComponentsInfoBar* _tmp29_;
				_tmp28_ = self->priv->info_bars;
				_tmp29_ = self->priv->cert_problem_infobar;
				components_info_bar_stack_add (_tmp28_, _tmp29_);
			} else {
				if (has_auth_error) {
					ComponentsInfoBarStack* _tmp30_;
					ComponentsInfoBar* _tmp31_;
					_tmp30_ = self->priv->info_bars;
					_tmp31_ = self->priv->auth_problem_infobar;
					components_info_bar_stack_add (_tmp30_, _tmp31_);
				} else {
					ComponentsInfoBarStack* _tmp32_;
					_tmp32_ = self->priv->info_bars;
					components_info_bar_stack_remove_all (_tmp32_);
				}
			}
		}
	}
}

static void
application_main_window_select_folder_data_free (gpointer _data)
{
	ApplicationMainWindowSelectFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to_select);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowSelectFolderData, _data_);
}

void
application_main_window_select_folder (ApplicationMainWindow* self,
                                       GearyFolder* to_select,
                                       gboolean is_interactive,
                                       gboolean inhibit_autoselect,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ApplicationMainWindowSelectFolderData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyFolder* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((to_select == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_select, GEARY_TYPE_FOLDER));
	_data_ = g_slice_new0 (ApplicationMainWindowSelectFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_select_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_select);
	_g_object_unref0 (_data_->to_select);
	_data_->to_select = _tmp1_;
	_data_->is_interactive = is_interactive;
	_data_->inhibit_autoselect = inhibit_autoselect;
	application_main_window_select_folder_co (_data_);
}

void
application_main_window_select_folder_finish (ApplicationMainWindow* self,
                                              GAsyncResult* _res_)
{
	ApplicationMainWindowSelectFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Selects and open the given folder.
     *
     * If is_interactive is true, the selection is treated as being
     * caused directly by human request (e.g. clicking on a folder in
     * the folder list), as opposed to some side effect.
     */
static void
_application_main_window_update_headerbar_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	application_main_window_update_headerbar ((ApplicationMainWindow*) self);
}

static void
application_main_window_select_folder_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	ApplicationMainWindowSelectFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_select_folder_co (_data_);
}

static gboolean
application_main_window_select_folder_co (ApplicationMainWindowSelectFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_selected_folder;
	if (_data_->_tmp0_ != _data_->to_select) {
		_data_->_tmp1_ = _data_->self->priv->folder_open;
		g_cancellable_cancel (_data_->_tmp1_);
		_data_->_tmp2_ = g_cancellable_new ();
		_g_object_unref0 (_data_->self->priv->folder_open);
		_data_->self->priv->folder_open = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->folder_open;
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
		_data_->cancellable = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->priv->_selected_folder;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->self->priv->folder_popovers;
			_data_->_tmp6__length1 = _data_->self->priv->folder_popovers_length1;
			{
				_data_->menu_collection_length1 = 0;
				_data_->_menu_collection_size_ = 0;
				_data_->menu_collection = _data_->_tmp6_;
				_data_->menu_collection_length1 = _data_->_tmp6__length1;
				for (_data_->menu_it = 0; _data_->menu_it < _data_->menu_collection_length1; _data_->menu_it = _data_->menu_it + 1) {
					_data_->_tmp7_ = _g_object_ref0 (_data_->menu_collection[_data_->menu_it]);
					_data_->menu = _data_->_tmp7_;
					{
						_data_->_tmp8_ = _data_->menu;
						_data_->_tmp9_ = _data_->self->priv->_selected_folder;
						folder_popover_enable_disable_folder (_data_->_tmp8_, _data_->_tmp9_, TRUE);
						_g_object_unref0 (_data_->menu);
					}
				}
			}
			_data_->_tmp10_ = _data_->self->priv->progress_monitor;
			_data_->_tmp11_ = _data_->self->priv->_selected_folder;
			_data_->_tmp12_ = geary_folder_get_opening_monitor (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			geary_aggregate_progress_monitor_remove (_data_->_tmp10_, _data_->_tmp13_);
			_data_->_tmp14_ = _data_->self->priv->_selected_folder;
			_data_->_tmp15_ = geary_folder_get_properties (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			g_signal_parse_name ("notify", G_TYPE_OBJECT, &_data_->_tmp17_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp17_, 0, NULL, (GCallback) _application_main_window_update_headerbar_g_object_notify, _data_->self);
			application_main_window_set_selected_folder (_data_->self, NULL);
		}
		_data_->_tmp18_ = _data_->self->priv->_conversations;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp19_ = _data_->self->priv->progress_monitor;
			_data_->_tmp20_ = _data_->self->priv->_conversations;
			_data_->_tmp21_ = geary_app_conversation_monitor_get_progress_monitor (_data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			geary_aggregate_progress_monitor_remove (_data_->_tmp19_, _data_->_tmp22_);
			_data_->_tmp23_ = _data_->self->priv->_conversations;
			application_main_window_close_conversation_monitor (_data_->self, _data_->_tmp23_);
			application_main_window_set_conversations (_data_->self, NULL);
		}
		_data_->_tmp24_ = _data_->self->priv->_conversation_list_view;
		_data_->_tmp25_ = conversation_list_view_get_model (_data_->_tmp24_);
		_data_->conversations_model = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->conversations_model;
		if (_data_->_tmp26_ != NULL) {
			_data_->_tmp27_ = _data_->self->priv->progress_monitor;
			_data_->_tmp28_ = _data_->conversations_model;
			_data_->_tmp29_ = conversation_list_store_get_preview_monitor (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			geary_aggregate_progress_monitor_remove (_data_->_tmp27_, _data_->_tmp30_);
			_data_->_tmp31_ = _data_->self->priv->_conversation_list_view;
			conversation_list_view_set_model (_data_->_tmp31_, NULL);
		}
		_data_->_tmp32_ = _data_->self->priv->_conversation_list_info_bars;
		components_info_bar_stack_remove_all (_data_->_tmp32_);
		if (_data_->to_select != NULL) {
			_data_->_tmp34_ = geary_folder_get_account (_data_->to_select);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp33_ = _data_->_tmp35_;
		} else {
			_data_->_tmp33_ = NULL;
		}
		application_main_window_select_account (_data_->self, _data_->_tmp33_);
		application_main_window_set_selected_folder (_data_->self, _data_->to_select);
		if (_data_->to_select != NULL) {
			if (_data_->is_interactive) {
				_data_->_tmp36_ = TRUE;
			} else {
				_data_->_tmp38_ = geary_folder_get_used_as (_data_->to_select);
				_data_->_tmp39_ = _data_->_tmp38_;
				if (_data_->_tmp39_ != GEARY_FOLDER_SPECIAL_USE_INBOX) {
					_data_->_tmp37_ = TRUE;
				} else {
					_data_->_tmp40_ = _data_->self->priv->_folder_list;
					_data_->_tmp41_ = geary_folder_get_account (_data_->to_select);
					_data_->_tmp42_ = _data_->_tmp41_;
					_data_->_tmp37_ = !folder_list_tree_select_inbox (_data_->_tmp40_, _data_->_tmp42_);
				}
				_data_->_tmp36_ = _data_->_tmp37_;
			}
			if (_data_->_tmp36_) {
				_data_->_tmp43_ = _data_->self->priv->_folder_list;
				folder_list_tree_select_folder (_data_->_tmp43_, _data_->to_select);
			}
		} else {
			_data_->_tmp44_ = _data_->self->priv->_folder_list;
			folder_list_tree_deselect_folder (_data_->_tmp44_);
		}
		application_main_window_update_title (_data_->self);
		application_main_window_update_conversation_actions (_data_->self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE);
		application_main_window_update_trash_action (_data_->self);
		_data_->_tmp45_ = _data_->self->priv->_conversation_viewer;
		conversation_viewer_show_loading (_data_->_tmp45_);
		_data_->self->priv->previous_selection_was_interactive = _data_->is_interactive;
		if (_data_->to_select != NULL) {
			_data_->_tmp47_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->to_select, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_g_free0 (_data_->_tmp46_);
			_data_->_tmp46_ = _data_->_tmp47_;
		} else {
			_data_->_tmp48_ = g_strdup ("(null)");
			_g_free0 (_data_->_tmp46_);
			_data_->_tmp46_ = _data_->_tmp48_;
		}
		g_debug ("application-main-window.vala:817: Folder selected: %s", _data_->_tmp46_);
		if (_data_->to_select != NULL) {
			_data_->_tmp49_ = _data_->self->priv->progress_monitor;
			_data_->_tmp50_ = geary_folder_get_opening_monitor (_data_->to_select);
			_data_->_tmp51_ = _data_->_tmp50_;
			geary_aggregate_progress_monitor_add (_data_->_tmp49_, _data_->_tmp51_);
			_data_->_tmp52_ = geary_folder_get_properties (_data_->to_select);
			_data_->_tmp53_ = _data_->_tmp52_;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, G_TYPE_OBJECT, GObject), "notify", (GCallback) _application_main_window_update_headerbar_g_object_notify, _data_->self, 0);
			_data_->_tmp54_ = geary_app_conversation_monitor_new (_data_->to_select, (CONVERSATION_LIST_STORE_REQUIRED_FIELDS | CONVERSATION_LIST_BOX_REQUIRED_FIELDS) | CONVERSATION_EMAIL_REQUIRED_FOR_CONSTRUCT, APPLICATION_MAIN_WINDOW_MIN_CONVERSATION_COUNT);
			_data_->_tmp55_ = _data_->_tmp54_;
			application_main_window_set_conversations (_data_->self, _data_->_tmp55_);
			_g_object_unref0 (_data_->_tmp55_);
			_data_->_tmp56_ = _data_->self->priv->progress_monitor;
			_data_->_tmp57_ = _data_->self->priv->_conversations;
			_data_->_tmp58_ = geary_app_conversation_monitor_get_progress_monitor (_data_->_tmp57_);
			_data_->_tmp59_ = _data_->_tmp58_;
			geary_aggregate_progress_monitor_add (_data_->_tmp56_, _data_->_tmp59_);
			_data_->_tmp60_ = _data_->self->priv->_conversations;
			_data_->_tmp61_ = application_main_window_get_application (_data_->self);
			_data_->_tmp62_ = _data_->_tmp61_;
			_data_->_tmp63_ = application_client_get_config (_data_->_tmp62_);
			_data_->_tmp64_ = _data_->_tmp63_;
			_data_->_tmp65_ = conversation_list_store_new (_data_->_tmp60_, _data_->_tmp64_);
			_g_object_unref0 (_data_->conversations_model);
			_data_->conversations_model = _data_->_tmp65_;
			_data_->_tmp66_ = _data_->self->priv->progress_monitor;
			_data_->_tmp67_ = _data_->conversations_model;
			_data_->_tmp68_ = conversation_list_store_get_preview_monitor (_data_->_tmp67_);
			_data_->_tmp69_ = _data_->_tmp68_;
			geary_aggregate_progress_monitor_add (_data_->_tmp66_, _data_->_tmp69_);
			if (_data_->inhibit_autoselect) {
				_data_->_tmp70_ = _data_->self->priv->_conversation_list_view;
				conversation_list_view_inhibit_next_autoselect (_data_->_tmp70_);
			}
			_data_->_tmp71_ = _data_->self->priv->_conversation_list_view;
			_data_->_tmp72_ = _data_->conversations_model;
			conversation_list_view_set_model (_data_->_tmp71_, _data_->_tmp72_);
			_data_->_tmp73_ = _data_->self->priv->folder_popovers;
			_data_->_tmp73__length1 = _data_->self->priv->folder_popovers_length1;
			{
				_data_->_vala1_menu_collection_length1 = 0;
				_data_->__vala1_menu_collection_size_ = 0;
				_data_->_vala1_menu_collection = _data_->_tmp73_;
				_data_->_vala1_menu_collection_length1 = _data_->_tmp73__length1;
				for (_data_->_vala1_menu_it = 0; _data_->_vala1_menu_it < _data_->_vala1_menu_collection_length1; _data_->_vala1_menu_it = _data_->_vala1_menu_it + 1) {
					_data_->_tmp74_ = _g_object_ref0 (_data_->_vala1_menu_collection[_data_->_vala1_menu_it]);
					_data_->_vala1_menu = _data_->_tmp74_;
					{
						_data_->_tmp75_ = _data_->_vala1_menu;
						folder_popover_enable_disable_folder (_data_->_tmp75_, _data_->to_select, FALSE);
						_g_object_unref0 (_data_->_vala1_menu);
					}
				}
			}
			_data_->_tmp76_ = _data_->self->priv->_conversations;
			_data_->_tmp77_ = _data_->cancellable;
			_data_->_state_ = 1;
			application_main_window_open_conversation_monitor (_data_->self, _data_->_tmp76_, _data_->_tmp77_, application_main_window_select_folder_ready, _data_);
			return FALSE;
			_state_1:
			application_main_window_open_conversation_monitor_finish (_data_->self, _data_->_res_);
			_data_->_tmp78_ = _data_->self->priv->controller;
			_data_->_state_ = 2;
			application_controller_process_pending_composers (_data_->_tmp78_, application_main_window_select_folder_ready, _data_);
			return FALSE;
			_state_2:
			application_controller_process_pending_composers_finish (_data_->_tmp78_, _data_->_res_);
		}
		_g_free0 (_data_->_tmp46_);
		_g_object_unref0 (_data_->conversations_model);
		_g_object_unref0 (_data_->cancellable);
	}
	application_main_window_update_headerbar (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_show_conversations_data_free (gpointer _data)
{
	ApplicationMainWindowShowConversationsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->location);
	_g_object_unref0 (_data_->to_show);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowShowConversationsData, _data_);
}

void
application_main_window_show_conversations (ApplicationMainWindow* self,
                                            GearyFolder* location,
                                            GeeCollection* to_show,
                                            gboolean is_interactive,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	ApplicationMainWindowShowConversationsData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (location, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_show, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationMainWindowShowConversationsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_show_conversations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp1_;
	_tmp2_ = _g_object_ref0 (to_show);
	_g_object_unref0 (_data_->to_show);
	_data_->to_show = _tmp2_;
	_data_->is_interactive = is_interactive;
	application_main_window_show_conversations_co (_data_);
}

void
application_main_window_show_conversations_finish (ApplicationMainWindow* self,
                                                   GAsyncResult* _res_)
{
	ApplicationMainWindowShowConversationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Selects the given account, folder and conversations. */
static void
application_main_window_show_conversations_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	ApplicationMainWindowShowConversationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_show_conversations_co (_data_);
}

static gboolean
application_main_window_show_conversations_co (ApplicationMainWindowShowConversationsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_selected_folder;
	_data_->inhibit_autoselect = _data_->location != _data_->_tmp0_;
	_data_->_state_ = 1;
	application_main_window_select_folder (_data_->self, _data_->location, _data_->is_interactive, _data_->inhibit_autoselect, application_main_window_show_conversations_ready, _data_);
	return FALSE;
	_state_1:
	application_main_window_select_folder_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->self->priv->_selected_folder;
	if (_data_->_tmp1_ == _data_->location) {
		_data_->_tmp2_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->latest_email = _data_->_tmp2_;
		{
			_data_->_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->to_show, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_stale_it = _data_->_tmp3_;
			while (TRUE) {
				_data_->_tmp4_ = _data_->_stale_it;
				if (!gee_iterator_next (_data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->_stale_it;
				_data_->_tmp6_ = gee_iterator_get (_data_->_tmp5_);
				_data_->stale = (GearyAppConversation*) _data_->_tmp6_;
				_data_->_tmp7_ = _data_->stale;
				_data_->_tmp8_ = geary_app_conversation_get_latest_recv_email (_data_->_tmp7_, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER, NULL);
				_data_->first = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->first;
				if (_data_->_tmp9_ != NULL) {
					_data_->_tmp10_ = _data_->latest_email;
					_data_->_tmp11_ = _data_->first;
					_data_->_tmp12_ = geary_email_get_id (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp13_);
				}
				_g_object_unref0 (_data_->first);
				_g_object_unref0 (_data_->stale);
			}
			_g_object_unref0 (_data_->_stale_it);
		}
		_data_->_tmp14_ = _data_->latest_email;
		_data_->_state_ = 2;
		application_main_window_load_conversations_for_email (_data_->self, _data_->location, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), application_main_window_show_conversations_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp15_ = application_main_window_load_conversations_for_email_finish (_data_->self, _data_->_res_);
		_data_->loaded = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->loaded;
		_data_->_tmp17_ = gee_collection_get_is_empty (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		if (!_data_->_tmp18_) {
			_data_->_tmp19_ = _data_->loaded;
			_data_->_tmp20_ = gee_collection_empty (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_state_ = 3;
			application_main_window_select_conversations (_data_->self, _data_->_tmp19_, _data_->_tmp21_, _data_->is_interactive, application_main_window_show_conversations_ready, _data_);
			return FALSE;
			_state_3:
			application_main_window_select_conversations_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->_tmp21_);
		}
		_g_object_unref0 (_data_->loaded);
		_g_object_unref0 (_data_->latest_email);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_show_email_data_free (gpointer _data)
{
	ApplicationMainWindowShowEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->location);
	_g_object_unref0 (_data_->to_show);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowShowEmailData, _data_);
}

void
application_main_window_show_email (ApplicationMainWindow* self,
                                    GearyFolder* location,
                                    GeeCollection* to_show,
                                    gboolean is_interactive,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	ApplicationMainWindowShowEmailData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (location, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_show, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationMainWindowShowEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_show_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp1_;
	_tmp2_ = _g_object_ref0 (to_show);
	_g_object_unref0 (_data_->to_show);
	_data_->to_show = _tmp2_;
	_data_->is_interactive = is_interactive;
	application_main_window_show_email_co (_data_);
}

void
application_main_window_show_email_finish (ApplicationMainWindow* self,
                                           GAsyncResult* _res_)
{
	ApplicationMainWindowShowEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Selects the given account, folder and email. */
static void
application_main_window_show_email_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	ApplicationMainWindowShowEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_show_email_co (_data_);
}

static gboolean
application_main_window_show_email_co (ApplicationMainWindowShowEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_selected_folder;
	_data_->inhibit_autoselect = _data_->location != _data_->_tmp0_;
	_data_->_state_ = 1;
	application_main_window_select_folder (_data_->self, _data_->location, _data_->is_interactive, _data_->inhibit_autoselect, application_main_window_show_email_ready, _data_);
	return FALSE;
	_state_1:
	application_main_window_select_folder_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->self->priv->_selected_folder;
	if (_data_->_tmp1_ == _data_->location) {
		_data_->_state_ = 2;
		application_main_window_load_conversations_for_email (_data_->self, _data_->location, _data_->to_show, application_main_window_show_email_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp2_ = application_main_window_load_conversations_for_email_finish (_data_->self, _data_->_res_);
		_data_->loaded = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->loaded;
		_data_->_tmp4_ = gee_collection_get_size (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ == 1) {
			_data_->_tmp6_ = _data_->loaded;
			_data_->_tmp7_ = geary_collection_first (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp6_);
			_data_->target = (GearyAppConversation*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->self->priv->_conversation_viewer;
			_data_->_tmp9_ = conversation_viewer_get_current_list (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
			_data_->current_list = _data_->_tmp11_;
			_data_->_tmp13_ = _data_->current_list;
			if (_data_->_tmp13_ != NULL) {
				_data_->_tmp14_ = _data_->current_list;
				_data_->_tmp15_ = conversation_list_box_get_conversation (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->target;
				_data_->_tmp12_ = _data_->_tmp16_ == _data_->_tmp17_;
			} else {
				_data_->_tmp12_ = FALSE;
			}
			if (_data_->_tmp12_) {
				_data_->_tmp18_ = _data_->current_list;
				conversation_list_box_scroll_to_messages (_data_->_tmp18_, _data_->to_show);
			} else {
				_data_->_tmp19_ = _data_->loaded;
				_data_->_state_ = 3;
				application_main_window_select_conversations (_data_->self, _data_->_tmp19_, _data_->to_show, _data_->is_interactive, application_main_window_show_email_ready, _data_);
				return FALSE;
				_state_3:
				application_main_window_select_conversations_finish (_data_->self, _data_->_res_);
			}
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->target);
		} else {
			_data_->_tmp20_ = _data_->loaded;
			_data_->_tmp21_ = gee_collection_get_is_empty (_data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			if (!_data_->_tmp22_) {
				_data_->_tmp23_ = _data_->loaded;
				_data_->_tmp24_ = gee_collection_empty (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_state_ = 4;
				application_main_window_select_conversations (_data_->self, _data_->_tmp23_, _data_->_tmp25_, _data_->is_interactive, application_main_window_show_email_ready, _data_);
				return FALSE;
				_state_4:
				application_main_window_select_conversations_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->_tmp25_);
			} else {
			}
		}
		_g_object_unref0 (_data_->loaded);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Shows the appopriate window menu, if any. */
void
application_main_window_show_window_menu (ApplicationMainWindow* self)
{
	HdyLeaflet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	HdyLeaflet* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ComponentsApplicationHeaderBar* _tmp8_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->outer_leaflet;
	_tmp1_ = hdy_leaflet_get_folded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		HdyLeaflet* _tmp3_;
		_tmp3_ = self->priv->outer_leaflet;
		hdy_leaflet_navigate (_tmp3_, HDY_NAVIGATION_DIRECTION_BACK);
	}
	_tmp4_ = self->priv->inner_leaflet;
	_tmp5_ = hdy_leaflet_get_folded (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		HdyLeaflet* _tmp7_;
		_tmp7_ = self->priv->inner_leaflet;
		hdy_leaflet_navigate (_tmp7_, HDY_NAVIGATION_DIRECTION_BACK);
	}
	_tmp8_ = self->priv->application_headerbar;
	components_application_header_bar_show_app_menu (_tmp8_);
}

/** Displays and focuses the search bar for the window. */
void
application_main_window_show_search_bar (ApplicationMainWindow* self,
                                         const gchar* text)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	SearchBar* _tmp7_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = application_main_window_get_is_conversation_list_shown (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		HdyLeaflet* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		HdyLeaflet* _tmp6_;
		_tmp2_ = self->priv->outer_leaflet;
		_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			HdyLeaflet* _tmp5_;
			_tmp5_ = self->priv->outer_leaflet;
			hdy_leaflet_set_visible_child_name (_tmp5_, APPLICATION_MAIN_WINDOW_INNER_LEAFLET);
		}
		_tmp6_ = self->priv->inner_leaflet;
		hdy_leaflet_set_visible_child_name (_tmp6_, APPLICATION_MAIN_WINDOW_CONVERSATION_LIST);
	}
	_tmp7_ = self->priv->_search_bar;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	if (text != NULL) {
		SearchBar* _tmp8_;
		GtkSearchEntry* _tmp9_;
		GtkSearchEntry* _tmp10_;
		_tmp8_ = self->priv->_search_bar;
		_tmp9_ = search_bar_get_entry (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_entry_get_type (), GtkEntry), text);
	}
}

/** Displays an infobar in the window. */
void
application_main_window_show_info_bar (ApplicationMainWindow* self,
                                       ComponentsInfoBar* info_bar)
{
	ComponentsInfoBarStack* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (info_bar));
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = components_info_bar_stack_get_has_current (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ComponentsInfoBarStack* _tmp3_;
		_tmp3_ = self->priv->info_bars;
		components_info_bar_stack_add (_tmp3_, info_bar);
	}
}

/**
     * Displays a composer in the window if possible, else in a new window.
     */
static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->referrants);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
____lambda161_ (Block15Data* _data15_,
                GearyEmail* email)
{
	ApplicationMainWindow* self;
	GeeCollection* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	gboolean result;
	self = _data15_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), FALSE);
	_tmp0_ = _data15_->referrants;
	_tmp1_ = geary_email_get_id (email);
	_tmp2_ = _tmp1_;
	result = gee_collection_contains (_tmp0_, _tmp2_);
	return result;
}

static gboolean
_____lambda161__gee_predicate (gconstpointer g,
                               gpointer self)
{
	gboolean result;
	result = ____lambda161_ (self, (GearyEmail*) g);
	return result;
}

void
application_main_window_show_composer (ApplicationMainWindow* self,
                                       ComposerWidget* composer)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (COMPOSER_IS_WIDGET (composer));
	_tmp0_ = application_main_window_get_has_composer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ApplicationClient* _tmp2_;
		ApplicationClient* _tmp3_;
		_tmp2_ = application_main_window_get_application (self);
		_tmp3_ = _tmp2_;
		composer_widget_detach (composer, _tmp3_);
	} else {
		GearyEmail* latest_referred = NULL;
		ConversationViewer* _tmp4_;
		ConversationListBox* _tmp5_;
		ConversationListBox* _tmp6_;
		GearyEmail* _tmp18_;
		HdyLeaflet* _tmp22_;
		latest_referred = NULL;
		_tmp4_ = self->priv->_conversation_viewer;
		_tmp5_ = conversation_viewer_get_current_list (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			Block15Data* _data15_;
			GeeSet* _tmp7_;
			GearyAppConversation* selected = NULL;
			ConversationViewer* _tmp8_;
			ConversationListBox* _tmp9_;
			ConversationListBox* _tmp10_;
			GearyAppConversation* _tmp11_;
			GearyAppConversation* _tmp12_;
			GearyAppConversation* _tmp13_;
			GearyAppConversation* _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			_data15_ = g_slice_new0 (Block15Data);
			_data15_->_ref_count_ = 1;
			_data15_->self = g_object_ref (self);
			_tmp7_ = composer_widget_get_referred_ids (composer);
			_data15_->referrants = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection);
			_tmp8_ = self->priv->_conversation_viewer;
			_tmp9_ = conversation_viewer_get_current_list (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = conversation_list_box_get_conversation (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			selected = _tmp13_;
			_tmp14_ = selected;
			_tmp15_ = geary_app_conversation_get_emails (_tmp14_, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_DESCENDING, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, TRUE);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_traversable_first_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_TRAVERSABLE, GeeTraversable), _____lambda161__gee_predicate, block15_data_ref (_data15_), block15_data_unref);
			_g_object_unref0 (latest_referred);
			latest_referred = (GearyEmail*) _tmp17_;
			_g_object_unref0 (_tmp16_);
			_g_object_unref0 (selected);
			block15_data_unref (_data15_);
			_data15_ = NULL;
		}
		_tmp18_ = latest_referred;
		if (_tmp18_ != NULL) {
			ConversationViewer* _tmp19_;
			GearyEmail* _tmp20_;
			_tmp19_ = self->priv->_conversation_viewer;
			_tmp20_ = latest_referred;
			conversation_viewer_do_compose_embedded (_tmp19_, composer, _tmp20_);
		} else {
			ConversationViewer* _tmp21_;
			_tmp21_ = self->priv->_conversation_viewer;
			conversation_viewer_do_compose (_tmp21_, composer);
		}
		_tmp22_ = self->priv->outer_leaflet;
		hdy_leaflet_set_visible_child_name (_tmp22_, APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER);
		_g_object_unref0 (latest_referred);
	}
}

/**
     * Closes any open composers, after prompting the user if requested.
     *
     * Returns true if none were open or the user approved closing
     * them.
     */
gboolean
application_main_window_close_composer (ApplicationMainWindow* self,
                                        gboolean should_prompt,
                                        gboolean is_shutdown)
{
	gboolean closed = FALSE;
	ComposerWidget* composer = NULL;
	ConversationViewer* _tmp0_;
	ComposerWidget* _tmp1_;
	ComposerWidget* _tmp2_;
	ComposerWidget* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ComposerWidget* _tmp5_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	closed = TRUE;
	_tmp0_ = self->priv->_conversation_viewer;
	_tmp1_ = conversation_viewer_get_current_composer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	composer = _tmp3_;
	_tmp5_ = composer;
	if (_tmp5_ != NULL) {
		ComposerWidget* _tmp6_;
		_tmp6_ = composer;
		_tmp4_ = composer_widget_conditional_close (_tmp6_, should_prompt, is_shutdown) == COMPOSER_WIDGET_CLOSE_STATUS_CANCELLED;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		closed = FALSE;
	}
	result = closed;
	_g_object_unref0 (composer);
	return result;
}

void
application_main_window_start_search (ApplicationMainWindow* self,
                                      const gchar* query_text,
                                      gboolean is_interactive)
{
	ApplicationAccountContext* context = NULL;
	ApplicationAccountContext* _tmp0_;
	ApplicationAccountContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (query_text != NULL);
	_tmp0_ = application_main_window_get_selected_account_context (self);
	context = _tmp0_;
	_tmp1_ = context;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GearyFolder* _tmp4_;
		_tmp4_ = self->priv->previous_non_search_folder;
		if (_tmp4_ == NULL) {
			GearyFolder* _tmp5_;
			_tmp5_ = self->priv->_selected_folder;
			_tmp3_ = _tmp5_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GearyFolder* _tmp6_;
			GearyFolderSpecialUse _tmp7_;
			GearyFolderSpecialUse _tmp8_;
			_tmp6_ = self->priv->_selected_folder;
			_tmp7_ = geary_folder_get_used_as (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = _tmp8_ != GEARY_FOLDER_SPECIAL_USE_SEARCH;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GearyFolder* _tmp9_;
			GearyFolder* _tmp10_;
			_tmp9_ = self->priv->_selected_folder;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			_g_object_unref0 (self->priv->previous_non_search_folder);
			self->priv->previous_non_search_folder = _tmp10_;
		}
		{
			UtilEmailSearchExpressionFactory* expr_factory = NULL;
			ApplicationClient* _tmp11_;
			ApplicationClient* _tmp12_;
			ApplicationConfiguration* _tmp13_;
			ApplicationConfiguration* _tmp14_;
			ApplicationAccountContext* _tmp15_;
			GearyAccount* _tmp16_;
			GearyAccount* _tmp17_;
			GearyAccountInformation* _tmp18_;
			GearyAccountInformation* _tmp19_;
			UtilEmailSearchExpressionFactory* _tmp20_;
			GearySearchQuery* query = NULL;
			ApplicationAccountContext* _tmp21_;
			GearyAccount* _tmp22_;
			GearyAccount* _tmp23_;
			UtilEmailSearchExpressionFactory* _tmp24_;
			GeeList* _tmp25_;
			GeeList* _tmp26_;
			GearySearchQuery* _tmp27_;
			GearySearchQuery* _tmp28_;
			FolderListTree* _tmp29_;
			ApplicationClient* _tmp30_;
			ApplicationClient* _tmp31_;
			GearyEngine* _tmp32_;
			GearyEngine* _tmp33_;
			ApplicationAccountContext* _tmp34_;
			GearyAppSearchFolder* _tmp35_;
			ApplicationAccountContext* _tmp36_;
			GearyAppSearchFolder* _tmp37_;
			GearySearchQuery* _tmp38_;
			_tmp11_ = application_main_window_get_application (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = application_client_get_config (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = context;
			_tmp16_ = application_account_context_get_account (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = geary_account_get_information (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = util_email_search_expression_factory_new (application_configuration_get_search_strategy (_tmp14_), _tmp19_);
			expr_factory = _tmp20_;
			_tmp21_ = context;
			_tmp22_ = application_account_context_get_account (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = expr_factory;
			_tmp25_ = util_email_search_expression_factory_parse_query (_tmp24_, query_text);
			_tmp26_ = _tmp25_;
			_tmp27_ = geary_account_new_search_query (_tmp23_, _tmp26_, query_text, &_inner_error0_);
			_tmp28_ = _tmp27_;
			_g_object_unref0 (_tmp26_);
			query = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (expr_factory);
				goto __catch0_g_error;
			}
			_tmp29_ = self->priv->_folder_list;
			_tmp30_ = application_main_window_get_application (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = application_client_get_engine (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = context;
			_tmp35_ = _tmp34_->search;
			folder_list_tree_set_search (_tmp29_, _tmp33_, _tmp35_);
			_tmp36_ = context;
			_tmp37_ = _tmp36_->search;
			_tmp38_ = query;
			geary_app_search_folder_update_query (_tmp37_, _tmp38_);
			_g_object_unref0 (query);
			_g_object_unref0 (expr_factory);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			ApplicationAccountContext* _tmp39_;
			GearyAccount* _tmp40_;
			GearyAccount* _tmp41_;
			GearyAccountInformation* _tmp42_;
			GearyAccountInformation* _tmp43_;
			GError* _tmp44_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp39_ = context;
			_tmp40_ = application_account_context_get_account (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = geary_account_get_information (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = _error_;
			application_main_window_handle_error (self, _tmp43_, _tmp44_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (context);
}

void
application_main_window_stop_search (ApplicationMainWindow* self,
                                     gboolean is_interactive)
{
	gboolean _tmp0_ = FALSE;
	GearyFolder* _tmp1_;
	FolderListTree* _tmp15_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp1_ = self->priv->_selected_folder;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GearyFolder* _tmp2_;
		GearyFolderSpecialUse _tmp3_;
		GearyFolderSpecialUse _tmp4_;
		_tmp2_ = self->priv->_selected_folder;
		_tmp3_ = geary_folder_get_used_as (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == GEARY_FOLDER_SPECIAL_USE_SEARCH;
	}
	if (_tmp0_) {
		GearyFolder* to_select = NULL;
		GearyFolder* _tmp5_;
		GearyFolder* _tmp6_;
		GearyFolder* _tmp7_;
		GearyFolder* _tmp13_;
		_tmp5_ = self->priv->previous_non_search_folder;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		to_select = _tmp6_;
		_tmp7_ = to_select;
		if (_tmp7_ == NULL) {
			ApplicationAccountContext* account = NULL;
			ApplicationAccountContext* _tmp8_;
			ApplicationAccountContext* _tmp9_;
			_tmp8_ = application_main_window_get_selected_account_context (self);
			account = _tmp8_;
			_tmp9_ = account;
			if (_tmp9_ != NULL) {
				ApplicationAccountContext* _tmp10_;
				GearyFolder* _tmp11_;
				GearyFolder* _tmp12_;
				_tmp10_ = account;
				_tmp11_ = _tmp10_->inbox;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (to_select);
				to_select = _tmp12_;
			}
			_g_object_unref0 (account);
		}
		_tmp13_ = to_select;
		if (_tmp13_ != NULL) {
			GearyFolder* _tmp14_;
			_tmp14_ = self->priv->previous_non_search_folder;
			application_main_window_select_folder (self, _tmp14_, is_interactive, FALSE, NULL, NULL);
		} else {
			application_main_window_select_first_inbox (self, is_interactive);
		}
		_g_object_unref0 (to_select);
	}
	_tmp15_ = self->priv->_folder_list;
	folder_list_tree_remove_search (_tmp15_);
	{
		GeeIterator* _context_it = NULL;
		ApplicationController* _tmp16_;
		GeeCollection* _tmp17_;
		GeeCollection* _tmp18_;
		GeeIterator* _tmp19_;
		GeeIterator* _tmp20_;
		_tmp16_ = self->priv->controller;
		_tmp17_ = application_account_interface_get_account_contexts (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface));
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_context_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			ApplicationAccountContext* context = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			ApplicationAccountContext* _tmp24_;
			GearyAppSearchFolder* _tmp25_;
			_tmp21_ = _context_it;
			if (!gee_iterator_next (_tmp21_)) {
				break;
			}
			_tmp22_ = _context_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			context = (ApplicationAccountContext*) _tmp23_;
			_tmp24_ = context;
			_tmp25_ = _tmp24_->search;
			geary_app_search_folder_clear_query (_tmp25_);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
}

gboolean
application_main_window_select_first_inbox (ApplicationMainWindow* self,
                                            gboolean is_interactive)
{
	gboolean success = FALSE;
	GearyFolder* inbox = NULL;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	success = FALSE;
	_tmp0_ = application_main_window_get_first_inbox (self);
	inbox = _tmp0_;
	_tmp1_ = inbox;
	if (_tmp1_ != NULL) {
		GearyFolder* _tmp2_;
		_tmp2_ = inbox;
		application_main_window_select_folder (self, _tmp2_, is_interactive, FALSE, NULL, NULL);
		success = TRUE;
	}
	result = success;
	_g_object_unref0 (inbox);
	return result;
}

static void
_application_main_window_on_folders_available_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                             GeeCollection* available,
                                                                                             gpointer self)
{
	application_main_window_on_folders_available ((ApplicationMainWindow*) self, available);
}

static void
_application_main_window_on_folders_unavailable_application_account_context_folders_unavailable (ApplicationAccountContext* _sender,
                                                                                                 GeeCollection* unavailable,
                                                                                                 gpointer self)
{
	application_main_window_on_folders_unavailable ((ApplicationMainWindow*) self, unavailable);
}

static void
_application_main_window_on_command_execute_application_command_stack_executed (ApplicationCommandStack* _sender,
                                                                                ApplicationCommand* command,
                                                                                gpointer self)
{
	application_main_window_on_command_execute ((ApplicationMainWindow*) self, command);
}

static void
_application_main_window_on_command_undo_application_command_stack_undone (ApplicationCommandStack* _sender,
                                                                           ApplicationCommand* command,
                                                                           gpointer self)
{
	application_main_window_on_command_undo ((ApplicationMainWindow*) self, command);
}

static void
_application_main_window_on_command_redo_application_command_stack_redone (ApplicationCommandStack* _sender,
                                                                           ApplicationCommand* command,
                                                                           gpointer self)
{
	application_main_window_on_command_redo ((ApplicationMainWindow*) self, command);
}

static void
application_main_window_add_account (ApplicationMainWindow* self,
                                     ApplicationAccountContext* to_add)
{
	GeeSet* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (to_add));
	_tmp0_ = self->priv->accounts;
	if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), to_add)) {
		FolderListTree* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAggregateProgressMonitor* _tmp4_;
		GearyAccount* _tmp5_;
		GearyAccount* _tmp6_;
		GearyProgressMonitor* _tmp7_;
		GearyProgressMonitor* _tmp8_;
		GearySmtpClientService* smtp = NULL;
		GearyAccount* _tmp9_;
		GearyAccount* _tmp10_;
		GearyClientService* _tmp11_;
		GearyClientService* _tmp12_;
		GearySmtpClientService* _tmp13_;
		GearySmtpClientService* _tmp14_;
		ApplicationCommandStack* _tmp19_;
		ApplicationCommandStack* _tmp20_;
		ApplicationCommandStack* _tmp21_;
		ApplicationCommandStack* _tmp22_;
		ApplicationCommandStack* _tmp23_;
		ApplicationCommandStack* _tmp24_;
		GeeTreeSet* added = NULL;
		GeeTreeSet* _tmp25_;
		GeeTreeSet* _tmp26_;
		GeeCollection* _tmp27_;
		GeeCollection* _tmp28_;
		GeeTreeSet* _tmp29_;
		GeeSet* _tmp30_;
		_tmp1_ = self->priv->_folder_list;
		_tmp2_ = application_account_context_get_account (to_add);
		_tmp3_ = _tmp2_;
		folder_list_tree_set_user_folders_root_name (_tmp1_, _tmp3_, _ ("Labels"));
		_tmp4_ = self->priv->progress_monitor;
		_tmp5_ = application_account_context_get_account (to_add);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_account_get_background_progress (_tmp6_);
		_tmp8_ = _tmp7_;
		geary_aggregate_progress_monitor_add (_tmp4_, _tmp8_);
		_tmp9_ = application_account_context_get_account (to_add);
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_account_get_outgoing (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GEARY_SMTP_TYPE_CLIENT_SERVICE) ? ((GearySmtpClientService*) _tmp12_) : NULL);
		smtp = _tmp13_;
		_tmp14_ = smtp;
		if (_tmp14_ != NULL) {
			GearyAggregateProgressMonitor* _tmp15_;
			GearySmtpClientService* _tmp16_;
			GearyProgressMonitor* _tmp17_;
			GearyProgressMonitor* _tmp18_;
			_tmp15_ = self->priv->progress_monitor;
			_tmp16_ = smtp;
			_tmp17_ = geary_smtp_client_service_get_sending_monitor (_tmp16_);
			_tmp18_ = _tmp17_;
			geary_aggregate_progress_monitor_add (_tmp15_, _tmp18_);
		}
		g_signal_connect_object (to_add, "folders-available", (GCallback) _application_main_window_on_folders_available_application_account_context_folders_available, self, 0);
		g_signal_connect_object (to_add, "folders-unavailable", (GCallback) _application_main_window_on_folders_unavailable_application_account_context_folders_unavailable, self, 0);
		_tmp19_ = application_account_context_get_commands (to_add);
		_tmp20_ = _tmp19_;
		g_signal_connect_object (_tmp20_, "executed", (GCallback) _application_main_window_on_command_execute_application_command_stack_executed, self, 0);
		_tmp21_ = application_account_context_get_commands (to_add);
		_tmp22_ = _tmp21_;
		g_signal_connect_object (_tmp22_, "undone", (GCallback) _application_main_window_on_command_undo_application_command_stack_undone, self, 0);
		_tmp23_ = application_account_context_get_commands (to_add);
		_tmp24_ = _tmp23_;
		g_signal_connect_object (_tmp24_, "redone", (GCallback) _application_main_window_on_command_redo_application_command_stack_redone, self, 0);
		_tmp25_ = gee_tree_set_new (APPLICATION_TYPE_FOLDER_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		added = _tmp25_;
		_tmp26_ = added;
		_tmp27_ = application_account_context_get_folders (to_add);
		_tmp28_ = _tmp27_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_);
		_g_object_unref0 (_tmp28_);
		_tmp29_ = added;
		application_main_window_add_folders (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp30_ = self->priv->accounts;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), to_add);
		_g_object_unref0 (added);
		_g_object_unref0 (smtp);
	}
}

static void
application_main_window_remove_account_data_free (gpointer _data)
{
	ApplicationMainWindowRemoveAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to_remove);
	_g_object_unref0 (_data_->to_select);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowRemoveAccountData, _data_);
}

static void
application_main_window_remove_account (ApplicationMainWindow* self,
                                        ApplicationAccountContext* to_remove,
                                        GearyFolder* to_select,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationMainWindowRemoveAccountData* _data_;
	ApplicationMainWindow* _tmp0_;
	ApplicationAccountContext* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (to_remove));
	g_return_if_fail ((to_select == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_select, GEARY_TYPE_FOLDER));
	_data_ = g_slice_new0 (ApplicationMainWindowRemoveAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_remove_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_remove);
	_g_object_unref0 (_data_->to_remove);
	_data_->to_remove = _tmp1_;
	_tmp2_ = _g_object_ref0 (to_select);
	_g_object_unref0 (_data_->to_select);
	_data_->to_select = _tmp2_;
	application_main_window_remove_account_co (_data_);
}

static void
application_main_window_remove_account_finish (ApplicationMainWindow* self,
                                               GAsyncResult* _res_)
{
	ApplicationMainWindowRemoveAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Removes the given account from the main window.
     *
     * If `to_select` is not null, the given folder will be selected,
     * otherwise no folder will be.
     */
static void
application_main_window_remove_account_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ApplicationMainWindowRemoveAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_remove_account_co (_data_);
}

static void
_application_main_window_on_folders_unavailable_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                               GeeCollection* available,
                                                                                               gpointer self)
{
	application_main_window_on_folders_unavailable ((ApplicationMainWindow*) self, available);
}

static gboolean
application_main_window_remove_account_co (ApplicationMainWindowRemoveAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->accounts;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _data_->to_remove)) {
		_data_->_tmp2_ = _data_->self->priv->_selected_folder;
		if (_data_->_tmp2_ != NULL) {
			_data_->_tmp3_ = _data_->self->priv->_selected_folder;
			_data_->_tmp4_ = geary_folder_get_account (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_tmp6_ = application_account_context_get_account (_data_->to_remove);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp1_ = _data_->_tmp5_ == _data_->_tmp7_;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp8_ = _data_->self->priv->_selected_folder;
			_data_->_tmp9_ = geary_folder_get_used_as (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->is_account_search_active = _data_->_tmp10_ == GEARY_FOLDER_SPECIAL_USE_SEARCH;
			_data_->_state_ = 1;
			application_main_window_select_folder (_data_->self, _data_->to_select, FALSE, FALSE, application_main_window_remove_account_ready, _data_);
			return FALSE;
			_state_1:
			application_main_window_select_folder_finish (_data_->self, _data_->_res_);
			if (_data_->is_account_search_active) {
				_data_->_tmp11_ = _data_->self->priv->_search_bar;
				_data_->_tmp12_ = search_bar_get_entry (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, gtk_entry_get_type (), GtkEntry), "");
				_data_->_tmp14_ = _data_->self->priv->_search_bar;
				g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, hdy_search_bar_get_type (), HdySearchBar), "search-mode-enabled", FALSE, NULL);
			}
		}
		_data_->_tmp15_ = application_account_context_get_commands (_data_->to_remove);
		_data_->_tmp16_ = _data_->_tmp15_;
		g_signal_parse_name ("executed", APPLICATION_TYPE_COMMAND_STACK, &_data_->_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp17_, 0, NULL, (GCallback) _application_main_window_on_command_execute_application_command_stack_executed, _data_->self);
		_data_->_tmp18_ = application_account_context_get_commands (_data_->to_remove);
		_data_->_tmp19_ = _data_->_tmp18_;
		g_signal_parse_name ("undone", APPLICATION_TYPE_COMMAND_STACK, &_data_->_tmp20_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp20_, 0, NULL, (GCallback) _application_main_window_on_command_undo_application_command_stack_undone, _data_->self);
		_data_->_tmp21_ = application_account_context_get_commands (_data_->to_remove);
		_data_->_tmp22_ = _data_->_tmp21_;
		g_signal_parse_name ("redone", APPLICATION_TYPE_COMMAND_STACK, &_data_->_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp23_, 0, NULL, (GCallback) _application_main_window_on_command_redo_application_command_stack_redone, _data_->self);
		g_signal_parse_name ("folders-available", APPLICATION_TYPE_ACCOUNT_CONTEXT, &_data_->_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->to_remove, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp24_, 0, NULL, (GCallback) _application_main_window_on_folders_available_application_account_context_folders_available, _data_->self);
		g_signal_parse_name ("folders-available", APPLICATION_TYPE_ACCOUNT_CONTEXT, &_data_->_tmp25_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->to_remove, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp25_, 0, NULL, (GCallback) _application_main_window_on_folders_unavailable_application_account_context_folders_available, _data_->self);
		_data_->_tmp26_ = _data_->self->priv->progress_monitor;
		_data_->_tmp27_ = application_account_context_get_account (_data_->to_remove);
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = geary_account_get_background_progress (_data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		geary_aggregate_progress_monitor_remove (_data_->_tmp26_, _data_->_tmp30_);
		_data_->_tmp31_ = application_account_context_get_account (_data_->to_remove);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = geary_account_get_outgoing (_data_->_tmp32_);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, GEARY_SMTP_TYPE_CLIENT_SERVICE) ? ((GearySmtpClientService*) _data_->_tmp34_) : NULL);
		_data_->smtp = _data_->_tmp35_;
		_data_->_tmp36_ = _data_->smtp;
		if (_data_->_tmp36_ != NULL) {
			_data_->_tmp37_ = _data_->self->priv->progress_monitor;
			_data_->_tmp38_ = _data_->smtp;
			_data_->_tmp39_ = geary_smtp_client_service_get_sending_monitor (_data_->_tmp38_);
			_data_->_tmp40_ = _data_->_tmp39_;
			geary_aggregate_progress_monitor_remove (_data_->_tmp37_, _data_->_tmp40_);
		}
		_data_->_tmp41_ = application_account_context_get_folders (_data_->to_remove);
		_data_->_tmp42_ = _data_->_tmp41_;
		application_main_window_remove_folders (_data_->self, _data_->_tmp42_, FALSE);
		_g_object_unref0 (_data_->_tmp42_);
		_data_->_tmp43_ = _data_->self->priv->_folder_list;
		_data_->_tmp44_ = application_account_context_get_account (_data_->to_remove);
		_data_->_tmp45_ = _data_->_tmp44_;
		folder_list_tree_remove_account (_data_->_tmp43_, _data_->_tmp45_);
		_data_->_tmp46_ = _data_->self->priv->accounts;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, GEE_TYPE_COLLECTION, GeeCollection), _data_->to_remove);
		_g_object_unref0 (_data_->smtp);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Adds a folder to the window. */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_application_main_window_on_use_changed_geary_folder_use_changed (GearyFolder* _sender,
                                                                  GearyFolderSpecialUse old_use,
                                                                  GearyFolderSpecialUse new_use,
                                                                  gpointer self)
{
	application_main_window_on_use_changed ((ApplicationMainWindow*) self, _sender, old_use, new_use);
}

static void
application_main_window_add_folders (ApplicationMainWindow* self,
                                     GeeCollection* to_add)
{
	GeeHashMap* map = NULL;
	GeeHashMap* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_add, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_add, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GearyFolder* folder = NULL;
			ApplicationFolderContext* _tmp5_;
			GearyFolder* _tmp6_;
			GearyFolder* _tmp7_;
			GearyFolder* _tmp8_;
			GearyFolder* _tmp9_;
			GearyFolderSpecialUse _tmp10_;
			GearyFolderSpecialUse _tmp11_;
			GeeHashMap* _tmp12_;
			GearyFolder* _tmp13_;
			GearyFolderPath* _tmp14_;
			GearyFolderPath* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			ApplicationFolderContext* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp2_ = _context_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _context_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			context = (ApplicationFolderContext*) _tmp4_;
			_tmp5_ = context;
			_tmp6_ = application_folder_context_get_folder (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			folder = _tmp8_;
			_tmp9_ = folder;
			_tmp10_ = geary_folder_get_used_as (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == GEARY_FOLDER_SPECIAL_USE_NONE) {
				_g_object_unref0 (folder);
				_g_object_unref0 (context);
				continue;
			}
			_tmp12_ = map;
			_tmp13_ = folder;
			_tmp14_ = geary_folder_get_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = geary_folder_path_to_string (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) -1);
			_tmp19_ = _tmp18_;
			_tmp20_ = context;
			_tmp21_ = application_folder_context_get_display_name (_tmp20_);
			_tmp22_ = _tmp21_;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp19_, _tmp22_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_object_unref0 (folder);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp23_;
		_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_add, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			FolderListTree* _tmp27_;
			ApplicationFolderContext* _tmp28_;
			ApplicationFolderContext* _tmp29_;
			GearyFolder* _tmp30_;
			GearyFolder* _tmp31_;
			GearyAccount* _tmp32_;
			GearyAccount* _tmp33_;
			GearyAccount* _tmp34_;
			ApplicationFolderContext* _tmp40_;
			GearyFolder* _tmp41_;
			GearyFolder* _tmp42_;
			_tmp24_ = _context_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _context_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			context = (ApplicationFolderContext*) _tmp26_;
			_tmp27_ = self->priv->_folder_list;
			_tmp28_ = context;
			folder_list_tree_add_folder (_tmp27_, _tmp28_);
			_tmp29_ = context;
			_tmp30_ = application_folder_context_get_folder (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = geary_folder_get_account (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->_selected_account;
			if (_tmp33_ == _tmp34_) {
				FolderPopover** _tmp35_;
				gint _tmp35__length1;
				_tmp35_ = self->priv->folder_popovers;
				_tmp35__length1 = self->priv->folder_popovers_length1;
				{
					FolderPopover** menu_collection = NULL;
					gint menu_collection_length1 = 0;
					gint _menu_collection_size_ = 0;
					gint menu_it = 0;
					menu_collection = _tmp35_;
					menu_collection_length1 = _tmp35__length1;
					for (menu_it = 0; menu_it < menu_collection_length1; menu_it = menu_it + 1) {
						FolderPopover* _tmp36_;
						FolderPopover* menu = NULL;
						_tmp36_ = _g_object_ref0 (menu_collection[menu_it]);
						menu = _tmp36_;
						{
							FolderPopover* _tmp37_;
							ApplicationFolderContext* _tmp38_;
							GeeHashMap* _tmp39_;
							_tmp37_ = menu;
							_tmp38_ = context;
							_tmp39_ = map;
							folder_popover_add_folder (_tmp37_, _tmp38_, _tmp39_);
							_g_object_unref0 (menu);
						}
					}
				}
			}
			_tmp40_ = context;
			_tmp41_ = application_folder_context_get_folder (_tmp40_);
			_tmp42_ = _tmp41_;
			g_signal_connect_object (_tmp42_, "use-changed", (GCallback) _application_main_window_on_use_changed_geary_folder_use_changed, self, 0);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	_g_object_unref0 (map);
}

/** Removes a folder from the window. */
static void
application_main_window_remove_folders (ApplicationMainWindow* self,
                                        GeeCollection* to_remove,
                                        gboolean update_selecton)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_remove, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_remove, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GearyFolder* folder = NULL;
			ApplicationFolderContext* _tmp4_;
			GearyFolder* _tmp5_;
			GearyFolder* _tmp6_;
			GearyFolder* _tmp7_;
			GearyFolder* _tmp8_;
			GearyFolder* _tmp9_;
			GearyFolder* _tmp14_;
			guint _tmp15_;
			GearyFolder* _tmp16_;
			GearyAccount* _tmp17_;
			GearyAccount* _tmp18_;
			GearyAccount* _tmp19_;
			FolderListTree* _tmp24_;
			ApplicationFolderContext* _tmp25_;
			_tmp1_ = _context_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _context_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			context = (ApplicationFolderContext*) _tmp3_;
			_tmp4_ = context;
			_tmp5_ = application_folder_context_get_folder (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			folder = _tmp7_;
			_tmp8_ = self->priv->_selected_folder;
			_tmp9_ = folder;
			if (_tmp8_ == _tmp9_) {
				ApplicationAccountContext* account = NULL;
				ApplicationAccountContext* _tmp10_;
				ApplicationAccountContext* _tmp11_;
				_tmp10_ = application_main_window_get_selected_account_context (self);
				account = _tmp10_;
				_tmp11_ = account;
				if (_tmp11_ != NULL) {
					ApplicationAccountContext* _tmp12_;
					GearyFolder* _tmp13_;
					_tmp12_ = account;
					_tmp13_ = _tmp12_->inbox;
					application_main_window_select_folder (self, _tmp13_, TRUE, FALSE, NULL, NULL);
				}
				_g_object_unref0 (account);
			}
			_tmp14_ = folder;
			g_signal_parse_name ("use-changed", GEARY_TYPE_FOLDER, &_tmp15_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _application_main_window_on_use_changed_geary_folder_use_changed, self);
			_tmp16_ = folder;
			_tmp17_ = geary_folder_get_account (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->_selected_account;
			if (_tmp18_ == _tmp19_) {
				FolderPopover** _tmp20_;
				gint _tmp20__length1;
				_tmp20_ = self->priv->folder_popovers;
				_tmp20__length1 = self->priv->folder_popovers_length1;
				{
					FolderPopover** menu_collection = NULL;
					gint menu_collection_length1 = 0;
					gint _menu_collection_size_ = 0;
					gint menu_it = 0;
					menu_collection = _tmp20_;
					menu_collection_length1 = _tmp20__length1;
					for (menu_it = 0; menu_it < menu_collection_length1; menu_it = menu_it + 1) {
						FolderPopover* _tmp21_;
						FolderPopover* menu = NULL;
						_tmp21_ = _g_object_ref0 (menu_collection[menu_it]);
						menu = _tmp21_;
						{
							FolderPopover* _tmp22_;
							GearyFolder* _tmp23_;
							_tmp22_ = menu;
							_tmp23_ = folder;
							folder_popover_remove_folder (_tmp22_, _tmp23_);
							_g_object_unref0 (menu);
						}
					}
				}
			}
			_tmp24_ = self->priv->_folder_list;
			_tmp25_ = context;
			folder_list_tree_remove_folder (_tmp24_, _tmp25_);
			_g_object_unref0 (folder);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
}

static ApplicationAccountContext*
application_main_window_get_selected_account_context (ApplicationMainWindow* self)
{
	ApplicationAccountContext* context = NULL;
	GearyAccount* _tmp0_;
	ApplicationAccountContext* result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	context = NULL;
	_tmp0_ = self->priv->_selected_account;
	if (_tmp0_ != NULL) {
		ApplicationController* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccountInformation* _tmp3_;
		GearyAccountInformation* _tmp4_;
		ApplicationAccountContext* _tmp5_;
		_tmp1_ = self->priv->controller;
		_tmp2_ = self->priv->_selected_account;
		_tmp3_ = geary_account_get_information (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _tmp4_);
		_g_object_unref0 (context);
		context = _tmp5_;
	}
	result = context;
	return result;
}

static GearyFolder*
application_main_window_get_first_inbox (ApplicationMainWindow* self)
{
	GearyFolder* inbox = NULL;
	GError* _inner_error0_ = NULL;
	GearyFolder* result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	inbox = NULL;
	{
		GeeCollection* _tmp0_ = NULL;
		ApplicationClient* _tmp1_;
		ApplicationClient* _tmp2_;
		GearyEngine* _tmp3_;
		GearyEngine* _tmp4_;
		GeeCollection* _tmp5_;
		GearyAccount* first = NULL;
		gpointer _tmp6_;
		GearyAccount* _tmp7_;
		_tmp1_ = application_main_window_get_application (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = application_client_get_engine (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_engine_get_accounts (_tmp4_, &_inner_error0_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = geary_collection_first (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
		first = (GearyAccount*) _tmp6_;
		_tmp7_ = first;
		if (_tmp7_ != NULL) {
			GearyAccount* _tmp8_;
			GearyFolder* _tmp9_;
			_tmp8_ = first;
			_tmp9_ = geary_account_get_special_folder (_tmp8_, GEARY_FOLDER_SPECIAL_USE_INBOX);
			_g_object_unref0 (inbox);
			inbox = _tmp9_;
		}
		_g_object_unref0 (first);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_debug ("application-main-window.vala:1236: Error getting inbox for first accou" \
"nt");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (inbox);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = inbox;
	return result;
}

static void
application_main_window_load_config (ApplicationMainWindow* self,
                                     ApplicationConfiguration* config)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	application_configuration_bind (config, APPLICATION_CONFIGURATION_WINDOW_WIDTH_KEY, G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "window-width", G_SETTINGS_BIND_DEFAULT);
	application_configuration_bind (config, APPLICATION_CONFIGURATION_WINDOW_HEIGHT_KEY, G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "window-height", G_SETTINGS_BIND_DEFAULT);
	application_configuration_bind (config, APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_KEY, G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "window-maximized", G_SETTINGS_BIND_DEFAULT);
}

static void
application_main_window_restore_saved_window_state (ApplicationMainWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	gboolean _tmp23_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GdkMonitor* monitor = NULL;
		GdkDisplay* _tmp3_;
		GdkMonitor* _tmp4_;
		GdkMonitor* _tmp5_;
		GdkMonitor* _tmp6_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		GdkMonitor* _tmp12_;
		_tmp3_ = display;
		_tmp4_ = gdk_display_get_primary_monitor (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		monitor = _tmp5_;
		_tmp6_ = monitor;
		if (_tmp6_ == NULL) {
			GdkDisplay* _tmp7_;
			GdkMonitor* _tmp8_;
			GdkMonitor* _tmp9_;
			_tmp7_ = display;
			_tmp8_ = gdk_display_get_monitor_at_point (_tmp7_, 1, 1);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (monitor);
			monitor = _tmp9_;
		}
		_tmp12_ = monitor;
		if (_tmp12_ != NULL) {
			gint _tmp13_;
			GdkMonitor* _tmp14_;
			GdkRectangle _tmp15_ = {0};
			GdkRectangle _tmp16_;
			_tmp13_ = self->priv->_window_width;
			_tmp14_ = monitor;
			gdk_monitor_get_geometry (_tmp14_, &_tmp15_);
			_tmp16_ = _tmp15_;
			_tmp11_ = _tmp13_ <= _tmp16_.width;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint _tmp17_;
			GdkMonitor* _tmp18_;
			GdkRectangle _tmp19_ = {0};
			GdkRectangle _tmp20_;
			_tmp17_ = self->priv->_window_height;
			_tmp18_ = monitor;
			gdk_monitor_get_geometry (_tmp18_, &_tmp19_);
			_tmp20_ = _tmp19_;
			_tmp10_ = _tmp17_ <= _tmp20_.height;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gint _tmp21_;
			gint _tmp22_;
			_tmp21_ = self->priv->_window_width;
			_tmp22_ = self->priv->_window_height;
			gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp21_, _tmp22_);
		}
		_g_object_unref0 (monitor);
	}
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), "window-position", GTK_WIN_POS_CENTER, NULL);
	_tmp23_ = self->priv->_window_maximized;
	if (_tmp23_) {
		gtk_window_maximize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	}
	_g_object_unref0 (display);
}

static gboolean
application_main_window_real_window_state_event (GtkWidget* base,
                                                 GdkEventWindowState* event)
{
	ApplicationMainWindow * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->new_window_state & GDK_WINDOW_STATE_WITHDRAWN) == 0) {
		gboolean maximized = FALSE;
		gboolean _tmp0_;
		maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		_tmp0_ = self->priv->_window_maximized;
		if (_tmp0_ != maximized) {
			application_main_window_set_window_maximized (self, maximized);
		}
	}
	result = GTK_WIDGET_CLASS (application_main_window_parent_class)->window_state_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

static void
application_main_window_real_size_allocate (GtkWidget* base,
                                            GtkAllocation* allocation)
{
	ApplicationMainWindow * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (application_main_window_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	_tmp1_ = self->priv->_window_maximized;
	if (!_tmp1_) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp2_;
		GdkDisplay* _tmp3_;
		GdkWindow* window = NULL;
		GdkWindow* _tmp4_;
		GdkWindow* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GdkDisplay* _tmp7_;
		_tmp2_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _g_object_ref0 (_tmp2_);
		display = _tmp3_;
		_tmp4_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = _g_object_ref0 (_tmp4_);
		window = _tmp5_;
		_tmp7_ = display;
		if (_tmp7_ != NULL) {
			GdkWindow* _tmp8_;
			_tmp8_ = window;
			_tmp6_ = _tmp8_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GdkMonitor* monitor = NULL;
			GdkDisplay* _tmp9_;
			GdkWindow* _tmp10_;
			GdkMonitor* _tmp11_;
			GdkMonitor* _tmp12_;
			gint width = 0;
			gint height = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			gint _tmp17_;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gint _tmp23_;
			_tmp9_ = display;
			_tmp10_ = window;
			_tmp11_ = gdk_display_get_monitor_at_window (_tmp9_, _tmp10_);
			_tmp12_ = _g_object_ref0 (_tmp11_);
			monitor = _tmp12_;
			width = 0;
			height = 0;
			gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp13_, &_tmp14_);
			width = _tmp13_;
			height = _tmp14_;
			_tmp17_ = self->priv->_window_width;
			if (_tmp17_ != width) {
				_tmp16_ = width > 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				GdkMonitor* _tmp18_;
				GdkRectangle _tmp19_ = {0};
				GdkRectangle _tmp20_;
				_tmp18_ = monitor;
				gdk_monitor_get_geometry (_tmp18_, &_tmp19_);
				_tmp20_ = _tmp19_;
				_tmp15_ = width <= _tmp20_.width;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				application_main_window_set_window_width (self, width);
			}
			_tmp23_ = self->priv->_window_height;
			if (_tmp23_ != height) {
				_tmp22_ = height > 0;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				GdkMonitor* _tmp24_;
				GdkRectangle _tmp25_ = {0};
				GdkRectangle _tmp26_;
				_tmp24_ = monitor;
				gdk_monitor_get_geometry (_tmp24_, &_tmp25_);
				_tmp26_ = _tmp25_;
				_tmp21_ = height <= _tmp26_.height;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				application_main_window_set_window_height (self, height);
			}
			_g_object_unref0 (monitor);
		}
		_g_object_unref0 (window);
		_g_object_unref0 (display);
	}
}

void
application_main_window_add_notification (ApplicationMainWindow* self,
                                          ComponentsInAppNotification* notification)
{
	GtkOverlay* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (COMPONENTS_IS_IN_APP_NOTIFICATION (notification));
	_tmp0_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (notification, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (notification, gtk_widget_get_type (), GtkWidget));
}

static void
_application_main_window_on_has_toplevel_focus_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	application_main_window_on_has_toplevel_focus ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_search_search_bar_search_text_changed (SearchBar* _sender,
                                                                   const gchar* search_text,
                                                                   gpointer self)
{
	application_main_window_on_search ((ApplicationMainWindow*) self, search_text);
}

static void
_application_main_window_on_folder_selected_folder_list_tree_folder_selected (FolderListTree* _sender,
                                                                              GearyFolder* folder,
                                                                              gpointer self)
{
	application_main_window_on_folder_selected ((ApplicationMainWindow*) self, folder);
}

static void
_application_main_window_on_move_conversation_folder_list_tree_move_conversation (FolderListTree* _sender,
                                                                                  GearyFolder* folder,
                                                                                  gpointer self)
{
	application_main_window_on_move_conversation ((ApplicationMainWindow*) self, folder);
}

static void
_application_main_window_on_copy_conversation_folder_list_tree_copy_conversation (FolderListTree* _sender,
                                                                                  GearyFolder* folder,
                                                                                  gpointer self)
{
	application_main_window_on_copy_conversation ((ApplicationMainWindow*) self, folder);
}

static void
_application_main_window_on_folder_activated_folder_list_tree_folder_activated (FolderListTree* _sender,
                                                                                GearyFolder* folder,
                                                                                gpointer self)
{
	application_main_window_on_folder_activated ((ApplicationMainWindow*) self, folder);
}

static void
_application_main_window_on_load_more_conversation_list_view_load_more (ConversationListView* _sender,
                                                                        gpointer self)
{
	application_main_window_on_load_more ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_mark_conversations_conversation_list_view_mark_conversations (ConversationListView* _sender,
                                                                                          GeeCollection* conversations,
                                                                                          GearyNamedFlag* flag,
                                                                                          gpointer self)
{
	application_main_window_on_mark_conversations ((ApplicationMainWindow*) self, conversations, flag);
}

static void
_application_main_window_on_conversations_selected_conversation_list_view_conversations_selected (ConversationListView* _sender,
                                                                                                  GeeSet* selected,
                                                                                                  gpointer self)
{
	application_main_window_on_conversations_selected ((ApplicationMainWindow*) self, selected);
}

static void
_application_main_window_on_conversation_activated_conversation_list_view_conversation_activated (ConversationListView* _sender,
                                                                                                  GearyAppConversation* activated,
                                                                                                  gboolean single,
                                                                                                  gpointer self)
{
	application_main_window_on_conversation_activated ((ApplicationMainWindow*) self, activated, single);
}

static void
_application_main_window_on_visible_conversations_changed_conversation_list_view_visible_conversations_changed (ConversationListView* _sender,
                                                                                                                GeeSet* visible,
                                                                                                                gpointer self)
{
	application_main_window_on_visible_conversations_changed ((ApplicationMainWindow*) self, visible);
}

static void
_application_main_window_on_conversation_view_added_conversation_viewer_conversation_added (ConversationViewer* _sender,
                                                                                            ConversationListBox* list,
                                                                                            gpointer self)
{
	application_main_window_on_conversation_view_added ((ApplicationMainWindow*) self, list);
}

static void
__lambda201_ (ApplicationMainWindow* self)
{
	GtkRevealer* _tmp0_;
	ComponentsConversationHeaderBar* _tmp1_;
	ComponentsConversationActions* _tmp2_;
	ComponentsConversationActions* _tmp3_;
	ComponentsConversationHeaderBar* _tmp4_;
	ComponentsConversationActions* _tmp5_;
	_tmp0_ = self->priv->conversation_viewer_actions_revealer;
	_tmp1_ = self->conversation_headerbar;
	_tmp2_ = components_conversation_header_bar_get_shown_actions (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->conversation_headerbar;
	_tmp5_ = _tmp4_->compact_actions;
	gtk_revealer_set_reveal_child (_tmp0_, _tmp3_ == _tmp5_);
}

static void
___lambda201__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda201_ ((ApplicationMainWindow*) self);
}

static void
_vala_array_add8 (FolderPopover** * array,
                  gint* length,
                  gint* size,
                  FolderPopover* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolderPopover*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_application_main_window_on_move_conversation_folder_popover_folder_selected (FolderPopover* _sender,
                                                                              GearyFolder* folder,
                                                                              gpointer self)
{
	application_main_window_on_move_conversation ((ApplicationMainWindow*) self, folder);
}

static void
_vala_array_add9 (FolderPopover** * array,
                  gint* length,
                  gint* size,
                  FolderPopover* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolderPopover*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_application_main_window_on_copy_conversation_folder_popover_folder_selected (FolderPopover* _sender,
                                                                              GearyFolder* folder,
                                                                              gpointer self)
{
	application_main_window_on_copy_conversation ((ApplicationMainWindow*) self, folder);
}

static void
application_main_window_setup_layout (ApplicationMainWindow* self,
                                      ApplicationConfiguration* config)
{
	ApplicationClient* _tmp0_;
	ApplicationClient* _tmp1_;
	GearyEngine* _tmp2_;
	GearyEngine* _tmp3_;
	SearchBar* _tmp4_;
	SearchBar* _tmp5_;
	SearchBar* _tmp6_;
	GtkBox* _tmp7_;
	SearchBar* _tmp8_;
	FolderListTree* _tmp9_;
	FolderListTree* _tmp10_;
	FolderListTree* _tmp11_;
	FolderListTree* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	FolderListTree* _tmp14_;
	GtkBox* _tmp15_;
	ComponentsInfoBarStack* _tmp16_;
	ApplicationClient* _tmp17_;
	ApplicationClient* _tmp18_;
	ApplicationConfiguration* _tmp19_;
	ApplicationConfiguration* _tmp20_;
	ConversationListView* _tmp21_;
	ConversationListView* _tmp22_;
	ConversationListView* _tmp23_;
	ConversationListView* _tmp24_;
	ConversationListView* _tmp25_;
	ConversationListView* _tmp26_;
	ConversationListView* _tmp27_;
	GtkScrolledWindow* _tmp28_;
	ConversationListView* _tmp29_;
	ApplicationClient* _tmp30_;
	ApplicationClient* _tmp31_;
	ApplicationConfiguration* _tmp32_;
	ApplicationConfiguration* _tmp33_;
	ConversationViewer* _tmp34_;
	ConversationViewer* _tmp35_;
	ConversationViewer* _tmp36_;
	ConversationViewer* _tmp37_;
	GtkBox* _tmp38_;
	ConversationViewer* _tmp39_;
	ComponentsConversationListHeaderBar* _tmp40_;
	SearchBar* _tmp41_;
	ComponentsConversationHeaderBar* _tmp42_;
	ConversationViewer* _tmp43_;
	GtkSearchBar* _tmp44_;
	ComponentsConversationHeaderBar* _tmp45_;
	StatusBar* _tmp46_;
	StatusBar* _tmp47_;
	MonitoredSpinner* _tmp48_;
	MonitoredSpinner* _tmp49_;
	GearyAggregateProgressMonitor* _tmp50_;
	StatusBar* _tmp51_;
	MonitoredSpinner* _tmp52_;
	StatusBar* _tmp53_;
	ComponentsConversationHeaderBar* _tmp54_;
	ComponentsConversationActions* _tmp55_;
	ComponentsConversationActions* _tmp56_;
	ComponentsConversationActions* _tmp57_;
	ComponentsConversationActions* _tmp58_;
	ComponentsConversationActions** _tmp59_;
	ComponentsConversationActions** _tmp60_;
	gint _tmp60__length1;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::has-toplevel-focus", (GCallback) _application_main_window_on_has_toplevel_focus_g_object_notify, self, 0);
	_tmp0_ = application_main_window_get_application (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = application_client_get_engine (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = search_bar_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	application_main_window_set_search_bar (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_search_bar;
	g_signal_connect_object (_tmp6_, "search-text-changed", (GCallback) _application_main_window_on_search_search_bar_search_text_changed, self, 0);
	_tmp7_ = self->priv->conversation_list_box;
	_tmp8_ = self->priv->_search_bar;
	gtk_box_pack_start (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp9_ = self->priv->_folder_list;
	g_signal_connect_object (_tmp9_, "folder-selected", (GCallback) _application_main_window_on_folder_selected_folder_list_tree_folder_selected, self, 0);
	_tmp10_ = self->priv->_folder_list;
	g_signal_connect_object (_tmp10_, "move-conversation", (GCallback) _application_main_window_on_move_conversation_folder_list_tree_move_conversation, self, 0);
	_tmp11_ = self->priv->_folder_list;
	g_signal_connect_object (_tmp11_, "copy-conversation", (GCallback) _application_main_window_on_copy_conversation_folder_list_tree_copy_conversation, self, 0);
	_tmp12_ = self->priv->_folder_list;
	g_signal_connect_object (_tmp12_, "folder-activated", (GCallback) _application_main_window_on_folder_activated_folder_list_tree_folder_activated, self, 0);
	_tmp13_ = self->priv->folder_list_scrolled;
	_tmp14_ = self->priv->_folder_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->conversation_list_box;
	_tmp16_ = self->priv->_conversation_list_info_bars;
	gtk_box_pack_start (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp17_ = application_main_window_get_application (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = application_client_get_config (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = conversation_list_view_new (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	application_main_window_set_conversation_list_view (self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->_conversation_list_view;
	g_signal_connect_object (_tmp23_, "load-more", (GCallback) _application_main_window_on_load_more_conversation_list_view_load_more, self, 0);
	_tmp24_ = self->priv->_conversation_list_view;
	g_signal_connect_object (_tmp24_, "mark-conversations", (GCallback) _application_main_window_on_mark_conversations_conversation_list_view_mark_conversations, self, 0);
	_tmp25_ = self->priv->_conversation_list_view;
	g_signal_connect_object (_tmp25_, "conversations-selected", (GCallback) _application_main_window_on_conversations_selected_conversation_list_view_conversations_selected, self, 0);
	_tmp26_ = self->priv->_conversation_list_view;
	g_signal_connect_object (_tmp26_, "conversation-activated", (GCallback) _application_main_window_on_conversation_activated_conversation_list_view_conversation_activated, self, 0);
	_tmp27_ = self->priv->_conversation_list_view;
	g_signal_connect_object (_tmp27_, "visible-conversations-changed", (GCallback) _application_main_window_on_visible_conversations_changed_conversation_list_view_visible_conversations_changed, self, 0);
	_tmp28_ = self->priv->conversation_list_scrolled;
	_tmp29_ = self->priv->_conversation_list_view;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	_tmp30_ = application_main_window_get_application (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = application_client_get_config (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = conversation_viewer_new (_tmp33_);
	g_object_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	application_main_window_set_conversation_viewer (self, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->_conversation_viewer;
	g_signal_connect_object (_tmp36_, "conversation-added", (GCallback) _application_main_window_on_conversation_view_added_conversation_viewer_conversation_added, self, 0);
	_tmp37_ = self->priv->_conversation_viewer;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp38_ = self->priv->conversation_viewer_box;
	_tmp39_ = self->priv->_conversation_viewer;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
	_tmp40_ = self->priv->conversation_list_headerbar;
	_tmp41_ = self->priv->_search_bar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, G_TYPE_OBJECT, GObject), "search-open", G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, G_TYPE_OBJECT, GObject), "search-mode-enabled", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp42_ = self->conversation_headerbar;
	_tmp43_ = self->priv->_conversation_viewer;
	_tmp44_ = _tmp43_->conversation_find_bar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, G_TYPE_OBJECT, GObject), "find-open", G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, G_TYPE_OBJECT, GObject), "search-mode-enabled", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp45_ = self->conversation_headerbar;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, G_TYPE_OBJECT, GObject), "notify::shown-actions", (GCallback) ___lambda201__g_object_notify, self, 0);
	_tmp46_ = self->priv->_status_bar;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget), -1, APPLICATION_MAIN_WINDOW_STATUS_BAR_HEIGHT);
	_tmp47_ = self->priv->_status_bar;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_container_get_type (), GtkContainer), (guint) 2);
	_tmp48_ = self->priv->spinner;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget), APPLICATION_MAIN_WINDOW_STATUS_BAR_HEIGHT - 2, -1);
	_tmp49_ = self->priv->spinner;
	_tmp50_ = self->priv->progress_monitor;
	monitored_spinner_set_progress_monitor (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp51_ = self->priv->_status_bar;
	_tmp52_ = self->priv->spinner;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget));
	_tmp53_ = self->priv->_status_bar;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	_tmp54_ = self->conversation_headerbar;
	_tmp55_ = _tmp54_->full_actions;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_tmp57_ = self->priv->conversation_list_actions;
	_tmp58_ = _g_object_ref0 (_tmp57_);
	_tmp59_ = g_new0 (ComponentsConversationActions*, 2 + 1);
	_tmp59_[0] = _tmp56_;
	_tmp59_[1] = _tmp58_;
	self->priv->folder_conversation_actions = (_vala_array_free (self->priv->folder_conversation_actions, self->priv->folder_conversation_actions_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->folder_conversation_actions = _tmp59_;
	self->priv->folder_conversation_actions_length1 = 2;
	self->priv->_folder_conversation_actions_size_ = self->priv->folder_conversation_actions_length1;
	_tmp60_ = self->priv->folder_conversation_actions;
	_tmp60__length1 = self->priv->folder_conversation_actions_length1;
	{
		ComponentsConversationActions** actions_collection = NULL;
		gint actions_collection_length1 = 0;
		gint _actions_collection_size_ = 0;
		gint actions_it = 0;
		actions_collection = _tmp60_;
		actions_collection_length1 = _tmp60__length1;
		for (actions_it = 0; actions_it < actions_collection_length1; actions_it = actions_it + 1) {
			ComponentsConversationActions* _tmp61_;
			ComponentsConversationActions* actions = NULL;
			_tmp61_ = _g_object_ref0 (actions_collection[actions_it]);
			actions = _tmp61_;
			{
				FolderPopover* move = NULL;
				ComponentsConversationActions* _tmp62_;
				FolderPopover* _tmp63_;
				FolderPopover* _tmp64_;
				FolderPopover* _tmp65_;
				FolderPopover* _tmp66_;
				FolderPopover* _tmp67_;
				FolderPopover* _tmp68_;
				FolderPopover* copy = NULL;
				ComponentsConversationActions* _tmp69_;
				FolderPopover* _tmp70_;
				FolderPopover* _tmp71_;
				FolderPopover* _tmp72_;
				FolderPopover* _tmp73_;
				FolderPopover* _tmp74_;
				FolderPopover* _tmp75_;
				_tmp62_ = actions;
				_tmp63_ = components_conversation_actions_get_move_folder_menu (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = _g_object_ref0 (_tmp64_);
				move = _tmp65_;
				_tmp66_ = move;
				_tmp67_ = _g_object_ref0 (_tmp66_);
				_vala_array_add8 (&self->priv->folder_popovers, &self->priv->folder_popovers_length1, &self->priv->_folder_popovers_size_, _tmp67_);
				_tmp68_ = move;
				g_signal_connect_object (_tmp68_, "folder-selected", (GCallback) _application_main_window_on_move_conversation_folder_popover_folder_selected, self, 0);
				_tmp69_ = actions;
				_tmp70_ = components_conversation_actions_get_copy_folder_menu (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = _g_object_ref0 (_tmp71_);
				copy = _tmp72_;
				_tmp73_ = copy;
				_tmp74_ = _g_object_ref0 (_tmp73_);
				_vala_array_add9 (&self->priv->folder_popovers, &self->priv->folder_popovers_length1, &self->priv->_folder_popovers_size_, _tmp74_);
				_tmp75_ = copy;
				g_signal_connect_object (_tmp75_, "folder-selected", (GCallback) _application_main_window_on_copy_conversation_folder_popover_folder_selected, self, 0);
				_g_object_unref0 (copy);
				_g_object_unref0 (move);
				_g_object_unref0 (actions);
			}
		}
	}
}

/** {@inheritDoc} */
static gboolean
application_main_window_real_key_press_event (GtkWidget* base,
                                              GdkEventKey* event)
{
	ApplicationMainWindow * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	application_main_window_check_shift_event (self, event);
	result = GTK_WIDGET_CLASS (application_main_window_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

/** {@inheritDoc} */
static gboolean
application_main_window_real_key_release_event (GtkWidget* base,
                                                GdkEventKey* event)
{
	ApplicationMainWindow * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	application_main_window_check_shift_event (self, event);
	result = GTK_WIDGET_CLASS (application_main_window_parent_class)->key_release_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

gboolean
application_main_window_prompt_empty_folder (ApplicationMainWindow* self,
                                             GearyFolderSpecialUse type)
{
	gchar* folder_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ConfirmationDialog* dialog = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ConfirmationDialog* _tmp12_;
	ConfirmationDialog* _tmp13_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp0_ = util_i18n_to_folder_type_display_name (type);
	_tmp1_ = g_strdup (_tmp0_);
	folder_name = _tmp1_;
	_tmp2_ = g_strdup_printf (_ ("Empty all email from your %s folder?"), folder_name);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_ ("This removes the email from Geary and your email server."), "  <b>", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, _ ("This cannot be undone."), NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (_ ("Empty %s"), folder_name);
	_tmp11_ = _tmp10_;
	_tmp12_ = confirmation_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp3_, _tmp9_, _tmp11_, "destructive-action");
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	dialog = _tmp13_;
	alert_dialog_use_secondary_markup (G_TYPE_CHECK_INSTANCE_CAST (dialog, TYPE_ALERT_DIALOG, AlertDialog), TRUE);
	alert_dialog_set_focus_response (G_TYPE_CHECK_INSTANCE_CAST (dialog, TYPE_ALERT_DIALOG, AlertDialog), GTK_RESPONSE_CANCEL);
	result = alert_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, TYPE_ALERT_DIALOG, AlertDialog)) == GTK_RESPONSE_OK;
	_g_object_unref0 (dialog);
	_g_free0 (folder_name);
	return result;
}

static void
application_main_window_undo_data_free (gpointer _data)
{
	ApplicationMainWindowUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowUndoData, _data_);
}

static void
application_main_window_undo (ApplicationMainWindow* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ApplicationMainWindowUndoData* _data_;
	ApplicationMainWindow* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data_ = g_slice_new0 (ApplicationMainWindowUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_main_window_undo_co (_data_);
}

static void
application_main_window_undo_finish (ApplicationMainWindow* self,
                                     GAsyncResult* _res_)
{
	ApplicationMainWindowUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Un-does the last executed application command, if any. */
static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->selected);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
___lambda183_ (Block16Data* _data16_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data16_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationAccountContext* _tmp0_;
		ApplicationCommandStack* _tmp1_;
		ApplicationCommandStack* _tmp2_;
		_tmp0_ = _data16_->selected;
		_tmp1_ = application_account_context_get_commands (_tmp0_);
		_tmp2_ = _tmp1_;
		application_command_stack_undo_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		ApplicationAccountContext* _tmp3_;
		GearyAccount* _tmp4_;
		GearyAccount* _tmp5_;
		GearyAccountInformation* _tmp6_;
		GearyAccountInformation* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _data16_->selected;
		_tmp4_ = application_account_context_get_account (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_account_get_information (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = err;
		application_main_window_handle_error (self, _tmp7_, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda183__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda183_ (self, source_object, res);
	block16_data_unref (self);
}

static gboolean
application_main_window_undo_co (ApplicationMainWindowUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data16_ = g_slice_new0 (Block16Data);
	_data_->_data16_->_ref_count_ = 1;
	_data_->_data16_->self = g_object_ref (_data_->self);
	_data_->_data16_->_async_data_ = _data_;
	_data_->_tmp0_ = application_main_window_get_selected_account_context (_data_->self);
	_data_->_data16_->selected = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->_data16_->selected;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->_data16_->selected;
		_data_->_tmp3_ = application_account_context_get_commands (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->_data16_->selected;
		_data_->_tmp6_ = application_account_context_get_cancellable (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		application_command_stack_undo (_data_->_tmp4_, _data_->_tmp7_, ____lambda183__gasync_ready_callback, block16_data_ref (_data_->_data16_));
	}
	block16_data_unref (_data_->_data16_);
	_data_->_data16_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_redo_data_free (gpointer _data)
{
	ApplicationMainWindowRedoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowRedoData, _data_);
}

static void
application_main_window_redo (ApplicationMainWindow* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ApplicationMainWindowRedoData* _data_;
	ApplicationMainWindow* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data_ = g_slice_new0 (ApplicationMainWindowRedoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_redo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_main_window_redo_co (_data_);
}

static void
application_main_window_redo_finish (ApplicationMainWindow* self,
                                     GAsyncResult* _res_)
{
	ApplicationMainWindowRedoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Re-does the last undone application command, if any. */
static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->selected);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
___lambda184_ (Block17Data* _data17_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data17_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationAccountContext* _tmp0_;
		ApplicationCommandStack* _tmp1_;
		ApplicationCommandStack* _tmp2_;
		_tmp0_ = _data17_->selected;
		_tmp1_ = application_account_context_get_commands (_tmp0_);
		_tmp2_ = _tmp1_;
		application_command_stack_redo_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		ApplicationAccountContext* _tmp3_;
		GearyAccount* _tmp4_;
		GearyAccount* _tmp5_;
		GearyAccountInformation* _tmp6_;
		GearyAccountInformation* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _data17_->selected;
		_tmp4_ = application_account_context_get_account (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_account_get_information (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = err;
		application_main_window_handle_error (self, _tmp7_, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda184__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda184_ (self, source_object, res);
	block17_data_unref (self);
}

static gboolean
application_main_window_redo_co (ApplicationMainWindowRedoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data17_ = g_slice_new0 (Block17Data);
	_data_->_data17_->_ref_count_ = 1;
	_data_->_data17_->self = g_object_ref (_data_->self);
	_data_->_data17_->_async_data_ = _data_;
	_data_->_tmp0_ = application_main_window_get_selected_account_context (_data_->self);
	_data_->_data17_->selected = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->_data17_->selected;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->_data17_->selected;
		_data_->_tmp3_ = application_account_context_get_commands (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->_data17_->selected;
		_data_->_tmp6_ = application_account_context_get_cancellable (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		application_command_stack_redo (_data_->_tmp4_, _data_->_tmp7_, ____lambda184__gasync_ready_callback, block17_data_ref (_data_->_data17_));
	}
	block17_data_unref (_data_->_data17_);
	_data_->_data17_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_update_command_actions (ApplicationMainWindow* self)
{
	ApplicationAccountContext* selected = NULL;
	ApplicationAccountContext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ApplicationAccountContext* _tmp2_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	gboolean _tmp10_ = FALSE;
	ApplicationAccountContext* _tmp11_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = application_main_window_get_selected_account_context (self);
	selected = _tmp0_;
	_tmp2_ = selected;
	if (_tmp2_ != NULL) {
		ApplicationAccountContext* _tmp3_;
		ApplicationCommandStack* _tmp4_;
		ApplicationCommandStack* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = selected;
		_tmp4_ = application_account_context_get_commands (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = application_command_stack_get_can_undo (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = application_main_window_get_edit_action (self, ACTION_EDIT_UNDO);
	_tmp9_ = _tmp8_;
	g_simple_action_set_enabled (_tmp9_, _tmp1_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = selected;
	if (_tmp11_ != NULL) {
		ApplicationAccountContext* _tmp12_;
		ApplicationCommandStack* _tmp13_;
		ApplicationCommandStack* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp12_ = selected;
		_tmp13_ = application_account_context_get_commands (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = application_command_stack_get_can_redo (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = _tmp16_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp17_ = application_main_window_get_edit_action (self, ACTION_EDIT_REDO);
	_tmp18_ = _tmp17_;
	g_simple_action_set_enabled (_tmp18_, _tmp10_);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (selected);
}

static gboolean
application_main_window_prompt_delete_conversations (ApplicationMainWindow* self,
                                                     gint count)
{
	ConfirmationDialog* dialog = NULL;
	ConfirmationDialog* _tmp0_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp0_ = confirmation_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ngettext ("Do you want to permanently delete this conversation?", "Do you want to permanently delete these conversations?", (gulong) count), NULL, _ ("Delete"), "destructive-action");
	dialog = _tmp0_;
	result = alert_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, TYPE_ALERT_DIALOG, AlertDialog)) == GTK_RESPONSE_OK;
	_g_object_unref0 (dialog);
	return result;
}

static gboolean
application_main_window_prompt_delete_messages (ApplicationMainWindow* self,
                                                gint count)
{
	ConfirmationDialog* dialog = NULL;
	ConfirmationDialog* _tmp0_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	_tmp0_ = confirmation_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ngettext ("Do you want to permanently delete this message?", "Do you want to permanently delete these messages?", (gulong) count), NULL, _ ("Delete"), "destructive-action");
	dialog = _tmp0_;
	result = alert_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, TYPE_ALERT_DIALOG, AlertDialog)) == GTK_RESPONSE_OK;
	_g_object_unref0 (dialog);
	return result;
}

static void
application_main_window_load_conversations_for_email_data_free (gpointer _data)
{
	ApplicationMainWindowLoadConversationsForEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->location);
	_g_object_unref0 (_data_->to_load);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowLoadConversationsForEmailData, _data_);
}

static void
application_main_window_load_conversations_for_email (ApplicationMainWindow* self,
                                                      GearyFolder* location,
                                                      GeeCollection* to_load,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	ApplicationMainWindowLoadConversationsForEmailData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (location, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_load, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationMainWindowLoadConversationsForEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_load_conversations_for_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp1_;
	_tmp2_ = _g_object_ref0 (to_load);
	_g_object_unref0 (_data_->to_load);
	_data_->to_load = _tmp2_;
	application_main_window_load_conversations_for_email_co (_data_);
}

static GeeCollection*
application_main_window_load_conversations_for_email_finish (ApplicationMainWindow* self,
                                                             GAsyncResult* _res_)
{
	GeeCollection* result;
	ApplicationMainWindowLoadConversationsForEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_main_window_load_conversations_for_email_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	ApplicationMainWindowLoadConversationsForEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_load_conversations_for_email_co (_data_);
}

static gboolean
application_main_window_load_conversations_for_email_co (ApplicationMainWindowLoadConversationsForEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->was_loaded = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_conversations;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->_conversations;
		_data_->_tmp3_ = geary_app_conversation_monitor_get_base_folder (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ == _data_->location;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		{
			_data_->_tmp5_ = _data_->self->priv->_conversations;
			_data_->_tmp6_ = _data_->self->priv->folder_open;
			_data_->_state_ = 1;
			geary_app_conversation_monitor_load_email (_data_->_tmp5_, _data_->to_load, _data_->_tmp6_, application_main_window_load_conversations_for_email_ready, _data_);
			return FALSE;
			_state_1:
			geary_app_conversation_monitor_load_email_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->was_loaded = TRUE;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->err;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_debug ("application-main-window.vala:1515: Error loading conversations to show" \
" them: %s", _data_->_tmp8_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->loaded = _data_->_tmp9_;
	if (_data_->was_loaded) {
		_data_->_tmp12_ = _data_->self->priv->_conversations;
		_data_->_tmp11_ = _data_->_tmp12_ != NULL;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp13_ = _data_->self->priv->_conversations;
		_data_->_tmp14_ = geary_app_conversation_monitor_get_base_folder (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp10_ = _data_->_tmp15_ == _data_->location;
	} else {
		_data_->_tmp10_ = FALSE;
	}
	if (_data_->_tmp10_) {
		{
			_data_->_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->to_load, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_id_it = _data_->_tmp16_;
			while (TRUE) {
				_data_->_tmp17_ = _data_->_id_it;
				if (!gee_iterator_next (_data_->_tmp17_)) {
					break;
				}
				_data_->_tmp18_ = _data_->_id_it;
				_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
				_data_->id = (GearyEmailIdentifier*) _data_->_tmp19_;
				_data_->_tmp20_ = _data_->self->priv->_conversations;
				_data_->_tmp21_ = _data_->id;
				_data_->_tmp22_ = geary_app_conversation_monitor_get_by_email_identifier (_data_->_tmp20_, _data_->_tmp21_);
				_data_->conversation = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->conversation;
				if (_data_->_tmp23_ != NULL) {
					_data_->_tmp24_ = _data_->loaded;
					_data_->_tmp25_ = _data_->conversation;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp25_);
				}
				_g_object_unref0 (_data_->conversation);
				_g_object_unref0 (_data_->id);
			}
			_g_object_unref0 (_data_->_id_it);
		}
	}
	_data_->result = G_TYPE_CHECK_INSTANCE_CAST (_data_->loaded, GEE_TYPE_COLLECTION, GeeCollection);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline void
application_main_window_handle_error (ApplicationMainWindow* self,
                                      GearyAccountInformation* account,
                                      GError* _error_)
{
	GearyProblemReport* _tmp0_ = NULL;
	GearyProblemReport* report = NULL;
	GearyProblemReport* _tmp3_;
	ApplicationController* _tmp4_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((account == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (_error_ != NULL);
	if (account != NULL) {
		GearyAccountProblemReport* _tmp1_;
		_tmp1_ = geary_account_problem_report_new (account, _error_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport);
	} else {
		GearyProblemReport* _tmp2_;
		_tmp2_ = geary_problem_report_new (_error_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (_tmp0_);
	report = _tmp3_;
	_tmp4_ = self->priv->controller;
	composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), report);
	_g_object_unref0 (report);
	_g_object_unref0 (_tmp0_);
}

static void
application_main_window_update_ui (ApplicationMainWindow* self)
{
	gint64 now = 0LL;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	now = g_get_monotonic_time () / (1000 * 1000);
	if ((self->priv->update_ui_last + APPLICATION_MAIN_WINDOW_UPDATE_UI_INTERVAL) < now) {
		ConversationViewer* _tmp0_;
		ConversationListBox* _tmp1_;
		ConversationListBox* _tmp2_;
		ConversationListStore* list_store = NULL;
		ConversationListView* _tmp6_;
		ConversationListStore* _tmp7_;
		ConversationListStore* _tmp8_;
		ConversationListStore* _tmp9_;
		self->priv->update_ui_last = now;
		_tmp0_ = self->priv->_conversation_viewer;
		_tmp1_ = conversation_viewer_get_current_list (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			ConversationViewer* _tmp3_;
			ConversationListBox* _tmp4_;
			ConversationListBox* _tmp5_;
			_tmp3_ = self->priv->_conversation_viewer;
			_tmp4_ = conversation_viewer_get_current_list (_tmp3_);
			_tmp5_ = _tmp4_;
			conversation_list_box_update_display (_tmp5_);
		}
		_tmp6_ = self->priv->_conversation_list_view;
		_tmp7_ = conversation_list_view_get_model (_tmp6_);
		_tmp8_ = IS_CONVERSATION_LIST_STORE (_tmp7_) ? ((ConversationListStore*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		list_store = _tmp8_;
		_tmp9_ = list_store;
		if (_tmp9_ != NULL) {
			ConversationListStore* _tmp10_;
			_tmp10_ = list_store;
			conversation_list_store_update_display (_tmp10_);
		}
		_g_object_unref0 (list_store);
	}
}

static void
application_main_window_select_account (ApplicationMainWindow* self,
                                        GearyAccount* account)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((account == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	_tmp0_ = self->priv->_selected_account;
	if (_tmp0_ != account) {
		GearyAccount* _tmp1_;
		SearchBar* _tmp5_;
		_tmp1_ = self->priv->_selected_account;
		if (_tmp1_ != NULL) {
			FolderPopover** _tmp2_;
			gint _tmp2__length1;
			_tmp2_ = self->priv->folder_popovers;
			_tmp2__length1 = self->priv->folder_popovers_length1;
			{
				FolderPopover** menu_collection = NULL;
				gint menu_collection_length1 = 0;
				gint _menu_collection_size_ = 0;
				gint menu_it = 0;
				menu_collection = _tmp2_;
				menu_collection_length1 = _tmp2__length1;
				for (menu_it = 0; menu_it < menu_collection_length1; menu_it = menu_it + 1) {
					FolderPopover* _tmp3_;
					FolderPopover* menu = NULL;
					_tmp3_ = _g_object_ref0 (menu_collection[menu_it]);
					menu = _tmp3_;
					{
						FolderPopover* _tmp4_;
						_tmp4_ = menu;
						folder_popover_clear (_tmp4_);
						_g_object_unref0 (menu);
					}
				}
			}
		}
		application_main_window_set_selected_account (self, account);
		_tmp5_ = self->priv->_search_bar;
		search_bar_set_account (_tmp5_, account);
		if (account != NULL) {
			GearyServiceProvider service_provider = 0;
			GearyAccountInformation* _tmp6_;
			GearyAccountInformation* _tmp7_;
			GearyServiceProvider _tmp8_;
			GearyServiceProvider _tmp9_;
			ComponentsConversationActions* _tmp10_;
			ComponentsConversationHeaderBar* _tmp11_;
			ComponentsConversationActions* _tmp12_;
			ComponentsConversationHeaderBar* _tmp13_;
			ComponentsConversationActions* _tmp14_;
			FolderPopover** _tmp15_;
			gint _tmp15__length1;
			_tmp6_ = geary_account_get_information (account);
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_account_information_get_service_provider (_tmp7_);
			_tmp9_ = _tmp8_;
			service_provider = _tmp9_;
			_tmp10_ = self->priv->conversation_list_actions;
			components_conversation_actions_set_service_provider (_tmp10_, service_provider);
			_tmp11_ = self->conversation_headerbar;
			_tmp12_ = _tmp11_->full_actions;
			components_conversation_actions_set_service_provider (_tmp12_, service_provider);
			_tmp13_ = self->conversation_headerbar;
			_tmp14_ = _tmp13_->compact_actions;
			components_conversation_actions_set_service_provider (_tmp14_, service_provider);
			_tmp15_ = self->priv->folder_popovers;
			_tmp15__length1 = self->priv->folder_popovers_length1;
			{
				FolderPopover** menu_collection = NULL;
				gint menu_collection_length1 = 0;
				gint _menu_collection_size_ = 0;
				gint menu_it = 0;
				menu_collection = _tmp15_;
				menu_collection_length1 = _tmp15__length1;
				for (menu_it = 0; menu_it < menu_collection_length1; menu_it = menu_it + 1) {
					FolderPopover* _tmp16_;
					FolderPopover* menu = NULL;
					_tmp16_ = _g_object_ref0 (menu_collection[menu_it]);
					menu = _tmp16_;
					{
						GeeCollection* folders = NULL;
						GeeCollection* _tmp17_;
						GeeHashMap* map = NULL;
						GeeHashMap* _tmp18_;
						_tmp17_ = geary_account_list_folders (account);
						folders = _tmp17_;
						_tmp18_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
						map = _tmp18_;
						{
							GeeIterator* _folder_it = NULL;
							GeeCollection* _tmp19_;
							GeeIterator* _tmp20_;
							_tmp19_ = folders;
							_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable));
							_folder_it = _tmp20_;
							while (TRUE) {
								GeeIterator* _tmp21_;
								GearyFolder* folder = NULL;
								GeeIterator* _tmp22_;
								gpointer _tmp23_;
								ApplicationFolderContext* context = NULL;
								GearyFolder* _tmp24_;
								ApplicationFolderContext* _tmp25_;
								GearyFolder* _tmp26_;
								GearyFolderSpecialUse _tmp27_;
								GearyFolderSpecialUse _tmp28_;
								GeeHashMap* _tmp29_;
								GearyFolder* _tmp30_;
								GearyFolderPath* _tmp31_;
								GearyFolderPath* _tmp32_;
								gchar* _tmp33_;
								gchar* _tmp34_;
								gchar* _tmp35_;
								gchar* _tmp36_;
								ApplicationFolderContext* _tmp37_;
								const gchar* _tmp38_;
								const gchar* _tmp39_;
								_tmp21_ = _folder_it;
								if (!gee_iterator_next (_tmp21_)) {
									break;
								}
								_tmp22_ = _folder_it;
								_tmp23_ = gee_iterator_get (_tmp22_);
								folder = (GearyFolder*) _tmp23_;
								_tmp24_ = folder;
								_tmp25_ = application_folder_context_new (_tmp24_);
								context = _tmp25_;
								_tmp26_ = folder;
								_tmp27_ = geary_folder_get_used_as (_tmp26_);
								_tmp28_ = _tmp27_;
								if (_tmp28_ == GEARY_FOLDER_SPECIAL_USE_NONE) {
									_g_object_unref0 (context);
									_g_object_unref0 (folder);
									continue;
								}
								_tmp29_ = map;
								_tmp30_ = folder;
								_tmp31_ = geary_folder_get_path (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = geary_folder_path_to_string (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = string_substring (_tmp34_, (glong) 1, (glong) -1);
								_tmp36_ = _tmp35_;
								_tmp37_ = context;
								_tmp38_ = application_folder_context_get_display_name (_tmp37_);
								_tmp39_ = _tmp38_;
								gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp36_, _tmp39_);
								_g_free0 (_tmp36_);
								_g_free0 (_tmp34_);
								_g_object_unref0 (context);
								_g_object_unref0 (folder);
							}
							_g_object_unref0 (_folder_it);
						}
						{
							GeeIterator* _folder_it = NULL;
							GeeCollection* _tmp40_;
							GeeIterator* _tmp41_;
							_tmp40_ = folders;
							_tmp41_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ITERABLE, GeeIterable));
							_folder_it = _tmp41_;
							while (TRUE) {
								GeeIterator* _tmp42_;
								GearyFolder* folder = NULL;
								GeeIterator* _tmp43_;
								gpointer _tmp44_;
								ApplicationFolderContext* context = NULL;
								GearyFolder* _tmp45_;
								ApplicationFolderContext* _tmp46_;
								FolderPopover* _tmp47_;
								ApplicationFolderContext* _tmp48_;
								GeeHashMap* _tmp49_;
								_tmp42_ = _folder_it;
								if (!gee_iterator_next (_tmp42_)) {
									break;
								}
								_tmp43_ = _folder_it;
								_tmp44_ = gee_iterator_get (_tmp43_);
								folder = (GearyFolder*) _tmp44_;
								_tmp45_ = folder;
								_tmp46_ = application_folder_context_new (_tmp45_);
								context = _tmp46_;
								_tmp47_ = menu;
								_tmp48_ = context;
								_tmp49_ = map;
								folder_popover_add_folder (_tmp47_, _tmp48_, _tmp49_);
								_g_object_unref0 (context);
								_g_object_unref0 (folder);
							}
							_g_object_unref0 (_folder_it);
						}
						_g_object_unref0 (map);
						_g_object_unref0 (folders);
						_g_object_unref0 (menu);
					}
				}
			}
		}
		application_main_window_update_command_actions (self);
	}
}

static void
application_main_window_select_conversations_data_free (gpointer _data)
{
	ApplicationMainWindowSelectConversationsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to_select);
	_g_object_unref0 (_data_->scroll_to);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowSelectConversationsData, _data_);
}

static void
application_main_window_select_conversations (ApplicationMainWindow* self,
                                              GeeCollection* to_select,
                                              GeeCollection* scroll_to,
                                              gboolean is_interactive,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ApplicationMainWindowSelectConversationsData* _data_;
	ApplicationMainWindow* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_select, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (scroll_to, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationMainWindowSelectConversationsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_select_conversations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_select);
	_g_object_unref0 (_data_->to_select);
	_data_->to_select = _tmp1_;
	_tmp2_ = _g_object_ref0 (scroll_to);
	_g_object_unref0 (_data_->scroll_to);
	_data_->scroll_to = _tmp2_;
	_data_->is_interactive = is_interactive;
	application_main_window_select_conversations_co (_data_);
}

static void
application_main_window_select_conversations_finish (ApplicationMainWindow* self,
                                                     GAsyncResult* _res_)
{
	ApplicationMainWindowSelectConversationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_main_window_select_conversations_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	ApplicationMainWindowSelectConversationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_select_conversations_co (_data_);
}

static gboolean
application_main_window_select_conversations_co (ApplicationMainWindowSelectConversationsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->previous_selection_was_interactive) {
		_data_->_tmp0_ = _data_->is_interactive;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->start_mark_timer = _data_->_tmp0_;
	_data_->self->priv->previous_selection_was_interactive = _data_->is_interactive;
	_data_->_tmp1_ = _data_->self->priv->_conversation_list_view;
	conversation_list_view_select_conversations (_data_->_tmp1_, _data_->to_select);
	_data_->_tmp2_ = _data_->self->priv->conversation_list_actions;
	_data_->_tmp3_ = gee_collection_get_size (_data_->to_select);
	_data_->_tmp4_ = _data_->_tmp3_;
	components_conversation_actions_set_selected_conversations (_data_->_tmp2_, _data_->_tmp4_);
	_data_->_tmp5_ = _data_->self->conversation_headerbar;
	_data_->_tmp6_ = _data_->_tmp5_->full_actions;
	_data_->_tmp7_ = gee_collection_get_size (_data_->to_select);
	_data_->_tmp8_ = _data_->_tmp7_;
	components_conversation_actions_set_selected_conversations (_data_->_tmp6_, _data_->_tmp8_);
	_data_->_tmp9_ = _data_->self->conversation_headerbar;
	_data_->_tmp10_ = _data_->_tmp9_->compact_actions;
	_data_->_tmp11_ = gee_collection_get_size (_data_->to_select);
	_data_->_tmp12_ = _data_->_tmp11_;
	components_conversation_actions_set_selected_conversations (_data_->_tmp10_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->self->priv->_selected_folder;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = application_main_window_get_has_composer (_data_->self);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp13_ = !_data_->_tmp16_;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		_data_->_tmp17_ = gee_collection_get_size (_data_->to_select);
		_data_->_tmp18_ = _data_->_tmp17_;
		switch (_data_->_tmp18_) {
			case 0:
			{
				application_main_window_update_conversation_actions (_data_->self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE);
				_data_->_tmp19_ = _data_->self->priv->_conversation_viewer;
				conversation_viewer_show_none_selected (_data_->_tmp19_);
				break;
			}
			case 1:
			{
				application_main_window_update_conversation_actions (_data_->self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE);
				_data_->_tmp20_ = geary_collection_first (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->to_select);
				_data_->convo = (GearyAppConversation*) _data_->_tmp20_;
				_data_->_tmp21_ = application_main_window_get_selected_account_context (_data_->self);
				_data_->context = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->context;
				if (_data_->_tmp23_ != NULL) {
					_data_->_tmp24_ = _data_->convo;
					_data_->_tmp22_ = geary_app_conversation_get_count (_data_->_tmp24_) > 0;
				} else {
					_data_->_tmp22_ = FALSE;
				}
				if (_data_->_tmp22_) {
					{
						_data_->_tmp25_ = _data_->self->priv->_conversation_viewer;
						_data_->_tmp26_ = _data_->convo;
						_data_->_tmp27_ = _data_->context;
						_data_->_tmp28_ = application_account_context_get_emails (_data_->_tmp27_);
						_data_->_tmp29_ = _data_->_tmp28_;
						_data_->_tmp30_ = _data_->context;
						_data_->_tmp31_ = application_account_context_get_contacts (_data_->_tmp30_);
						_data_->_tmp32_ = _data_->_tmp31_;
						_data_->_state_ = 1;
						conversation_viewer_load_conversation (_data_->_tmp25_, _data_->_tmp26_, _data_->scroll_to, _data_->_tmp29_, _data_->_tmp32_, _data_->start_mark_timer, application_main_window_select_conversations_ready, _data_);
						return FALSE;
						_state_1:
						conversation_viewer_load_conversation_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
								goto __catch0_geary_engine_error_not_found;
							}
							if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
								goto __catch0_g_io_error_cancelled;
							}
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_geary_engine_error_not_found:
					{
						_data_->err = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp33_ = _data_->convo;
						if (geary_app_conversation_get_count (_data_->_tmp33_) == 0) {
							_data_->_tmp34_ = _data_->err;
							_data_->_tmp35_ = _data_->_tmp34_->message;
							g_debug ("application-main-window.vala:1659: Ignoring not found error: %s", _data_->_tmp35_);
						} else {
							_data_->_tmp36_ = _data_->convo;
							_data_->_tmp37_ = geary_app_conversation_get_base_folder (_data_->_tmp36_);
							_data_->_tmp38_ = _data_->_tmp37_;
							_data_->_tmp39_ = geary_folder_get_account (_data_->_tmp38_);
							_data_->_tmp40_ = _data_->_tmp39_;
							_data_->_tmp41_ = geary_account_get_information (_data_->_tmp40_);
							_data_->_tmp42_ = _data_->_tmp41_;
							_data_->_tmp43_ = _data_->err;
							application_main_window_handle_error (_data_->self, _data_->_tmp42_, _data_->_tmp43_);
						}
						_g_error_free0 (_data_->err);
					}
					goto __finally0;
					__catch0_g_io_error_cancelled:
					{
						g_clear_error (&_data_->_inner_error0_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->_vala1_err = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp44_ = _data_->convo;
						_data_->_tmp45_ = geary_app_conversation_get_base_folder (_data_->_tmp44_);
						_data_->_tmp46_ = _data_->_tmp45_;
						_data_->_tmp47_ = geary_folder_get_account (_data_->_tmp46_);
						_data_->_tmp48_ = _data_->_tmp47_;
						_data_->_tmp49_ = geary_account_get_information (_data_->_tmp48_);
						_data_->_tmp50_ = _data_->_tmp49_;
						_data_->_tmp51_ = _data_->_vala1_err;
						application_main_window_handle_error (_data_->self, _data_->_tmp50_, _data_->_tmp51_);
						_g_error_free0 (_data_->_vala1_err);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->context);
						_g_object_unref0 (_data_->convo);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->context);
				_g_object_unref0 (_data_->convo);
				break;
			}
			default:
			{
				application_main_window_update_conversation_actions (_data_->self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE);
				_data_->_tmp52_ = _data_->self->priv->_conversation_viewer;
				conversation_viewer_show_multiple_selected (_data_->_tmp52_);
				break;
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_open_conversation_monitor_data_free (gpointer _data)
{
	ApplicationMainWindowOpenConversationMonitorData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowOpenConversationMonitorData, _data_);
}

static void
application_main_window_open_conversation_monitor (ApplicationMainWindow* self,
                                                   GearyAppConversationMonitor* to_open,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	ApplicationMainWindowOpenConversationMonitorData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_open, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationMainWindowOpenConversationMonitorData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_open_conversation_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_open);
	_g_object_unref0 (_data_->to_open);
	_data_->to_open = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_main_window_open_conversation_monitor_co (_data_);
}

static void
application_main_window_open_conversation_monitor_finish (ApplicationMainWindow* self,
                                                          GAsyncResult* _res_)
{
	ApplicationMainWindowOpenConversationMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->to_open);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
_application_main_window_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                          gpointer self)
{
	application_main_window_on_scan_completed ((ApplicationMainWindow*) self, _sender);
}

static void
_application_main_window_on_scan_error_geary_app_conversation_monitor_scan_error (GearyAppConversationMonitor* _sender,
                                                                                  GError* err,
                                                                                  gpointer self)
{
	application_main_window_on_scan_error ((ApplicationMainWindow*) self, _sender, err);
}

static void
_application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                                      gpointer self)
{
	application_main_window_on_conversation_count_changed ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                           GeeCollection* conversations,
                                                                                                           gpointer self)
{
	application_main_window_on_conversation_count_changed ((ApplicationMainWindow*) self);
}

static void
_application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                             GeeCollection* conversations,
                                                                                                             gpointer self)
{
	application_main_window_on_conversation_count_changed ((ApplicationMainWindow*) self);
}

static void
__lambda160_ (Block18Data* _data18_,
              GObject* obj,
              GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data18_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		geary_app_conversation_monitor_start_monitoring_finish (_data18_->to_open, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp0_;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = geary_app_conversation_monitor_get_base_folder (_data18_->to_open);
		_tmp1_ = _tmp0_;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda160__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda160_ (self, source_object, res);
	block18_data_unref (self);
}

static gboolean
application_main_window_open_conversation_monitor_co (ApplicationMainWindowOpenConversationMonitorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data18_ = g_slice_new0 (Block18Data);
	_data_->_data18_->_ref_count_ = 1;
	_data_->_data18_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data18_->to_open);
	_data_->_data18_->to_open = _data_->to_open;
	_data_->_data18_->_async_data_ = _data_;
	g_signal_connect_object (_data_->_data18_->to_open, "scan-completed", (GCallback) _application_main_window_on_scan_completed_geary_app_conversation_monitor_scan_completed, _data_->self, 0);
	g_signal_connect_object (_data_->_data18_->to_open, "scan-error", (GCallback) _application_main_window_on_scan_error_geary_app_conversation_monitor_scan_error, _data_->self, 0);
	g_signal_connect_object (_data_->_data18_->to_open, "scan-completed", (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_scan_completed, _data_->self, 0);
	g_signal_connect_object (_data_->_data18_->to_open, "conversations-added", (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_added, _data_->self, 0);
	g_signal_connect_object (_data_->_data18_->to_open, "conversations-removed", (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_removed, _data_->self, 0);
	geary_app_conversation_monitor_start_monitoring (_data_->_data18_->to_open, GEARY_FOLDER_OPEN_FLAGS_NO_DELAY, _data_->cancellable, ___lambda160__gasync_ready_callback, block18_data_ref (_data_->_data18_));
	block18_data_unref (_data_->_data18_);
	_data_->_data18_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->to_close);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda158_ (Block19Data* _data19_,
              GObject* obj,
              GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data19_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		geary_app_conversation_monitor_stop_monitoring_finish (_data19_->to_close, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp0_;
		GearyFolder* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = geary_app_conversation_monitor_get_base_folder (_data19_->to_close);
		_tmp1_ = _tmp0_;
		_tmp2_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp3_ = _tmp2_;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("application-main-window.vala:1717: Error closing conversation monitor " \
"%s: %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda158__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda158_ (self, source_object, res);
	block19_data_unref (self);
}

static void
application_main_window_close_conversation_monitor (ApplicationMainWindow* self,
                                                    GearyAppConversationMonitor* to_close)
{
	Block19Data* _data19_;
	GearyAppConversationMonitor* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_close, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (to_close);
	_g_object_unref0 (_data19_->to_close);
	_data19_->to_close = _tmp0_;
	g_signal_parse_name ("scan-completed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data19_->to_close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _application_main_window_on_scan_completed_geary_app_conversation_monitor_scan_completed, self);
	g_signal_parse_name ("scan-error", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data19_->to_close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _application_main_window_on_scan_error_geary_app_conversation_monitor_scan_error, self);
	g_signal_parse_name ("scan-completed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data19_->to_close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_scan_completed, self);
	g_signal_parse_name ("conversations-added", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data19_->to_close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_added, self);
	g_signal_parse_name ("conversations-removed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data19_->to_close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _application_main_window_on_conversation_count_changed_geary_app_conversation_monitor_conversations_removed, self);
	geary_app_conversation_monitor_stop_monitoring (_data19_->to_close, NULL, ___lambda158__gasync_ready_callback, block19_data_ref (_data19_));
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static void
application_main_window_create_composer_data_free (gpointer _data)
{
	ApplicationMainWindowCreateComposerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->send_context);
	_g_object_unref0 (_data_->context);
	_g_free0 (_data_->quote);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowCreateComposerData, _data_);
}

static void
application_main_window_create_composer (ApplicationMainWindow* self,
                                         GearyAccount* send_context,
                                         ComposerWidgetContextType type,
                                         GearyEmail* context,
                                         const gchar* quote,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ApplicationMainWindowCreateComposerData* _data_;
	ApplicationMainWindow* _tmp0_;
	GearyAccount* _tmp1_;
	GearyEmail* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (send_context, GEARY_TYPE_ACCOUNT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, GEARY_TYPE_EMAIL));
	_data_ = g_slice_new0 (ApplicationMainWindowCreateComposerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_create_composer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (send_context);
	_g_object_unref0 (_data_->send_context);
	_data_->send_context = _tmp1_;
	_data_->type = type;
	_tmp2_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp2_;
	_tmp3_ = g_strdup (quote);
	_g_free0 (_data_->quote);
	_data_->quote = _tmp3_;
	application_main_window_create_composer_co (_data_);
}

static void
application_main_window_create_composer_finish (ApplicationMainWindow* self,
                                                GAsyncResult* _res_)
{
	ApplicationMainWindowCreateComposerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_main_window_create_composer_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ApplicationMainWindowCreateComposerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_create_composer_co (_data_);
}

static gboolean
application_main_window_create_composer_co (ApplicationMainWindowCreateComposerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->quote;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp0_ = "";
	}
	_data_->_tmp1_ = _data_->self->priv->controller;
	_data_->_tmp2_ = _data_->self->priv->controller;
	_data_->_tmp3_ = geary_account_get_information (_data_->send_context);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_state_ = 1;
	application_controller_compose_with_context (_data_->_tmp1_, _data_->_tmp6_, _data_->type, _data_->context, _data_->_tmp0_, application_main_window_create_composer_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = application_controller_compose_with_context_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp6_);
	_data_->composer = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->controller;
	application_controller_present_composer (_data_->_tmp9_, _data_->composer);
	_g_object_unref0 (_data_->composer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_create_composer_from_viewer_data_free (gpointer _data)
{
	ApplicationMainWindowCreateComposerFromViewerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowCreateComposerFromViewerData, _data_);
}

static void
application_main_window_create_composer_from_viewer (ApplicationMainWindow* self,
                                                     ComposerWidgetContextType type,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	ApplicationMainWindowCreateComposerFromViewerData* _data_;
	ApplicationMainWindow* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data_ = g_slice_new0 (ApplicationMainWindowCreateComposerFromViewerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_create_composer_from_viewer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->type = type;
	application_main_window_create_composer_from_viewer_co (_data_);
}

static void
application_main_window_create_composer_from_viewer_finish (ApplicationMainWindow* self,
                                                            GAsyncResult* _res_)
{
	ApplicationMainWindowCreateComposerFromViewerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_main_window_create_composer_from_viewer_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	ApplicationMainWindowCreateComposerFromViewerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_create_composer_from_viewer_co (_data_);
}

static gboolean
application_main_window_create_composer_from_viewer_co (ApplicationMainWindowCreateComposerFromViewerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_selected_account;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->account = _data_->_tmp1_;
	_data_->email_view = NULL;
	_data_->_tmp2_ = _data_->self->priv->_conversation_viewer;
	_data_->_tmp3_ = conversation_viewer_get_current_list (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
	_data_->list_view = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->list_view;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->list_view;
		_data_->_tmp8_ = conversation_list_box_get_reply_target (_data_->_tmp7_);
		_g_object_unref0 (_data_->email_view);
		_data_->email_view = _data_->_tmp8_;
	}
	_data_->_tmp10_ = _data_->account;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = _data_->email_view;
		_data_->_tmp9_ = _data_->_tmp11_ != NULL;
	} else {
		_data_->_tmp9_ = FALSE;
	}
	if (_data_->_tmp9_) {
		_data_->_tmp12_ = _data_->email_view;
		_data_->_state_ = 1;
		conversation_email_get_selection_for_quoting (_data_->_tmp12_, application_main_window_create_composer_from_viewer_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp13_ = conversation_email_get_selection_for_quoting_finish (_data_->_tmp12_, _data_->_res_);
		_data_->quote = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->account;
		_data_->_tmp15_ = _data_->email_view;
		_data_->_tmp16_ = conversation_email_get_email (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = _data_->quote;
		_data_->_state_ = 2;
		application_main_window_create_composer (_data_->self, _data_->_tmp14_, _data_->type, _data_->_tmp17_, _data_->_tmp18_, application_main_window_create_composer_from_viewer_ready, _data_);
		return FALSE;
		_state_2:
		application_main_window_create_composer_finish (_data_->self, _data_->_res_);
		_g_free0 (_data_->quote);
	}
	_g_object_unref0 (_data_->list_view);
	_g_object_unref0 (_data_->email_view);
	_g_object_unref0 (_data_->account);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_load_more (ApplicationMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp1_ = application_main_window_get_is_conversation_list_shown (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GearyAppConversationMonitor* _tmp3_;
		_tmp3_ = self->priv->_conversations;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyAppConversationMonitor* _tmp4_;
		GearyAppConversationMonitor* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->_conversations;
		_tmp5_ = self->priv->_conversations;
		_tmp6_ = geary_app_conversation_monitor_get_min_window_count (_tmp5_);
		_tmp7_ = _tmp6_;
		geary_app_conversation_monitor_set_min_window_count (_tmp5_, _tmp7_ + APPLICATION_MAIN_WINDOW_MIN_CONVERSATION_COUNT);
	}
}

static void
application_main_window_on_conversations_selected (ApplicationMainWindow* self,
                                                   GeeSet* selected)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selected, GEE_TYPE_SET));
	_tmp0_ = gee_collection_empty (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	_tmp1_ = _tmp0_;
	application_main_window_select_conversations (self, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_, TRUE, NULL, NULL);
	_g_object_unref0 (_tmp1_);
}

static void
application_main_window_on_conversation_count_changed (ApplicationMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = application_main_window_get_has_composer (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GearyAppConversationMonitor* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_conversations;
		_tmp3_ = geary_app_conversation_monitor_get_size (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == 0) {
			GearyFolder* _tmp5_;
			GearyFolderSpecialUse _tmp6_;
			GearyFolderSpecialUse _tmp7_;
			_tmp5_ = self->priv->_selected_folder;
			_tmp6_ = geary_folder_get_used_as (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ == GEARY_FOLDER_SPECIAL_USE_SEARCH) {
				ConversationViewer* _tmp8_;
				_tmp8_ = self->priv->_conversation_viewer;
				conversation_viewer_show_empty_search (_tmp8_);
			} else {
				ConversationViewer* _tmp9_;
				_tmp9_ = self->priv->_conversation_viewer;
				conversation_viewer_show_empty_folder (_tmp9_);
			}
			application_main_window_update_conversation_actions (self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE);
		} else {
			gboolean _tmp10_ = FALSE;
			ApplicationClient* _tmp11_;
			ApplicationClient* _tmp12_;
			ApplicationConfiguration* _tmp13_;
			ApplicationConfiguration* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp11_ = application_main_window_get_application (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = application_client_get_config (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = application_configuration_get_autoselect (_tmp14_);
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				ConversationListView* _tmp17_;
				GtkTreeSelection* _tmp18_;
				_tmp17_ = self->priv->_conversation_list_view;
				_tmp18_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_tree_view_get_type (), GtkTreeView));
				_tmp10_ = gtk_tree_selection_count_selected_rows (_tmp18_) == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ConversationViewer* _tmp19_;
				_tmp19_ = self->priv->_conversation_viewer;
				conversation_viewer_show_none_selected (_tmp19_);
				application_main_window_update_conversation_actions (self, APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE);
			}
		}
	}
}

static void
application_main_window_update_headerbar (ApplicationMainWindow* self)
{
	GearyFolder* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_update_title (self);
	_tmp0_ = self->priv->_selected_folder;
	if (_tmp0_ != NULL) {
		gint count = 0;
		GearyFolder* _tmp1_;
		GearyFolderSpecialUse _tmp2_;
		GearyFolderSpecialUse _tmp3_;
		_tmp1_ = self->priv->_selected_folder;
		_tmp2_ = geary_folder_get_used_as (_tmp1_);
		_tmp3_ = _tmp2_;
		switch (_tmp3_) {
			case GEARY_FOLDER_SPECIAL_USE_DRAFTS:
			case GEARY_FOLDER_SPECIAL_USE_OUTBOX:
			{
				GearyFolder* _tmp4_;
				GearyFolderProperties* _tmp5_;
				GearyFolderProperties* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp4_ = self->priv->_selected_folder;
				_tmp5_ = geary_folder_get_properties (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = geary_folder_properties_get_email_total (_tmp6_);
				_tmp8_ = _tmp7_;
				count = _tmp8_;
				break;
			}
			default:
			{
				GearyFolder* _tmp9_;
				GearyFolderProperties* _tmp10_;
				GearyFolderProperties* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				_tmp9_ = self->priv->_selected_folder;
				_tmp10_ = geary_folder_get_properties (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = geary_folder_properties_get_email_unread (_tmp11_);
				_tmp13_ = _tmp12_;
				count = _tmp13_;
				break;
			}
		}
		if (count > 0) {
			ComponentsConversationListHeaderBar* _tmp14_;
			ComponentsConversationListHeaderBar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp14_ = self->priv->conversation_list_headerbar;
			_tmp15_ = self->priv->conversation_list_headerbar;
			_tmp16_ = components_conversation_list_header_bar_get_folder (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf (_ ("%s (%d)"), _tmp17_, count);
			_tmp19_ = _tmp18_;
			components_conversation_list_header_bar_set_folder (_tmp14_, _tmp19_);
			_g_free0 (_tmp19_);
		}
	}
}

static void
application_main_window_update_conversation_actions (ApplicationMainWindow* self,
                                                     ApplicationMainWindowConversationCount count)
{
	gboolean sensitive = FALSE;
	gboolean multiple = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean reply_sensitive = FALSE;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean move_enabled = FALSE;
	GSimpleAction* _tmp21_;
	GSimpleAction* _tmp22_;
	ComponentsConversationActions** _tmp23_;
	gint _tmp23__length1;
	gboolean _tmp26_ = FALSE;
	gboolean copy_enabled = FALSE;
	GSimpleAction* _tmp28_;
	GSimpleAction* _tmp29_;
	ComponentsConversationActions** _tmp30_;
	gint _tmp30__length1;
	gboolean _tmp33_ = FALSE;
	gboolean mark_enabled = FALSE;
	ComponentsConversationActions** _tmp35_;
	gint _tmp35__length1;
	gboolean _tmp38_ = FALSE;
	GSimpleAction* _tmp40_;
	GSimpleAction* _tmp41_;
	gboolean _tmp42_ = FALSE;
	GSimpleAction* _tmp45_;
	GSimpleAction* _tmp46_;
	gboolean _tmp47_ = FALSE;
	GSimpleAction* _tmp49_;
	GSimpleAction* _tmp50_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	sensitive = count != APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE;
	multiple = count == APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE;
	if (sensitive) {
		_tmp1_ = !multiple;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = application_main_window_get_is_conversation_viewer_shown (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_FIND_IN_CONVERSATION);
	_tmp5_ = _tmp4_;
	g_simple_action_set_enabled (_tmp5_, _tmp0_);
	_g_object_unref0 (_tmp5_);
	if (sensitive) {
		_tmp8_ = !multiple;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GearyFolder* _tmp9_;
		_tmp9_ = self->priv->_selected_folder;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GearyFolder* _tmp10_;
		GearyFolderSpecialUse _tmp11_;
		GearyFolderSpecialUse _tmp12_;
		_tmp10_ = self->priv->_selected_folder;
		_tmp11_ = geary_folder_get_used_as (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_ != GEARY_FOLDER_SPECIAL_USE_DRAFTS;
	} else {
		_tmp6_ = FALSE;
	}
	reply_sensitive = _tmp6_;
	_tmp13_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_REPLY_CONVERSATION);
	_tmp14_ = _tmp13_;
	g_simple_action_set_enabled (_tmp14_, reply_sensitive);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_REPLY_ALL_CONVERSATION);
	_tmp16_ = _tmp15_;
	g_simple_action_set_enabled (_tmp16_, reply_sensitive);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_FORWARD_CONVERSATION);
	_tmp18_ = _tmp17_;
	g_simple_action_set_enabled (_tmp18_, reply_sensitive);
	_g_object_unref0 (_tmp18_);
	if (sensitive) {
		GearyFolder* _tmp20_;
		_tmp20_ = self->priv->_selected_folder;
		_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GEARY_FOLDER_SUPPORT_TYPE_MOVE);
	} else {
		_tmp19_ = FALSE;
	}
	move_enabled = _tmp19_;
	_tmp21_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_MOVE_MENU);
	_tmp22_ = _tmp21_;
	g_simple_action_set_enabled (_tmp22_, move_enabled);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->folder_conversation_actions;
	_tmp23__length1 = self->priv->folder_conversation_actions_length1;
	{
		ComponentsConversationActions** actions_collection = NULL;
		gint actions_collection_length1 = 0;
		gint _actions_collection_size_ = 0;
		gint actions_it = 0;
		actions_collection = _tmp23_;
		actions_collection_length1 = _tmp23__length1;
		for (actions_it = 0; actions_it < actions_collection_length1; actions_it = actions_it + 1) {
			ComponentsConversationActions* _tmp24_;
			ComponentsConversationActions* actions = NULL;
			_tmp24_ = _g_object_ref0 (actions_collection[actions_it]);
			actions = _tmp24_;
			{
				ComponentsConversationActions* _tmp25_;
				_tmp25_ = actions;
				components_conversation_actions_set_move_sensitive (_tmp25_, move_enabled);
				_g_object_unref0 (actions);
			}
		}
	}
	if (sensitive) {
		GearyFolder* _tmp27_;
		_tmp27_ = self->priv->_selected_folder;
		_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, GEARY_FOLDER_SUPPORT_TYPE_COPY);
	} else {
		_tmp26_ = FALSE;
	}
	copy_enabled = _tmp26_;
	_tmp28_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_COPY_MENU);
	_tmp29_ = _tmp28_;
	g_simple_action_set_enabled (_tmp29_, move_enabled);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = self->priv->folder_conversation_actions;
	_tmp30__length1 = self->priv->folder_conversation_actions_length1;
	{
		ComponentsConversationActions** actions_collection = NULL;
		gint actions_collection_length1 = 0;
		gint _actions_collection_size_ = 0;
		gint actions_it = 0;
		actions_collection = _tmp30_;
		actions_collection_length1 = _tmp30__length1;
		for (actions_it = 0; actions_it < actions_collection_length1; actions_it = actions_it + 1) {
			ComponentsConversationActions* _tmp31_;
			ComponentsConversationActions* actions = NULL;
			_tmp31_ = _g_object_ref0 (actions_collection[actions_it]);
			actions = _tmp31_;
			{
				ComponentsConversationActions* _tmp32_;
				_tmp32_ = actions;
				components_conversation_actions_set_copy_sensitive (_tmp32_, copy_enabled);
				_g_object_unref0 (actions);
			}
		}
	}
	if (sensitive) {
		GearyFolder* _tmp34_;
		_tmp34_ = self->priv->_selected_folder;
		_tmp33_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, GEARY_FOLDER_SUPPORT_TYPE_MARK);
	} else {
		_tmp33_ = FALSE;
	}
	mark_enabled = _tmp33_;
	_tmp35_ = self->priv->folder_conversation_actions;
	_tmp35__length1 = self->priv->folder_conversation_actions_length1;
	{
		ComponentsConversationActions** actions_collection = NULL;
		gint actions_collection_length1 = 0;
		gint _actions_collection_size_ = 0;
		gint actions_it = 0;
		actions_collection = _tmp35_;
		actions_collection_length1 = _tmp35__length1;
		for (actions_it = 0; actions_it < actions_collection_length1; actions_it = actions_it + 1) {
			ComponentsConversationActions* _tmp36_;
			ComponentsConversationActions* actions = NULL;
			_tmp36_ = _g_object_ref0 (actions_collection[actions_it]);
			actions = _tmp36_;
			{
				ComponentsConversationActions* _tmp37_;
				_tmp37_ = actions;
				components_conversation_actions_set_mark_sensitive (_tmp37_, mark_enabled);
				_g_object_unref0 (actions);
			}
		}
	}
	if (sensitive) {
		GearyFolder* _tmp39_;
		_tmp39_ = self->priv->_selected_folder;
		_tmp38_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, GEARY_FOLDER_SUPPORT_TYPE_ARCHIVE);
	} else {
		_tmp38_ = FALSE;
	}
	_tmp40_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_ARCHIVE_CONVERSATION);
	_tmp41_ = _tmp40_;
	g_simple_action_set_enabled (_tmp41_, _tmp38_);
	_g_object_unref0 (_tmp41_);
	if (sensitive) {
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp43_ = application_main_window_get_selected_folder_supports_trash (self);
		_tmp44_ = _tmp43_;
		_tmp42_ = _tmp44_;
	} else {
		_tmp42_ = FALSE;
	}
	_tmp45_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION);
	_tmp46_ = _tmp45_;
	g_simple_action_set_enabled (_tmp46_, _tmp42_);
	_g_object_unref0 (_tmp46_);
	if (sensitive) {
		GearyFolder* _tmp48_;
		_tmp48_ = self->priv->_selected_folder;
		_tmp47_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, GEARY_FOLDER_SUPPORT_TYPE_REMOVE);
	} else {
		_tmp47_ = FALSE;
	}
	_tmp49_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
	_tmp50_ = _tmp49_;
	g_simple_action_set_enabled (_tmp50_, _tmp47_);
	_g_object_unref0 (_tmp50_);
	switch (count) {
		case APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_NONE:
		{
			GtkRevealer* _tmp51_;
			_tmp51_ = self->priv->conversation_list_actions_revealer;
			gtk_revealer_set_reveal_child (_tmp51_, FALSE);
			break;
		}
		case APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_SINGLE:
		{
			GtkRevealer* _tmp52_;
			HdyLeaflet* _tmp53_;
			gboolean _tmp54_;
			gboolean _tmp55_;
			_tmp52_ = self->priv->conversation_list_actions_revealer;
			_tmp53_ = self->priv->outer_leaflet;
			_tmp54_ = hdy_leaflet_get_folded (_tmp53_);
			_tmp55_ = _tmp54_;
			gtk_revealer_set_reveal_child (_tmp52_, _tmp55_);
			break;
		}
		case APPLICATION_MAIN_WINDOW_CONVERSATION_COUNT_MULTIPLE:
		{
			GtkRevealer* _tmp56_;
			_tmp56_ = self->priv->conversation_list_actions_revealer;
			gtk_revealer_set_reveal_child (_tmp56_, TRUE);
			break;
		}
		default:
		break;
	}
	application_main_window_update_context_dependent_actions (self, sensitive, NULL, NULL);
}

static void
application_main_window_update_trash_action (ApplicationMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean show_trash = FALSE;
	ComponentsConversationActions* _tmp4_;
	ComponentsConversationHeaderBar* _tmp5_;
	ComponentsConversationActions* _tmp6_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp1_ = self->priv->_is_shift_down;
	if (!_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = application_main_window_get_selected_folder_supports_trash (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	show_trash = _tmp0_;
	_tmp4_ = self->priv->conversation_list_actions;
	components_conversation_actions_update_trash_button (_tmp4_, show_trash);
	_tmp5_ = self->conversation_headerbar;
	_tmp6_ = _tmp5_->full_actions;
	components_conversation_actions_update_trash_button (_tmp6_, show_trash);
}

static void
application_main_window_update_context_dependent_actions_data_free (gpointer _data)
{
	ApplicationMainWindowUpdateContextDependentActionsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationMainWindowUpdateContextDependentActionsData, _data_);
}

static void
application_main_window_update_context_dependent_actions (ApplicationMainWindow* self,
                                                          gboolean sensitive,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	ApplicationMainWindowUpdateContextDependentActionsData* _data_;
	ApplicationMainWindow* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data_ = g_slice_new0 (ApplicationMainWindowUpdateContextDependentActionsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_main_window_update_context_dependent_actions_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->sensitive = sensitive;
	application_main_window_update_context_dependent_actions_co (_data_);
}

static void
application_main_window_update_context_dependent_actions_finish (ApplicationMainWindow* self,
                                                                 GAsyncResult* _res_)
{
	ApplicationMainWindowUpdateContextDependentActionsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_main_window_update_context_dependent_actions_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	ApplicationMainWindowUpdateContextDependentActionsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_main_window_update_context_dependent_actions_co (_data_);
}

static gboolean
application_main_window_update_context_dependent_actions_co (ApplicationMainWindowUpdateContextDependentActionsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->action_update_cancellable;
	g_cancellable_cancel (_data_->_tmp0_);
	_data_->_tmp1_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->cancellable;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->self->priv->action_update_cancellable);
	_data_->self->priv->action_update_cancellable = _data_->_tmp3_;
	_data_->selected_operations = NULL;
	_data_->_tmp4_ = _data_->self->priv->_selected_folder;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->controller;
		_data_->_tmp6_ = _data_->self->priv->_selected_folder;
		_data_->_tmp7_ = geary_folder_get_account (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = geary_account_get_information (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _data_->_tmp10_);
		_data_->context = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->context;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = gee_linked_list_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_data_->ids = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_COLLECTION, GeeCollection);
			{
				_data_->_tmp14_ = _data_->self->priv->_conversation_list_view;
				_data_->_tmp15_ = conversation_list_view_get_selected (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_tmp18_ = _data_->_tmp17_;
				_g_object_unref0 (_data_->_tmp16_);
				_data_->_convo_it = _data_->_tmp18_;
				while (TRUE) {
					_data_->_tmp19_ = _data_->_convo_it;
					if (!gee_iterator_next (_data_->_tmp19_)) {
						break;
					}
					_data_->_tmp20_ = _data_->_convo_it;
					_data_->_tmp21_ = gee_iterator_get (_data_->_tmp20_);
					_data_->convo = (GearyAppConversation*) _data_->_tmp21_;
					_data_->_tmp22_ = _data_->ids;
					_data_->_tmp23_ = _data_->convo;
					_data_->_tmp24_ = geary_app_conversation_get_email_ids (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					gee_collection_add_all (_data_->_tmp22_, _data_->_tmp25_);
					_g_object_unref0 (_data_->_tmp25_);
					_g_object_unref0 (_data_->convo);
				}
				_g_object_unref0 (_data_->_convo_it);
			}
			{
				_data_->_tmp27_ = _data_->context;
				_data_->_tmp28_ = application_account_context_get_emails (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = _data_->ids;
				_data_->_tmp31_ = _data_->cancellable;
				_data_->_state_ = 1;
				geary_app_email_store_get_supported_operations_async (_data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, application_main_window_update_context_dependent_actions_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp32_ = geary_app_email_store_get_supported_operations_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp26_ = _data_->_tmp32_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp33_ = _data_->_tmp26_;
				_data_->_tmp26_ = NULL;
				_g_object_unref0 (_data_->selected_operations);
				_data_->selected_operations = _data_->_tmp33_;
				_g_object_unref0 (_data_->_tmp26_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp34_ = _data_->e;
				_data_->_tmp35_ = _data_->_tmp34_->message;
				g_debug ("application-main-window.vala:1916: Error checking for what operations " \
"are supported in the selected conversations: %s", _data_->_tmp35_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->ids);
				_g_object_unref0 (_data_->context);
				_g_object_unref0 (_data_->selected_operations);
				_g_object_unref0 (_data_->cancellable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->ids);
		}
		_g_object_unref0 (_data_->context);
	}
	_data_->_tmp36_ = _data_->cancellable;
	if (!g_cancellable_is_cancelled (_data_->_tmp36_)) {
		_data_->_tmp37_ = gee_hash_set_new (G_TYPE_GTYPE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->supported_operations = _data_->_tmp37_;
		_data_->_tmp38_ = _data_->selected_operations;
		if (_data_->_tmp38_ != NULL) {
			_data_->_tmp39_ = _data_->supported_operations;
			_data_->_tmp40_ = _data_->selected_operations;
			_data_->_tmp41_ = gee_multi_map_get_values (_data_->_tmp40_);
			_data_->_tmp42_ = _data_->_tmp41_;
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp42_);
			_g_object_unref0 (_data_->_tmp42_);
		}
		if (_data_->sensitive) {
			_data_->_tmp44_ = _data_->supported_operations;
			_data_->_tmp43_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_COPY));
		} else {
			_data_->_tmp43_ = FALSE;
		}
		_data_->_tmp45_ = application_main_window_get_window_action (_data_->self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_COPY_MENU);
		_data_->_tmp46_ = _data_->_tmp45_;
		g_simple_action_set_enabled (_data_->_tmp46_, _data_->_tmp43_);
		_g_object_unref0 (_data_->_tmp46_);
		if (_data_->sensitive) {
			_data_->_tmp48_ = _data_->supported_operations;
			_data_->_tmp47_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_MOVE));
		} else {
			_data_->_tmp47_ = FALSE;
		}
		_data_->_tmp49_ = application_main_window_get_window_action (_data_->self, APPLICATION_MAIN_WINDOW_ACTION_SHOW_MOVE_MENU);
		_data_->_tmp50_ = _data_->_tmp49_;
		g_simple_action_set_enabled (_data_->_tmp50_, _data_->_tmp47_);
		_g_object_unref0 (_data_->_tmp50_);
		_g_object_unref0 (_data_->supported_operations);
	}
	_g_object_unref0 (_data_->selected_operations);
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_main_window_set_shift_key_down (ApplicationMainWindow* self,
                                            gboolean down)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_set_is_shift_down (self, down);
	application_main_window_update_trash_action (self);
}

static inline void
application_main_window_check_shift_event (ApplicationMainWindow* self,
                                           GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (event != NULL);
	if (event->keyval == GDK_KEY_Shift_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->keyval == GDK_KEY_Shift_R;
	}
	if (_tmp0_) {
		GtkWidget* focus = NULL;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GtkWidget* _tmp4_;
		_tmp1_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp2_ = _g_object_ref0 (_tmp1_);
		focus = _tmp2_;
		_tmp4_ = focus;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			GtkWidget* _tmp6_;
			_tmp6_ = focus;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_entry_get_type ())) {
				GtkWidget* _tmp7_;
				_tmp7_ = focus;
				_tmp5_ = !COMPOSER_IS_WEB_VIEW (_tmp7_);
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		if (_tmp3_) {
			application_main_window_set_shift_key_down (self, event->type == GDK_KEY_PRESS);
		}
		_g_object_unref0 (focus);
	}
}

static void
application_main_window_focus_next_pane (ApplicationMainWindow* self)
{
	GtkWidget* focus = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	HdyLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkWidget* _tmp62_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	focus = _tmp1_;
	_tmp2_ = self->priv->outer_leaflet;
	_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		HdyLeaflet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->outer_leaflet;
		_tmp6_ = hdy_leaflet_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		if (g_strcmp0 (_tmp7_, APPLICATION_MAIN_WINDOW_INNER_LEAFLET) == 0) {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			HdyLeaflet* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp10_ = self->priv->inner_leaflet;
			_tmp11_ = hdy_leaflet_get_folded (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				HdyLeaflet* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = self->priv->inner_leaflet;
				_tmp14_ = hdy_leaflet_get_visible_child_name (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = g_strcmp0 (_tmp15_, APPLICATION_MAIN_WINDOW_FOLDER_LIST) == 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				GtkWidget* _tmp16_;
				FolderListTree* _tmp17_;
				_tmp16_ = focus;
				_tmp17_ = self->priv->_folder_list;
				_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget);
			}
			if (_tmp8_) {
				HdyLeaflet* _tmp18_;
				ConversationListView* _tmp19_;
				GtkWidget* _tmp20_;
				_tmp18_ = self->priv->inner_leaflet;
				hdy_leaflet_navigate (_tmp18_, HDY_NAVIGATION_DIRECTION_FORWARD);
				_tmp19_ = self->priv->_conversation_list_view;
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (focus);
				focus = _tmp20_;
			} else {
				gboolean _tmp21_ = FALSE;
				ConversationListView* _tmp22_;
				GeeSet* _tmp23_;
				GeeSet* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gboolean _tmp27_;
				_tmp22_ = self->priv->_conversation_list_view;
				_tmp23_ = conversation_list_view_get_selected (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_ == 1;
				_g_object_unref0 (_tmp24_);
				if (_tmp27_) {
					GearyFolder* _tmp28_;
					GearyFolderProperties* _tmp29_;
					GearyFolderProperties* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					_tmp28_ = self->priv->_selected_folder;
					_tmp29_ = geary_folder_get_properties (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = geary_folder_properties_get_email_total (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp21_ = _tmp32_ > 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					HdyLeaflet* _tmp33_;
					ConversationViewer* _tmp34_;
					GtkWidget* _tmp35_;
					GtkWidget* _tmp36_;
					GtkWidget* _tmp37_;
					_tmp33_ = self->priv->outer_leaflet;
					hdy_leaflet_navigate (_tmp33_, HDY_NAVIGATION_DIRECTION_FORWARD);
					_tmp34_ = self->priv->_conversation_viewer;
					_tmp35_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_stack_get_type (), GtkStack));
					_tmp36_ = _tmp35_;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_g_object_unref0 (focus);
					focus = _tmp37_;
				}
			}
		}
	} else {
		GtkWidget* _tmp38_;
		_tmp38_ = focus;
		if (_tmp38_ != NULL) {
			gboolean _tmp39_ = FALSE;
			GtkWidget* _tmp40_;
			FolderListTree* _tmp41_;
			_tmp40_ = focus;
			_tmp41_ = self->priv->_folder_list;
			if (_tmp40_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget)) {
				_tmp39_ = TRUE;
			} else {
				GtkWidget* _tmp42_;
				FolderListTree* _tmp43_;
				_tmp42_ = focus;
				_tmp43_ = self->priv->_folder_list;
				_tmp39_ = gtk_widget_is_ancestor (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
			}
			if (_tmp39_) {
				ConversationListView* _tmp44_;
				GtkWidget* _tmp45_;
				_tmp44_ = self->priv->_conversation_list_view;
				_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (focus);
				focus = _tmp45_;
			} else {
				gboolean _tmp46_ = FALSE;
				GtkWidget* _tmp47_;
				ConversationListView* _tmp48_;
				_tmp47_ = focus;
				_tmp48_ = self->priv->_conversation_list_view;
				if (_tmp47_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget)) {
					_tmp46_ = TRUE;
				} else {
					GtkWidget* _tmp49_;
					ConversationListView* _tmp50_;
					_tmp49_ = focus;
					_tmp50_ = self->priv->_conversation_list_view;
					_tmp46_ = gtk_widget_is_ancestor (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget));
				}
				if (_tmp46_) {
					ConversationViewer* _tmp51_;
					GtkWidget* _tmp52_;
					GtkWidget* _tmp53_;
					GtkWidget* _tmp54_;
					_tmp51_ = self->priv->_conversation_viewer;
					_tmp52_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_stack_get_type (), GtkStack));
					_tmp53_ = _tmp52_;
					_tmp54_ = _g_object_ref0 (_tmp53_);
					_g_object_unref0 (focus);
					focus = _tmp54_;
				} else {
					gboolean _tmp55_ = FALSE;
					GtkWidget* _tmp56_;
					ConversationViewer* _tmp57_;
					_tmp56_ = focus;
					_tmp57_ = self->priv->_conversation_viewer;
					if (_tmp56_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget)) {
						_tmp55_ = TRUE;
					} else {
						GtkWidget* _tmp58_;
						ConversationViewer* _tmp59_;
						_tmp58_ = focus;
						_tmp59_ = self->priv->_conversation_viewer;
						_tmp55_ = gtk_widget_is_ancestor (_tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
					}
					if (_tmp55_) {
						FolderListTree* _tmp60_;
						GtkWidget* _tmp61_;
						_tmp60_ = self->priv->_folder_list;
						_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
						_g_object_unref0 (focus);
						focus = _tmp61_;
					}
				}
			}
		}
	}
	_tmp62_ = focus;
	if (_tmp62_ != NULL) {
		GtkWidget* _tmp63_;
		gboolean _tmp64_ = FALSE;
		_tmp63_ = focus;
		g_signal_emit_by_name (_tmp63_, "focus", GTK_DIR_TAB_FORWARD, &_tmp64_);
	} else {
		gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (focus);
}

static void
application_main_window_focus_previous_pane (ApplicationMainWindow* self)
{
	GtkWidget* focus = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	HdyLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkWidget* _tmp50_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	focus = _tmp1_;
	_tmp2_ = self->priv->outer_leaflet;
	_tmp3_ = hdy_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		HdyLeaflet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->outer_leaflet;
		_tmp6_ = hdy_leaflet_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		if (g_strcmp0 (_tmp7_, APPLICATION_MAIN_WINDOW_INNER_LEAFLET) == 0) {
			HdyLeaflet* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->inner_leaflet;
			_tmp9_ = hdy_leaflet_get_folded (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				HdyLeaflet* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = self->priv->inner_leaflet;
				_tmp12_ = hdy_leaflet_get_visible_child_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, APPLICATION_MAIN_WINDOW_CONVERSATION_LIST) == 0) {
					HdyLeaflet* _tmp14_;
					FolderListTree* _tmp15_;
					GtkWidget* _tmp16_;
					_tmp14_ = self->priv->inner_leaflet;
					hdy_leaflet_navigate (_tmp14_, HDY_NAVIGATION_DIRECTION_BACK);
					_tmp15_ = self->priv->_folder_list;
					_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (focus);
					focus = _tmp16_;
				}
			} else {
				GtkWidget* _tmp17_;
				ConversationListView* _tmp18_;
				_tmp17_ = focus;
				_tmp18_ = self->priv->_conversation_list_view;
				if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget)) {
					FolderListTree* _tmp19_;
					GtkWidget* _tmp20_;
					_tmp19_ = self->priv->_folder_list;
					_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (focus);
					focus = _tmp20_;
				} else {
					ConversationListView* _tmp21_;
					GtkWidget* _tmp22_;
					_tmp21_ = self->priv->_conversation_list_view;
					_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (focus);
					focus = _tmp22_;
				}
			}
		} else {
			HdyLeaflet* _tmp23_;
			ConversationListView* _tmp24_;
			GtkWidget* _tmp25_;
			_tmp23_ = self->priv->outer_leaflet;
			hdy_leaflet_navigate (_tmp23_, HDY_NAVIGATION_DIRECTION_BACK);
			_tmp24_ = self->priv->_conversation_list_view;
			_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (focus);
			focus = _tmp25_;
		}
	} else {
		GtkWidget* _tmp26_;
		_tmp26_ = focus;
		if (_tmp26_ != NULL) {
			gboolean _tmp27_ = FALSE;
			GtkWidget* _tmp28_;
			FolderListTree* _tmp29_;
			_tmp28_ = focus;
			_tmp29_ = self->priv->_folder_list;
			if (_tmp28_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget)) {
				_tmp27_ = TRUE;
			} else {
				GtkWidget* _tmp30_;
				FolderListTree* _tmp31_;
				_tmp30_ = focus;
				_tmp31_ = self->priv->_folder_list;
				_tmp27_ = gtk_widget_is_ancestor (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
			}
			if (_tmp27_) {
				ConversationViewer* _tmp32_;
				GtkWidget* _tmp33_;
				GtkWidget* _tmp34_;
				GtkWidget* _tmp35_;
				_tmp32_ = self->priv->_conversation_viewer;
				_tmp33_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_stack_get_type (), GtkStack));
				_tmp34_ = _tmp33_;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_g_object_unref0 (focus);
				focus = _tmp35_;
			} else {
				gboolean _tmp36_ = FALSE;
				GtkWidget* _tmp37_;
				ConversationListView* _tmp38_;
				_tmp37_ = focus;
				_tmp38_ = self->priv->_conversation_list_view;
				if (_tmp37_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget)) {
					_tmp36_ = TRUE;
				} else {
					GtkWidget* _tmp39_;
					ConversationListView* _tmp40_;
					_tmp39_ = focus;
					_tmp40_ = self->priv->_conversation_list_view;
					_tmp36_ = gtk_widget_is_ancestor (_tmp39_, G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget));
				}
				if (_tmp36_) {
					FolderListTree* _tmp41_;
					GtkWidget* _tmp42_;
					_tmp41_ = self->priv->_folder_list;
					_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (focus);
					focus = _tmp42_;
				} else {
					gboolean _tmp43_ = FALSE;
					GtkWidget* _tmp44_;
					ConversationViewer* _tmp45_;
					_tmp44_ = focus;
					_tmp45_ = self->priv->_conversation_viewer;
					if (_tmp44_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget)) {
						_tmp43_ = TRUE;
					} else {
						GtkWidget* _tmp46_;
						ConversationViewer* _tmp47_;
						_tmp46_ = focus;
						_tmp47_ = self->priv->_conversation_viewer;
						_tmp43_ = gtk_widget_is_ancestor (_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget));
					}
					if (_tmp43_) {
						ConversationListView* _tmp48_;
						GtkWidget* _tmp49_;
						_tmp48_ = self->priv->_conversation_list_view;
						_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget));
						_g_object_unref0 (focus);
						focus = _tmp49_;
					}
				}
			}
		}
	}
	_tmp50_ = focus;
	if (_tmp50_ != NULL) {
		GtkWidget* _tmp51_;
		gboolean _tmp52_ = FALSE;
		_tmp51_ = focus;
		g_signal_emit_by_name (_tmp51_, "focus", GTK_DIR_TAB_FORWARD, &_tmp52_);
	} else {
		gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (focus);
}

static GSimpleAction*
application_main_window_get_window_action (ApplicationMainWindow* self,
                                           const gchar* name)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

static GSimpleAction*
application_main_window_get_edit_action (ApplicationMainWindow* self,
                                         const gchar* name)
{
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->edit_actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp2_;
	return result;
}

static void
application_main_window_activate_action (ApplicationMainWindow* self,
                                         GAction* action)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((action == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()));
	if (action != NULL) {
		_tmp0_ = g_action_get_enabled (action);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_action_activate (action, NULL);
	} else {
		gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}

static void
application_main_window_on_scan_completed (ApplicationMainWindow* self,
                                           GearyAppConversationMonitor* monitor)
{
	GtkScrollbar* scrollbar = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkScrollbar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	_tmp0_ = self->priv->conversation_list_scrolled;
	_tmp1_ = gtk_scrolled_window_get_vscrollbar (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_scrollbar_get_type ()) ? ((GtkScrollbar*) _tmp1_) : NULL);
	scrollbar = _tmp2_;
	if (gtk_widget_is_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget))) {
		gboolean _tmp6_ = FALSE;
		GtkScrollbar* _tmp7_;
		_tmp7_ = scrollbar;
		if (_tmp7_ == NULL) {
			_tmp6_ = TRUE;
		} else {
			GtkScrollbar* _tmp8_;
			_tmp8_ = scrollbar;
			_tmp6_ = !gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp5_ = _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GearyAppConversationMonitor* _tmp9_;
		_tmp9_ = self->priv->_conversations;
		_tmp4_ = monitor == _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = geary_app_conversation_monitor_get_can_load_more (monitor);
		_tmp11_ = _tmp10_;
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GearyFolder* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = self->priv->_selected_folder;
		_tmp13_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp14_ = _tmp13_;
		g_debug ("application-main-window.vala:2062: Not enough messages, loading more f" \
"or folder %s", _tmp14_);
		_g_free0 (_tmp14_);
		application_main_window_load_more (self);
	}
	_g_object_unref0 (scrollbar);
}

static void
application_main_window_on_scan_error (ApplicationMainWindow* self,
                                       GearyAppConversationMonitor* monitor,
                                       GError* err)
{
	GearyAccountInformation* account = NULL;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccount* _tmp3_;
	GearyAccountInformation* _tmp4_;
	GearyAccountInformation* _tmp5_;
	GearyAccountInformation* _tmp6_;
	ApplicationController* _tmp7_;
	GearyServiceInformation* _tmp8_;
	GearyServiceInformation* _tmp9_;
	GearyServiceProblemReport* _tmp10_;
	GearyServiceProblemReport* _tmp11_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	g_return_if_fail (err != NULL);
	_tmp0_ = geary_app_conversation_monitor_get_base_folder (monitor);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_folder_get_account (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_account_get_information (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	account = _tmp6_;
	_tmp7_ = self->priv->controller;
	_tmp8_ = geary_account_information_get_incoming (account);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_service_problem_report_new (account, _tmp9_, err);
	_tmp11_ = _tmp10_;
	composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (account);
}

static void
application_main_window_on_load_more (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_load_more (self);
}

static void
application_main_window_on_map (ApplicationMainWindow* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->update_ui_timeout;
	geary_timeout_manager_start (_tmp0_);
	application_main_window_update_ui (self);
}

static void
_application_main_window_on_map_gtk_widget_map (GtkWidget* _sender,
                                                gpointer self)
{
	application_main_window_on_map ((ApplicationMainWindow*) self);
}

static void
application_main_window_on_unmap (ApplicationMainWindow* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->update_ui_timeout;
	geary_timeout_manager_reset (_tmp0_);
}

static void
_application_main_window_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                    gpointer self)
{
	application_main_window_on_unmap ((ApplicationMainWindow*) self);
}

static gboolean
application_main_window_on_focus_event (ApplicationMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	application_main_window_set_shift_key_down (self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
_application_main_window_on_focus_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                    GdkEventFocus* event,
                                                                    gpointer self)
{
	gboolean result;
	result = application_main_window_on_focus_event ((ApplicationMainWindow*) self);
	return result;
}

static void
___lambda202_ (ApplicationMainWindow* self,
               GObject* obj,
               GAsyncResult* res)
{
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	application_main_window_select_folder_finish (self, res);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
____lambda202__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda202_ ((ApplicationMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
application_main_window_on_delete_event (ApplicationMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (self), FALSE);
	if (application_main_window_close_composer (self, TRUE, FALSE)) {
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
		application_main_window_select_folder (self, NULL, FALSE, TRUE, ____lambda202__gasync_ready_callback, g_object_ref (self));
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
_application_main_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                  GdkEventAny* event,
                                                                  gpointer self)
{
	gboolean result;
	result = application_main_window_on_delete_event ((ApplicationMainWindow*) self);
	return result;
}

static void
application_main_window_on_outer_leaflet_changed (ApplicationMainWindow* self)
{
	gint selected = 0;
	ConversationListView* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	HdyLeaflet* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_conversation_list_view;
	_tmp1_ = conversation_list_view_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	selected = _tmp5_;
	application_main_window_update_conversation_actions (self, application_main_window_conversation_count_for_size (selected));
	_tmp6_ = self->priv->outer_leaflet;
	_tmp7_ = hdy_leaflet_get_folded (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		ComponentsConversationListHeaderBar* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp9_ = self->priv->conversation_list_headerbar;
		hdy_header_bar_set_show_close_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, hdy_header_bar_get_type (), HdyHeaderBar), TRUE);
		_tmp10_ = application_main_window_get_is_conversation_list_shown (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			ConversationListView* _tmp12_;
			_tmp12_ = self->priv->_conversation_list_view;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		} else {
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp13_ = application_main_window_get_is_folder_list_shown (self);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				FolderListTree* _tmp15_;
				_tmp15_ = self->priv->_folder_list;
				gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
			} else {
				ComponentsConversationHeaderBar* _tmp16_;
				GtkButton* _tmp17_;
				_tmp16_ = self->conversation_headerbar;
				_tmp17_ = _tmp16_->back_button;
				gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), TRUE);
			}
		}
		_tmp19_ = application_main_window_get_has_composer (self);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = application_main_window_get_is_folder_list_shown (self);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				_tmp21_ = TRUE;
			} else {
				gboolean _tmp24_;
				gboolean _tmp25_;
				_tmp24_ = application_main_window_get_is_conversation_list_shown (self);
				_tmp25_ = _tmp24_;
				_tmp21_ = _tmp25_;
			}
			_tmp18_ = _tmp21_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			application_main_window_close_composer (self, FALSE, FALSE);
		}
	} else {
		ComponentsConversationListHeaderBar* _tmp26_;
		ComponentsConversationHeaderBar* _tmp27_;
		GtkButton* _tmp28_;
		_tmp26_ = self->priv->conversation_list_headerbar;
		hdy_header_bar_set_show_close_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, hdy_header_bar_get_type (), HdyHeaderBar), FALSE);
		_tmp27_ = self->conversation_headerbar;
		_tmp28_ = _tmp27_->back_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
}

static void
_application_main_window_on_outer_leaflet_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	application_main_window_on_outer_leaflet_changed ((ApplicationMainWindow*) self);
}

static void
application_main_window_on_inner_leaflet_changed (ApplicationMainWindow* self)
{
	HdyLeaflet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->inner_leaflet;
	_tmp1_ = hdy_leaflet_get_folded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ComponentsApplicationHeaderBar* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->application_headerbar;
		hdy_header_bar_set_show_close_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, hdy_header_bar_get_type (), HdyHeaderBar), TRUE);
		_tmp4_ = application_main_window_get_is_conversation_list_shown (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ComponentsConversationListHeaderBar* _tmp6_;
			GtkButton* _tmp7_;
			ConversationListView* _tmp8_;
			_tmp6_ = self->priv->conversation_list_headerbar;
			_tmp7_ = _tmp6_->back_button;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp8_ = self->priv->_conversation_list_view;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = application_main_window_get_is_folder_list_shown (self);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				FolderListTree* _tmp11_;
				_tmp11_ = self->priv->_folder_list;
				gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
			}
		}
	} else {
		ComponentsApplicationHeaderBar* _tmp12_;
		ComponentsConversationListHeaderBar* _tmp13_;
		GtkButton* _tmp14_;
		_tmp12_ = self->priv->application_headerbar;
		hdy_header_bar_set_show_close_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, hdy_header_bar_get_type (), HdyHeaderBar), FALSE);
		_tmp13_ = self->priv->conversation_list_headerbar;
		_tmp14_ = _tmp13_->back_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
}

static void
_application_main_window_on_inner_leaflet_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	application_main_window_on_inner_leaflet_changed ((ApplicationMainWindow*) self);
}

static void
application_main_window_on_offline_infobar_response (ApplicationMainWindow* self)
{
	ComponentsInfoBarStack* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = self->priv->offline_infobar;
	components_info_bar_stack_remove (_tmp0_, _tmp1_);
}

static void
application_main_window_on_service_problem_retry (ApplicationMainWindow* self)
{
	ComponentsInfoBarStack* _tmp0_;
	ComponentsProblemReportInfoBar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = self->priv->service_problem_infobar;
	components_info_bar_stack_remove (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar));
	_g_object_unref0 (self->priv->service_problem_infobar);
	self->priv->service_problem_infobar = NULL;
	g_signal_emit (self, application_main_window_signals[APPLICATION_MAIN_WINDOW_RETRY_SERVICE_PROBLEM_SIGNAL], 0, GEARY_CLIENT_SERVICE_STATUS_CONNECTION_FAILED);
}

static void
application_main_window_on_cert_problem_retry (ApplicationMainWindow* self)
{
	ComponentsInfoBarStack* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = self->priv->cert_problem_infobar;
	components_info_bar_stack_remove (_tmp0_, _tmp1_);
	g_signal_emit (self, application_main_window_signals[APPLICATION_MAIN_WINDOW_RETRY_SERVICE_PROBLEM_SIGNAL], 0, GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED);
}

static void
application_main_window_on_auth_problem_retry (ApplicationMainWindow* self)
{
	ComponentsInfoBarStack* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = self->priv->auth_problem_infobar;
	components_info_bar_stack_remove (_tmp0_, _tmp1_);
	g_signal_emit (self, application_main_window_signals[APPLICATION_MAIN_WINDOW_RETRY_SERVICE_PROBLEM_SIGNAL], 0, GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED);
}

static void
application_main_window_on_update_ui_timeout (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_update_ui (self);
}

static void
application_main_window_on_account_available (ApplicationMainWindow* self,
                                              ApplicationAccountContext* account)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	application_main_window_add_account (self, account);
}

static void
application_main_window_on_account_unavailable (ApplicationMainWindow* self,
                                                ApplicationAccountContext* account,
                                                gboolean is_shutdown)
{
	GearyFolder* to_select = NULL;
	GearyFolder* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	to_select = NULL;
	if (!is_shutdown) {
		GearyFolder* _tmp0_;
		_tmp0_ = application_main_window_get_first_inbox (self);
		_g_object_unref0 (to_select);
		to_select = _tmp0_;
	}
	_tmp1_ = to_select;
	application_main_window_remove_account (self, account, _tmp1_, NULL, NULL);
	_g_object_unref0 (to_select);
}

static void
application_main_window_on_folders_available (ApplicationMainWindow* self,
                                              GeeCollection* available)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (available, GEE_TYPE_COLLECTION));
	application_main_window_add_folders (self, available);
}

static void
application_main_window_on_folders_unavailable (ApplicationMainWindow* self,
                                                GeeCollection* unavailable)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unavailable, GEE_TYPE_COLLECTION));
	application_main_window_remove_folders (self, unavailable, TRUE);
}

static void
application_main_window_on_use_changed (ApplicationMainWindow* self,
                                        GearyFolder* folder,
                                        GearyFolderSpecialUse old_type,
                                        GearyFolderSpecialUse new_type)
{
	ApplicationAccountContext* context = NULL;
	ApplicationController* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccountInformation* _tmp3_;
	GearyAccountInformation* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	ApplicationAccountContext* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	_tmp0_ = self->priv->controller;
	_tmp1_ = geary_folder_get_account (folder);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_account_get_information (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _tmp4_);
	context = _tmp5_;
	_tmp6_ = context;
	if (_tmp6_ != NULL) {
		ApplicationFolderContext* folder_context = NULL;
		ApplicationAccountContext* _tmp7_;
		ApplicationFolderContext* _tmp8_;
		ApplicationFolderContext* _tmp9_;
		_tmp7_ = context;
		_tmp8_ = application_account_context_get_folder (_tmp7_, folder);
		folder_context = _tmp8_;
		_tmp9_ = folder_context;
		if (_tmp9_ != NULL) {
			FolderListTree* _tmp10_;
			ApplicationFolderContext* _tmp11_;
			FolderListTree* _tmp12_;
			ApplicationFolderContext* _tmp13_;
			_tmp10_ = self->priv->_folder_list;
			_tmp11_ = folder_context;
			folder_list_tree_remove_folder (_tmp10_, _tmp11_);
			_tmp12_ = self->priv->_folder_list;
			_tmp13_ = folder_context;
			folder_list_tree_add_folder (_tmp12_, _tmp13_);
			{
				GeeCollection* _tmp14_ = NULL;
				GearyAccount* _tmp15_;
				GearyAccount* _tmp16_;
				GearyFolderPath* _tmp17_;
				GearyFolderPath* _tmp18_;
				GeeCollection* _tmp19_;
				_tmp15_ = geary_folder_get_account (folder);
				_tmp16_ = _tmp15_;
				_tmp17_ = geary_folder_get_path (folder);
				_tmp18_ = _tmp17_;
				_tmp19_ = geary_account_list_matching_folders (_tmp16_, _tmp18_, &_inner_error0_);
				_tmp14_ = _tmp19_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				{
					GeeIterator* _child_it = NULL;
					GeeIterator* _tmp20_;
					_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
					_child_it = _tmp20_;
					while (TRUE) {
						GeeIterator* _tmp21_;
						GearyFolder* child = NULL;
						GeeIterator* _tmp22_;
						gpointer _tmp23_;
						ApplicationFolderContext* child_context = NULL;
						ApplicationAccountContext* _tmp24_;
						GearyFolder* _tmp25_;
						ApplicationFolderContext* _tmp26_;
						ApplicationFolderContext* _tmp27_;
						_tmp21_ = _child_it;
						if (!gee_iterator_next (_tmp21_)) {
							break;
						}
						_tmp22_ = _child_it;
						_tmp23_ = gee_iterator_get (_tmp22_);
						child = (GearyFolder*) _tmp23_;
						_tmp24_ = context;
						_tmp25_ = child;
						_tmp26_ = application_account_context_get_folder (_tmp24_, _tmp25_);
						child_context = _tmp26_;
						_tmp27_ = child_context;
						if (_tmp27_ != NULL) {
							FolderListTree* _tmp28_;
							ApplicationFolderContext* _tmp29_;
							_tmp28_ = self->priv->_folder_list;
							_tmp29_ = child_context;
							folder_list_tree_add_folder (_tmp28_, _tmp29_);
						}
						_g_object_unref0 (child_context);
						_g_object_unref0 (child);
					}
					_g_object_unref0 (_child_it);
				}
				_g_object_unref0 (_tmp14_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder_context);
				_g_object_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_object_unref0 (folder_context);
	}
	_g_object_unref0 (context);
}

static void
application_main_window_on_command_execute (ApplicationMainWindow* self,
                                            ApplicationCommand* command)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_COMMAND (command));
	if (!APPLICATION_IS_TRIVIAL_COMMAND (command)) {
		application_main_window_on_command_redo (self, command);
	} else {
		application_main_window_update_command_actions (self);
	}
}

static void
application_main_window_on_command_undo (ApplicationMainWindow* self,
                                         ApplicationCommand* command)
{
	ApplicationEmailCommand* email = NULL;
	ApplicationEmailCommand* _tmp0_;
	ApplicationEmailCommand* _tmp1_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_COMMAND (command));
	application_main_window_update_command_actions (self);
	_tmp0_ = _g_object_ref0 (APPLICATION_IS_EMAIL_COMMAND (command) ? ((ApplicationEmailCommand*) command) : NULL);
	email = _tmp0_;
	_tmp1_ = email;
	if (_tmp1_ != NULL) {
		ApplicationEmailCommand* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp2_ = email;
		_tmp3_ = application_email_command_get_conversations (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_collection_get_size (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 1) {
			ApplicationEmailCommand* _tmp7_;
			GearyFolder* _tmp8_;
			GearyFolder* _tmp9_;
			ApplicationEmailCommand* _tmp10_;
			GeeCollection* _tmp11_;
			GeeCollection* _tmp12_;
			_tmp7_ = email;
			_tmp8_ = application_email_command_get_location (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = email;
			_tmp11_ = application_email_command_get_conversations (_tmp10_);
			_tmp12_ = _tmp11_;
			application_main_window_show_conversations (self, _tmp9_, _tmp12_, FALSE, NULL, NULL);
		} else {
			ApplicationEmailCommand* _tmp13_;
			GearyFolder* _tmp14_;
			GearyFolder* _tmp15_;
			ApplicationEmailCommand* _tmp16_;
			GeeCollection* _tmp17_;
			GeeCollection* _tmp18_;
			_tmp13_ = email;
			_tmp14_ = application_email_command_get_location (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = email;
			_tmp17_ = application_email_command_get_email (_tmp16_);
			_tmp18_ = _tmp17_;
			application_main_window_show_email (self, _tmp15_, _tmp18_, FALSE, NULL, NULL);
		}
	}
	_tmp19_ = application_command_get_undone_label (command);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		ComponentsInAppNotification* ian = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ComponentsInAppNotification* _tmp23_;
		ComponentsInAppNotification* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		ComponentsInAppNotification* _tmp27_;
		_tmp21_ = application_command_get_undone_label (command);
		_tmp22_ = _tmp21_;
		_tmp23_ = components_in_app_notification_new (_tmp22_, COMPONENTS_IN_APP_NOTIFICATION_DEFAULT_DURATION);
		g_object_ref_sink (_tmp23_);
		ian = _tmp23_;
		_tmp24_ = ian;
		_tmp25_ = action_edit_prefix (ACTION_EDIT_REDO);
		_tmp26_ = _tmp25_;
		components_in_app_notification_set_button (_tmp24_, _ ("Redo"), _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = ian;
		application_main_window_add_notification (self, _tmp27_);
		_g_object_unref0 (ian);
	}
	_g_object_unref0 (email);
}

static void
application_main_window_on_command_redo (ApplicationMainWindow* self,
                                         ApplicationCommand* command)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (APPLICATION_IS_COMMAND (command));
	application_main_window_update_command_actions (self);
	_tmp0_ = application_command_get_executed_label (command);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		guint notification_time = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_;
		ComponentsInAppNotification* ian = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ComponentsInAppNotification* _tmp12_;
		ComponentsInAppNotification* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ComponentsInAppNotification* _tmp16_;
		notification_time = COMPONENTS_IN_APP_NOTIFICATION_DEFAULT_DURATION;
		_tmp2_ = application_command_get_executed_notification_brief (command);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			ApplicationClient* _tmp4_;
			ApplicationClient* _tmp5_;
			ApplicationConfiguration* _tmp6_;
			ApplicationConfiguration* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp4_ = application_main_window_get_application (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = application_client_get_config (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = application_configuration_get_brief_notification_duration (_tmp7_);
			_tmp9_ = _tmp8_;
			notification_time = (guint) _tmp9_;
		}
		_tmp10_ = application_command_get_executed_label (command);
		_tmp11_ = _tmp10_;
		_tmp12_ = components_in_app_notification_new (_tmp11_, notification_time);
		g_object_ref_sink (_tmp12_);
		ian = _tmp12_;
		_tmp13_ = ian;
		_tmp14_ = action_edit_prefix (ACTION_EDIT_UNDO);
		_tmp15_ = _tmp14_;
		components_in_app_notification_set_button (_tmp13_, _ ("Undo"), _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = ian;
		application_main_window_add_notification (self, _tmp16_);
		_g_object_unref0 (ian);
	}
}

static void
_application_main_window_on_email_loaded_conversation_list_box_email_loaded (ConversationListBox* _sender,
                                                                             GearyEmail* email,
                                                                             gpointer self)
{
	application_main_window_on_email_loaded ((ApplicationMainWindow*) self, _sender, email);
}

static void
_application_main_window_on_email_mark_conversation_list_box_mark_email (ConversationListBox* _sender,
                                                                         GeeCollection* email,
                                                                         GearyNamedFlag* to_add,
                                                                         GearyNamedFlag* to_remove,
                                                                         gpointer self)
{
	application_main_window_on_email_mark ((ApplicationMainWindow*) self, _sender, email, to_add, to_remove);
}

static void
_application_main_window_on_email_reply_to_all_conversation_list_box_reply_to_all_email (ConversationListBox* _sender,
                                                                                         GearyEmail* email,
                                                                                         const gchar* quote,
                                                                                         gpointer self)
{
	application_main_window_on_email_reply_to_all ((ApplicationMainWindow*) self, email, quote);
}

static void
_application_main_window_on_email_reply_to_sender_conversation_list_box_reply_to_sender_email (ConversationListBox* _sender,
                                                                                               GearyEmail* email,
                                                                                               const gchar* quote,
                                                                                               gpointer self)
{
	application_main_window_on_email_reply_to_sender ((ApplicationMainWindow*) self, email, quote);
}

static void
_application_main_window_on_email_forward_conversation_list_box_forward_email (ConversationListBox* _sender,
                                                                               GearyEmail* email,
                                                                               const gchar* quote,
                                                                               gpointer self)
{
	application_main_window_on_email_forward ((ApplicationMainWindow*) self, email, quote);
}

static void
_application_main_window_on_email_trash_conversation_list_box_trash_email (ConversationListBox* _sender,
                                                                           GearyEmail* email,
                                                                           gpointer self)
{
	application_main_window_on_email_trash ((ApplicationMainWindow*) self, _sender, email);
}

static void
_application_main_window_on_email_delete_conversation_list_box_delete_email (ConversationListBox* _sender,
                                                                             GearyEmail* email,
                                                                             gpointer self)
{
	application_main_window_on_email_delete ((ApplicationMainWindow*) self, _sender, email);
}

static void
application_main_window_on_conversation_view_added (ApplicationMainWindow* self,
                                                    ConversationListBox* list)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (list));
	g_signal_connect_object (list, "email-loaded", (GCallback) _application_main_window_on_email_loaded_conversation_list_box_email_loaded, self, 0);
	g_signal_connect_object (list, "mark-email", (GCallback) _application_main_window_on_email_mark_conversation_list_box_mark_email, self, 0);
	g_signal_connect_object (list, "reply-to-all-email", (GCallback) _application_main_window_on_email_reply_to_all_conversation_list_box_reply_to_all_email, self, 0);
	g_signal_connect_object (list, "reply-to-sender-email", (GCallback) _application_main_window_on_email_reply_to_sender_conversation_list_box_reply_to_sender_email, self, 0);
	g_signal_connect_object (list, "forward-email", (GCallback) _application_main_window_on_email_forward_conversation_list_box_forward_email, self, 0);
	g_signal_connect_object (list, "trash-email", (GCallback) _application_main_window_on_email_trash_conversation_list_box_trash_email, self, 0);
	g_signal_connect_object (list, "delete-email", (GCallback) _application_main_window_on_email_delete_conversation_list_box_delete_email, self, 0);
}

static void
application_main_window_on_undo (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_undo (self, NULL, NULL);
}

static void
application_main_window_on_redo (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_redo (self, NULL, NULL);
}

static void
application_main_window_on_close (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	gtk_window_close (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
}

static void
application_main_window_on_has_toplevel_focus (ApplicationMainWindow* self)
{
	GearyFolder* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_selected_folder;
	if (_tmp0_ != NULL) {
		ApplicationController* _tmp1_;
		GearyFolder* _tmp2_;
		ConversationListView* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		_tmp1_ = self->priv->controller;
		_tmp2_ = self->priv->_selected_folder;
		_tmp3_ = self->priv->_conversation_list_view;
		_tmp4_ = conversation_list_view_get_visible_conversations (_tmp3_);
		_tmp5_ = _tmp4_;
		application_controller_clear_new_messages (_tmp1_, _tmp2_, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}

static void
application_main_window_on_folder_selected (ApplicationMainWindow* self,
                                            GearyFolder* folder)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((folder == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	application_main_window_select_folder (self, folder, TRUE, FALSE, NULL, NULL);
}

static void
application_main_window_on_select_inbox (ApplicationMainWindow* self,
                                         GSimpleAction* action,
                                         GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	if (parameter != NULL) {
		gint account_number = 0;
		account_number = (gint) g_variant_get_int32 (parameter);
		{
			GeeCollection* accounts = NULL;
			ApplicationClient* _tmp0_;
			ApplicationClient* _tmp1_;
			GearyEngine* _tmp2_;
			GearyEngine* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp0_ = application_main_window_get_application (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = application_client_get_engine (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = geary_engine_get_accounts (_tmp3_, &_inner_error0_);
			accounts = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = accounts;
			_tmp6_ = gee_collection_get_size (_tmp5_);
			_tmp7_ = _tmp6_;
			if (account_number < _tmp7_) {
				GearyAccount* account = NULL;
				GeeCollection* _tmp8_;
				gint _tmp9_ = 0;
				gpointer* _tmp10_;
				GearyAccount** _tmp11_;
				gint _tmp11__length1;
				GearyAccount* _tmp12_;
				GearyAccount* _tmp13_;
				GearyAccount* _tmp14_;
				GearyFolder* inbox = NULL;
				GearyAccount* _tmp15_;
				GearyFolder* _tmp16_;
				GearyFolder* _tmp17_;
				_tmp8_ = accounts;
				_tmp10_ = gee_collection_to_array (_tmp8_, &_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp11__length1 = _tmp9_;
				_tmp12_ = _tmp11_[account_number];
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
				account = _tmp14_;
				_tmp15_ = account;
				_tmp16_ = geary_account_get_special_folder (_tmp15_, GEARY_FOLDER_SPECIAL_USE_INBOX);
				inbox = _tmp16_;
				_tmp17_ = inbox;
				application_main_window_select_folder (self, _tmp17_, TRUE, FALSE, NULL, NULL);
				_g_object_unref0 (inbox);
				_g_object_unref0 (account);
			}
			_g_object_unref0 (accounts);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_debug ("application-main-window.vala:2343: Error getting accounts");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
application_main_window_on_search (ApplicationMainWindow* self,
                                   const gchar* text)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (text != NULL);
	if (geary_string_is_empty_or_whitespace (text)) {
		application_main_window_stop_search (self, TRUE);
	} else {
		application_main_window_start_search (self, text, TRUE);
	}
}

static void
application_main_window_on_visible_conversations_changed (ApplicationMainWindow* self,
                                                          GeeSet* visible)
{
	GearyFolder* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visible, GEE_TYPE_SET));
	_tmp0_ = self->priv->_selected_folder;
	if (_tmp0_ != NULL) {
		ApplicationController* _tmp1_;
		GearyFolder* _tmp2_;
		_tmp1_ = self->priv->controller;
		_tmp2_ = self->priv->_selected_folder;
		application_controller_clear_new_messages (_tmp1_, _tmp2_, visible);
	}
}

static void
application_main_window_on_folder_activated (ApplicationMainWindow* self,
                                             GearyFolder* folder)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail ((folder == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	if (folder != NULL) {
		application_main_window_focus_next_pane (self);
	}
}

static void
application_main_window_on_conversation_activated (ApplicationMainWindow* self,
                                                   GearyAppConversation* activated,
                                                   gboolean single)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (activated, GEARY_APP_TYPE_CONVERSATION));
	if (single) {
		HdyLeaflet* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->outer_leaflet;
		_tmp1_ = hdy_leaflet_get_folded (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			application_main_window_focus_next_pane (self);
		}
	} else {
		GearyFolder* _tmp3_;
		_tmp3_ = self->priv->_selected_folder;
		if (_tmp3_ != NULL) {
			GearyFolder* _tmp4_;
			GearyFolderSpecialUse _tmp5_;
			GearyFolderSpecialUse _tmp6_;
			_tmp4_ = self->priv->_selected_folder;
			_tmp5_ = geary_folder_get_used_as (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_ != GEARY_FOLDER_SPECIAL_USE_DRAFTS) {
				ApplicationClient* _tmp7_;
				ApplicationClient* _tmp8_;
				GearyFolder* _tmp9_;
				ConversationListView* _tmp10_;
				GeeSet* _tmp11_;
				GeeSet* _tmp12_;
				_tmp7_ = application_main_window_get_application (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->_selected_folder;
				_tmp10_ = self->priv->_conversation_list_view;
				_tmp11_ = conversation_list_view_copy_selected (_tmp10_);
				_tmp12_ = _tmp11_;
				application_client_new_window (_tmp8_, _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
				_g_object_unref0 (_tmp12_);
			} else {
				GearyEmail* draft = NULL;
				GearyEmail* _tmp13_;
				GearyFolder* _tmp14_;
				GearyAccount* _tmp15_;
				GearyAccount* _tmp16_;
				GearyEmail* _tmp17_;
				_tmp13_ = geary_app_conversation_get_latest_recv_email (activated, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER, NULL);
				draft = _tmp13_;
				_tmp14_ = self->priv->_selected_folder;
				_tmp15_ = geary_folder_get_account (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = draft;
				application_main_window_create_composer (self, _tmp16_, COMPOSER_WIDGET_CONTEXT_TYPE_EDIT, _tmp17_, NULL, NULL, NULL);
				_g_object_unref0 (draft);
			}
		}
	}
}

static void
application_main_window_on_find_in_conversation_action (ApplicationMainWindow* self)
{
	ConversationViewer* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_conversation_viewer;
	conversation_viewer_enable_find (_tmp0_);
}

static void
application_main_window_on_search_activated (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_show_search_bar (self, NULL);
}

static void
application_main_window_on_zoom (ApplicationMainWindow* self,
                                 GSimpleAction* action,
                                 GVariant* parameter)
{
	ConversationListBox* view = NULL;
	ConversationViewer* _tmp0_;
	ConversationListBox* _tmp1_;
	ConversationListBox* _tmp2_;
	ConversationListBox* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ConversationListBox* _tmp5_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = self->priv->_conversation_viewer;
	_tmp1_ = conversation_viewer_get_current_list (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	view = _tmp3_;
	_tmp5_ = view;
	if (_tmp5_ != NULL) {
		_tmp4_ = parameter != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* zoom_action = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = g_variant_get_string (parameter, NULL);
		_tmp7_ = g_strdup (_tmp6_);
		zoom_action = _tmp7_;
		_tmp8_ = zoom_action;
		if (g_strcmp0 (_tmp8_, "in") == 0) {
			ConversationListBox* _tmp9_;
			_tmp9_ = view;
			conversation_list_box_zoom_in (_tmp9_);
		} else {
			const gchar* _tmp10_;
			_tmp10_ = zoom_action;
			if (g_strcmp0 (_tmp10_, "out") == 0) {
				ConversationListBox* _tmp11_;
				_tmp11_ = view;
				conversation_list_box_zoom_out (_tmp11_);
			} else {
				ConversationListBox* _tmp12_;
				_tmp12_ = view;
				conversation_list_box_zoom_reset (_tmp12_);
			}
		}
		_g_free0 (zoom_action);
	}
	_g_object_unref0 (view);
}

static void
application_main_window_on_reply_conversation (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_create_composer_from_viewer (self, COMPOSER_WIDGET_CONTEXT_TYPE_REPLY_SENDER, NULL, NULL);
}

static void
application_main_window_on_reply_all_conversation (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_create_composer_from_viewer (self, COMPOSER_WIDGET_CONTEXT_TYPE_REPLY_ALL, NULL, NULL);
}

static void
application_main_window_on_forward_conversation (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_create_composer_from_viewer (self, COMPOSER_WIDGET_CONTEXT_TYPE_FORWARD, NULL, NULL);
}

static void
application_main_window_on_show_window_menu (ApplicationMainWindow* self)
{
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	application_main_window_show_window_menu (self);
}

static void
application_main_window_on_show_help_overlay (ApplicationMainWindow* self)
{
	GtkShortcutsWindow* overlay = NULL;
	GtkShortcutsWindow* _tmp0_;
	GtkShortcutsWindow* _tmp1_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = gtk_application_window_get_help_overlay (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	overlay = _tmp1_;
	g_object_set (overlay, "section-name", "conversation", NULL);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (overlay, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (overlay);
}

static void
application_main_window_on_show_copy_menu (ApplicationMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp1_ = application_main_window_get_is_conversation_list_shown (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->conversation_list_actions_revealer;
		_tmp4_ = gtk_revealer_get_child_revealed (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ComponentsConversationActions* _tmp6_;
		_tmp6_ = self->priv->conversation_list_actions;
		components_conversation_actions_show_copy_menu (_tmp6_);
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = application_main_window_get_is_conversation_viewer_shown (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			ComponentsConversationHeaderBar* _tmp9_;
			ComponentsConversationActions* _tmp10_;
			ComponentsConversationActions* _tmp11_;
			_tmp9_ = self->conversation_headerbar;
			_tmp10_ = components_conversation_header_bar_get_shown_actions (_tmp9_);
			_tmp11_ = _tmp10_;
			components_conversation_actions_show_copy_menu (_tmp11_);
		} else {
			gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
}

static void
application_main_window_on_show_move_menu (ApplicationMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp1_ = application_main_window_get_is_conversation_list_shown (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->conversation_list_actions_revealer;
		_tmp4_ = gtk_revealer_get_child_revealed (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ComponentsConversationActions* _tmp6_;
		_tmp6_ = self->priv->conversation_list_actions;
		components_conversation_actions_show_move_menu (_tmp6_);
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = application_main_window_get_is_conversation_viewer_shown (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			ComponentsConversationHeaderBar* _tmp9_;
			ComponentsConversationActions* _tmp10_;
			ComponentsConversationActions* _tmp11_;
			_tmp9_ = self->conversation_headerbar;
			_tmp10_ = components_conversation_header_bar_get_shown_actions (_tmp9_);
			_tmp11_ = _tmp10_;
			components_conversation_actions_show_move_menu (_tmp11_);
		} else {
			gtk_widget_error_bell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
}

static void
application_main_window_on_conversation_up (ApplicationMainWindow* self)
{
	ConversationListView* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_conversation_list_view;
	conversation_list_view_scroll (_tmp0_, GTK_SCROLL_STEP_UP);
}

static void
application_main_window_on_conversation_down (ApplicationMainWindow* self)
{
	ConversationListView* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_conversation_list_view;
	conversation_list_view_scroll (_tmp0_, GTK_SCROLL_STEP_DOWN);
}

static void
application_main_window_on_show_mark_menu (ApplicationMainWindow* self)
{
	gboolean unread_selected = FALSE;
	gboolean read_selected = FALSE;
	gboolean starred_selected = FALSE;
	gboolean unstarred_selected = FALSE;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleAction* _tmp26_;
	GSimpleAction* _tmp27_;
	GSimpleAction* _tmp28_;
	GSimpleAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleAction* _tmp31_;
	gboolean in_junk_folder = FALSE;
	GearyFolder* _tmp32_;
	GearyFolderSpecialUse _tmp33_;
	GearyFolderSpecialUse _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GSimpleAction* _tmp43_;
	GSimpleAction* _tmp44_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	unread_selected = FALSE;
	read_selected = FALSE;
	starred_selected = FALSE;
	unstarred_selected = FALSE;
	{
		GeeIterator* _conversation_it = NULL;
		ConversationListView* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->_conversation_list_view;
		_tmp1_ = conversation_list_view_get_selected (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_conversation_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GearyAppConversation* conversation = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GearyAppConversation* _tmp8_;
			GearyEmail* latest = NULL;
			GearyAppConversation* _tmp9_;
			GearyEmail* _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			GearyEmail* _tmp13_;
			GearyAppConversation* _tmp23_;
			_tmp5_ = _conversation_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _conversation_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			conversation = (GearyAppConversation*) _tmp7_;
			_tmp8_ = conversation;
			if (geary_app_conversation_is_unread (_tmp8_)) {
				unread_selected = TRUE;
			}
			_tmp9_ = conversation;
			_tmp10_ = geary_app_conversation_get_latest_sent_email (_tmp9_, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, NULL);
			latest = _tmp10_;
			_tmp13_ = latest;
			if (_tmp13_ != NULL) {
				GearyEmail* _tmp14_;
				GearyEmailFlags* _tmp15_;
				GearyEmailFlags* _tmp16_;
				_tmp14_ = latest;
				_tmp15_ = geary_email_get_email_flags (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_ != NULL;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				GearyEmail* _tmp17_;
				GearyEmailFlags* _tmp18_;
				GearyEmailFlags* _tmp19_;
				GearyNamedFlag* _tmp20_;
				GearyNamedFlag* _tmp21_;
				GearyNamedFlag* _tmp22_;
				_tmp17_ = latest;
				_tmp18_ = geary_email_get_email_flags (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = geary_email_flags_get_UNREAD ();
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp11_ = !geary_named_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _tmp22_);
				_g_object_unref0 (_tmp22_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				read_selected = TRUE;
			}
			_tmp23_ = conversation;
			if (geary_app_conversation_is_flagged (_tmp23_)) {
				starred_selected = TRUE;
			} else {
				unstarred_selected = TRUE;
			}
			_g_object_unref0 (latest);
			_g_object_unref0 (conversation);
		}
		_g_object_unref0 (_conversation_it);
	}
	_tmp24_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_READ);
	_tmp25_ = _tmp24_;
	g_simple_action_set_enabled (_tmp25_, unread_selected);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNREAD);
	_tmp27_ = _tmp26_;
	g_simple_action_set_enabled (_tmp27_, read_selected);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_STARRED);
	_tmp29_ = _tmp28_;
	g_simple_action_set_enabled (_tmp29_, unstarred_selected);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNSTARRED);
	_tmp31_ = _tmp30_;
	g_simple_action_set_enabled (_tmp31_, starred_selected);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = self->priv->_selected_folder;
	_tmp33_ = geary_folder_get_used_as (_tmp32_);
	_tmp34_ = _tmp33_;
	in_junk_folder = _tmp34_ == GEARY_FOLDER_SPECIAL_USE_JUNK;
	if (!in_junk_folder) {
		GearyFolder* _tmp37_;
		GearyFolderSpecialUse _tmp38_;
		GearyFolderSpecialUse _tmp39_;
		_tmp37_ = self->priv->_selected_folder;
		_tmp38_ = geary_folder_get_used_as (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp36_ = _tmp39_ != GEARY_FOLDER_SPECIAL_USE_DRAFTS;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GearyFolder* _tmp40_;
		GearyFolderSpecialUse _tmp41_;
		GearyFolderSpecialUse _tmp42_;
		_tmp40_ = self->priv->_selected_folder;
		_tmp41_ = geary_folder_get_used_as (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp35_ = _tmp42_ != GEARY_FOLDER_SPECIAL_USE_OUTBOX;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp43_ = application_main_window_get_window_action (self, APPLICATION_MAIN_WINDOW_ACTION_TOGGLE_JUNK);
	_tmp44_ = _tmp43_;
	g_simple_action_set_enabled (_tmp44_, _tmp35_);
	_g_object_unref0 (_tmp44_);
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->location);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
___lambda197_ (Block20Data* _data20_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data20_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data20_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda197__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda197_ (self, source_object, res);
	block20_data_unref (self);
}

static void
application_main_window_on_mark_conversations (ApplicationMainWindow* self,
                                               GeeCollection* conversations,
                                               GearyNamedFlag* flag)
{
	Block20Data* _data20_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flag, GEARY_TYPE_NAMED_FLAG));
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data20_->location = _tmp1_;
	_tmp2_ = _data20_->location;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data20_->location;
		application_controller_mark_conversations (_tmp3_, _tmp4_, conversations, flag, TRUE, ____lambda197__gasync_ready_callback, block20_data_ref (_data20_));
	}
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->location);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
___lambda188_ (Block21Data* _data21_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data21_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data21_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda188__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda188_ (self, source_object, res);
	block21_data_unref (self);
}

static void
application_main_window_on_mark_as_read (ApplicationMainWindow* self)
{
	Block21Data* _data21_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data21_->location = _tmp1_;
	_tmp2_ = _data21_->location;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GearyNamedFlag* _tmp8_;
		GearyNamedFlag* _tmp9_;
		GearyNamedFlag* _tmp10_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data21_->location;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_email_flags_get_UNREAD ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		application_controller_mark_conversations (_tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_, FALSE, ____lambda188__gasync_ready_callback, block21_data_ref (_data21_));
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
	}
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->location);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
___lambda189_ (Block22Data* _data22_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data22_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data22_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda189__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda189_ (self, source_object, res);
	block22_data_unref (self);
}

static void
application_main_window_on_mark_as_unread (ApplicationMainWindow* self)
{
	Block22Data* _data22_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data22_->location = _tmp1_;
	_tmp2_ = _data22_->location;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GearyNamedFlag* _tmp8_;
		GearyNamedFlag* _tmp9_;
		GearyNamedFlag* _tmp10_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data22_->location;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_email_flags_get_UNREAD ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		application_controller_mark_conversations (_tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_, TRUE, ____lambda189__gasync_ready_callback, block22_data_ref (_data22_));
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
	}
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->location);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
___lambda190_ (Block23Data* _data23_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data23_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data23_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda190__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda190_ (self, source_object, res);
	block23_data_unref (self);
}

static void
application_main_window_on_mark_as_starred (ApplicationMainWindow* self)
{
	Block23Data* _data23_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data23_->location = _tmp1_;
	_tmp2_ = _data23_->location;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GearyNamedFlag* _tmp8_;
		GearyNamedFlag* _tmp9_;
		GearyNamedFlag* _tmp10_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data23_->location;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_email_flags_get_FLAGGED ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		application_controller_mark_conversations (_tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_, TRUE, ____lambda190__gasync_ready_callback, block23_data_ref (_data23_));
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
	}
	block23_data_unref (_data23_);
	_data23_ = NULL;
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->location);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
___lambda191_ (Block24Data* _data24_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data24_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data24_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda191__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda191_ (self, source_object, res);
	block24_data_unref (self);
}

static void
application_main_window_on_mark_as_unstarred (ApplicationMainWindow* self)
{
	Block24Data* _data24_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data24_->location = _tmp1_;
	_tmp2_ = _data24_->location;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GearyNamedFlag* _tmp8_;
		GearyNamedFlag* _tmp9_;
		GearyNamedFlag* _tmp10_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data24_->location;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_email_flags_get_FLAGGED ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		application_controller_mark_conversations (_tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_, FALSE, ____lambda191__gasync_ready_callback, block24_data_ref (_data24_));
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
	}
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->source);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
___lambda192_ (Block25Data* _data25_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data25_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_move_conversations_special_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data25_->source;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda192__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda192_ (self, source_object, res);
	block25_data_unref (self);
}

static void
application_main_window_on_mark_as_junk_toggle (ApplicationMainWindow* self)
{
	Block25Data* _data25_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data25_->source = _tmp1_;
	_tmp2_ = _data25_->source;
	if (_tmp2_ != NULL) {
		GearyFolderSpecialUse _tmp3_ = 0;
		GearyFolder* _tmp4_;
		GearyFolderSpecialUse _tmp5_;
		GearyFolderSpecialUse _tmp6_;
		GearyFolderSpecialUse destination = 0;
		ApplicationController* _tmp7_;
		GearyFolder* _tmp8_;
		ConversationListView* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		_tmp4_ = _data25_->source;
		_tmp5_ = geary_folder_get_used_as (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != GEARY_FOLDER_SPECIAL_USE_JUNK) {
			_tmp3_ = GEARY_FOLDER_SPECIAL_USE_JUNK;
		} else {
			_tmp3_ = GEARY_FOLDER_SPECIAL_USE_INBOX;
		}
		destination = _tmp3_;
		_tmp7_ = self->priv->controller;
		_tmp8_ = _data25_->source;
		_tmp9_ = self->priv->_conversation_list_view;
		_tmp10_ = conversation_list_view_copy_selected (_tmp9_);
		_tmp11_ = _tmp10_;
		application_controller_move_conversations_special (_tmp7_, _tmp8_, destination, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), ____lambda192__gasync_ready_callback, block25_data_ref (_data25_));
		_g_object_unref0 (_tmp11_);
	}
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->source);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
___lambda195_ (Block26Data* _data26_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data26_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_move_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolderSupportMove* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data26_->source;
		_tmp2_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_FOLDER, GearyFolder));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda195__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda195_ (self, source_object, res);
	block26_data_unref (self);
}

static void
application_main_window_on_move_conversation (ApplicationMainWindow* self,
                                              GearyFolder* destination)
{
	Block26Data* _data26_;
	GearyFolder* _tmp0_;
	GearyFolderSupportMove* _tmp1_;
	GearyFolderSupportMove* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, GEARY_TYPE_FOLDER));
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEARY_FOLDER_SUPPORT_TYPE_MOVE) ? ((GearyFolderSupportMove*) _tmp0_) : NULL);
	_data26_->source = _tmp1_;
	_tmp2_ = _data26_->source;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolderSupportMove* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data26_->source;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		application_controller_move_conversations (_tmp3_, _tmp4_, destination, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), ____lambda195__gasync_ready_callback, block26_data_ref (_data26_));
		_g_object_unref0 (_tmp7_);
	}
	block26_data_unref (_data26_);
	_data26_ = NULL;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->source);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static void
___lambda196_ (Block27Data* _data27_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data27_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_copy_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolderSupportCopy* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data27_->source;
		_tmp2_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_FOLDER, GearyFolder));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda196__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda196_ (self, source_object, res);
	block27_data_unref (self);
}

static void
application_main_window_on_copy_conversation (ApplicationMainWindow* self,
                                              GearyFolder* destination)
{
	Block27Data* _data27_;
	GearyFolder* _tmp0_;
	GearyFolderSupportCopy* _tmp1_;
	GearyFolderSupportCopy* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, GEARY_TYPE_FOLDER));
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEARY_FOLDER_SUPPORT_TYPE_COPY) ? ((GearyFolderSupportCopy*) _tmp0_) : NULL);
	_data27_->source = _tmp1_;
	_tmp2_ = _data27_->source;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolderSupportCopy* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data27_->source;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		application_controller_copy_conversations (_tmp3_, _tmp4_, destination, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), ____lambda196__gasync_ready_callback, block27_data_ref (_data27_));
		_g_object_unref0 (_tmp7_);
	}
	block27_data_unref (_data27_);
	_data27_ = NULL;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->source);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
___lambda185_ (Block28Data* _data28_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data28_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_move_conversations_special_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data28_->source;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda185__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda185_ (self, source_object, res);
	block28_data_unref (self);
}

static void
application_main_window_on_archive_conversation (ApplicationMainWindow* self)
{
	Block28Data* _data28_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data28_->source = _tmp1_;
	_tmp2_ = _data28_->source;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data28_->source;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		application_controller_move_conversations_special (_tmp3_, _tmp4_, GEARY_FOLDER_SPECIAL_USE_ARCHIVE, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), ____lambda185__gasync_ready_callback, block28_data_ref (_data28_));
		_g_object_unref0 (_tmp7_);
	}
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->source);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
___lambda186_ (Block29Data* _data29_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data29_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_move_conversations_special_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data29_->source;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda186__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda186_ (self, source_object, res);
	block29_data_unref (self);
}

static void
application_main_window_on_trash_conversation (ApplicationMainWindow* self)
{
	Block29Data* _data29_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data29_->source = _tmp1_;
	_tmp2_ = _data29_->source;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		ConversationListView* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data29_->source;
		_tmp5_ = self->priv->_conversation_list_view;
		_tmp6_ = conversation_list_view_copy_selected (_tmp5_);
		_tmp7_ = _tmp6_;
		application_controller_move_conversations_special (_tmp3_, _tmp4_, GEARY_FOLDER_SPECIAL_USE_TRASH, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), ____lambda186__gasync_ready_callback, block29_data_ref (_data29_));
		_g_object_unref0 (_tmp7_);
	}
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->target);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
___lambda187_ (Block30Data* _data30_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data30_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_delete_conversations_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolderSupportRemove* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data30_->target;
		_tmp2_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_FOLDER, GearyFolder));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda187__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda187_ (self, source_object, res);
	block30_data_unref (self);
}

static void
application_main_window_on_delete_conversation (ApplicationMainWindow* self)
{
	Block30Data* _data30_;
	GearyFolder* _tmp0_;
	GearyFolderSupportRemove* _tmp1_;
	GeeCollection* conversations = NULL;
	ConversationListView* _tmp2_;
	GeeSet* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyFolderSupportRemove* _tmp5_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEARY_FOLDER_SUPPORT_TYPE_REMOVE) ? ((GearyFolderSupportRemove*) _tmp0_) : NULL);
	_data30_->target = _tmp1_;
	_tmp2_ = self->priv->_conversation_list_view;
	_tmp3_ = conversation_list_view_copy_selected (_tmp2_);
	conversations = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp5_ = _data30_->target;
	if (_tmp5_ != NULL) {
		GeeCollection* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = conversations;
		_tmp7_ = gee_collection_get_size (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = application_main_window_prompt_delete_conversations (self, _tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ApplicationController* _tmp9_;
		GearyFolderSupportRemove* _tmp10_;
		GeeCollection* _tmp11_;
		_tmp9_ = self->priv->controller;
		_tmp10_ = _data30_->target;
		_tmp11_ = conversations;
		application_controller_delete_conversations (_tmp9_, _tmp10_, _tmp11_, ____lambda187__gasync_ready_callback, block30_data_ref (_data30_));
	}
	_g_object_unref0 (conversations);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}

static void
application_main_window_on_email_loaded (ApplicationMainWindow* self,
                                         ConversationListBox* view,
                                         GearyEmail* loaded)
{
	ApplicationController* _tmp0_;
	GearyAppConversation* _tmp1_;
	GearyAppConversation* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolder* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccountInformation* _tmp7_;
	GearyAccountInformation* _tmp8_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (view));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (loaded, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->controller;
	_tmp1_ = conversation_list_box_get_conversation (view);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_app_conversation_get_base_folder (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_folder_get_account (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_account_get_information (_tmp6_);
	_tmp8_ = _tmp7_;
	application_controller_email_loaded (_tmp0_, _tmp8_, loaded);
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->location);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
___lambda198_ (Block31Data* _data31_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data31_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_mark_messages_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data31_->location;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda198__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda198_ (self, source_object, res);
	block31_data_unref (self);
}

static void
application_main_window_on_email_mark (ApplicationMainWindow* self,
                                       ConversationListBox* view,
                                       GeeCollection* messages,
                                       GearyNamedFlag* to_add,
                                       GearyNamedFlag* to_remove)
{
	Block31Data* _data31_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (view));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (messages, GEE_TYPE_COLLECTION));
	g_return_if_fail ((to_add == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_add, GEARY_TYPE_NAMED_FLAG));
	g_return_if_fail ((to_remove == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_remove, GEARY_TYPE_NAMED_FLAG));
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data31_->location = _tmp1_;
	_tmp2_ = _data31_->location;
	if (_tmp2_ != NULL) {
		GearyEmailFlags* add_flags = NULL;
		GearyEmailFlags* remove_flags = NULL;
		ApplicationController* _tmp7_;
		GearyFolder* _tmp8_;
		GearyAppConversation* _tmp9_;
		GearyAppConversation* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GearyEmailFlags* _tmp13_;
		GearyEmailFlags* _tmp14_;
		add_flags = NULL;
		if (to_add != NULL) {
			GearyEmailFlags* _tmp3_;
			GearyEmailFlags* _tmp4_;
			_tmp3_ = geary_email_flags_new ();
			_g_object_unref0 (add_flags);
			add_flags = _tmp3_;
			_tmp4_ = add_flags;
			geary_named_flags_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), to_add);
		}
		remove_flags = NULL;
		if (to_remove != NULL) {
			GearyEmailFlags* _tmp5_;
			GearyEmailFlags* _tmp6_;
			_tmp5_ = geary_email_flags_new ();
			_g_object_unref0 (remove_flags);
			remove_flags = _tmp5_;
			_tmp6_ = remove_flags;
			geary_named_flags_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), to_remove);
		}
		_tmp7_ = self->priv->controller;
		_tmp8_ = _data31_->location;
		_tmp9_ = conversation_list_box_get_conversation (view);
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_collection_single (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = add_flags;
		_tmp14_ = remove_flags;
		application_controller_mark_messages (_tmp7_, _tmp8_, _tmp12_, messages, _tmp13_, _tmp14_, ____lambda198__gasync_ready_callback, block31_data_ref (_data31_));
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (remove_flags);
		_g_object_unref0 (add_flags);
	}
	block31_data_unref (_data31_);
	_data31_ = NULL;
}

static void
application_main_window_on_email_reply_to_sender (ApplicationMainWindow* self,
                                                  GearyEmail* target,
                                                  const gchar* quote)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->_selected_account;
	if (_tmp0_ != NULL) {
		GearyAccount* _tmp1_;
		_tmp1_ = self->priv->_selected_account;
		application_main_window_create_composer (self, _tmp1_, COMPOSER_WIDGET_CONTEXT_TYPE_REPLY_SENDER, target, quote, NULL, NULL);
	}
}

static void
application_main_window_on_email_reply_to_all (ApplicationMainWindow* self,
                                               GearyEmail* target,
                                               const gchar* quote)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->_selected_account;
	if (_tmp0_ != NULL) {
		GearyAccount* _tmp1_;
		_tmp1_ = self->priv->_selected_account;
		application_main_window_create_composer (self, _tmp1_, COMPOSER_WIDGET_CONTEXT_TYPE_REPLY_ALL, target, quote, NULL, NULL);
	}
}

static void
application_main_window_on_email_forward (ApplicationMainWindow* self,
                                          GearyEmail* target,
                                          const gchar* quote)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->_selected_account;
	if (_tmp0_ != NULL) {
		GearyAccount* _tmp1_;
		_tmp1_ = self->priv->_selected_account;
		application_main_window_create_composer (self, _tmp1_, COMPOSER_WIDGET_CONTEXT_TYPE_FORWARD, target, quote, NULL, NULL);
	}
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->source);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
___lambda199_ (Block32Data* _data32_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data32_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_move_messages_special_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolder* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data32_->source;
		_tmp2_ = geary_folder_get_account (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda199__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda199_ (self, source_object, res);
	block32_data_unref (self);
}

static void
application_main_window_on_email_trash (ApplicationMainWindow* self,
                                        ConversationListBox* view,
                                        GearyEmail* target)
{
	Block32Data* _data32_;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (view));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_EMAIL));
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data32_->source = _tmp1_;
	_tmp2_ = _data32_->source;
	if (_tmp2_ != NULL) {
		ApplicationController* _tmp3_;
		GearyFolder* _tmp4_;
		GearyAppConversation* _tmp5_;
		GearyAppConversation* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GearyEmailIdentifier* _tmp9_;
		GearyEmailIdentifier* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		_tmp3_ = self->priv->controller;
		_tmp4_ = _data32_->source;
		_tmp5_ = conversation_list_box_get_conversation (view);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_collection_single (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = geary_email_get_id (target);
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_);
		_tmp12_ = _tmp11_;
		application_controller_move_messages_special (_tmp3_, _tmp4_, GEARY_FOLDER_SPECIAL_USE_TRASH, _tmp8_, _tmp12_, ____lambda199__gasync_ready_callback, block32_data_ref (_data32_));
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp8_);
	}
	block32_data_unref (_data32_);
	_data32_ = NULL;
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ApplicationMainWindow* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->source);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
___lambda200_ (Block33Data* _data33_,
               GObject* obj,
               GAsyncResult* res)
{
	ApplicationMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data33_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		ApplicationController* _tmp0_;
		_tmp0_ = self->priv->controller;
		application_controller_delete_messages_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GearyFolderSupportRemove* _tmp1_;
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data33_->source;
		_tmp2_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_FOLDER, GearyFolder));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		application_main_window_handle_error (self, _tmp5_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda200__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda200_ (self, source_object, res);
	block33_data_unref (self);
}

static void
application_main_window_on_email_delete (ApplicationMainWindow* self,
                                         ConversationListBox* view,
                                         GearyEmail* target)
{
	Block33Data* _data33_;
	GearyFolder* _tmp0_;
	GearyFolderSupportRemove* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GearyFolderSupportRemove* _tmp3_;
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (view));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_EMAIL));
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = self->priv->_selected_folder;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEARY_FOLDER_SUPPORT_TYPE_REMOVE) ? ((GearyFolderSupportRemove*) _tmp0_) : NULL);
	_data33_->source = _tmp1_;
	_tmp3_ = _data33_->source;
	if (_tmp3_ != NULL) {
		_tmp2_ = application_main_window_prompt_delete_messages (self, 1);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ApplicationController* _tmp4_;
		GearyFolderSupportRemove* _tmp5_;
		GearyAppConversation* _tmp6_;
		GearyAppConversation* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GearyEmailIdentifier* _tmp10_;
		GearyEmailIdentifier* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		_tmp4_ = self->priv->controller;
		_tmp5_ = _data33_->source;
		_tmp6_ = conversation_list_box_get_conversation (view);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_collection_single (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_email_get_id (target);
		_tmp11_ = _tmp10_;
		_tmp12_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp11_);
		_tmp13_ = _tmp12_;
		application_controller_delete_messages (_tmp4_, _tmp5_, _tmp9_, _tmp13_, ____lambda200__gasync_ready_callback, block33_data_ref (_data33_));
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (_tmp9_);
	}
	block33_data_unref (_data33_);
	_data33_ = NULL;
}

static void
application_main_window_class_init (ApplicationMainWindowClass * klass,
                                    gpointer klass_data)
{
	GtkBindingSet* bindings = NULL;
	GTypeClass* _tmp0_;
	GObjectClass* _tmp1_;
	GtkBindingSet* _tmp2_;
	GtkBindingSet* _tmp3_;
	GtkBindingSet* _tmp4_;
	GtkBindingSet* _tmp5_;
	GtkBindingSet* _tmp6_;
	GtkBindingSet* _tmp7_;
	GtkBindingSet* _tmp8_;
	GtkBindingSet* _tmp9_;
	GtkBindingSet* _tmp10_;
	GtkBindingSet* _tmp11_;
	GtkBindingSet* _tmp12_;
	GtkBindingSet* _tmp13_;
	GtkBindingSet* _tmp14_;
	GtkBindingSet* _tmp15_;
	GtkBindingSet* _tmp16_;
	GtkBindingSet* _tmp17_;
	GtkBindingSet* _tmp18_;
	GtkBindingSet* _tmp19_;
	GtkBindingSet* _tmp20_;
	GtkBindingSet* _tmp21_;
	GtkBindingSet* _tmp22_;
	GtkBindingSet* _tmp23_;
	GtkBindingSet* _tmp24_;
	GtkBindingSet* _tmp25_;
	GtkBindingSet* _tmp26_;
	GtkBindingSet* _tmp27_;
	GtkBindingSet* _tmp28_;
	application_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationMainWindow_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) application_main_window_real_destroy;
	((GtkWidgetClass *) klass)->window_state_event = (gboolean (*) (GtkWidget*, GdkEventWindowState*)) application_main_window_real_window_state_event;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) application_main_window_real_size_allocate;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) application_main_window_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) application_main_window_real_key_release_event;
	((ApplicationMainWindowClass *) klass)->reply_conversation_sender = application_main_window_real_reply_conversation_sender;
	((ApplicationMainWindowClass *) klass)->reply_conversation_all = application_main_window_real_reply_conversation_all;
	((ApplicationMainWindowClass *) klass)->forward_conversation = application_main_window_real_forward_conversation;
	((ApplicationMainWindowClass *) klass)->mark_conversations_read = application_main_window_real_mark_conversations_read;
	((ApplicationMainWindowClass *) klass)->mark_conversations_starred = application_main_window_real_mark_conversations_starred;
	((ApplicationMainWindowClass *) klass)->show_copy_menu = application_main_window_real_show_copy_menu;
	((ApplicationMainWindowClass *) klass)->show_move_menu = application_main_window_real_show_move_menu;
	((ApplicationMainWindowClass *) klass)->archive_conversations = application_main_window_real_archive_conversations;
	((ApplicationMainWindowClass *) klass)->junk_conversations = application_main_window_real_junk_conversations;
	((ApplicationMainWindowClass *) klass)->trash_conversations = application_main_window_real_trash_conversations;
	((ApplicationMainWindowClass *) klass)->delete_conversations = application_main_window_real_delete_conversations;
	((ApplicationMainWindowClass *) klass)->search = application_main_window_real_search;
	((ApplicationMainWindowClass *) klass)->find = application_main_window_real_find;
	((ApplicationMainWindowClass *) klass)->navigate = application_main_window_real_navigate;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_main_window_finalize;
	/** Returns the window's associated client application instance. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", APPLICATION_TYPE_CLIENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Currently selected account, null if none selected */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY] = g_param_spec_object ("selected-account", "selected-account", "selected-account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Currently selected folder, null if none selected */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY] = g_param_spec_object ("selected-folder", "selected-folder", "selected-folder", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Conversations for the current folder, null if none selected */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY] = g_param_spec_object ("conversations", "conversations", "conversations", GEARY_APP_TYPE_CONVERSATION_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies if the conversation list is currently displayed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_IS_FOLDER_LIST_SHOWN_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_IS_FOLDER_LIST_SHOWN_PROPERTY] = g_param_spec_boolean ("is-folder-list-shown", "is-folder-list-shown", "is-folder-list-shown", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies if the conversation list is currently displayed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_IS_CONVERSATION_LIST_SHOWN_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_IS_CONVERSATION_LIST_SHOWN_PROPERTY] = g_param_spec_boolean ("is-conversation-list-shown", "is-conversation-list-shown", "is-conversation-list-shown", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies if the conversation viewer is currently displayed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_IS_CONVERSATION_VIEWER_SHOWN_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_IS_CONVERSATION_VIEWER_SHOWN_PROPERTY] = g_param_spec_boolean ("is-conversation-viewer-shown", "is-conversation-viewer-shown", "is-conversation-viewer-shown", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The attachment manager for this window. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY] = g_param_spec_object ("attachments", "attachments", "attachments", APPLICATION_TYPE_ATTACHMENT_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if conversations in the selected folder can be trashed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_SUPPORTS_TRASH_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_SUPPORTS_TRASH_PROPERTY] = g_param_spec_boolean ("selected-folder-supports-trash", "selected-folder-supports-trash", "selected-folder-supports-trash", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if a composer is currently open in this window. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_HAS_COMPOSER_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_HAS_COMPOSER_PROPERTY] = g_param_spec_boolean ("has-composer", "has-composer", "has-composer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies if the Shift key is currently being held. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY] = g_param_spec_boolean ("is-shift-down", "is-shift-down", "is-shift-down", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY] = g_param_spec_boolean ("window-maximized", "window-maximized", "window-maximized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY] = g_param_spec_object ("folder-list", "folder-list", "folder-list", FOLDER_LIST_TYPE_TREE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY] = g_param_spec_object ("search-bar", "search-bar", "search-bar", TYPE_SEARCH_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY] = g_param_spec_object ("conversation-list-view", "conversation-list-view", "conversation-list-view", TYPE_CONVERSATION_LIST_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY] = g_param_spec_object ("conversation-viewer", "conversation-viewer", "conversation-viewer", TYPE_CONVERSATION_VIEWER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY] = g_param_spec_object ("conversation-list-info-bars", "conversation-list-info-bars", "conversation-list-info-bars", COMPONENTS_TYPE_INFO_BAR_STACK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY, application_main_window_properties[APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY] = g_param_spec_object ("status-bar", "status-bar", "status-bar", TYPE_STATUS_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/application-main-window.ui");
	/** Fired when the user requests an account status be retried. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_RETRY_SERVICE_PROBLEM_SIGNAL] = g_signal_new ("retry-service-problem", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, GEARY_CLIENT_SERVICE_TYPE_STATUS);
	/** Keybinding signal for replying to sender for the current conversation. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_REPLY_CONVERSATION_SENDER_SIGNAL] = g_signal_new ("reply-conversation-sender", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, reply_conversation_sender), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for replying to all for the current conversation. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_REPLY_CONVERSATION_ALL_SIGNAL] = g_signal_new ("reply-conversation-all", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, reply_conversation_all), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for forwarding the current conversation. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_FORWARD_CONVERSATION_SIGNAL] = g_signal_new ("forward-conversation", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, forward_conversation), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for marking the current selection read. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_MARK_CONVERSATIONS_READ_SIGNAL] = g_signal_new ("mark-conversations-read", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, mark_conversations_read), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	/** Keybinding signal for marking the current selection starred. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_MARK_CONVERSATIONS_STARRED_SIGNAL] = g_signal_new ("mark-conversations-starred", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, mark_conversations_starred), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	/** Keybinding signal for showing the copy/label menu. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_SHOW_COPY_MENU_SIGNAL] = g_signal_new ("show-copy-menu", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, show_copy_menu), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for showing the move menu. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_SHOW_MOVE_MENU_SIGNAL] = g_signal_new ("show-move-menu", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, show_move_menu), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for archiving the current selection. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_ARCHIVE_CONVERSATIONS_SIGNAL] = g_signal_new ("archive-conversations", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, archive_conversations), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for junking the current selection. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_JUNK_CONVERSATIONS_SIGNAL] = g_signal_new ("junk-conversations", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, junk_conversations), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for trashing the current selection. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_TRASH_CONVERSATIONS_SIGNAL] = g_signal_new ("trash-conversations", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, trash_conversations), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for deleting the current selection. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_DELETE_CONVERSATIONS_SIGNAL] = g_signal_new ("delete-conversations", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, delete_conversations), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for activating conversation search. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_SEARCH_SIGNAL] = g_signal_new ("search", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, search), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for activating in-conversation find. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_FIND_SIGNAL] = g_signal_new ("find", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, find), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Keybinding signal for shifting the keyboard focus. */
	application_main_window_signals[APPLICATION_MAIN_WINDOW_NAVIGATE_SIGNAL] = g_signal_new ("navigate", APPLICATION_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ApplicationMainWindowClass, navigate), NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, gtk_scroll_type_get_type ());
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "application_headerbar", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, application_headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_list_headerbar", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_list_headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_headerbar", FALSE, G_STRUCT_OFFSET (ApplicationMainWindow, conversation_headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "outer_leaflet", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, outer_leaflet));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "inner_leaflet", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, inner_leaflet));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "folder_box", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, folder_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "folder_list_scrolled", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, folder_list_scrolled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_list_box", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_list_scrolled", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_list_scrolled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_list_actions_revealer", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_list_actions_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_list_actions", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_list_actions));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_viewer_box", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_viewer_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_viewer_actions_revealer", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, conversation_viewer_actions_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_bars", FALSE, ApplicationMainWindow_private_offset + G_STRUCT_OFFSET (ApplicationMainWindowPrivate, info_bars));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_map", G_CALLBACK(_application_main_window_on_map_gtk_widget_map));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_unmap", G_CALLBACK(_application_main_window_on_unmap_gtk_widget_unmap));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_focus_event", G_CALLBACK(_application_main_window_on_focus_event_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_event", G_CALLBACK(_application_main_window_on_delete_event_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_outer_leaflet_changed", G_CALLBACK(_application_main_window_on_outer_leaflet_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_inner_leaflet_changed", G_CALLBACK(_application_main_window_on_inner_leaflet_changed_g_object_notify));
	_tmp0_ = g_type_class_ref (APPLICATION_TYPE_MAIN_WINDOW);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class ((gpointer) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	bindings = _tmp3_;
	_tmp4_ = bindings;
	gtk_binding_entry_add_signal (_tmp4_, GDK_KEY_R, GDK_CONTROL_MASK, "reply-conversation-sender", (guint) 0, NULL);
	_tmp5_ = bindings;
	gtk_binding_entry_add_signal (_tmp5_, GDK_KEY_R, GDK_CONTROL_MASK | GDK_SHIFT_MASK, "reply-conversation-all", (guint) 0, NULL);
	_tmp6_ = bindings;
	gtk_binding_entry_add_signal (_tmp6_, GDK_KEY_L, GDK_CONTROL_MASK, "forward-conversation", (guint) 0, NULL);
	_tmp7_ = bindings;
	gtk_binding_entry_add_signal (_tmp7_, GDK_KEY_U, GDK_CONTROL_MASK, "mark-conversations-read", (guint) 1, G_TYPE_BOOLEAN, TRUE, NULL);
	_tmp8_ = bindings;
	gtk_binding_entry_add_signal (_tmp8_, GDK_KEY_U, GDK_CONTROL_MASK | GDK_SHIFT_MASK, "mark-conversations-read", (guint) 1, G_TYPE_BOOLEAN, FALSE, NULL);
	_tmp9_ = bindings;
	gtk_binding_entry_add_signal (_tmp9_, GDK_KEY_D, GDK_CONTROL_MASK, "mark-conversations-starred", (guint) 1, G_TYPE_BOOLEAN, TRUE, NULL);
	_tmp10_ = bindings;
	gtk_binding_entry_add_signal (_tmp10_, GDK_KEY_D, GDK_CONTROL_MASK | GDK_SHIFT_MASK, "mark-conversations-starred", (guint) 1, G_TYPE_BOOLEAN, FALSE, NULL);
	_tmp11_ = bindings;
	gtk_binding_entry_add_signal (_tmp11_, GDK_KEY_B, GDK_CONTROL_MASK, "show-copy-menu", (guint) 0, NULL);
	_tmp12_ = bindings;
	gtk_binding_entry_add_signal (_tmp12_, GDK_KEY_M, GDK_CONTROL_MASK, "show-move-menu", (guint) 0, NULL);
	_tmp13_ = bindings;
	gtk_binding_entry_add_signal (_tmp13_, GDK_KEY_K, GDK_CONTROL_MASK, "archive-conversations", (guint) 0, NULL);
	_tmp14_ = bindings;
	gtk_binding_entry_add_signal (_tmp14_, GDK_KEY_J, GDK_CONTROL_MASK, "junk-conversations", (guint) 0, NULL);
	_tmp15_ = bindings;
	gtk_binding_entry_add_signal (_tmp15_, GDK_KEY_BackSpace, 0, "trash-conversations", (guint) 0, NULL);
	_tmp16_ = bindings;
	gtk_binding_entry_add_signal (_tmp16_, GDK_KEY_Delete, 0, "trash-conversations", (guint) 0, NULL);
	_tmp17_ = bindings;
	gtk_binding_entry_add_signal (_tmp17_, GDK_KEY_KP_Delete, 0, "trash-conversations", (guint) 0, NULL);
	_tmp18_ = bindings;
	gtk_binding_entry_add_signal (_tmp18_, GDK_KEY_BackSpace, GDK_SHIFT_MASK, "delete-conversations", (guint) 0, NULL);
	_tmp19_ = bindings;
	gtk_binding_entry_add_signal (_tmp19_, GDK_KEY_Delete, GDK_SHIFT_MASK, "delete-conversations", (guint) 0, NULL);
	_tmp20_ = bindings;
	gtk_binding_entry_add_signal (_tmp20_, GDK_KEY_KP_Delete, GDK_SHIFT_MASK, "delete-conversations", (guint) 0, NULL);
	_tmp21_ = bindings;
	gtk_binding_entry_add_signal (_tmp21_, GDK_KEY_F, GDK_CONTROL_MASK, "find", (guint) 0, NULL);
	_tmp22_ = bindings;
	gtk_binding_entry_add_signal (_tmp22_, GDK_KEY_S, GDK_CONTROL_MASK, "search", (guint) 0, NULL);
	_tmp23_ = bindings;
	gtk_binding_entry_add_signal (_tmp23_, GDK_KEY_Left, GDK_MOD1_MASK, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_PAGE_LEFT, NULL);
	_tmp24_ = bindings;
	gtk_binding_entry_add_signal (_tmp24_, GDK_KEY_Back, 0, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_PAGE_LEFT, NULL);
	_tmp25_ = bindings;
	gtk_binding_entry_add_signal (_tmp25_, GDK_KEY_Right, GDK_MOD1_MASK, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_PAGE_RIGHT, NULL);
	_tmp26_ = bindings;
	gtk_binding_entry_add_signal (_tmp26_, GDK_KEY_Forward, 0, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_PAGE_RIGHT, NULL);
	_tmp27_ = bindings;
	gtk_binding_entry_add_signal (_tmp27_, GDK_KEY_comma, GDK_CONTROL_MASK, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_STEP_UP, NULL);
	_tmp28_ = bindings;
	gtk_binding_entry_add_signal (_tmp28_, GDK_KEY_period, GDK_CONTROL_MASK, "navigate", (guint) 1, gtk_scroll_type_get_type (), GTK_SCROLL_STEP_DOWN, NULL);
}

static void
application_main_window_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                             gpointer iface_data)
{
	application_main_window_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
application_main_window_instance_init (ApplicationMainWindow * self,
                                       gpointer klass)
{
	FolderListTree* _tmp0_;
	ComponentsInfoBarStack* _tmp1_;
	StatusBar* _tmp2_;
	MonitoredSpinner* _tmp3_;
	GeeHashSet* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GearyAggregateProgressMonitor* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	ComponentsConversationActions** _tmp9_;
	FolderPopover** _tmp10_;
	self->priv = application_main_window_get_instance_private (self);
	self->priv->_selected_account = NULL;
	self->priv->_selected_folder = NULL;
	self->priv->_conversations = NULL;
	self->priv->_is_shift_down = FALSE;
	_tmp0_ = folder_list_tree_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->_folder_list = _tmp0_;
	_tmp1_ = components_info_bar_stack_new (COMPONENTS_INFO_BAR_STACK_STACK_TYPE_PRIORITY_QUEUE);
	g_object_ref_sink (_tmp1_);
	self->priv->_conversation_list_info_bars = _tmp1_;
	_tmp2_ = status_bar_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->_status_bar = _tmp2_;
	_tmp3_ = monitored_spinner_new ();
	g_object_ref_sink (_tmp3_);
	self->priv->spinner = _tmp3_;
	_tmp4_ = gee_hash_set_new (APPLICATION_TYPE_ACCOUNT_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->accounts = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet);
	_tmp5_ = g_simple_action_group_new ();
	self->priv->edit_actions = _tmp5_;
	self->priv->previous_selection_was_interactive = FALSE;
	self->priv->previous_non_search_folder = NULL;
	_tmp6_ = geary_aggregate_progress_monitor_new ();
	self->priv->progress_monitor = _tmp6_;
	_tmp7_ = g_cancellable_new ();
	self->priv->action_update_cancellable = _tmp7_;
	_tmp8_ = g_cancellable_new ();
	self->priv->folder_open = _tmp8_;
	self->priv->update_ui_last = (gint64) 0;
	_tmp9_ = g_new0 (ComponentsConversationActions*, 0 + 1);
	self->priv->folder_conversation_actions = _tmp9_;
	self->priv->folder_conversation_actions_length1 = 0;
	self->priv->_folder_conversation_actions_size_ = self->priv->folder_conversation_actions_length1;
	_tmp10_ = g_new0 (FolderPopover*, 0 + 1);
	self->priv->folder_popovers = _tmp10_;
	self->priv->folder_popovers_length1 = 0;
	self->priv->_folder_popovers_size_ = self->priv->folder_popovers_length1;
	self->priv->service_problem_infobar = NULL;
	g_type_ensure (COMPONENTS_TYPE_APPLICATION_HEADER_BAR);
	g_type_ensure (COMPONENTS_TYPE_CONVERSATION_LIST_HEADER_BAR);
	g_type_ensure (COMPONENTS_TYPE_CONVERSATION_HEADER_BAR);
	g_type_ensure (COMPONENTS_TYPE_CONVERSATION_ACTIONS);
	g_type_ensure (COMPONENTS_TYPE_INFO_BAR_STACK);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
application_main_window_finalize (GObject * obj)
{
	ApplicationMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->_selected_account);
	_g_object_unref0 (self->priv->_selected_folder);
	_g_object_unref0 (self->priv->_conversations);
	_g_object_unref0 (self->priv->_attachments);
	_g_object_unref0 (self->priv->_folder_list);
	_g_object_unref0 (self->priv->_search_bar);
	_g_object_unref0 (self->priv->_conversation_list_view);
	_g_object_unref0 (self->priv->_conversation_viewer);
	_g_object_unref0 (self->priv->_conversation_list_info_bars);
	_g_object_unref0 (self->priv->_status_bar);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->edit_actions);
	_g_object_unref0 (self->priv->previous_non_search_folder);
	_g_object_unref0 (self->priv->progress_monitor);
	_g_object_unref0 (self->priv->action_update_cancellable);
	_g_object_unref0 (self->priv->folder_open);
	_g_object_unref0 (self->priv->update_ui_timeout);
	self->priv->folder_conversation_actions = (_vala_array_free (self->priv->folder_conversation_actions, self->priv->folder_conversation_actions_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->folder_popovers = (_vala_array_free (self->priv->folder_popovers, self->priv->folder_popovers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->offline_infobar);
	_g_object_unref0 (self->priv->cert_problem_infobar);
	_g_object_unref0 (self->priv->auth_problem_infobar);
	_g_object_unref0 (self->priv->service_problem_infobar);
	G_OBJECT_CLASS (application_main_window_parent_class)->finalize (obj);
}

static GType
application_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationMainWindow), 0, (GInstanceInitFunc) application_main_window_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) application_main_window_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_main_window_type_id;
	application_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "ApplicationMainWindow", &g_define_type_info, 0);
	g_type_add_interface_static (application_main_window_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ApplicationMainWindow_private_offset = g_type_add_instance_private (application_main_window_type_id, sizeof (ApplicationMainWindowPrivate));
	return application_main_window_type_id;
}

GType
application_main_window_get_type (void)
{
	static volatile gsize application_main_window_type_id__once = 0;
	if (g_once_init_enter (&application_main_window_type_id__once)) {
		GType application_main_window_type_id;
		application_main_window_type_id = application_main_window_get_type_once ();
		g_once_init_leave (&application_main_window_type_id__once, application_main_window_type_id);
	}
	return application_main_window_type_id__once;
}

static void
_vala_application_main_window_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ApplicationMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	switch (property_id) {
		case APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY:
		g_value_set_object (value, application_main_window_get_application (self));
		break;
		case APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY:
		g_value_set_object (value, application_main_window_get_selected_account (self));
		break;
		case APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY:
		g_value_set_object (value, application_main_window_get_selected_folder (self));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY:
		g_value_set_object (value, application_main_window_get_conversations (self));
		break;
		case APPLICATION_MAIN_WINDOW_IS_FOLDER_LIST_SHOWN_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_is_folder_list_shown (self));
		break;
		case APPLICATION_MAIN_WINDOW_IS_CONVERSATION_LIST_SHOWN_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_is_conversation_list_shown (self));
		break;
		case APPLICATION_MAIN_WINDOW_IS_CONVERSATION_VIEWER_SHOWN_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_is_conversation_viewer_shown (self));
		break;
		case APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY:
		g_value_set_object (value, application_main_window_get_attachments (self));
		break;
		case APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_SUPPORTS_TRASH_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_selected_folder_supports_trash (self));
		break;
		case APPLICATION_MAIN_WINDOW_HAS_COMPOSER_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_has_composer (self));
		break;
		case APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_is_shift_down (self));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, application_main_window_get_window_width (self));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, application_main_window_get_window_height (self));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY:
		g_value_set_boolean (value, application_main_window_get_window_maximized (self));
		break;
		case APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY:
		g_value_set_object (value, application_main_window_get_folder_list (self));
		break;
		case APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY:
		g_value_set_object (value, application_main_window_get_search_bar (self));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY:
		g_value_set_object (value, application_main_window_get_conversation_list_view (self));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY:
		g_value_set_object (value, application_main_window_get_conversation_viewer (self));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY:
		g_value_set_object (value, application_main_window_get_conversation_list_info_bars (self));
		break;
		case APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY:
		g_value_set_object (value, application_main_window_get_status_bar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_main_window_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ApplicationMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_MAIN_WINDOW, ApplicationMainWindow);
	switch (property_id) {
		case APPLICATION_MAIN_WINDOW_APPLICATION_PROPERTY:
		application_main_window_set_application (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_SELECTED_ACCOUNT_PROPERTY:
		application_main_window_set_selected_account (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_SELECTED_FOLDER_PROPERTY:
		application_main_window_set_selected_folder (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATIONS_PROPERTY:
		application_main_window_set_conversations (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_ATTACHMENTS_PROPERTY:
		application_main_window_set_attachments (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_IS_SHIFT_DOWN_PROPERTY:
		application_main_window_set_is_shift_down (self, g_value_get_boolean (value));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		application_main_window_set_window_width (self, g_value_get_int (value));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		application_main_window_set_window_height (self, g_value_get_int (value));
		break;
		case APPLICATION_MAIN_WINDOW_WINDOW_MAXIMIZED_PROPERTY:
		application_main_window_set_window_maximized (self, g_value_get_boolean (value));
		break;
		case APPLICATION_MAIN_WINDOW_FOLDER_LIST_PROPERTY:
		application_main_window_set_folder_list (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_SEARCH_BAR_PROPERTY:
		application_main_window_set_search_bar (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_VIEW_PROPERTY:
		application_main_window_set_conversation_list_view (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_VIEWER_PROPERTY:
		application_main_window_set_conversation_viewer (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_CONVERSATION_LIST_INFO_BARS_PROPERTY:
		application_main_window_set_conversation_list_info_bars (self, g_value_get_object (value));
		break;
		case APPLICATION_MAIN_WINDOW_STATUS_BAR_PROPERTY:
		application_main_window_set_status_bar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

