/* components-info-bar-stack.c generated by valac 0.56.3, the Vala compiler
 * generated from components-info-bar-stack.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "geary-engine.h"

enum  {
	COMPONENTS_INFO_BAR_STACK_0_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_HAS_CURRENT_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_CURRENT_INFO_BAR_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_NUM_PROPERTIES
};
static GParamSpec* components_info_bar_stack_properties[COMPONENTS_INFO_BAR_STACK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE (components_info_bar_stack_singleton_queue_get_type ())
#define COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue))
#define COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueueClass))
#define COMPONENTS_INFO_BAR_STACK_IS_SINGLETON_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE))
#define COMPONENTS_INFO_BAR_STACK_IS_SINGLETON_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE))
#define COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueueClass))

typedef struct _ComponentsInfoBarStackSingletonQueue ComponentsInfoBarStackSingletonQueue;
typedef struct _ComponentsInfoBarStackSingletonQueueClass ComponentsInfoBarStackSingletonQueueClass;
typedef struct _ComponentsInfoBarStackSingletonQueuePrivate ComponentsInfoBarStackSingletonQueuePrivate;
enum  {
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_0_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_READ_ONLY_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_SIZE_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_CAPACITY_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_IS_FULL_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_REMAINING_CAPACITY_PROPERTY,
	COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_NUM_PROPERTIES
};
static GParamSpec* components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_NUM_PROPERTIES];

struct _ComponentsInfoBarStackPrivate {
	ComponentsInfoBarStackStackType _algorithm;
	GeeQueue* available;
};

struct _ComponentsInfoBarStackSingletonQueue {
	GeeAbstractQueue parent_instance;
	ComponentsInfoBarStackSingletonQueuePrivate * priv;
};

struct _ComponentsInfoBarStackSingletonQueueClass {
	GeeAbstractQueueClass parent_class;
};

struct _ComponentsInfoBarStackSingletonQueuePrivate {
	ComponentsInfoBar* element;
};

static gint ComponentsInfoBarStack_private_offset;
static gpointer components_info_bar_stack_parent_class = NULL;
static gint ComponentsInfoBarStackSingletonQueue_private_offset;
static gpointer components_info_bar_stack_singleton_queue_parent_class = NULL;
static GearyBaseInterfaceIface * components_info_bar_stack_geary_base_interface_parent_iface = NULL;

static void components_info_bar_stack_update_queue_type (ComponentsInfoBarStack* self);
static void components_info_bar_stack_update (ComponentsInfoBarStack* self);
static void components_info_bar_stack_on_revealed (ComponentsInfoBarStack* self,
                                            GObject* target,
                                            GParamSpec* param);
static void _components_info_bar_stack_on_revealed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static ComponentsInfoBarStackSingletonQueue* components_info_bar_stack_singleton_queue_new (void);
static ComponentsInfoBarStackSingletonQueue* components_info_bar_stack_singleton_queue_construct (GType object_type);
static GType components_info_bar_stack_singleton_queue_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint _components_info_bar_stack_priority_queue_comparator_gcompare_data_func (gconstpointer a,
                                                                              gconstpointer b,
                                                                              gpointer self);
static gboolean components_info_bar_stack_singleton_queue_real_add (GeeAbstractCollection* base,
                                                             ComponentsInfoBar* to_add);
static void components_info_bar_stack_singleton_queue_real_clear (GeeAbstractCollection* base);
static gboolean components_info_bar_stack_singleton_queue_real_contains (GeeAbstractCollection* base,
                                                                  ComponentsInfoBar* other);
static GeeIterator* components_info_bar_stack_singleton_queue_real_iterator (GeeAbstractCollection* base);
static gboolean components_info_bar_stack_singleton_queue_real_remove (GeeAbstractCollection* base,
                                                                ComponentsInfoBar* to_remove);
static ComponentsInfoBar* components_info_bar_stack_singleton_queue_real_peek (GeeAbstractQueue* base);
static ComponentsInfoBar* components_info_bar_stack_singleton_queue_real_poll (GeeAbstractQueue* base);
static void components_info_bar_stack_singleton_queue_finalize (GObject * obj);
static GType components_info_bar_stack_singleton_queue_get_type_once (void);
static void _vala_components_info_bar_stack_singleton_queue_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static GObject * components_info_bar_stack_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void components_info_bar_stack_finalize (GObject * obj);
static GType components_info_bar_stack_get_type_once (void);
static void _vala_components_info_bar_stack_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_components_info_bar_stack_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
components_info_bar_stack_get_instance_private (ComponentsInfoBarStack* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInfoBarStack_private_offset);
}

/** Supported stack algorithms. */
static GType
components_info_bar_stack_stack_type_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPONENTS_INFO_BAR_STACK_STACK_TYPE_SINGLE, "COMPONENTS_INFO_BAR_STACK_STACK_TYPE_SINGLE", "single"}, {COMPONENTS_INFO_BAR_STACK_STACK_TYPE_PRIORITY_QUEUE, "COMPONENTS_INFO_BAR_STACK_STACK_TYPE_PRIORITY_QUEUE", "priority-queue"}, {0, NULL, NULL}};
	GType components_info_bar_stack_stack_type_type_id;
	components_info_bar_stack_stack_type_type_id = g_enum_register_static ("ComponentsInfoBarStackStackType", values);
	return components_info_bar_stack_stack_type_type_id;
}

GType
components_info_bar_stack_stack_type_get_type (void)
{
	static volatile gsize components_info_bar_stack_stack_type_type_id__once = 0;
	if (g_once_init_enter (&components_info_bar_stack_stack_type_type_id__once)) {
		GType components_info_bar_stack_stack_type_type_id;
		components_info_bar_stack_stack_type_type_id = components_info_bar_stack_stack_type_get_type_once ();
		g_once_init_leave (&components_info_bar_stack_stack_type_type_id__once, components_info_bar_stack_stack_type_type_id);
	}
	return components_info_bar_stack_stack_type_type_id__once;
}

/**
     * Comparator used for the priority queue algorithm.
     *
     * When {@link algorithm} is set to {@link
     * StackType.PRIORITY_QUEUE}, this comparator is used for the
     * priority queue to compare info bars. It uses an integer value
     * stored via GLib.Object.set_data with {@link PRIORITY_QUEUE_KEY}
     * as a key to determine the relative priority between two info
     * bars.
     *
     * @see algorithm
     * @see StackType.PRIORITY_QUEUE
     */
gint
components_info_bar_stack_priority_queue_comparator (ComponentsInfoBar* a,
                                                     ComponentsInfoBar* b)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gint result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (a), 0);
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (b), 0);
	_tmp0_ = g_object_get_data (G_TYPE_CHECK_INSTANCE_CAST (b, G_TYPE_OBJECT, GObject), COMPONENTS_INFO_BAR_STACK_PRIORITY_QUEUE_KEY);
	_tmp1_ = g_object_get_data (G_TYPE_CHECK_INSTANCE_CAST (a, G_TYPE_OBJECT, GObject), COMPONENTS_INFO_BAR_STACK_PRIORITY_QUEUE_KEY);
	result = ((gint) ((gintptr) _tmp0_)) - ((gint) ((gintptr) _tmp1_));
	return result;
}

ComponentsInfoBarStackStackType
components_info_bar_stack_get_algorithm (ComponentsInfoBarStack* self)
{
	ComponentsInfoBarStackStackType result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self), 0);
	result = self->priv->_algorithm;
	return result;
}

void
components_info_bar_stack_set_algorithm (ComponentsInfoBarStack* self,
                                         ComponentsInfoBarStackStackType value)
{
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	self->priv->_algorithm = value;
	components_info_bar_stack_update_queue_type (self);
	g_object_notify_by_pspec ((GObject *) self, components_info_bar_stack_properties[COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY]);
}

gboolean
components_info_bar_stack_get_has_current (ComponentsInfoBarStack* self)
{
	gboolean result;
	ComponentsInfoBar* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self), FALSE);
	_tmp0_ = components_info_bar_stack_get_current_info_bar (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != NULL;
	return result;
}

ComponentsInfoBar*
components_info_bar_stack_get_current_info_bar (ComponentsInfoBarStack* self)
{
	ComponentsInfoBar* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self), NULL);
	_tmp0_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
	result = COMPONENTS_IS_INFO_BAR (_tmp0_) ? ((ComponentsInfoBar*) _tmp0_) : NULL;
	return result;
}

ComponentsInfoBarStack*
components_info_bar_stack_construct (GType object_type,
                                     ComponentsInfoBarStackStackType algorithm)
{
	ComponentsInfoBarStack * self = NULL;
	self = (ComponentsInfoBarStack*) g_object_new (object_type, "algorithm", algorithm, NULL);
	return self;
}

ComponentsInfoBarStack*
components_info_bar_stack_new (ComponentsInfoBarStackStackType algorithm)
{
	return components_info_bar_stack_construct (COMPONENTS_TYPE_INFO_BAR_STACK, algorithm);
}

/**
     * Adds an info bar to the stack.
     *
     * If this is the first info bar added, the stack will show itself
     * and reveal the info bar. Otherwise, depending on the type of
     * stack constructed, the info bar may or may not be revealed
     * immediately.
     */
void
components_info_bar_stack_add (ComponentsInfoBarStack* self,
                               ComponentsInfoBar* to_add)
{
	GeeQueue* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (to_add));
	_tmp0_ = self->priv->available;
	if (gee_queue_offer (_tmp0_, to_add)) {
		components_info_bar_stack_update (self);
	}
}

/**
     * Removes an info bar to the stack.
     *
     * If the info bar is currently visible, it will be hidden and
     * replaced with the next info bar added. If the only info bar
     * present is removed, the stack also hides itself.
     */
void
components_info_bar_stack_remove (ComponentsInfoBarStack* self,
                                  ComponentsInfoBar* to_remove)
{
	GeeQueue* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (to_remove));
	_tmp0_ = self->priv->available;
	if (gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), to_remove)) {
		components_info_bar_stack_update (self);
	}
}

/**
     * Removes all info bars from the stack, hiding the stack.
     */
void
components_info_bar_stack_remove_all (ComponentsInfoBarStack* self)
{
	GeeQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	_tmp0_ = self->priv->available;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GeeQueue* _tmp3_;
		_tmp3_ = self->priv->available;
		gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		components_info_bar_stack_update (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_components_info_bar_stack_on_revealed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	components_info_bar_stack_on_revealed ((ComponentsInfoBarStack*) self, _sender, pspec);
}

static void
components_info_bar_stack_update (ComponentsInfoBarStack* self)
{
	ComponentsInfoBar* current = NULL;
	ComponentsInfoBar* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	ComponentsInfoBar* _tmp2_;
	ComponentsInfoBar* next = NULL;
	GeeQueue* _tmp3_;
	gpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	ComponentsInfoBar* _tmp6_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	_tmp0_ = components_info_bar_stack_get_current_info_bar (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current = _tmp2_;
	_tmp3_ = self->priv->available;
	_tmp4_ = gee_queue_peek (_tmp3_);
	next = (ComponentsInfoBar*) _tmp4_;
	_tmp6_ = current;
	if (_tmp6_ == NULL) {
		ComponentsInfoBar* _tmp7_;
		_tmp7_ = next;
		_tmp5_ = _tmp7_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ComponentsInfoBar* _tmp8_;
		ComponentsInfoBar* _tmp9_;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp8_ = next;
		GTK_CONTAINER_CLASS (components_info_bar_stack_parent_class)->add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_frame_get_type (), GtkFrame), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = next;
		components_info_bar_set_revealed (_tmp9_, TRUE);
	} else {
		gboolean _tmp10_ = FALSE;
		ComponentsInfoBar* _tmp11_;
		_tmp11_ = current;
		if (_tmp11_ != NULL) {
			ComponentsInfoBar* _tmp12_;
			ComponentsInfoBar* _tmp13_;
			_tmp12_ = next;
			_tmp13_ = current;
			_tmp10_ = _tmp12_ != _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ComponentsInfoBar* _tmp14_;
			ComponentsInfoBar* _tmp15_;
			_tmp14_ = current;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, G_TYPE_OBJECT, GObject), "notify::revealed", (GCallback) _components_info_bar_stack_on_revealed_g_object_notify, self, 0);
			_tmp15_ = current;
			components_info_bar_set_revealed (_tmp15_, FALSE);
		} else {
			gboolean _tmp16_ = FALSE;
			ComponentsInfoBar* _tmp17_;
			_tmp17_ = current;
			if (_tmp17_ == NULL) {
				ComponentsInfoBar* _tmp18_;
				_tmp18_ = next;
				_tmp16_ = _tmp18_ == NULL;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
			}
		}
	}
	_g_object_unref0 (next);
	_g_object_unref0 (current);
}

static gint
_components_info_bar_stack_priority_queue_comparator_gcompare_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self)
{
	gint result;
	result = components_info_bar_stack_priority_queue_comparator ((ComponentsInfoBar*) a, (ComponentsInfoBar*) b);
	return result;
}

static void
components_info_bar_stack_update_queue_type (ComponentsInfoBarStack* self)
{
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	switch (self->priv->_algorithm) {
		case COMPONENTS_INFO_BAR_STACK_STACK_TYPE_SINGLE:
		{
			ComponentsInfoBarStackSingletonQueue* _tmp0_;
			_tmp0_ = components_info_bar_stack_singleton_queue_new ();
			_g_object_unref0 (self->priv->available);
			self->priv->available = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_QUEUE, GeeQueue);
			break;
		}
		case COMPONENTS_INFO_BAR_STACK_STACK_TYPE_PRIORITY_QUEUE:
		{
			GeePriorityQueue* _tmp1_;
			_tmp1_ = gee_priority_queue_new (COMPONENTS_TYPE_INFO_BAR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _components_info_bar_stack_priority_queue_comparator_gcompare_data_func, NULL, NULL);
			_g_object_unref0 (self->priv->available);
			self->priv->available = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_QUEUE, GeeQueue);
			break;
		}
		default:
		break;
	}
	components_info_bar_stack_update (self);
}

static void
components_info_bar_stack_on_revealed (ComponentsInfoBarStack* self,
                                       GObject* target,
                                       GParamSpec* param)
{
	ComponentsInfoBar* info_bar = NULL;
	ComponentsInfoBar* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR_STACK (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = _g_object_ref0 (COMPONENTS_IS_INFO_BAR (target) ? ((ComponentsInfoBar*) target) : NULL);
	info_bar = _tmp0_;
	g_signal_parse_name ("notify::revealed", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched (target, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _components_info_bar_stack_on_revealed_g_object_notify, self);
	GTK_CONTAINER_CLASS (components_info_bar_stack_parent_class)->remove (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_frame_get_type (), GtkFrame), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (info_bar, gtk_widget_get_type (), GtkWidget));
	components_info_bar_stack_remove (self, info_bar);
	_g_object_unref0 (info_bar);
}

static inline gpointer
components_info_bar_stack_singleton_queue_get_instance_private (ComponentsInfoBarStackSingletonQueue* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInfoBarStackSingletonQueue_private_offset);
}

static gboolean
components_info_bar_stack_singleton_queue_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	ComponentsInfoBarStackSingletonQueue* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	result = FALSE;
	return result;
}

static gint
components_info_bar_stack_singleton_queue_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	ComponentsInfoBarStackSingletonQueue* self;
	gint _tmp0_ = 0;
	ComponentsInfoBar* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp1_ = self->priv->element;
	if (_tmp1_ == NULL) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}

static gint
components_info_bar_stack_singleton_queue_real_get_capacity (GeeAbstractQueue* base)
{
	gint result;
	ComponentsInfoBarStackSingletonQueue* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	result = 1;
	return result;
}

static gboolean
components_info_bar_stack_singleton_queue_real_get_is_full (GeeAbstractQueue* base)
{
	gboolean result;
	ComponentsInfoBarStackSingletonQueue* self;
	ComponentsInfoBar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp0_ = self->priv->element;
	result = _tmp0_ != NULL;
	return result;
}

static gint
components_info_bar_stack_singleton_queue_real_get_remaining_capacity (GeeAbstractQueue* base)
{
	gint result;
	ComponentsInfoBarStackSingletonQueue* self;
	gint _tmp0_ = 0;
	ComponentsInfoBar* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp1_ = self->priv->element;
	if (_tmp1_ != NULL) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}

static gboolean
components_info_bar_stack_singleton_queue_real_add (GeeAbstractCollection* base,
                                                    ComponentsInfoBar* to_add)
{
	ComponentsInfoBarStackSingletonQueue * self;
	gboolean added = FALSE;
	ComponentsInfoBar* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (to_add), FALSE);
	added = FALSE;
	_tmp0_ = self->priv->element;
	if (_tmp0_ != to_add) {
		ComponentsInfoBar* _tmp1_;
		_tmp1_ = _g_object_ref0 (to_add);
		_g_object_unref0 (self->priv->element);
		self->priv->element = _tmp1_;
		added = TRUE;
	}
	result = added;
	return result;
}

static void
components_info_bar_stack_singleton_queue_real_clear (GeeAbstractCollection* base)
{
	ComponentsInfoBarStackSingletonQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_g_object_unref0 (self->priv->element);
	self->priv->element = NULL;
}

static gboolean
components_info_bar_stack_singleton_queue_real_contains (GeeAbstractCollection* base,
                                                         ComponentsInfoBar* other)
{
	ComponentsInfoBarStackSingletonQueue * self;
	ComponentsInfoBar* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (other), FALSE);
	_tmp0_ = self->priv->element;
	result = _tmp0_ == other;
	return result;
}

static GeeIterator*
components_info_bar_stack_singleton_queue_real_iterator (GeeAbstractCollection* base)
{
	ComponentsInfoBarStackSingletonQueue * self;
	GeeIterator* _tmp0_ = NULL;
	ComponentsInfoBar* _tmp1_;
	GeeIterator* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp1_ = self->priv->element;
	if (_tmp1_ == NULL) {
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp2_ = gee_collection_empty (COMPONENTS_TYPE_INFO_BAR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
	} else {
		ComponentsInfoBar* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp5_ = self->priv->element;
		_tmp6_ = geary_collection_single (COMPONENTS_TYPE_INFO_BAR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
components_info_bar_stack_singleton_queue_real_remove (GeeAbstractCollection* base,
                                                       ComponentsInfoBar* to_remove)
{
	ComponentsInfoBarStackSingletonQueue * self;
	gboolean removed = FALSE;
	ComponentsInfoBar* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (to_remove), FALSE);
	removed = FALSE;
	_tmp0_ = self->priv->element;
	if (_tmp0_ == to_remove) {
		_g_object_unref0 (self->priv->element);
		self->priv->element = NULL;
		removed = TRUE;
	}
	result = removed;
	return result;
}

static ComponentsInfoBar*
components_info_bar_stack_singleton_queue_real_peek (GeeAbstractQueue* base)
{
	ComponentsInfoBarStackSingletonQueue * self;
	ComponentsInfoBar* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	ComponentsInfoBar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp0_ = self->priv->element;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static ComponentsInfoBar*
components_info_bar_stack_singleton_queue_real_poll (GeeAbstractQueue* base)
{
	ComponentsInfoBarStackSingletonQueue * self;
	ComponentsInfoBar* element = NULL;
	ComponentsInfoBar* _tmp0_;
	ComponentsInfoBar* _tmp1_;
	ComponentsInfoBar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_tmp0_ = self->priv->element;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	element = _tmp1_;
	_g_object_unref0 (self->priv->element);
	self->priv->element = NULL;
	result = element;
	return result;
}

static ComponentsInfoBarStackSingletonQueue*
components_info_bar_stack_singleton_queue_construct (GType object_type)
{
	ComponentsInfoBarStackSingletonQueue * self = NULL;
	self = (ComponentsInfoBarStackSingletonQueue*) gee_abstract_queue_construct (object_type, COMPONENTS_TYPE_INFO_BAR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	return self;
}

static ComponentsInfoBarStackSingletonQueue*
components_info_bar_stack_singleton_queue_new (void)
{
	return components_info_bar_stack_singleton_queue_construct (COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE);
}

static void
components_info_bar_stack_singleton_queue_class_init (ComponentsInfoBarStackSingletonQueueClass * klass,
                                                      gpointer klass_data)
{
	components_info_bar_stack_singleton_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInfoBarStackSingletonQueue_private_offset);
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) components_info_bar_stack_singleton_queue_real_add;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) components_info_bar_stack_singleton_queue_real_clear;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) components_info_bar_stack_singleton_queue_real_contains;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) components_info_bar_stack_singleton_queue_real_iterator;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) components_info_bar_stack_singleton_queue_real_remove;
	((GeeAbstractQueueClass *) klass)->peek = (gpointer (*) (GeeAbstractQueue*)) components_info_bar_stack_singleton_queue_real_peek;
	((GeeAbstractQueueClass *) klass)->poll = (gpointer (*) (GeeAbstractQueue*)) components_info_bar_stack_singleton_queue_real_poll;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = components_info_bar_stack_singleton_queue_real_get_read_only;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = components_info_bar_stack_singleton_queue_real_get_size;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = components_info_bar_stack_singleton_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = components_info_bar_stack_singleton_queue_real_get_is_full;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = components_info_bar_stack_singleton_queue_real_get_remaining_capacity;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_info_bar_stack_singleton_queue_get_property;
	G_OBJECT_CLASS (klass)->finalize = components_info_bar_stack_singleton_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_READ_ONLY_PROPERTY, components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_SIZE_PROPERTY, components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_CAPACITY_PROPERTY, components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_CAPACITY_PROPERTY] = g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_IS_FULL_PROPERTY, components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_IS_FULL_PROPERTY] = g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_REMAINING_CAPACITY_PROPERTY, components_info_bar_stack_singleton_queue_properties[COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_REMAINING_CAPACITY_PROPERTY] = g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
components_info_bar_stack_singleton_queue_instance_init (ComponentsInfoBarStackSingletonQueue * self,
                                                         gpointer klass)
{
	self->priv = components_info_bar_stack_singleton_queue_get_instance_private (self);
	self->priv->element = NULL;
}

static void
components_info_bar_stack_singleton_queue_finalize (GObject * obj)
{
	ComponentsInfoBarStackSingletonQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	_g_object_unref0 (self->priv->element);
	G_OBJECT_CLASS (components_info_bar_stack_singleton_queue_parent_class)->finalize (obj);
}

static GType
components_info_bar_stack_singleton_queue_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInfoBarStackSingletonQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_info_bar_stack_singleton_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInfoBarStackSingletonQueue), 0, (GInstanceInitFunc) components_info_bar_stack_singleton_queue_instance_init, NULL };
	GType components_info_bar_stack_singleton_queue_type_id;
	components_info_bar_stack_singleton_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "ComponentsInfoBarStackSingletonQueue", &g_define_type_info, 0);
	ComponentsInfoBarStackSingletonQueue_private_offset = g_type_add_instance_private (components_info_bar_stack_singleton_queue_type_id, sizeof (ComponentsInfoBarStackSingletonQueuePrivate));
	return components_info_bar_stack_singleton_queue_type_id;
}

static GType
components_info_bar_stack_singleton_queue_get_type (void)
{
	static volatile gsize components_info_bar_stack_singleton_queue_type_id__once = 0;
	if (g_once_init_enter (&components_info_bar_stack_singleton_queue_type_id__once)) {
		GType components_info_bar_stack_singleton_queue_type_id;
		components_info_bar_stack_singleton_queue_type_id = components_info_bar_stack_singleton_queue_get_type_once ();
		g_once_init_leave (&components_info_bar_stack_singleton_queue_type_id__once, components_info_bar_stack_singleton_queue_type_id);
	}
	return components_info_bar_stack_singleton_queue_type_id__once;
}

static void
_vala_components_info_bar_stack_singleton_queue_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	ComponentsInfoBarStackSingletonQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_INFO_BAR_STACK_TYPE_SINGLETON_QUEUE, ComponentsInfoBarStackSingletonQueue);
	switch (property_id) {
		case COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
		break;
		case COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
		break;
		case COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_capacity (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue)));
		break;
		case COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_IS_FULL_PROPERTY:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue)));
		break;
		case COMPONENTS_INFO_BAR_STACK_SINGLETON_QUEUE_REMAINING_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
components_info_bar_stack_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ComponentsInfoBarStack * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (components_info_bar_stack_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INFO_BAR_STACK, ComponentsInfoBarStack);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "geary-info-bar-stack");
	components_info_bar_stack_update_queue_type (self);
	return obj;
}

static void
components_info_bar_stack_class_init (ComponentsInfoBarStackClass * klass,
                                      gpointer klass_data)
{
	components_info_bar_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInfoBarStack_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_components_info_bar_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_info_bar_stack_set_property;
	G_OBJECT_CLASS (klass)->constructor = components_info_bar_stack_constructor;
	G_OBJECT_CLASS (klass)->finalize = components_info_bar_stack_finalize;
	/** The algorithm used when showing info bars. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY, components_info_bar_stack_properties[COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY] = g_param_spec_enum ("algorithm", "algorithm", "algorithm", COMPONENTS_INFO_BAR_STACK_TYPE_STACK_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** Determines if an info bar is currently being shown. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_HAS_CURRENT_PROPERTY, components_info_bar_stack_properties[COMPONENTS_INFO_BAR_STACK_HAS_CURRENT_PROPERTY] = g_param_spec_boolean ("has-current", "has-current", "has-current", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the currently displayed info bar, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STACK_CURRENT_INFO_BAR_PROPERTY, components_info_bar_stack_properties[COMPONENTS_INFO_BAR_STACK_CURRENT_INFO_BAR_PROPERTY] = g_param_spec_object ("current-info-bar", "current-info-bar", "current-info-bar", COMPONENTS_TYPE_INFO_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
components_info_bar_stack_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                               gpointer iface_data)
{
	components_info_bar_stack_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
components_info_bar_stack_instance_init (ComponentsInfoBarStack * self,
                                         gpointer klass)
{
	self->priv = components_info_bar_stack_get_instance_private (self);
	self->priv->_algorithm = COMPONENTS_INFO_BAR_STACK_STACK_TYPE_SINGLE;
}

static void
components_info_bar_stack_finalize (GObject * obj)
{
	ComponentsInfoBarStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INFO_BAR_STACK, ComponentsInfoBarStack);
	_g_object_unref0 (self->priv->available);
	G_OBJECT_CLASS (components_info_bar_stack_parent_class)->finalize (obj);
}

/**
 * A stack-like widget for displaying Components.InfoBar widgets.
 *
 * The stack ensures only one info bar is shown at once, shows a frame
 * around the info bar, and manages revealing and hiding itself and
 * the info bars as needed.
 */
static GType
components_info_bar_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInfoBarStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_info_bar_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInfoBarStack), 0, (GInstanceInitFunc) components_info_bar_stack_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) components_info_bar_stack_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType components_info_bar_stack_type_id;
	components_info_bar_stack_type_id = g_type_register_static (gtk_frame_get_type (), "ComponentsInfoBarStack", &g_define_type_info, 0);
	g_type_add_interface_static (components_info_bar_stack_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ComponentsInfoBarStack_private_offset = g_type_add_instance_private (components_info_bar_stack_type_id, sizeof (ComponentsInfoBarStackPrivate));
	return components_info_bar_stack_type_id;
}

GType
components_info_bar_stack_get_type (void)
{
	static volatile gsize components_info_bar_stack_type_id__once = 0;
	if (g_once_init_enter (&components_info_bar_stack_type_id__once)) {
		GType components_info_bar_stack_type_id;
		components_info_bar_stack_type_id = components_info_bar_stack_get_type_once ();
		g_once_init_leave (&components_info_bar_stack_type_id__once, components_info_bar_stack_type_id);
	}
	return components_info_bar_stack_type_id__once;
}

static void
_vala_components_info_bar_stack_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ComponentsInfoBarStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INFO_BAR_STACK, ComponentsInfoBarStack);
	switch (property_id) {
		case COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY:
		g_value_set_enum (value, components_info_bar_stack_get_algorithm (self));
		break;
		case COMPONENTS_INFO_BAR_STACK_HAS_CURRENT_PROPERTY:
		g_value_set_boolean (value, components_info_bar_stack_get_has_current (self));
		break;
		case COMPONENTS_INFO_BAR_STACK_CURRENT_INFO_BAR_PROPERTY:
		g_value_set_object (value, components_info_bar_stack_get_current_info_bar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_info_bar_stack_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ComponentsInfoBarStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INFO_BAR_STACK, ComponentsInfoBarStack);
	switch (property_id) {
		case COMPONENTS_INFO_BAR_STACK_ALGORITHM_PROPERTY:
		components_info_bar_stack_set_algorithm (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

