/* composer-editor.c generated by valac 0.56.3, the Vala compiler
 * generated from composer-editor.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2017-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "geary-client-43.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <webkit2/webkit2.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define COMPOSER_EDITOR_ACTION_BOLD "bold"
#define COMPOSER_EDITOR_ACTION_COLOR "color"
#define COMPOSER_EDITOR_ACTION_COPY_LINK "copy-link"
#define COMPOSER_EDITOR_ACTION_CUT "cut"
#define COMPOSER_EDITOR_ACTION_FONT_FAMILY "font-family"
#define COMPOSER_EDITOR_ACTION_FONT_SIZE "font-size"
#define COMPOSER_EDITOR_ACTION_INDENT "indent"
#define COMPOSER_EDITOR_ACTION_INSERT_IMAGE "insert-image"
#define COMPOSER_EDITOR_ACTION_INSERT_LINK "insert-link"
#define COMPOSER_EDITOR_ACTION_ITALIC "italic"
#define COMPOSER_EDITOR_ACTION_JUSTIFY "justify"
#define COMPOSER_EDITOR_ACTION_OLIST "olist"
#define COMPOSER_EDITOR_ACTION_OPEN_INSPECTOR "open_inspector"
#define COMPOSER_EDITOR_ACTION_OUTDENT "outdent"
#define COMPOSER_EDITOR_ACTION_PASTE "paste"
#define COMPOSER_EDITOR_ACTION_PASTE_WITHOUT_FORMATTING "paste-without-formatting"
#define COMPOSER_EDITOR_ACTION_REMOVE_FORMAT "remove-format"
#define COMPOSER_EDITOR_ACTION_SELECT_ALL "select-all"
#define COMPOSER_EDITOR_ACTION_SELECT_DICTIONARY "select-dictionary"
#define COMPOSER_EDITOR_ACTION_SHOW_FORMATTING "show-formatting"
#define COMPOSER_EDITOR_ACTION_STRIKETHROUGH "strikethrough"
#define COMPOSER_EDITOR_ACTION_TEXT_FORMAT "text-format"
#define COMPOSER_EDITOR_ACTION_ULIST "ulist"
#define COMPOSER_EDITOR_ACTION_UNDERLINE "underline"

enum  {
	COMPOSER_EDITOR_0_PROPERTY,
	COMPOSER_EDITOR_BODY_PROPERTY,
	COMPOSER_EDITOR_NUM_PROPERTIES
};
static GParamSpec* composer_editor_properties[COMPOSER_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block63Data Block63Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _spell_check_popover_unref0(var) ((var == NULL) ? NULL : (var = (spell_check_popover_unref (var), NULL)))
typedef struct _Block64Data Block64Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ComposerEditorNewLinkPopoverData ComposerEditorNewLinkPopoverData;
typedef struct _ComposerEditorUpdateColorIconData ComposerEditorUpdateColorIconData;
typedef struct _Block65Data Block65Data;
typedef struct _Block66Data Block66Data;
typedef void (*UtilGtkMenuForeachFunc) (const gchar* label, const gchar* action_name, GVariant* target, GMenu* section, gpointer user_data);
typedef struct _Block67Data Block67Data;
typedef struct _Block68Data Block68Data;
enum  {
	COMPOSER_EDITOR_INSERT_IMAGE_SIGNAL,
	COMPOSER_EDITOR_NUM_SIGNALS
};
static guint composer_editor_signals[COMPOSER_EDITOR_NUM_SIGNALS] = {0};

struct _ComposerEditorPrivate {
	ComposerWebView* _body;
	ApplicationConfiguration* config;
	gchar* pointer_url;
	gchar* cursor_url;
	GearyTimeoutManager* show_background_work_timeout;
	GearyTimeoutManager* background_work_pulse;
	GMenu* context_menu_model;
	GMenu* context_menu_rich_text;
	GMenu* context_menu_plain_text;
	GMenu* context_menu_webkit_spelling;
	GMenu* context_menu_webkit_text_entry;
	GMenu* context_menu_inspector;
	GtkGrid* body_container;
	GtkLabel* message_overlay_label;
	GtkBox* action_bar_box;
	GtkButton* insert_link_button;
	GtkMenuButton* select_dictionary_button;
	GtkLabel* info_label;
	GtkProgressBar* background_progress;
	GtkRevealer* formatting;
	GtkMenuButton* font_button;
	GtkStack* font_button_stack;
	GtkMenuButton* font_size_button;
	GtkImage* font_color_icon;
	GtkMenuButton* more_options_button;
	GtkGestureMultiPress* click_gesture;
};

struct _Block63Data {
	int _ref_count_;
	ComposerEditor* self;
	ApplicationConfiguration* config;
};

struct _Block64Data {
	int _ref_count_;
	ComposerEditor* self;
	gchar* selection_id;
	ComposerLinkPopover* popover;
	gpointer _async_data_;
};

struct _ComposerEditorNewLinkPopoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerEditor* self;
	ComposerLinkPopoverType type;
	gchar* url;
	ComposerLinkPopover* result;
	Block64Data* _data64_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ComposerWebView* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	ComposerLinkPopover* _tmp7_;
	ComposerLinkPopover* _tmp8_;
	GError* _inner_error0_;
};

struct _ComposerEditorUpdateColorIconData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerEditor* self;
	GdkRGBA color;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GtkIconInfo* icon;
	GtkIconInfo* _tmp2_;
	GdkRGBA fg_color;
	GdkRGBA _tmp3_;
	GtkStyleContext* _tmp4_;
	GdkRGBA _tmp5_;
	GdkPixbuf* pixbuf;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkPixbuf* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GError* _inner_error0_;
};

struct _Block65Data {
	int _ref_count_;
	ComposerEditor* self;
	GdkRectangle location;
};

struct _Block66Data {
	int _ref_count_;
	ComposerEditor* self;
	GeeList* existing_spelling;
	GeeList* existing_text_entry;
	WebKitContextMenu* context_menu;
};

struct _Block67Data {
	int _ref_count_;
	ComposerEditor* self;
	WebKitContextMenu* context_menu;
};

struct _Block68Data {
	int _ref_count_;
	ComposerEditor* self;
	GtkStyleContext* style;
};

static gint ComposerEditor_private_offset;
static gpointer composer_editor_parent_class = NULL;
static GearyBaseInterfaceIface * composer_editor_geary_base_interface_parent_iface = NULL;

GType components_reflow_box_get_type (void);
static void composer_editor_on_copy (ComposerEditor* self);
static void _composer_editor_on_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void composer_editor_on_redo (ComposerEditor* self);
static void _composer_editor_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void composer_editor_on_undo (ComposerEditor* self);
static void _composer_editor_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void composer_editor_on_action (ComposerEditor* self,
                                GSimpleAction* action,
                                GVariant* param);
static void _composer_editor_on_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void composer_editor_on_select_color (ComposerEditor* self);
static void _composer_editor_on_select_color_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void composer_editor_on_copy_link (ComposerEditor* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _composer_editor_on_copy_link_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void composer_editor_on_cut (ComposerEditor* self);
static void _composer_editor_on_cut_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void composer_editor_on_font_family (ComposerEditor* self,
                                     GSimpleAction* action,
                                     GVariant* param);
static void _composer_editor_on_font_family_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void composer_editor_on_font_size (ComposerEditor* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _composer_editor_on_font_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void composer_editor_on_indent (ComposerEditor* self);
static void _composer_editor_on_indent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void composer_editor_on_insert_image (ComposerEditor* self);
static void _composer_editor_on_insert_image_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void composer_editor_on_insert_link (ComposerEditor* self);
static void _composer_editor_on_insert_link_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void composer_editor_on_justify (ComposerEditor* self,
                                 GAction* action,
                                 GVariant* param);
static void _composer_editor_on_justify_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void composer_editor_on_olist (ComposerEditor* self);
static void _composer_editor_on_olist_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void composer_editor_on_open_inspector (ComposerEditor* self);
static void _composer_editor_on_open_inspector_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void composer_editor_on_paste (ComposerEditor* self);
static void _composer_editor_on_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void composer_editor_on_paste_without_formatting (ComposerEditor* self,
                                                  GSimpleAction* action,
                                                  GVariant* param);
static void _composer_editor_on_paste_without_formatting_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void composer_editor_on_remove_format (ComposerEditor* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _composer_editor_on_remove_format_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void composer_editor_on_select_all (ComposerEditor* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _composer_editor_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void composer_editor_on_select_dictionary (ComposerEditor* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _composer_editor_on_select_dictionary_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void composer_editor_on_toggle_action (ComposerEditor* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _composer_editor_on_toggle_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void composer_editor_on_show_formatting (ComposerEditor* self,
                                         GSimpleAction* action,
                                         GVariant* new_state);
static void _composer_editor_on_show_formatting_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                               GVariant* value,
                                                                               gpointer self);
static void composer_editor_on_text_format (ComposerEditor* self,
                                     GSimpleAction* action,
                                     GVariant* new_state);
static void _composer_editor_on_text_format_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                           GVariant* value,
                                                                           gpointer self);
static void composer_editor_on_ulist (ComposerEditor* self);
static void _composer_editor_on_ulist_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void composer_editor_set_body (ComposerEditor* self,
                               ComposerWebView* value);
VALA_EXTERN ComposerEditor* composer_editor_new (ApplicationConfiguration* config);
VALA_EXTERN ComposerEditor* composer_editor_construct (GType object_type,
                                           ApplicationConfiguration* config);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static void composer_editor_on_command_state_changed (ComposerEditor* self,
                                               gboolean can_undo,
                                               gboolean can_redo);
static void _composer_editor_on_command_state_changed_components_web_view_command_stack_changed (ComponentsWebView* _sender,
                                                                                          gboolean can_undo,
                                                                                          gboolean can_redo,
                                                                                          gpointer self);
static gboolean composer_editor_on_context_menu (ComposerEditor* self,
                                          WebKitWebView* view,
                                          WebKitContextMenu* context_menu,
                                          GdkEvent* event,
                                          WebKitHitTestResult* hit_test_result);
static gboolean _composer_editor_on_context_menu_webkit_web_view_context_menu (WebKitWebView* _sender,
                                                                        WebKitContextMenu* context_menu,
                                                                        GdkEvent* event,
                                                                        WebKitHitTestResult* hit_test_result,
                                                                        gpointer self);
static void composer_editor_on_cursor_context_changed (ComposerEditor* self,
                                                ComposerWebViewEditContext* context);
static void _composer_editor_on_cursor_context_changed_composer_web_view_cursor_context_changed (ComposerWebView* _sender,
                                                                                          ComposerWebViewEditContext* cursor_context,
                                                                                          gpointer self);
static void composer_editor_on_typing_attributes_changed (ComposerEditor* self);
static void _composer_editor_on_typing_attributes_changed_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void composer_editor_on_mouse_target_changed (ComposerEditor* self,
                                              WebKitWebView* web_view,
                                              WebKitHitTestResult* hit_test,
                                              guint modifiers);
static void _composer_editor_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                                    WebKitHitTestResult* hit_test_result,
                                                                                    guint modifiers,
                                                                                    gpointer self);
static void composer_editor_on_selection_changed (ComposerEditor* self);
static void _composer_editor_on_selection_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void composer_editor_on_button_press (ComposerEditor* self,
                                      gint n_press,
                                      gdouble x,
                                      gdouble y);
static void _composer_editor_on_button_press_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                       gint n_press,
                                                                       gdouble x,
                                                                       gdouble y,
                                                                       gpointer self);
static void composer_editor_on_button_release (ComposerEditor* self,
                                        gint n_press,
                                        gdouble x,
                                        gdouble y);
static void _composer_editor_on_button_release_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                          gint n_press,
                                                                          gdouble x,
                                                                          gdouble y,
                                                                          gpointer self);
static GVariant* _variant_new7 (const gchar* value);
static GVariant* _variant_new8 (gboolean value);
static GSimpleAction* composer_editor_get_action (ComposerEditor* self,
                                           const gchar* action_name);
static void composer_editor_update_cursor_actions (ComposerEditor* self);
static void __lambda26_ (Block63Data* _data63_,
                  gchar** active_langs,
                  gint active_langs_length1);
static void ___lambda26__spell_check_popover_selection_changed (SpellCheckPopover* _sender,
                                                         gchar** active_langs,
                                                         gint active_langs_length1,
                                                         gpointer self);
static void composer_editor_on_background_work_timeout (ComposerEditor* self);
static void _composer_editor_on_background_work_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                     gpointer self);
static void _gtk_progress_bar_pulse_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                 gpointer self);
static void composer_editor_real_destroy (GtkWidget* base);
VALA_EXTERN void composer_editor_set_info_label (ComposerEditor* self,
                                     const gchar* text);
VALA_EXTERN void composer_editor_start_background_work_pulse (ComposerEditor* self);
VALA_EXTERN void composer_editor_stop_background_work_pulse (ComposerEditor* self);
static void composer_editor_new_link_popover_data_free (gpointer _data);
static void composer_editor_new_link_popover (ComposerEditor* self,
                                       ComposerLinkPopoverType type,
                                       const gchar* url,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static ComposerLinkPopover* composer_editor_new_link_popover_finish (ComposerEditor* self,
                                                              GAsyncResult* _res_);
static gboolean composer_editor_new_link_popover_co (ComposerEditorNewLinkPopoverData* _data_);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static void composer_editor_new_link_popover_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void __lambda15_ (Block64Data* _data64_);
static void ___lambda15__gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self);
static void __lambda16_ (Block64Data* _data64_);
static gboolean __lambda17_ (Block64Data* _data64_);
static gboolean ___lambda17__gsource_func (gpointer self);
static void ___lambda16__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
static void __lambda18_ (Block64Data* _data64_,
                  ComposerLinkPopover* link_uri);
static void ___lambda18__composer_link_popover_link_activate (ComposerLinkPopover* _sender,
                                                       gpointer self);
static void __lambda19_ (Block64Data* _data64_);
static void ___lambda19__composer_link_popover_link_delete (ComposerLinkPopover* _sender,
                                                     gpointer self);
static void composer_editor_update_formatting_toolbar (ComposerEditor* self);
static void composer_editor_update_color_icon_data_free (gpointer _data);
static void composer_editor_update_color_icon (ComposerEditor* self,
                                        GdkRGBA* color,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void composer_editor_update_color_icon_finish (ComposerEditor* self,
                                               GAsyncResult* _res_);
static gboolean composer_editor_update_color_icon_co (ComposerEditorUpdateColorIconData* _data_);
static void composer_editor_update_color_icon_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void ___lambda24_ (Block65Data* _data65_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda24__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static gboolean _vala_webkit_context_menu_action_array_contains (WebKitContextMenuAction * stack,
                                                          gssize stack_length,
                                                          const WebKitContextMenuAction needle);
VALA_EXTERN void util_gtk_menu_foreach (GMenu* menu,
                            UtilGtkMenuForeachFunc foreach_func,
                            gpointer foreach_func_target);
static void __lambda22_ (Block66Data* _data66_,
                  const gchar* label,
                  const gchar* name,
                  GVariant* target,
                  GMenu* section);
static inline void composer_editor_append_menu_section (ComposerEditor* self,
                                          WebKitContextMenu* context_menu,
                                          GMenu* section);
static void ___lambda22__util_gtk_menu_foreach_func (const gchar* label,
                                              const gchar* action_name,
                                              GVariant* target,
                                              GMenu* section,
                                              gpointer self);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static void __lambda23_ (Block67Data* _data67_,
                  const gchar* label,
                  const gchar* name,
                  GVariant* target,
                  GMenu* section);
static void ___lambda23__util_gtk_menu_foreach_func (const gchar* label,
                                              const gchar* action_name,
                                              GVariant* target,
                                              GMenu* section,
                                              gpointer self);
static GVariant* _variant_new9 (const gchar* value);
static GVariant* _variant_new10 (const gchar* value);
static GVariant* _variant_new11 (const gchar* value);
static GVariant* _variant_new12 (const gchar* value);
static GVariant* _variant_new13 (gboolean value);
static GVariant* _variant_new14 (gboolean value);
static GVariant* _variant_new15 (gboolean value);
static GVariant* _variant_new16 (gboolean value);
static GVariant* _variant_new17 (const gchar* value);
static void __lambda20_ (ComposerEditor* self,
                  GObject* obj,
                  GAsyncResult* res);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void __lambda21_ (Block68Data* _data68_);
static void ___lambda21__gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self);
static void ___lambda20__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GVariant* _variant_new18 (const gchar* value);
static GVariant* _variant_new19 (const gchar* value);
static GVariant* _variant_new20 (gboolean value);
static void composer_editor_finalize (GObject * obj);
static GType composer_editor_get_type_once (void);
static void _vala_composer_editor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_composer_editor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* COMPOSER_EDITOR_HTML_ACTIONS[12] = {COMPOSER_EDITOR_ACTION_BOLD, COMPOSER_EDITOR_ACTION_ITALIC, COMPOSER_EDITOR_ACTION_UNDERLINE, COMPOSER_EDITOR_ACTION_STRIKETHROUGH, COMPOSER_EDITOR_ACTION_FONT_SIZE, COMPOSER_EDITOR_ACTION_FONT_FAMILY, COMPOSER_EDITOR_ACTION_COLOR, COMPOSER_EDITOR_ACTION_JUSTIFY, COMPOSER_EDITOR_ACTION_INSERT_IMAGE, COMPOSER_EDITOR_ACTION_COPY_LINK, COMPOSER_EDITOR_ACTION_OLIST, COMPOSER_EDITOR_ACTION_ULIST};
static const GActionEntry COMPOSER_EDITOR_ACTIONS[27] = {{ACTION_EDIT_COPY, _composer_editor_on_copy_gsimple_action_activate_callback}, {ACTION_EDIT_REDO, _composer_editor_on_redo_gsimple_action_activate_callback}, {ACTION_EDIT_UNDO, _composer_editor_on_undo_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_BOLD, _composer_editor_on_action_gsimple_action_activate_callback, NULL, "false"}, {COMPOSER_EDITOR_ACTION_COLOR, _composer_editor_on_select_color_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_COPY_LINK, _composer_editor_on_copy_link_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_CUT, _composer_editor_on_cut_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_FONT_FAMILY, _composer_editor_on_font_family_gsimple_action_activate_callback, "s", "'sans'"}, {COMPOSER_EDITOR_ACTION_FONT_SIZE, _composer_editor_on_font_size_gsimple_action_activate_callback, "s", "'medium'"}, {COMPOSER_EDITOR_ACTION_INDENT, _composer_editor_on_indent_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_INSERT_IMAGE, _composer_editor_on_insert_image_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_INSERT_LINK, _composer_editor_on_insert_link_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_ITALIC, _composer_editor_on_action_gsimple_action_activate_callback, NULL, "false"}, {COMPOSER_EDITOR_ACTION_JUSTIFY, _composer_editor_on_justify_gsimple_action_activate_callback, "s", "'left'"}, {COMPOSER_EDITOR_ACTION_OLIST, _composer_editor_on_olist_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_OPEN_INSPECTOR, _composer_editor_on_open_inspector_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_OUTDENT, _composer_editor_on_action_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_PASTE, _composer_editor_on_paste_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_PASTE_WITHOUT_FORMATTING, _composer_editor_on_paste_without_formatting_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_REMOVE_FORMAT, _composer_editor_on_remove_format_gsimple_action_activate_callback, NULL, "false"}, {COMPOSER_EDITOR_ACTION_SELECT_ALL, _composer_editor_on_select_all_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_SELECT_DICTIONARY, _composer_editor_on_select_dictionary_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_SHOW_FORMATTING, _composer_editor_on_toggle_action_gsimple_action_activate_callback, NULL, "false", _composer_editor_on_show_formatting_gsimple_action_change_state_callback}, {COMPOSER_EDITOR_ACTION_STRIKETHROUGH, _composer_editor_on_action_gsimple_action_activate_callback, NULL, "false"}, {COMPOSER_EDITOR_ACTION_TEXT_FORMAT, NULL, "s", "'html'", _composer_editor_on_text_format_gsimple_action_change_state_callback}, {COMPOSER_EDITOR_ACTION_ULIST, _composer_editor_on_ulist_gsimple_action_activate_callback}, {COMPOSER_EDITOR_ACTION_UNDERLINE, _composer_editor_on_action_gsimple_action_activate_callback, NULL, "false"}};

static inline gpointer
composer_editor_get_instance_private (ComposerEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerEditor_private_offset);
}

static void
_composer_editor_on_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	composer_editor_on_copy ((ComposerEditor*) self);
}

static void
_composer_editor_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	composer_editor_on_redo ((ComposerEditor*) self);
}

static void
_composer_editor_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	composer_editor_on_undo ((ComposerEditor*) self);
}

static void
_composer_editor_on_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	composer_editor_on_action ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_select_color_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	composer_editor_on_select_color ((ComposerEditor*) self);
}

static void
_composer_editor_on_copy_link_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	composer_editor_on_copy_link ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_cut_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	composer_editor_on_cut ((ComposerEditor*) self);
}

static void
_composer_editor_on_font_family_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	composer_editor_on_font_family ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_font_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	composer_editor_on_font_size ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_indent_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	composer_editor_on_indent ((ComposerEditor*) self);
}

static void
_composer_editor_on_insert_image_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	composer_editor_on_insert_image ((ComposerEditor*) self);
}

static void
_composer_editor_on_insert_link_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	composer_editor_on_insert_link ((ComposerEditor*) self);
}

static void
_composer_editor_on_justify_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	composer_editor_on_justify ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_olist_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	composer_editor_on_olist ((ComposerEditor*) self);
}

static void
_composer_editor_on_open_inspector_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	composer_editor_on_open_inspector ((ComposerEditor*) self);
}

static void
_composer_editor_on_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	composer_editor_on_paste ((ComposerEditor*) self);
}

static void
_composer_editor_on_paste_without_formatting_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	composer_editor_on_paste_without_formatting ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_remove_format_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	composer_editor_on_remove_format ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	composer_editor_on_select_all ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_select_dictionary_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	composer_editor_on_select_dictionary ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_toggle_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	composer_editor_on_toggle_action ((ComposerEditor*) self, action, parameter);
}

static void
_composer_editor_on_show_formatting_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self)
{
	composer_editor_on_show_formatting ((ComposerEditor*) self, action, value);
}

static void
_composer_editor_on_text_format_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                      GVariant* value,
                                                                      gpointer self)
{
	composer_editor_on_text_format ((ComposerEditor*) self, action, value);
}

static void
_composer_editor_on_ulist_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	composer_editor_on_ulist ((ComposerEditor*) self);
}

void
composer_editor_add_accelerators (ApplicationClient* application)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	g_return_if_fail (APPLICATION_IS_CLIENT (application));
	_tmp0_ = g_strdup ("<Ctrl>x");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_CUT, _tmp2_, (gint) 1, NULL);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Ctrl>v");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_PASTE, _tmp5_, (gint) 1, NULL);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Ctrl><Shift>v");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_PASTE_WITHOUT_FORMATTING, _tmp8_, (gint) 1, NULL);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Ctrl>g");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_INSERT_IMAGE, _tmp11_, (gint) 1, NULL);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Ctrl>l");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_INSERT_LINK, _tmp14_, (gint) 1, NULL);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Ctrl>bracketright");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_INDENT, _tmp17_, (gint) 1, NULL);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Ctrl>bracketleft");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_OUTDENT, _tmp20_, (gint) 1, NULL);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<Ctrl>space");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_REMOVE_FORMAT, _tmp23_, (gint) 1, NULL);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("<Ctrl>b");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_BOLD, _tmp26_, (gint) 1, NULL);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("<Ctrl>i");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_ITALIC, _tmp29_, (gint) 1, NULL);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_strdup ("<Ctrl>u");
	_tmp31_ = g_new0 (gchar*, 1 + 1);
	_tmp31_[0] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_UNDERLINE, _tmp32_, (gint) 1, NULL);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = g_strdup ("<Ctrl>k");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	application_client_add_edit_accelerators (application, COMPOSER_EDITOR_ACTION_STRIKETHROUGH, _tmp35_, (gint) 1, NULL);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
}

ComposerWebView*
composer_editor_get_body (ComposerEditor* self)
{
	ComposerWebView* result;
	ComposerWebView* _tmp0_;
	g_return_val_if_fail (COMPOSER_IS_EDITOR (self), NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
composer_editor_set_body (ComposerEditor* self,
                          ComposerWebView* value)
{
	ComposerWebView* old_value;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	old_value = composer_editor_get_body (self);
	if (old_value != value) {
		ComposerWebView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, composer_editor_properties[COMPOSER_EDITOR_BODY_PROPERTY]);
	}
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		ComposerEditor* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->config);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static void
_composer_editor_on_command_state_changed_components_web_view_command_stack_changed (ComponentsWebView* _sender,
                                                                                     gboolean can_undo,
                                                                                     gboolean can_redo,
                                                                                     gpointer self)
{
	composer_editor_on_command_state_changed ((ComposerEditor*) self, can_undo, can_redo);
}

static gboolean
_composer_editor_on_context_menu_webkit_web_view_context_menu (WebKitWebView* _sender,
                                                               WebKitContextMenu* context_menu,
                                                               GdkEvent* event,
                                                               WebKitHitTestResult* hit_test_result,
                                                               gpointer self)
{
	gboolean result;
	result = composer_editor_on_context_menu ((ComposerEditor*) self, _sender, context_menu, event, hit_test_result);
	return result;
}

static void
_composer_editor_on_cursor_context_changed_composer_web_view_cursor_context_changed (ComposerWebView* _sender,
                                                                                     ComposerWebViewEditContext* cursor_context,
                                                                                     gpointer self)
{
	composer_editor_on_cursor_context_changed ((ComposerEditor*) self, cursor_context);
}

static void
_composer_editor_on_typing_attributes_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	composer_editor_on_typing_attributes_changed ((ComposerEditor*) self);
}

static void
_composer_editor_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                               WebKitHitTestResult* hit_test_result,
                                                                               guint modifiers,
                                                                               gpointer self)
{
	composer_editor_on_mouse_target_changed ((ComposerEditor*) self, _sender, hit_test_result, modifiers);
}

static void
_composer_editor_on_selection_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	composer_editor_on_selection_changed ((ComposerEditor*) self);
}

static void
_composer_editor_on_button_press_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                  gint n_press,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gpointer self)
{
	composer_editor_on_button_press ((ComposerEditor*) self, n_press, x, y);
}

static void
_composer_editor_on_button_release_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                     gint n_press,
                                                                     gdouble x,
                                                                     gdouble y,
                                                                     gpointer self)
{
	composer_editor_on_button_release ((ComposerEditor*) self, n_press, x, y);
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new8 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
__lambda26_ (Block63Data* _data63_,
             gchar** active_langs,
             gint active_langs_length1)
{
	ComposerEditor* self;
	self = _data63_->self;
	application_configuration_set_spell_check_languages (_data63_->config, active_langs, (gint) active_langs_length1);
}

static void
___lambda26__spell_check_popover_selection_changed (SpellCheckPopover* _sender,
                                                    gchar** active_langs,
                                                    gint active_langs_length1,
                                                    gpointer self)
{
	__lambda26_ (self, active_langs, active_langs_length1);
}

static void
_composer_editor_on_background_work_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                gpointer self)
{
	composer_editor_on_background_work_timeout ((ComposerEditor*) self);
}

static void
_gtk_progress_bar_pulse_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                            gpointer self)
{
	gtk_progress_bar_pulse ((GtkProgressBar*) self);
}

ComposerEditor*
composer_editor_construct (GType object_type,
                           ApplicationConfiguration* config)
{
	ComposerEditor * self = NULL;
	Block63Data* _data63_;
	ApplicationConfiguration* _tmp0_;
	ApplicationConfiguration* _tmp1_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GMenu* _tmp5_;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_;
	GMenu* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GMenu* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GMenu* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GMenu* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GMenu* _tmp20_;
	ComposerWebView* _tmp21_;
	ComposerWebView* _tmp22_;
	ComposerWebView* _tmp23_;
	ComposerWebView* _tmp24_;
	ComposerWebView* _tmp25_;
	ComposerWebView* _tmp26_;
	WebKitEditorState* _tmp27_;
	ComposerWebView* _tmp28_;
	ComposerWebView* _tmp29_;
	ComposerWebView* _tmp30_;
	ComposerWebView* _tmp31_;
	ComposerWebView* _tmp32_;
	GtkGrid* _tmp33_;
	ComposerWebView* _tmp34_;
	ComposerWebView* _tmp35_;
	GtkGestureMultiPress* _tmp36_;
	GtkGestureMultiPress* _tmp37_;
	GtkGestureMultiPress* _tmp38_;
	GtkGestureMultiPress* _tmp39_;
	GSimpleActionGroup* _tmp40_;
	const gchar* _tmp41_ = NULL;
	gboolean _tmp42_;
	gboolean _tmp43_;
	GSimpleActionGroup* _tmp44_;
	GVariant* _tmp45_;
	GSimpleActionGroup* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	GVariant* _tmp49_;
	GSimpleActionGroup* _tmp50_;
	GSimpleAction* _tmp51_;
	GSimpleAction* _tmp52_;
	GSimpleAction* _tmp53_;
	GSimpleAction* _tmp54_;
	SpellCheckPopover* spell_check_popover = NULL;
	GtkMenuButton* _tmp55_;
	SpellCheckPopover* _tmp56_;
	GearyTimeoutManager* _tmp57_;
	GtkProgressBar* _tmp58_;
	GearyTimeoutManager* _tmp59_;
	GearyTimeoutManager* _tmp60_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (_data63_->config);
	_data63_->config = _tmp0_;
	self = (ComposerEditor*) g_object_new (object_type, NULL);
	_data63_->self = g_object_ref (self);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	components_reflow_box_get_type ();
	_tmp1_ = _g_object_ref0 (_data63_->config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_tmp2_ = gtk_builder_new_from_resource ("/org/gnome/Geary/composer-editor-menus.ui");
	builder = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "context_menu_model");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_model);
	self->priv->context_menu_model = _tmp5_;
	_tmp6_ = builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "context_menu_rich_text");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_rich_text);
	self->priv->context_menu_rich_text = _tmp8_;
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "context_menu_plain_text");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_plain_text);
	self->priv->context_menu_plain_text = _tmp11_;
	_tmp12_ = builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "context_menu_inspector");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_inspector);
	self->priv->context_menu_inspector = _tmp14_;
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "context_menu_webkit_spelling");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_webkit_spelling);
	self->priv->context_menu_webkit_spelling = _tmp17_;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "context_menu_webkit_text_entry");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_menu_get_type (), GMenu));
	_g_object_unref0 (self->priv->context_menu_webkit_text_entry);
	self->priv->context_menu_webkit_text_entry = _tmp20_;
	_tmp21_ = composer_web_view_new (_data63_->config);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	composer_editor_set_body (self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->_body;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), "command-stack-changed", (GCallback) _composer_editor_on_command_state_changed_components_web_view_command_stack_changed, self, 0);
	_tmp24_ = self->priv->_body;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, webkit_web_view_get_type (), WebKitWebView), "context-menu", (GCallback) _composer_editor_on_context_menu_webkit_web_view_context_menu, self, 0);
	_tmp25_ = self->priv->_body;
	g_signal_connect_object (_tmp25_, "cursor-context-changed", (GCallback) _composer_editor_on_cursor_context_changed_composer_web_view_cursor_context_changed, self, 0);
	_tmp26_ = self->priv->_body;
	_tmp27_ = webkit_web_view_get_editor_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, webkit_web_view_get_type (), WebKitWebView));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G_TYPE_OBJECT, GObject), "notify::typing-attributes", (GCallback) _composer_editor_on_typing_attributes_changed_g_object_notify, self, 0);
	_tmp28_ = self->priv->_body;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, webkit_web_view_get_type (), WebKitWebView), "mouse-target-changed", (GCallback) _composer_editor_on_mouse_target_changed_webkit_web_view_mouse_target_changed, self, 0);
	_tmp29_ = self->priv->_body;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, G_TYPE_OBJECT, GObject), "notify::has-selection", (GCallback) _composer_editor_on_selection_changed_g_object_notify, self, 0);
	_tmp30_ = self->priv->_body;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp31_ = self->priv->_body;
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp32_ = self->priv->_body;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
	_tmp33_ = self->priv->body_container;
	_tmp34_ = self->priv->_body;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_tmp35_ = self->priv->_body;
	_tmp36_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->click_gesture);
	self->priv->click_gesture = _tmp36_;
	_tmp37_ = self->priv->click_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_CAPTURE);
	_tmp38_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp38_, "pressed", (GCallback) _composer_editor_on_button_press_gtk_gesture_multi_press_pressed, self, 0);
	_tmp39_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp39_, "released", (GCallback) _composer_editor_on_button_release_gtk_gesture_multi_press_released, self, 0);
	_tmp40_ = self->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, g_action_map_get_type (), GActionMap), COMPOSER_EDITOR_ACTIONS, (gint) G_N_ELEMENTS (COMPOSER_EDITOR_ACTIONS), self);
	_tmp42_ = application_configuration_get_compose_as_html (_data63_->config);
	_tmp43_ = _tmp42_;
	if (_tmp43_) {
		_tmp41_ = "html";
	} else {
		_tmp41_ = "plain";
	}
	_tmp44_ = self->actions;
	_tmp45_ = _variant_new7 (_tmp41_);
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_TEXT_FORMAT, _tmp45_);
	_g_variant_unref0 (_tmp45_);
	_tmp46_ = self->actions;
	_tmp47_ = application_configuration_get_formatting_toolbar_visible (_data63_->config);
	_tmp48_ = _tmp47_;
	_tmp49_ = _variant_new8 (_tmp48_);
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_SHOW_FORMATTING, _tmp49_);
	_g_variant_unref0 (_tmp49_);
	_tmp50_ = self->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), ACTION_EDIT_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, g_action_group_get_type (), GActionGroup));
	_tmp51_ = composer_editor_get_action (self, ACTION_EDIT_UNDO);
	_tmp52_ = _tmp51_;
	g_simple_action_set_enabled (_tmp52_, FALSE);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = composer_editor_get_action (self, ACTION_EDIT_REDO);
	_tmp54_ = _tmp53_;
	g_simple_action_set_enabled (_tmp54_, FALSE);
	_g_object_unref0 (_tmp54_);
	composer_editor_update_cursor_actions (self);
	_tmp55_ = self->priv->select_dictionary_button;
	_tmp56_ = spell_check_popover_new (_tmp55_, _data63_->config);
	spell_check_popover = _tmp56_;
	g_signal_connect_data (spell_check_popover, "selection-changed", (GCallback) ___lambda26__spell_check_popover_selection_changed, block63_data_ref (_data63_), (GClosureNotify) block63_data_unref, 0);
	_tmp57_ = geary_timeout_manager_new_milliseconds ((guint) UTIL_GTK_SHOW_PROGRESS_TIMEOUT_MSEC, _composer_editor_on_background_work_timeout_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->show_background_work_timeout);
	self->priv->show_background_work_timeout = _tmp57_;
	_tmp58_ = self->priv->background_progress;
	_tmp59_ = geary_timeout_manager_new_milliseconds ((guint) UTIL_GTK_PROGRESS_PULSE_TIMEOUT_MSEC, _gtk_progress_bar_pulse_geary_timeout_manager_timeout_func, _tmp58_);
	_g_object_unref0 (self->priv->background_work_pulse);
	self->priv->background_work_pulse = _tmp59_;
	_tmp60_ = self->priv->background_work_pulse;
	_tmp60_->repetition = GEARY_TIMEOUT_MANAGER_REPEAT_FOREVER;
	_spell_check_popover_unref0 (spell_check_popover);
	_g_object_unref0 (builder);
	block63_data_unref (_data63_);
	_data63_ = NULL;
	return self;
}

ComposerEditor*
composer_editor_new (ApplicationConfiguration* config)
{
	return composer_editor_construct (COMPOSER_TYPE_EDITOR, config);
}

static void
composer_editor_real_destroy (GtkWidget* base)
{
	ComposerEditor * self;
	GearyTimeoutManager* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_EDITOR, ComposerEditor);
	_tmp0_ = self->priv->show_background_work_timeout;
	geary_timeout_manager_reset (_tmp0_);
	_tmp1_ = self->priv->background_work_pulse;
	geary_timeout_manager_reset (_tmp1_);
	GTK_WIDGET_CLASS (composer_editor_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), gtk_widget_get_type (), GtkWidget));
}

/** Adds an action bar to the composer. */
void
composer_editor_add_action_bar (ComposerEditor* self,
                                GtkActionBar* to_add)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_add, gtk_action_bar_get_type ()));
	_tmp0_ = self->priv->action_bar_box;
	gtk_box_pack_start (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (to_add, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp1_ = self->priv->action_bar_box;
	gtk_box_reorder_child (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (to_add, gtk_widget_get_type (), GtkWidget), 0);
}

/**
     * Inserts a menu section into the editor's menu.
     */
void
composer_editor_insert_menu_section (ComposerEditor* self,
                                     GMenuModel* section)
{
	GMenu* menu = NULL;
	GtkMenuButton* _tmp0_;
	GMenuModel* _tmp1_;
	GMenuModel* _tmp2_;
	GMenu* _tmp3_;
	GMenu* _tmp4_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (section, g_menu_model_get_type ()));
	_tmp0_ = self->priv->more_options_button;
	_tmp1_ = gtk_menu_button_get_menu_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_menu_get_type ()) ? ((GMenu*) _tmp2_) : NULL);
	menu = _tmp3_;
	_tmp4_ = menu;
	if (_tmp4_ != NULL) {
		GMenu* _tmp5_;
		_tmp5_ = menu;
		g_menu_insert_section (_tmp5_, 0, NULL, section);
	}
	_g_object_unref0 (menu);
}

/** Displays the given human readable text in the UI */
void
composer_editor_set_info_label (ComposerEditor* self,
                                const gchar* text)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->info_label;
	gtk_label_set_text (_tmp0_, text);
	_tmp1_ = self->priv->info_label;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), text);
}

/** Starts the progress meter timer. */
void
composer_editor_start_background_work_pulse (ComposerEditor* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->show_background_work_timeout;
	geary_timeout_manager_start (_tmp0_);
}

/** Hides and stops pulsing the progress meter. */
void
composer_editor_stop_background_work_pulse (ComposerEditor* self)
{
	GtkProgressBar* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	GearyTimeoutManager* _tmp2_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->background_progress;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->background_work_pulse;
	geary_timeout_manager_reset (_tmp1_);
	_tmp2_ = self->priv->show_background_work_timeout;
	geary_timeout_manager_reset (_tmp2_);
}

static void
composer_editor_update_cursor_actions (ComposerEditor* self)
{
	gboolean has_selection = FALSE;
	ComposerWebView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	gboolean _tmp7_ = FALSE;
	ComposerWebView* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	gboolean _tmp15_ = FALSE;
	ComposerWebView* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction* _tmp20_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	_tmp1_ = components_web_view_get_has_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
	_tmp2_ = _tmp1_;
	has_selection = _tmp2_;
	_tmp3_ = composer_editor_get_action (self, COMPOSER_EDITOR_ACTION_CUT);
	_tmp4_ = _tmp3_;
	g_simple_action_set_enabled (_tmp4_, has_selection);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = composer_editor_get_action (self, ACTION_EDIT_COPY);
	_tmp6_ = _tmp5_;
	g_simple_action_set_enabled (_tmp6_, has_selection);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = self->priv->_body;
	_tmp9_ = composer_web_view_get_is_rich_text (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		if (has_selection) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = self->priv->cursor_url;
			_tmp11_ = _tmp12_ != NULL;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp13_ = composer_editor_get_action (self, COMPOSER_EDITOR_ACTION_INSERT_LINK);
	_tmp14_ = _tmp13_;
	g_simple_action_set_enabled (_tmp14_, _tmp7_);
	_g_object_unref0 (_tmp14_);
	_tmp16_ = self->priv->_body;
	_tmp17_ = composer_web_view_get_is_rich_text (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		_tmp15_ = has_selection;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp19_ = composer_editor_get_action (self, COMPOSER_EDITOR_ACTION_REMOVE_FORMAT);
	_tmp20_ = _tmp19_;
	g_simple_action_set_enabled (_tmp20_, _tmp15_);
	_g_object_unref0 (_tmp20_);
}

static void
composer_editor_new_link_popover_data_free (gpointer _data)
{
	ComposerEditorNewLinkPopoverData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerEditorNewLinkPopoverData, _data_);
}

static void
composer_editor_new_link_popover (ComposerEditor* self,
                                  ComposerLinkPopoverType type,
                                  const gchar* url,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ComposerEditorNewLinkPopoverData* _data_;
	ComposerEditor* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (url != NULL);
	_data_ = g_slice_new0 (ComposerEditorNewLinkPopoverData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_editor_new_link_popover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->type = type;
	_tmp1_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	composer_editor_new_link_popover_co (_data_);
}

static ComposerLinkPopover*
composer_editor_new_link_popover_finish (ComposerEditor* self,
                                         GAsyncResult* _res_)
{
	ComposerLinkPopover* result;
	ComposerEditorNewLinkPopoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		ComposerEditor* self;
		self = _data64_->self;
		_g_object_unref0 (_data64_->popover);
		_g_free0 (_data64_->selection_id);
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}

static void
composer_editor_new_link_popover_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ComposerEditorNewLinkPopoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_editor_new_link_popover_co (_data_);
}

static void
__lambda15_ (Block64Data* _data64_)
{
	ComposerEditor* self;
	ComposerWebView* _tmp0_;
	const gchar* _tmp1_;
	self = _data64_->self;
	_tmp0_ = self->priv->_body;
	_tmp1_ = _data64_->selection_id;
	composer_web_view_free_selection (_tmp0_, _tmp1_);
}

static void
___lambda15__gtk_popover_closed (GtkPopover* _sender,
                                 gpointer self)
{
	__lambda15_ (self);
}

static gboolean
__lambda17_ (Block64Data* _data64_)
{
	ComposerEditor* self;
	gboolean result;
	self = _data64_->self;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data64_->popover, gtk_widget_get_type (), GtkWidget));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ (self);
	return result;
}

static void
__lambda16_ (Block64Data* _data64_)
{
	ComposerEditor* self;
	self = _data64_->self;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block64_data_ref (_data64_), block64_data_unref);
}

static void
___lambda16__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda18_ (Block64Data* _data64_,
             ComposerLinkPopover* link_uri)
{
	ComposerEditor* self;
	ComposerWebView* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data64_->self;
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (link_uri));
	_tmp0_ = self->priv->_body;
	_tmp1_ = composer_link_popover_get_link_uri (_data64_->popover);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data64_->selection_id;
	composer_web_view_insert_link (_tmp0_, _tmp2_, _tmp3_);
}

static void
___lambda18__composer_link_popover_link_activate (ComposerLinkPopover* _sender,
                                                  gpointer self)
{
	__lambda18_ (self, _sender);
}

static void
__lambda19_ (Block64Data* _data64_)
{
	ComposerEditor* self;
	ComposerWebView* _tmp0_;
	const gchar* _tmp1_;
	self = _data64_->self;
	_tmp0_ = self->priv->_body;
	_tmp1_ = _data64_->selection_id;
	composer_web_view_delete_link (_tmp0_, _tmp1_);
}

static void
___lambda19__composer_link_popover_link_delete (ComposerLinkPopover* _sender,
                                                gpointer self)
{
	__lambda19_ (self);
}

static gboolean
composer_editor_new_link_popover_co (ComposerEditorNewLinkPopoverData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data64_ = g_slice_new0 (Block64Data);
	_data_->_data64_->_ref_count_ = 1;
	_data_->_data64_->self = g_object_ref (_data_->self);
	_data_->_data64_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup ("");
	_data_->_data64_->selection_id = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->self->priv->_body;
		_data_->_state_ = 1;
		composer_web_view_save_selection (_data_->_tmp2_, composer_editor_new_link_popover_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = composer_web_view_save_selection_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_free0 (_data_->_data64_->selection_id);
		_data_->_data64_->selection_id = _data_->_tmp4_;
		_g_free0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->err;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_debug ("composer-editor.vala:281: Error saving selection: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block64_data_unref (_data_->_data64_);
		_data_->_data64_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = composer_link_popover_new (_data_->type);
	g_object_ref_sink (_data_->_tmp7_);
	_data_->_data64_->popover = _data_->_tmp7_;
	composer_link_popover_set_link_url (_data_->_data64_->popover, _data_->url);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data_->_data64_->popover, gtk_popover_get_type (), GtkPopover), "closed", (GCallback) ___lambda15__gtk_popover_closed, block64_data_ref (_data_->_data64_), (GClosureNotify) block64_data_unref, 0);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data_->_data64_->popover, gtk_widget_get_type (), GtkWidget), "hide", (GCallback) ___lambda16__gtk_widget_hide, block64_data_ref (_data_->_data64_), (GClosureNotify) block64_data_unref, 0);
	g_signal_connect_data (_data_->_data64_->popover, "link-activate", (GCallback) ___lambda18__composer_link_popover_link_activate, block64_data_ref (_data_->_data64_), (GClosureNotify) block64_data_unref, 0);
	g_signal_connect_data (_data_->_data64_->popover, "link-delete", (GCallback) ___lambda19__composer_link_popover_link_delete, block64_data_ref (_data_->_data64_), (GClosureNotify) block64_data_unref, 0);
	_data_->_tmp8_ = _g_object_ref0 (_data_->_data64_->popover);
	_data_->result = _data_->_tmp8_;
	block64_data_unref (_data_->_data64_);
	_data_->_data64_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
composer_editor_update_formatting_toolbar (ComposerEditor* self)
{
	GSimpleAction* show_formatting = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* text_format = NULL;
	GSimpleActionGroup* _tmp3_;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GSimpleAction* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	GtkRevealer* _tmp15_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), COMPOSER_EDITOR_ACTION_SHOW_FORMATTING);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	show_formatting = _tmp2_;
	_tmp3_ = self->actions;
	_tmp4_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_map_get_type (), GActionMap), COMPOSER_EDITOR_ACTION_TEXT_FORMAT);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	text_format = _tmp5_;
	_tmp7_ = text_format;
	_tmp8_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_get_type (), GAction));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_get_string (_tmp9_, NULL);
	_tmp11_ = g_strcmp0 (_tmp10_, "html") == 0;
	_g_variant_unref0 (_tmp9_);
	if (_tmp11_) {
		GSimpleAction* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp12_ = show_formatting;
		_tmp13_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_action_get_type (), GAction));
		_tmp14_ = _tmp13_;
		_tmp6_ = g_variant_get_boolean (_tmp14_);
		_g_variant_unref0 (_tmp14_);
	} else {
		_tmp6_ = FALSE;
	}
	_tmp15_ = self->priv->formatting;
	gtk_revealer_set_reveal_child (_tmp15_, _tmp6_);
	_g_object_unref0 (text_format);
	_g_object_unref0 (show_formatting);
}

static void
composer_editor_update_color_icon_data_free (gpointer _data)
{
	ComposerEditorUpdateColorIconData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerEditorUpdateColorIconData, _data_);
}

static void
composer_editor_update_color_icon (ComposerEditor* self,
                                   GdkRGBA* color,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ComposerEditorUpdateColorIconData* _data_;
	ComposerEditor* _tmp0_;
	GdkRGBA _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (color != NULL);
	_data_ = g_slice_new0 (ComposerEditorUpdateColorIconData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_editor_update_color_icon_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *color;
	_data_->color = _tmp1_;
	composer_editor_update_color_icon_co (_data_);
}

static void
composer_editor_update_color_icon_finish (ComposerEditor* self,
                                          GAsyncResult* _res_)
{
	ComposerEditorUpdateColorIconData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
composer_editor_update_color_icon_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ComposerEditorUpdateColorIconData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_editor_update_color_icon_co (_data_);
}

static gboolean
composer_editor_update_color_icon_co (ComposerEditorUpdateColorIconData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_icon_theme_get_default ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->theme = _data_->_tmp1_;
	_data_->_tmp2_ = gtk_icon_theme_lookup_icon (_data_->theme, "font-color-symbolic", 16, 0);
	_data_->icon = _data_->_tmp2_;
	memset (&_data_->_tmp3_, 0, sizeof (GdkRGBA));
	util_gtk_rgba ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1, &_data_->_tmp3_);
	_data_->fg_color = _data_->_tmp3_;
	_data_->_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	memset (&_data_->_tmp5_, 0, sizeof (GdkRGBA));
	gtk_style_context_lookup_color (_data_->_tmp4_, "theme_fg_color", &_data_->_tmp5_);
	_data_->fg_color = _data_->_tmp5_;
	{
		_data_->_tmp6_ = _data_->fg_color;
		_data_->_tmp7_ = _data_->color;
		_data_->_state_ = 1;
		gtk_icon_info_load_symbolic_async (_data_->icon, &_data_->_tmp6_, &_data_->_tmp7_, NULL, NULL, NULL, composer_editor_update_color_icon_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = gtk_icon_info_load_symbolic_finish (_data_->icon, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->self->priv->font_color_icon;
		g_object_set (_data_->_tmp9_, "pixbuf", _data_->pixbuf, NULL);
		_g_object_unref0 (_data_->pixbuf);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_warning ("composer-editor.vala:318: Could not load icon `font-color-symbolic`!");
		_data_->_tmp10_ = _data_->self->priv->font_color_icon;
		g_object_set (_data_->_tmp10_, "icon-name", "font-color-symbolic", NULL);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->icon);
		_g_object_unref0 (_data_->theme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->icon);
	_g_object_unref0 (_data_->theme);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GSimpleAction*
composer_editor_get_action (ComposerEditor* self,
                            const gchar* action_name)
{
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* result;
	g_return_val_if_fail (COMPOSER_IS_EDITOR (self), NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	_tmp0_ = self->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), action_name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
	result = _tmp2_;
	return result;
}

static void
composer_editor_on_button_press (ComposerEditor* self,
                                 gint n_press,
                                 gdouble x,
                                 gdouble y)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		ComposerEditor* self;
		self = _data65_->self;
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static void
___lambda24_ (Block65Data* _data65_,
              GObject* obj,
              GAsyncResult* res)
{
	ComposerEditor* self;
	ComposerLinkPopover* popover = NULL;
	ComposerLinkPopover* _tmp0_;
	ComposerWebView* _tmp1_;
	GdkRectangle _tmp2_;
	self = _data65_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	_tmp0_ = composer_editor_new_link_popover_finish (self, res);
	popover = _tmp0_;
	_tmp1_ = self->priv->_body;
	gtk_popover_set_relative_to (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _data65_->location;
	gtk_popover_set_pointing_to (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover), &_tmp2_);
	gtk_popover_popup (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover));
	_g_object_unref0 (popover);
}

static void
____lambda24__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda24_ (self, source_object, res);
	block65_data_unref (self);
}

static void
composer_editor_on_button_release (ComposerEditor* self,
                                   gint n_press,
                                   gdouble x,
                                   gdouble y)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp1_ = self->priv->pointer_url;
	if (_tmp1_ != NULL) {
		ApplicationConfiguration* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->config;
		_tmp3_ = application_configuration_get_compose_as_html (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block65Data* _data65_;
		const gchar* _tmp5_;
		_data65_ = g_slice_new0 (Block65Data);
		_data65_->_ref_count_ = 1;
		_data65_->self = g_object_ref (self);
		memset (&_data65_->location, 0, sizeof (GdkRectangle));
		_data65_->location.x = (gint) x;
		_data65_->location.y = (gint) y;
		_tmp5_ = self->priv->pointer_url;
		composer_editor_new_link_popover (self, COMPOSER_LINK_POPOVER_TYPE_EXISTING_LINK, _tmp5_, ____lambda24__gasync_ready_callback, block65_data_ref (_data65_));
		block65_data_unref (_data65_);
		_data65_ = NULL;
	}
}

static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		ComposerEditor* self;
		self = _data66_->self;
		_g_object_unref0 (_data66_->existing_text_entry);
		_g_object_unref0 (_data66_->existing_spelling);
		_g_object_unref0 (_data66_->context_menu);
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}

static gboolean
_vala_webkit_context_menu_action_array_contains (WebKitContextMenuAction * stack,
                                                 gssize stack_length,
                                                 const WebKitContextMenuAction needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
__lambda22_ (Block66Data* _data66_,
             const gchar* label,
             const gchar* name,
             GVariant* target,
             GMenu* section)
{
	ComposerEditor* self;
	WebKitContextMenuItem* _tmp0_;
	GMenu* _tmp3_;
	self = _data66_->self;
	g_return_if_fail ((section == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (section, g_menu_get_type ()));
	_tmp0_ = webkit_context_menu_last (_data66_->context_menu);
	if (_tmp0_ != NULL) {
		WebKitContextMenuItem* _tmp1_;
		WebKitContextMenuItem* _tmp2_;
		_tmp1_ = webkit_context_menu_item_new_separator ();
		g_object_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		webkit_context_menu_append (_data66_->context_menu, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->context_menu_webkit_spelling;
	if (section == _tmp3_) {
		{
			GeeList* _item_list = NULL;
			GeeList* _tmp4_;
			gint _item_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _item_index = 0;
			_tmp4_ = _data66_->existing_spelling;
			_item_list = _tmp4_;
			_tmp5_ = _item_list;
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp7_ = _tmp6_;
			_item_size = _tmp7_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				WebKitContextMenuItem* item = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				WebKitContextMenuItem* _tmp12_;
				_item_index = _item_index + 1;
				_tmp8_ = _item_index;
				_tmp9_ = _item_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _item_list;
				_tmp11_ = gee_list_get (_tmp10_, _item_index);
				item = (WebKitContextMenuItem*) _tmp11_;
				_tmp12_ = item;
				webkit_context_menu_append (_data66_->context_menu, _tmp12_);
				_g_object_unref0 (item);
			}
		}
	} else {
		GMenu* _tmp13_;
		_tmp13_ = self->priv->context_menu_webkit_text_entry;
		if (section == _tmp13_) {
			{
				GeeList* _item_list = NULL;
				GeeList* _tmp14_;
				gint _item_size = 0;
				GeeList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _item_index = 0;
				_tmp14_ = _data66_->existing_text_entry;
				_item_list = _tmp14_;
				_tmp15_ = _item_list;
				_tmp16_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp17_ = _tmp16_;
				_item_size = _tmp17_;
				_item_index = -1;
				while (TRUE) {
					gint _tmp18_;
					gint _tmp19_;
					WebKitContextMenuItem* item = NULL;
					GeeList* _tmp20_;
					gpointer _tmp21_;
					WebKitContextMenuItem* _tmp22_;
					_item_index = _item_index + 1;
					_tmp18_ = _item_index;
					_tmp19_ = _item_size;
					if (!(_tmp18_ < _tmp19_)) {
						break;
					}
					_tmp20_ = _item_list;
					_tmp21_ = gee_list_get (_tmp20_, _item_index);
					item = (WebKitContextMenuItem*) _tmp21_;
					_tmp22_ = item;
					webkit_context_menu_append (_data66_->context_menu, _tmp22_);
					_g_object_unref0 (item);
				}
			}
		} else {
			GMenu* _tmp23_;
			_tmp23_ = self->priv->context_menu_rich_text;
			if (section == _tmp23_) {
				ComposerWebView* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = self->priv->_body;
				_tmp25_ = composer_web_view_get_is_rich_text (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_) {
					composer_editor_append_menu_section (self, _data66_->context_menu, section);
				}
			} else {
				GMenu* _tmp27_;
				_tmp27_ = self->priv->context_menu_plain_text;
				if (section == _tmp27_) {
					ComposerWebView* _tmp28_;
					gboolean _tmp29_;
					gboolean _tmp30_;
					_tmp28_ = self->priv->_body;
					_tmp29_ = composer_web_view_get_is_rich_text (_tmp28_);
					_tmp30_ = _tmp29_;
					if (!_tmp30_) {
						composer_editor_append_menu_section (self, _data66_->context_menu, section);
					}
				} else {
					GMenu* _tmp31_;
					_tmp31_ = self->priv->context_menu_inspector;
					if (section == _tmp31_) {
						ApplicationConfiguration* _tmp32_;
						gboolean _tmp33_;
						gboolean _tmp34_;
						_tmp32_ = self->priv->config;
						_tmp33_ = application_configuration_get_enable_inspector (_tmp32_);
						_tmp34_ = _tmp33_;
						if (_tmp34_) {
							composer_editor_append_menu_section (self, _data66_->context_menu, section);
						}
					} else {
						composer_editor_append_menu_section (self, _data66_->context_menu, section);
					}
				}
			}
		}
	}
}

static void
___lambda22__util_gtk_menu_foreach_func (const gchar* label,
                                         const gchar* action_name,
                                         GVariant* target,
                                         GMenu* section,
                                         gpointer self)
{
	__lambda22_ (self, label, action_name, target, section);
}

static gboolean
composer_editor_on_context_menu (ComposerEditor* self,
                                 WebKitWebView* view,
                                 WebKitContextMenu* context_menu,
                                 GdkEvent* event,
                                 WebKitHitTestResult* hit_test_result)
{
	Block66Data* _data66_;
	WebKitContextMenu* _tmp0_;
	static const WebKitContextMenuAction SPELLING_ACTIONS[5] = {WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS, WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND, WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING, WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR, WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING};
	static const WebKitContextMenuAction TEXT_INPUT_ACTIONS[3] = {WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS, WEBKIT_CONTEXT_MENU_ACTION_UNICODE, WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI};
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GList* _tmp3_;
	GMenu* _tmp11_;
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_EDITOR (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (view, webkit_web_view_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context_menu, webkit_context_menu_get_type ()), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hit_test_result, webkit_hit_test_result_get_type ()), FALSE);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (context_menu);
	_g_object_unref0 (_data66_->context_menu);
	_data66_->context_menu = _tmp0_;
	_tmp1_ = gee_linked_list_new (webkit_context_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data66_->existing_spelling = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	_tmp2_ = gee_linked_list_new (webkit_context_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data66_->existing_text_entry = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
	_tmp3_ = webkit_context_menu_get_items (_data66_->context_menu);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp3_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			WebKitContextMenuItem* _tmp4_;
			WebKitContextMenuItem* item = NULL;
			_tmp4_ = _g_object_ref0 ((WebKitContextMenuItem*) item_it->data);
			item = _tmp4_;
			{
				WebKitContextMenuItem* _tmp5_;
				_tmp5_ = item;
				if (_vala_webkit_context_menu_action_array_contains (SPELLING_ACTIONS, G_N_ELEMENTS (SPELLING_ACTIONS), webkit_context_menu_item_get_stock_action (_tmp5_))) {
					GeeList* _tmp6_;
					WebKitContextMenuItem* _tmp7_;
					_tmp6_ = _data66_->existing_spelling;
					_tmp7_ = item;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), _tmp7_);
				} else {
					WebKitContextMenuItem* _tmp8_;
					_tmp8_ = item;
					if (_vala_webkit_context_menu_action_array_contains (TEXT_INPUT_ACTIONS, G_N_ELEMENTS (TEXT_INPUT_ACTIONS), webkit_context_menu_item_get_stock_action (_tmp8_))) {
						GeeList* _tmp9_;
						WebKitContextMenuItem* _tmp10_;
						_tmp9_ = _data66_->existing_text_entry;
						_tmp10_ = item;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_);
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	webkit_context_menu_remove_all (_data66_->context_menu);
	_tmp11_ = self->priv->context_menu_model;
	util_gtk_menu_foreach (_tmp11_, ___lambda22__util_gtk_menu_foreach_func, _data66_);
	result = GDK_EVENT_PROPAGATE;
	block66_data_unref (_data66_);
	_data66_ = NULL;
	return result;
}

static Block67Data*
block67_data_ref (Block67Data* _data67_)
{
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}

static void
block67_data_unref (void * _userdata_)
{
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		ComposerEditor* self;
		self = _data67_->self;
		_g_object_unref0 (_data67_->context_menu);
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda23_ (Block67Data* _data67_,
             const gchar* label,
             const gchar* name,
             GVariant* target,
             GMenu* section)
{
	ComposerEditor* self;
	gchar* simple_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GSimpleAction* action = NULL;
	const gchar* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	self = _data67_->self;
	g_return_if_fail ((section == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (section, g_menu_get_type ()));
	_tmp0_ = g_strdup (name);
	simple_name = _tmp0_;
	_tmp1_ = simple_name;
	if (string_contains (_tmp1_, ".")) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = simple_name;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ".", 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_tmp6_ = _tmp5_[1];
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (simple_name);
		simple_name = _tmp7_;
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp8_ = simple_name;
	_tmp9_ = composer_editor_get_action (self, _tmp8_);
	action = _tmp9_;
	_tmp10_ = action;
	if (_tmp10_ != NULL) {
		GSimpleAction* _tmp11_;
		WebKitContextMenuItem* _tmp12_;
		WebKitContextMenuItem* _tmp13_;
		_tmp11_ = action;
		_tmp12_ = webkit_context_menu_item_new_from_gaction (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_action_get_type (), GAction), label, target);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		webkit_context_menu_append (_data67_->context_menu, _tmp13_);
		_g_object_unref0 (_tmp13_);
	} else {
		g_warning ("composer-editor.vala:450: Unknown action: %s/%s", name, label);
	}
	_g_object_unref0 (action);
	_g_free0 (simple_name);
}

static void
___lambda23__util_gtk_menu_foreach_func (const gchar* label,
                                         const gchar* action_name,
                                         GVariant* target,
                                         GMenu* section,
                                         gpointer self)
{
	__lambda23_ (self, label, action_name, target, section);
}

static inline void
composer_editor_append_menu_section (ComposerEditor* self,
                                     WebKitContextMenu* context_menu,
                                     GMenu* section)
{
	Block67Data* _data67_;
	WebKitContextMenu* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context_menu, webkit_context_menu_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (section, g_menu_get_type ()));
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_data67_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (context_menu);
	_g_object_unref0 (_data67_->context_menu);
	_data67_->context_menu = _tmp0_;
	util_gtk_menu_foreach (section, ___lambda23__util_gtk_menu_foreach_func, _data67_);
	block67_data_unref (_data67_);
	_data67_ = NULL;
}

static GVariant*
_variant_new9 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new10 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new11 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new12 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
composer_editor_on_cursor_context_changed (ComposerEditor* self,
                                           ComposerWebViewEditContext* context)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GVariant* _tmp9_;
	GdkRGBA _tmp10_ = {0};
	GdkRGBA _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (context));
	_tmp1_ = composer_web_view_edit_context_get_is_link (context);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = composer_web_view_edit_context_get_link_url (context);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp5_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->cursor_url);
	self->priv->cursor_url = _tmp5_;
	composer_editor_update_cursor_actions (self);
	_tmp6_ = self->actions;
	_tmp7_ = composer_web_view_edit_context_get_font_family (context);
	_tmp8_ = _tmp7_;
	_tmp9_ = _variant_new9 (_tmp8_);
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_FONT_FAMILY, _tmp9_);
	_g_variant_unref0 (_tmp9_);
	composer_web_view_edit_context_get_font_color (context, &_tmp10_);
	_tmp11_ = _tmp10_;
	composer_editor_update_color_icon (self, &_tmp11_, NULL, NULL);
	_tmp12_ = composer_web_view_edit_context_get_font_size (context);
	_tmp13_ = _tmp12_;
	if (_tmp13_ < ((guint) 11)) {
		GSimpleActionGroup* _tmp14_;
		GVariant* _tmp15_;
		_tmp14_ = self->actions;
		_tmp15_ = _variant_new10 ("small");
		g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_FONT_SIZE, _tmp15_);
		_g_variant_unref0 (_tmp15_);
	} else {
		guint _tmp16_;
		guint _tmp17_;
		_tmp16_ = composer_web_view_edit_context_get_font_size (context);
		_tmp17_ = _tmp16_;
		if (_tmp17_ > ((guint) 20)) {
			GSimpleActionGroup* _tmp18_;
			GVariant* _tmp19_;
			_tmp18_ = self->actions;
			_tmp19_ = _variant_new11 ("large");
			g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_FONT_SIZE, _tmp19_);
			_g_variant_unref0 (_tmp19_);
		} else {
			GSimpleActionGroup* _tmp20_;
			GVariant* _tmp21_;
			_tmp20_ = self->actions;
			_tmp21_ = _variant_new12 ("medium");
			g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_FONT_SIZE, _tmp21_);
			_g_variant_unref0 (_tmp21_);
		}
	}
}

static void
composer_editor_on_mouse_target_changed (ComposerEditor* self,
                                         WebKitWebView* web_view,
                                         WebKitHitTestResult* hit_test,
                                         guint modifiers)
{
	gboolean copy_link_enabled = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (web_view, webkit_web_view_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hit_test, webkit_hit_test_result_get_type ()));
	copy_link_enabled = webkit_hit_test_result_context_is_link (hit_test);
	if (copy_link_enabled) {
		const gchar* _tmp1_;
		_tmp1_ = webkit_hit_test_result_get_link_uri (hit_test);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp2_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->pointer_url);
	self->priv->pointer_url = _tmp2_;
	_tmp4_ = self->priv->pointer_url;
	_tmp3_ = _tmp4_;
	if (_tmp3_ == NULL) {
		_tmp3_ = "";
	}
	_tmp5_ = self->priv->message_overlay_label;
	gtk_label_set_label (_tmp5_, _tmp3_);
	_tmp6_ = self->priv->message_overlay_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), copy_link_enabled);
	_tmp7_ = composer_editor_get_action (self, COMPOSER_EDITOR_ACTION_COPY_LINK);
	_tmp8_ = _tmp7_;
	g_simple_action_set_enabled (_tmp8_, copy_link_enabled);
	_g_object_unref0 (_tmp8_);
}

static GVariant*
_variant_new13 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new14 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new15 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new16 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
composer_editor_on_typing_attributes_changed (ComposerEditor* self)
{
	guint mask = 0U;
	ComposerWebView* _tmp0_;
	WebKitEditorState* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GVariant* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GVariant* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GVariant* _tmp7_;
	GSimpleActionGroup* _tmp8_;
	GVariant* _tmp9_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	_tmp1_ = webkit_web_view_get_editor_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, webkit_web_view_get_type (), WebKitWebView));
	mask = webkit_editor_state_get_typing_attributes (_tmp1_);
	_tmp2_ = self->actions;
	_tmp3_ = _variant_new13 ((mask & WEBKIT_EDITOR_TYPING_ATTRIBUTE_BOLD) == ((guint) WEBKIT_EDITOR_TYPING_ATTRIBUTE_BOLD));
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_BOLD, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = self->actions;
	_tmp5_ = _variant_new14 ((mask & WEBKIT_EDITOR_TYPING_ATTRIBUTE_ITALIC) == ((guint) WEBKIT_EDITOR_TYPING_ATTRIBUTE_ITALIC));
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_ITALIC, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = self->actions;
	_tmp7_ = _variant_new15 ((mask & WEBKIT_EDITOR_TYPING_ATTRIBUTE_UNDERLINE) == ((guint) WEBKIT_EDITOR_TYPING_ATTRIBUTE_UNDERLINE));
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_UNDERLINE, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_tmp8_ = self->actions;
	_tmp9_ = _variant_new16 ((mask & WEBKIT_EDITOR_TYPING_ATTRIBUTE_STRIKETHROUGH) == ((guint) WEBKIT_EDITOR_TYPING_ATTRIBUTE_STRIKETHROUGH));
	g_action_group_change_action_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_action_group_get_type (), GActionGroup), COMPOSER_EDITOR_ACTION_STRIKETHROUGH, _tmp9_);
	_g_variant_unref0 (_tmp9_);
}

/** Shows and starts pulsing the progress meter. */
static void
composer_editor_on_background_work_timeout (ComposerEditor* self)
{
	GtkProgressBar* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	GtkProgressBar* _tmp2_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->background_progress;
	gtk_progress_bar_set_fraction (_tmp0_, 0.0);
	_tmp1_ = self->priv->background_work_pulse;
	geary_timeout_manager_start (_tmp1_);
	_tmp2_ = self->priv->background_progress;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
}

static GVariant*
_variant_new17 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
composer_editor_on_text_format (ComposerEditor* self,
                                GSimpleAction* action,
                                GVariant* new_state)
{
	gboolean compose_as_html = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GSimpleAction* show_formatting = NULL;
	GSimpleAction* _tmp7_;
	ComposerWebView* _tmp8_;
	ApplicationConfiguration* _tmp9_;
	GtkMenuButton* _tmp10_;
	GtkPopover* _tmp11_;
	GtkPopover* _tmp12_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail ((action == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_variant_get_string (new_state, NULL);
	compose_as_html = g_strcmp0 (_tmp0_, "html") == 0;
	_tmp1_ = g_variant_get_string (new_state, NULL);
	_tmp2_ = _variant_new17 (_tmp1_);
	g_simple_action_set_state (action, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	{
		const gchar** html_action_collection = NULL;
		gint html_action_collection_length1 = 0;
		gint _html_action_collection_size_ = 0;
		gint html_action_it = 0;
		html_action_collection = COMPOSER_EDITOR_HTML_ACTIONS;
		html_action_collection_length1 = G_N_ELEMENTS (COMPOSER_EDITOR_HTML_ACTIONS);
		for (html_action_it = 0; html_action_it < html_action_collection_length1; html_action_it = html_action_it + 1) {
			gchar* _tmp3_;
			gchar* html_action = NULL;
			_tmp3_ = g_strdup (html_action_collection[html_action_it]);
			html_action = _tmp3_;
			{
				const gchar* _tmp4_;
				GSimpleAction* _tmp5_;
				GSimpleAction* _tmp6_;
				_tmp4_ = html_action;
				_tmp5_ = composer_editor_get_action (self, _tmp4_);
				_tmp6_ = _tmp5_;
				g_simple_action_set_enabled (_tmp6_, compose_as_html);
				_g_object_unref0 (_tmp6_);
				_g_free0 (html_action);
			}
		}
	}
	composer_editor_update_cursor_actions (self);
	_tmp7_ = composer_editor_get_action (self, COMPOSER_EDITOR_ACTION_SHOW_FORMATTING);
	show_formatting = _tmp7_;
	g_simple_action_set_enabled (show_formatting, compose_as_html);
	composer_editor_update_formatting_toolbar (self);
	_tmp8_ = self->priv->_body;
	composer_web_view_set_rich_text (_tmp8_, compose_as_html);
	_tmp9_ = self->priv->config;
	application_configuration_set_compose_as_html (_tmp9_, compose_as_html);
	_tmp10_ = self->priv->more_options_button;
	_tmp11_ = gtk_menu_button_get_popover (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_popover_popdown (_tmp12_);
	_g_object_unref0 (show_formatting);
}

static void
composer_editor_on_show_formatting (ComposerEditor* self,
                                    GSimpleAction* action,
                                    GVariant* new_state)
{
	gboolean show_formatting = FALSE;
	ApplicationConfiguration* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail ((action == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	show_formatting = g_variant_get_boolean (new_state);
	_tmp0_ = self->priv->config;
	application_configuration_set_formatting_toolbar_visible (_tmp0_, show_formatting);
	g_simple_action_set_state (action, new_state);
	composer_editor_update_formatting_toolbar (self);
	util_gtk_rgba ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, &_tmp1_);
	composer_editor_update_color_icon (self, &_tmp1_, NULL, NULL);
}

static void
composer_editor_on_select_dictionary (ComposerEditor* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = self->priv->select_dictionary_button;
	gtk_toggle_button_toggled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
}

static void
composer_editor_on_command_state_changed (ComposerEditor* self,
                                          gboolean can_undo,
                                          gboolean can_redo)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = composer_editor_get_action (self, ACTION_EDIT_UNDO);
	_tmp1_ = _tmp0_;
	g_simple_action_set_enabled (_tmp1_, can_undo);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = composer_editor_get_action (self, ACTION_EDIT_REDO);
	_tmp3_ = _tmp2_;
	g_simple_action_set_enabled (_tmp3_, can_redo);
	_g_object_unref0 (_tmp3_);
}

static void
composer_editor_on_selection_changed (ComposerEditor* self)
{
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	composer_editor_update_cursor_actions (self);
}

static void
composer_editor_on_undo (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_undo (_tmp0_);
}

static void
composer_editor_on_redo (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_redo (_tmp0_);
}

static void
composer_editor_on_cut (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_cut_clipboard (_tmp0_);
}

static void
composer_editor_on_copy (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	components_web_view_copy_clipboard (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
}

static void
composer_editor_on_copy_link (ComposerEditor* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	GtkClipboard* c = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	c = _tmp1_;
	_tmp2_ = self->priv->pointer_url;
	gtk_clipboard_set_text (c, _tmp2_, -1);
	gtk_clipboard_store (c);
	_g_object_unref0 (c);
}

static void
composer_editor_on_paste (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	_tmp1_ = composer_web_view_get_is_rich_text (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp3_;
		GtkClipboard* _tmp4_;
		gboolean has_image = FALSE;
		GtkClipboard* _tmp5_;
		_tmp3_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		clipboard = _tmp4_;
		_tmp5_ = clipboard;
		has_image = gtk_clipboard_wait_is_image_available (_tmp5_);
		if (has_image) {
			g_signal_emit (self, composer_editor_signals[COMPOSER_EDITOR_INSERT_IMAGE_SIGNAL], 0, TRUE);
		} else {
			ComposerWebView* _tmp6_;
			_tmp6_ = self->priv->_body;
			composer_web_view_paste_rich_text (_tmp6_);
		}
		_g_object_unref0 (clipboard);
	} else {
		ComposerWebView* _tmp7_;
		_tmp7_ = self->priv->_body;
		composer_web_view_paste_plain_text (_tmp7_);
	}
}

static void
composer_editor_on_paste_without_formatting (ComposerEditor* self,
                                             GSimpleAction* action,
                                             GVariant* param)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = self->priv->_body;
	composer_web_view_paste_plain_text (_tmp0_);
}

static void
composer_editor_on_select_all (ComposerEditor* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = self->priv->_body;
	components_web_view_select_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
}

static void
composer_editor_on_indent (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_indent_line (_tmp0_);
}

static void
composer_editor_on_olist (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_insert_olist (_tmp0_);
}

static void
composer_editor_on_ulist (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	composer_web_view_insert_ulist (_tmp0_);
}

static void
composer_editor_on_justify (ComposerEditor* self,
                            GAction* action,
                            GVariant* param)
{
	ComposerWebView* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()));
	_tmp0_ = self->priv->_body;
	_tmp1_ = g_variant_get_string (param, NULL);
	_tmp2_ = g_strconcat ("justify", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, webkit_web_view_get_type (), WebKitWebView), _tmp3_);
	_g_free0 (_tmp3_);
}

static void
composer_editor_on_insert_image (ComposerEditor* self)
{
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_signal_emit (self, composer_editor_signals[COMPOSER_EDITOR_INSERT_IMAGE_SIGNAL], 0, FALSE);
}

static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		ComposerEditor* self;
		self = _data68_->self;
		_g_object_unref0 (_data68_->style);
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
__lambda21_ (Block68Data* _data68_)
{
	ComposerEditor* self;
	ComposerWebView* _tmp0_;
	self = _data68_->self;
	_tmp0_ = self->priv->_body;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), "notify::has-selection", (GCallback) _composer_editor_on_selection_changed_g_object_notify, self, 0);
	gtk_style_context_set_state (_data68_->style, GTK_STATE_FLAG_NORMAL);
}

static void
___lambda21__gtk_popover_closed (GtkPopover* _sender,
                                 gpointer self)
{
	__lambda21_ (self);
}

static void
__lambda20_ (ComposerEditor* self,
             GObject* obj,
             GAsyncResult* res)
{
	Block68Data* _data68_;
	ComposerLinkPopover* popover = NULL;
	ComposerLinkPopover* _tmp0_;
	GtkButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	ComposerWebView* _tmp4_;
	guint _tmp5_;
	GQuark _tmp6_;
	GtkButton* _tmp7_;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	_tmp0_ = composer_editor_new_link_popover_finish (self, res);
	popover = _tmp0_;
	_tmp1_ = self->priv->insert_link_button;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data68_->style = _tmp3_;
	_tmp4_ = self->priv->_body;
	g_signal_parse_name ("notify::has-selection", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _composer_editor_on_selection_changed_g_object_notify, self);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover), "closed", (GCallback) ___lambda21__gtk_popover_closed, block68_data_ref (_data68_), (GClosureNotify) block68_data_unref, 0);
	_tmp7_ = self->priv->insert_link_button;
	gtk_popover_set_relative_to (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	gtk_popover_popup (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover));
	gtk_style_context_set_state (_data68_->style, GTK_STATE_FLAG_ACTIVE);
	_g_object_unref0 (popover);
	block68_data_unref (_data68_);
	_data68_ = NULL;
}

static void
___lambda20__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda20_ ((ComposerEditor*) self, source_object, res);
	g_object_unref (self);
}

static void
composer_editor_on_insert_link (ComposerEditor* self)
{
	ComposerLinkPopoverType type = 0;
	gchar* url = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	type = COMPOSER_LINK_POPOVER_TYPE_NEW_LINK;
	_tmp0_ = g_strdup ("https://");
	url = _tmp0_;
	_tmp1_ = self->priv->cursor_url;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		type = COMPOSER_LINK_POPOVER_TYPE_EXISTING_LINK;
		_tmp2_ = self->priv->cursor_url;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (url);
		url = _tmp3_;
	}
	_tmp4_ = url;
	composer_editor_new_link_popover (self, type, _tmp4_, ___lambda20__gasync_ready_callback, g_object_ref (self));
	_g_free0 (url);
}

static void
composer_editor_on_remove_format (ComposerEditor* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	ComposerWebView* _tmp0_;
	ComposerWebView* _tmp1_;
	ComposerWebView* _tmp2_;
	ComposerWebView* _tmp3_;
	ComposerWebView* _tmp4_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = self->priv->_body;
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, webkit_web_view_get_type (), WebKitWebView), "removeformat");
	_tmp1_ = self->priv->_body;
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, webkit_web_view_get_type (), WebKitWebView), "removeparaformat");
	_tmp2_ = self->priv->_body;
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, webkit_web_view_get_type (), WebKitWebView), "unlink");
	_tmp3_ = self->priv->_body;
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, webkit_web_view_get_type (), WebKitWebView), "backcolor", "#ffffff");
	_tmp4_ = self->priv->_body;
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, webkit_web_view_get_type (), WebKitWebView), "forecolor", "#000000");
}

static GVariant*
_variant_new18 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
composer_editor_on_font_family (ComposerEditor* self,
                                GSimpleAction* action,
                                GVariant* param)
{
	gchar* font = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ComposerWebView* _tmp2_;
	GVariant* _tmp3_;
	GtkStack* _tmp4_;
	GtkMenuButton* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	font = _tmp1_;
	_tmp2_ = self->priv->_body;
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, webkit_web_view_get_type (), WebKitWebView), "fontname", font);
	_tmp3_ = _variant_new18 (font);
	g_simple_action_set_state (action, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = self->priv->font_button_stack;
	gtk_stack_set_visible_child_name (_tmp4_, font);
	_tmp5_ = self->priv->font_button;
	_tmp6_ = gtk_menu_button_get_popover (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_popover_popdown (_tmp7_);
	_g_free0 (font);
}

static GVariant*
_variant_new19 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
composer_editor_on_font_size (ComposerEditor* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	gchar* size = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ComposerWebView* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GVariant* _tmp9_;
	GtkMenuButton* _tmp10_;
	GtkPopover* _tmp11_;
	GtkPopover* _tmp12_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_strdup ("");
	size = _tmp0_;
	_tmp1_ = g_variant_get_string (param, NULL);
	if (g_strcmp0 (_tmp1_, "small") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("1");
		_g_free0 (size);
		size = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = g_variant_get_string (param, NULL);
		if (g_strcmp0 (_tmp3_, "medium") == 0) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("3");
			_g_free0 (size);
			size = _tmp4_;
		} else {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("7");
			_g_free0 (size);
			size = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_body;
	_tmp7_ = size;
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, webkit_web_view_get_type (), WebKitWebView), "fontsize", _tmp7_);
	_tmp8_ = g_variant_get_string (param, NULL);
	_tmp9_ = _variant_new19 (_tmp8_);
	g_simple_action_set_state (action, _tmp9_);
	_g_variant_unref0 (_tmp9_);
	_tmp10_ = self->priv->font_size_button;
	_tmp11_ = gtk_menu_button_get_popover (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_popover_popdown (_tmp12_);
	_g_free0 (size);
}

static void
composer_editor_on_select_color (ComposerEditor* self)
{
	GtkColorChooserDialog* dialog = NULL;
	GtkWidget* _tmp0_;
	GtkColorChooserDialog* _tmp1_;
	GtkColorChooserDialog* _tmp2_;
	GtkColorChooserDialog* _tmp9_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = (GtkColorChooserDialog*) gtk_color_chooser_dialog_new (_ ("Select Color"), G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	if (gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_dialog_get_type (), GtkDialog)) == ((gint) GTK_RESPONSE_OK)) {
		GdkRGBA rgba = {0};
		GtkColorChooserDialog* _tmp3_;
		GdkRGBA _tmp4_ = {0};
		ComposerWebView* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GdkRGBA _tmp8_;
		_tmp3_ = dialog;
		gtk_color_chooser_get_rgba (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_color_chooser_get_type (), GtkColorChooser), &_tmp4_);
		rgba = _tmp4_;
		_tmp5_ = self->priv->_body;
		_tmp6_ = gdk_rgba_to_string (&rgba);
		_tmp7_ = _tmp6_;
		webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, webkit_web_view_get_type (), WebKitWebView), "forecolor", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = rgba;
		composer_editor_update_color_icon (self, &_tmp8_, NULL, NULL);
	}
	_tmp9_ = dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}

static void
composer_editor_on_action (ComposerEditor* self,
                           GSimpleAction* action,
                           GVariant* param)
{
	gchar** prefixed_action_name = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint prefixed_action_name_length1;
	gint _prefixed_action_name_size_;
	gchar* action_name = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	ComposerWebView* _tmp5_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_action_get_name (G_TYPE_CHECK_INSTANCE_CAST (action, g_action_get_type (), GAction));
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	prefixed_action_name = _tmp2_;
	prefixed_action_name_length1 = _vala_array_length (_tmp1_);
	_prefixed_action_name_size_ = prefixed_action_name_length1;
	_tmp3_ = prefixed_action_name[prefixed_action_name_length1 - 1];
	_tmp4_ = g_strdup (_tmp3_);
	action_name = _tmp4_;
	_tmp5_ = self->priv->_body;
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, webkit_web_view_get_type (), WebKitWebView), action_name);
	_g_free0 (action_name);
	prefixed_action_name = (_vala_array_free (prefixed_action_name, prefixed_action_name_length1, (GDestroyNotify) g_free), NULL);
}

static GVariant*
_variant_new20 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
composer_editor_on_toggle_action (ComposerEditor* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	g_return_if_fail ((action == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (action, g_action_get_type (), GAction));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _variant_new20 (!g_variant_get_boolean (_tmp2_));
	g_signal_emit_by_name (action, "change-state", _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_g_variant_unref0 (_tmp2_);
}

static void
composer_editor_on_open_inspector (ComposerEditor* self)
{
	ComposerWebView* _tmp0_;
	WebKitWebInspector* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EDITOR (self));
	_tmp0_ = self->priv->_body;
	_tmp1_ = webkit_web_view_get_inspector (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, webkit_web_view_get_type (), WebKitWebView));
	webkit_web_inspector_show (_tmp1_);
}

static void
composer_editor_class_init (ComposerEditorClass * klass,
                            gpointer klass_data)
{
	composer_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerEditor_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) composer_editor_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_composer_editor_set_property;
	G_OBJECT_CLASS (klass)->finalize = composer_editor_finalize;
	/** The email body view. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EDITOR_BODY_PROPERTY, composer_editor_properties[COMPOSER_EDITOR_BODY_PROPERTY] = g_param_spec_object ("body", "body", "body", COMPOSER_TYPE_WEB_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/composer-editor.ui");
	composer_editor_signals[COMPOSER_EDITOR_INSERT_IMAGE_SIGNAL] = g_signal_new ("insert-image", COMPOSER_TYPE_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_message_attach_button", FALSE, G_STRUCT_OFFSET (ComposerEditor, new_message_attach_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_attach_buttons", FALSE, G_STRUCT_OFFSET (ComposerEditor, conversation_attach_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "body_container", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, body_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "message_overlay_label", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, message_overlay_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_bar_box", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, action_bar_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "insert_link_button", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, insert_link_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_dictionary_button", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, select_dictionary_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_label", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, info_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "background_progress", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, background_progress));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "formatting", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, formatting));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_button", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, font_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_button_stack", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, font_button_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_size_button", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, font_size_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_color_icon", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, font_color_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "more_options_button", FALSE, ComposerEditor_private_offset + G_STRUCT_OFFSET (ComposerEditorPrivate, more_options_button));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "geary-composer-editor");
}

static void
composer_editor_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                     gpointer iface_data)
{
	composer_editor_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
composer_editor_instance_init (ComposerEditor * self,
                               gpointer klass)
{
	GSimpleActionGroup* _tmp0_;
	self->priv = composer_editor_get_instance_private (self);
	_tmp0_ = g_simple_action_group_new ();
	self->actions = _tmp0_;
	self->priv->pointer_url = NULL;
	self->priv->cursor_url = NULL;
	self->priv->show_background_work_timeout = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
composer_editor_finalize (GObject * obj)
{
	ComposerEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_TYPE_EDITOR, ComposerEditor);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->_body);
	_g_object_unref0 (self->actions);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->pointer_url);
	_g_free0 (self->priv->cursor_url);
	_g_object_unref0 (self->priv->show_background_work_timeout);
	_g_object_unref0 (self->priv->background_work_pulse);
	_g_object_unref0 (self->priv->context_menu_model);
	_g_object_unref0 (self->priv->context_menu_rich_text);
	_g_object_unref0 (self->priv->context_menu_plain_text);
	_g_object_unref0 (self->priv->context_menu_webkit_spelling);
	_g_object_unref0 (self->priv->context_menu_webkit_text_entry);
	_g_object_unref0 (self->priv->context_menu_inspector);
	_g_object_unref0 (self->priv->click_gesture);
	G_OBJECT_CLASS (composer_editor_parent_class)->finalize (obj);
}

/**
 * A widget for editing the body of an email message.
 */
static GType
composer_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerEditor), 0, (GInstanceInitFunc) composer_editor_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) composer_editor_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType composer_editor_type_id;
	composer_editor_type_id = g_type_register_static (gtk_grid_get_type (), "ComposerEditor", &g_define_type_info, 0);
	g_type_add_interface_static (composer_editor_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ComposerEditor_private_offset = g_type_add_instance_private (composer_editor_type_id, sizeof (ComposerEditorPrivate));
	return composer_editor_type_id;
}

GType
composer_editor_get_type (void)
{
	static volatile gsize composer_editor_type_id__once = 0;
	if (g_once_init_enter (&composer_editor_type_id__once)) {
		GType composer_editor_type_id;
		composer_editor_type_id = composer_editor_get_type_once ();
		g_once_init_leave (&composer_editor_type_id__once, composer_editor_type_id);
	}
	return composer_editor_type_id__once;
}

static void
_vala_composer_editor_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ComposerEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EDITOR, ComposerEditor);
	switch (property_id) {
		case COMPOSER_EDITOR_BODY_PROPERTY:
		g_value_set_object (value, composer_editor_get_body (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_composer_editor_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ComposerEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EDITOR, ComposerEditor);
	switch (property_id) {
		case COMPOSER_EDITOR_BODY_PROPERTY:
		composer_editor_set_body (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

