/* conversation-web-view.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-web-view.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2017-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <webkit2/webkit2.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <float.h>
#include <math.h>

#define CONVERSATION_WEB_VIEW_DECEPTIVE_LINK_CLICKED "deceptive_link_clicked"

enum  {
	CONVERSATION_WEB_VIEW_0_PROPERTY,
	CONVERSATION_WEB_VIEW_NUM_PROPERTIES
};
static GParamSpec* conversation_web_view_properties[CONVERSATION_WEB_VIEW_NUM_PROPERTIES];
#define _webkit_user_script_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_script_unref (var), NULL)))
#define _webkit_user_style_sheet_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_style_sheet_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _util_js_callable_unref0(var) ((var == NULL) ? NULL : (var = (util_js_callable_unref (var), NULL)))
typedef struct _ConversationWebViewGetSelectionForFindData ConversationWebViewGetSelectionForFindData;
typedef struct _ConversationWebViewGetSelectionForQuotingData ConversationWebViewGetSelectionForQuotingData;
typedef struct _ConversationWebViewGetAnchorTargetYData ConversationWebViewGetAnchorTargetYData;
typedef struct _Block99Data Block99Data;
typedef struct _ConversationWebViewHighlightSearchTermsData ConversationWebViewHighlightSearchTermsData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
enum  {
	CONVERSATION_WEB_VIEW_DECEPTIVE_LINK_CLICKED_SIGNAL,
	CONVERSATION_WEB_VIEW_NUM_SIGNALS
};
static guint conversation_web_view_signals[CONVERSATION_WEB_VIEW_NUM_SIGNALS] = {0};

struct _ConversationWebViewGetSelectionForFindData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationWebView* self;
	gchar* result;
	gchar* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ConversationWebViewGetSelectionForQuotingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationWebView* self;
	gchar* result;
	gchar* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ConversationWebViewGetAnchorTargetYData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationWebView* self;
	gchar* anchor_body;
	gint* result;
	gint* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	UtilJSCallable* _tmp4_;
	gpointer _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_;
	GError* _inner_error0_;
};

struct _Block99Data {
	int _ref_count_;
	ConversationWebView* self;
	guint found;
	gboolean finished;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _ConversationWebViewHighlightSearchTermsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationWebView* self;
	GeeCollection* terms;
	GCancellable* cancellable;
	guint result;
	Block99Data* _data99_;
	WebKitFindController* controller;
	WebKitFindController* _tmp0_;
	WebKitFindController* _tmp1_;
	WebKitFindController* _tmp2_;
	gulong found_handler;
	WebKitFindController* _tmp3_;
	gulong _tmp4_;
	gulong not_found_handler;
	WebKitFindController* _tmp5_;
	gulong _tmp6_;
	gulong cancelled_handler;
	gulong _tmp7_;
	WebKitFindController* _tmp8_;
	gpointer _tmp9_;
	gchar* _tmp10_;
	WebKitFindController* _tmp11_;
	WebKitFindController* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

static gpointer conversation_web_view_parent_class = NULL;
static WebKitUserStyleSheet* conversation_web_view_app_stylesheet;
static WebKitUserStyleSheet* conversation_web_view_app_stylesheet = NULL;
static WebKitUserScript* conversation_web_view_app_script;
static WebKitUserScript* conversation_web_view_app_script = NULL;

static void g_cclosure_user_marshal_VOID__ENUM_STRING_STRING_BOXED (GClosure * closure,
                                                             GValue * return_value,
                                                             guint n_param_values,
                                                             const GValue * param_values,
                                                             gpointer invocation_hint,
                                                             gpointer marshal_data);
static void conversation_web_view_init (ConversationWebView* self);
VALA_EXTERN ConversationWebView* conversation_web_view_new_with_related_view (ApplicationConfiguration* config,
                                                                  ConversationWebView* related);
VALA_EXTERN ConversationWebView* conversation_web_view_construct_with_related_view (GType object_type,
                                                                        ApplicationConfiguration* config,
                                                                        ConversationWebView* related);
static void conversation_web_view_get_selection_for_find_data_free (gpointer _data);
static gboolean conversation_web_view_get_selection_for_find_co (ConversationWebViewGetSelectionForFindData* _data_);
static void conversation_web_view_get_selection_for_find_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void conversation_web_view_get_selection_for_quoting_data_free (gpointer _data);
static gboolean conversation_web_view_get_selection_for_quoting_co (ConversationWebViewGetSelectionForQuotingData* _data_);
static void conversation_web_view_get_selection_for_quoting_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void conversation_web_view_get_anchor_target_y_data_free (gpointer _data);
static gboolean conversation_web_view_get_anchor_target_y_co (ConversationWebViewGetAnchorTargetYData* _data_);
static gint* _int_dup (gint* self);
static void conversation_web_view_get_anchor_target_y_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void conversation_web_view_highlight_search_terms_data_free (gpointer _data);
static gboolean conversation_web_view_highlight_search_terms_co (ConversationWebViewHighlightSearchTermsData* _data_);
static Block99Data* block99_data_ref (Block99Data* _data99_);
static void block99_data_unref (void * _userdata_);
static gboolean _conversation_web_view_highlight_search_terms_co_gsource_func (gpointer self);
static void __lambda73_ (Block99Data* _data99_,
                  guint count);
static void ___lambda73__webkit_find_controller_found_text (WebKitFindController* _sender,
                                                     guint match_count,
                                                     gpointer self);
static void __lambda74_ (Block99Data* _data99_);
static void ___lambda74__webkit_find_controller_failed_to_find_text (WebKitFindController* _sender,
                                                              gpointer self);
static void __lambda75_ (Block99Data* _data99_);
static gboolean ___lambda76_ (Block99Data* _data99_);
static gboolean ____lambda76__gsource_func (gpointer self);
static void ___lambda75__g_cancellable_cancelled (GCancellable* _sender,
                                           gpointer self);
static gboolean conversation_web_view_real_key_press_event (GtkWidget* base,
                                                     GdkEventKey* event);
static gboolean _vala_uint_array_contains (guint * stack,
                                    gssize stack_length,
                                    const guint needle);
static gboolean conversation_web_view_real_draw (GtkWidget* base,
                                          cairo_t* cr);
static void conversation_web_view_real_get_preferred_height (GtkWidget* base,
                                                      gint* minimum_height,
                                                      gint* natural_height);
static void conversation_web_view_real_get_preferred_width (GtkWidget* base,
                                                     gint* minimum_height,
                                                     gint* natural_height);
static void conversation_web_view_on_deceptive_link_clicked (ConversationWebView* self,
                                                      GVariant* parameters);
static void _conversation_web_view_on_deceptive_link_clicked_components_web_view_message_callback (GVariant* parameters,
                                                                                            gpointer self);
static void __lambda72_ (ConversationWebView* self);
static void ___lambda72__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void conversation_web_view_finalize (GObject * obj);
static GType conversation_web_view_get_type_once (void);

static const guint CONVERSATION_WEB_VIEW_BLACKLISTED_KEY_CODES[8] = {GDK_KEY_space, GDK_KEY_KP_Space, GDK_KEY_Up, GDK_KEY_Down, GDK_KEY_Page_Up, GDK_KEY_Page_Down, GDK_KEY_Home, GDK_KEY_End};

/** Specifies the type of deceptive link text when clicked. */
static GType
conversation_web_view_deceptive_text_get_type_once (void)
{
	static const GEnumValue values[] = {{CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_NOT_DECEPTIVE, "CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_NOT_DECEPTIVE", "not-deceptive"}, {CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_DECEPTIVE_HREF, "CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_DECEPTIVE_HREF", "deceptive-href"}, {CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_DECEPTIVE_DOMAIN, "CONVERSATION_WEB_VIEW_DECEPTIVE_TEXT_DECEPTIVE_DOMAIN", "deceptive-domain"}, {0, NULL, NULL}};
	GType conversation_web_view_deceptive_text_type_id;
	conversation_web_view_deceptive_text_type_id = g_enum_register_static ("ConversationWebViewDeceptiveText", values);
	return conversation_web_view_deceptive_text_type_id;
}

GType
conversation_web_view_deceptive_text_get_type (void)
{
	static volatile gsize conversation_web_view_deceptive_text_type_id__once = 0;
	if (g_once_init_enter (&conversation_web_view_deceptive_text_type_id__once)) {
		GType conversation_web_view_deceptive_text_type_id;
		conversation_web_view_deceptive_text_type_id = conversation_web_view_deceptive_text_get_type_once ();
		g_once_init_leave (&conversation_web_view_deceptive_text_type_id__once, conversation_web_view_deceptive_text_type_id);
	}
	return conversation_web_view_deceptive_text_type_id__once;
}

void
conversation_web_view_load_resources (GError** error)
{
	WebKitUserScript* _tmp0_ = NULL;
	WebKitUserScript* _tmp1_;
	WebKitUserScript* _tmp2_;
	WebKitUserStyleSheet* _tmp3_ = NULL;
	WebKitUserStyleSheet* _tmp4_;
	WebKitUserStyleSheet* _tmp5_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = components_web_view_load_app_script ("conversation-web-view.js", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_webkit_user_script_unref0 (conversation_web_view_app_script);
	conversation_web_view_app_script = _tmp2_;
	_tmp4_ = components_web_view_load_app_stylesheet ("conversation-web-view.css", &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_webkit_user_script_unref0 (_tmp0_);
		return;
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_webkit_user_style_sheet_unref0 (conversation_web_view_app_stylesheet);
	conversation_web_view_app_stylesheet = _tmp5_;
	_webkit_user_style_sheet_unref0 (_tmp3_);
	_webkit_user_script_unref0 (_tmp0_);
}

static void
g_cclosure_user_marshal_VOID__ENUM_STRING_STRING_BOXED (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_STRING_STRING_BOXED) (gpointer data1, gint arg_1, const char* arg_2, const char* arg_3, gpointer arg_4, gpointer data2);
	register GMarshalFunc_VOID__ENUM_STRING_STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_STRING_STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_boxed (param_values + 4), data2);
}

/**
     * Constructs a new web view for displaying an email message body.
     *
     * A new WebKitGTK WebProcess will be constructed for this view.
     */
ConversationWebView*
conversation_web_view_construct (GType object_type,
                                 ApplicationConfiguration* config)
{
	ConversationWebView * self = NULL;
	WebKitUserContentManager* _tmp0_;
	WebKitUserContentManager* _tmp1_;
	WebKitUserScript* _tmp2_;
	WebKitUserContentManager* _tmp3_;
	WebKitUserContentManager* _tmp4_;
	WebKitUserStyleSheet* _tmp5_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationWebView*) components_web_view_construct (object_type, config, NULL, NULL);
	conversation_web_view_init (self);
	_tmp0_ = webkit_web_view_get_user_content_manager (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	_tmp2_ = conversation_web_view_app_script;
	webkit_user_content_manager_add_script (_tmp1_, _tmp2_);
	_tmp3_ = webkit_web_view_get_user_content_manager (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp4_ = _tmp3_;
	_tmp5_ = conversation_web_view_app_stylesheet;
	webkit_user_content_manager_add_style_sheet (_tmp4_, _tmp5_);
	return self;
}

ConversationWebView*
conversation_web_view_new (ApplicationConfiguration* config)
{
	return conversation_web_view_construct (TYPE_CONVERSATION_WEB_VIEW, config);
}

/**
     * Constructs a new web view for displaying an email message body.
     *
     * The WebKitGTK WebProcess will be shared with the related view's
     * process.
     */
ConversationWebView*
conversation_web_view_construct_with_related_view (GType object_type,
                                                   ApplicationConfiguration* config,
                                                   ConversationWebView* related)
{
	ConversationWebView * self = NULL;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail (IS_CONVERSATION_WEB_VIEW (related), NULL);
	self = (ConversationWebView*) components_web_view_construct_with_related_view (object_type, config, G_TYPE_CHECK_INSTANCE_CAST (related, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
	conversation_web_view_init (self);
	return self;
}

ConversationWebView*
conversation_web_view_new_with_related_view (ApplicationConfiguration* config,
                                             ConversationWebView* related)
{
	return conversation_web_view_construct_with_related_view (TYPE_CONVERSATION_WEB_VIEW, config, related);
}

static void
conversation_web_view_get_selection_for_find_data_free (gpointer _data)
{
	ConversationWebViewGetSelectionForFindData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationWebViewGetSelectionForFindData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
conversation_web_view_get_selection_for_find (ConversationWebView* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ConversationWebViewGetSelectionForFindData* _data_;
	ConversationWebView* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	_data_ = g_slice_new0 (ConversationWebViewGetSelectionForFindData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_web_view_get_selection_for_find_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_web_view_get_selection_for_find_co (_data_);
}

gchar*
conversation_web_view_get_selection_for_find_finish (ConversationWebView* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	gchar* result;
	ConversationWebViewGetSelectionForFindData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the current selection, for prefill as find text.
     */
static void
conversation_web_view_get_selection_for_find_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	ConversationWebViewGetSelectionForFindData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_web_view_get_selection_for_find_co (_data_);
}

static gboolean
conversation_web_view_get_selection_for_find_co (ConversationWebViewGetSelectionForFindData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("getSelectionForFind");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp2_, NULL, conversation_web_view_get_selection_for_find_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = (gchar*) _data_->_tmp3_;
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_web_view_get_selection_for_quoting_data_free (gpointer _data)
{
	ConversationWebViewGetSelectionForQuotingData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationWebViewGetSelectionForQuotingData, _data_);
}

void
conversation_web_view_get_selection_for_quoting (ConversationWebView* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ConversationWebViewGetSelectionForQuotingData* _data_;
	ConversationWebView* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	_data_ = g_slice_new0 (ConversationWebViewGetSelectionForQuotingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_web_view_get_selection_for_quoting_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_web_view_get_selection_for_quoting_co (_data_);
}

gchar*
conversation_web_view_get_selection_for_quoting_finish (ConversationWebView* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	gchar* result;
	ConversationWebViewGetSelectionForQuotingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the current selection, for quoting in a message.
     */
static void
conversation_web_view_get_selection_for_quoting_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ConversationWebViewGetSelectionForQuotingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_web_view_get_selection_for_quoting_co (_data_);
}

static gboolean
conversation_web_view_get_selection_for_quoting_co (ConversationWebViewGetSelectionForQuotingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("getSelectionForQuoting");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp2_, NULL, conversation_web_view_get_selection_for_quoting_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = (gchar*) _data_->_tmp3_;
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_web_view_get_anchor_target_y_data_free (gpointer _data)
{
	ConversationWebViewGetAnchorTargetYData* _data_;
	_data_ = _data;
	_g_free0 (_data_->anchor_body);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationWebViewGetAnchorTargetYData, _data_);
}

void
conversation_web_view_get_anchor_target_y (ConversationWebView* self,
                                           const gchar* anchor_body,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ConversationWebViewGetAnchorTargetYData* _data_;
	ConversationWebView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	g_return_if_fail (anchor_body != NULL);
	_data_ = g_slice_new0 (ConversationWebViewGetAnchorTargetYData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_web_view_get_anchor_target_y_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (anchor_body);
	_g_free0 (_data_->anchor_body);
	_data_->anchor_body = _tmp1_;
	conversation_web_view_get_anchor_target_y_co (_data_);
}

gint*
conversation_web_view_get_anchor_target_y_finish (ConversationWebView* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	gint* result;
	ConversationWebViewGetAnchorTargetYData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the y value for a element, by its id
     */
static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static void
conversation_web_view_get_anchor_target_y_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	ConversationWebViewGetAnchorTargetYData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_web_view_get_anchor_target_y_co (_data_);
}

static gboolean
conversation_web_view_get_anchor_target_y_co (ConversationWebViewGetAnchorTargetYData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("getAnchorTargetY");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = util_js_callable_string (_data_->_tmp2_, _data_->anchor_body);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_INT, (GBoxedCopyFunc) _int_dup, (GDestroyNotify) g_free, _data_->_tmp4_, NULL, conversation_web_view_get_anchor_target_y_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = (gint*) _data_->_tmp5_;
	_util_js_callable_unref0 (_data_->_tmp4_);
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp7_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_web_view_highlight_search_terms_data_free (gpointer _data)
{
	ConversationWebViewHighlightSearchTermsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->terms);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationWebViewHighlightSearchTermsData, _data_);
}

void
conversation_web_view_highlight_search_terms (ConversationWebView* self,
                                              GeeCollection* terms,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ConversationWebViewHighlightSearchTermsData* _data_;
	ConversationWebView* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (terms, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ConversationWebViewHighlightSearchTermsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_web_view_highlight_search_terms_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (terms);
	_g_object_unref0 (_data_->terms);
	_data_->terms = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	conversation_web_view_highlight_search_terms_co (_data_);
}

guint
conversation_web_view_highlight_search_terms_finish (ConversationWebView* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	guint result;
	ConversationWebViewHighlightSearchTermsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		guint _tmp0_ = 0U;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Highlights user search terms in the message view.
     *
     * Returns the number of matching search terms.
     */
static Block99Data*
block99_data_ref (Block99Data* _data99_)
{
	g_atomic_int_inc (&_data99_->_ref_count_);
	return _data99_;
}

static void
block99_data_unref (void * _userdata_)
{
	Block99Data* _data99_;
	_data99_ = (Block99Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data99_->_ref_count_)) {
		ConversationWebView* self;
		self = _data99_->self;
		(_data99_->callback_target_destroy_notify == NULL) ? NULL : (_data99_->callback_target_destroy_notify (_data99_->callback_target), NULL);
		_data99_->callback = NULL;
		_data99_->callback_target = NULL;
		_data99_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block99Data, _data99_);
	}
}

static gboolean
_conversation_web_view_highlight_search_terms_co_gsource_func (gpointer self)
{
	gboolean result;
	result = conversation_web_view_highlight_search_terms_co (self);
	return result;
}

static void
__lambda73_ (Block99Data* _data99_,
             guint count)
{
	ConversationWebView* self;
	self = _data99_->self;
	if (!_data99_->finished) {
		GSourceFunc _tmp0_;
		gpointer _tmp0__target;
		_data99_->found = count;
		_tmp0_ = _data99_->callback;
		_tmp0__target = _data99_->callback_target;
		_tmp0_ (_tmp0__target);
	}
}

static void
___lambda73__webkit_find_controller_found_text (WebKitFindController* _sender,
                                                guint match_count,
                                                gpointer self)
{
	__lambda73_ (self, match_count);
}

static void
__lambda74_ (Block99Data* _data99_)
{
	ConversationWebView* self;
	self = _data99_->self;
	if (!_data99_->finished) {
		GSourceFunc _tmp0_;
		gpointer _tmp0__target;
		_tmp0_ = _data99_->callback;
		_tmp0__target = _data99_->callback_target;
		_tmp0_ (_tmp0__target);
	}
}

static void
___lambda74__webkit_find_controller_failed_to_find_text (WebKitFindController* _sender,
                                                         gpointer self)
{
	__lambda74_ (self);
}

static gboolean
___lambda76_ (Block99Data* _data99_)
{
	ConversationWebView* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	self = _data99_->self;
	_tmp0_ = _data99_->callback;
	_tmp0__target = _data99_->callback_target;
	result = _tmp0_ (_tmp0__target);
	return result;
}

static gboolean
____lambda76__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda76_ (self);
	return result;
}

static void
__lambda75_ (Block99Data* _data99_)
{
	ConversationWebView* self;
	self = _data99_->self;
	if (!_data99_->finished) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda76__gsource_func, block99_data_ref (_data99_), block99_data_unref);
	}
}

static void
___lambda75__g_cancellable_cancelled (GCancellable* _sender,
                                      gpointer self)
{
	__lambda75_ (self);
}

static gboolean
conversation_web_view_highlight_search_terms_co (ConversationWebViewHighlightSearchTermsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data99_ = g_slice_new0 (Block99Data);
	_data_->_data99_->_ref_count_ = 1;
	_data_->_data99_->self = g_object_ref (_data_->self);
	_data_->_data99_->_async_data_ = _data_;
	_data_->_tmp0_ = webkit_web_view_get_find_controller (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, webkit_web_view_get_type (), WebKitWebView));
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->controller = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->controller;
	webkit_find_controller_search_finish (_data_->_tmp2_);
	_data_->_data99_->found = (guint) 0;
	_data_->_data99_->finished = FALSE;
	_data_->_data99_->callback = _conversation_web_view_highlight_search_terms_co_gsource_func;
	_data_->_data99_->callback_target = _data_;
	_data_->_data99_->callback_target_destroy_notify = NULL;
	_data_->_tmp3_ = _data_->controller;
	_data_->_tmp4_ = g_signal_connect_data (_data_->_tmp3_, "found-text", (GCallback) ___lambda73__webkit_find_controller_found_text, block99_data_ref (_data_->_data99_), (GClosureNotify) block99_data_unref, 0);
	_data_->found_handler = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->controller;
	_data_->_tmp6_ = g_signal_connect_data (_data_->_tmp5_, "failed-to-find-text", (GCallback) ___lambda74__webkit_find_controller_failed_to_find_text, block99_data_ref (_data_->_data99_), (GClosureNotify) block99_data_unref, 0);
	_data_->not_found_handler = _data_->_tmp6_;
	_data_->_tmp7_ = g_signal_connect_data (_data_->cancellable, "cancelled", (GCallback) ___lambda75__g_cancellable_cancelled, block99_data_ref (_data_->_data99_), (GClosureNotify) block99_data_unref, 0);
	_data_->cancelled_handler = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->controller;
	_data_->_tmp9_ = geary_collection_first (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->terms);
	_data_->_tmp10_ = (gchar*) _data_->_tmp9_;
	webkit_find_controller_search (_data_->_tmp8_, _data_->_tmp10_, (guint32) (WEBKIT_FIND_OPTIONS_CASE_INSENSITIVE | WEBKIT_FIND_OPTIONS_WRAP_AROUND), (guint) 128);
	_g_free0 (_data_->_tmp10_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_data99_->finished = TRUE;
	_data_->_tmp11_ = _data_->controller;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, G_TYPE_OBJECT, GObject), _data_->found_handler);
	_data_->_tmp12_ = _data_->controller;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, G_TYPE_OBJECT, GObject), _data_->not_found_handler);
	g_cancellable_disconnect (_data_->cancellable, _data_->cancelled_handler);
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		_data_->_tmp13_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "ConversationWebView highlight search terms cancelled");
		_data_->_inner_error0_ = _data_->_tmp13_;
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->controller);
			block99_data_unref (_data_->_data99_);
			_data_->_data99_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->controller);
			block99_data_unref (_data_->_data99_);
			_data_->_data99_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_data99_->found;
	_g_object_unref0 (_data_->controller);
	block99_data_unref (_data_->_data99_);
	_data_->_data99_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Unmarks any search terms highlighted in the message view.
     */
void
conversation_web_view_unmark_search_terms (ConversationWebView* self)
{
	WebKitFindController* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	_tmp0_ = webkit_web_view_get_find_controller (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	webkit_find_controller_search_finish (_tmp0_);
}

static gboolean
_vala_uint_array_contains (guint * stack,
                           gssize stack_length,
                           const guint needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
conversation_web_view_real_key_press_event (GtkWidget* base,
                                            GdkEventKey* event)
{
	ConversationWebView * self;
	gboolean ret = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONVERSATION_WEB_VIEW, ConversationWebView);
	g_return_val_if_fail (event != NULL, FALSE);
	ret = GDK_EVENT_PROPAGATE;
	if (!_vala_uint_array_contains (CONVERSATION_WEB_VIEW_BLACKLISTED_KEY_CODES, G_N_ELEMENTS (CONVERSATION_WEB_VIEW_BLACKLISTED_KEY_CODES), (gint) event->keyval)) {
		ret = GTK_WIDGET_CLASS (conversation_web_view_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), gtk_widget_get_type (), GtkWidget), event);
	}
	result = ret;
	return result;
}

static gboolean
conversation_web_view_real_draw (GtkWidget* base,
                                 cairo_t* cr)
{
	ConversationWebView * self;
	gint frameWidth = 0;
	gint frameHeight = 0;
	GtkStyleContext* styleContext = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gint borderRadius = 0;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	gint _tmp4_;
	gdouble arc0 = 0.0;
	gdouble arc1 = 0.0;
	gdouble arc2 = 0.0;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONVERSATION_WEB_VIEW, ConversationWebView);
	g_return_val_if_fail (cr != NULL, FALSE);
	frameWidth = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	frameHeight = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	styleContext = _tmp1_;
	gtk_style_context_get_property (styleContext, "border-radius", gtk_style_context_get_state (styleContext), &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_value_get_int (&_tmp2_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	borderRadius = _tmp4_;
	arc0 = 0.0;
	arc1 = G_PI * 0.5;
	arc2 = G_PI;
	cairo_new_sub_path (cr);
	cairo_line_to (cr, (gdouble) frameWidth, (gdouble) 0);
	cairo_arc (cr, (gdouble) (frameWidth - borderRadius), (gdouble) (frameHeight - borderRadius), (gdouble) borderRadius, arc0, arc1);
	cairo_arc (cr, (gdouble) borderRadius, (gdouble) (frameHeight - borderRadius), (gdouble) borderRadius, arc1, arc2);
	cairo_line_to (cr, (gdouble) 0, (gdouble) 0);
	cairo_close_path (cr);
	cairo_clip (cr);
	cairo_fill (cr);
	GTK_WIDGET_CLASS (conversation_web_view_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), gtk_widget_get_type (), GtkWidget), cr);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (styleContext);
	return result;
}

static void
conversation_web_view_real_get_preferred_height (GtkWidget* base,
                                                 gint* minimum_height,
                                                 gint* natural_height)
{
	ConversationWebView * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	static const guint max_pixels = (guint) ((8 * 1024) * 1024);
	gint width = 0;
	gint height = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONVERSATION_WEB_VIEW, ConversationWebView);
	width = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = components_web_view_get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
	_tmp1_ = _tmp0_;
	height = _tmp1_;
	if (((guint) (height * width)) > max_pixels) {
		height = (gint) floor (max_pixels / ((gdouble) width));
	}
	_vala_natural_height = height;
	_vala_minimum_height = _vala_natural_height;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
conversation_web_view_real_get_preferred_width (GtkWidget* base,
                                                gint* minimum_height,
                                                gint* natural_height)
{
	ConversationWebView * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONVERSATION_WEB_VIEW, ConversationWebView);
	_vala_natural_height = 0;
	_vala_minimum_height = _vala_natural_height;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
_conversation_web_view_on_deceptive_link_clicked_components_web_view_message_callback (GVariant* parameters,
                                                                                       gpointer self)
{
	conversation_web_view_on_deceptive_link_clicked ((ConversationWebView*) self, parameters);
}

static void
__lambda72_ (ConversationWebView* self)
{
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
___lambda72__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda72_ ((ConversationWebView*) self);
}

static void
conversation_web_view_init (ConversationWebView* self)
{
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	components_web_view_register_message_callback (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), CONVERSATION_WEB_VIEW_DECEPTIVE_LINK_CLICKED, _conversation_web_view_on_deceptive_link_clicked_components_web_view_message_callback, self);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::preferred-height", (GCallback) ___lambda72__g_object_notify, self, 0);
}

static void
conversation_web_view_on_deceptive_link_clicked (ConversationWebView* self,
                                                 GVariant* parameters)
{
	GVariantDict* dict = NULL;
	GVariantDict* _tmp0_;
	guint reason = 0U;
	const GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	guint _tmp4_;
	gchar* href = NULL;
	const GVariantType* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* text = NULL;
	const GVariantType* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GdkRectangle location = {0};
	GVariantDict* location_dict = NULL;
	const GVariantType* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariantDict* _tmp20_;
	GVariantDict* _tmp21_;
	const GVariantType* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	const GVariantType* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	const GVariantType* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	const GVariantType* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GdkRectangle _tmp34_;
	g_return_if_fail (IS_CONVERSATION_WEB_VIEW (self));
	_tmp0_ = g_variant_dict_new (parameters);
	dict = _tmp0_;
	_tmp1_ = G_VARIANT_TYPE_DOUBLE;
	_tmp2_ = g_variant_dict_lookup_value (dict, "reason", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (guint) g_variant_get_double (_tmp3_);
	_g_variant_unref0 (_tmp3_);
	reason = _tmp4_;
	_tmp5_ = G_VARIANT_TYPE_STRING;
	_tmp6_ = g_variant_dict_lookup_value (dict, "href", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_string (_tmp7_, NULL);
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp7_);
	href = _tmp10_;
	_tmp11_ = G_VARIANT_TYPE_STRING;
	_tmp12_ = g_variant_dict_lookup_value (dict, "text", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_variant_unref0 (_tmp13_);
	text = _tmp16_;
	memset (&location, 0, sizeof (GdkRectangle));
	_tmp17_ = G_VARIANT_TYPE_VARDICT;
	_tmp18_ = g_variant_dict_lookup_value (dict, "location", _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_dict_new (_tmp19_);
	_tmp21_ = _tmp20_;
	_g_variant_unref0 (_tmp19_);
	location_dict = _tmp21_;
	_tmp22_ = G_VARIANT_TYPE_DOUBLE;
	_tmp23_ = g_variant_dict_lookup_value (location_dict, "x", _tmp22_);
	_tmp24_ = _tmp23_;
	location.x = (gint) g_variant_get_double (_tmp24_);
	_g_variant_unref0 (_tmp24_);
	_tmp25_ = G_VARIANT_TYPE_DOUBLE;
	_tmp26_ = g_variant_dict_lookup_value (location_dict, "y", _tmp25_);
	_tmp27_ = _tmp26_;
	location.y = (gint) g_variant_get_double (_tmp27_);
	_g_variant_unref0 (_tmp27_);
	_tmp28_ = G_VARIANT_TYPE_DOUBLE;
	_tmp29_ = g_variant_dict_lookup_value (location_dict, "width", _tmp28_);
	_tmp30_ = _tmp29_;
	location.width = (gint) g_variant_get_double (_tmp30_);
	_g_variant_unref0 (_tmp30_);
	_tmp31_ = G_VARIANT_TYPE_DOUBLE;
	_tmp32_ = g_variant_dict_lookup_value (location_dict, "height", _tmp31_);
	_tmp33_ = _tmp32_;
	location.height = (gint) g_variant_get_double (_tmp33_);
	_g_variant_unref0 (_tmp33_);
	_tmp34_ = location;
	g_signal_emit (self, conversation_web_view_signals[CONVERSATION_WEB_VIEW_DECEPTIVE_LINK_CLICKED_SIGNAL], 0, (ConversationWebViewDeceptiveText) reason, text, href, &_tmp34_);
	_g_variant_dict_unref0 (location_dict);
	_g_free0 (text);
	_g_free0 (href);
	_g_variant_dict_unref0 (dict);
}

static void
conversation_web_view_class_init (ConversationWebViewClass * klass,
                                  gpointer klass_data)
{
	conversation_web_view_parent_class = g_type_class_peek_parent (klass);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) conversation_web_view_real_key_press_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) conversation_web_view_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) conversation_web_view_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) conversation_web_view_real_get_preferred_width;
	G_OBJECT_CLASS (klass)->finalize = conversation_web_view_finalize;
	/** Emitted when the user clicks on a link with deceptive text. */
	conversation_web_view_signals[CONVERSATION_WEB_VIEW_DECEPTIVE_LINK_CLICKED_SIGNAL] = g_signal_new ("deceptive-link-clicked", TYPE_CONVERSATION_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_STRING_STRING_BOXED, G_TYPE_NONE, 4, CONVERSATION_WEB_VIEW_TYPE_DECEPTIVE_TEXT, G_TYPE_STRING, G_TYPE_STRING, gdk_rectangle_get_type ());
}

static void
conversation_web_view_instance_init (ConversationWebView * self,
                                     gpointer klass)
{
}

static void
conversation_web_view_finalize (GObject * obj)
{
	ConversationWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSATION_WEB_VIEW, ConversationWebView);
	G_OBJECT_CLASS (conversation_web_view_parent_class)->finalize (obj);
}

static GType
conversation_web_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationWebViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_web_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationWebView), 0, (GInstanceInitFunc) conversation_web_view_instance_init, NULL };
	GType conversation_web_view_type_id;
	conversation_web_view_type_id = g_type_register_static (COMPONENTS_TYPE_WEB_VIEW, "ConversationWebView", &g_define_type_info, 0);
	return conversation_web_view_type_id;
}

GType
conversation_web_view_get_type (void)
{
	static volatile gsize conversation_web_view_type_id__once = 0;
	if (g_once_init_enter (&conversation_web_view_type_id__once)) {
		GType conversation_web_view_type_id;
		conversation_web_view_type_id = conversation_web_view_get_type_once ();
		g_once_init_leave (&conversation_web_view_type_id__once, conversation_web_view_type_id);
	}
	return conversation_web_view_type_id__once;
}

