/* geary-credentials.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-credentials.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

enum  {
	GEARY_CREDENTIALS_0_PROPERTY,
	GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY,
	GEARY_CREDENTIALS_USER_PROPERTY,
	GEARY_CREDENTIALS_TOKEN_PROPERTY,
	GEARY_CREDENTIALS_NUM_PROPERTIES
};
static GParamSpec* geary_credentials_properties[GEARY_CREDENTIALS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyCredentialsPrivate {
	GearyCredentialsMethod _supported_method;
	gchar* _user;
	gchar* _token;
};

static gint GearyCredentials_private_offset;
static gpointer geary_credentials_parent_class = NULL;
static GeeHashableIface * geary_credentials_gee_hashable_parent_iface = NULL;

static void geary_credentials_set_supported_method (GearyCredentials* self,
                                             GearyCredentialsMethod value);
static void geary_credentials_set_user (GearyCredentials* self,
                                 const gchar* value);
static void geary_credentials_set_token (GearyCredentials* self,
                                  const gchar* value);
static gboolean geary_credentials_real_equal_to (GeeHashable* base,
                                          GearyCredentials* c);
static guint geary_credentials_real_hash (GeeHashable* base);
static void geary_credentials_finalize (GObject * obj);
static GType geary_credentials_get_type_once (void);
static void _vala_geary_credentials_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_geary_credentials_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
geary_credentials_get_instance_private (GearyCredentials* self)
{
	return G_STRUCT_MEMBER_P (self, GearyCredentials_private_offset);
}

/**
     * Authentication methods supported by the Engine.
     */
gchar*
geary_credentials_method_to_string (GearyCredentialsMethod self)
{
	gchar* result;
	switch (self) {
		case GEARY_CREDENTIALS_METHOD_PASSWORD:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("password");
			result = _tmp0_;
			return result;
		}
		case GEARY_CREDENTIALS_METHOD_OAUTH2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("oauth2");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GearyCredentialsMethod
geary_credentials_method_from_string (const gchar* str,
                                      GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GError* _inner_error0_ = NULL;
	GearyCredentialsMethod result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("password")))) {
		switch (0) {
			default:
			{
				result = GEARY_CREDENTIALS_METHOD_PASSWORD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("oauth2")))) {
		switch (0) {
			default:
			{
				result = GEARY_CREDENTIALS_METHOD_OAUTH2;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "Unknown credentials method type: %s", str);
				_inner_error0_ = _tmp3_;
				g_propagate_error (error, _inner_error0_);
				return 0;
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_credentials_method_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_CREDENTIALS_METHOD_PASSWORD, "GEARY_CREDENTIALS_METHOD_PASSWORD", "password"}, {GEARY_CREDENTIALS_METHOD_OAUTH2, "GEARY_CREDENTIALS_METHOD_OAUTH2", "oauth2"}, {0, NULL, NULL}};
	GType geary_credentials_method_type_id;
	geary_credentials_method_type_id = g_enum_register_static ("GearyCredentialsMethod", values);
	return geary_credentials_method_type_id;
}

GType
geary_credentials_method_get_type (void)
{
	static gsize geary_credentials_method_type_id__once = 0;
	if (g_once_init_enter (&geary_credentials_method_type_id__once)) {
		GType geary_credentials_method_type_id;
		geary_credentials_method_type_id = geary_credentials_method_get_type_once ();
		g_once_init_leave (&geary_credentials_method_type_id__once, geary_credentials_method_type_id);
	}
	return geary_credentials_method_type_id__once;
}

/** The requirements for a service's credentials. */
GearyCredentialsRequirement
geary_credentials_requirement_for_value (const gchar* value,
                                         GError** error)
{
	GearyCredentialsRequirement _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	GearyCredentialsRequirement _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyCredentialsRequirement result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp1_ = g_ascii_strdown (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_object_utils_from_enum_nick (GEARY_CREDENTIALS_TYPE_REQUIREMENT, NULL, NULL, GEARY_CREDENTIALS_TYPE_REQUIREMENT, _tmp2_, &_inner_error0_);
	_tmp4_ = (GearyCredentialsRequirement) ((gintptr) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_credentials_requirement_to_value (GearyCredentialsRequirement self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (GEARY_CREDENTIALS_TYPE_REQUIREMENT, NULL, NULL, GEARY_CREDENTIALS_TYPE_REQUIREMENT, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_credentials_requirement_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_CREDENTIALS_REQUIREMENT_NONE, "GEARY_CREDENTIALS_REQUIREMENT_NONE", "none"}, {GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING, "GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING", "use-incoming"}, {GEARY_CREDENTIALS_REQUIREMENT_CUSTOM, "GEARY_CREDENTIALS_REQUIREMENT_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType geary_credentials_requirement_type_id;
	geary_credentials_requirement_type_id = g_enum_register_static ("GearyCredentialsRequirement", values);
	return geary_credentials_requirement_type_id;
}

GType
geary_credentials_requirement_get_type (void)
{
	static gsize geary_credentials_requirement_type_id__once = 0;
	if (g_once_init_enter (&geary_credentials_requirement_type_id__once)) {
		GType geary_credentials_requirement_type_id;
		geary_credentials_requirement_type_id = geary_credentials_requirement_get_type_once ();
		g_once_init_leave (&geary_credentials_requirement_type_id__once, geary_credentials_requirement_type_id);
	}
	return geary_credentials_requirement_type_id__once;
}

GearyCredentialsMethod
geary_credentials_get_supported_method (GearyCredentials* self)
{
	GearyCredentialsMethod result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), 0);
	result = self->priv->_supported_method;
	return result;
}

static void
geary_credentials_set_supported_method (GearyCredentials* self,
                                        GearyCredentialsMethod value)
{
	GearyCredentialsMethod old_value;
	g_return_if_fail (GEARY_IS_CREDENTIALS (self));
	old_value = geary_credentials_get_supported_method (self);
	if (old_value != value) {
		self->priv->_supported_method = value;
		g_object_notify_by_pspec ((GObject *) self, geary_credentials_properties[GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY]);
	}
}

const gchar*
geary_credentials_get_user (GearyCredentials* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
geary_credentials_set_user (GearyCredentials* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_CREDENTIALS (self));
	old_value = geary_credentials_get_user (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_credentials_properties[GEARY_CREDENTIALS_USER_PROPERTY]);
	}
}

const gchar*
geary_credentials_get_token (GearyCredentials* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	_tmp0_ = self->priv->_token;
	result = _tmp0_;
	return result;
}

static void
geary_credentials_set_token (GearyCredentials* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_CREDENTIALS (self));
	old_value = geary_credentials_get_token (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_token);
		self->priv->_token = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_credentials_properties[GEARY_CREDENTIALS_TOKEN_PROPERTY]);
	}
}

GearyCredentials*
geary_credentials_construct (GType object_type,
                             GearyCredentialsMethod supported_method,
                             const gchar* user,
                             const gchar* token)
{
	GearyCredentials * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (GearyCredentials*) geary_base_object_construct (object_type);
	geary_credentials_set_supported_method (self, supported_method);
	geary_credentials_set_user (self, user);
	geary_credentials_set_token (self, token);
	return self;
}

GearyCredentials*
geary_credentials_new (GearyCredentialsMethod supported_method,
                       const gchar* user,
                       const gchar* token)
{
	return geary_credentials_construct (GEARY_TYPE_CREDENTIALS, supported_method, user, token);
}

/** Determines if a token has been provided. */
gboolean
geary_credentials_is_complete (GearyCredentials* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), FALSE);
	_tmp0_ = self->priv->_token;
	result = _tmp0_ != NULL;
	return result;
}

GearyCredentials*
geary_credentials_copy_with_user (GearyCredentials* self,
                                  const gchar* user)
{
	GearyCredentialsMethod _tmp0_;
	const gchar* _tmp1_;
	GearyCredentials* _tmp2_;
	GearyCredentials* result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	g_return_val_if_fail (user != NULL, NULL);
	_tmp0_ = self->priv->_supported_method;
	_tmp1_ = self->priv->_token;
	_tmp2_ = geary_credentials_new (_tmp0_, user, _tmp1_);
	result = _tmp2_;
	return result;
}

GearyCredentials*
geary_credentials_copy_with_token (GearyCredentials* self,
                                   const gchar* token)
{
	GearyCredentialsMethod _tmp0_;
	const gchar* _tmp1_;
	GearyCredentials* _tmp2_;
	GearyCredentials* result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	_tmp0_ = self->priv->_supported_method;
	_tmp1_ = self->priv->_user;
	_tmp2_ = geary_credentials_new (_tmp0_, _tmp1_, token);
	result = _tmp2_;
	return result;
}

GearyCredentials*
geary_credentials_copy (GearyCredentials* self)
{
	GearyCredentialsMethod _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GearyCredentials* _tmp3_;
	GearyCredentials* result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	_tmp0_ = self->priv->_supported_method;
	_tmp1_ = self->priv->_user;
	_tmp2_ = self->priv->_token;
	_tmp3_ = geary_credentials_new (_tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
geary_credentials_to_string (GearyCredentials* self)
{
	const gchar* _tmp0_;
	GearyCredentialsMethod _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (self), NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = self->priv->_supported_method;
	_tmp2_ = geary_credentials_method_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gboolean
geary_credentials_real_equal_to (GeeHashable* base,
                                 GearyCredentials* c)
{
	GearyCredentials * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GearyCredentialsMethod _tmp2_;
	GearyCredentialsMethod _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CREDENTIALS, GearyCredentials);
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (c), FALSE);
	if (self == c) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->_supported_method;
	_tmp3_ = c->priv->_supported_method;
	if (_tmp2_ == _tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_user;
		_tmp5_ = c->priv->_user;
		_tmp1_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->_token;
		_tmp7_ = c->priv->_token;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static guint
geary_credentials_real_hash (GeeHashable* base)
{
	GearyCredentials * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GearyCredentialsMethod _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CREDENTIALS, GearyCredentials);
	_tmp1_ = self->priv->_token;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = self->priv->_supported_method;
	_tmp3_ = self->priv->_user;
	_tmp4_ = g_strdup_printf ("%d%s%s", (gint) _tmp2_, _tmp3_, _tmp0_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_str_hash (_tmp5_);
	_g_free0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static void
geary_credentials_class_init (GearyCredentialsClass * klass,
                              gpointer klass_data)
{
	geary_credentials_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyCredentials_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_credentials_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_credentials_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_credentials_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY, geary_credentials_properties[GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY] = g_param_spec_enum ("supported-method", "supported-method", "supported-method", GEARY_CREDENTIALS_TYPE_METHOD, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CREDENTIALS_USER_PROPERTY, geary_credentials_properties[GEARY_CREDENTIALS_USER_PROPERTY] = g_param_spec_string ("user", "user", "user", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CREDENTIALS_TOKEN_PROPERTY, geary_credentials_properties[GEARY_CREDENTIALS_TOKEN_PROPERTY] = g_param_spec_string ("token", "token", "token", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_credentials_gee_hashable_interface_init (GeeHashableIface * iface,
                                               gpointer iface_data)
{
	geary_credentials_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_credentials_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_credentials_real_hash;
}

static void
geary_credentials_instance_init (GearyCredentials * self,
                                 gpointer klass)
{
	self->priv = geary_credentials_get_instance_private (self);
}

static void
geary_credentials_finalize (GObject * obj)
{
	GearyCredentials * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CREDENTIALS, GearyCredentials);
	_g_free0 (self->priv->_user);
	_g_free0 (self->priv->_token);
	G_OBJECT_CLASS (geary_credentials_parent_class)->finalize (obj);
}

/**
 * Credentials provide a user's access details for authentication.
 *
 * The {@link user} property specifies the user's log in name, and the
 * {@link token} property is a shared secret between the user and a
 * service. For password-based schemes, this would be a password.

 * The token property may be null. This indicates the Credentials are
 * incomplete and need further information (i.e. prompt user for
 * username, fetch password from keyring, etc.). The token may be a
 * non-null zero-length string; this is considered valid and
 * is_complete() will return true in this case.
 *
 * Note that Geary will hold Credentials in memory for the long-term,
 * usually the duration of the application.  This is because network
 * resources often have to be connected (or reconnected) to in the
 * background and asking the user to reauthenticate each time is
 * deemed inconvenient.
 */
 G_GNUC_NO_INLINE static GType
geary_credentials_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyCredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyCredentials), 0, (GInstanceInitFunc) geary_credentials_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_credentials_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_credentials_type_id;
	geary_credentials_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyCredentials", &g_define_type_info, 0);
	g_type_add_interface_static (geary_credentials_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyCredentials_private_offset = g_type_add_instance_private (geary_credentials_type_id, sizeof (GearyCredentialsPrivate));
	return geary_credentials_type_id;
}

GType
geary_credentials_get_type (void)
{
	static gsize geary_credentials_type_id__once = 0;
	if (g_once_init_enter (&geary_credentials_type_id__once)) {
		GType geary_credentials_type_id;
		geary_credentials_type_id = geary_credentials_get_type_once ();
		g_once_init_leave (&geary_credentials_type_id__once, geary_credentials_type_id);
	}
	return geary_credentials_type_id__once;
}

static void
_vala_geary_credentials_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GearyCredentials * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CREDENTIALS, GearyCredentials);
	switch (property_id) {
		case GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY:
		g_value_set_enum (value, geary_credentials_get_supported_method (self));
		break;
		case GEARY_CREDENTIALS_USER_PROPERTY:
		g_value_set_string (value, geary_credentials_get_user (self));
		break;
		case GEARY_CREDENTIALS_TOKEN_PROPERTY:
		g_value_set_string (value, geary_credentials_get_token (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_credentials_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GearyCredentials * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CREDENTIALS, GearyCredentials);
	switch (property_id) {
		case GEARY_CREDENTIALS_SUPPORTED_METHOD_PROPERTY:
		geary_credentials_set_supported_method (self, g_value_get_enum (value));
		break;
		case GEARY_CREDENTIALS_USER_PROPERTY:
		geary_credentials_set_user (self, g_value_get_string (value));
		break;
		case GEARY_CREDENTIALS_TOKEN_PROPERTY:
		geary_credentials_set_token (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

