/* app-search-folder.c generated by valac 0.56.3, the Vala compiler
 * generated from app-search-folder.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL (geary_app_search_folder_folder_properties_impl_get_type ())
#define GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL, GearyAppSearchFolderFolderPropertiesImpl))
#define GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL, GearyAppSearchFolderFolderPropertiesImplClass))
#define GEARY_APP_SEARCH_FOLDER_IS_FOLDER_PROPERTIES_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL))
#define GEARY_APP_SEARCH_FOLDER_IS_FOLDER_PROPERTIES_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL))
#define GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL, GearyAppSearchFolderFolderPropertiesImplClass))

typedef struct _GearyAppSearchFolderFolderPropertiesImpl GearyAppSearchFolderFolderPropertiesImpl;
typedef struct _GearyAppSearchFolderFolderPropertiesImplClass GearyAppSearchFolderFolderPropertiesImplClass;

#define GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY (geary_app_search_folder_email_entry_get_type ())
#define GEARY_APP_SEARCH_FOLDER_EMAIL_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, GearyAppSearchFolderEmailEntry))
#define GEARY_APP_SEARCH_FOLDER_EMAIL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, GearyAppSearchFolderEmailEntryClass))
#define GEARY_APP_SEARCH_FOLDER_IS_EMAIL_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY))
#define GEARY_APP_SEARCH_FOLDER_IS_EMAIL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY))
#define GEARY_APP_SEARCH_FOLDER_EMAIL_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, GearyAppSearchFolderEmailEntryClass))

typedef struct _GearyAppSearchFolderEmailEntry GearyAppSearchFolderEmailEntry;
typedef struct _GearyAppSearchFolderEmailEntryClass GearyAppSearchFolderEmailEntryClass;
enum  {
	GEARY_APP_SEARCH_FOLDER_0_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_ACCOUNT_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_PROPERTIES_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_PATH_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_USED_AS_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_NUM_PROPERTIES
};
static GParamSpec* geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyAppSearchFolderGetSearchMatchesAsyncData GearyAppSearchFolderGetSearchMatchesAsyncData;
typedef struct _Block17Data Block17Data;
typedef struct _GearyAppSearchFolderContainsIdentifiersData GearyAppSearchFolderContainsIdentifiersData;
#define _geary_app_search_folder_email_entry_unref0(var) ((var == NULL) ? NULL : (var = (geary_app_search_folder_email_entry_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyAppSearchFolderEmailEntryPrivate GearyAppSearchFolderEmailEntryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyAppSearchFolderListEmailByIdAsyncData GearyAppSearchFolderListEmailByIdAsyncData;
typedef struct _GearyAppSearchFolderListEmailBySparseIdAsyncData GearyAppSearchFolderListEmailBySparseIdAsyncData;
typedef struct _GearyAppSearchFolderFetchEmailAsyncData GearyAppSearchFolderFetchEmailAsyncData;
typedef struct _GearyAppSearchFolderRemoveEmailAsyncData GearyAppSearchFolderRemoveEmailAsyncData;
typedef struct _GearyAppSearchFolderAppendData GearyAppSearchFolderAppendData;
typedef struct _GearyAppSearchFolderUpdateData GearyAppSearchFolderUpdateData;
typedef struct _Block18Data Block18Data;
typedef struct _GearyAppSearchFolderRemoveData GearyAppSearchFolderRemoveData;
typedef struct _GearyAppSearchFolderDoSearchAsyncData GearyAppSearchFolderDoSearchAsyncData;
typedef struct _GearyAppSearchFolderFolderPropertiesImplPrivate GearyAppSearchFolderFolderPropertiesImplPrivate;
enum  {
	GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL_0_PROPERTY,
	GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL_NUM_PROPERTIES
};
static GParamSpec* geary_app_search_folder_folder_properties_impl_properties[GEARY_APP_SEARCH_FOLDER_FOLDER_PROPERTIES_IMPL_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GearyAppSearchFolderParamSpecEmailEntry GearyAppSearchFolderParamSpecEmailEntry;

struct _GearyAppSearchFolderPrivate {
	GearyAccount* _account;
	GearyAppSearchFolderFolderPropertiesImpl* _properties;
	GearyFolderPath* _path;
	GearySearchQuery* _query;
	GeeHashSet* exclude_folders;
	GeeSortedSet* entries;
	GeeMap* ids;
	GearyNonblockingMutex* result_mutex;
	GCancellable* executing;
};

struct _GearyAppSearchFolderGetSearchMatchesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GeeCollection* targets;
	GCancellable* cancellable;
	GeeSet* result;
	GeeSet* results;
	GearySearchQuery* _tmp0_;
	GeeSet* _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccount* _tmp3_;
	GearySearchQuery* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GError* _inner_error0_;
};

struct _Block17Data {
	int _ref_count_;
	GearyAppSearchFolder* self;
	GeeMap* existing_ids;
	gpointer _async_data_;
};

struct _GearyAppSearchFolderContainsIdentifiersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GeeCollection* ids;
	GCancellable* cancellable;
	GeeCollection* result;
	Block17Data* _data17_;
	gint result_mutex_token;
	GearyNonblockingMutex* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GearyNonblockingMutex* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* _tmp6_;
	GearyIterable* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeCollection* _tmp9_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderEmailEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GearyEmailIdentifier* id;
	GDateTime* received;
	GearyAppSearchFolderEmailEntryPrivate * priv;
};

struct _GearyAppSearchFolderEmailEntryClass {
	GTypeClass parent_class;
	void (*finalize) (GearyAppSearchFolderEmailEntry *self);
};

struct _GearyAppSearchFolderListEmailByIdAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GearyEmailIdentifier* initial_id;
	gint count;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GeeList* result;
	gint result_mutex_token;
	GearyNonblockingMutex* _tmp0_;
	GeeSortedSet* existing_entries;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeMap* existing_ids;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GearyNonblockingMutex* _tmp5_;
	GeeLinkedList* engine_ids;
	GeeLinkedList* _tmp6_;
	GearyAppSearchFolderEmailEntry* oldest;
	GeeSortedSet* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeSortedSet* _tmp10_;
	gpointer _tmp11_;
	GeeMap* _tmp12_;
	gpointer _tmp13_;
	GearyAppSearchFolderEmailEntry* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	GeeSortedSet* _tmp19_;
	GearyAppSearchFolderEmailEntry* _tmp20_;
	gpointer _tmp21_;
	GearyAppSearchFolderEmailEntry* _tmp22_;
	GeeBidirIterator* iter;
	GeeSortedSet* _tmp23_;
	GearyAppSearchFolderEmailEntry* _tmp24_;
	GeeIterator* _tmp25_;
	GeeBidirIterator* _tmp26_;
	GeeLinkedList* _tmp27_;
	GearyAppSearchFolderEmailEntry* _tmp28_;
	GearyEmailIdentifier* _tmp29_;
	gboolean _tmp30_;
	GeeLinkedList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeBidirIterator* _tmp34_;
	GeeLinkedList* _tmp35_;
	GeeBidirIterator* _tmp36_;
	gpointer _tmp37_;
	GearyAppSearchFolderEmailEntry* _tmp38_;
	GearyEmailIdentifier* _tmp39_;
	GearyAppSearchFolderEmailEntry* newest;
	GeeSortedSet* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GeeSortedSet* _tmp43_;
	gpointer _tmp44_;
	GeeMap* _tmp45_;
	gpointer _tmp46_;
	GearyAppSearchFolderEmailEntry* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _tmp50_;
	GError* _tmp51_;
	GeeSortedSet* _tmp52_;
	GearyAppSearchFolderEmailEntry* _tmp53_;
	gpointer _tmp54_;
	GearyAppSearchFolderEmailEntry* _tmp55_;
	GeeBidirIterator* _vala1_iter;
	GeeSortedSet* _tmp56_;
	GearyAppSearchFolderEmailEntry* _tmp57_;
	GeeIterator* _tmp58_;
	GeeBidirIterator* _tmp59_;
	GeeLinkedList* _tmp60_;
	GearyAppSearchFolderEmailEntry* _tmp61_;
	GearyEmailIdentifier* _tmp62_;
	gboolean _tmp63_;
	GeeLinkedList* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	GeeBidirIterator* _tmp67_;
	GeeLinkedList* _tmp68_;
	GeeBidirIterator* _tmp69_;
	gpointer _tmp70_;
	GearyAppSearchFolderEmailEntry* _tmp71_;
	GearyEmailIdentifier* _tmp72_;
	GeeList* results;
	GError* list_error;
	GeeLinkedList* _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	GeeList* _tmp76_;
	GearyAccount* _tmp77_;
	GearyAccount* _tmp78_;
	GeeLinkedList* _tmp79_;
	GeeList* _tmp80_;
	GeeList* _tmp81_;
	GError* _error_;
	GError* _tmp82_;
	GError* _tmp83_;
	GError* _tmp84_;
	GError* _tmp85_;
	GError* _tmp86_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderListEmailBySparseIdAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GeeCollection* list;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GeeList* result;
	GeeList* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderFetchEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GearyEmailIdentifier* fetch;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GearyEmail* result;
	GearyEmail* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GearyEmail* _tmp3_;
	GearyEmail* _tmp4_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderRemoveEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GeeCollection* remove;
	GCancellable* cancellable;
	GeeMultiMap* ids_to_folders;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _tmp6_;
	GeeMultiMap* folders_to_ids;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	GeeIterator* _path_it;
	GeeMultiMap* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GearyFolderPath* path;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	GearyFolder* folder;
	GearyAccount* _tmp17_;
	GearyAccount* _tmp18_;
	GearyFolderPath* _tmp19_;
	GearyFolder* _tmp20_;
	GearyFolderSupportRemove* removable;
	GearyFolder* _tmp21_;
	GearyFolderSupportRemove* _tmp22_;
	GearyFolderSupportRemove* _tmp23_;
	GeeCollection* ids;
	GeeMultiMap* _tmp24_;
	GearyFolderPath* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GearyFolder* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean open;
	GearyFolder* _tmp33_;
	GearyFolderSupportRemove* _tmp34_;
	GeeCollection* _tmp35_;
	GError* _inner_error1_;
	GearyFolder* _tmp36_;
	GError* e;
	GearyFolder* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GError* _tmp40_;
	const gchar* _tmp41_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderAppendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GearyFolder* folder;
	GeeCollection* ids;
	GCancellable* cancellable;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gint result_mutex_token;
	GearyNonblockingMutex* _tmp2_;
	GCancellable* _tmp3_;
	GeeHashSet* _tmp4_;
	GearyFolderPath* _tmp5_;
	GearyFolderPath* _tmp6_;
	GCancellable* _tmp7_;
	GError* _error_;
	GearyAccount* _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccount* _tmp10_;
	GearyAccount* _tmp11_;
	GearyAccountInformation* _tmp12_;
	GearyAccountInformation* _tmp13_;
	GError* _tmp14_;
	GearyAccountProblemReport* _tmp15_;
	GearyAccountProblemReport* _tmp16_;
	GearyNonblockingMutex* _tmp17_;
	GError* mutex_err;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GCancellable* cancellable;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gint result_mutex_token;
	GearyNonblockingMutex* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GError* _error_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	GearyAccount* _tmp8_;
	GearyAccountInformation* _tmp9_;
	GearyAccountInformation* _tmp10_;
	GError* _tmp11_;
	GearyAccountProblemReport* _tmp12_;
	GearyAccountProblemReport* _tmp13_;
	GearyNonblockingMutex* _tmp14_;
	GError* mutex_err;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _Block18Data {
	int _ref_count_;
	GearyAppSearchFolder* self;
	GeeMap* id_map;
};

struct _GearyAppSearchFolderRemoveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GearyFolder* folder;
	GeeCollection* ids;
	GCancellable* cancellable;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	Block18Data* _data18_;
	gint result_mutex_token;
	GearyNonblockingMutex* _tmp2_;
	GCancellable* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GeeLinkedList* relevant_ids;
	GearyIterable* _tmp6_;
	GearyIterable* _tmp7_;
	GearyIterable* _tmp8_;
	GearyIterable* _tmp9_;
	GeeLinkedList* _tmp10_;
	GeeLinkedList* _tmp11_;
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeLinkedList* _tmp15_;
	GCancellable* _tmp16_;
	GError* _error_;
	GearyAccount* _tmp17_;
	GearyAccount* _tmp18_;
	GearyAccount* _tmp19_;
	GearyAccount* _tmp20_;
	GearyAccountInformation* _tmp21_;
	GearyAccountInformation* _tmp22_;
	GError* _tmp23_;
	GearyAccountProblemReport* _tmp24_;
	GearyAccountProblemReport* _tmp25_;
	GearyNonblockingMutex* _tmp26_;
	GError* mutex_err;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderDoSearchAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppSearchFolder* self;
	GeeCollection* add_ids;
	GeeCollection* remove_ids;
	GCancellable* cancellable;
	GeeSortedSet* entries;
	GeeSortedSet* _tmp0_;
	GeeMap* ids;
	GeeMap* _tmp1_;
	GeeLinkedList* added;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* removed;
	GeeLinkedList* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	GeeCollection* id_results;
	GearyAccount* _tmp8_;
	GearyAccount* _tmp9_;
	GearySearchQuery* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* email_results;
	GearyAccount* _tmp14_;
	GearyAccount* _tmp15_;
	GeeCollection* _tmp16_;
	GeeList* _tmp17_;
	GeeHashSet* hashed_results;
	GeeHashSet* _tmp18_;
	GeeHashSet* _tmp19_;
	GeeCollection* _tmp20_;
	GeeMapIterator* existing;
	GeeMap* _tmp21_;
	GeeMapIterator* _tmp22_;
	GeeMapIterator* _tmp23_;
	GeeHashSet* _tmp24_;
	GeeMapIterator* _tmp25_;
	gpointer _tmp26_;
	GearyEmailIdentifier* _tmp27_;
	gboolean _tmp28_;
	GearyAppSearchFolderEmailEntry* entry;
	GeeMapIterator* _tmp29_;
	gpointer _tmp30_;
	GeeMapIterator* _tmp31_;
	GeeSortedSet* _tmp32_;
	GearyAppSearchFolderEmailEntry* _tmp33_;
	GeeLinkedList* _tmp34_;
	GearyAppSearchFolderEmailEntry* _tmp35_;
	GearyEmailIdentifier* _tmp36_;
	GeeIterator* _email_it;
	GeeCollection* _tmp37_;
	GeeIterator* _tmp38_;
	GeeIterator* _tmp39_;
	GearyEmail* email;
	GeeIterator* _tmp40_;
	gpointer _tmp41_;
	GeeMap* _tmp42_;
	GearyEmail* _tmp43_;
	GearyEmailIdentifier* _tmp44_;
	GearyEmailIdentifier* _tmp45_;
	GearyAppSearchFolderEmailEntry* _vala1_entry;
	GearyEmail* _tmp46_;
	GearyEmailIdentifier* _tmp47_;
	GearyEmailIdentifier* _tmp48_;
	GearyEmail* _tmp49_;
	GearyEmailProperties* _tmp50_;
	GearyEmailProperties* _tmp51_;
	GDateTime* _tmp52_;
	GDateTime* _tmp53_;
	GearyAppSearchFolderEmailEntry* _tmp54_;
	GeeSortedSet* _tmp55_;
	GearyAppSearchFolderEmailEntry* _tmp56_;
	GeeMap* _tmp57_;
	GearyEmail* _tmp58_;
	GearyEmailIdentifier* _tmp59_;
	GearyEmailIdentifier* _tmp60_;
	GearyAppSearchFolderEmailEntry* _tmp61_;
	GeeLinkedList* _tmp62_;
	GearyEmail* _tmp63_;
	GearyEmailIdentifier* _tmp64_;
	GearyEmailIdentifier* _tmp65_;
	GeeIterator* _id_it;
	GeeIterator* _tmp66_;
	GeeIterator* _tmp67_;
	GearyEmailIdentifier* id;
	GeeIterator* _tmp68_;
	gpointer _tmp69_;
	GearyAppSearchFolderEmailEntry* _vala2_entry;
	GeeMap* _tmp70_;
	GearyEmailIdentifier* _tmp71_;
	gpointer _tmp72_;
	gboolean _tmp73_;
	GeeSortedSet* _tmp74_;
	GearyAppSearchFolderEmailEntry* _tmp75_;
	GeeLinkedList* _tmp76_;
	GearyEmailIdentifier* _tmp77_;
	GeeSortedSet* _tmp78_;
	GeeSortedSet* _tmp79_;
	GeeMap* _tmp80_;
	GeeMap* _tmp81_;
	GearyAppSearchFolderFolderPropertiesImpl* _tmp82_;
	GeeSortedSet* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	GearyFolderCountChangeReason reason;
	GeeLinkedList* _tmp86_;
	gint _tmp87_;
	gint _tmp88_;
	GeeLinkedList* _tmp89_;
	GeeLinkedList* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GeeLinkedList* _tmp93_;
	GeeSortedSet* _tmp94_;
	gint _tmp95_;
	gint _tmp96_;
	GeeSortedSet* _tmp97_;
	gint _tmp98_;
	gint _tmp99_;
	GeeMap* _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	GeeSortedSet* _tmp103_;
	gint _tmp104_;
	gint _tmp105_;
	GeeMap* _tmp106_;
	gint _tmp107_;
	gint _tmp108_;
	GError* _inner_error0_;
};

struct _GearyAppSearchFolderFolderPropertiesImpl {
	GearyFolderProperties parent_instance;
	GearyAppSearchFolderFolderPropertiesImplPrivate * priv;
};

struct _GearyAppSearchFolderFolderPropertiesImplClass {
	GearyFolderPropertiesClass parent_class;
};

struct _GearyAppSearchFolderParamSpecEmailEntry {
	GParamSpec parent_instance;
};

static gint GearyAppSearchFolder_private_offset;
static gpointer geary_app_search_folder_parent_class = NULL;
static gpointer geary_app_search_folder_folder_properties_impl_parent_class = NULL;
static gpointer geary_app_search_folder_email_entry_parent_class = NULL;
static GearyFolderSupportRemoveIface * geary_app_search_folder_geary_folder_support_remove_parent_iface = NULL;

static GType geary_app_search_folder_folder_properties_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer geary_app_search_folder_email_entry_ref (gpointer instance);
static void geary_app_search_folder_email_entry_unref (gpointer instance);
static GParamSpec* geary_app_search_folder_param_spec_email_entry (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags) G_GNUC_UNUSED ;
static void geary_app_search_folder_value_set_email_entry (GValue* value,
                                                    gpointer v_object) G_GNUC_UNUSED ;
static void geary_app_search_folder_value_take_email_entry (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED ;
static gpointer geary_app_search_folder_value_get_email_entry (const GValue* value) G_GNUC_UNUSED ;
static GType geary_app_search_folder_email_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void geary_app_search_folder_on_folders_available_unavailable (GearyAppSearchFolder* self,
                                                               GeeCollection* available,
                                                               GeeCollection* unavailable);
static void _geary_app_search_folder_on_folders_available_unavailable_geary_account_folders_available_unavailable (GearyAccount* _sender,
                                                                                                            GeeBidirSortedSet* available,
                                                                                                            GeeBidirSortedSet* unavailable,
                                                                                                            gpointer self);
static void geary_app_search_folder_on_folders_use_changed (GearyAppSearchFolder* self,
                                                     GeeCollection* folders);
static void _geary_app_search_folder_on_folders_use_changed_geary_account_folders_use_changed (GearyAccount* _sender,
                                                                                        GeeCollection* altered,
                                                                                        gpointer self);
static void geary_app_search_folder_on_email_locally_complete (GearyAppSearchFolder* self,
                                                        GearyFolder* folder,
                                                        GeeCollection* ids);
static void _geary_app_search_folder_on_email_locally_complete_geary_account_email_locally_complete (GearyAccount* _sender,
                                                                                              GearyFolder* folder,
                                                                                              GeeCollection* ids,
                                                                                              gpointer self);
static void geary_app_search_folder_on_account_email_removed (GearyAppSearchFolder* self,
                                                       GearyFolder* folder,
                                                       GeeCollection* ids);
static void _geary_app_search_folder_on_account_email_removed_geary_account_email_removed (GearyAccount* _sender,
                                                                                    GearyFolder* folder,
                                                                                    GeeCollection* ids,
                                                                                    gpointer self);
static void _geary_app_search_folder_on_account_email_removed_geary_account_email_locally_removed (GearyAccount* _sender,
                                                                                            GearyFolder* folder,
                                                                                            GeeCollection* ids,
                                                                                            gpointer self);
static GearyAppSearchFolderFolderPropertiesImpl* geary_app_search_folder_folder_properties_impl_new (gint total,
                                                                                              gint unread);
static GearyAppSearchFolderFolderPropertiesImpl* geary_app_search_folder_folder_properties_impl_construct (GType object_type,
                                                                                                    gint total,
                                                                                                    gint unread);
static inline GeeSortedSet* geary_app_search_folder_new_entry_set (GearyAppSearchFolder* self);
static inline GeeMap* geary_app_search_folder_new_id_map (GearyAppSearchFolder* self);
static void geary_app_search_folder_exclude_orphan_emails (GearyAppSearchFolder* self);
static void geary_app_search_folder_update (GearyAppSearchFolder* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void geary_app_search_folder_update_finish (GearyAppSearchFolder* self,
                                            GAsyncResult* _res_);
static void geary_app_search_folder_get_search_matches_async_data_free (gpointer _data);
static gboolean geary_app_search_folder_get_search_matches_async_co (GearyAppSearchFolderGetSearchMatchesAsyncData* _data_);
static GeeList* geary_app_search_folder_check_ids (GearyAppSearchFolder* self,
                                            GeeCollection* to_check);
static void geary_app_search_folder_get_search_matches_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void geary_app_search_folder_real_contains_identifiers_data_free (gpointer _data);
static void geary_app_search_folder_real_contains_identifiers (GearyFolder* base,
                                                        GeeCollection* ids,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean geary_app_search_folder_real_contains_identifiers_co (GearyAppSearchFolderContainsIdentifiersData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void geary_app_search_folder_contains_identifiers_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static gboolean __lambda177_ (Block17Data* _data17_,
                       GearyEmailIdentifier* id);
static gboolean ___lambda177__gee_predicate (gconstpointer g,
                                      gpointer self);
static void geary_app_search_folder_real_list_email_by_id_async_data_free (gpointer _data);
static void geary_app_search_folder_real_list_email_by_id_async (GearyFolder* base,
                                                          GearyEmailIdentifier* initial_id,
                                                          gint count,
                                                          GearyEmailField required_fields,
                                                          GearyFolderListFlags flags,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean geary_app_search_folder_real_list_email_by_id_async_co (GearyAppSearchFolderListEmailByIdAsyncData* _data_);
static void geary_app_search_folder_list_email_by_id_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void geary_app_search_folder_real_list_email_by_sparse_id_async_data_free (gpointer _data);
static void geary_app_search_folder_real_list_email_by_sparse_id_async (GearyFolder* base,
                                                                 GeeCollection* list,
                                                                 GearyEmailField required_fields,
                                                                 GearyFolderListFlags flags,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean geary_app_search_folder_real_list_email_by_sparse_id_async_co (GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_);
static void geary_app_search_folder_list_email_by_sparse_id_async_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void geary_app_search_folder_real_fetch_email_async_data_free (gpointer _data);
static void geary_app_search_folder_real_fetch_email_async (GearyFolder* base,
                                                     GearyEmailIdentifier* fetch,
                                                     GearyEmailField required_fields,
                                                     GearyFolderListFlags flags,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean geary_app_search_folder_real_fetch_email_async_co (GearyAppSearchFolderFetchEmailAsyncData* _data_);
static void geary_app_search_folder_require_id (GearyAppSearchFolder* self,
                                         GearyEmailIdentifier* id,
                                         GError** error);
static void geary_app_search_folder_fetch_email_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void geary_app_search_folder_real_remove_email_async_data_free (gpointer _data);
static void geary_app_search_folder_real_remove_email_async (GearyAppSearchFolder* self,
                                                      GeeCollection* remove,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean geary_app_search_folder_real_remove_email_async_co (GearyAppSearchFolderRemoveEmailAsyncData* _data_);
static void geary_app_search_folder_remove_email_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void geary_app_search_folder_real_set_used_as_custom (GearyFolder* base,
                                                      gboolean enabled,
                                                      GError** error);
static void geary_app_search_folder_append_data_free (gpointer _data);
static void geary_app_search_folder_append (GearyAppSearchFolder* self,
                                     GearyFolder* folder,
                                     GeeCollection* ids,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void geary_app_search_folder_append_finish (GearyAppSearchFolder* self,
                                            GAsyncResult* _res_);
static gboolean geary_app_search_folder_append_co (GearyAppSearchFolderAppendData* _data_);
static void geary_app_search_folder_append_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void geary_app_search_folder_do_search_async (GearyAppSearchFolder* self,
                                              GeeCollection* add_ids,
                                              GeeCollection* remove_ids,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void geary_app_search_folder_do_search_finish (GearyAppSearchFolder* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void geary_app_search_folder_update_data_free (gpointer _data);
static gboolean geary_app_search_folder_update_co (GearyAppSearchFolderUpdateData* _data_);
static void geary_app_search_folder_update_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void geary_app_search_folder_remove_data_free (gpointer _data);
static void geary_app_search_folder_remove (GearyAppSearchFolder* self,
                                     GearyFolder* folder,
                                     GeeCollection* ids,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void geary_app_search_folder_remove_finish (GearyAppSearchFolder* self,
                                            GAsyncResult* _res_);
static gboolean geary_app_search_folder_remove_co (GearyAppSearchFolderRemoveData* _data_);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void geary_app_search_folder_remove_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean ___lambda176_ (Block18Data* _data18_,
                        GearyEmailIdentifier* id);
static gboolean ____lambda176__gee_predicate (gconstpointer g,
                                       gpointer self);
static void geary_app_search_folder_do_search_async_data_free (gpointer _data);
static gboolean geary_app_search_folder_do_search_async_co (GearyAppSearchFolderDoSearchAsyncData* _data_);
static void geary_app_search_folder_do_search_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static GearyAppSearchFolderEmailEntry* geary_app_search_folder_email_entry_new (GearyEmailIdentifier* id,
                                                                         GDateTime* received);
static GearyAppSearchFolderEmailEntry* geary_app_search_folder_email_entry_construct (GType object_type,
                                                                               GearyEmailIdentifier* id,
                                                                               GDateTime* received);
static void geary_app_search_folder_folder_properties_impl_set_total (GearyAppSearchFolderFolderPropertiesImpl* self,
                                                               gint total);
static gint geary_app_search_folder_email_entry_compare_to (GearyAppSearchFolderEmailEntry* a,
                                                     GearyAppSearchFolderEmailEntry* b);
static gint _geary_app_search_folder_email_entry_compare_to_gcompare_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static void geary_app_search_folder_include_folder (GearyAppSearchFolder* self,
                                             GearyFolder* folder);
static void geary_app_search_folder_exclude_folder (GearyAppSearchFolder* self,
                                             GearyFolder* folder);
static gboolean ___lambda175_ (GearyAppSearchFolder* self,
                        GearyFolder* f);
static gboolean _vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                                        gssize stack_length,
                                                        const GearyFolderSpecialUse needle);
static gboolean ____lambda175__gee_predicate (gconstpointer g,
                                       gpointer self);
static GType geary_app_search_folder_folder_properties_impl_get_type_once (void);
static void geary_app_search_folder_email_entry_finalize (GearyAppSearchFolderEmailEntry * obj);
static GType geary_app_search_folder_email_entry_get_type_once (void);
static void geary_app_search_folder_finalize (GObject * obj);
static GType geary_app_search_folder_get_type_once (void);
static void _vala_geary_app_search_folder_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_app_search_folder_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static const GearyFolderSpecialUse GEARY_APP_SEARCH_FOLDER_EXCLUDE_TYPES[3] = {GEARY_FOLDER_SPECIAL_USE_DRAFTS, GEARY_FOLDER_SPECIAL_USE_JUNK, GEARY_FOLDER_SPECIAL_USE_TRASH};

static inline gpointer
geary_app_search_folder_get_instance_private (GearyAppSearchFolder* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppSearchFolder_private_offset);
}

static void
_geary_app_search_folder_on_folders_available_unavailable_geary_account_folders_available_unavailable (GearyAccount* _sender,
                                                                                                       GeeBidirSortedSet* available,
                                                                                                       GeeBidirSortedSet* unavailable,
                                                                                                       gpointer self)
{
	geary_app_search_folder_on_folders_available_unavailable ((GearyAppSearchFolder*) self, available, unavailable);
}

static void
_geary_app_search_folder_on_folders_use_changed_geary_account_folders_use_changed (GearyAccount* _sender,
                                                                                   GeeCollection* altered,
                                                                                   gpointer self)
{
	geary_app_search_folder_on_folders_use_changed ((GearyAppSearchFolder*) self, altered);
}

static void
_geary_app_search_folder_on_email_locally_complete_geary_account_email_locally_complete (GearyAccount* _sender,
                                                                                         GearyFolder* folder,
                                                                                         GeeCollection* ids,
                                                                                         gpointer self)
{
	geary_app_search_folder_on_email_locally_complete ((GearyAppSearchFolder*) self, folder, ids);
}

static void
_geary_app_search_folder_on_account_email_removed_geary_account_email_removed (GearyAccount* _sender,
                                                                               GearyFolder* folder,
                                                                               GeeCollection* ids,
                                                                               gpointer self)
{
	geary_app_search_folder_on_account_email_removed ((GearyAppSearchFolder*) self, folder, ids);
}

static void
_geary_app_search_folder_on_account_email_removed_geary_account_email_locally_removed (GearyAccount* _sender,
                                                                                       GearyFolder* folder,
                                                                                       GeeCollection* ids,
                                                                                       gpointer self)
{
	geary_app_search_folder_on_account_email_removed ((GearyAppSearchFolder*) self, folder, ids);
}

static GearyAccount*
geary_app_search_folder_real_get_account (GearyFolder* base)
{
	GearyAccount* result;
	GearyAppSearchFolder* self;
	GearyAccount* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static GearyFolderProperties*
geary_app_search_folder_real_get_properties (GearyFolder* base)
{
	GearyFolderProperties* result;
	GearyAppSearchFolder* self;
	GearyAppSearchFolderFolderPropertiesImpl* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_tmp0_ = self->priv->_properties;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties);
	return result;
}

static GearyFolderPath*
geary_app_search_folder_real_get_path (GearyFolder* base)
{
	GearyFolderPath* result;
	GearyAppSearchFolder* self;
	GearyFolderPath* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static GearyFolderSpecialUse
geary_app_search_folder_real_get_used_as (GearyFolder* base)
{
	GearyFolderSpecialUse result;
	GearyAppSearchFolder* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	result = GEARY_FOLDER_SPECIAL_USE_SEARCH;
	return result;
}

GearySearchQuery*
geary_app_search_folder_get_query (GearyAppSearchFolder* self)
{
	GearySearchQuery* result;
	GearySearchQuery* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self), NULL);
	_tmp0_ = self->priv->_query;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_app_search_folder_set_query (GearyAppSearchFolder* self,
                                   GearySearchQuery* value)
{
	GearySearchQuery* old_value;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	old_value = geary_app_search_folder_get_query (self);
	if (old_value != value) {
		GearySearchQuery* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_query);
		self->priv->_query = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY]);
	}
}

GearyAppSearchFolder*
geary_app_search_folder_construct (GType object_type,
                                   GearyAccount* account,
                                   GearyFolderRoot* root)
{
	GearyAppSearchFolder * self = NULL;
	GearyAppSearchFolderFolderPropertiesImpl* _tmp0_;
	GearyFolderPath* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeMap* _tmp3_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (root), NULL);
	self = (GearyAppSearchFolder*) geary_abstract_local_folder_construct (object_type);
	self->priv->_account = account;
	_tmp0_ = geary_app_search_folder_folder_properties_impl_new (0, 0);
	_g_object_unref0 (self->priv->_properties);
	self->priv->_properties = _tmp0_;
	_tmp1_ = geary_folder_path_get_child (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_TYPE_FOLDER_PATH, GearyFolderPath), GEARY_APP_SEARCH_FOLDER_MAGIC_BASENAME, GEARY_TRILLIAN_TRUE);
	_g_object_unref0 (self->priv->_path);
	self->priv->_path = _tmp1_;
	g_signal_connect_object (account, "folders-available-unavailable", (GCallback) _geary_app_search_folder_on_folders_available_unavailable_geary_account_folders_available_unavailable, self, 0);
	g_signal_connect_object (account, "folders-use-changed", (GCallback) _geary_app_search_folder_on_folders_use_changed_geary_account_folders_use_changed, self, 0);
	g_signal_connect_object (account, "email-locally-complete", (GCallback) _geary_app_search_folder_on_email_locally_complete_geary_account_email_locally_complete, self, 0);
	g_signal_connect_object (account, "email-removed", (GCallback) _geary_app_search_folder_on_account_email_removed_geary_account_email_removed, self, 0);
	g_signal_connect_object (account, "email-locally-removed", (GCallback) _geary_app_search_folder_on_account_email_removed_geary_account_email_locally_removed, self, 0);
	_tmp2_ = geary_app_search_folder_new_entry_set (self);
	_g_object_unref0 (self->priv->entries);
	self->priv->entries = _tmp2_;
	_tmp3_ = geary_app_search_folder_new_id_map (self);
	_g_object_unref0 (self->priv->ids);
	self->priv->ids = _tmp3_;
	geary_app_search_folder_exclude_orphan_emails (self);
	return self;
}

GearyAppSearchFolder*
geary_app_search_folder_new (GearyAccount* account,
                             GearyFolderRoot* root)
{
	return geary_app_search_folder_construct (GEARY_APP_TYPE_SEARCH_FOLDER, account, root);
}

/**
     * Sets the current search query for the folder.
     *
     * Calling this method will start the search folder asynchronously
     * in the background. If the given query is not equal to the
     * existing query, the folder's contents will be updated to
     * reflect the changed query.
     */
void
geary_app_search_folder_update_query (GearyAppSearchFolder* self,
                                      GearySearchQuery* query)
{
	gboolean _tmp0_ = FALSE;
	GearySearchQuery* _tmp1_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_SEARCH_QUERY (query));
	_tmp1_ = self->priv->_query;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GearySearchQuery* _tmp2_;
		_tmp2_ = self->priv->_query;
		_tmp0_ = !geary_search_query_equal_to (_tmp2_, query);
	}
	if (_tmp0_) {
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = self->priv->executing;
		g_cancellable_cancel (_tmp3_);
		_tmp4_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->executing);
		self->priv->executing = _tmp4_;
		geary_app_search_folder_set_query (self, query);
		geary_app_search_folder_update (self, NULL, NULL);
	}
}

/**
     * Cancels and clears the search query and results.
     *
     * The {@link query} property will be set to null.
     */
void
geary_app_search_folder_clear_query (GearyAppSearchFolder* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeMap* old_ids = NULL;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeMap* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	_tmp0_ = self->priv->executing;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->executing);
	self->priv->executing = _tmp1_;
	geary_app_search_folder_set_query (self, NULL);
	_tmp2_ = self->priv->ids;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_ids = _tmp3_;
	_tmp4_ = geary_app_search_folder_new_entry_set (self);
	_g_object_unref0 (self->priv->entries);
	self->priv->entries = _tmp4_;
	_tmp5_ = geary_app_search_folder_new_id_map (self);
	_g_object_unref0 (self->priv->ids);
	self->priv->ids = _tmp5_;
	_tmp6_ = gee_map_get_keys (old_ids);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	geary_folder_notify_email_removed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_tmp8_);
	geary_folder_notify_email_count_changed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder), 0, GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED);
	_g_object_unref0 (old_ids);
}

static void
geary_app_search_folder_get_search_matches_async_data_free (gpointer _data)
{
	GearyAppSearchFolderGetSearchMatchesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->targets);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderGetSearchMatchesAsyncData, _data_);
}

void
geary_app_search_folder_get_search_matches_async (GearyAppSearchFolder* self,
                                                  GeeCollection* targets,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GearyAppSearchFolderGetSearchMatchesAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (targets, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppSearchFolderGetSearchMatchesAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_get_search_matches_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (targets);
	_g_object_unref0 (_data_->targets);
	_data_->targets = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_get_search_matches_async_co (_data_);
}

GeeSet*
geary_app_search_folder_get_search_matches_finish (GearyAppSearchFolder* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GeeSet* result;
	GearyAppSearchFolderGetSearchMatchesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a set of case-folded words matched by the current query.
     *
     * The set contains words from the given collection of email that
     * match any of the non-negated text operators in {@link query}.
     */
static void
geary_app_search_folder_get_search_matches_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GearyAppSearchFolderGetSearchMatchesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_get_search_matches_async_co (_data_);
}

static gboolean
geary_app_search_folder_get_search_matches_async_co (GearyAppSearchFolderGetSearchMatchesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->results = NULL;
	_data_->_tmp0_ = _data_->self->priv->_query;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp2_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->_query;
		_data_->_tmp5_ = geary_app_search_folder_check_ids (_data_->self, _data_->targets);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		geary_account_get_search_matches_async (_data_->_tmp3_, _data_->_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), _data_->cancellable, geary_app_search_folder_get_search_matches_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = geary_account_get_search_matches_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_tmp1_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->results);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->results);
		_data_->results = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp1_);
	}
	_data_->result = _data_->results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_real_contains_identifiers_data_free (gpointer _data)
{
	GearyAppSearchFolderContainsIdentifiersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderContainsIdentifiersData, _data_);
}

static void
geary_app_search_folder_real_contains_identifiers (GearyFolder* base,
                                                   GeeCollection* ids,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GearyAppSearchFolder * self;
	GearyAppSearchFolderContainsIdentifiersData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_data_ = g_slice_new0 (GearyAppSearchFolderContainsIdentifiersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_real_contains_identifiers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ids);
	_g_object_unref0 (_data_->ids);
	_data_->ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_real_contains_identifiers_co (_data_);
}

static GeeCollection*
geary_app_search_folder_contains_identifiers_finish (GearyFolder* base,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GeeCollection* result;
	GearyAppSearchFolderContainsIdentifiersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/** {@inheritDoc} */
static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GearyAppSearchFolder* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->existing_ids);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
geary_app_search_folder_contains_identifiers_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearyAppSearchFolderContainsIdentifiersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_real_contains_identifiers_co (_data_);
}

static gboolean
__lambda177_ (Block17Data* _data17_,
              GearyEmailIdentifier* id)
{
	GearyAppSearchFolder* self;
	GeeMap* _tmp0_;
	gboolean result;
	self = _data17_->self;
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), FALSE);
	_tmp0_ = _data17_->existing_ids;
	result = gee_map_has_key (_tmp0_, id);
	return result;
}

static gboolean
___lambda177__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda177_ (self, (GearyEmailIdentifier*) g);
	return result;
}

static gboolean
geary_app_search_folder_real_contains_identifiers_co (GearyAppSearchFolderContainsIdentifiersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data17_ = g_slice_new0 (Block17Data);
	_data_->_data17_->_ref_count_ = 1;
	_data_->_data17_->self = g_object_ref (_data_->self);
	_data_->_data17_->_async_data_ = _data_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting for checking contains");
	_data_->_tmp0_ = _data_->self->priv->result_mutex;
	_data_->_state_ = 1;
	geary_nonblocking_mutex_claim_async (_data_->_tmp0_, _data_->cancellable, geary_app_search_folder_contains_identifiers_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result_mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block17_data_unref (_data_->_data17_);
		_data_->_data17_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->ids;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->_data17_->existing_ids = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->result_mutex;
	geary_nonblocking_mutex_release (_data_->_tmp3_, &_data_->result_mutex_token, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block17_data_unref (_data_->_data17_);
		_data_->_data17_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Checking contains");
	_data_->_tmp4_ = geary_traverse (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data_->ids, GEE_TYPE_ITERABLE, GeeIterable));
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = geary_iterable_filter (_data_->_tmp5_, ___lambda177__gee_predicate, block17_data_ref (_data_->_data17_), block17_data_unref);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = geary_iterable_to_hash_set (_data_->_tmp7_, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEE_TYPE_COLLECTION, GeeCollection);
	_g_object_unref0 (_data_->_tmp7_);
	_g_object_unref0 (_data_->_tmp5_);
	_data_->result = _data_->_tmp9_;
	block17_data_unref (_data_->_data17_);
	_data_->_data17_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_real_list_email_by_id_async_data_free (gpointer _data)
{
	GearyAppSearchFolderListEmailByIdAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->initial_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderListEmailByIdAsyncData, _data_);
}

static void
geary_app_search_folder_real_list_email_by_id_async (GearyFolder* base,
                                                     GearyEmailIdentifier* initial_id,
                                                     gint count,
                                                     GearyEmailField required_fields,
                                                     GearyFolderListFlags flags,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyAppSearchFolder * self;
	GearyAppSearchFolderListEmailByIdAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail ((initial_id == NULL) || GEARY_IS_EMAIL_IDENTIFIER (initial_id));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_data_ = g_slice_new0 (GearyAppSearchFolderListEmailByIdAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_real_list_email_by_id_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (initial_id);
	_g_object_unref0 (_data_->initial_id);
	_data_->initial_id = _tmp1_;
	_data_->count = count;
	_data_->required_fields = required_fields;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_real_list_email_by_id_async_co (_data_);
}

static GeeList*
geary_app_search_folder_list_email_by_id_finish (GearyFolder* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GeeList* result;
	GearyAppSearchFolderListEmailByIdAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_app_search_folder_list_email_by_id_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearyAppSearchFolderListEmailByIdAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_real_list_email_by_id_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_app_search_folder_real_list_email_by_id_async_co (GearyAppSearchFolderListEmailByIdAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting to list email");
	_data_->_tmp0_ = _data_->self->priv->result_mutex;
	_data_->_state_ = 1;
	geary_nonblocking_mutex_claim_async (_data_->_tmp0_, _data_->cancellable, geary_app_search_folder_list_email_by_id_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result_mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->entries;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->existing_entries = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->ids;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->existing_ids = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->result_mutex;
	geary_nonblocking_mutex_release (_data_->_tmp5_, &_data_->result_mutex_token, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->existing_ids);
		_g_object_unref0 (_data_->existing_entries);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Listing email");
	_data_->_tmp6_ = gee_linked_list_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->engine_ids = _data_->_tmp6_;
	if ((_data_->flags & GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST) == GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST) {
		_data_->oldest = NULL;
		_data_->_tmp7_ = _data_->existing_entries;
		_data_->_tmp8_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp9_ = _data_->_tmp8_;
		if (!_data_->_tmp9_) {
			if (_data_->initial_id == NULL) {
				_data_->_tmp10_ = _data_->existing_entries;
				_data_->_tmp11_ = gee_sorted_set_last (_data_->_tmp10_);
				_geary_app_search_folder_email_entry_unref0 (_data_->oldest);
				_data_->oldest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp11_;
			} else {
				_data_->_tmp12_ = _data_->existing_ids;
				_data_->_tmp13_ = gee_map_get (_data_->_tmp12_, _data_->initial_id);
				_geary_app_search_folder_email_entry_unref0 (_data_->oldest);
				_data_->oldest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp13_;
				_data_->_tmp14_ = _data_->oldest;
				if (_data_->_tmp14_ == NULL) {
					_data_->_tmp15_ = geary_email_identifier_to_string (_data_->initial_id);
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp17_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Initial id not found: %s", _data_->_tmp16_);
					_data_->_tmp18_ = _data_->_tmp17_;
					_g_free0 (_data_->_tmp16_);
					_data_->_inner_error0_ = _data_->_tmp18_;
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_geary_app_search_folder_email_entry_unref0 (_data_->oldest);
					_g_object_unref0 (_data_->engine_ids);
					_g_object_unref0 (_data_->existing_ids);
					_g_object_unref0 (_data_->existing_entries);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				if (!((_data_->flags & GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID) == GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID)) {
					_data_->_tmp19_ = _data_->existing_entries;
					_data_->_tmp20_ = _data_->oldest;
					_data_->_tmp21_ = gee_sorted_set_higher (_data_->_tmp19_, _data_->_tmp20_);
					_geary_app_search_folder_email_entry_unref0 (_data_->oldest);
					_data_->oldest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp21_;
				}
			}
		}
		_data_->_tmp22_ = _data_->oldest;
		if (_data_->_tmp22_ != NULL) {
			_data_->_tmp23_ = _data_->existing_entries;
			_data_->_tmp24_ = _data_->oldest;
			_data_->_tmp25_ = gee_sorted_set_iterator_at (_data_->_tmp23_, _data_->_tmp24_);
			_data_->_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp25_, GEE_TYPE_BIDIR_ITERATOR) ? ((GeeBidirIterator*) _data_->_tmp25_) : NULL;
			if (_data_->_tmp26_ == NULL) {
				_g_object_unref0 (_data_->_tmp25_);
			}
			_data_->iter = _data_->_tmp26_;
			_data_->_tmp27_ = _data_->engine_ids;
			_data_->_tmp28_ = _data_->oldest;
			_data_->_tmp29_ = _data_->_tmp28_->id;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp29_);
			while (TRUE) {
				_data_->_tmp31_ = _data_->engine_ids;
				_data_->_tmp32_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_data_->_tmp33_ = _data_->_tmp32_;
				if (_data_->_tmp33_ < _data_->count) {
					_data_->_tmp34_ = _data_->iter;
					_data_->_tmp30_ = gee_bidir_iterator_previous (_data_->_tmp34_);
				} else {
					_data_->_tmp30_ = FALSE;
				}
				if (!_data_->_tmp30_) {
					break;
				}
				_data_->_tmp35_ = _data_->engine_ids;
				_data_->_tmp36_ = _data_->iter;
				_data_->_tmp37_ = gee_iterator_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp36_, GEE_TYPE_ITERATOR, GeeIterator));
				_data_->_tmp38_ = (GearyAppSearchFolderEmailEntry*) _data_->_tmp37_;
				_data_->_tmp39_ = _data_->_tmp38_->id;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp39_);
				_geary_app_search_folder_email_entry_unref0 (_data_->_tmp38_);
			}
			_g_object_unref0 (_data_->iter);
		}
		_geary_app_search_folder_email_entry_unref0 (_data_->oldest);
	} else {
		_data_->newest = NULL;
		_data_->_tmp40_ = _data_->existing_entries;
		_data_->_tmp41_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp42_ = _data_->_tmp41_;
		if (!_data_->_tmp42_) {
			if (_data_->initial_id == NULL) {
				_data_->_tmp43_ = _data_->existing_entries;
				_data_->_tmp44_ = gee_sorted_set_first (_data_->_tmp43_);
				_geary_app_search_folder_email_entry_unref0 (_data_->newest);
				_data_->newest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp44_;
			} else {
				_data_->_tmp45_ = _data_->existing_ids;
				_data_->_tmp46_ = gee_map_get (_data_->_tmp45_, _data_->initial_id);
				_geary_app_search_folder_email_entry_unref0 (_data_->newest);
				_data_->newest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp46_;
				_data_->_tmp47_ = _data_->newest;
				if (_data_->_tmp47_ == NULL) {
					_data_->_tmp48_ = geary_email_identifier_to_string (_data_->initial_id);
					_data_->_tmp49_ = _data_->_tmp48_;
					_data_->_tmp50_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Initial id not found: %s", _data_->_tmp49_);
					_data_->_tmp51_ = _data_->_tmp50_;
					_g_free0 (_data_->_tmp49_);
					_data_->_inner_error0_ = _data_->_tmp51_;
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_geary_app_search_folder_email_entry_unref0 (_data_->newest);
					_g_object_unref0 (_data_->engine_ids);
					_g_object_unref0 (_data_->existing_ids);
					_g_object_unref0 (_data_->existing_entries);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				if (!((_data_->flags & GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID) == GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID)) {
					_data_->_tmp52_ = _data_->existing_entries;
					_data_->_tmp53_ = _data_->newest;
					_data_->_tmp54_ = gee_sorted_set_lower (_data_->_tmp52_, _data_->_tmp53_);
					_geary_app_search_folder_email_entry_unref0 (_data_->newest);
					_data_->newest = (GearyAppSearchFolderEmailEntry*) _data_->_tmp54_;
				}
			}
		}
		_data_->_tmp55_ = _data_->newest;
		if (_data_->_tmp55_ != NULL) {
			_data_->_tmp56_ = _data_->existing_entries;
			_data_->_tmp57_ = _data_->newest;
			_data_->_tmp58_ = gee_sorted_set_iterator_at (_data_->_tmp56_, _data_->_tmp57_);
			_data_->_tmp59_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp58_, GEE_TYPE_BIDIR_ITERATOR) ? ((GeeBidirIterator*) _data_->_tmp58_) : NULL;
			if (_data_->_tmp59_ == NULL) {
				_g_object_unref0 (_data_->_tmp58_);
			}
			_data_->_vala1_iter = _data_->_tmp59_;
			_data_->_tmp60_ = _data_->engine_ids;
			_data_->_tmp61_ = _data_->newest;
			_data_->_tmp62_ = _data_->_tmp61_->id;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp60_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp62_);
			while (TRUE) {
				_data_->_tmp64_ = _data_->engine_ids;
				_data_->_tmp65_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp64_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_data_->_tmp66_ = _data_->_tmp65_;
				if (_data_->_tmp66_ < _data_->count) {
					_data_->_tmp67_ = _data_->_vala1_iter;
					_data_->_tmp63_ = gee_iterator_next (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp67_, GEE_TYPE_ITERATOR, GeeIterator));
				} else {
					_data_->_tmp63_ = FALSE;
				}
				if (!_data_->_tmp63_) {
					break;
				}
				_data_->_tmp68_ = _data_->engine_ids;
				_data_->_tmp69_ = _data_->_vala1_iter;
				_data_->_tmp70_ = gee_iterator_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp69_, GEE_TYPE_ITERATOR, GeeIterator));
				_data_->_tmp71_ = (GearyAppSearchFolderEmailEntry*) _data_->_tmp70_;
				_data_->_tmp72_ = _data_->_tmp71_->id;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp68_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp72_);
				_geary_app_search_folder_email_entry_unref0 (_data_->_tmp71_);
			}
			_g_object_unref0 (_data_->_vala1_iter);
		}
		_geary_app_search_folder_email_entry_unref0 (_data_->newest);
	}
	_data_->results = NULL;
	_data_->list_error = NULL;
	_data_->_tmp73_ = _data_->engine_ids;
	_data_->_tmp74_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp73_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp75_ = _data_->_tmp74_;
	if (!_data_->_tmp75_) {
		{
			_data_->_tmp77_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp78_ = _data_->_tmp77_;
			_data_->_tmp79_ = _data_->engine_ids;
			_data_->_state_ = 2;
			geary_account_list_local_email_async (_data_->_tmp78_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp79_, GEE_TYPE_COLLECTION, GeeCollection), _data_->required_fields, _data_->cancellable, geary_app_search_folder_list_email_by_id_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp80_ = geary_account_list_local_email_finish (_data_->_tmp78_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp76_ = _data_->_tmp80_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp81_ = _data_->_tmp76_;
			_data_->_tmp76_ = NULL;
			_g_object_unref0 (_data_->results);
			_data_->results = _data_->_tmp81_;
			_g_object_unref0 (_data_->_tmp76_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp82_ = _data_->_error_;
			_data_->_tmp83_ = _g_error_copy0 (_data_->_tmp82_);
			_g_error_free0 (_data_->list_error);
			_data_->list_error = _data_->_tmp83_;
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_error_free0 (_data_->list_error);
			_g_object_unref0 (_data_->results);
			_g_object_unref0 (_data_->engine_ids);
			_g_object_unref0 (_data_->existing_ids);
			_g_object_unref0 (_data_->existing_entries);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp84_ = _data_->list_error;
	if (_data_->_tmp84_ != NULL) {
		_data_->_tmp85_ = _data_->list_error;
		_data_->_tmp86_ = _g_error_copy0 (_data_->_tmp85_);
		_data_->_inner_error0_ = _data_->_tmp86_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->list_error);
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->engine_ids);
		_g_object_unref0 (_data_->existing_ids);
		_g_object_unref0 (_data_->existing_entries);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->results;
	_g_error_free0 (_data_->list_error);
	_g_object_unref0 (_data_->engine_ids);
	_g_object_unref0 (_data_->existing_ids);
	_g_object_unref0 (_data_->existing_entries);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_real_list_email_by_sparse_id_async_data_free (gpointer _data)
{
	GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->list);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderListEmailBySparseIdAsyncData, _data_);
}

static void
geary_app_search_folder_real_list_email_by_sparse_id_async (GearyFolder* base,
                                                            GeeCollection* list,
                                                            GearyEmailField required_fields,
                                                            GearyFolderListFlags flags,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyAppSearchFolder * self;
	GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (list, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_data_ = g_slice_new0 (GearyAppSearchFolderListEmailBySparseIdAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_real_list_email_by_sparse_id_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (list);
	_g_object_unref0 (_data_->list);
	_data_->list = _tmp1_;
	_data_->required_fields = required_fields;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_real_list_email_by_sparse_id_async_co (_data_);
}

static GeeList*
geary_app_search_folder_list_email_by_sparse_id_finish (GearyFolder* base,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	GeeList* result;
	GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_app_search_folder_list_email_by_sparse_id_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_real_list_email_by_sparse_id_async_co (_data_);
}

static gboolean
geary_app_search_folder_real_list_email_by_sparse_id_async_co (GearyAppSearchFolderListEmailBySparseIdAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = geary_app_search_folder_check_ids (_data_->self, _data_->list);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	geary_account_list_local_email_async (_data_->_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), _data_->required_fields, _data_->cancellable, geary_app_search_folder_list_email_by_sparse_id_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = geary_account_list_local_email_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp4_);
	_data_->_tmp0_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_real_fetch_email_async_data_free (gpointer _data)
{
	GearyAppSearchFolderFetchEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->fetch);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderFetchEmailAsyncData, _data_);
}

static void
geary_app_search_folder_real_fetch_email_async (GearyFolder* base,
                                                GearyEmailIdentifier* fetch,
                                                GearyEmailField required_fields,
                                                GearyFolderListFlags flags,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyAppSearchFolder * self;
	GearyAppSearchFolderFetchEmailAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (fetch));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_data_ = g_slice_new0 (GearyAppSearchFolderFetchEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_real_fetch_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (fetch);
	_g_object_unref0 (_data_->fetch);
	_data_->fetch = _tmp1_;
	_data_->required_fields = required_fields;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_real_fetch_email_async_co (_data_);
}

static GearyEmail*
geary_app_search_folder_fetch_email_finish (GearyFolder* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GearyEmail* result;
	GearyAppSearchFolderFetchEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_app_search_folder_fetch_email_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GearyAppSearchFolderFetchEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_real_fetch_email_async_co (_data_);
}

static gboolean
geary_app_search_folder_real_fetch_email_async_co (GearyAppSearchFolderFetchEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_app_search_folder_require_id (_data_->self, _data_->fetch, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	geary_account_local_fetch_email_async (_data_->_tmp2_, _data_->fetch, _data_->required_fields, _data_->cancellable, geary_app_search_folder_fetch_email_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = geary_account_local_fetch_email_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_real_remove_email_async_data_free (gpointer _data)
{
	GearyAppSearchFolderRemoveEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remove);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderRemoveEmailAsyncData, _data_);
}

static void
geary_app_search_folder_real_remove_email_async (GearyAppSearchFolder* self,
                                                 GeeCollection* remove,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearyAppSearchFolderRemoveEmailAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (remove, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppSearchFolderRemoveEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_real_remove_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remove);
	_g_object_unref0 (_data_->remove);
	_data_->remove = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_search_folder_real_remove_email_async_co (_data_);
}

static void
geary_app_search_folder_real_remove_email_finish (GearyAppSearchFolder* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyAppSearchFolderRemoveEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_app_search_folder_remove_email_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearyAppSearchFolderRemoveEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_real_remove_email_async_co (_data_);
}

static gboolean
geary_app_search_folder_real_remove_email_async_co (GearyAppSearchFolderRemoveEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_app_search_folder_check_ids (_data_->self, _data_->remove);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	geary_account_get_containing_folders_async (_data_->_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _data_->cancellable, geary_app_search_folder_remove_email_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = geary_account_get_containing_folders_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->ids_to_folders = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->ids_to_folders;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->ids_to_folders;
		_data_->_tmp8_ = geary_collection_reverse_multi_map (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp7_);
		_data_->folders_to_ids = _data_->_tmp8_;
		{
			_data_->_tmp9_ = _data_->folders_to_ids;
			_data_->_tmp10_ = gee_multi_map_get_keys (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_tmp13_ = _data_->_tmp12_;
			_g_object_unref0 (_data_->_tmp11_);
			_data_->_path_it = _data_->_tmp13_;
			while (TRUE) {
				_data_->_tmp14_ = _data_->_path_it;
				if (!gee_iterator_next (_data_->_tmp14_)) {
					break;
				}
				_data_->_tmp15_ = _data_->_path_it;
				_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
				_data_->path = (GearyFolderPath*) _data_->_tmp16_;
				_data_->_tmp17_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp19_ = _data_->path;
				_data_->_tmp20_ = geary_account_get_folder (_data_->_tmp18_, _data_->_tmp19_, &_data_->_inner_error0_);
				_data_->folder = _data_->_tmp20_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->path);
					_g_object_unref0 (_data_->_path_it);
					_g_object_unref0 (_data_->folders_to_ids);
					_g_object_unref0 (_data_->ids_to_folders);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp21_ = _data_->folder;
				_data_->_tmp22_ = _g_object_ref0 (GEARY_FOLDER_SUPPORT_IS_REMOVE (_data_->_tmp21_) ? ((GearyFolderSupportRemove*) _data_->_tmp21_) : NULL);
				_data_->removable = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->removable;
				if (_data_->_tmp23_ != NULL) {
					_data_->_tmp24_ = _data_->folders_to_ids;
					_data_->_tmp25_ = _data_->path;
					_data_->_tmp26_ = gee_multi_map_get (_data_->_tmp24_, _data_->_tmp25_);
					_data_->ids = _data_->_tmp26_;
					_data_->_tmp27_ = _data_->ids;
					_data_->_tmp28_ = gee_collection_get_size (_data_->_tmp27_);
					_data_->_tmp29_ = _data_->_tmp28_;
					_data_->_tmp30_ = _data_->folder;
					_data_->_tmp31_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
					_data_->_tmp32_ = _data_->_tmp31_;
					geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Search folder removing %d emails from %s", _data_->_tmp29_, _data_->_tmp32_);
					_g_free0 (_data_->_tmp32_);
					_data_->open = FALSE;
					{
						_data_->_tmp33_ = _data_->folder;
						_data_->_state_ = 2;
						geary_folder_open_async (_data_->_tmp33_, GEARY_FOLDER_OPEN_FLAGS_NONE, _data_->cancellable, geary_app_search_folder_remove_email_async_ready, _data_);
						return FALSE;
						_state_2:
						geary_folder_open_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __finally0;
						}
						_data_->open = TRUE;
						_data_->_tmp34_ = _data_->removable;
						_data_->_tmp35_ = _data_->ids;
						_data_->_state_ = 3;
						geary_folder_support_remove_remove_email_async (_data_->_tmp34_, _data_->_tmp35_, _data_->cancellable, geary_app_search_folder_remove_email_async_ready, _data_);
						return FALSE;
						_state_3:
						geary_folder_support_remove_remove_email_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __finally0;
						}
					}
					__finally0:
					{
						if (_data_->open) {
							{
								_data_->_tmp36_ = _data_->folder;
								_data_->_state_ = 4;
								geary_folder_close_async (_data_->_tmp36_, NULL, geary_app_search_folder_remove_email_async_ready, _data_);
								return FALSE;
								_state_4:
								geary_folder_close_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error1_);
								if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
									goto __catch1_g_error;
								}
							}
							goto __finally1;
							__catch1_g_error:
							{
								_data_->e = _data_->_inner_error1_;
								_data_->_inner_error1_ = NULL;
								_data_->_tmp37_ = _data_->folder;
								_data_->_tmp38_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
								_data_->_tmp39_ = _data_->_tmp38_;
								_data_->_tmp40_ = _data_->e;
								_data_->_tmp41_ = _data_->_tmp40_->message;
								geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error closing folder %s: %s", _data_->_tmp39_, _data_->_tmp41_);
								_g_free0 (_data_->_tmp39_);
								_g_error_free0 (_data_->e);
							}
							__finally1:
							if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error1_);
								_g_object_unref0 (_data_->ids);
								_g_object_unref0 (_data_->removable);
								_g_object_unref0 (_data_->folder);
								_g_object_unref0 (_data_->path);
								_g_object_unref0 (_data_->_path_it);
								_g_object_unref0 (_data_->folders_to_ids);
								_g_object_unref0 (_data_->ids_to_folders);
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
						}
					}
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->ids);
						_g_object_unref0 (_data_->removable);
						_g_object_unref0 (_data_->folder);
						_g_object_unref0 (_data_->path);
						_g_object_unref0 (_data_->_path_it);
						_g_object_unref0 (_data_->folders_to_ids);
						_g_object_unref0 (_data_->ids_to_folders);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_object_unref0 (_data_->ids);
				}
				_g_object_unref0 (_data_->removable);
				_g_object_unref0 (_data_->folder);
				_g_object_unref0 (_data_->path);
			}
			_g_object_unref0 (_data_->_path_it);
		}
		_g_object_unref0 (_data_->folders_to_ids);
	}
	_g_object_unref0 (_data_->ids_to_folders);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_app_search_folder_remove_email_async (GearyAppSearchFolder* self,
                                            GeeCollection* remove,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyAppSearchFolderClass* _klass_;
	_klass_ = GEARY_APP_SEARCH_FOLDER_GET_CLASS (self);
	if (_klass_->remove_email_async) {
		_klass_->remove_email_async (self, remove, cancellable, _callback_, _user_data_);
	}
}

void
geary_app_search_folder_remove_email_finish (GearyAppSearchFolder* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyAppSearchFolderClass* _klass_;
	_klass_ = GEARY_APP_SEARCH_FOLDER_GET_CLASS (self);
	if (_klass_->remove_email_finish) {
		_klass_->remove_email_finish (self, _res_, error);
	}
}

static void
geary_app_search_folder_real_set_used_as_custom (GearyFolder* base,
                                                 gboolean enabled,
                                                 GError** error)
{
	GearyAppSearchFolder * self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_tmp0_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "Folder special use cannot be changed");
	_inner_error0_ = _tmp0_;
	if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
geary_app_search_folder_require_id (GearyAppSearchFolder* self,
                                    GearyEmailIdentifier* id,
                                    GError** error)
{
	GeeMap* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id));
	_tmp0_ = self->priv->ids;
	if (!gee_map_has_key (_tmp0_, id)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_email_identifier_to_string (id);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Id not found: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static GeeList*
geary_app_search_folder_check_ids (GearyAppSearchFolder* self,
                                   GeeCollection* to_check)
{
	GeeLinkedList* available = NULL;
	GeeLinkedList* _tmp0_;
	GeeMap* ids = NULL;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeIterator* iter = NULL;
	GeeIterator* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_check, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_linked_list_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	available = _tmp0_;
	_tmp1_ = self->priv->ids;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ids = _tmp2_;
	_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_check, GEE_TYPE_ITERABLE, GeeIterable));
	iter = _tmp3_;
	while (TRUE) {
		GeeIterator* _tmp4_;
		GearyEmailIdentifier* id = NULL;
		GeeIterator* _tmp5_;
		gpointer _tmp6_;
		GeeMap* _tmp7_;
		GearyEmailIdentifier* _tmp8_;
		_tmp4_ = iter;
		if (!gee_iterator_next (_tmp4_)) {
			break;
		}
		_tmp5_ = iter;
		_tmp6_ = gee_iterator_get (_tmp5_);
		id = (GearyEmailIdentifier*) _tmp6_;
		_tmp7_ = ids;
		_tmp8_ = id;
		if (gee_map_has_key (_tmp7_, _tmp8_)) {
			GeeLinkedList* _tmp9_;
			GearyEmailIdentifier* _tmp10_;
			_tmp9_ = available;
			_tmp10_ = id;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
		}
		_g_object_unref0 (id);
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (available, GEE_TYPE_LIST, GeeList);
	_g_object_unref0 (iter);
	_g_object_unref0 (ids);
	return result;
}

static void
geary_app_search_folder_append_data_free (gpointer _data)
{
	GearyAppSearchFolderAppendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderAppendData, _data_);
}

static void
geary_app_search_folder_append (GearyAppSearchFolder* self,
                                GearyFolder* folder,
                                GeeCollection* ids,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyAppSearchFolderAppendData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (GearyAppSearchFolderAppendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_append_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_tmp2_ = _g_object_ref0 (ids);
	_g_object_unref0 (_data_->ids);
	_data_->ids = _tmp2_;
	geary_app_search_folder_append_co (_data_);
}

static void
geary_app_search_folder_append_finish (GearyAppSearchFolder* self,
                                       GAsyncResult* _res_)
{
	GearyAppSearchFolderAppendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_app_search_folder_append_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyAppSearchFolderAppendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_append_co (_data_);
}

static gboolean
geary_app_search_folder_append_co (GearyAppSearchFolderAppendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->executing;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->cancellable = _data_->_tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting to append to search results");
	{
		_data_->_tmp2_ = _data_->self->priv->result_mutex;
		_data_->_tmp3_ = _data_->cancellable;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp2_, _data_->_tmp3_, geary_app_search_folder_append_ready, _data_);
		return FALSE;
		_state_1:
		_data_->result_mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		{
			_data_->_tmp4_ = _data_->self->priv->exclude_folders;
			_data_->_tmp5_ = geary_folder_get_path (_data_->folder);
			_data_->_tmp6_ = _data_->_tmp5_;
			if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp6_)) {
				_data_->_tmp7_ = _data_->cancellable;
				_data_->_state_ = 2;
				geary_app_search_folder_do_search_async (_data_->self, _data_->ids, NULL, _data_->_tmp7_, geary_app_search_folder_append_ready, _data_);
				return FALSE;
				_state_2:
				geary_app_search_folder_do_search_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = geary_account_get_information (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = geary_account_problem_report_new (_data_->_tmp13_, _data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			g_signal_emit_by_name (_data_->_tmp9_, "report-problem", G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
			_g_object_unref0 (_data_->_tmp16_);
			_g_error_free0 (_data_->_error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp17_ = _data_->self->priv->result_mutex;
		geary_nonblocking_mutex_release (_data_->_tmp17_, &_data_->result_mutex_token, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->mutex_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->mutex_err;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error acquiring lock: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->mutex_err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_update_data_free (gpointer _data)
{
	GearyAppSearchFolderUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderUpdateData, _data_);
}

static void
geary_app_search_folder_update (GearyAppSearchFolder* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyAppSearchFolderUpdateData* _data_;
	GearyAppSearchFolder* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	_data_ = g_slice_new0 (GearyAppSearchFolderUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_app_search_folder_update_co (_data_);
}

static void
geary_app_search_folder_update_finish (GearyAppSearchFolder* self,
                                       GAsyncResult* _res_)
{
	GearyAppSearchFolderUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_app_search_folder_update_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyAppSearchFolderUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_update_co (_data_);
}

static gboolean
geary_app_search_folder_update_co (GearyAppSearchFolderUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->executing;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->cancellable = _data_->_tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting to update search results");
	{
		_data_->_tmp2_ = _data_->self->priv->result_mutex;
		_data_->_tmp3_ = _data_->cancellable;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp2_, _data_->_tmp3_, geary_app_search_folder_update_ready, _data_);
		return FALSE;
		_state_1:
		_data_->result_mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		{
			_data_->_tmp4_ = _data_->cancellable;
			_data_->_state_ = 2;
			geary_app_search_folder_do_search_async (_data_->self, NULL, NULL, _data_->_tmp4_, geary_app_search_folder_update_ready, _data_);
			return FALSE;
			_state_2:
			geary_app_search_folder_do_search_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = geary_account_get_information (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->_error_;
			_data_->_tmp12_ = geary_account_problem_report_new (_data_->_tmp10_, _data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			g_signal_emit_by_name (_data_->_tmp6_, "report-problem", G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
			_g_object_unref0 (_data_->_tmp13_);
			_g_error_free0 (_data_->_error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp14_ = _data_->self->priv->result_mutex;
		geary_nonblocking_mutex_release (_data_->_tmp14_, &_data_->result_mutex_token, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->mutex_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->mutex_err;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error acquiring lock: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->mutex_err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_remove_data_free (gpointer _data)
{
	GearyAppSearchFolderRemoveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderRemoveData, _data_);
}

static void
geary_app_search_folder_remove (GearyAppSearchFolder* self,
                                GearyFolder* folder,
                                GeeCollection* ids,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyAppSearchFolderRemoveData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (GearyAppSearchFolderRemoveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_remove_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_tmp2_ = _g_object_ref0 (ids);
	_g_object_unref0 (_data_->ids);
	_data_->ids = _tmp2_;
	geary_app_search_folder_remove_co (_data_);
}

static void
geary_app_search_folder_remove_finish (GearyAppSearchFolder* self,
                                       GAsyncResult* _res_)
{
	GearyAppSearchFolderRemoveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		GearyAppSearchFolder* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->id_map);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
geary_app_search_folder_remove_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyAppSearchFolderRemoveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_remove_co (_data_);
}

static gboolean
___lambda176_ (Block18Data* _data18_,
               GearyEmailIdentifier* id)
{
	GearyAppSearchFolder* self;
	GeeMap* _tmp0_;
	gboolean result;
	self = _data18_->self;
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), FALSE);
	_tmp0_ = _data18_->id_map;
	result = gee_map_has_key (_tmp0_, id);
	return result;
}

static gboolean
____lambda176__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda176_ (self, (GearyEmailIdentifier*) g);
	return result;
}

static gboolean
geary_app_search_folder_remove_co (GearyAppSearchFolderRemoveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->executing;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->cancellable = _data_->_tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting to remove from search results");
	{
		_data_->_data18_ = g_slice_new0 (Block18Data);
		_data_->_data18_->_ref_count_ = 1;
		_data_->_data18_->self = g_object_ref (_data_->self);
		_data_->_tmp2_ = _data_->self->priv->result_mutex;
		_data_->_tmp3_ = _data_->cancellable;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp2_, _data_->_tmp3_, geary_app_search_folder_remove_ready, _data_);
		return FALSE;
		_state_1:
		_data_->result_mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block18_data_unref (_data_->_data18_);
			_data_->_data18_ = NULL;
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->self->priv->ids;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_data_->_data18_->id_map = _data_->_tmp5_;
		_data_->_tmp6_ = geary_traverse (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data_->ids, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = geary_iterable_filter (_data_->_tmp7_, ____lambda176__gee_predicate, block18_data_ref (_data_->_data18_), block18_data_unref);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = geary_iterable_to_linked_list (_data_->_tmp9_, NULL, NULL, NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->_tmp7_);
		_data_->relevant_ids = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->relevant_ids;
		_data_->_tmp13_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_tmp14_ = _data_->_tmp13_;
		if (_data_->_tmp14_ > 0) {
			{
				_data_->_tmp15_ = _data_->relevant_ids;
				_data_->_tmp16_ = _data_->cancellable;
				_data_->_state_ = 2;
				geary_app_search_folder_do_search_async (_data_->self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp16_, geary_app_search_folder_remove_ready, _data_);
				return FALSE;
				_state_2:
				geary_app_search_folder_do_search_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_error_ = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp17_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp19_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = geary_account_get_information (_data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->_error_;
				_data_->_tmp24_ = geary_account_problem_report_new (_data_->_tmp22_, _data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				g_signal_emit_by_name (_data_->_tmp18_, "report-problem", G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
				_g_object_unref0 (_data_->_tmp25_);
				_g_error_free0 (_data_->_error_);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->relevant_ids);
				block18_data_unref (_data_->_data18_);
				_data_->_data18_ = NULL;
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch0_g_io_error_cancelled;
				}
				goto __catch0_g_error;
			}
		}
		_data_->_tmp26_ = _data_->self->priv->result_mutex;
		geary_nonblocking_mutex_release (_data_->_tmp26_, &_data_->result_mutex_token, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->relevant_ids);
			block18_data_unref (_data_->_data18_);
			_data_->_data18_ = NULL;
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->relevant_ids);
		block18_data_unref (_data_->_data18_);
		_data_->_data18_ = NULL;
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->mutex_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->mutex_err;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error acquiring lock: %s", _data_->_tmp28_);
		_g_error_free0 (_data_->mutex_err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_search_folder_do_search_async_data_free (gpointer _data)
{
	GearyAppSearchFolderDoSearchAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->add_ids);
	_g_object_unref0 (_data_->remove_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppSearchFolderDoSearchAsyncData, _data_);
}

static void
geary_app_search_folder_do_search_async (GearyAppSearchFolder* self,
                                         GeeCollection* add_ids,
                                         GeeCollection* remove_ids,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyAppSearchFolderDoSearchAsyncData* _data_;
	GearyAppSearchFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail ((add_ids == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (add_ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((remove_ids == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (remove_ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppSearchFolderDoSearchAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_search_folder_do_search_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (add_ids);
	_g_object_unref0 (_data_->add_ids);
	_data_->add_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (remove_ids);
	_g_object_unref0 (_data_->remove_ids);
	_data_->remove_ids = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_app_search_folder_do_search_async_co (_data_);
}

static void
geary_app_search_folder_do_search_finish (GearyAppSearchFolder* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyAppSearchFolderDoSearchAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_app_search_folder_do_search_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyAppSearchFolderDoSearchAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_search_folder_do_search_async_co (_data_);
}

static gboolean
geary_app_search_folder_do_search_async_co (GearyAppSearchFolderDoSearchAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Processing search results");
	_data_->_tmp0_ = geary_app_search_folder_new_entry_set (_data_->self);
	_data_->entries = _data_->_tmp0_;
	_data_->_tmp1_ = geary_app_search_folder_new_id_map (_data_->self);
	_data_->ids = _data_->_tmp1_;
	_data_->_tmp2_ = gee_linked_list_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->added = _data_->_tmp2_;
	_data_->_tmp3_ = gee_linked_list_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->removed = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->entries;
	_data_->_tmp5_ = _data_->self->priv->entries;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp6_ = _data_->ids;
	_data_->_tmp7_ = _data_->self->priv->ids;
	gee_map_set_all (_data_->_tmp6_, _data_->_tmp7_);
	if (_data_->remove_ids == NULL) {
		_data_->_tmp8_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->self->priv->_query;
		_data_->_tmp11_ = _data_->self->priv->exclude_folders;
		_data_->_state_ = 1;
		geary_account_local_search_async (_data_->_tmp9_, _data_->_tmp10_, GEARY_APP_SEARCH_FOLDER_MAX_RESULT_EMAILS, 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _data_->add_ids, _data_->cancellable, geary_app_search_folder_do_search_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp12_ = geary_account_local_search_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		_data_->id_results = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->removed);
			_g_object_unref0 (_data_->added);
			_g_object_unref0 (_data_->ids);
			_g_object_unref0 (_data_->entries);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = _data_->id_results;
		if (_data_->_tmp13_ != NULL) {
			_data_->_tmp14_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->id_results;
			_data_->_state_ = 2;
			geary_account_list_local_email_async (_data_->_tmp15_, _data_->_tmp16_, GEARY_EMAIL_FIELD_PROPERTIES, _data_->cancellable, geary_app_search_folder_do_search_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp17_ = geary_account_list_local_email_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
			_data_->email_results = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_COLLECTION, GeeCollection);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->id_results);
				_g_object_unref0 (_data_->removed);
				_g_object_unref0 (_data_->added);
				_g_object_unref0 (_data_->ids);
				_g_object_unref0 (_data_->entries);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->add_ids == NULL) {
				_data_->_tmp18_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_data_->hashed_results = _data_->_tmp18_;
				_data_->_tmp19_ = _data_->hashed_results;
				_data_->_tmp20_ = _data_->id_results;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp20_);
				_data_->_tmp21_ = _data_->ids;
				_data_->_tmp22_ = gee_map_map_iterator (_data_->_tmp21_);
				_data_->existing = _data_->_tmp22_;
				while (TRUE) {
					_data_->_tmp23_ = _data_->existing;
					if (!gee_map_iterator_next (_data_->_tmp23_)) {
						break;
					}
					_data_->_tmp24_ = _data_->hashed_results;
					_data_->_tmp25_ = _data_->existing;
					_data_->_tmp26_ = gee_map_iterator_get_key (_data_->_tmp25_);
					_data_->_tmp27_ = (GearyEmailIdentifier*) _data_->_tmp26_;
					_data_->_tmp28_ = !gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp27_);
					_g_object_unref0 (_data_->_tmp27_);
					if (_data_->_tmp28_) {
						_data_->_tmp29_ = _data_->existing;
						_data_->_tmp30_ = gee_map_iterator_get_value (_data_->_tmp29_);
						_data_->entry = (GearyAppSearchFolderEmailEntry*) _data_->_tmp30_;
						_data_->_tmp31_ = _data_->existing;
						gee_map_iterator_unset (_data_->_tmp31_);
						_data_->_tmp32_ = _data_->entries;
						_data_->_tmp33_ = _data_->entry;
						gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp33_);
						_data_->_tmp34_ = _data_->removed;
						_data_->_tmp35_ = _data_->entry;
						_data_->_tmp36_ = _data_->_tmp35_->id;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp36_);
						_geary_app_search_folder_email_entry_unref0 (_data_->entry);
					}
				}
				_g_object_unref0 (_data_->existing);
				_g_object_unref0 (_data_->hashed_results);
			}
			{
				_data_->_tmp37_ = _data_->email_results;
				_data_->_tmp38_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_email_it = _data_->_tmp38_;
				while (TRUE) {
					_data_->_tmp39_ = _data_->_email_it;
					if (!gee_iterator_next (_data_->_tmp39_)) {
						break;
					}
					_data_->_tmp40_ = _data_->_email_it;
					_data_->_tmp41_ = gee_iterator_get (_data_->_tmp40_);
					_data_->email = (GearyEmail*) _data_->_tmp41_;
					_data_->_tmp42_ = _data_->ids;
					_data_->_tmp43_ = _data_->email;
					_data_->_tmp44_ = geary_email_get_id (_data_->_tmp43_);
					_data_->_tmp45_ = _data_->_tmp44_;
					if (!gee_map_has_key (_data_->_tmp42_, _data_->_tmp45_)) {
						_data_->_tmp46_ = _data_->email;
						_data_->_tmp47_ = geary_email_get_id (_data_->_tmp46_);
						_data_->_tmp48_ = _data_->_tmp47_;
						_data_->_tmp49_ = _data_->email;
						_data_->_tmp50_ = geary_email_get_properties (_data_->_tmp49_);
						_data_->_tmp51_ = _data_->_tmp50_;
						_data_->_tmp52_ = geary_email_properties_get_date_received (_data_->_tmp51_);
						_data_->_tmp53_ = _data_->_tmp52_;
						_data_->_tmp54_ = geary_app_search_folder_email_entry_new (_data_->_tmp48_, _data_->_tmp53_);
						_data_->_vala1_entry = _data_->_tmp54_;
						_data_->_tmp55_ = _data_->entries;
						_data_->_tmp56_ = _data_->_vala1_entry;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp55_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp56_);
						_data_->_tmp57_ = _data_->ids;
						_data_->_tmp58_ = _data_->email;
						_data_->_tmp59_ = geary_email_get_id (_data_->_tmp58_);
						_data_->_tmp60_ = _data_->_tmp59_;
						_data_->_tmp61_ = _data_->_vala1_entry;
						gee_map_set (_data_->_tmp57_, _data_->_tmp60_, _data_->_tmp61_);
						_data_->_tmp62_ = _data_->added;
						_data_->_tmp63_ = _data_->email;
						_data_->_tmp64_ = geary_email_get_id (_data_->_tmp63_);
						_data_->_tmp65_ = _data_->_tmp64_;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp62_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp65_);
						_geary_app_search_folder_email_entry_unref0 (_data_->_vala1_entry);
					}
					_g_object_unref0 (_data_->email);
				}
				_g_object_unref0 (_data_->_email_it);
			}
			_g_object_unref0 (_data_->email_results);
		}
		_g_object_unref0 (_data_->id_results);
	} else {
		{
			_data_->_tmp66_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->remove_ids, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_id_it = _data_->_tmp66_;
			while (TRUE) {
				_data_->_tmp67_ = _data_->_id_it;
				if (!gee_iterator_next (_data_->_tmp67_)) {
					break;
				}
				_data_->_tmp68_ = _data_->_id_it;
				_data_->_tmp69_ = gee_iterator_get (_data_->_tmp68_);
				_data_->id = (GearyEmailIdentifier*) _data_->_tmp69_;
				_data_->_tmp70_ = _data_->ids;
				_data_->_tmp71_ = _data_->id;
				_data_->_tmp72_ = NULL;
				_data_->_tmp73_ = gee_map_unset (_data_->_tmp70_, _data_->_tmp71_, &_data_->_tmp72_);
				_geary_app_search_folder_email_entry_unref0 (_data_->_vala2_entry);
				_data_->_vala2_entry = _data_->_tmp72_;
				if (_data_->_tmp73_) {
					_data_->_tmp74_ = _data_->entries;
					_data_->_tmp75_ = _data_->_vala2_entry;
					gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp74_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp75_);
					_data_->_tmp76_ = _data_->removed;
					_data_->_tmp77_ = _data_->id;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp76_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp77_);
				}
				_geary_app_search_folder_email_entry_unref0 (_data_->_vala2_entry);
				_g_object_unref0 (_data_->id);
			}
			_g_object_unref0 (_data_->_id_it);
		}
	}
	if (!g_cancellable_is_cancelled (_data_->cancellable)) {
		_data_->_tmp78_ = _data_->entries;
		_data_->_tmp79_ = _g_object_ref0 (_data_->_tmp78_);
		_g_object_unref0 (_data_->self->priv->entries);
		_data_->self->priv->entries = _data_->_tmp79_;
		_data_->_tmp80_ = _data_->ids;
		_data_->_tmp81_ = _g_object_ref0 (_data_->_tmp80_);
		_g_object_unref0 (_data_->self->priv->ids);
		_data_->self->priv->ids = _data_->_tmp81_;
		_data_->_tmp82_ = _data_->self->priv->_properties;
		_data_->_tmp83_ = _data_->entries;
		_data_->_tmp84_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp83_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp85_ = _data_->_tmp84_;
		geary_app_search_folder_folder_properties_impl_set_total (_data_->_tmp82_, _data_->_tmp85_);
		_data_->reason = GEARY_FOLDER_COUNT_CHANGE_REASON_NONE;
		_data_->_tmp86_ = _data_->removed;
		_data_->_tmp87_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp86_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_tmp88_ = _data_->_tmp87_;
		if (_data_->_tmp88_ > 0) {
			_data_->_tmp89_ = _data_->removed;
			geary_folder_notify_email_removed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp89_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->reason |= GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED;
		}
		_data_->_tmp90_ = _data_->added;
		_data_->_tmp91_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp90_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_tmp92_ = _data_->_tmp91_;
		if (_data_->_tmp92_ > 0) {
			_data_->_tmp93_ = _data_->added;
			geary_folder_notify_email_inserted (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp93_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->reason |= GEARY_FOLDER_COUNT_CHANGE_REASON_INSERTED;
		}
		if (_data_->reason != GEARY_FOLDER_COUNT_CHANGE_REASON_NONE) {
			_data_->_tmp94_ = _data_->self->priv->entries;
			_data_->_tmp95_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp94_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp96_ = _data_->_tmp95_;
			geary_folder_notify_email_count_changed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), _data_->_tmp96_, _data_->reason);
		}
		_data_->_tmp97_ = _data_->entries;
		_data_->_tmp98_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp97_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp99_ = _data_->_tmp98_;
		_data_->_tmp100_ = _data_->ids;
		_data_->_tmp101_ = gee_map_get_size (_data_->_tmp100_);
		_data_->_tmp102_ = _data_->_tmp101_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Processing done, entries/ids: %d/%d", _data_->_tmp99_, _data_->_tmp102_);
	} else {
		_data_->_tmp103_ = _data_->entries;
		_data_->_tmp104_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp103_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp105_ = _data_->_tmp104_;
		_data_->_tmp106_ = _data_->ids;
		_data_->_tmp107_ = gee_map_get_size (_data_->_tmp106_);
		_data_->_tmp108_ = _data_->_tmp107_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Processing cancelled, dropping entries/ids: %d/%d", _data_->_tmp105_, _data_->_tmp108_);
	}
	_g_object_unref0 (_data_->removed);
	_g_object_unref0 (_data_->added);
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->entries);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
_geary_app_search_folder_email_entry_compare_to_gcompare_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gint result;
	result = geary_app_search_folder_email_entry_compare_to ((GearyAppSearchFolderEmailEntry*) a, (GearyAppSearchFolderEmailEntry*) b);
	return result;
}

static inline GeeSortedSet*
geary_app_search_folder_new_entry_set (GearyAppSearchFolder* self)
{
	GeeTreeSet* _tmp0_;
	GeeSortedSet* result;
	g_return_val_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self), NULL);
	_tmp0_ = gee_tree_set_new (GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, (GBoxedCopyFunc) geary_app_search_folder_email_entry_ref, (GDestroyNotify) geary_app_search_folder_email_entry_unref, _geary_app_search_folder_email_entry_compare_to_gcompare_data_func, NULL, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	return result;
}

static inline GeeMap*
geary_app_search_folder_new_id_map (GearyAppSearchFolder* self)
{
	GeeHashMap* _tmp0_;
	GeeMap* result;
	g_return_val_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self), NULL);
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, (GBoxedCopyFunc) geary_app_search_folder_email_entry_ref, (GDestroyNotify) geary_app_search_folder_email_entry_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	return result;
}

static void
geary_app_search_folder_include_folder (GearyAppSearchFolder* self,
                                        GearyFolder* folder)
{
	GeeHashSet* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderPath* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	_tmp0_ = self->priv->exclude_folders;
	_tmp1_ = geary_folder_get_path (folder);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
}

static void
geary_app_search_folder_exclude_folder (GearyAppSearchFolder* self,
                                        GearyFolder* folder)
{
	GeeHashSet* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderPath* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	_tmp0_ = self->priv->exclude_folders;
	_tmp1_ = geary_folder_get_path (folder);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
}

static void
geary_app_search_folder_exclude_orphan_emails (GearyAppSearchFolder* self)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	_tmp0_ = self->priv->exclude_folders;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), NULL);
}

static gboolean
_vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                               gssize stack_length,
                                               const GearyFolderSpecialUse needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
___lambda175_ (GearyAppSearchFolder* self,
               GearyFolder* f)
{
	GearyFolderSpecialUse _tmp0_;
	GearyFolderSpecialUse _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER (f), FALSE);
	_tmp0_ = geary_folder_get_used_as (f);
	_tmp1_ = _tmp0_;
	result = _vala_geary_folder_special_use_array_contains (GEARY_APP_SEARCH_FOLDER_EXCLUDE_TYPES, G_N_ELEMENTS (GEARY_APP_SEARCH_FOLDER_EXCLUDE_TYPES), _tmp1_);
	return result;
}

static gboolean
____lambda175__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda175_ ((GearyAppSearchFolder*) self, (GearyFolder*) g);
	return result;
}

static void
geary_app_search_folder_on_folders_available_unavailable (GearyAppSearchFolder* self,
                                                          GeeCollection* available,
                                                          GeeCollection* unavailable)
{
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail ((available == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (available, GEE_TYPE_COLLECTION));
	g_return_if_fail ((unavailable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unavailable, GEE_TYPE_COLLECTION));
	if (available != NULL) {
		{
			GeeIterator* _folder_it = NULL;
			GearyIterable* _tmp0_;
			GearyIterable* _tmp1_;
			GearyIterable* _tmp2_;
			GearyIterable* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp0_ = geary_traverse (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (available, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp1_ = _tmp0_;
			_tmp2_ = geary_iterable_filter (_tmp1_, ____lambda175__gee_predicate, g_object_ref (self), g_object_unref);
			_tmp3_ = _tmp2_;
			_tmp4_ = geary_iterable_iterator (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (_tmp1_);
			_folder_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				GearyFolder* folder = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				GearyFolder* _tmp9_;
				_tmp6_ = _folder_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _folder_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				folder = (GearyFolder*) _tmp8_;
				_tmp9_ = folder;
				geary_app_search_folder_exclude_folder (self, _tmp9_);
				_g_object_unref0 (folder);
			}
			_g_object_unref0 (_folder_it);
		}
	}
}

static void
geary_app_search_folder_on_folders_use_changed (GearyAppSearchFolder* self,
                                                GeeCollection* folders)
{
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _folder_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (folders, GEE_TYPE_ITERABLE, GeeIterable));
		_folder_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyFolder* folder = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GearyFolder* _tmp4_;
			GearyFolderSpecialUse _tmp5_;
			GearyFolderSpecialUse _tmp6_;
			_tmp1_ = _folder_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _folder_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			folder = (GearyFolder*) _tmp3_;
			_tmp4_ = folder;
			_tmp5_ = geary_folder_get_used_as (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_vala_geary_folder_special_use_array_contains (GEARY_APP_SEARCH_FOLDER_EXCLUDE_TYPES, G_N_ELEMENTS (GEARY_APP_SEARCH_FOLDER_EXCLUDE_TYPES), _tmp6_)) {
				GearyFolder* _tmp7_;
				_tmp7_ = folder;
				geary_app_search_folder_exclude_folder (self, _tmp7_);
			} else {
				GearyFolder* _tmp8_;
				_tmp8_ = folder;
				geary_app_search_folder_include_folder (self, _tmp8_);
			}
			_g_object_unref0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
}

static void
geary_app_search_folder_on_email_locally_complete (GearyAppSearchFolder* self,
                                                   GearyFolder* folder,
                                                   GeeCollection* ids)
{
	GearySearchQuery* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->_query;
	if (_tmp0_ != NULL) {
		geary_app_search_folder_append (self, folder, ids, NULL, NULL);
	}
}

static void
geary_app_search_folder_on_account_email_removed (GearyAppSearchFolder* self,
                                                  GearyFolder* folder,
                                                  GeeCollection* ids)
{
	GearySearchQuery* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_SEARCH_FOLDER (self));
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->_query;
	if (_tmp0_ != NULL) {
		geary_app_search_folder_remove (self, folder, ids, NULL, NULL);
	}
}

static GearyAppSearchFolderFolderPropertiesImpl*
geary_app_search_folder_folder_properties_impl_construct (GType object_type,
                                                          gint total,
                                                          gint unread)
{
	GearyAppSearchFolderFolderPropertiesImpl * self = NULL;
	self = (GearyAppSearchFolderFolderPropertiesImpl*) geary_folder_properties_construct (object_type, total, unread, GEARY_TRILLIAN_FALSE, GEARY_TRILLIAN_FALSE, GEARY_TRILLIAN_TRUE, TRUE, TRUE, FALSE);
	return self;
}

static GearyAppSearchFolderFolderPropertiesImpl*
geary_app_search_folder_folder_properties_impl_new (gint total,
                                                    gint unread)
{
	return geary_app_search_folder_folder_properties_impl_construct (GEARY_APP_SEARCH_FOLDER_TYPE_FOLDER_PROPERTIES_IMPL, total, unread);
}

static void
geary_app_search_folder_folder_properties_impl_set_total (GearyAppSearchFolderFolderPropertiesImpl* self,
                                                          gint total)
{
	g_return_if_fail (GEARY_APP_SEARCH_FOLDER_IS_FOLDER_PROPERTIES_IMPL (self));
	geary_folder_properties_set_email_total (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties), total);
}

static void
geary_app_search_folder_folder_properties_impl_class_init (GearyAppSearchFolderFolderPropertiesImplClass * klass,
                                                           gpointer klass_data)
{
	geary_app_search_folder_folder_properties_impl_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_app_search_folder_folder_properties_impl_instance_init (GearyAppSearchFolderFolderPropertiesImpl * self,
                                                              gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_app_search_folder_folder_properties_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppSearchFolderFolderPropertiesImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_search_folder_folder_properties_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppSearchFolderFolderPropertiesImpl), 0, (GInstanceInitFunc) geary_app_search_folder_folder_properties_impl_instance_init, NULL };
	GType geary_app_search_folder_folder_properties_impl_type_id;
	geary_app_search_folder_folder_properties_impl_type_id = g_type_register_static (GEARY_TYPE_FOLDER_PROPERTIES, "GearyAppSearchFolderFolderPropertiesImpl", &g_define_type_info, 0);
	return geary_app_search_folder_folder_properties_impl_type_id;
}

static GType
geary_app_search_folder_folder_properties_impl_get_type (void)
{
	static gsize geary_app_search_folder_folder_properties_impl_type_id__once = 0;
	if (g_once_init_enter (&geary_app_search_folder_folder_properties_impl_type_id__once)) {
		GType geary_app_search_folder_folder_properties_impl_type_id;
		geary_app_search_folder_folder_properties_impl_type_id = geary_app_search_folder_folder_properties_impl_get_type_once ();
		g_once_init_leave (&geary_app_search_folder_folder_properties_impl_type_id__once, geary_app_search_folder_folder_properties_impl_type_id);
	}
	return geary_app_search_folder_folder_properties_impl_type_id__once;
}

static gint
geary_app_search_folder_email_entry_compare_to (GearyAppSearchFolderEmailEntry* a,
                                                GearyAppSearchFolderEmailEntry* b)
{
	gint cmp = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint result;
	g_return_val_if_fail (GEARY_APP_SEARCH_FOLDER_IS_EMAIL_ENTRY (a), 0);
	g_return_val_if_fail (GEARY_APP_SEARCH_FOLDER_IS_EMAIL_ENTRY (b), 0);
	cmp = 0;
	if (a != b) {
		GearyEmailIdentifier* _tmp2_;
		GearyEmailIdentifier* _tmp3_;
		_tmp2_ = a->id;
		_tmp3_ = b->id;
		_tmp1_ = _tmp2_ != _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GearyEmailIdentifier* _tmp4_;
		GearyEmailIdentifier* _tmp5_;
		_tmp4_ = a->id;
		_tmp5_ = b->id;
		_tmp0_ = !geary_email_identifier_equal_to (_tmp4_, _tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		_tmp6_ = a->received;
		_tmp7_ = b->received;
		cmp = g_date_time_compare (_tmp6_, _tmp7_);
		if (cmp == 0) {
			GearyEmailIdentifier* _tmp8_;
			GearyEmailIdentifier* _tmp9_;
			_tmp8_ = a->id;
			_tmp9_ = b->id;
			cmp = geary_email_identifier_stable_sort_comparator (_tmp8_, _tmp9_);
		}
	}
	result = cmp;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static GearyAppSearchFolderEmailEntry*
geary_app_search_folder_email_entry_construct (GType object_type,
                                               GearyEmailIdentifier* id,
                                               GDateTime* received)
{
	GearyAppSearchFolderEmailEntry* self = NULL;
	GearyEmailIdentifier* _tmp0_;
	GDateTime* _tmp1_;
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), NULL);
	g_return_val_if_fail (received != NULL, NULL);
	self = (GearyAppSearchFolderEmailEntry*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (id);
	_g_object_unref0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = _g_date_time_ref0 (received);
	_g_date_time_unref0 (self->received);
	self->received = _tmp1_;
	return self;
}

static GearyAppSearchFolderEmailEntry*
geary_app_search_folder_email_entry_new (GearyEmailIdentifier* id,
                                         GDateTime* received)
{
	return geary_app_search_folder_email_entry_construct (GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, id, received);
}

static void
geary_app_search_folder_value_email_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_app_search_folder_value_email_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_app_search_folder_email_entry_unref (value->data[0].v_pointer);
	}
}

static void
geary_app_search_folder_value_email_entry_copy_value (const GValue* src_value,
                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_app_search_folder_email_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_app_search_folder_value_email_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_app_search_folder_value_email_entry_collect_value (GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyAppSearchFolderEmailEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_app_search_folder_email_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_app_search_folder_value_email_entry_lcopy_value (const GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	GearyAppSearchFolderEmailEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_app_search_folder_email_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
geary_app_search_folder_param_spec_email_entry (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags)
{
	GearyAppSearchFolderParamSpecEmailEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
geary_app_search_folder_value_get_email_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
geary_app_search_folder_value_set_email_entry (GValue* value,
                                               gpointer v_object)
{
	GearyAppSearchFolderEmailEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_app_search_folder_email_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_app_search_folder_email_entry_unref (old);
	}
}

static void
geary_app_search_folder_value_take_email_entry (GValue* value,
                                                gpointer v_object)
{
	GearyAppSearchFolderEmailEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_app_search_folder_email_entry_unref (old);
	}
}

static void
geary_app_search_folder_email_entry_class_init (GearyAppSearchFolderEmailEntryClass * klass,
                                                gpointer klass_data)
{
	geary_app_search_folder_email_entry_parent_class = g_type_class_peek_parent (klass);
	((GearyAppSearchFolderEmailEntryClass *) klass)->finalize = geary_app_search_folder_email_entry_finalize;
}

static void
geary_app_search_folder_email_entry_instance_init (GearyAppSearchFolderEmailEntry * self,
                                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
geary_app_search_folder_email_entry_finalize (GearyAppSearchFolderEmailEntry * obj)
{
	GearyAppSearchFolderEmailEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_SEARCH_FOLDER_TYPE_EMAIL_ENTRY, GearyAppSearchFolderEmailEntry);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->id);
	_g_date_time_unref0 (self->received);
}

 G_GNUC_NO_INLINE static GType
geary_app_search_folder_email_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_app_search_folder_value_email_entry_init, geary_app_search_folder_value_email_entry_free_value, geary_app_search_folder_value_email_entry_copy_value, geary_app_search_folder_value_email_entry_peek_pointer, "p", geary_app_search_folder_value_email_entry_collect_value, "p", geary_app_search_folder_value_email_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppSearchFolderEmailEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_search_folder_email_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppSearchFolderEmailEntry), 0, (GInstanceInitFunc) geary_app_search_folder_email_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_app_search_folder_email_entry_type_id;
	geary_app_search_folder_email_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyAppSearchFolderEmailEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return geary_app_search_folder_email_entry_type_id;
}

static GType
geary_app_search_folder_email_entry_get_type (void)
{
	static gsize geary_app_search_folder_email_entry_type_id__once = 0;
	if (g_once_init_enter (&geary_app_search_folder_email_entry_type_id__once)) {
		GType geary_app_search_folder_email_entry_type_id;
		geary_app_search_folder_email_entry_type_id = geary_app_search_folder_email_entry_get_type_once ();
		g_once_init_leave (&geary_app_search_folder_email_entry_type_id__once, geary_app_search_folder_email_entry_type_id);
	}
	return geary_app_search_folder_email_entry_type_id__once;
}

static gpointer
geary_app_search_folder_email_entry_ref (gpointer instance)
{
	GearyAppSearchFolderEmailEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
geary_app_search_folder_email_entry_unref (gpointer instance)
{
	GearyAppSearchFolderEmailEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_APP_SEARCH_FOLDER_EMAIL_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
geary_app_search_folder_class_init (GearyAppSearchFolderClass * klass,
                                    gpointer klass_data)
{
	geary_app_search_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppSearchFolder_private_offset);
	((GearyFolderClass *) klass)->contains_identifiers = (void (*) (GearyFolder*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_real_contains_identifiers;
	((GearyFolderClass *) klass)->contains_identifiers_finish = (GeeCollection* (*) (GearyFolder*, GAsyncResult*, GError**)) geary_app_search_folder_contains_identifiers_finish;
	((GearyFolderClass *) klass)->list_email_by_id_async = (void (*) (GearyFolder*, GearyEmailIdentifier*, gint, GearyEmailField, GearyFolderListFlags, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_real_list_email_by_id_async;
	((GearyFolderClass *) klass)->list_email_by_id_finish = (GeeList* (*) (GearyFolder*, GAsyncResult*, GError**)) geary_app_search_folder_list_email_by_id_finish;
	((GearyFolderClass *) klass)->list_email_by_sparse_id_async = (void (*) (GearyFolder*, GeeCollection*, GearyEmailField, GearyFolderListFlags, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_real_list_email_by_sparse_id_async;
	((GearyFolderClass *) klass)->list_email_by_sparse_id_finish = (GeeList* (*) (GearyFolder*, GAsyncResult*, GError**)) geary_app_search_folder_list_email_by_sparse_id_finish;
	((GearyFolderClass *) klass)->fetch_email_async = (void (*) (GearyFolder*, GearyEmailIdentifier*, GearyEmailField, GearyFolderListFlags, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_real_fetch_email_async;
	((GearyFolderClass *) klass)->fetch_email_finish = (GearyEmail* (*) (GearyFolder*, GAsyncResult*, GError**)) geary_app_search_folder_fetch_email_finish;
	((GearyAppSearchFolderClass *) klass)->remove_email_async = (void (*) (GearyAppSearchFolder*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_real_remove_email_async;
	((GearyAppSearchFolderClass *) klass)->remove_email_finish = (void (*) (GearyAppSearchFolder*, GAsyncResult*, GError**)) geary_app_search_folder_real_remove_email_finish;
	((GearyFolderClass *) klass)->set_used_as_custom = (void (*) (GearyFolder*, gboolean, GError**)) geary_app_search_folder_real_set_used_as_custom;
	GEARY_FOLDER_CLASS (klass)->get_account = geary_app_search_folder_real_get_account;
	GEARY_FOLDER_CLASS (klass)->get_properties = geary_app_search_folder_real_get_properties;
	GEARY_FOLDER_CLASS (klass)->get_path = geary_app_search_folder_real_get_path;
	GEARY_FOLDER_CLASS (klass)->get_used_as = geary_app_search_folder_real_get_used_as;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_search_folder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_search_folder_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_search_folder_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_SEARCH_FOLDER_ACCOUNT_PROPERTY, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_SEARCH_FOLDER_PROPERTIES_PROPERTY, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_PROPERTIES_PROPERTY] = g_param_spec_object ("properties", "properties", "properties", GEARY_TYPE_FOLDER_PROPERTIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_SEARCH_FOLDER_PATH_PROPERTY, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_PATH_PROPERTY] = g_param_spec_object ("path", "path", "path", GEARY_TYPE_FOLDER_PATH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Always returns {@link Folder.SpecialUse.SEARCH}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_SEARCH_FOLDER_USED_AS_PROPERTY, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_USED_AS_PROPERTY] = g_param_spec_enum ("used-as", "used-as", "used-as", GEARY_FOLDER_TYPE_SPECIAL_USE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The query being evaluated by this folder, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY, geary_app_search_folder_properties[GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY] = g_param_spec_object ("query", "query", "query", GEARY_TYPE_SEARCH_QUERY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_app_search_folder_geary_folder_support_remove_interface_init (GearyFolderSupportRemoveIface * iface,
                                                                    gpointer iface_data)
{
	geary_app_search_folder_geary_folder_support_remove_parent_iface = g_type_interface_peek_parent (iface);
	iface->remove_email_async = (void (*) (GearyFolderSupportRemove*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_app_search_folder_remove_email_async;
	iface->remove_email_finish = (void (*) (GearyFolderSupportRemove*, GAsyncResult*, GError**)) geary_app_search_folder_remove_email_finish;
}

static void
geary_app_search_folder_instance_init (GearyAppSearchFolder * self,
                                       gpointer klass)
{
	GeeHashSet* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GCancellable* _tmp2_;
	self->priv = geary_app_search_folder_get_instance_private (self);
	self->priv->_path = NULL;
	self->priv->_query = NULL;
	_tmp0_ = gee_hash_set_new (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->exclude_folders = _tmp0_;
	_tmp1_ = geary_nonblocking_mutex_new ();
	self->priv->result_mutex = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	self->priv->executing = _tmp2_;
}

static void
geary_app_search_folder_finalize (GObject * obj)
{
	GearyAppSearchFolder * self;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	guint _tmp2_;
	GearyAccount* _tmp3_;
	GearyAccount* _tmp4_;
	guint _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	guint _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccount* _tmp10_;
	guint _tmp11_;
	GearyAccount* _tmp12_;
	GearyAccount* _tmp13_;
	guint _tmp14_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	_tmp0_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("folders-available-unavailable", GEARY_TYPE_ACCOUNT, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _geary_app_search_folder_on_folders_available_unavailable_geary_account_folders_available_unavailable, self);
	_tmp3_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("folders-use-changed", GEARY_TYPE_ACCOUNT, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _geary_app_search_folder_on_folders_use_changed_geary_account_folders_use_changed, self);
	_tmp6_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("email-locally-complete", GEARY_TYPE_ACCOUNT, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _geary_app_search_folder_on_email_locally_complete_geary_account_email_locally_complete, self);
	_tmp9_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp10_ = _tmp9_;
	g_signal_parse_name ("email-removed", GEARY_TYPE_ACCOUNT, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _geary_app_search_folder_on_account_email_removed_geary_account_email_removed, self);
	_tmp12_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp13_ = _tmp12_;
	g_signal_parse_name ("email-locally-removed", GEARY_TYPE_ACCOUNT, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _geary_app_search_folder_on_account_email_removed_geary_account_email_locally_removed, self);
	_g_object_unref0 (self->priv->_properties);
	_g_object_unref0 (self->priv->_path);
	_g_object_unref0 (self->priv->_query);
	_g_object_unref0 (self->priv->exclude_folders);
	_g_object_unref0 (self->priv->entries);
	_g_object_unref0 (self->priv->ids);
	_g_object_unref0 (self->priv->result_mutex);
	_g_object_unref0 (self->priv->executing);
	G_OBJECT_CLASS (geary_app_search_folder_parent_class)->finalize (obj);
}

/**
 * A folder for executing and listing an account-wide email search.
 *
 * This uses the search methods on {@link Account} to implement the
 * search, then collects search results and presents them via the
 * folder interface.
 */
 G_GNUC_NO_INLINE static GType
geary_app_search_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppSearchFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_search_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppSearchFolder), 0, (GInstanceInitFunc) geary_app_search_folder_instance_init, NULL };
	static const GInterfaceInfo geary_folder_support_remove_info = { (GInterfaceInitFunc) geary_app_search_folder_geary_folder_support_remove_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_app_search_folder_type_id;
	geary_app_search_folder_type_id = g_type_register_static (GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, "GearyAppSearchFolder", &g_define_type_info, 0);
	g_type_add_interface_static (geary_app_search_folder_type_id, GEARY_FOLDER_SUPPORT_TYPE_REMOVE, &geary_folder_support_remove_info);
	GearyAppSearchFolder_private_offset = g_type_add_instance_private (geary_app_search_folder_type_id, sizeof (GearyAppSearchFolderPrivate));
	return geary_app_search_folder_type_id;
}

GType
geary_app_search_folder_get_type (void)
{
	static gsize geary_app_search_folder_type_id__once = 0;
	if (g_once_init_enter (&geary_app_search_folder_type_id__once)) {
		GType geary_app_search_folder_type_id;
		geary_app_search_folder_type_id = geary_app_search_folder_get_type_once ();
		g_once_init_leave (&geary_app_search_folder_type_id__once, geary_app_search_folder_type_id);
	}
	return geary_app_search_folder_type_id__once;
}

static void
_vala_geary_app_search_folder_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyAppSearchFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	switch (property_id) {
		case GEARY_APP_SEARCH_FOLDER_ACCOUNT_PROPERTY:
		g_value_set_object (value, geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder)));
		break;
		case GEARY_APP_SEARCH_FOLDER_PROPERTIES_PROPERTY:
		g_value_set_object (value, geary_folder_get_properties (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder)));
		break;
		case GEARY_APP_SEARCH_FOLDER_PATH_PROPERTY:
		g_value_set_object (value, geary_folder_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder)));
		break;
		case GEARY_APP_SEARCH_FOLDER_USED_AS_PROPERTY:
		g_value_set_enum (value, geary_folder_get_used_as (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder)));
		break;
		case GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY:
		g_value_set_object (value, geary_app_search_folder_get_query (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_search_folder_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyAppSearchFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_SEARCH_FOLDER, GearyAppSearchFolder);
	switch (property_id) {
		case GEARY_APP_SEARCH_FOLDER_QUERY_PROPERTY:
		geary_app_search_folder_set_query (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

