/* imap-db-email-identifier.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-db-email-identifier.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_VARIANT_TYPE "(y(xx))"

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef struct _GearyImapDBEmailIdentifierPrivate GearyImapDBEmailIdentifierPrivate;
enum  {
	GEARY_IMAP_DB_EMAIL_IDENTIFIER_0_PROPERTY,
	GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY,
	GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY,
	GEARY_IMAP_DB_EMAIL_IDENTIFIER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_db_email_identifier_properties[GEARY_IMAP_DB_EMAIL_IDENTIFIER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyImapDBEmailIdentifier {
	GearyEmailIdentifier parent_instance;
	GearyImapDBEmailIdentifierPrivate * priv;
};

struct _GearyImapDBEmailIdentifierClass {
	GearyEmailIdentifierClass parent_class;
};

struct _GearyImapDBEmailIdentifierPrivate {
	gint64 _message_id;
	GearyImapUID* _uid;
};

static gint GearyImapDBEmailIdentifier_private_offset;
static gpointer geary_imap_db_email_identifier_parent_class = NULL;

VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint64 geary_imap_db_email_identifier_get_message_id (GearyImapDBEmailIdentifier* self);
static void geary_imap_db_email_identifier_set_message_id (GearyImapDBEmailIdentifier* self,
                                                    gint64 value);
VALA_EXTERN GearyImapUID* geary_imap_db_email_identifier_get_uid (GearyImapDBEmailIdentifier* self);
static void geary_imap_db_email_identifier_set_uid (GearyImapDBEmailIdentifier* self,
                                             GearyImapUID* value);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_new (gint64 message_id,
                                                                GearyImapUID* uid);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_construct (GType object_type,
                                                                      gint64 message_id,
                                                                      GearyImapUID* uid);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_new_no_message_id (GearyImapUID* uid);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_construct_no_message_id (GType object_type,
                                                                                    GearyImapUID* uid);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_new_from_variant (GVariant* serialised,
                                                                             GError** error);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_email_identifier_construct_from_variant (GType object_type,
                                                                                   GVariant* serialised,
                                                                                   GError** error);
VALA_EXTERN void geary_imap_db_email_identifier_promote_with_message_id (GearyImapDBEmailIdentifier* self,
                                                             gint64 message_id);
VALA_EXTERN gboolean geary_imap_db_email_identifier_has_uid (GearyImapDBEmailIdentifier* self);
static guint geary_imap_db_email_identifier_real_hash (GearyEmailIdentifier* base);
static gboolean geary_imap_db_email_identifier_real_equal_to (GearyEmailIdentifier* base,
                                                       GearyEmailIdentifier* other);
static gint geary_imap_db_email_identifier_real_natural_sort_comparator (GearyEmailIdentifier* base,
                                                                  GearyEmailIdentifier* o);
static GVariant* geary_imap_db_email_identifier_real_to_variant (GearyEmailIdentifier* base);
static gchar* geary_imap_db_email_identifier_real_to_string (GearyEmailIdentifier* base);
VALA_EXTERN GeeSet* geary_imap_db_email_identifier_to_uids (GeeCollection* ids);
static void geary_imap_db_email_identifier_finalize (GObject * obj);
static GType geary_imap_db_email_identifier_get_type_once (void);
static void _vala_geary_imap_db_email_identifier_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_imap_db_email_identifier_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_imap_db_email_identifier_get_instance_private (GearyImapDBEmailIdentifier* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDBEmailIdentifier_private_offset);
}

gint64
geary_imap_db_email_identifier_get_message_id (GearyImapDBEmailIdentifier* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self), 0LL);
	result = self->priv->_message_id;
	return result;
}

static void
geary_imap_db_email_identifier_set_message_id (GearyImapDBEmailIdentifier* self,
                                               gint64 value)
{
	gint64 old_value;
	g_return_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self));
	old_value = geary_imap_db_email_identifier_get_message_id (self);
	if (old_value != value) {
		self->priv->_message_id = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_db_email_identifier_properties[GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY]);
	}
}

GearyImapUID*
geary_imap_db_email_identifier_get_uid (GearyImapDBEmailIdentifier* self)
{
	GearyImapUID* result;
	GearyImapUID* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self), NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_db_email_identifier_set_uid (GearyImapDBEmailIdentifier* self,
                                        GearyImapUID* value)
{
	GearyImapUID* old_value;
	g_return_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self));
	old_value = geary_imap_db_email_identifier_get_uid (self);
	if (old_value != value) {
		GearyImapUID* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid);
		self->priv->_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_db_email_identifier_properties[GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY]);
	}
}

GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_construct (GType object_type,
                                          gint64 message_id,
                                          GearyImapUID* uid)
{
	GearyImapDBEmailIdentifier * self = NULL;
	g_return_val_if_fail ((uid == NULL) || GEARY_IMAP_IS_UID (uid), NULL);
	self = (GearyImapDBEmailIdentifier*) geary_email_identifier_construct (object_type);
	_vala_assert (message_id != GEARY_DB_INVALID_ROWID, "message_id != Db.INVALID_ROWID");
	geary_imap_db_email_identifier_set_message_id (self, message_id);
	geary_imap_db_email_identifier_set_uid (self, uid);
	return self;
}

GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_new (gint64 message_id,
                                    GearyImapUID* uid)
{
	return geary_imap_db_email_identifier_construct (GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, message_id, uid);
}

GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_construct_no_message_id (GType object_type,
                                                        GearyImapUID* uid)
{
	GearyImapDBEmailIdentifier * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (uid), NULL);
	self = (GearyImapDBEmailIdentifier*) geary_email_identifier_construct (object_type);
	geary_imap_db_email_identifier_set_message_id (self, GEARY_DB_INVALID_ROWID);
	geary_imap_db_email_identifier_set_uid (self, uid);
	return self;
}

GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_new_no_message_id (GearyImapUID* uid)
{
	return geary_imap_db_email_identifier_construct_no_message_id (GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, uid);
}

/** Reconstructs an identifier from its variant representation. */
GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_construct_from_variant (GType object_type,
                                                       GVariant* serialised,
                                                       GError** error)
{
	GearyImapDBEmailIdentifier * self = NULL;
	const gchar* _tmp0_;
	GVariant* inner = NULL;
	GVariant* _tmp3_;
	GearyImapUID* uid = NULL;
	gint64 uid_value = 0LL;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint64 _tmp7_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GearyImapUID* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (serialised != NULL, NULL);
	_tmp0_ = g_variant_get_type_string (serialised);
	if (g_strcmp0 (_tmp0_, GEARY_IMAP_DB_EMAIL_IDENTIFIER_VARIANT_TYPE) != 0) {
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = g_variant_get_type_string (serialised);
		_tmp2_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_BAD_PARAMETERS, "Invalid serialised id type: %s", _tmp1_);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_variant_get_child_value (serialised, (gsize) 1);
	inner = _tmp3_;
	uid = NULL;
	_tmp4_ = inner;
	_tmp5_ = g_variant_get_child_value (_tmp4_, (gsize) 1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_get_int64 (_tmp6_);
	_g_variant_unref0 (_tmp6_);
	uid_value = _tmp7_;
	if (uid_value >= ((gint64) 0)) {
		GearyImapUID* _tmp8_;
		_tmp8_ = geary_imap_uid_new (uid_value);
		_g_object_unref0 (uid);
		uid = _tmp8_;
	}
	_tmp9_ = inner;
	_tmp10_ = g_variant_get_child_value (_tmp9_, (gsize) 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = uid;
	self = (GearyImapDBEmailIdentifier*) geary_imap_db_email_identifier_construct (object_type, g_variant_get_int64 (_tmp11_), _tmp12_);
	_g_variant_unref0 (_tmp11_);
	_g_object_unref0 (uid);
	_g_variant_unref0 (inner);
	return self;
}

GearyImapDBEmailIdentifier*
geary_imap_db_email_identifier_new_from_variant (GVariant* serialised,
                                                 GError** error)
{
	return geary_imap_db_email_identifier_construct_from_variant (GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, serialised, error);
}

void
geary_imap_db_email_identifier_promote_with_message_id (GearyImapDBEmailIdentifier* self,
                                                        gint64 message_id)
{
	gint64 _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self));
	_tmp0_ = self->priv->_message_id;
	_vala_assert (_tmp0_ == GEARY_DB_INVALID_ROWID, "this.message_id == Db.INVALID_ROWID");
	geary_imap_db_email_identifier_set_message_id (self, message_id);
}

gboolean
geary_imap_db_email_identifier_has_uid (GearyImapDBEmailIdentifier* self)
{
	gboolean _tmp0_ = FALSE;
	GearyImapUID* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (self), FALSE);
	_tmp1_ = self->priv->_uid;
	if (_tmp1_ != NULL) {
		GearyImapUID* _tmp2_;
		_tmp2_ = self->priv->_uid;
		_tmp0_ = geary_imap_uid_is_valid (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** {@inheritDoc} */
static guint
geary_imap_db_email_identifier_real_hash (GearyEmailIdentifier* base)
{
	GearyImapDBEmailIdentifier * self;
	GHashFunc _tmp0_;
	gint64 _tmp1_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	_tmp0_ = g_int64_hash;
	_tmp1_ = self->priv->_message_id;
	result = _tmp0_ (&_tmp1_);
	return result;
}

/** {@inheritDoc} */
static gboolean
geary_imap_db_email_identifier_real_equal_to (GearyEmailIdentifier* base,
                                              GearyEmailIdentifier* other)
{
	GearyImapDBEmailIdentifier * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (other), FALSE);
	if (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)) == G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (other, G_TYPE_OBJECT, GObject))) {
		gint64 _tmp1_;
		gint64 _tmp2_;
		_tmp1_ = self->priv->_message_id;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (other, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier)->priv->_message_id;
		_tmp0_ = _tmp1_ == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint
geary_imap_db_email_identifier_real_natural_sort_comparator (GearyEmailIdentifier* base,
                                                             GearyEmailIdentifier* o)
{
	GearyImapDBEmailIdentifier * self;
	GearyImapDBEmailIdentifier* other = NULL;
	GearyImapDBEmailIdentifier* _tmp0_;
	GearyImapDBEmailIdentifier* _tmp1_;
	GearyImapUID* _tmp2_;
	GearyImapDBEmailIdentifier* _tmp3_;
	GearyImapUID* _tmp4_;
	GearyImapUID* _tmp5_;
	GearyImapDBEmailIdentifier* _tmp6_;
	GearyImapUID* _tmp7_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (o), 0);
	_tmp0_ = _g_object_ref0 (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (o) ? ((GearyImapDBEmailIdentifier*) o) : NULL);
	other = _tmp0_;
	_tmp1_ = other;
	if (_tmp1_ == NULL) {
		result = 1;
		_g_object_unref0 (other);
		return result;
	}
	_tmp2_ = self->priv->_uid;
	if (_tmp2_ == NULL) {
		result = 1;
		_g_object_unref0 (other);
		return result;
	}
	_tmp3_ = other;
	_tmp4_ = _tmp3_->priv->_uid;
	if (_tmp4_ == NULL) {
		result = -1;
		_g_object_unref0 (other);
		return result;
	}
	_tmp5_ = self->priv->_uid;
	_tmp6_ = other;
	_tmp7_ = _tmp6_->priv->_uid;
	result = geary_imap_uid_compare_to (_tmp5_, _tmp7_);
	_g_object_unref0 (other);
	return result;
}

static GVariant*
geary_imap_db_email_identifier_real_to_variant (GearyEmailIdentifier* base)
{
	GearyImapDBEmailIdentifier * self;
	gint64 _tmp0_ = 0LL;
	GearyImapUID* _tmp1_;
	gint64 uid_value = 0LL;
	GVariant* _tmp5_;
	gint64 _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant** _tmp9_;
	GVariant** _tmp10_;
	gint _tmp10__length1;
	GVariant* _tmp11_;
	GVariant** _tmp12_;
	GVariant** _tmp13_;
	gint _tmp13__length1;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	_tmp1_ = self->priv->_uid;
	if (_tmp1_ != NULL) {
		GearyImapUID* _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		_tmp2_ = self->priv->_uid;
		_tmp3_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = (gint64) -1;
	}
	uid_value = _tmp0_;
	_tmp5_ = g_variant_new_byte ((guint8) 'i');
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = self->priv->_message_id;
	_tmp7_ = g_variant_new_int64 (_tmp6_);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = g_variant_new_int64 (uid_value);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = g_new0 (GVariant*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = g_variant_new_tuple (_tmp10_, 2);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = g_new0 (GVariant*, 2 + 1);
	_tmp12_[0] = _tmp5_;
	_tmp12_[1] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 2;
	_tmp14_ = g_variant_new_tuple (_tmp13_, 2);
	g_variant_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_variant_unref), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_variant_unref), NULL);
	result = _tmp15_;
	return result;
}

static gchar*
geary_imap_db_email_identifier_real_to_string (GearyEmailIdentifier* base)
{
	GearyImapDBEmailIdentifier * self;
	gchar* _tmp0_ = NULL;
	GearyImapUID* _tmp1_;
	const gchar* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	_tmp1_ = self->priv->_uid;
	if (_tmp1_ != NULL) {
		GearyImapUID* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_uid;
		_tmp3_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("null");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
	_tmp6_ = self->priv->_message_id;
	_tmp7_ = g_strdup_printf ("%s(%lld,%s)", _tmp5_, _tmp6_, _tmp0_);
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}

GeeSet*
geary_imap_db_email_identifier_to_uids (GeeCollection* ids)
{
	GeeHashSet* uids = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_IMAP_TYPE_UID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	uids = _tmp0_;
	{
		GeeIterator* _id_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (ids, GEE_TYPE_ITERABLE, GeeIterable));
		_id_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GearyImapDBEmailIdentifier* id = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GearyImapDBEmailIdentifier* _tmp5_;
			GearyImapUID* _tmp6_;
			_tmp2_ = _id_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _id_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			id = (GearyImapDBEmailIdentifier*) _tmp4_;
			_tmp5_ = id;
			_tmp6_ = _tmp5_->priv->_uid;
			if (_tmp6_ != NULL) {
				GeeHashSet* _tmp7_;
				GearyImapDBEmailIdentifier* _tmp8_;
				GearyImapUID* _tmp9_;
				_tmp7_ = uids;
				_tmp8_ = id;
				_tmp9_ = _tmp8_->priv->_uid;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
			}
			_g_object_unref0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (uids, GEE_TYPE_SET, GeeSet);
	return result;
}

static void
geary_imap_db_email_identifier_class_init (GearyImapDBEmailIdentifierClass * klass,
                                           gpointer klass_data)
{
	geary_imap_db_email_identifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapDBEmailIdentifier_private_offset);
	((GearyEmailIdentifierClass *) klass)->hash = (guint (*) (GearyEmailIdentifier*)) geary_imap_db_email_identifier_real_hash;
	((GearyEmailIdentifierClass *) klass)->equal_to = (gboolean (*) (GearyEmailIdentifier*, GearyEmailIdentifier*)) geary_imap_db_email_identifier_real_equal_to;
	((GearyEmailIdentifierClass *) klass)->natural_sort_comparator = (gint (*) (GearyEmailIdentifier*, GearyEmailIdentifier*)) geary_imap_db_email_identifier_real_natural_sort_comparator;
	((GearyEmailIdentifierClass *) klass)->to_variant = (GVariant* (*) (GearyEmailIdentifier*)) geary_imap_db_email_identifier_real_to_variant;
	((GearyEmailIdentifierClass *) klass)->to_string = (gchar* (*) (GearyEmailIdentifier*)) geary_imap_db_email_identifier_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_db_email_identifier_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_db_email_identifier_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_db_email_identifier_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY, geary_imap_db_email_identifier_properties[GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY] = g_param_spec_int64 ("message-id", "message-id", "message-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY, geary_imap_db_email_identifier_properties[GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY] = g_param_spec_object ("uid", "uid", "uid", GEARY_IMAP_TYPE_UID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_db_email_identifier_instance_init (GearyImapDBEmailIdentifier * self,
                                              gpointer klass)
{
	self->priv = geary_imap_db_email_identifier_get_instance_private (self);
}

static void
geary_imap_db_email_identifier_finalize (GObject * obj)
{
	GearyImapDBEmailIdentifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	_g_object_unref0 (self->priv->_uid);
	G_OBJECT_CLASS (geary_imap_db_email_identifier_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_db_email_identifier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDBEmailIdentifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_db_email_identifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDBEmailIdentifier), 0, (GInstanceInitFunc) geary_imap_db_email_identifier_instance_init, NULL };
	GType geary_imap_db_email_identifier_type_id;
	geary_imap_db_email_identifier_type_id = g_type_register_static (GEARY_TYPE_EMAIL_IDENTIFIER, "GearyImapDBEmailIdentifier", &g_define_type_info, 0);
	GearyImapDBEmailIdentifier_private_offset = g_type_add_instance_private (geary_imap_db_email_identifier_type_id, sizeof (GearyImapDBEmailIdentifierPrivate));
	return geary_imap_db_email_identifier_type_id;
}

GType
geary_imap_db_email_identifier_get_type (void)
{
	static gsize geary_imap_db_email_identifier_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_email_identifier_type_id__once)) {
		GType geary_imap_db_email_identifier_type_id;
		geary_imap_db_email_identifier_type_id = geary_imap_db_email_identifier_get_type_once ();
		g_once_init_leave (&geary_imap_db_email_identifier_type_id__once, geary_imap_db_email_identifier_type_id);
	}
	return geary_imap_db_email_identifier_type_id__once;
}

static void
_vala_geary_imap_db_email_identifier_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapDBEmailIdentifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	switch (property_id) {
		case GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY:
		g_value_set_int64 (value, geary_imap_db_email_identifier_get_message_id (self));
		break;
		case GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY:
		g_value_set_object (value, geary_imap_db_email_identifier_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_db_email_identifier_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapDBEmailIdentifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier);
	switch (property_id) {
		case GEARY_IMAP_DB_EMAIL_IDENTIFIER_MESSAGE_ID_PROPERTY:
		geary_imap_db_email_identifier_set_message_id (self, g_value_get_int64 (value));
		break;
		case GEARY_IMAP_DB_EMAIL_IDENTIFIER_UID_PROPERTY:
		geary_imap_db_email_identifier_set_uid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

