/* imap-engine-replay-operation.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine-replay-operation.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY
} GearyImapEngineReplayOperationScope;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_SCOPE (geary_imap_engine_replay_operation_scope_get_type ())
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())
enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_0_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_NOTIFIED_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyImapEngineReplayOperationReplayLocalAsyncData GearyImapEngineReplayOperationReplayLocalAsyncData;
typedef struct _GearyImapEngineReplayOperationReplayRemoteAsyncData GearyImapEngineReplayOperationReplayRemoteAsyncData;
typedef struct _GearyImapEngineReplayOperationBackoutLocalAsyncData GearyImapEngineReplayOperationBackoutLocalAsyncData;
typedef struct _GearyImapEngineReplayOperationWaitForReadyAsyncData GearyImapEngineReplayOperationWaitForReadyAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineReplayOperationPrivate {
	gchar* _name;
	gint64 _submission_number;
	GearyImapEngineReplayOperationScope _scope;
	GearyImapEngineReplayOperationOnError _on_remote_error;
	gint _remote_retry_count;
	GError* _err;
	GearyNonblockingSemaphore* semaphore;
};

struct _GearyImapEngineReplayOperationReplayLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayOperation* self;
	GearyImapEngineReplayOperationStatus result;
	GearyImapEngineReplayOperationScope _tmp0_;
	GError* _tmp1_;
	GearyImapEngineReplayOperationStatus _tmp2_;
	GearyImapEngineReplayOperationScope _tmp3_;
	GError* _inner_error0_;
};

struct _GearyImapEngineReplayOperationReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayOperation* self;
	GearyImapFolderSession* remote;
	GearyImapEngineReplayOperationScope _tmp0_;
	GError* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyImapEngineReplayOperationBackoutLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayOperation* self;
};

struct _GearyImapEngineReplayOperationWaitForReadyAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayOperation* self;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _inner_error0_;
};

static gint GearyImapEngineReplayOperation_private_offset;
static gpointer geary_imap_engine_replay_operation_parent_class = NULL;
static GeeComparableIface * geary_imap_engine_replay_operation_gee_comparable_parent_iface = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_scope_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                        GearyImapSequenceNumber* removed);
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                                   GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                      GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_local_async (GearyImapEngineReplayOperation* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN GearyImapEngineReplayOperationStatus geary_imap_engine_replay_operation_replay_local_finish (GearyImapEngineReplayOperation* self,
                                                                                             GAsyncResult* _res_,
                                                                                             GError** error);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN void geary_imap_engine_replay_operation_backout_local_async (GearyImapEngineReplayOperation* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_backout_local_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
VALA_EXTERN const gchar* geary_imap_engine_replay_operation_get_name (GearyImapEngineReplayOperation* self);
VALA_EXTERN void geary_imap_engine_replay_operation_set_name (GearyImapEngineReplayOperation* self,
                                                  const gchar* value);
VALA_EXTERN gint64 geary_imap_engine_replay_operation_get_submission_number (GearyImapEngineReplayOperation* self);
VALA_EXTERN void geary_imap_engine_replay_operation_set_submission_number (GearyImapEngineReplayOperation* self,
                                                               gint64 value);
VALA_EXTERN GearyImapEngineReplayOperationScope geary_imap_engine_replay_operation_get_scope (GearyImapEngineReplayOperation* self);
static void geary_imap_engine_replay_operation_set_scope (GearyImapEngineReplayOperation* self,
                                                   GearyImapEngineReplayOperationScope value);
VALA_EXTERN GearyImapEngineReplayOperationOnError geary_imap_engine_replay_operation_get_on_remote_error (GearyImapEngineReplayOperation* self);
VALA_EXTERN void geary_imap_engine_replay_operation_set_on_remote_error (GearyImapEngineReplayOperation* self,
                                                             GearyImapEngineReplayOperationOnError value);
VALA_EXTERN gint geary_imap_engine_replay_operation_get_remote_retry_count (GearyImapEngineReplayOperation* self);
VALA_EXTERN void geary_imap_engine_replay_operation_set_remote_retry_count (GearyImapEngineReplayOperation* self,
                                                                gint value);
VALA_EXTERN GError* geary_imap_engine_replay_operation_get_err (GearyImapEngineReplayOperation* self);
static void geary_imap_engine_replay_operation_set_err (GearyImapEngineReplayOperation* self,
                                                 GError* value);
VALA_EXTERN gboolean geary_imap_engine_replay_operation_get_notified (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyImapEngineReplayOperation* geary_imap_engine_replay_operation_construct (GType object_type,
                                                                              const gchar* name,
                                                                              GearyImapEngineReplayOperationScope scope,
                                                                              GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_replay_operation_real_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                             GearyImapSequenceNumber* removed);
static void geary_imap_engine_replay_operation_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                                        GeeCollection* ids);
static void geary_imap_engine_replay_operation_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                           GeeCollection* ids);
static void geary_imap_engine_replay_operation_real_replay_local_async_data_free (gpointer _data);
static void geary_imap_engine_replay_operation_real_replay_local_async (GearyImapEngineReplayOperation* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean geary_imap_engine_replay_operation_real_replay_local_async_co (GearyImapEngineReplayOperationReplayLocalAsyncData* _data_);
static void geary_imap_engine_replay_operation_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_replay_operation_real_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                                  GearyImapFolderSession* remote,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean geary_imap_engine_replay_operation_real_replay_remote_async_co (GearyImapEngineReplayOperationReplayRemoteAsyncData* _data_);
static void geary_imap_engine_replay_operation_real_backout_local_async_data_free (gpointer _data);
static void geary_imap_engine_replay_operation_real_backout_local_async (GearyImapEngineReplayOperation* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean geary_imap_engine_replay_operation_real_backout_local_async_co (GearyImapEngineReplayOperationBackoutLocalAsyncData* _data_);
static void geary_imap_engine_replay_operation_wait_for_ready_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_engine_replay_operation_wait_for_ready_async (GearyImapEngineReplayOperation* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_wait_for_ready_finish (GearyImapEngineReplayOperation* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static gboolean geary_imap_engine_replay_operation_wait_for_ready_async_co (GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_);
static void geary_imap_engine_replay_operation_wait_for_ready_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_notify_ready (GearyImapEngineReplayOperation* self,
                                                      GError* err);
static gchar* geary_imap_engine_replay_operation_real_describe_state (GearyImapEngineReplayOperation* self);
static gint geary_imap_engine_replay_operation_real_compare_to (GeeComparable* base,
                                                         GearyImapEngineReplayOperation* other);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self);
static void geary_imap_engine_replay_operation_finalize (GObject * obj);
static GType geary_imap_engine_replay_operation_get_type_once (void);
static void _vala_geary_imap_engine_replay_operation_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_imap_engine_replay_operation_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
geary_imap_engine_replay_operation_get_instance_private (GearyImapEngineReplayOperation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineReplayOperation_private_offset);
}

/**
     * Specifies the call scope (local, remote, both) of an operation.
     *
     * The methods that are called for the operation depends on the
     * returned Scope.
     *
     * * `LOCAL_AND_REMOTE`: replay_local_async() is called.  If that
     * method returns COMPLETED, no further calls are made.  If it
     * returns CONTINUE, replay_remote_async() is called.
     * * `LOCAL_ONLY`: replay_local_async() only.
     * replay_remote_async() will never be called.
     * * `REMOTE_ONLY`: replay_remote_async() only.
     * replay_local_async() will never be called.
     *
     * See the various replay methods for how backout_local_async()
     * may be called depending on this field and those methods' return
     * values.
     */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_operation_scope_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE", "local-and-remote"}, {GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY", "local-only"}, {GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY", "remote-only"}, {0, NULL, NULL}};
	GType geary_imap_engine_replay_operation_scope_type_id;
	geary_imap_engine_replay_operation_scope_type_id = g_enum_register_static ("GearyImapEngineReplayOperationScope", values);
	return geary_imap_engine_replay_operation_scope_type_id;
}

GType
geary_imap_engine_replay_operation_scope_get_type (void)
{
	static gsize geary_imap_engine_replay_operation_scope_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_operation_scope_type_id__once)) {
		GType geary_imap_engine_replay_operation_scope_type_id;
		geary_imap_engine_replay_operation_scope_type_id = geary_imap_engine_replay_operation_scope_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_operation_scope_type_id__once, geary_imap_engine_replay_operation_scope_type_id);
	}
	return geary_imap_engine_replay_operation_scope_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_operation_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED", "completed"}, {GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE", "continue"}, {0, NULL, NULL}};
	GType geary_imap_engine_replay_operation_status_type_id;
	geary_imap_engine_replay_operation_status_type_id = g_enum_register_static ("GearyImapEngineReplayOperationStatus", values);
	return geary_imap_engine_replay_operation_status_type_id;
}

GType
geary_imap_engine_replay_operation_status_get_type (void)
{
	static gsize geary_imap_engine_replay_operation_status_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_operation_status_type_id__once)) {
		GType geary_imap_engine_replay_operation_status_type_id;
		geary_imap_engine_replay_operation_status_type_id = geary_imap_engine_replay_operation_status_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_operation_status_type_id__once, geary_imap_engine_replay_operation_status_type_id);
	}
	return geary_imap_engine_replay_operation_status_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_operation_on_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW", "throw"}, {GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY", "retry"}, {GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE, "GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE", "ignore-remote"}, {0, NULL, NULL}};
	GType geary_imap_engine_replay_operation_on_error_type_id;
	geary_imap_engine_replay_operation_on_error_type_id = g_enum_register_static ("GearyImapEngineReplayOperationOnError", values);
	return geary_imap_engine_replay_operation_on_error_type_id;
}

GType
geary_imap_engine_replay_operation_on_error_get_type (void)
{
	static gsize geary_imap_engine_replay_operation_on_error_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_operation_on_error_type_id__once)) {
		GType geary_imap_engine_replay_operation_on_error_type_id;
		geary_imap_engine_replay_operation_on_error_type_id = geary_imap_engine_replay_operation_on_error_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_operation_on_error_type_id__once, geary_imap_engine_replay_operation_on_error_type_id);
	}
	return geary_imap_engine_replay_operation_on_error_type_id__once;
}

const gchar*
geary_imap_engine_replay_operation_get_name (GearyImapEngineReplayOperation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
geary_imap_engine_replay_operation_set_name (GearyImapEngineReplayOperation* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY]);
	}
}

gint64
geary_imap_engine_replay_operation_get_submission_number (GearyImapEngineReplayOperation* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), 0LL);
	result = self->priv->_submission_number;
	return result;
}

void
geary_imap_engine_replay_operation_set_submission_number (GearyImapEngineReplayOperation* self,
                                                          gint64 value)
{
	gint64 old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_submission_number (self);
	if (old_value != value) {
		self->priv->_submission_number = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY]);
	}
}

GearyImapEngineReplayOperationScope
geary_imap_engine_replay_operation_get_scope (GearyImapEngineReplayOperation* self)
{
	GearyImapEngineReplayOperationScope result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), 0);
	result = self->priv->_scope;
	return result;
}

static void
geary_imap_engine_replay_operation_set_scope (GearyImapEngineReplayOperation* self,
                                              GearyImapEngineReplayOperationScope value)
{
	GearyImapEngineReplayOperationScope old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_scope (self);
	if (old_value != value) {
		self->priv->_scope = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY]);
	}
}

GearyImapEngineReplayOperationOnError
geary_imap_engine_replay_operation_get_on_remote_error (GearyImapEngineReplayOperation* self)
{
	GearyImapEngineReplayOperationOnError result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), 0);
	result = self->priv->_on_remote_error;
	return result;
}

void
geary_imap_engine_replay_operation_set_on_remote_error (GearyImapEngineReplayOperation* self,
                                                        GearyImapEngineReplayOperationOnError value)
{
	GearyImapEngineReplayOperationOnError old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_on_remote_error (self);
	if (old_value != value) {
		self->priv->_on_remote_error = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY]);
	}
}

gint
geary_imap_engine_replay_operation_get_remote_retry_count (GearyImapEngineReplayOperation* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), 0);
	result = self->priv->_remote_retry_count;
	return result;
}

void
geary_imap_engine_replay_operation_set_remote_retry_count (GearyImapEngineReplayOperation* self,
                                                           gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_remote_retry_count (self);
	if (old_value != value) {
		self->priv->_remote_retry_count = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY]);
	}
}

GError*
geary_imap_engine_replay_operation_get_err (GearyImapEngineReplayOperation* self)
{
	GError* result;
	GError* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), NULL);
	_tmp0_ = self->priv->_err;
	result = _tmp0_;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
geary_imap_engine_replay_operation_set_err (GearyImapEngineReplayOperation* self,
                                            GError* value)
{
	GError* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	old_value = geary_imap_engine_replay_operation_get_err (self);
	if (old_value != value) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (value);
		_g_error_free0 (self->priv->_err);
		self->priv->_err = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY]);
	}
}

gboolean
geary_imap_engine_replay_operation_get_notified (GearyImapEngineReplayOperation* self)
{
	gboolean result;
	GearyNonblockingSemaphore* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), FALSE);
	_tmp0_ = self->priv->semaphore;
	_tmp1_ = geary_nonblocking_lock_get_can_pass (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GearyImapEngineReplayOperation*
geary_imap_engine_replay_operation_construct (GType object_type,
                                              const gchar* name,
                                              GearyImapEngineReplayOperationScope scope,
                                              GearyImapEngineReplayOperationOnError on_remote_error)
{
	GearyImapEngineReplayOperation * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyImapEngineReplayOperation*) geary_base_object_construct (object_type);
	geary_imap_engine_replay_operation_set_name (self, name);
	geary_imap_engine_replay_operation_set_scope (self, scope);
	geary_imap_engine_replay_operation_set_on_remote_error (self, on_remote_error);
	return self;
}

/**
     * Notify the operation that a message has been removed by position (SequenceNumber).
     *
     * This notification can be invoked any time before replay_remote_async() is called.
     *
     * Since the unsolicited server notification is positionally addressed, this only applies to
     * operations that use positional addressing.  Use Imap.SequenceNumber.shift_for_removed() for
     * foolproof adjustment.
     *
     * This won't be called while replay_local_async() or replay_remote_async() are executing.
     */
static void
geary_imap_engine_replay_operation_real_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                        GearyImapSequenceNumber* removed)
{
	g_return_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (removed));
}

void
geary_imap_engine_replay_operation_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                   GearyImapSequenceNumber* removed)
{
	GearyImapEngineReplayOperationClass* _klass_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->notify_remote_removed_position) {
		_klass_->notify_remote_removed_position (self, removed);
	}
}

/**
     * Notify the operation that a message has been removed by UID (EmailIdentifier).
     *
     * This method is called only when the ReplayOperation is blocked waiting to execute and it's
     * discovered that the supplied email(s) are no longer on the server.
     *
     * This happens during folder normalization (initial synchronization with the server
     * when a folder is opened) where ReplayOperations are allowed to execute locally and enqueue
     * for remote operation in preparation for the folder to fully open.
     *
     * The ReplayOperation should remove any reference to the emails so not to attempt operation
     * on the server.  If it's discovered in replay_remote_async() that there are no more operations
     * to perform, it should simply exit without contacting the server.
     *
     * This won't be called while replay_local_async() or replay_remote_async() are executing.
     */
static void
geary_imap_engine_replay_operation_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                                   GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
}

void
geary_imap_engine_replay_operation_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                              GeeCollection* ids)
{
	GearyImapEngineReplayOperationClass* _klass_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->notify_remote_removed_ids) {
		_klass_->notify_remote_removed_ids (self, ids);
	}
}

/**
     * Add to the Collection EmailIdentifiers that will be removed in replay_remote_async().
     *
     * This is called when the ReplayOperation is still waiting to run replay_remote_async().
     * If it has any EmailIdentifiers it plans on removing from the server's folder, it should
     * add them to the supplied Collection.
     *
     * This is called during folder normalization when it's necessary to know which remove markers
     * in the local folder are set due to current user interaction or were left over from the last
     * invocation (i.e. the Folder closed before the server could notify the engine that they were
     * removed).
     */
static void
geary_imap_engine_replay_operation_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                      GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
}

void
geary_imap_engine_replay_operation_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                 GeeCollection* ids)
{
	GearyImapEngineReplayOperationClass* _klass_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->get_ids_to_be_remote_removed) {
		_klass_->get_ids_to_be_remote_removed (self, ids);
	}
}

static void
geary_imap_engine_replay_operation_real_replay_local_async_data_free (gpointer _data)
{
	GearyImapEngineReplayOperationReplayLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayOperationReplayLocalAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_engine_replay_operation_real_replay_local_async (GearyImapEngineReplayOperation* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyImapEngineReplayOperationReplayLocalAsyncData* _data_;
	GearyImapEngineReplayOperation* _tmp0_;
	_data_ = g_slice_new0 (GearyImapEngineReplayOperationReplayLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_operation_real_replay_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_replay_operation_real_replay_local_async_co (_data_);
}

static GearyImapEngineReplayOperationStatus
geary_imap_engine_replay_operation_real_replay_local_finish (GearyImapEngineReplayOperation* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	GearyImapEngineReplayOperationStatus result;
	GearyImapEngineReplayOperationReplayLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0;
	}
	result = _data_->result;
	return result;
}

/**
     * Executes the local parts of this operation, if any.
     *
     * See Scope for conditions where this method will be called.
     *
     * If an error is thrown, {@link backout_local_async} will
     * *not* be executed.
     *
     * @return {@link Status.COMPLETED} if the operation has completed
     * and no further calls should be made, else {@link
     * Status.CONTINUE} if the local operation has completed and the
     * remote portion must be executed as well. This is treated as
     * `COMPLETED` if get_scope() returns {@link Scope.LOCAL_ONLY}.
     */
static gboolean
geary_imap_engine_replay_operation_real_replay_local_async_co (GearyImapEngineReplayOperationReplayLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_scope;
	if (_data_->_tmp0_ != GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY) {
		_data_->_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Local operation is not implemented");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_scope;
	if (_data_->_tmp3_ == GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY) {
		_data_->_tmp2_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED;
	} else {
		_data_->_tmp2_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE;
	}
	_data_->result = _data_->_tmp2_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_engine_replay_operation_replay_local_async (GearyImapEngineReplayOperation* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->replay_local_async) {
		_klass_->replay_local_async (self, _callback_, _user_data_);
	}
}

GearyImapEngineReplayOperationStatus
geary_imap_engine_replay_operation_replay_local_finish (GearyImapEngineReplayOperation* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->replay_local_finish) {
		return _klass_->replay_local_finish (self, _res_, error);
	}
	return 0;
}

static void
geary_imap_engine_replay_operation_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineReplayOperationReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayOperationReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_replay_operation_real_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GearyImapEngineReplayOperationReplayRemoteAsyncData* _data_;
	GearyImapEngineReplayOperation* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	_data_ = g_slice_new0 (GearyImapEngineReplayOperationReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_operation_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_replay_operation_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_replay_operation_real_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GearyImapEngineReplayOperationReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Executes the remote parts of this operation, if any.
     *
     * See Scope for conditions where this method will be called.
     *
     * Passed a folder session with the current folder selected.
     *
     * If an error is thrown, {@link backout_local_async} will be
     * executed only if scope is LOCAL_AND_REMOTE.
     */
static gboolean
geary_imap_engine_replay_operation_real_replay_remote_async_co (GearyImapEngineReplayOperationReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_scope;
	if (_data_->_tmp0_ != GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY) {
		_data_->_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Remote operation is not implemented");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                        GearyImapFolderSession* remote,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->replay_remote_async) {
		_klass_->replay_remote_async (self, remote, _callback_, _user_data_);
	}
}

void
geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->replay_remote_finish) {
		_klass_->replay_remote_finish (self, _res_, error);
	}
}

static void
geary_imap_engine_replay_operation_real_backout_local_async_data_free (gpointer _data)
{
	GearyImapEngineReplayOperationBackoutLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayOperationBackoutLocalAsyncData, _data_);
}

static void
geary_imap_engine_replay_operation_real_backout_local_async (GearyImapEngineReplayOperation* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GearyImapEngineReplayOperationBackoutLocalAsyncData* _data_;
	GearyImapEngineReplayOperation* _tmp0_;
	_data_ = g_slice_new0 (GearyImapEngineReplayOperationBackoutLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_operation_real_backout_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_replay_operation_real_backout_local_async_co (_data_);
}

static void
geary_imap_engine_replay_operation_real_backout_local_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GearyImapEngineReplayOperationBackoutLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Reverts any local effects of this operation.
     *
     * See {@link Scope}, {@link replay_local_async}, and {@link
     * replay_remote_async} for conditions for this where this will be
     * called.
     */
static gboolean
geary_imap_engine_replay_operation_real_backout_local_async_co (GearyImapEngineReplayOperationBackoutLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_engine_replay_operation_backout_local_async (GearyImapEngineReplayOperation* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->backout_local_async) {
		_klass_->backout_local_async (self, _callback_, _user_data_);
	}
}

void
geary_imap_engine_replay_operation_backout_local_finish (GearyImapEngineReplayOperation* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	GearyImapEngineReplayOperationClass* _klass_;
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->backout_local_finish) {
		_klass_->backout_local_finish (self, _res_, error);
	}
}

static void
geary_imap_engine_replay_operation_wait_for_ready_async_data_free (gpointer _data)
{
	GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayOperationWaitForReadyAsyncData, _data_);
}

void
geary_imap_engine_replay_operation_wait_for_ready_async (GearyImapEngineReplayOperation* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_;
	GearyImapEngineReplayOperation* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapEngineReplayOperationWaitForReadyAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_operation_wait_for_ready_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_engine_replay_operation_wait_for_ready_async_co (_data_);
}

void
geary_imap_engine_replay_operation_wait_for_ready_finish (GearyImapEngineReplayOperation* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Completes when the operation has completed execution.  If the operation threw an error
     * during execution, it will be thrown here.
     */
static void
geary_imap_engine_replay_operation_wait_for_ready_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_operation_wait_for_ready_async_co (_data_);
}

static gboolean
geary_imap_engine_replay_operation_wait_for_ready_async_co (GearyImapEngineReplayOperationWaitForReadyAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->semaphore;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_imap_engine_replay_operation_wait_for_ready_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_err;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->_err;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_engine_replay_operation_notify_ready (GearyImapEngineReplayOperation* self,
                                                 GError* err)
{
	GearyNonblockingSemaphore* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self));
	_tmp0_ = self->priv->semaphore;
	_tmp1_ = geary_nonblocking_lock_get_can_pass (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	_tmp2_ = _tmp1_;
	_vala_assert (!_tmp2_, "!semaphore.can_pass");
	geary_imap_engine_replay_operation_set_err (self, err);
	{
		GearyNonblockingSemaphore* _tmp3_;
		_tmp3_ = self->priv->semaphore;
		geary_nonblocking_lock_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* notify_err = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		notify_err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = self->priv->_name;
		_tmp5_ = notify_err;
		_tmp6_ = _tmp5_->message;
		g_debug ("imap-engine-replay-operation.vala:186: Unable to notify replay operati" \
"on as ready: [%s] %s", _tmp4_, _tmp6_);
		_g_error_free0 (notify_err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
geary_imap_engine_replay_operation_real_describe_state (GearyImapEngineReplayOperation* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_imap_engine_replay_operation_describe_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self)
{
	GearyImapEngineReplayOperationClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), NULL);
	_klass_ = GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS (self);
	if (_klass_->describe_state) {
		return _klass_->describe_state (self);
	}
	return NULL;
}

static gint
geary_imap_engine_replay_operation_real_compare_to (GeeComparable* base,
                                                    GearyImapEngineReplayOperation* other)
{
	GearyImapEngineReplayOperation * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation);
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (other), 0);
	_tmp0_ = self->priv->_submission_number;
	_vala_assert (_tmp0_ >= ((gint64) 0), "submission_number >= 0");
	_tmp1_ = other->priv->_submission_number;
	_vala_assert (_tmp1_ >= ((gint64) 0), "other.submission_number >= 0");
	_tmp2_ = self->priv->_submission_number;
	_tmp3_ = other->priv->_submission_number;
	result = (gint) CLAMP (_tmp2_ - _tmp3_, (gint64) -1, (gint64) 1);
	return result;
}

gchar*
geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self)
{
	gchar* state = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION (self), NULL);
	_tmp0_ = geary_imap_engine_replay_operation_describe_state (self);
	state = _tmp0_;
	_tmp2_ = state;
	if (geary_string_is_empty (_tmp2_)) {
		gint64 _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = self->priv->_submission_number;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_name;
		_tmp7_ = self->priv->_remote_retry_count;
		_tmp8_ = g_strdup_printf ("[%s] %s remote_retry_count=%d", _tmp5_, _tmp6_, _tmp7_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp8_;
		_g_free0 (_tmp5_);
	} else {
		gint64 _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = self->priv->_submission_number;
		_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->_name;
		_tmp13_ = state;
		_tmp14_ = self->priv->_remote_retry_count;
		_tmp15_ = g_strdup_printf ("[%s] %s: %s remote_retry_count=%d", _tmp11_, _tmp12_, _tmp13_, _tmp14_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp15_;
		_g_free0 (_tmp11_);
	}
	result = _tmp1_;
	_g_free0 (state);
	return result;
}

static void
geary_imap_engine_replay_operation_class_init (GearyImapEngineReplayOperationClass * klass,
                                               gpointer klass_data)
{
	geary_imap_engine_replay_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineReplayOperation_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_position = (void (*) (GearyImapEngineReplayOperation*, GearyImapSequenceNumber*)) geary_imap_engine_replay_operation_real_notify_remote_removed_position;
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_ids = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_replay_operation_real_notify_remote_removed_ids;
	((GearyImapEngineReplayOperationClass *) klass)->get_ids_to_be_remote_removed = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_replay_operation_real_get_ids_to_be_remote_removed;
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_async = (void (*) (GearyImapEngineReplayOperation*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_operation_real_replay_local_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_finish = (GearyImapEngineReplayOperationStatus (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_operation_real_replay_local_finish;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_operation_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_operation_real_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->backout_local_async = (void (*) (GearyImapEngineReplayOperation*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_operation_real_backout_local_async;
	((GearyImapEngineReplayOperationClass *) klass)->backout_local_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_operation_real_backout_local_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_replay_operation_real_describe_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_engine_replay_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_engine_replay_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_replay_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY] = g_param_spec_int64 ("submission-number", "submission-number", "submission-number", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY] = g_param_spec_enum ("scope", "scope", "scope", GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_SCOPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY] = g_param_spec_enum ("on-remote-error", "on-remote-error", "on-remote-error", GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY] = g_param_spec_int ("remote-retry-count", "remote-retry-count", "remote-retry-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY] = g_param_spec_boxed ("err", "err", "err", G_TYPE_ERROR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_REPLAY_OPERATION_NOTIFIED_PROPERTY, geary_imap_engine_replay_operation_properties[GEARY_IMAP_ENGINE_REPLAY_OPERATION_NOTIFIED_PROPERTY] = g_param_spec_boolean ("notified", "notified", "notified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_engine_replay_operation_gee_comparable_interface_init (GeeComparableIface * iface,
                                                                  gpointer iface_data)
{
	geary_imap_engine_replay_operation_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_imap_engine_replay_operation_real_compare_to;
}

static void
geary_imap_engine_replay_operation_instance_init (GearyImapEngineReplayOperation * self,
                                                  gpointer klass)
{
	GearyNonblockingSemaphore* _tmp0_;
	self->priv = geary_imap_engine_replay_operation_get_instance_private (self);
	self->priv->_submission_number = (gint64) -1;
	self->priv->_remote_retry_count = 0;
	self->priv->_err = NULL;
	_tmp0_ = geary_nonblocking_semaphore_new (NULL);
	self->priv->semaphore = _tmp0_;
}

static void
geary_imap_engine_replay_operation_finalize (GObject * obj)
{
	GearyImapEngineReplayOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation);
	_g_free0 (self->priv->_name);
	_g_error_free0 (self->priv->_err);
	_g_object_unref0 (self->priv->semaphore);
	G_OBJECT_CLASS (geary_imap_engine_replay_operation_parent_class)->finalize (obj);
}

/**
 * Base class for folder operations executed by {@link ReplayQueue}.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineReplayOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_replay_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineReplayOperation), 0, (GInstanceInitFunc) geary_imap_engine_replay_operation_instance_init, NULL };
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_imap_engine_replay_operation_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_engine_replay_operation_type_id;
	geary_imap_engine_replay_operation_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapEngineReplayOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_imap_engine_replay_operation_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	GearyImapEngineReplayOperation_private_offset = g_type_add_instance_private (geary_imap_engine_replay_operation_type_id, sizeof (GearyImapEngineReplayOperationPrivate));
	return geary_imap_engine_replay_operation_type_id;
}

GType
geary_imap_engine_replay_operation_get_type (void)
{
	static gsize geary_imap_engine_replay_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_operation_type_id__once)) {
		GType geary_imap_engine_replay_operation_type_id;
		geary_imap_engine_replay_operation_type_id = geary_imap_engine_replay_operation_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_operation_type_id__once, geary_imap_engine_replay_operation_type_id);
	}
	return geary_imap_engine_replay_operation_type_id__once;
}

static void
_vala_geary_imap_engine_replay_operation_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineReplayOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY:
		g_value_set_string (value, geary_imap_engine_replay_operation_get_name (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY:
		g_value_set_int64 (value, geary_imap_engine_replay_operation_get_submission_number (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY:
		g_value_set_enum (value, geary_imap_engine_replay_operation_get_scope (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY:
		g_value_set_enum (value, geary_imap_engine_replay_operation_get_on_remote_error (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY:
		g_value_set_int (value, geary_imap_engine_replay_operation_get_remote_retry_count (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY:
		g_value_set_pointer (value, geary_imap_engine_replay_operation_get_err (self));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_NOTIFIED_PROPERTY:
		g_value_set_boolean (value, geary_imap_engine_replay_operation_get_notified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_engine_replay_operation_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineReplayOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_NAME_PROPERTY:
		geary_imap_engine_replay_operation_set_name (self, g_value_get_string (value));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_SUBMISSION_NUMBER_PROPERTY:
		geary_imap_engine_replay_operation_set_submission_number (self, g_value_get_int64 (value));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_PROPERTY:
		geary_imap_engine_replay_operation_set_scope (self, g_value_get_enum (value));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_REMOTE_ERROR_PROPERTY:
		geary_imap_engine_replay_operation_set_on_remote_error (self, g_value_get_enum (value));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_REMOTE_RETRY_COUNT_PROPERTY:
		geary_imap_engine_replay_operation_set_remote_retry_count (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_ENGINE_REPLAY_OPERATION_ERR_PROPERTY:
		geary_imap_engine_replay_operation_set_err (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

