/* imap-account-session.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-account-session.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_TYPE_ACCOUNT_SESSION (geary_imap_account_session_get_type ())
#define GEARY_IMAP_ACCOUNT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSession))
#define GEARY_IMAP_ACCOUNT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSessionClass))
#define GEARY_IMAP_IS_ACCOUNT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_ACCOUNT_SESSION))
#define GEARY_IMAP_IS_ACCOUNT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_ACCOUNT_SESSION))
#define GEARY_IMAP_ACCOUNT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSessionClass))

typedef struct _GearyImapAccountSession GearyImapAccountSession;
typedef struct _GearyImapAccountSessionClass GearyImapAccountSessionClass;
typedef struct _GearyImapAccountSessionPrivate GearyImapAccountSessionPrivate;

#define GEARY_IMAP_TYPE_FOLDER (geary_imap_folder_get_type ())
#define GEARY_IMAP_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER, GearyImapFolder))
#define GEARY_IMAP_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER, GearyImapFolderClass))
#define GEARY_IMAP_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER))
#define GEARY_IMAP_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER))
#define GEARY_IMAP_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER, GearyImapFolderClass))

typedef struct _GearyImapFolder GearyImapFolder;
typedef struct _GearyImapFolderClass GearyImapFolderClass;
enum  {
	GEARY_IMAP_ACCOUNT_SESSION_0_PROPERTY,
	GEARY_IMAP_ACCOUNT_SESSION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_account_session_properties[GEARY_IMAP_ACCOUNT_SESSION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapAccountSessionGetDefaultPersonalNamespaceData GearyImapAccountSessionGetDefaultPersonalNamespaceData;
typedef struct _GearyImapAccountSessionCreateFolderAsyncData GearyImapAccountSessionCreateFolderAsyncData;
typedef struct _GearyImapAccountSessionFetchFolderAsyncData GearyImapAccountSessionFetchFolderAsyncData;
typedef struct _GearyImapAccountSessionFetchChildFoldersAsyncData GearyImapAccountSessionFetchChildFoldersAsyncData;
#define _geary_logging_state_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_state_unref (var), NULL)))
typedef struct _GearyImapAccountSessionSendListAsyncData GearyImapAccountSessionSendListAsyncData;
typedef struct _GearyImapAccountSessionSendStatusAsyncData GearyImapAccountSessionSendStatusAsyncData;
typedef struct _GearyImapAccountSessionSendCommandAsyncData GearyImapAccountSessionSendCommandAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapAccountSessionSendMultipleAsyncData GearyImapAccountSessionSendMultipleAsyncData;

struct _GearyImapAccountSession {
	GearyImapSessionObject parent_instance;
	GearyImapAccountSessionPrivate * priv;
};

struct _GearyImapAccountSessionClass {
	GearyImapSessionObjectClass parent_class;
};

struct _GearyImapAccountSessionPrivate {
	GearyImapFolderRoot* root;
	GeeHashMap* folders;
	GearyNonblockingMutex* cmd_mutex;
	GeeList* list_collector;
	GeeList* status_collector;
};

struct _GearyImapAccountSessionGetDefaultPersonalNamespaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GCancellable* cancellable;
	GearyFolderPath* result;
	GearyImapClientSession* session;
	GearyImapClientSession* _tmp0_;
	GeeList* personal;
	GearyImapClientSession* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError* _tmp6_;
	GearyImapNamespace* ns;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	gchar* prefix;
	GearyImapNamespace* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* delim;
	GearyImapNamespace* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	GearyFolderPath* _tmp29_;
	const gchar* _tmp30_;
	GearyImapFolderRoot* _tmp31_;
	GearyFolderPath* _tmp32_;
	GearyImapFolderRoot* _tmp33_;
	const gchar* _tmp34_;
	GearyFolderPath* _tmp35_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionCreateFolderAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyFolderPath* path;
	GearyFolderSpecialUse* use;
	GCancellable* cancellable;
	GearyImapClientSession* session;
	GearyImapClientSession* _tmp0_;
	GearyImapMailboxSpecifier* mailbox;
	GearyImapClientSession* _tmp1_;
	GearyImapMailboxSpecifier* _tmp2_;
	gboolean can_create_special;
	GearyImapClientSession* _tmp3_;
	GearyImapCapabilities* _tmp4_;
	GearyImapCapabilities* _tmp5_;
	GearyImapCreateCommand* _tmp6_;
	gboolean _tmp7_;
	GearyImapMailboxSpecifier* _tmp8_;
	GearyImapCreateCommand* _tmp9_;
	GearyImapMailboxSpecifier* _tmp10_;
	GearyImapCreateCommand* _tmp11_;
	GearyImapCreateCommand* cmd;
	GearyImapCreateCommand* _tmp12_;
	GearyImapStatusResponse* response;
	GearyImapClientSession* _tmp13_;
	GearyImapCreateCommand* _tmp14_;
	GearyImapStatusResponse* _tmp15_;
	GearyImapStatusResponse* _tmp16_;
	GearyImapStatus _tmp17_;
	GearyImapStatus _tmp18_;
	GearyImapMailboxSpecifier* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GearyImapStatusResponse* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionFetchFolderAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyFolderPath* path;
	GCancellable* cancellable;
	GearyImapFolder* result;
	GearyImapClientSession* session;
	GearyImapClientSession* _tmp0_;
	GearyImapFolder* folder;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GearyImapFolder* _tmp3_;
	GeeList* mailboxes;
	GearyImapClientSession* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GearyImapMailboxInformation* mailbox_info;
	GeeList* _tmp9_;
	gpointer _tmp10_;
	GearyImapFolderProperties* props;
	GearyImapMailboxInformation* _tmp11_;
	GearyImapMailboxAttributes* _tmp12_;
	GearyImapMailboxAttributes* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GearyImapStatusData* status;
	GearyImapClientSession* _tmp16_;
	GearyImapMailboxInformation* _tmp17_;
	GearyImapMailboxSpecifier* _tmp18_;
	GearyImapMailboxSpecifier* _tmp19_;
	gint _tmp20_;
	GearyImapStatusDataType* _tmp21_;
	GearyImapStatusDataType* _tmp22_;
	gint _tmp22__length1;
	GearyImapStatusData* _tmp23_;
	GearyImapStatusData* _tmp24_;
	GearyImapMailboxInformation* _tmp25_;
	GearyImapMailboxAttributes* _tmp26_;
	GearyImapMailboxAttributes* _tmp27_;
	GearyImapStatusData* _tmp28_;
	GearyImapClientSession* _tmp29_;
	GearyImapCapabilities* _tmp30_;
	GearyImapCapabilities* _tmp31_;
	GearyImapFolderProperties* _tmp32_;
	GearyImapMailboxInformation* _tmp33_;
	GearyImapMailboxAttributes* _tmp34_;
	GearyImapMailboxAttributes* _tmp35_;
	GearyImapFolderProperties* _tmp36_;
	GearyImapFolderProperties* _tmp37_;
	GearyImapFolder* _tmp38_;
	GeeHashMap* _tmp39_;
	GearyImapFolder* _tmp40_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionFetchChildFoldersAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyFolderPath* parent;
	GCancellable* cancellable;
	GeeList* result;
	GearyImapClientSession* session;
	GearyImapClientSession* _tmp0_;
	GeeList* children;
	GeeArrayList* _tmp1_;
	GeeList* mailboxes;
	GearyImapClientSession* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeMap* info_map;
	GeeHashMap* _tmp7_;
	GeeMap* cmd_map;
	GeeHashMap* _tmp8_;
	GeeList* _mailbox_info_list;
	GeeList* _tmp9_;
	gint _mailbox_info_size;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _mailbox_info_index;
	gint _tmp13_;
	gint _tmp14_;
	GearyImapMailboxInformation* mailbox_info;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	GearyImapMailboxInformation* _tmp17_;
	GearyImapMailboxAttributes* _tmp18_;
	GearyImapMailboxAttributes* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GeeMap* _tmp22_;
	GearyImapMailboxInformation* _tmp23_;
	GearyImapMailboxSpecifier* _tmp24_;
	GearyImapMailboxSpecifier* _tmp25_;
	GearyImapMailboxInformation* _tmp26_;
	GeeMap* _tmp27_;
	GearyImapMailboxInformation* _tmp28_;
	GearyImapMailboxSpecifier* _tmp29_;
	GearyImapMailboxSpecifier* _tmp30_;
	gint _tmp31_;
	GearyImapStatusDataType* _tmp32_;
	GearyImapStatusDataType* _tmp33_;
	gint _tmp33__length1;
	GearyImapStatusCommand* _tmp34_;
	GearyImapStatusCommand* _tmp35_;
	GearyImapMailboxInformation* _tmp36_;
	GearyImapMailboxSpecifier* _tmp37_;
	GearyImapMailboxSpecifier* _tmp38_;
	GearyFolderPath* path;
	GearyImapClientSession* _tmp39_;
	GearyImapFolderRoot* _tmp40_;
	GearyImapMailboxInformation* _tmp41_;
	GearyImapMailboxSpecifier* _tmp42_;
	GearyImapMailboxSpecifier* _tmp43_;
	GearyFolderPath* _tmp44_;
	GearyImapFolder* child;
	GeeHashMap* _tmp45_;
	GearyFolderPath* _tmp46_;
	gpointer _tmp47_;
	GearyImapFolder* _tmp48_;
	GearyFolderPath* _tmp49_;
	GearyImapMailboxInformation* _tmp50_;
	GearyImapMailboxAttributes* _tmp51_;
	GearyImapMailboxAttributes* _tmp52_;
	GearyImapFolderProperties* _tmp53_;
	GearyImapFolderProperties* _tmp54_;
	GearyImapFolder* _tmp55_;
	GeeHashMap* _tmp56_;
	GearyFolderPath* _tmp57_;
	GearyImapFolder* _tmp58_;
	GeeList* _tmp59_;
	GearyImapFolder* _tmp60_;
	GeeMap* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	GeeList* status_results;
	GeeArrayList* _tmp64_;
	GeeMap* responses;
	GearyImapClientSession* _tmp65_;
	GeeMap* _tmp66_;
	GeeSet* _tmp67_;
	GeeSet* _tmp68_;
	GeeSet* _tmp69_;
	GeeList* _tmp70_;
	GeeMap* _tmp71_;
	GeeMap* _tmp72_;
	GeeIterator* _cmd_it;
	GeeMap* _tmp73_;
	GeeSet* _tmp74_;
	GeeSet* _tmp75_;
	GeeSet* _tmp76_;
	GeeIterator* _tmp77_;
	GeeIterator* _tmp78_;
	GeeIterator* _tmp79_;
	GearyImapCommand* cmd;
	GeeIterator* _tmp80_;
	gpointer _tmp81_;
	GearyImapStatusCommand* status_cmd;
	GearyImapCommand* _tmp82_;
	GearyImapStatusCommand* _tmp83_;
	GearyImapStatusResponse* response;
	GeeMap* _tmp84_;
	GearyImapCommand* _tmp85_;
	gpointer _tmp86_;
	GearyImapMailboxSpecifier* mailbox;
	GeeMap* _tmp87_;
	GearyImapStatusCommand* _tmp88_;
	gpointer _tmp89_;
	GearyImapMailboxInformation* _vala1_mailbox_info;
	GeeMap* _tmp90_;
	GearyImapMailboxSpecifier* _tmp91_;
	gpointer _tmp92_;
	GearyImapStatusResponse* _tmp93_;
	GearyImapStatus _tmp94_;
	GearyImapStatus _tmp95_;
	GearyImapMailboxSpecifier* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	GearyImapStatusResponse* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GearyImapCommand* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GearyImapStatusData* status;
	GeeList* _status_data_list;
	GeeList* _tmp105_;
	gint _status_data_size;
	GeeList* _tmp106_;
	gint _tmp107_;
	gint _tmp108_;
	gint _status_data_index;
	gint _tmp109_;
	gint _tmp110_;
	GearyImapStatusData* status_data;
	GeeList* _tmp111_;
	gpointer _tmp112_;
	GearyImapStatusData* _tmp113_;
	GearyImapMailboxSpecifier* _tmp114_;
	GearyImapMailboxSpecifier* _tmp115_;
	GearyImapMailboxSpecifier* _tmp116_;
	GearyImapStatusData* _tmp117_;
	GearyImapStatusData* _tmp118_;
	GearyImapStatusData* _tmp119_;
	GearyImapMailboxSpecifier* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	GeeList* _tmp123_;
	GearyImapStatusData* _tmp124_;
	GearyFolderPath* child_path;
	GearyImapClientSession* _tmp125_;
	GearyImapFolderRoot* _tmp126_;
	GearyImapMailboxInformation* _tmp127_;
	GearyImapMailboxSpecifier* _tmp128_;
	GearyImapMailboxSpecifier* _tmp129_;
	GearyFolderPath* _tmp130_;
	GearyImapFolder* _vala1_child;
	GeeHashMap* _tmp131_;
	GearyFolderPath* _tmp132_;
	gpointer _tmp133_;
	GearyImapFolder* _tmp134_;
	GearyImapFolder* _tmp135_;
	GearyImapFolderProperties* _tmp136_;
	GearyImapFolderProperties* _tmp137_;
	GearyImapStatusData* _tmp138_;
	GearyFolderPath* _tmp139_;
	GearyImapMailboxInformation* _tmp140_;
	GearyImapMailboxAttributes* _tmp141_;
	GearyImapMailboxAttributes* _tmp142_;
	GearyImapStatusData* _tmp143_;
	GearyImapClientSession* _tmp144_;
	GearyImapCapabilities* _tmp145_;
	GearyImapCapabilities* _tmp146_;
	GearyImapFolderProperties* _tmp147_;
	GearyImapFolderProperties* _tmp148_;
	GearyImapFolder* _tmp149_;
	GeeHashMap* _tmp150_;
	GearyFolderPath* _tmp151_;
	GearyImapFolder* _tmp152_;
	GeeList* _tmp153_;
	GearyImapFolder* _tmp154_;
	GeeList* _tmp155_;
	gint _tmp156_;
	gint _tmp157_;
	GeeList* _tmp158_;
	gint _tmp159_;
	gint _tmp160_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionSendListAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyImapClientSession* session;
	GearyFolderPath* folder;
	gboolean list_children;
	GCancellable* cancellable;
	GeeList* result;
	GearyImapListReturnParameter* return_param;
	gboolean use_xlist;
	GearyImapCapabilities* _tmp0_;
	GearyImapCapabilities* _tmp1_;
	GearyImapListReturnParameter* _tmp2_;
	GearyImapListReturnParameter* _tmp3_;
	GearyImapCapabilities* _tmp4_;
	GearyImapCapabilities* _tmp5_;
	GearyImapListCommand* cmd;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GearyImapMailboxSpecifier* _tmp8_;
	GearyImapMailboxSpecifier* _tmp9_;
	GearyImapListReturnParameter* _tmp10_;
	GearyImapListCommand* _tmp11_;
	GearyImapMailboxSpecifier* _tmp12_;
	GearyImapMailboxSpecifier* _tmp13_;
	gchar* specifier;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* delim;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	GearyImapMailboxSpecifier* _tmp26_;
	GearyImapMailboxSpecifier* _tmp27_;
	GearyImapListReturnParameter* _tmp28_;
	GearyImapListCommand* _tmp29_;
	GeeList* list_results;
	GeeArrayList* _tmp30_;
	GearyImapStatusResponse* response;
	GearyImapListCommand* _tmp31_;
	GeeList* _tmp32_;
	GearyImapStatusResponse* _tmp33_;
	GearyImapStatusResponse* _tmp34_;
	GearyImapStatus _tmp35_;
	GearyImapStatus _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GearyImapStatusResponse* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GError* _tmp43_;
	GError* _tmp44_;
	gboolean _tmp45_;
	GeeIterator* iter;
	GeeList* _tmp46_;
	GeeIterator* _tmp47_;
	GeeIterator* _tmp48_;
	GearyFolderPath* list_path;
	GearyImapFolderRoot* _tmp49_;
	GeeIterator* _tmp50_;
	gpointer _tmp51_;
	GearyImapMailboxInformation* _tmp52_;
	GearyImapMailboxSpecifier* _tmp53_;
	GearyImapMailboxSpecifier* _tmp54_;
	GearyFolderPath* _tmp55_;
	GearyFolderPath* _tmp56_;
	GearyFolderPath* _tmp57_;
	GearyFolderPath* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GeeIterator* _tmp61_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionSendStatusAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyImapClientSession* session;
	GearyImapMailboxSpecifier* mailbox;
	GearyImapStatusDataType* status_types;
	gint status_types_length1;
	GCancellable* cancellable;
	GearyImapStatusData* result;
	GeeList* status_results;
	GeeArrayList* _tmp0_;
	GearyImapStatusResponse* response;
	GearyImapStatusCommand* _tmp1_;
	GearyImapStatusCommand* _tmp2_;
	GeeList* _tmp3_;
	GearyImapStatusResponse* _tmp4_;
	GearyImapStatusResponse* _tmp5_;
	GearyImapStatusResponse* _tmp6_;
	GearyImapStatus _tmp7_;
	GearyImapStatus _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GearyImapStatusResponse* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GearyImapStatusResponse* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	GeeList* _tmp29_;
	gpointer _tmp30_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionSendCommandAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyImapClientSession* session;
	GearyImapCommand* cmd;
	GeeList* list_results;
	GeeList* status_results;
	GCancellable* cancellable;
	GearyImapStatusResponse* result;
	GeeMap* responses;
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GearyImapStatusResponse* response;
	GeeMap* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	gpointer _tmp10_;
	GearyImapStatusResponse* _tmp11_;
	GearyImapStatusResponse* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

struct _GearyImapAccountSessionSendMultipleAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAccountSession* self;
	GearyImapClientSession* session;
	GeeCollection* cmds;
	GeeList* list_results;
	GeeList* status_results;
	GCancellable* cancellable;
	GeeMap* result;
	GeeMap* responses;
	gint token;
	GearyNonblockingMutex* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GError* cmd_err;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GError* err;
	GError* _tmp6_;
	GError* _tmp7_;
	GearyNonblockingMutex* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_;
};

static gint GearyImapAccountSession_private_offset;
static gpointer geary_imap_account_session_parent_class = NULL;

VALA_EXTERN GType geary_imap_account_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapAccountSession* geary_imap_account_session_new (GearyImapFolderRoot* root,
                                                         GearyImapClientSession* session);
VALA_EXTERN GearyImapAccountSession* geary_imap_account_session_construct (GType object_type,
                                                               GearyImapFolderRoot* root,
                                                               GearyImapClientSession* session);
static void geary_imap_account_session_on_list_data (GearyImapAccountSession* self,
                                              GearyImapMailboxInformation* mailbox_info);
static void _geary_imap_account_session_on_list_data_geary_imap_client_session_list (GearyImapClientSession* _sender,
                                                                              GearyImapMailboxInformation* mailbox_info,
                                                                              gpointer self);
static void geary_imap_account_session_on_status_data (GearyImapAccountSession* self,
                                                GearyImapStatusData* status_data);
static void _geary_imap_account_session_on_status_data_geary_imap_client_session_status (GearyImapClientSession* _sender,
                                                                                  GearyImapStatusData* status_data,
                                                                                  gpointer self);
static void geary_imap_account_session_get_default_personal_namespace_data_free (gpointer _data);
VALA_EXTERN void geary_imap_account_session_get_default_personal_namespace (GearyImapAccountSession* self,
                                                                GCancellable* cancellable,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN GearyFolderPath* geary_imap_account_session_get_default_personal_namespace_finish (GearyImapAccountSession* self,
                                                                                   GAsyncResult* _res_,
                                                                                   GError** error);
static gboolean geary_imap_account_session_get_default_personal_namespace_co (GearyImapAccountSessionGetDefaultPersonalNamespaceData* _data_);
VALA_EXTERN gboolean geary_imap_account_session_is_folder_path_valid (GearyImapAccountSession* self,
                                                          GearyFolderPath* path,
                                                          GError** error);
static void geary_imap_account_session_create_folder_async_data_free (gpointer _data);
static GearyFolderSpecialUse* _geary_folder_special_use_dup (GearyFolderSpecialUse* self);
VALA_EXTERN void geary_imap_account_session_create_folder_async (GearyImapAccountSession* self,
                                                     GearyFolderPath* path,
                                                     GearyFolderSpecialUse* use,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void geary_imap_account_session_create_folder_finish (GearyImapAccountSession* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static gboolean geary_imap_account_session_create_folder_async_co (GearyImapAccountSessionCreateFolderAsyncData* _data_);
static void geary_imap_account_session_send_command_async (GearyImapAccountSession* self,
                                                    GearyImapClientSession* session,
                                                    GearyImapCommand* cmd,
                                                    GeeList* list_results,
                                                    GeeList* status_results,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static GearyImapStatusResponse* geary_imap_account_session_send_command_finish (GearyImapAccountSession* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void geary_imap_account_session_create_folder_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void geary_imap_account_session_fetch_folder_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_account_session_fetch_folder_async (GearyImapAccountSession* self,
                                                    GearyFolderPath* path,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN GearyImapFolder* geary_imap_account_session_fetch_folder_finish (GearyImapAccountSession* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error);
static gboolean geary_imap_account_session_fetch_folder_async_co (GearyImapAccountSessionFetchFolderAsyncData* _data_);
static void geary_imap_account_session_send_list_async (GearyImapAccountSession* self,
                                                 GearyImapClientSession* session,
                                                 GearyFolderPath* folder,
                                                 gboolean list_children,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static GeeList* geary_imap_account_session_send_list_finish (GearyImapAccountSession* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_imap_account_session_fetch_folder_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_imap_account_session_throw_not_found (GearyImapAccountSession* self,
                                                 GearyFolderPath* path,
                                                 GError** error);
static void geary_imap_account_session_send_status_async (GearyImapAccountSession* self,
                                                   GearyImapClientSession* session,
                                                   GearyImapMailboxSpecifier* mailbox,
                                                   GearyImapStatusDataType* status_types,
                                                   gint status_types_length1,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static GearyImapStatusData* geary_imap_account_session_send_status_finish (GearyImapAccountSession* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
VALA_EXTERN GearyImapFolder* geary_imap_folder_new (GearyFolderPath* path,
                                        GearyImapFolderProperties* properties);
VALA_EXTERN GearyImapFolder* geary_imap_folder_construct (GType object_type,
                                              GearyFolderPath* path,
                                              GearyImapFolderProperties* properties);
static void geary_imap_account_session_fetch_child_folders_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_account_session_fetch_child_folders_async (GearyImapAccountSession* self,
                                                           GearyFolderPath* parent,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN GeeList* geary_imap_account_session_fetch_child_folders_finish (GearyImapAccountSession* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static gboolean geary_imap_account_session_fetch_child_folders_async_co (GearyImapAccountSessionFetchChildFoldersAsyncData* _data_);
static void geary_imap_account_session_fetch_child_folders_async_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void geary_imap_account_session_send_multiple_async (GearyImapAccountSession* self,
                                                     GearyImapClientSession* session,
                                                     GeeCollection* cmds,
                                                     GeeList* list_results,
                                                     GeeList* status_results,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static GeeMap* geary_imap_account_session_send_multiple_finish (GearyImapAccountSession* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
VALA_EXTERN GearyImapFolderProperties* geary_imap_folder_get_properties (GearyImapFolder* self);
VALA_EXTERN void geary_imap_account_session_folders_removed (GearyImapAccountSession* self,
                                                 GeeCollection* paths);
static GearyImapClientSession* geary_imap_account_session_real_close (GearyImapSessionObject* base);
static GearyLoggingState* geary_imap_account_session_real_to_logging_state (GearyImapSessionObject* base);
static void geary_imap_account_session_send_list_async_data_free (gpointer _data);
static gboolean geary_imap_account_session_send_list_async_co (GearyImapAccountSessionSendListAsyncData* _data_);
static void geary_imap_account_session_send_list_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void geary_imap_account_session_send_status_async_data_free (gpointer _data);
static gboolean geary_imap_account_session_send_status_async_co (GearyImapAccountSessionSendStatusAsyncData* _data_);
static void geary_imap_account_session_send_status_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_imap_account_session_send_command_async_data_free (gpointer _data);
static gboolean geary_imap_account_session_send_command_async_co (GearyImapAccountSessionSendCommandAsyncData* _data_);
static void geary_imap_account_session_send_command_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_imap_account_session_send_multiple_async_data_free (gpointer _data);
static gboolean geary_imap_account_session_send_multiple_async_co (GearyImapAccountSessionSendMultipleAsyncData* _data_);
static void geary_imap_account_session_send_multiple_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void geary_imap_account_session_finalize (GObject * obj);
static GType geary_imap_account_session_get_type_once (void);

static inline gpointer
geary_imap_account_session_get_instance_private (GearyImapAccountSession* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapAccountSession_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_geary_imap_account_session_on_list_data_geary_imap_client_session_list (GearyImapClientSession* _sender,
                                                                         GearyImapMailboxInformation* mailbox_info,
                                                                         gpointer self)
{
	geary_imap_account_session_on_list_data ((GearyImapAccountSession*) self, mailbox_info);
}

static void
_geary_imap_account_session_on_status_data_geary_imap_client_session_status (GearyImapClientSession* _sender,
                                                                             GearyImapStatusData* status_data,
                                                                             gpointer self)
{
	geary_imap_account_session_on_status_data ((GearyImapAccountSession*) self, status_data);
}

GearyImapAccountSession*
geary_imap_account_session_construct (GType object_type,
                                      GearyImapFolderRoot* root,
                                      GearyImapClientSession* session)
{
	GearyImapAccountSession * self = NULL;
	GearyImapFolderRoot* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_ROOT (root), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session), NULL);
	self = (GearyImapAccountSession*) geary_imap_session_object_construct (object_type, session);
	_tmp0_ = _g_object_ref0 (root);
	_g_object_unref0 (self->priv->root);
	self->priv->root = _tmp0_;
	g_signal_connect_object (session, "list", (GCallback) _geary_imap_account_session_on_list_data_geary_imap_client_session_list, self, 0);
	g_signal_connect_object (session, "status", (GCallback) _geary_imap_account_session_on_status_data_geary_imap_client_session_status, self, 0);
	return self;
}

GearyImapAccountSession*
geary_imap_account_session_new (GearyImapFolderRoot* root,
                                GearyImapClientSession* session)
{
	return geary_imap_account_session_construct (GEARY_IMAP_TYPE_ACCOUNT_SESSION, root, session);
}

static void
geary_imap_account_session_get_default_personal_namespace_data_free (gpointer _data)
{
	GearyImapAccountSessionGetDefaultPersonalNamespaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionGetDefaultPersonalNamespaceData, _data_);
}

void
geary_imap_account_session_get_default_personal_namespace (GearyImapAccountSession* self,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	GearyImapAccountSessionGetDefaultPersonalNamespaceData* _data_;
	GearyImapAccountSession* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionGetDefaultPersonalNamespaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_get_default_personal_namespace_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_account_session_get_default_personal_namespace_co (_data_);
}

GearyFolderPath*
geary_imap_account_session_get_default_personal_namespace_finish (GearyImapAccountSession* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error)
{
	GearyFolderPath* result;
	GearyImapAccountSessionGetDefaultPersonalNamespaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the root path for the default personal namespace.
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
geary_imap_account_session_get_default_personal_namespace_co (GearyImapAccountSessionGetDefaultPersonalNamespaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_session_object_get_session (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject), &_data_->_inner_error0_);
	_data_->session = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->session;
	_data_->_tmp2_ = geary_imap_client_session_get_personal_namespaces (_data_->_tmp1_);
	_data_->personal = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->personal;
	_data_->_tmp4_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "No personal namespace found");
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->personal);
		_g_object_unref0 (_data_->session);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->personal;
	_data_->_tmp8_ = gee_list_get (_data_->_tmp7_, 0);
	_data_->ns = (GearyImapNamespace*) _data_->_tmp8_;
	_data_->_tmp9_ = _data_->ns;
	_data_->_tmp10_ = geary_imap_namespace_get_prefix (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
	_data_->prefix = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->ns;
	_data_->_tmp14_ = geary_imap_namespace_get_delim (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
	_data_->delim = _data_->_tmp16_;
	_data_->_tmp18_ = _data_->delim;
	if (_data_->_tmp18_ != NULL) {
		_data_->_tmp19_ = _data_->prefix;
		_data_->_tmp20_ = _data_->delim;
		_data_->_tmp17_ = g_str_has_suffix (_data_->_tmp19_, _data_->_tmp20_);
	} else {
		_data_->_tmp17_ = FALSE;
	}
	if (_data_->_tmp17_) {
		_data_->_tmp21_ = _data_->prefix;
		_data_->_tmp22_ = _data_->prefix;
		_data_->_tmp23_ = strlen (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->delim;
		_data_->_tmp26_ = strlen (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = string_substring (_data_->_tmp21_, (glong) 0, (glong) (_data_->_tmp24_ - _data_->_tmp27_));
		_g_free0 (_data_->prefix);
		_data_->prefix = _data_->_tmp28_;
	}
	_data_->_tmp30_ = _data_->prefix;
	if (geary_string_is_empty (_data_->_tmp30_)) {
		_data_->_tmp31_ = _data_->self->priv->root;
		_data_->_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_TYPE_FOLDER_PATH, GearyFolderPath));
		_g_object_unref0 (_data_->_tmp29_);
		_data_->_tmp29_ = _data_->_tmp32_;
	} else {
		_data_->_tmp33_ = _data_->self->priv->root;
		_data_->_tmp34_ = _data_->prefix;
		_data_->_tmp35_ = geary_folder_path_get_child (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp33_, GEARY_TYPE_FOLDER_PATH, GearyFolderPath), _data_->_tmp34_, GEARY_TRILLIAN_UNKNOWN);
		_g_object_unref0 (_data_->_tmp29_);
		_data_->_tmp29_ = _data_->_tmp35_;
	}
	_data_->result = _data_->_tmp29_;
	_g_free0 (_data_->delim);
	_g_free0 (_data_->prefix);
	_g_object_unref0 (_data_->ns);
	_g_object_unref0 (_data_->personal);
	_g_object_unref0 (_data_->session);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Determines if the given folder path appears to a valid mailbox.
     */
gboolean
geary_imap_account_session_is_folder_path_valid (GearyImapAccountSession* self,
                                                 GearyFolderPath* path,
                                                 GError** error)
{
	gboolean is_valid = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self), FALSE);
	g_return_val_if_fail ((path == NULL) || GEARY_IS_FOLDER_PATH (path), FALSE);
	is_valid = FALSE;
	if (path != NULL) {
		GearyImapClientSession* session = NULL;
		GearyImapClientSession* _tmp0_;
		_tmp0_ = geary_imap_session_object_get_session (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject), &_inner_error0_);
		session = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		}
		{
			GearyImapClientSession* _tmp2_;
			GearyImapMailboxSpecifier* _tmp3_;
			GearyImapMailboxSpecifier* _tmp4_;
			_tmp2_ = session;
			_tmp3_ = geary_imap_client_session_get_mailbox_for_path (_tmp2_, path, &_inner_error0_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			is_valid = TRUE;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (session);
			return _tmp5_;
		}
		_g_object_unref0 (session);
	}
	result = is_valid;
	return result;
}

static void
geary_imap_account_session_create_folder_async_data_free (gpointer _data)
{
	GearyImapAccountSessionCreateFolderAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->path);
	_g_free0 (_data_->use);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionCreateFolderAsyncData, _data_);
}

static GearyFolderSpecialUse*
_geary_folder_special_use_dup (GearyFolderSpecialUse* self)
{
	GearyFolderSpecialUse* dup;
	dup = g_new0 (GearyFolderSpecialUse, 1);
	memcpy (dup, self, sizeof (GearyFolderSpecialUse));
	return dup;
}

static gpointer
__geary_folder_special_use_dup0 (gpointer self)
{
	return self ? _geary_folder_special_use_dup (self) : NULL;
}

void
geary_imap_account_session_create_folder_async (GearyImapAccountSession* self,
                                                GearyFolderPath* path,
                                                GearyFolderSpecialUse* use,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyImapAccountSessionCreateFolderAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderSpecialUse* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (path));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionCreateFolderAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_create_folder_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (path);
	_g_object_unref0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = __geary_folder_special_use_dup0 (use);
	_g_free0 (_data_->use);
	_data_->use = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_imap_account_session_create_folder_async_co (_data_);
}

void
geary_imap_account_session_create_folder_finish (GearyImapAccountSession* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearyImapAccountSessionCreateFolderAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Creates a new special folder on the remote server.
     *
     * The given path must be a fully-qualified path, including
     * namespace prefix.
     *
     * If the optional special folder type is specified, and
     * CREATE-SPECIAL-USE is supported by the connection, that will be
     * used to specify the type of the new folder.
     */
static void
geary_imap_account_session_create_folder_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearyImapAccountSessionCreateFolderAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_create_folder_async_co (_data_);
}

static gboolean
geary_imap_account_session_create_folder_async_co (GearyImapAccountSessionCreateFolderAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_session_object_get_session (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject), &_data_->_inner_error0_);
	_data_->session = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->session;
	_data_->_tmp2_ = geary_imap_client_session_get_mailbox_for_path (_data_->_tmp1_, _data_->path, &_data_->_inner_error0_);
	_data_->mailbox = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->session);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->session;
	_data_->_tmp4_ = geary_imap_client_session_get_capabilities (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->can_create_special = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_CREATE_SPECIAL_USE);
	if (_data_->use != NULL) {
		_data_->_tmp7_ = _data_->can_create_special;
	} else {
		_data_->_tmp7_ = FALSE;
	}
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _data_->mailbox;
		_data_->_tmp9_ = geary_imap_create_command_new_special_use (_data_->_tmp8_, *_data_->use, _data_->cancellable);
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_tmp6_ = _data_->_tmp9_;
	} else {
		_data_->_tmp10_ = _data_->mailbox;
		_data_->_tmp11_ = geary_imap_create_command_new (_data_->_tmp10_, _data_->cancellable);
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_tmp6_ = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp6_);
	_data_->cmd = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->session;
	_data_->_tmp14_ = _data_->cmd;
	_data_->_state_ = 1;
	geary_imap_account_session_send_command_async (_data_->self, _data_->_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), NULL, NULL, _data_->cancellable, geary_imap_account_session_create_folder_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp15_ = geary_imap_account_session_send_command_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp15_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cmd);
		_g_object_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->mailbox);
		_g_object_unref0 (_data_->session);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->response;
	_data_->_tmp17_ = geary_imap_status_response_get_status (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	if (_data_->_tmp18_ != GEARY_IMAP_STATUS_OK) {
		_data_->_tmp19_ = _data_->mailbox;
		_data_->_tmp20_ = geary_imap_mailbox_specifier_to_string (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->response;
		_data_->_tmp23_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "Server reports error creating folder %s: %s", _data_->_tmp21_, _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_g_free0 (_data_->_tmp24_);
		_g_free0 (_data_->_tmp21_);
		_data_->_inner_error0_ = _data_->_tmp26_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->cmd);
		_g_object_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->mailbox);
		_g_object_unref0 (_data_->session);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->response);
	_g_object_unref0 (_data_->cmd);
	_g_object_unref0 (_data_->_tmp6_);
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->session);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_fetch_folder_async_data_free (gpointer _data)
{
	GearyImapAccountSessionFetchFolderAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionFetchFolderAsyncData, _data_);
}

void
geary_imap_account_session_fetch_folder_async (GearyImapAccountSession* self,
                                               GearyFolderPath* path,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearyImapAccountSessionFetchFolderAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyFolderPath* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (path));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionFetchFolderAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_fetch_folder_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (path);
	_g_object_unref0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_account_session_fetch_folder_async_co (_data_);
}

GearyImapFolder*
geary_imap_account_session_fetch_folder_finish (GearyImapAccountSession* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearyImapFolder* result;
	GearyImapAccountSessionFetchFolderAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a single folder, from the account's cache or fetched fresh.
     *
     * If the folder has previously been retrieved, that is returned
     * instead of fetching it again. If not, it is fetched from the
     * server and cached for future use.
     */
static void
geary_imap_account_session_fetch_folder_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearyImapAccountSessionFetchFolderAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_fetch_folder_async_co (_data_);
}

static gboolean
geary_imap_account_session_fetch_folder_async_co (GearyImapAccountSessionFetchFolderAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_session_object_get_session (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject), &_data_->_inner_error0_);
	_data_->session = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->folders;
	_data_->_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->path);
	_data_->folder = (GearyImapFolder*) _data_->_tmp2_;
	_data_->_tmp3_ = _data_->folder;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = _data_->session;
		_data_->_state_ = 1;
		geary_imap_account_session_send_list_async (_data_->self, _data_->_tmp4_, _data_->path, FALSE, _data_->cancellable, geary_imap_account_session_fetch_folder_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = geary_imap_account_session_send_list_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->mailboxes = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->folder);
			_g_object_unref0 (_data_->session);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = _data_->mailboxes;
		_data_->_tmp7_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp8_ = _data_->_tmp7_;
		if (_data_->_tmp8_) {
			geary_imap_account_session_throw_not_found (_data_->self, _data_->path, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->mailboxes);
				_g_object_unref0 (_data_->folder);
				_g_object_unref0 (_data_->session);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp9_ = _data_->mailboxes;
		_data_->_tmp10_ = gee_list_get (_data_->_tmp9_, 0);
		_data_->mailbox_info = (GearyImapMailboxInformation*) _data_->_tmp10_;
		_data_->props = NULL;
		_data_->_tmp11_ = _data_->mailbox_info;
		_data_->_tmp12_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = geary_imap_mailbox_attributes_get_is_no_select (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		if (!_data_->_tmp15_) {
			_data_->_tmp16_ = _data_->session;
			_data_->_tmp17_ = _data_->mailbox_info;
			_data_->_tmp18_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = 0;
			_data_->_tmp21_ = geary_imap_status_data_type_all (&_data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp22__length1 = _data_->_tmp20_;
			_data_->_state_ = 2;
			geary_imap_account_session_send_status_async (_data_->self, _data_->_tmp16_, _data_->_tmp19_, _data_->_tmp22_, (gint) _data_->_tmp20_, _data_->cancellable, geary_imap_account_session_fetch_folder_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp23_ = geary_imap_account_session_send_status_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp22_ = (g_free (_data_->_tmp22_), NULL);
			_data_->status = _data_->_tmp24_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->props);
				_g_object_unref0 (_data_->mailbox_info);
				_g_object_unref0 (_data_->mailboxes);
				_g_object_unref0 (_data_->folder);
				_g_object_unref0 (_data_->session);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp25_ = _data_->mailbox_info;
			_data_->_tmp26_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = _data_->status;
			_data_->_tmp29_ = _data_->session;
			_data_->_tmp30_ = geary_imap_client_session_get_capabilities (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = geary_imap_folder_properties_new_selectable (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp31_);
			_g_object_unref0 (_data_->props);
			_data_->props = _data_->_tmp32_;
			_g_object_unref0 (_data_->status);
		} else {
			_data_->_tmp33_ = _data_->mailbox_info;
			_data_->_tmp34_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = geary_imap_folder_properties_new_not_selectable (_data_->_tmp35_);
			_g_object_unref0 (_data_->props);
			_data_->props = _data_->_tmp36_;
		}
		_data_->_tmp37_ = _data_->props;
		_data_->_tmp38_ = geary_imap_folder_new (_data_->path, _data_->_tmp37_);
		_g_object_unref0 (_data_->folder);
		_data_->folder = _data_->_tmp38_;
		_data_->_tmp39_ = _data_->self->priv->folders;
		_data_->_tmp40_ = _data_->folder;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->path, _data_->_tmp40_);
		_g_object_unref0 (_data_->props);
		_g_object_unref0 (_data_->mailbox_info);
		_g_object_unref0 (_data_->mailboxes);
	}
	_data_->result = _data_->folder;
	_g_object_unref0 (_data_->session);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_fetch_child_folders_async_data_free (gpointer _data)
{
	GearyImapAccountSessionFetchChildFoldersAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionFetchChildFoldersAsyncData, _data_);
}

void
geary_imap_account_session_fetch_child_folders_async (GearyImapAccountSession* self,
                                                      GearyFolderPath* parent,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyImapAccountSessionFetchChildFoldersAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyFolderPath* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (parent));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionFetchChildFoldersAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_fetch_child_folders_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_account_session_fetch_child_folders_async_co (_data_);
}

GeeList*
geary_imap_account_session_fetch_child_folders_finish (GearyImapAccountSession* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GeeList* result;
	GearyImapAccountSessionFetchChildFoldersAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a list of children of the given folder.
     *
     * This method will perform a pipe-lined IMAP SELECT for all
     * folders found, and hence should be used with care.
     */
static void
geary_imap_account_session_fetch_child_folders_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	GearyImapAccountSessionFetchChildFoldersAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_fetch_child_folders_async_co (_data_);
}

static gboolean
geary_imap_account_session_fetch_child_folders_async_co (GearyImapAccountSessionFetchChildFoldersAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_session_object_get_session (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject), &_data_->_inner_error0_);
	_data_->session = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = gee_array_list_new (GEARY_IMAP_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->children = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_LIST, GeeList);
	_data_->_tmp2_ = _data_->session;
	_data_->_state_ = 1;
	geary_imap_account_session_send_list_async (_data_->self, _data_->_tmp2_, _data_->parent, TRUE, _data_->cancellable, geary_imap_account_session_fetch_child_folders_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = geary_imap_account_session_send_list_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->mailboxes = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->session);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->mailboxes;
	_data_->_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_ == 0) {
		_data_->result = _data_->children;
		_g_object_unref0 (_data_->mailboxes);
		_g_object_unref0 (_data_->session);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = gee_hash_map_new (GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_IMAP_TYPE_MAILBOX_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->info_map = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEE_TYPE_MAP, GeeMap);
	_data_->_tmp8_ = gee_hash_map_new (GEARY_IMAP_TYPE_STATUS_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->cmd_map = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEE_TYPE_MAP, GeeMap);
	{
		_data_->_tmp9_ = _data_->mailboxes;
		_data_->_mailbox_info_list = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->_mailbox_info_list;
		_data_->_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_mailbox_info_size = _data_->_tmp12_;
		_data_->_mailbox_info_index = -1;
		while (TRUE) {
			_data_->_mailbox_info_index = _data_->_mailbox_info_index + 1;
			_data_->_tmp13_ = _data_->_mailbox_info_index;
			_data_->_tmp14_ = _data_->_mailbox_info_size;
			if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
				break;
			}
			_data_->_tmp15_ = _data_->_mailbox_info_list;
			_data_->_tmp16_ = gee_list_get (_data_->_tmp15_, _data_->_mailbox_info_index);
			_data_->mailbox_info = (GearyImapMailboxInformation*) _data_->_tmp16_;
			_data_->_tmp17_ = _data_->mailbox_info;
			_data_->_tmp18_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = geary_imap_mailbox_attributes_get_is_no_select (_data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			if (!_data_->_tmp21_) {
				_data_->_tmp22_ = _data_->info_map;
				_data_->_tmp23_ = _data_->mailbox_info;
				_data_->_tmp24_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = _data_->mailbox_info;
				gee_map_set (_data_->_tmp22_, _data_->_tmp25_, _data_->_tmp26_);
				_data_->_tmp27_ = _data_->cmd_map;
				_data_->_tmp28_ = _data_->mailbox_info;
				_data_->_tmp29_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = 0;
				_data_->_tmp32_ = geary_imap_status_data_type_all (&_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp33__length1 = _data_->_tmp31_;
				_data_->_tmp34_ = geary_imap_status_command_new (_data_->_tmp30_, _data_->_tmp33_, _data_->_tmp31_, _data_->cancellable);
				_data_->_tmp35_ = _data_->_tmp34_;
				_data_->_tmp36_ = _data_->mailbox_info;
				_data_->_tmp37_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp36_);
				_data_->_tmp38_ = _data_->_tmp37_;
				gee_map_set (_data_->_tmp27_, _data_->_tmp35_, _data_->_tmp38_);
				_g_object_unref0 (_data_->_tmp35_);
				_data_->_tmp33_ = (g_free (_data_->_tmp33_), NULL);
			} else {
				_data_->_tmp39_ = _data_->session;
				_data_->_tmp40_ = _data_->self->priv->root;
				_data_->_tmp41_ = _data_->mailbox_info;
				_data_->_tmp42_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = geary_imap_client_session_get_path_for_mailbox (_data_->_tmp39_, _data_->_tmp40_, _data_->_tmp43_, &_data_->_inner_error0_);
				_data_->path = _data_->_tmp44_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->mailbox_info);
					_g_object_unref0 (_data_->cmd_map);
					_g_object_unref0 (_data_->info_map);
					_g_object_unref0 (_data_->mailboxes);
					_g_object_unref0 (_data_->children);
					_g_object_unref0 (_data_->session);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp45_ = _data_->self->priv->folders;
				_data_->_tmp46_ = _data_->path;
				_data_->_tmp47_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp46_);
				_data_->child = (GearyImapFolder*) _data_->_tmp47_;
				_data_->_tmp48_ = _data_->child;
				if (_data_->_tmp48_ == NULL) {
					_data_->_tmp49_ = _data_->path;
					_data_->_tmp50_ = _data_->mailbox_info;
					_data_->_tmp51_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp50_);
					_data_->_tmp52_ = _data_->_tmp51_;
					_data_->_tmp53_ = geary_imap_folder_properties_new_not_selectable (_data_->_tmp52_);
					_data_->_tmp54_ = _data_->_tmp53_;
					_data_->_tmp55_ = geary_imap_folder_new (_data_->_tmp49_, _data_->_tmp54_);
					_g_object_unref0 (_data_->child);
					_data_->child = _data_->_tmp55_;
					_g_object_unref0 (_data_->_tmp54_);
					_data_->_tmp56_ = _data_->self->priv->folders;
					_data_->_tmp57_ = _data_->path;
					_data_->_tmp58_ = _data_->child;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp56_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp57_, _data_->_tmp58_);
				}
				_data_->_tmp59_ = _data_->children;
				_data_->_tmp60_ = _data_->child;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp59_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp60_);
				_g_object_unref0 (_data_->child);
				_g_object_unref0 (_data_->path);
			}
			_g_object_unref0 (_data_->mailbox_info);
		}
	}
	_data_->_tmp61_ = _data_->cmd_map;
	_data_->_tmp62_ = gee_map_get_is_empty (_data_->_tmp61_);
	_data_->_tmp63_ = _data_->_tmp62_;
	if (!_data_->_tmp63_) {
		_data_->_tmp64_ = gee_array_list_new (GEARY_IMAP_TYPE_STATUS_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->status_results = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp64_, GEE_TYPE_LIST, GeeList);
		_data_->_tmp65_ = _data_->session;
		_data_->_tmp66_ = _data_->cmd_map;
		_data_->_tmp67_ = gee_map_get_keys (_data_->_tmp66_);
		_data_->_tmp68_ = _data_->_tmp67_;
		_data_->_tmp69_ = _data_->_tmp68_;
		_data_->_tmp70_ = _data_->status_results;
		_data_->_state_ = 2;
		geary_imap_account_session_send_multiple_async (_data_->self, _data_->_tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp69_, GEE_TYPE_COLLECTION, GeeCollection), NULL, _data_->_tmp70_, _data_->cancellable, geary_imap_account_session_fetch_child_folders_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp71_ = geary_imap_account_session_send_multiple_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp72_ = _data_->_tmp71_;
		_g_object_unref0 (_data_->_tmp69_);
		_data_->responses = _data_->_tmp72_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->status_results);
			_g_object_unref0 (_data_->cmd_map);
			_g_object_unref0 (_data_->info_map);
			_g_object_unref0 (_data_->mailboxes);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->session);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp73_ = _data_->responses;
			_data_->_tmp74_ = gee_map_get_keys (_data_->_tmp73_);
			_data_->_tmp75_ = _data_->_tmp74_;
			_data_->_tmp76_ = _data_->_tmp75_;
			_data_->_tmp77_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp76_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_tmp78_ = _data_->_tmp77_;
			_g_object_unref0 (_data_->_tmp76_);
			_data_->_cmd_it = _data_->_tmp78_;
			while (TRUE) {
				_data_->_tmp79_ = _data_->_cmd_it;
				if (!gee_iterator_next (_data_->_tmp79_)) {
					break;
				}
				_data_->_tmp80_ = _data_->_cmd_it;
				_data_->_tmp81_ = gee_iterator_get (_data_->_tmp80_);
				_data_->cmd = (GearyImapCommand*) _data_->_tmp81_;
				_data_->_tmp82_ = _data_->cmd;
				_data_->_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp82_, GEARY_IMAP_TYPE_STATUS_COMMAND, GearyImapStatusCommand));
				_data_->status_cmd = _data_->_tmp83_;
				_data_->_tmp84_ = _data_->responses;
				_data_->_tmp85_ = _data_->cmd;
				_data_->_tmp86_ = gee_map_get (_data_->_tmp84_, _data_->_tmp85_);
				_data_->response = (GearyImapStatusResponse*) _data_->_tmp86_;
				_data_->_tmp87_ = _data_->cmd_map;
				_data_->_tmp88_ = _data_->status_cmd;
				_data_->_tmp89_ = gee_map_get (_data_->_tmp87_, _data_->_tmp88_);
				_data_->mailbox = (GearyImapMailboxSpecifier*) _data_->_tmp89_;
				_data_->_tmp90_ = _data_->info_map;
				_data_->_tmp91_ = _data_->mailbox;
				_data_->_tmp92_ = gee_map_get (_data_->_tmp90_, _data_->_tmp91_);
				_data_->_vala1_mailbox_info = (GearyImapMailboxInformation*) _data_->_tmp92_;
				_data_->_tmp93_ = _data_->response;
				_data_->_tmp94_ = geary_imap_status_response_get_status (_data_->_tmp93_);
				_data_->_tmp95_ = _data_->_tmp94_;
				if (_data_->_tmp95_ != GEARY_IMAP_STATUS_OK) {
					_data_->_tmp96_ = _data_->mailbox;
					_data_->_tmp97_ = geary_imap_mailbox_specifier_to_string (_data_->_tmp96_);
					_data_->_tmp98_ = _data_->_tmp97_;
					_data_->_tmp99_ = _data_->response;
					_data_->_tmp100_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp99_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
					_data_->_tmp101_ = _data_->_tmp100_;
					geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to get STATUS of %s: %s", _data_->_tmp98_, _data_->_tmp101_);
					_g_free0 (_data_->_tmp101_);
					_g_free0 (_data_->_tmp98_);
					_data_->_tmp102_ = _data_->cmd;
					_data_->_tmp103_ = geary_imap_command_to_string (_data_->_tmp102_);
					_data_->_tmp104_ = _data_->_tmp103_;
					geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "STATUS command: %s", _data_->_tmp104_);
					_g_free0 (_data_->_tmp104_);
					_g_object_unref0 (_data_->_vala1_mailbox_info);
					_g_object_unref0 (_data_->mailbox);
					_g_object_unref0 (_data_->response);
					_g_object_unref0 (_data_->status_cmd);
					_g_object_unref0 (_data_->cmd);
					continue;
				}
				_data_->status = NULL;
				{
					_data_->_tmp105_ = _data_->status_results;
					_data_->_status_data_list = _data_->_tmp105_;
					_data_->_tmp106_ = _data_->_status_data_list;
					_data_->_tmp107_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp106_, GEE_TYPE_COLLECTION, GeeCollection));
					_data_->_tmp108_ = _data_->_tmp107_;
					_data_->_status_data_size = _data_->_tmp108_;
					_data_->_status_data_index = -1;
					while (TRUE) {
						_data_->_status_data_index = _data_->_status_data_index + 1;
						_data_->_tmp109_ = _data_->_status_data_index;
						_data_->_tmp110_ = _data_->_status_data_size;
						if (!(_data_->_tmp109_ < _data_->_tmp110_)) {
							break;
						}
						_data_->_tmp111_ = _data_->_status_data_list;
						_data_->_tmp112_ = gee_list_get (_data_->_tmp111_, _data_->_status_data_index);
						_data_->status_data = (GearyImapStatusData*) _data_->_tmp112_;
						_data_->_tmp113_ = _data_->status_data;
						_data_->_tmp114_ = geary_imap_status_data_get_mailbox (_data_->_tmp113_);
						_data_->_tmp115_ = _data_->_tmp114_;
						_data_->_tmp116_ = _data_->mailbox;
						if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp115_, GEE_TYPE_HASHABLE, GeeHashable), _data_->_tmp116_)) {
							_data_->_tmp117_ = _data_->status_data;
							_data_->_tmp118_ = _g_object_ref0 (_data_->_tmp117_);
							_g_object_unref0 (_data_->status);
							_data_->status = _data_->_tmp118_;
							_g_object_unref0 (_data_->status_data);
							break;
						}
						_g_object_unref0 (_data_->status_data);
					}
				}
				_data_->_tmp119_ = _data_->status;
				if (_data_->_tmp119_ == NULL) {
					_data_->_tmp120_ = _data_->mailbox;
					_data_->_tmp121_ = geary_imap_mailbox_specifier_to_string (_data_->_tmp120_);
					_data_->_tmp122_ = _data_->_tmp121_;
					geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to get STATUS of %s: not returned from server", _data_->_tmp122_);
					_g_free0 (_data_->_tmp122_);
					_g_object_unref0 (_data_->status);
					_g_object_unref0 (_data_->_vala1_mailbox_info);
					_g_object_unref0 (_data_->mailbox);
					_g_object_unref0 (_data_->response);
					_g_object_unref0 (_data_->status_cmd);
					_g_object_unref0 (_data_->cmd);
					continue;
				}
				_data_->_tmp123_ = _data_->status_results;
				_data_->_tmp124_ = _data_->status;
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp123_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp124_);
				_data_->_tmp125_ = _data_->session;
				_data_->_tmp126_ = _data_->self->priv->root;
				_data_->_tmp127_ = _data_->_vala1_mailbox_info;
				_data_->_tmp128_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp127_);
				_data_->_tmp129_ = _data_->_tmp128_;
				_data_->_tmp130_ = geary_imap_client_session_get_path_for_mailbox (_data_->_tmp125_, _data_->_tmp126_, _data_->_tmp129_, &_data_->_inner_error0_);
				_data_->child_path = _data_->_tmp130_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->status);
					_g_object_unref0 (_data_->_vala1_mailbox_info);
					_g_object_unref0 (_data_->mailbox);
					_g_object_unref0 (_data_->response);
					_g_object_unref0 (_data_->status_cmd);
					_g_object_unref0 (_data_->cmd);
					_g_object_unref0 (_data_->_cmd_it);
					_g_object_unref0 (_data_->responses);
					_g_object_unref0 (_data_->status_results);
					_g_object_unref0 (_data_->cmd_map);
					_g_object_unref0 (_data_->info_map);
					_g_object_unref0 (_data_->mailboxes);
					_g_object_unref0 (_data_->children);
					_g_object_unref0 (_data_->session);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp131_ = _data_->self->priv->folders;
				_data_->_tmp132_ = _data_->child_path;
				_data_->_tmp133_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp131_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp132_);
				_data_->_vala1_child = (GearyImapFolder*) _data_->_tmp133_;
				_data_->_tmp134_ = _data_->_vala1_child;
				if (_data_->_tmp134_ != NULL) {
					_data_->_tmp135_ = _data_->_vala1_child;
					_data_->_tmp136_ = geary_imap_folder_get_properties (_data_->_tmp135_);
					_data_->_tmp137_ = _data_->_tmp136_;
					_data_->_tmp138_ = _data_->status;
					geary_imap_folder_properties_update_status (_data_->_tmp137_, _data_->_tmp138_);
				} else {
					_data_->_tmp139_ = _data_->child_path;
					_data_->_tmp140_ = _data_->_vala1_mailbox_info;
					_data_->_tmp141_ = geary_imap_mailbox_information_get_attrs (_data_->_tmp140_);
					_data_->_tmp142_ = _data_->_tmp141_;
					_data_->_tmp143_ = _data_->status;
					_data_->_tmp144_ = _data_->session;
					_data_->_tmp145_ = geary_imap_client_session_get_capabilities (_data_->_tmp144_);
					_data_->_tmp146_ = _data_->_tmp145_;
					_data_->_tmp147_ = geary_imap_folder_properties_new_selectable (_data_->_tmp142_, _data_->_tmp143_, _data_->_tmp146_);
					_data_->_tmp148_ = _data_->_tmp147_;
					_data_->_tmp149_ = geary_imap_folder_new (_data_->_tmp139_, _data_->_tmp148_);
					_g_object_unref0 (_data_->_vala1_child);
					_data_->_vala1_child = _data_->_tmp149_;
					_g_object_unref0 (_data_->_tmp148_);
					_data_->_tmp150_ = _data_->self->priv->folders;
					_data_->_tmp151_ = _data_->child_path;
					_data_->_tmp152_ = _data_->_vala1_child;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp150_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp151_, _data_->_tmp152_);
				}
				_data_->_tmp153_ = _data_->children;
				_data_->_tmp154_ = _data_->_vala1_child;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp153_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp154_);
				_g_object_unref0 (_data_->_vala1_child);
				_g_object_unref0 (_data_->child_path);
				_g_object_unref0 (_data_->status);
				_g_object_unref0 (_data_->_vala1_mailbox_info);
				_g_object_unref0 (_data_->mailbox);
				_g_object_unref0 (_data_->response);
				_g_object_unref0 (_data_->status_cmd);
				_g_object_unref0 (_data_->cmd);
			}
			_g_object_unref0 (_data_->_cmd_it);
		}
		_data_->_tmp155_ = _data_->status_results;
		_data_->_tmp156_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp155_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp157_ = _data_->_tmp156_;
		if (_data_->_tmp157_ > 0) {
			_data_->_tmp158_ = _data_->status_results;
			_data_->_tmp159_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp158_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp160_ = _data_->_tmp159_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%d STATUS results leftover", _data_->_tmp160_);
		}
		_g_object_unref0 (_data_->responses);
		_g_object_unref0 (_data_->status_results);
	}
	_data_->result = _data_->children;
	_g_object_unref0 (_data_->cmd_map);
	_g_object_unref0 (_data_->info_map);
	_g_object_unref0 (_data_->mailboxes);
	_g_object_unref0 (_data_->session);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_account_session_folders_removed (GearyImapAccountSession* self,
                                            GeeCollection* paths)
{
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (paths, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _path_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (paths, GEE_TYPE_ITERABLE, GeeIterable));
		_path_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyFolderPath* path = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashMap* _tmp4_;
			GearyFolderPath* _tmp5_;
			_tmp1_ = _path_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _path_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			path = (GearyFolderPath*) _tmp3_;
			_tmp4_ = self->priv->folders;
			_tmp5_ = path;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_)) {
				GeeHashMap* _tmp6_;
				GearyFolderPath* _tmp7_;
				_tmp6_ = self->priv->folders;
				_tmp7_ = path;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_, NULL);
			}
			_g_object_unref0 (path);
		}
		_g_object_unref0 (_path_it);
	}
}

/** {@inheritDoc} */
static GearyImapClientSession*
geary_imap_account_session_real_close (GearyImapSessionObject* base)
{
	GearyImapAccountSession * self;
	GearyImapClientSession* old_session = NULL;
	GearyImapClientSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GearyImapClientSession* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSession);
	_tmp0_ = GEARY_IMAP_SESSION_OBJECT_CLASS (geary_imap_account_session_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject));
	old_session = _tmp0_;
	_tmp1_ = old_session;
	if (_tmp1_ != NULL) {
		GearyImapClientSession* _tmp2_;
		guint _tmp3_;
		GearyImapClientSession* _tmp4_;
		guint _tmp5_;
		_tmp2_ = old_session;
		g_signal_parse_name ("list", GEARY_IMAP_TYPE_CLIENT_SESSION, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _geary_imap_account_session_on_list_data_geary_imap_client_session_list, self);
		_tmp4_ = old_session;
		g_signal_parse_name ("status", GEARY_IMAP_TYPE_CLIENT_SESSION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _geary_imap_account_session_on_status_data_geary_imap_client_session_status, self);
	}
	result = old_session;
	return result;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_account_session_real_to_logging_state (GearyImapSessionObject* base)
{
	GearyImapAccountSession * self;
	GearyLoggingState* _tmp0_;
	GearyLoggingState* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyImapFolderRoot* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GearyLoggingState* _tmp7_;
	GearyLoggingState* _tmp8_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSession);
	_tmp0_ = GEARY_IMAP_SESSION_OBJECT_CLASS (geary_imap_account_session_parent_class)->to_logging_state (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_logging_state_format_message (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->root;
	_tmp5_ = geary_folder_path_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_TYPE_FOLDER_PATH, GearyFolderPath));
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s, folder root: %s", _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_geary_logging_state_unref0 (_tmp1_);
	result = _tmp8_;
	return result;
}

static void
geary_imap_account_session_send_list_async_data_free (gpointer _data)
{
	GearyImapAccountSessionSendListAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionSendListAsyncData, _data_);
}

static void
geary_imap_account_session_send_list_async (GearyImapAccountSession* self,
                                            GearyImapClientSession* session,
                                            GearyFolderPath* folder,
                                            gboolean list_children,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyImapAccountSessionSendListAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GearyFolderPath* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (folder));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionSendListAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_send_list_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	_tmp2_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp2_;
	_data_->list_children = list_children;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_imap_account_session_send_list_async_co (_data_);
}

static GeeList*
geary_imap_account_session_send_list_finish (GearyImapAccountSession* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GeeList* result;
	GearyImapAccountSessionSendListAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_account_session_send_list_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearyImapAccountSessionSendListAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_send_list_async_co (_data_);
}

static gboolean
geary_imap_account_session_send_list_async_co (GearyImapAccountSessionSendListAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->return_param = NULL;
	_data_->use_xlist = FALSE;
	_data_->_tmp0_ = geary_imap_client_session_get_capabilities (_data_->session);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (geary_imap_capabilities_supports_special_use (_data_->_tmp1_)) {
		_data_->_tmp2_ = geary_imap_list_return_parameter_new ();
		_g_object_unref0 (_data_->return_param);
		_data_->return_param = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->return_param;
		geary_imap_list_return_parameter_add_special_use (_data_->_tmp3_);
	} else {
		_data_->_tmp4_ = geary_imap_client_session_get_capabilities (_data_->session);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->use_xlist = geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_IMAP_CAPABILITIES_XLIST);
	}
	_data_->_tmp6_ = geary_folder_path_get_is_root (_data_->folder);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = geary_imap_mailbox_specifier_new ("%");
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->return_param;
		_data_->_tmp11_ = geary_imap_list_command_new_wildcarded ("", _data_->_tmp9_, _data_->use_xlist, _data_->_tmp10_, _data_->cancellable);
		_g_object_unref0 (_data_->cmd);
		_data_->cmd = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp9_);
	} else {
		_data_->_tmp13_ = geary_imap_client_session_get_mailbox_for_path (_data_->session, _data_->folder, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->cmd);
			_g_object_unref0 (_data_->return_param);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = geary_imap_mailbox_specifier_get_name (_data_->_tmp12_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
		_data_->specifier = _data_->_tmp16_;
		if (_data_->list_children) {
			_data_->_tmp17_ = geary_imap_client_session_get_delimiter_for_path (_data_->session, _data_->folder, &_data_->_inner_error0_);
			_data_->delim = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->specifier);
				_g_object_unref0 (_data_->_tmp12_);
				_g_object_unref0 (_data_->cmd);
				_g_object_unref0 (_data_->return_param);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp18_ = _data_->delim;
			if (_data_->_tmp18_ == NULL) {
				_data_->_tmp19_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Cannot list children of namespace with no delimiter");
				_data_->_inner_error0_ = _data_->_tmp19_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->delim);
				_g_free0 (_data_->specifier);
				_g_object_unref0 (_data_->_tmp12_);
				_g_object_unref0 (_data_->cmd);
				_g_object_unref0 (_data_->return_param);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp20_ = _data_->specifier;
			_data_->_tmp21_ = _data_->delim;
			_data_->_tmp22_ = g_strconcat (_data_->_tmp20_, _data_->_tmp21_, NULL);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = g_strconcat (_data_->_tmp23_, "%", NULL);
			_g_free0 (_data_->specifier);
			_data_->specifier = _data_->_tmp24_;
			_g_free0 (_data_->_tmp23_);
			_g_free0 (_data_->delim);
		}
		_data_->_tmp25_ = _data_->specifier;
		_data_->_tmp26_ = geary_imap_mailbox_specifier_new (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = _data_->return_param;
		_data_->_tmp29_ = geary_imap_list_command_new (_data_->_tmp27_, _data_->use_xlist, _data_->_tmp28_, _data_->cancellable);
		_g_object_unref0 (_data_->cmd);
		_data_->cmd = _data_->_tmp29_;
		_g_object_unref0 (_data_->_tmp27_);
		_g_free0 (_data_->specifier);
		_g_object_unref0 (_data_->_tmp12_);
	}
	_data_->_tmp30_ = gee_array_list_new (GEARY_IMAP_TYPE_MAILBOX_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->list_results = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEE_TYPE_LIST, GeeList);
	_data_->_tmp31_ = _data_->cmd;
	_data_->_tmp32_ = _data_->list_results;
	_data_->_state_ = 1;
	geary_imap_account_session_send_command_async (_data_->self, _data_->session, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->_tmp32_, NULL, _data_->cancellable, geary_imap_account_session_send_list_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp33_ = geary_imap_account_session_send_command_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp33_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->list_results);
		_g_object_unref0 (_data_->cmd);
		_g_object_unref0 (_data_->return_param);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->response;
	_data_->_tmp35_ = geary_imap_status_response_get_status (_data_->_tmp34_);
	_data_->_tmp36_ = _data_->_tmp35_;
	if (_data_->_tmp36_ != GEARY_IMAP_STATUS_OK) {
		if (_data_->folder != NULL) {
			_data_->_tmp38_ = geary_folder_path_to_string (_data_->folder);
			_g_free0 (_data_->_tmp37_);
			_data_->_tmp37_ = _data_->_tmp38_;
		} else {
			_data_->_tmp39_ = g_strdup ("root");
			_g_free0 (_data_->_tmp37_);
			_data_->_tmp37_ = _data_->_tmp39_;
		}
		_data_->_tmp40_ = _data_->response;
		_data_->_tmp41_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "Unable to list children of %s: %s", _data_->_tmp37_, _data_->_tmp42_);
		_data_->_tmp44_ = _data_->_tmp43_;
		_g_free0 (_data_->_tmp42_);
		_data_->_inner_error0_ = _data_->_tmp44_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_tmp37_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->list_results);
		_g_object_unref0 (_data_->cmd);
		_g_object_unref0 (_data_->return_param);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->folder != NULL) {
		_data_->_tmp45_ = _data_->list_children;
	} else {
		_data_->_tmp45_ = FALSE;
	}
	if (_data_->_tmp45_) {
		_data_->_tmp46_ = _data_->list_results;
		_data_->_tmp47_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->iter = _data_->_tmp47_;
		while (TRUE) {
			_data_->_tmp48_ = _data_->iter;
			if (!gee_iterator_next (_data_->_tmp48_)) {
				break;
			}
			_data_->_tmp49_ = _data_->self->priv->root;
			_data_->_tmp50_ = _data_->iter;
			_data_->_tmp51_ = gee_iterator_get (_data_->_tmp50_);
			_data_->_tmp52_ = (GearyImapMailboxInformation*) _data_->_tmp51_;
			_data_->_tmp53_ = geary_imap_mailbox_information_get_mailbox (_data_->_tmp52_);
			_data_->_tmp54_ = _data_->_tmp53_;
			_data_->_tmp55_ = geary_imap_client_session_get_path_for_mailbox (_data_->session, _data_->_tmp49_, _data_->_tmp54_, &_data_->_inner_error0_);
			_data_->_tmp56_ = _data_->_tmp55_;
			_g_object_unref0 (_data_->_tmp52_);
			_data_->list_path = _data_->_tmp56_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->iter);
				_g_object_unref0 (_data_->response);
				_g_object_unref0 (_data_->list_results);
				_g_object_unref0 (_data_->cmd);
				_g_object_unref0 (_data_->return_param);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp57_ = _data_->list_path;
			if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp57_, GEE_TYPE_HASHABLE, GeeHashable), _data_->folder)) {
				_data_->_tmp58_ = _data_->list_path;
				_data_->_tmp59_ = geary_folder_path_to_string (_data_->_tmp58_);
				_data_->_tmp60_ = _data_->_tmp59_;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Removing parent from LIST results: %s", _data_->_tmp60_);
				_g_free0 (_data_->_tmp60_);
				_data_->_tmp61_ = _data_->iter;
				gee_iterator_remove (_data_->_tmp61_);
			}
			_g_object_unref0 (_data_->list_path);
		}
		_g_object_unref0 (_data_->iter);
	}
	_data_->result = _data_->list_results;
	_g_object_unref0 (_data_->response);
	_g_object_unref0 (_data_->cmd);
	_g_object_unref0 (_data_->return_param);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_send_status_async_data_free (gpointer _data)
{
	GearyImapAccountSessionSendStatusAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionSendStatusAsyncData, _data_);
}

static void
geary_imap_account_session_send_status_async (GearyImapAccountSession* self,
                                              GearyImapClientSession* session,
                                              GearyImapMailboxSpecifier* mailbox,
                                              GearyImapStatusDataType* status_types,
                                              gint status_types_length1,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyImapAccountSessionSendStatusAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GearyImapMailboxSpecifier* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionSendStatusAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_send_status_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	_tmp2_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp2_;
	_data_->status_types = status_types;
	_data_->status_types_length1 = status_types_length1;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_imap_account_session_send_status_async_co (_data_);
}

static GearyImapStatusData*
geary_imap_account_session_send_status_finish (GearyImapAccountSession* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GearyImapStatusData* result;
	GearyImapAccountSessionSendStatusAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_account_session_send_status_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearyImapAccountSessionSendStatusAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_send_status_async_co (_data_);
}

static gboolean
geary_imap_account_session_send_status_async_co (GearyImapAccountSessionSendStatusAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_STATUS_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->status_results = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_LIST, GeeList);
	_data_->_tmp1_ = geary_imap_status_command_new (_data_->mailbox, _data_->status_types, _data_->status_types_length1, _data_->cancellable);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->status_results;
	_data_->_state_ = 1;
	geary_imap_account_session_send_command_async (_data_->self, _data_->session, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), NULL, _data_->_tmp3_, _data_->cancellable, geary_imap_account_session_send_status_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = geary_imap_account_session_send_command_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->response = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->status_results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->response;
	_data_->_tmp7_ = geary_imap_status_response_get_status (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	if (_data_->_tmp8_ != GEARY_IMAP_STATUS_OK) {
		_data_->_tmp9_ = geary_imap_mailbox_specifier_to_string (_data_->mailbox);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->response;
		_data_->_tmp12_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "Error fetching \"%s\" STATUS: %s", _data_->_tmp10_, _data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_free0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp10_);
		_data_->_inner_error0_ = _data_->_tmp15_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->status_results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->status_results;
	_data_->_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp18_ = _data_->_tmp17_;
	if (_data_->_tmp18_ != 1) {
		_data_->_tmp19_ = _data_->status_results;
		_data_->_tmp20_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = geary_imap_mailbox_specifier_to_string (_data_->mailbox);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = _data_->response;
		_data_->_tmp25_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Invalid result count (%d) \"%s\" STATUS: %s", _data_->_tmp21_, _data_->_tmp23_, _data_->_tmp26_);
		_data_->_tmp28_ = _data_->_tmp27_;
		_g_free0 (_data_->_tmp26_);
		_g_free0 (_data_->_tmp23_);
		_data_->_inner_error0_ = _data_->_tmp28_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->status_results);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = _data_->status_results;
	_data_->_tmp30_ = gee_list_get (_data_->_tmp29_, 0);
	_data_->result = (GearyImapStatusData*) _data_->_tmp30_;
	_g_object_unref0 (_data_->response);
	_g_object_unref0 (_data_->status_results);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_send_command_async_data_free (gpointer _data)
{
	GearyImapAccountSessionSendCommandAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->cmd);
	_g_object_unref0 (_data_->list_results);
	_g_object_unref0 (_data_->status_results);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionSendCommandAsyncData, _data_);
}

static void
geary_imap_account_session_send_command_async (GearyImapAccountSession* self,
                                               GearyImapClientSession* session,
                                               GearyImapCommand* cmd,
                                               GeeList* list_results,
                                               GeeList* status_results,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearyImapAccountSessionSendCommandAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GearyImapCommand* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GCancellable* _tmp5_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (cmd));
	g_return_if_fail ((list_results == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (list_results, GEE_TYPE_LIST));
	g_return_if_fail ((status_results == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (status_results, GEE_TYPE_LIST));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionSendCommandAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_send_command_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	_tmp2_ = _g_object_ref0 (cmd);
	_g_object_unref0 (_data_->cmd);
	_data_->cmd = _tmp2_;
	_tmp3_ = _g_object_ref0 (list_results);
	_g_object_unref0 (_data_->list_results);
	_data_->list_results = _tmp3_;
	_tmp4_ = _g_object_ref0 (status_results);
	_g_object_unref0 (_data_->status_results);
	_data_->status_results = _tmp4_;
	_tmp5_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	geary_imap_account_session_send_command_async_co (_data_);
}

static GearyImapStatusResponse*
geary_imap_account_session_send_command_finish (GearyImapAccountSession* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearyImapStatusResponse* result;
	GearyImapAccountSessionSendCommandAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_account_session_send_command_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearyImapAccountSessionSendCommandAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_send_command_async_co (_data_);
}

static gboolean
geary_imap_account_session_send_command_async_co (GearyImapAccountSessionSendCommandAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_iterate (GEARY_IMAP_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->cmd, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_iterable_to_array_list (_data_->_tmp1_, NULL, NULL, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	geary_imap_account_session_send_multiple_async (_data_->self, _data_->session, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _data_->list_results, _data_->status_results, _data_->cancellable, geary_imap_account_session_send_command_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = geary_imap_account_session_send_multiple_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp1_);
	_data_->responses = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->responses;
	_data_->_tmp7_ = gee_map_get_values (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = geary_collection_first (GEARY_IMAP_TYPE_STATUS_RESPONSE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp9_);
	_data_->_tmp11_ = (GearyImapStatusResponse*) _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp9_);
	_data_->response = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->response;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp13_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "No status response received from server");
		_data_->_inner_error0_ = _data_->_tmp13_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->responses);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->response;
	_g_object_unref0 (_data_->responses);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_send_multiple_async_data_free (gpointer _data)
{
	GearyImapAccountSessionSendMultipleAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->cmds);
	_g_object_unref0 (_data_->list_results);
	_g_object_unref0 (_data_->status_results);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAccountSessionSendMultipleAsyncData, _data_);
}

static void
geary_imap_account_session_send_multiple_async (GearyImapAccountSession* self,
                                                GearyImapClientSession* session,
                                                GeeCollection* cmds,
                                                GeeList* list_results,
                                                GeeList* status_results,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyImapAccountSessionSendMultipleAsyncData* _data_;
	GearyImapAccountSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GeeCollection* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GCancellable* _tmp5_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cmds, GEE_TYPE_COLLECTION));
	g_return_if_fail ((list_results == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (list_results, GEE_TYPE_LIST));
	g_return_if_fail ((status_results == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (status_results, GEE_TYPE_LIST));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapAccountSessionSendMultipleAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_account_session_send_multiple_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	_tmp2_ = _g_object_ref0 (cmds);
	_g_object_unref0 (_data_->cmds);
	_data_->cmds = _tmp2_;
	_tmp3_ = _g_object_ref0 (list_results);
	_g_object_unref0 (_data_->list_results);
	_data_->list_results = _tmp3_;
	_tmp4_ = _g_object_ref0 (status_results);
	_g_object_unref0 (_data_->status_results);
	_data_->status_results = _tmp4_;
	_tmp5_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	geary_imap_account_session_send_multiple_async_co (_data_);
}

static GeeMap*
geary_imap_account_session_send_multiple_finish (GearyImapAccountSession* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GeeMap* result;
	GearyImapAccountSessionSendMultipleAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_account_session_send_multiple_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearyImapAccountSessionSendMultipleAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_account_session_send_multiple_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_imap_account_session_send_multiple_async_co (GearyImapAccountSessionSendMultipleAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->responses = NULL;
	_data_->_tmp0_ = _data_->self->priv->cmd_mutex;
	_data_->_state_ = 1;
	geary_nonblocking_mutex_claim_async (_data_->_tmp0_, _data_->cancellable, geary_imap_account_session_send_multiple_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->token = geary_nonblocking_mutex_claim_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->responses);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (_data_->list_results);
	_g_object_unref0 (_data_->self->priv->list_collector);
	_data_->self->priv->list_collector = _data_->_tmp1_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->status_results);
	_g_object_unref0 (_data_->self->priv->status_collector);
	_data_->self->priv->status_collector = _data_->_tmp2_;
	_data_->cmd_err = NULL;
	{
		_data_->_state_ = 2;
		geary_imap_client_session_send_multiple_commands_async (_data_->session, _data_->cmds, _data_->cancellable, geary_imap_account_session_send_multiple_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = geary_imap_client_session_send_multiple_commands_finish (_data_->session, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->responses);
		_data_->responses = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
		_g_error_free0 (_data_->cmd_err);
		_data_->cmd_err = _data_->_tmp7_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->cmd_err);
		_g_object_unref0 (_data_->responses);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->list_collector);
	_data_->self->priv->list_collector = NULL;
	_g_object_unref0 (_data_->self->priv->status_collector);
	_data_->self->priv->status_collector = NULL;
	_data_->_tmp8_ = _data_->self->priv->cmd_mutex;
	geary_nonblocking_mutex_release (_data_->_tmp8_, &_data_->token, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->cmd_err);
		_g_object_unref0 (_data_->responses);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->cmd_err;
	if (_data_->_tmp9_ != NULL) {
		_data_->_tmp10_ = _data_->cmd_err;
		_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
		_data_->_inner_error0_ = _data_->_tmp11_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->cmd_err);
		_g_object_unref0 (_data_->responses);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->responses;
	_g_error_free0 (_data_->cmd_err);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_account_session_throw_not_found (GearyImapAccountSession* self,
                                            GearyFolderPath* path,
                                            GError** error)
{
	gchar* _tmp0_ = NULL;
	GError* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail ((path == NULL) || GEARY_IS_FOLDER_PATH (path));
	if (path != NULL) {
		gchar* _tmp1_;
		_tmp1_ = geary_folder_path_to_string (path);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("[root]");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Folder not found: %s", _tmp0_);
	_inner_error0_ = _tmp3_;
	if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	} else {
		_g_free0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
geary_imap_account_session_on_list_data (GearyImapAccountSession* self,
                                         GearyImapMailboxInformation* mailbox_info)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (mailbox_info));
	_tmp0_ = self->priv->list_collector;
	if (_tmp0_ != NULL) {
		GeeList* _tmp1_;
		_tmp1_ = self->priv->list_collector;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), mailbox_info);
	}
}

static void
geary_imap_account_session_on_status_data (GearyImapAccountSession* self,
                                           GearyImapStatusData* status_data)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_ACCOUNT_SESSION (self));
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (status_data));
	_tmp0_ = self->priv->status_collector;
	if (_tmp0_ != NULL) {
		GeeList* _tmp1_;
		_tmp1_ = self->priv->status_collector;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), status_data);
	}
}

static void
geary_imap_account_session_class_init (GearyImapAccountSessionClass * klass,
                                       gpointer klass_data)
{
	geary_imap_account_session_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapAccountSession_private_offset);
	((GearyImapSessionObjectClass *) klass)->close = (GearyImapClientSession* (*) (GearyImapSessionObject*)) geary_imap_account_session_real_close;
	((GearyImapSessionObjectClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyImapSessionObject*)) geary_imap_account_session_real_to_logging_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_account_session_finalize;
}

static void
geary_imap_account_session_instance_init (GearyImapAccountSession * self,
                                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	self->priv = geary_imap_account_session_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_IMAP_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->folders = _tmp0_;
	_tmp1_ = geary_nonblocking_mutex_new ();
	self->priv->cmd_mutex = _tmp1_;
	self->priv->list_collector = NULL;
	self->priv->status_collector = NULL;
}

static void
geary_imap_account_session_finalize (GObject * obj)
{
	GearyImapAccountSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_ACCOUNT_SESSION, GearyImapAccountSession);
	_g_object_unref0 (self->priv->root);
	_g_object_unref0 (self->priv->folders);
	_g_object_unref0 (self->priv->cmd_mutex);
	_g_object_unref0 (self->priv->list_collector);
	_g_object_unref0 (self->priv->status_collector);
	G_OBJECT_CLASS (geary_imap_account_session_parent_class)->finalize (obj);
}

/**
 * An interface between the high-level engine API and the IMAP stack.
 *
 * Because of the complexities of the IMAP protocol, class takes
 * common operations that a Geary.Account implementation would need
 * (in particular, {@link Geary.ImapEngine.GenericAccount}) and makes
 * them into simple async calls.
 *
 * Geary.Imap.Account manages the {@link Imap.Folder} objects it
 * returns, but only in the sense that it will not create new
 * instances repeatedly.  Otherwise, it does not refresh or update the
 * Imap.Folders themselves (such as update their {@link
 * Imap.StatusData} periodically). That's the responsibility of the
 * higher layers of the stack.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_account_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapAccountSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_account_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapAccountSession), 0, (GInstanceInitFunc) geary_imap_account_session_instance_init, NULL };
	GType geary_imap_account_session_type_id;
	geary_imap_account_session_type_id = g_type_register_static (GEARY_IMAP_TYPE_SESSION_OBJECT, "GearyImapAccountSession", &g_define_type_info, 0);
	GearyImapAccountSession_private_offset = g_type_add_instance_private (geary_imap_account_session_type_id, sizeof (GearyImapAccountSessionPrivate));
	return geary_imap_account_session_type_id;
}

GType
geary_imap_account_session_get_type (void)
{
	static gsize geary_imap_account_session_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_account_session_type_id__once)) {
		GType geary_imap_account_session_type_id;
		geary_imap_account_session_type_id = geary_imap_account_session_get_type_once ();
		g_once_init_leave (&geary_imap_account_session_type_id__once, geary_imap_account_session_type_id);
	}
	return geary_imap_account_session_type_id__once;
}

