/* imap-session-object.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-session-object.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_SESSION_OBJECT_0_PROPERTY,
	GEARY_IMAP_SESSION_OBJECT_IS_VALID_PROPERTY,
	GEARY_IMAP_SESSION_OBJECT_LOGGING_PARENT_PROPERTY,
	GEARY_IMAP_SESSION_OBJECT_NUM_PROPERTIES
};
static GParamSpec* geary_imap_session_object_properties[GEARY_IMAP_SESSION_OBJECT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_IMAP_SESSION_OBJECT_DISCONNECTED_SIGNAL,
	GEARY_IMAP_SESSION_OBJECT_NUM_SIGNALS
};
static guint geary_imap_session_object_signals[GEARY_IMAP_SESSION_OBJECT_NUM_SIGNALS] = {0};

struct _GearyImapSessionObjectPrivate {
	GearyLoggingSource* _logging_parent;
	GearyImapClientSession* session;
};

static gint GearyImapSessionObject_private_offset;
static gpointer geary_imap_session_object_parent_class = NULL;
static GearyLoggingSourceIface * geary_imap_session_object_geary_logging_source_parent_iface = NULL;

static void geary_imap_session_object_on_session_state_change (GearyImapSessionObject* self);
static void _geary_imap_session_object_on_session_state_change_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static GearyImapClientSession* geary_imap_session_object_real_close (GearyImapSessionObject* self);
static GearyLoggingState* geary_imap_session_object_real_to_logging_state (GearyImapSessionObject* self);
VALA_EXTERN void geary_imap_session_object_set_logging_parent (GearyImapSessionObject* self,
                                                   GearyLoggingSource* parent);
static GearyImapClientSession* geary_imap_session_object_real_get_session (GearyImapSessionObject* self,
                                                                    GError** error);
static void geary_imap_session_object_finalize (GObject * obj);
static GType geary_imap_session_object_get_type_once (void);
static void _vala_geary_imap_session_object_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_imap_session_object_get_instance_private (GearyImapSessionObject* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapSessionObject_private_offset);
}

gboolean
geary_imap_session_object_get_is_valid (GearyImapSessionObject* self)
{
	gboolean result;
	GearyImapClientSession* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self), FALSE);
	_tmp0_ = self->priv->session;
	result = _tmp0_ != NULL;
	return result;
}

static GearyLoggingSource*
geary_imap_session_object_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyImapSessionObject* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

/**
     * Constructs a new IMAP object with the given session.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_geary_imap_session_object_on_session_state_change_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	geary_imap_session_object_on_session_state_change ((GearyImapSessionObject*) self);
}

GearyImapSessionObject*
geary_imap_session_object_construct (GType object_type,
                                     GearyImapClientSession* session)
{
	GearyImapSessionObject * self = NULL;
	GearyImapClientSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session), NULL);
	self = (GearyImapSessionObject*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (session);
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp0_;
	_tmp1_ = self->priv->session;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "notify::protocol-state", (GCallback) _geary_imap_session_object_on_session_state_change_g_object_notify, self, 0);
	return self;
}

/**
     * Drops this object's association with its client session.
     *
     * Calling this method unhooks the object from its session, and
     * makes it unavailable for further use. This does //not//
     * disconnect the client session from its server.
     *
     * @return the old IMAP client session, for returning to the pool,
     * etc, if any.
     */
static GearyImapClientSession*
geary_imap_session_object_real_close (GearyImapSessionObject* self)
{
	GearyImapClientSession* old_session = NULL;
	GearyImapClientSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	GearyImapClientSession* _tmp2_;
	GearyImapClientSession* result;
	_tmp0_ = self->priv->session;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	old_session = _tmp1_;
	_g_object_unref0 (self->priv->session);
	self->priv->session = NULL;
	_tmp2_ = old_session;
	if (_tmp2_ != NULL) {
		GearyImapClientSession* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		_tmp3_ = old_session;
		g_signal_parse_name ("notify::protocol-state", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _geary_imap_session_object_on_session_state_change_g_object_notify, self);
	}
	result = old_session;
	return result;
}

GearyImapClientSession*
geary_imap_session_object_close (GearyImapSessionObject* self)
{
	GearyImapSessionObjectClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self), NULL);
	_klass_ = GEARY_IMAP_SESSION_OBJECT_GET_CLASS (self);
	if (_klass_->close) {
		return _klass_->close (self);
	}
	return NULL;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_session_object_real_to_logging_state (GearyImapSessionObject* self)
{
	gchar* _tmp0_ = NULL;
	GearyImapClientSession* _tmp1_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* result;
	_tmp1_ = self->priv->session;
	if (_tmp1_ != NULL) {
		GearyImapClientSession* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->session;
		_tmp3_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("no session");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp0_);
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

GearyLoggingState*
geary_imap_session_object_to_logging_state (GearyImapSessionObject* self)
{
	GearyImapSessionObjectClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self), NULL);
	_klass_ = GEARY_IMAP_SESSION_OBJECT_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

/** Sets the session's logging parent. */
void
geary_imap_session_object_set_logging_parent (GearyImapSessionObject* self,
                                              GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

/**
     * Returns a valid IMAP client session for use by this object.
     *
     * @throws ImapError.NOT_CONNECTED if the client session has been
     * dropped via {@link close}, if the client session is logging out
     * or has been closed, or because the connection to the server was
     * lost.
     */
static GearyImapClientSession*
geary_imap_session_object_real_get_session (GearyImapSessionObject* self,
                                            GError** error)
{
	gboolean _tmp0_ = FALSE;
	GearyImapClientSession* _tmp1_;
	GearyImapClientSession* _tmp6_;
	GearyImapClientSession* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyImapClientSession* result;
	_tmp1_ = self->priv->session;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GearyImapClientSession* _tmp2_;
		GearyImapClientSessionProtocolState _tmp3_;
		GearyImapClientSessionProtocolState _tmp4_;
		_tmp2_ = self->priv->session;
		_tmp3_ = geary_imap_client_session_get_protocol_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_NOT_CONNECTED;
	}
	if (_tmp0_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED, "IMAP object has no session or is not connected");
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = self->priv->session;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

GearyImapClientSession*
geary_imap_session_object_get_session (GearyImapSessionObject* self,
                                       GError** error)
{
	GearyImapSessionObjectClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self), NULL);
	_klass_ = GEARY_IMAP_SESSION_OBJECT_GET_CLASS (self);
	if (_klass_->get_session) {
		return _klass_->get_session (self, error);
	}
	return NULL;
}

static void
geary_imap_session_object_on_session_state_change (GearyImapSessionObject* self)
{
	gboolean _tmp0_ = FALSE;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_SESSION_OBJECT (self));
	_tmp1_ = self->priv->session;
	if (_tmp1_ != NULL) {
		GearyImapClientSession* _tmp2_;
		GearyImapClientSessionProtocolState _tmp3_;
		GearyImapClientSessionProtocolState _tmp4_;
		_tmp2_ = self->priv->session;
		_tmp3_ = geary_imap_client_session_get_protocol_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_NOT_CONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyImapClientSessionDisconnectReason _tmp5_ = 0;
		GearyImapClientSession* _tmp6_;
		GearyImapClientSessionDisconnectReason _tmp7_;
		GearyImapClientSessionDisconnectReason _tmp8_;
		GearyImapClientSessionDisconnectReason reason = 0;
		GearyImapClientSession* _tmp12_;
		GearyImapClientSession* _tmp13_;
		_tmp6_ = self->priv->session;
		_tmp7_ = geary_imap_client_session_get_disconnected (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == GEARY_IMAP_CLIENT_SESSION_DISCONNECT_REASON_NULL) {
			_tmp5_ = GEARY_IMAP_CLIENT_SESSION_DISCONNECT_REASON_LOCAL_CLOSE;
		} else {
			GearyImapClientSession* _tmp9_;
			GearyImapClientSessionDisconnectReason _tmp10_;
			GearyImapClientSessionDisconnectReason _tmp11_;
			_tmp9_ = self->priv->session;
			_tmp10_ = geary_imap_client_session_get_disconnected (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		}
		reason = _tmp5_;
		_tmp12_ = geary_imap_session_object_close (self);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		g_signal_emit (self, geary_imap_session_object_signals[GEARY_IMAP_SESSION_OBJECT_DISCONNECTED_SIGNAL], 0, reason);
	}
}

static void
geary_imap_session_object_class_init (GearyImapSessionObjectClass * klass,
                                      gpointer klass_data)
{
	geary_imap_session_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapSessionObject_private_offset);
	((GearyImapSessionObjectClass *) klass)->close = (GearyImapClientSession* (*) (GearyImapSessionObject*)) geary_imap_session_object_real_close;
	((GearyImapSessionObjectClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyImapSessionObject*)) geary_imap_session_object_real_to_logging_state;
	((GearyImapSessionObjectClass *) klass)->get_session = (GearyImapClientSession* (*) (GearyImapSessionObject*, GError**)) geary_imap_session_object_real_get_session;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_session_object_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_session_object_finalize;
	/** Determines if this object has a valid session or not. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_SESSION_OBJECT_IS_VALID_PROPERTY, geary_imap_session_object_properties[GEARY_IMAP_SESSION_OBJECT_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_SESSION_OBJECT_LOGGING_PARENT_PROPERTY, geary_imap_session_object_properties[GEARY_IMAP_SESSION_OBJECT_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Fired if the object's connection to the server is lost. */
	geary_imap_session_object_signals[GEARY_IMAP_SESSION_OBJECT_DISCONNECTED_SIGNAL] = g_signal_new ("disconnected", GEARY_IMAP_TYPE_SESSION_OBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, GEARY_IMAP_CLIENT_SESSION_TYPE_DISCONNECT_REASON);
}

static void
geary_imap_session_object_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                               gpointer iface_data)
{
	geary_imap_session_object_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_imap_session_object_to_logging_state;
	iface->get_logging_parent = geary_imap_session_object_real_get_logging_parent;
}

static void
geary_imap_session_object_instance_init (GearyImapSessionObject * self,
                                         gpointer klass)
{
	self->priv = geary_imap_session_object_get_instance_private (self);
	self->priv->_logging_parent = NULL;
}

static void
geary_imap_session_object_finalize (GObject * obj)
{
	GearyImapSessionObject * self;
	GearyImapClientSession* _tmp0_;
	GearyImapClientSession* _tmp1_;
	gboolean _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject);
	_tmp0_ = geary_imap_session_object_close (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Destroyed without releasing its session");
	}
	_g_object_unref0 (self->priv->session);
	G_OBJECT_CLASS (geary_imap_session_object_parent_class)->finalize (obj);
}

/**
 * Base class for IMAP client session objects.
 *
 * Since a client session can come and go as the server and network
 * changes, IMAP client objects need to be sensitive to the state of
 * the connection. This abstract class manages access to an IMAP
 * client session for objects that use connections to an IMAP server,
 * ensuring it is no longer available if the client session is
 * disconnected.
 *
 * This class is ''not'' thread safe.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_session_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapSessionObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_session_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapSessionObject), 0, (GInstanceInitFunc) geary_imap_session_object_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_imap_session_object_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_session_object_type_id;
	geary_imap_session_object_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapSessionObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_imap_session_object_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyImapSessionObject_private_offset = g_type_add_instance_private (geary_imap_session_object_type_id, sizeof (GearyImapSessionObjectPrivate));
	return geary_imap_session_object_type_id;
}

GType
geary_imap_session_object_get_type (void)
{
	static gsize geary_imap_session_object_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_session_object_type_id__once)) {
		GType geary_imap_session_object_type_id;
		geary_imap_session_object_type_id = geary_imap_session_object_get_type_once ();
		g_once_init_leave (&geary_imap_session_object_type_id__once, geary_imap_session_object_type_id);
	}
	return geary_imap_session_object_type_id__once;
}

static void
_vala_geary_imap_session_object_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapSessionObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_SESSION_OBJECT, GearyImapSessionObject);
	switch (property_id) {
		case GEARY_IMAP_SESSION_OBJECT_IS_VALID_PROPERTY:
		g_value_set_boolean (value, geary_imap_session_object_get_is_valid (self));
		break;
		case GEARY_IMAP_SESSION_OBJECT_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

