/* imap-message-flags.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-message-flags.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_MESSAGE_FLAGS_0_PROPERTY,
	GEARY_IMAP_MESSAGE_FLAGS_NUM_PROPERTIES
};
static GParamSpec* geary_imap_message_flags_properties[GEARY_IMAP_MESSAGE_FLAGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_imap_message_flags_parent_class = NULL;

VALA_EXTERN void geary_imap_message_flags_add (GearyImapMessageFlags* self,
                                   GearyImapMessageFlag* flag);
VALA_EXTERN void geary_imap_message_flags_remove (GearyImapMessageFlags* self,
                                      GearyImapMessageFlag* flag);
static GType geary_imap_message_flags_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GearyImapMessageFlags*
geary_imap_message_flags_construct (GType object_type,
                                    GeeCollection* flags)
{
	GearyImapMessageFlags * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flags, GEE_TYPE_COLLECTION), NULL);
	self = (GearyImapMessageFlags*) geary_imap_flags_construct (object_type, flags);
	return self;
}

GearyImapMessageFlags*
geary_imap_message_flags_new (GeeCollection* flags)
{
	return geary_imap_message_flags_construct (GEARY_IMAP_TYPE_MESSAGE_FLAGS, flags);
}

/**
     * Create {@link MessageFlags} from a {@link ListParameter} of flag strings.
     */
GearyImapMessageFlags*
geary_imap_message_flags_from_list (GearyImapListParameter* listp,
                                    GError** error)
{
	GeeCollection* list = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp12_;
	GearyImapMessageFlags* _tmp13_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageFlags* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), NULL);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MESSAGE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				GearyImapStringParameter* _tmp5_ = NULL;
				GearyImapStringParameter* _tmp6_;
				GeeCollection* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GearyImapMessageFlag* _tmp10_;
				GearyImapMessageFlag* _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = geary_imap_list_parameter_get_size (listp);
				_tmp4_ = _tmp3_;
				if (!(ctr < _tmp4_)) {
					break;
				}
				_tmp6_ = geary_imap_list_parameter_get_as_string (listp, ctr, &_inner_error0_);
				_tmp5_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp7_ = list;
				_tmp8_ = geary_imap_string_parameter_get_ascii (_tmp5_);
				_tmp9_ = _tmp8_;
				_tmp10_ = geary_imap_message_flag_new (_tmp9_);
				_tmp11_ = _tmp10_;
				gee_collection_add (_tmp7_, _tmp11_);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp12_ = list;
	_tmp13_ = geary_imap_message_flags_new (_tmp12_);
	result = _tmp13_;
	_g_object_unref0 (list);
	return result;
}

/**
     * Create {@link MessageFlags} from a flat string of space-delimited flags.
     */
GearyImapMessageFlags*
geary_imap_message_flags_deserialize (const gchar* str)
{
	gchar** tokens = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	GeeCollection* flags = NULL;
	GeeArrayList* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GeeCollection* _tmp13_;
	GearyImapMessageFlags* _tmp14_;
	GearyImapMessageFlags* result;
	if (geary_string_is_empty (str)) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GearyImapMessageFlags* _tmp2_;
		GearyImapMessageFlags* _tmp3_;
		_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MESSAGE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = geary_imap_message_flags_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp5_ = _tmp4_ = g_strsplit (str, " ", 0);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	_tmp6_ = gee_array_list_new (GEARY_IMAP_TYPE_MESSAGE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	flags = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp7_;
		token_collection_length1 = _tmp7__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp8_;
			gchar* token = NULL;
			_tmp8_ = g_strdup (token_collection[token_it]);
			token = _tmp8_;
			{
				GeeCollection* _tmp9_;
				const gchar* _tmp10_;
				GearyImapMessageFlag* _tmp11_;
				GearyImapMessageFlag* _tmp12_;
				_tmp9_ = flags;
				_tmp10_ = token;
				_tmp11_ = geary_imap_message_flag_new (_tmp10_);
				_tmp12_ = _tmp11_;
				gee_collection_add (_tmp9_, _tmp12_);
				_g_object_unref0 (_tmp12_);
				_g_free0 (token);
			}
		}
	}
	_tmp13_ = flags;
	_tmp14_ = geary_imap_message_flags_new (_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (flags);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
geary_imap_message_flags_add (GearyImapMessageFlags* self,
                              GearyImapMessageFlag* flag)
{
	GeeSet* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_FLAGS (self));
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_FLAG (flag));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags)->list;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (flag, GEARY_IMAP_TYPE_FLAG, GearyImapFlag));
}

void
geary_imap_message_flags_remove (GearyImapMessageFlags* self,
                                 GearyImapMessageFlag* flag)
{
	GeeSet* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_FLAGS (self));
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_FLAG (flag));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags)->list;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (flag, GEARY_IMAP_TYPE_FLAG, GearyImapFlag));
}

static void
geary_imap_message_flags_class_init (GearyImapMessageFlagsClass * klass,
                                     gpointer klass_data)
{
	geary_imap_message_flags_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_message_flags_instance_init (GearyImapMessageFlags * self,
                                        gpointer klass)
{
}

/**
 * A collection of {@link MessageFlag}s.
 *
 * @see StoreCommand
 * @see FetchCommand
 * @see FetchedData
 */
 G_GNUC_NO_INLINE static GType
geary_imap_message_flags_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMessageFlagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_message_flags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMessageFlags), 0, (GInstanceInitFunc) geary_imap_message_flags_instance_init, NULL };
	GType geary_imap_message_flags_type_id;
	geary_imap_message_flags_type_id = g_type_register_static (GEARY_IMAP_TYPE_FLAGS, "GearyImapMessageFlags", &g_define_type_info, 0);
	return geary_imap_message_flags_type_id;
}

GType
geary_imap_message_flags_get_type (void)
{
	static gsize geary_imap_message_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_message_flags_type_id__once)) {
		GType geary_imap_message_flags_type_id;
		geary_imap_message_flags_type_id = geary_imap_message_flags_get_type_once ();
		g_once_init_leave (&geary_imap_message_flags_type_id__once, geary_imap_message_flags_type_id);
	}
	return geary_imap_message_flags_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

