/* imap-number-parameter.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-number-parameter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_NUMBER_PARAMETER_0_PROPERTY,
	GEARY_IMAP_NUMBER_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_number_parameter_properties[GEARY_IMAP_NUMBER_PARAMETER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_imap_number_parameter_parent_class = NULL;

static GType geary_imap_number_parameter_get_type_once (void);

GearyImapNumberParameter*
geary_imap_number_parameter_construct (GType object_type,
                                       gint num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%i", num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new (gint num)
{
	return geary_imap_number_parameter_construct (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

GearyImapNumberParameter*
geary_imap_number_parameter_construct_uint (GType object_type,
                                            guint num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%u", num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_uint (guint num)
{
	return geary_imap_number_parameter_construct_uint (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

GearyImapNumberParameter*
geary_imap_number_parameter_construct_int32 (GType object_type,
                                             gint32 num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%i", num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_int32 (gint32 num)
{
	return geary_imap_number_parameter_construct_int32 (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

GearyImapNumberParameter*
geary_imap_number_parameter_construct_uint32 (GType object_type,
                                              guint32 num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%u", num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_uint32 (guint32 num)
{
	return geary_imap_number_parameter_construct_uint32 (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

GearyImapNumberParameter*
geary_imap_number_parameter_construct_int64 (GType object_type,
                                             gint64 num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_int64 (gint64 num)
{
	return geary_imap_number_parameter_construct_int64 (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

GearyImapNumberParameter*
geary_imap_number_parameter_construct_uint64 (GType object_type,
                                              guint64 num)
{
	GearyImapNumberParameter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%" G_GUINT64_FORMAT, num);
	_tmp1_ = _tmp0_;
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_uint64 (guint64 num)
{
	return geary_imap_number_parameter_construct_uint64 (GEARY_IMAP_TYPE_NUMBER_PARAMETER, num);
}

/**
     * Creates a {@link NumberParameter} for a string representation of a number.
     *
     * No checking is performed to verify that the string is only composed of numeric characters.
     * Use {@link is_ascii_numeric}.
     */
GearyImapNumberParameter*
geary_imap_number_parameter_construct_from_ascii (GType object_type,
                                                  const gchar* ascii)
{
	GearyImapNumberParameter * self = NULL;
	g_return_val_if_fail (ascii != NULL, NULL);
	self = (GearyImapNumberParameter*) geary_imap_unquoted_string_parameter_construct (object_type, ascii);
	return self;
}

GearyImapNumberParameter*
geary_imap_number_parameter_new_from_ascii (const gchar* ascii)
{
	return geary_imap_number_parameter_construct_from_ascii (GEARY_IMAP_TYPE_NUMBER_PARAMETER, ascii);
}

/**
     * Returns true if the string is composed of numeric 7-bit characters.
     *
     * The only non-numeric character allowed is a dash ('-') at the beginning of the string to
     * indicate a negative value.  However, note that almost every IMAP use of a number is for a
     * positive value.  is_negative returns set to true if that's the case.  is_negative is only
     * a valid value if the method returns true itself.
     *
     * is_negative is false for zero ("0") and negative zero ("-0").
     *
     * Empty strings (null or zero-length) are considered non-numeric.  Leading and trailing
     * whitespace are stripped before evaluating the string.
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
geary_imap_number_parameter_is_ascii_numeric (const gchar* ascii,
                                              gboolean* is_negative)
{
	gboolean _vala_is_negative = FALSE;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean has_nonzero = FALSE;
	gint index = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean result;
	g_return_val_if_fail (ascii != NULL, FALSE);
	_vala_is_negative = FALSE;
	_tmp0_ = string_strip (ascii);
	str = _tmp0_;
	_tmp1_ = str;
	if (geary_string_is_empty (_tmp1_)) {
		result = FALSE;
		_g_free0 (str);
		if (is_negative) {
			*is_negative = _vala_is_negative;
		}
		return result;
	}
	has_nonzero = FALSE;
	index = 0;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gchar ch = '\0';
			const gchar* _tmp3_;
			gint _tmp4_;
			gboolean _tmp5_ = FALSE;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = str;
			_tmp4_ = index;
			index = _tmp4_ + 1;
			ch = string_get (_tmp3_, (glong) _tmp4_);
			if (ch == GEARY_STRING_EOS) {
				break;
			}
			if (index == 1) {
				_tmp5_ = ch == '-';
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_vala_is_negative = TRUE;
				continue;
			}
			if (!g_ascii_isdigit (ch)) {
				result = FALSE;
				_g_free0 (str);
				if (is_negative) {
					*is_negative = _vala_is_negative;
				}
				return result;
			}
			if (ch != '0') {
				has_nonzero = TRUE;
			}
		}
	}
	if (_vala_is_negative) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = str;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp6_ = _tmp9_ == 1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		_g_free0 (str);
		if (is_negative) {
			*is_negative = _vala_is_negative;
		}
		return result;
	}
	if (_vala_is_negative) {
		_tmp10_ = !has_nonzero;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_vala_is_negative = FALSE;
	}
	result = TRUE;
	_g_free0 (str);
	if (is_negative) {
		*is_negative = _vala_is_negative;
	}
	return result;
}

static void
geary_imap_number_parameter_class_init (GearyImapNumberParameterClass * klass,
                                        gpointer klass_data)
{
	geary_imap_number_parameter_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_number_parameter_instance_init (GearyImapNumberParameter * self,
                                           gpointer klass)
{
}

/**
 * A representation of a numerical {@link Parameter} in an IMAP {@link Command} or
 * {@link ServerResponse}.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-4.2]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_number_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapNumberParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_number_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapNumberParameter), 0, (GInstanceInitFunc) geary_imap_number_parameter_instance_init, NULL };
	GType geary_imap_number_parameter_type_id;
	geary_imap_number_parameter_type_id = g_type_register_static (GEARY_IMAP_TYPE_UNQUOTED_STRING_PARAMETER, "GearyImapNumberParameter", &g_define_type_info, 0);
	return geary_imap_number_parameter_type_id;
}

GType
geary_imap_number_parameter_get_type (void)
{
	static gsize geary_imap_number_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_number_parameter_type_id__once)) {
		GType geary_imap_number_parameter_type_id;
		geary_imap_number_parameter_type_id = geary_imap_number_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_number_parameter_type_id__once, geary_imap_number_parameter_type_id);
	}
	return geary_imap_number_parameter_type_id__once;
}

