/* imap-status-data.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-status-data.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_STATUS_DATA_0_PROPERTY,
	GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY,
	GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY,
	GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY,
	GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY,
	GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY,
	GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY,
	GEARY_IMAP_STATUS_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GearyImapStatusDataPrivate {
	GearyImapMailboxSpecifier* _mailbox;
	gint _messages;
	gint _recent;
	GearyImapUID* _uid_next;
	GearyImapUIDValidity* _uid_validity;
	gint _unseen;
};

static gint GearyImapStatusData_private_offset;
static gpointer geary_imap_status_data_parent_class = NULL;

static void geary_imap_status_data_set_mailbox (GearyImapStatusData* self,
                                         GearyImapMailboxSpecifier* value);
static void geary_imap_status_data_set_messages (GearyImapStatusData* self,
                                          gint value);
static void geary_imap_status_data_set_recent (GearyImapStatusData* self,
                                        gint value);
static void geary_imap_status_data_set_uid_next (GearyImapStatusData* self,
                                          GearyImapUID* value);
static void geary_imap_status_data_set_uid_validity (GearyImapStatusData* self,
                                              GearyImapUIDValidity* value);
static void geary_imap_status_data_set_unseen (GearyImapStatusData* self,
                                        gint value);
static void geary_imap_status_data_finalize (GObject * obj);
static GType geary_imap_status_data_get_type_once (void);
static void _vala_geary_imap_status_data_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_imap_status_data_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
geary_imap_status_data_get_instance_private (GearyImapStatusData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapStatusData_private_offset);
}

GearyImapMailboxSpecifier*
geary_imap_status_data_get_mailbox (GearyImapStatusData* self)
{
	GearyImapMailboxSpecifier* result;
	GearyImapMailboxSpecifier* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_status_data_set_mailbox (GearyImapStatusData* self,
                                    GearyImapMailboxSpecifier* value)
{
	GearyImapMailboxSpecifier* old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_mailbox (self);
	if (old_value != value) {
		GearyImapMailboxSpecifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mailbox);
		self->priv->_mailbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY]);
	}
}

gint
geary_imap_status_data_get_messages (GearyImapStatusData* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), 0);
	result = self->priv->_messages;
	return result;
}

static void
geary_imap_status_data_set_messages (GearyImapStatusData* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_messages (self);
	if (old_value != value) {
		self->priv->_messages = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY]);
	}
}

gint
geary_imap_status_data_get_recent (GearyImapStatusData* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), 0);
	result = self->priv->_recent;
	return result;
}

static void
geary_imap_status_data_set_recent (GearyImapStatusData* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_recent (self);
	if (old_value != value) {
		self->priv->_recent = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY]);
	}
}

GearyImapUID*
geary_imap_status_data_get_uid_next (GearyImapStatusData* self)
{
	GearyImapUID* result;
	GearyImapUID* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), NULL);
	_tmp0_ = self->priv->_uid_next;
	result = _tmp0_;
	return result;
}

static void
geary_imap_status_data_set_uid_next (GearyImapStatusData* self,
                                     GearyImapUID* value)
{
	GearyImapUID* old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_uid_next (self);
	if (old_value != value) {
		GearyImapUID* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid_next);
		self->priv->_uid_next = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY]);
	}
}

GearyImapUIDValidity*
geary_imap_status_data_get_uid_validity (GearyImapStatusData* self)
{
	GearyImapUIDValidity* result;
	GearyImapUIDValidity* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), NULL);
	_tmp0_ = self->priv->_uid_validity;
	result = _tmp0_;
	return result;
}

static void
geary_imap_status_data_set_uid_validity (GearyImapStatusData* self,
                                         GearyImapUIDValidity* value)
{
	GearyImapUIDValidity* old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_uid_validity (self);
	if (old_value != value) {
		GearyImapUIDValidity* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid_validity);
		self->priv->_uid_validity = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY]);
	}
}

gint
geary_imap_status_data_get_unseen (GearyImapStatusData* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), 0);
	result = self->priv->_unseen;
	return result;
}

static void
geary_imap_status_data_set_unseen (GearyImapStatusData* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (self));
	old_value = geary_imap_status_data_get_unseen (self);
	if (old_value != value) {
		self->priv->_unseen = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY]);
	}
}

GearyImapStatusData*
geary_imap_status_data_construct (GType object_type,
                                  GearyImapMailboxSpecifier* mailbox,
                                  gint messages,
                                  gint recent,
                                  GearyImapUID* uid_next,
                                  GearyImapUIDValidity* uid_validity,
                                  gint unseen)
{
	GearyImapStatusData * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail ((uid_next == NULL) || GEARY_IMAP_IS_UID (uid_next), NULL);
	g_return_val_if_fail ((uid_validity == NULL) || GEARY_IMAP_IS_UID_VALIDITY (uid_validity), NULL);
	self = (GearyImapStatusData*) g_object_new (object_type, NULL);
	geary_imap_status_data_set_mailbox (self, mailbox);
	geary_imap_status_data_set_messages (self, messages);
	geary_imap_status_data_set_recent (self, recent);
	geary_imap_status_data_set_uid_next (self, uid_next);
	geary_imap_status_data_set_uid_validity (self, uid_validity);
	geary_imap_status_data_set_unseen (self, unseen);
	return self;
}

GearyImapStatusData*
geary_imap_status_data_new (GearyImapMailboxSpecifier* mailbox,
                            gint messages,
                            gint recent,
                            GearyImapUID* uid_next,
                            GearyImapUIDValidity* uid_validity,
                            gint unseen)
{
	return geary_imap_status_data_construct (GEARY_IMAP_TYPE_STATUS_DATA, mailbox, messages, recent, uid_next, uid_validity, unseen);
}

/**
     * Decodes {@link ServerData} into a StatusData representation.
     *
     * The ServerData must be the response to a STATUS command.
     *
     * @see StatusCommand
     * @see ServerData.get_status
     */
static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

GearyImapStatusData*
geary_imap_status_data_decode (GearyImapServerData* server_data,
                               GError** error)
{
	GearyImapStringParameter* _tmp0_ = NULL;
	GearyImapStringParameter* _tmp1_;
	GearyImapStringParameter* mailbox_param = NULL;
	GearyImapStringParameter* _tmp6_;
	gint messages = 0;
	gint recent = 0;
	GearyImapUID* uid_next = NULL;
	GearyImapUIDValidity* uid_validity = NULL;
	gint unseen = 0;
	GearyImapListParameter* values = NULL;
	GearyImapListParameter* _tmp7_;
	GearyImapStringParameter* _tmp45_;
	GearyImapMailboxSpecifier* _tmp46_;
	GearyImapMailboxSpecifier* _tmp47_;
	GearyImapUID* _tmp48_;
	GearyImapUIDValidity* _tmp49_;
	GearyImapStatusData* _tmp50_;
	GearyImapStatusData* _tmp51_;
	GError* _inner_error0_ = NULL;
	GearyImapStatusData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (server_data), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_string_parameter_equals_ci (_tmp0_, GEARY_IMAP_STATUS_COMMAND_NAME)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Bad STATUS command name in response \"%s\"", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	mailbox_param = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	messages = GEARY_IMAP_STATUS_DATA_UNSET;
	recent = GEARY_IMAP_STATUS_DATA_UNSET;
	uid_next = NULL;
	uid_validity = NULL;
	unseen = GEARY_IMAP_STATUS_DATA_UNSET;
	_tmp7_ = geary_imap_list_parameter_get_as_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 3, &_inner_error0_);
	values = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (uid_validity);
			_g_object_unref0 (uid_next);
			_g_object_unref0 (mailbox_param);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (uid_validity);
			_g_object_unref0 (uid_next);
			_g_object_unref0 (mailbox_param);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GearyImapListParameter* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp8_) {
					ctr += 2;
				}
				_tmp8_ = FALSE;
				_tmp9_ = values;
				_tmp10_ = geary_imap_list_parameter_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(ctr < _tmp11_)) {
					break;
				}
				{
					GearyImapStringParameter* typep = NULL;
					GearyImapListParameter* _tmp12_;
					GearyImapStringParameter* _tmp13_;
					GearyImapStringParameter* valuep = NULL;
					GearyImapListParameter* _tmp14_;
					GearyImapStringParameter* _tmp15_;
					GearyImapStatusDataType _tmp16_ = 0;
					GearyImapStringParameter* _tmp17_;
					_tmp12_ = values;
					_tmp13_ = geary_imap_list_parameter_get_as_string (_tmp12_, ctr, &_inner_error0_);
					typep = _tmp13_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							goto __catch0_geary_imap_error;
						}
						_g_object_unref0 (values);
						_g_object_unref0 (uid_validity);
						_g_object_unref0 (uid_next);
						_g_object_unref0 (mailbox_param);
						_g_object_unref0 (_tmp0_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp14_ = values;
					_tmp15_ = geary_imap_list_parameter_get_as_string (_tmp14_, ctr + 1, &_inner_error0_);
					valuep = _tmp15_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (typep);
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							goto __catch0_geary_imap_error;
						}
						_g_object_unref0 (values);
						_g_object_unref0 (uid_validity);
						_g_object_unref0 (uid_next);
						_g_object_unref0 (mailbox_param);
						_g_object_unref0 (_tmp0_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp17_ = typep;
					_tmp16_ = geary_imap_status_data_type_from_parameter (_tmp17_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (valuep);
						_g_object_unref0 (typep);
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							goto __catch0_geary_imap_error;
						}
						_g_object_unref0 (values);
						_g_object_unref0 (uid_validity);
						_g_object_unref0 (uid_next);
						_g_object_unref0 (mailbox_param);
						_g_object_unref0 (_tmp0_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					switch (_tmp16_) {
						case GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES:
						{
							gint32 _tmp18_ = 0;
							GearyImapStringParameter* _tmp19_;
							_tmp19_ = valuep;
							_tmp18_ = geary_imap_string_parameter_as_int32 (_tmp19_, (gint32) -1, (gint32) G_MAXINT, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							messages = (gint) _tmp18_;
							break;
						}
						case GEARY_IMAP_STATUS_DATA_TYPE_RECENT:
						{
							gint32 _tmp20_ = 0;
							GearyImapStringParameter* _tmp21_;
							_tmp21_ = valuep;
							_tmp20_ = geary_imap_string_parameter_as_int32 (_tmp21_, (gint32) -1, (gint32) G_MAXINT, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							recent = (gint) _tmp20_;
							break;
						}
						case GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT:
						{
							{
								gint64 _tmp22_ = 0LL;
								GearyImapStringParameter* _tmp23_;
								GearyImapUID* _tmp24_ = NULL;
								GearyImapUID* _tmp25_;
								GearyImapUID* _tmp26_;
								_tmp23_ = valuep;
								_tmp22_ = geary_imap_string_parameter_as_int64 (_tmp23_, G_MININT64, G_MAXINT64, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (g_error_matches (_inner_error0_, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID)) {
										goto __catch1_geary_imap_error_invalid;
									}
									goto __finally1;
								}
								_tmp25_ = geary_imap_uid_new_checked (_tmp22_, &_inner_error0_);
								_tmp24_ = _tmp25_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (g_error_matches (_inner_error0_, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID)) {
										goto __catch1_geary_imap_error_invalid;
									}
									goto __finally1;
								}
								_tmp26_ = _tmp24_;
								_tmp24_ = NULL;
								_g_object_unref0 (uid_next);
								uid_next = _tmp26_;
								_g_object_unref0 (_tmp24_);
							}
							goto __finally1;
							__catch1_geary_imap_error_invalid:
							{
								GError* err = NULL;
								gint64 _tmp27_ = 0LL;
								GearyImapStringParameter* _tmp28_;
								err = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp28_ = valuep;
								_tmp27_ = geary_imap_string_parameter_as_int64 (_tmp28_, G_MININT64, G_MAXINT64, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_error_free0 (err);
									goto __finally1;
								}
								if (_tmp27_ == ((gint64) 0)) {
									g_warning ("imap-status-data.vala:113: Ignoring bad UIDNEXT 0 from server");
								} else {
									GError* _tmp29_;
									GError* _tmp30_;
									_tmp29_ = err;
									_tmp30_ = _g_error_copy0 (_tmp29_);
									_inner_error0_ = _tmp30_;
									_g_error_free0 (err);
									goto __finally1;
								}
								_g_error_free0 (err);
							}
							__finally1:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							break;
						}
						case GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY:
						{
							gint64 _tmp31_ = 0LL;
							GearyImapStringParameter* _tmp32_;
							GearyImapUIDValidity* _tmp33_ = NULL;
							GearyImapUIDValidity* _tmp34_;
							GearyImapUIDValidity* _tmp35_;
							_tmp32_ = valuep;
							_tmp31_ = geary_imap_string_parameter_as_int64 (_tmp32_, G_MININT64, G_MAXINT64, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							_tmp34_ = geary_imap_uid_validity_new_checked (_tmp31_, &_inner_error0_);
							_tmp33_ = _tmp34_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							_tmp35_ = _tmp33_;
							_tmp33_ = NULL;
							_g_object_unref0 (uid_validity);
							uid_validity = _tmp35_;
							_g_object_unref0 (_tmp33_);
							break;
						}
						case GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN:
						{
							gint32 _tmp36_ = 0;
							GearyImapStringParameter* _tmp37_;
							_tmp37_ = valuep;
							_tmp36_ = geary_imap_string_parameter_as_int32 (_tmp37_, (gint32) -1, (gint32) G_MAXINT, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (valuep);
								_g_object_unref0 (typep);
								if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
									goto __catch0_geary_imap_error;
								}
								_g_object_unref0 (values);
								_g_object_unref0 (uid_validity);
								_g_object_unref0 (uid_next);
								_g_object_unref0 (mailbox_param);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							unseen = (gint) _tmp36_;
							break;
						}
						default:
						{
							GearyImapStringParameter* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							_tmp38_ = typep;
							_tmp39_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
							_tmp40_ = _tmp39_;
							g_message ("imap-status-data.vala:130: Bad STATUS data type %s", _tmp40_);
							_g_free0 (_tmp40_);
							break;
						}
					}
					_g_object_unref0 (valuep);
					_g_object_unref0 (typep);
				}
				goto __finally0;
				__catch0_geary_imap_error:
				{
					GError* ierr = NULL;
					gchar* _tmp41_;
					gchar* _tmp42_;
					GError* _tmp43_;
					const gchar* _tmp44_;
					ierr = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp41_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
					_tmp42_ = _tmp41_;
					_tmp43_ = ierr;
					_tmp44_ = _tmp43_->message;
					g_warning ("imap-status-data.vala:134: Bad value at %d/%d in STATUS response \"%s\"" \
": %s", ctr, ctr + 1, _tmp42_, _tmp44_);
					_g_free0 (_tmp42_);
					_g_error_free0 (ierr);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (values);
						_g_object_unref0 (uid_validity);
						_g_object_unref0 (uid_next);
						_g_object_unref0 (mailbox_param);
						_g_object_unref0 (_tmp0_);
						return NULL;
					} else {
						_g_object_unref0 (values);
						_g_object_unref0 (uid_validity);
						_g_object_unref0 (uid_next);
						_g_object_unref0 (mailbox_param);
						_g_object_unref0 (_tmp0_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp45_ = mailbox_param;
	_tmp46_ = geary_imap_mailbox_specifier_new_from_parameter (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = uid_next;
	_tmp49_ = uid_validity;
	_tmp50_ = geary_imap_status_data_new (_tmp47_, messages, recent, _tmp48_, _tmp49_, unseen);
	_tmp51_ = _tmp50_;
	_g_object_unref0 (_tmp47_);
	result = _tmp51_;
	_g_object_unref0 (values);
	_g_object_unref0 (uid_validity);
	_g_object_unref0 (uid_next);
	_g_object_unref0 (mailbox_param);
	_g_object_unref0 (_tmp0_);
	return result;
}

gchar*
geary_imap_status_data_to_string (GearyImapStatusData* self)
{
	gchar* _tmp0_ = NULL;
	GearyImapUID* _tmp1_;
	gchar* _tmp5_ = NULL;
	GearyImapUIDValidity* _tmp6_;
	GearyImapMailboxSpecifier* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (self), NULL);
	_tmp1_ = self->priv->_uid_next;
	if (_tmp1_ != NULL) {
		GearyImapUID* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_uid_next;
		_tmp3_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("(none)");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp6_ = self->priv->_uid_validity;
	if (_tmp6_ != NULL) {
		GearyImapUIDValidity* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->_uid_validity;
		_tmp8_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("(none)");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = self->priv->_mailbox;
	_tmp11_ = geary_imap_mailbox_specifier_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_messages;
	_tmp14_ = g_strdup_printf ("%s/%d/UIDNEXT=%s/UIDVALIDITY=%s", _tmp12_, _tmp13_, _tmp0_, _tmp5_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp12_);
	result = _tmp15_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp0_);
	return result;
}

static void
geary_imap_status_data_class_init (GearyImapStatusDataClass * klass,
                                   gpointer klass_data)
{
	geary_imap_status_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapStatusData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_status_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_status_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_status_data_finalize;
	/**
	     * Name of the mailbox.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY] = g_param_spec_object ("mailbox", "mailbox", "mailbox", GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@link UNSET} if not set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY] = g_param_spec_int ("messages", "messages", "messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@link UNSET} if not set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY] = g_param_spec_int ("recent", "recent", "recent", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The UIDNEXT of the mailbox, if returned.
	     *
	     * See [[http://tools.ietf.org/html/rfc3501#section-2.3.1.1]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY] = g_param_spec_object ("uid-next", "uid-next", "uid-next", GEARY_IMAP_TYPE_UID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The UIDVALIDITY of the mailbox, if returned.
	     *
	     * See [[http://tools.ietf.org/html/rfc3501#section-2.3.1.1]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY] = g_param_spec_object ("uid-validity", "uid-validity", "uid-validity", GEARY_IMAP_TYPE_UID_VALIDITY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@link UNSET} if not set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY, geary_imap_status_data_properties[GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY] = g_param_spec_int ("unseen", "unseen", "unseen", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_status_data_instance_init (GearyImapStatusData * self,
                                      gpointer klass)
{
	self->priv = geary_imap_status_data_get_instance_private (self);
}

static void
geary_imap_status_data_finalize (GObject * obj)
{
	GearyImapStatusData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_STATUS_DATA, GearyImapStatusData);
	_g_object_unref0 (self->priv->_mailbox);
	_g_object_unref0 (self->priv->_uid_next);
	_g_object_unref0 (self->priv->_uid_validity);
	G_OBJECT_CLASS (geary_imap_status_data_parent_class)->finalize (obj);
}

/**
 * The decoded response to a STATUS command.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.2.4]]
 *
 * @see StatusCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_status_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapStatusDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_status_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapStatusData), 0, (GInstanceInitFunc) geary_imap_status_data_instance_init, NULL };
	GType geary_imap_status_data_type_id;
	geary_imap_status_data_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyImapStatusData", &g_define_type_info, 0);
	GearyImapStatusData_private_offset = g_type_add_instance_private (geary_imap_status_data_type_id, sizeof (GearyImapStatusDataPrivate));
	return geary_imap_status_data_type_id;
}

GType
geary_imap_status_data_get_type (void)
{
	static gsize geary_imap_status_data_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_status_data_type_id__once)) {
		GType geary_imap_status_data_type_id;
		geary_imap_status_data_type_id = geary_imap_status_data_get_type_once ();
		g_once_init_leave (&geary_imap_status_data_type_id__once, geary_imap_status_data_type_id);
	}
	return geary_imap_status_data_type_id__once;
}

static void
_vala_geary_imap_status_data_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapStatusData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STATUS_DATA, GearyImapStatusData);
	switch (property_id) {
		case GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY:
		g_value_set_object (value, geary_imap_status_data_get_mailbox (self));
		break;
		case GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY:
		g_value_set_int (value, geary_imap_status_data_get_messages (self));
		break;
		case GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY:
		g_value_set_int (value, geary_imap_status_data_get_recent (self));
		break;
		case GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY:
		g_value_set_object (value, geary_imap_status_data_get_uid_next (self));
		break;
		case GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY:
		g_value_set_object (value, geary_imap_status_data_get_uid_validity (self));
		break;
		case GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY:
		g_value_set_int (value, geary_imap_status_data_get_unseen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_status_data_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapStatusData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STATUS_DATA, GearyImapStatusData);
	switch (property_id) {
		case GEARY_IMAP_STATUS_DATA_MAILBOX_PROPERTY:
		geary_imap_status_data_set_mailbox (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_STATUS_DATA_MESSAGES_PROPERTY:
		geary_imap_status_data_set_messages (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_STATUS_DATA_RECENT_PROPERTY:
		geary_imap_status_data_set_recent (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_STATUS_DATA_UID_NEXT_PROPERTY:
		geary_imap_status_data_set_uid_next (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_STATUS_DATA_UID_VALIDITY_PROPERTY:
		geary_imap_status_data_set_uid_validity (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_STATUS_DATA_UNSEEN_PROPERTY:
		geary_imap_status_data_set_unseen (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

