/* imap-deserializer.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-deserializer.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2019-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>

#define GEARY_IMAP_DESERIALIZER_MAX_BLOCK_READ_SIZE ((gsize) 4096)

enum  {
	GEARY_IMAP_DESERIALIZER_0_PROPERTY,
	GEARY_IMAP_DESERIALIZER_LOGGING_PARENT_PROPERTY,
	GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY,
	GEARY_IMAP_DESERIALIZER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_deserializer_properties[GEARY_IMAP_DESERIALIZER_NUM_PROPERTIES];
typedef enum  {
	GEARY_IMAP_DESERIALIZER_MODE_LINE,
	GEARY_IMAP_DESERIALIZER_MODE_BLOCK,
	GEARY_IMAP_DESERIALIZER_MODE_FAILED,
	GEARY_IMAP_DESERIALIZER_MODE_CLOSED
} GearyImapDeserializerMode;

#define GEARY_IMAP_DESERIALIZER_TYPE_MODE (geary_imap_deserializer_mode_get_type ())
typedef enum  {
	GEARY_IMAP_DESERIALIZER_STATE_TAG,
	GEARY_IMAP_DESERIALIZER_STATE_START_PARAM,
	GEARY_IMAP_DESERIALIZER_STATE_ATOM,
	GEARY_IMAP_DESERIALIZER_STATE_FLAG,
	GEARY_IMAP_DESERIALIZER_STATE_QUOTED,
	GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE,
	GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM,
	GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING,
	GEARY_IMAP_DESERIALIZER_STATE_LITERAL,
	GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN,
	GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA,
	GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT,
	GEARY_IMAP_DESERIALIZER_STATE_FAILED,
	GEARY_IMAP_DESERIALIZER_STATE_CLOSED,
	GEARY_IMAP_DESERIALIZER_STATE_COUNT
} GearyImapDeserializerState;

#define GEARY_IMAP_DESERIALIZER_TYPE_STATE (geary_imap_deserializer_state_get_type ())
typedef enum  {
	GEARY_IMAP_DESERIALIZER_EVENT_CHAR,
	GEARY_IMAP_DESERIALIZER_EVENT_EOL,
	GEARY_IMAP_DESERIALIZER_EVENT_DATA,
	GEARY_IMAP_DESERIALIZER_EVENT_EOS,
	GEARY_IMAP_DESERIALIZER_EVENT_ERROR,
	GEARY_IMAP_DESERIALIZER_EVENT_COUNT
} GearyImapDeserializerEvent;

#define GEARY_IMAP_DESERIALIZER_TYPE_EVENT (geary_imap_deserializer_event_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyImapDeserializerStartAsyncData GearyImapDeserializerStartAsyncData;
typedef struct _GearyImapDeserializerStopAsyncData GearyImapDeserializerStopAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GEARY_IMAP_DESERIALIZER_PARAMETERS_READY_SIGNAL,
	GEARY_IMAP_DESERIALIZER_BYTES_RECEIVED_SIGNAL,
	GEARY_IMAP_DESERIALIZER_DESERIALIZE_FAILURE_SIGNAL,
	GEARY_IMAP_DESERIALIZER_RECEIVE_FAILURE_SIGNAL,
	GEARY_IMAP_DESERIALIZER_END_OF_STREAM_SIGNAL,
	GEARY_IMAP_DESERIALIZER_NUM_SIGNALS
};
static guint geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyImapDeserializerPrivate {
	GearyLoggingSource* _logging_parent;
	GearyImapQuirks* _quirks;
	gchar* identifier;
	GDataInputStream* input;
	GearyStateMachine* fsm;
	GearyImapListParameter* context;
	GeeLinkedList* context_stack;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* closed_semaphore;
	GString* current_string;
	gsize literal_length_remaining;
	GearyMemoryGrowableBuffer* block_buffer;
	guint8* current_buffer;
	gint current_buffer_length1;
	gint _current_buffer_size_;
	gint ins_priority;
	gboolean is_parsing_flags;
};

struct _GearyImapDeserializerStartAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDeserializer* self;
	gint priority;
	GCancellable* _tmp0_;
	GError* _tmp1_;
	GearyImapDeserializerMode mode;
	GError* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GCancellable* _tmp8_;
	GError* _inner_error0_;
};

struct _GearyImapDeserializerStopAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDeserializer* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GearyNonblockingSemaphore* _tmp5_;
	GDataInputStream* _tmp6_;
	GError* _inner_error0_;
};

static gint GearyImapDeserializer_private_offset;
static gpointer geary_imap_deserializer_parent_class = NULL;
static GearyStateMachineDescriptor* geary_imap_deserializer_machine_desc;
static GearyStateMachineDescriptor* geary_imap_deserializer_machine_desc = NULL;
static GearyLoggingSourceIface * geary_imap_deserializer_geary_logging_source_parent_iface = NULL;

static GType geary_imap_deserializer_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType geary_imap_deserializer_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType geary_imap_deserializer_event_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* geary_imap_deserializer_state_to_string (guint state);
static gchar* geary_imap_deserializer_event_to_string (guint event);
static gchar* _geary_imap_deserializer_state_to_string_geary_state_state_event_to_string (guint state_or_event,
                                                                                   gpointer self);
static gchar* _geary_imap_deserializer_event_to_string_geary_state_state_event_to_string (guint state_or_event,
                                                                                   gpointer self);
VALA_EXTERN GearyImapQuirks* geary_imap_deserializer_get_quirks (GearyImapDeserializer* self);
VALA_EXTERN void geary_imap_deserializer_set_quirks (GearyImapDeserializer* self,
                                         GearyImapQuirks* value);
static guint geary_imap_deserializer_on_tag_char (GearyImapDeserializer* self,
                                           guint state,
                                           guint event,
                                           void* user);
static guint _geary_imap_deserializer_on_tag_char_geary_state_transition (guint state,
                                                                   guint event,
                                                                   void* user,
                                                                   GObject* object,
                                                                   GError* err,
                                                                   gpointer self);
static guint geary_imap_deserializer_on_eos (GearyImapDeserializer* self);
static guint _geary_imap_deserializer_on_eos_geary_state_transition (guint state,
                                                              guint event,
                                                              void* user,
                                                              GObject* object,
                                                              GError* err,
                                                              gpointer self);
static guint geary_imap_deserializer_on_error (GearyImapDeserializer* self,
                                        guint state,
                                        guint event,
                                        void* user,
                                        GObject* object,
                                        GError* err);
static guint _geary_imap_deserializer_on_error_geary_state_transition (guint state,
                                                                guint event,
                                                                void* user,
                                                                GObject* object,
                                                                GError* err,
                                                                gpointer self);
static guint geary_imap_deserializer_on_first_param_char (GearyImapDeserializer* self,
                                                   guint state,
                                                   guint event,
                                                   void* user);
static guint _geary_imap_deserializer_on_first_param_char_geary_state_transition (guint state,
                                                                           guint event,
                                                                           void* user,
                                                                           GObject* object,
                                                                           GError* err,
                                                                           gpointer self);
static guint geary_imap_deserializer_on_eol (GearyImapDeserializer* self,
                                      guint state,
                                      guint event,
                                      void* user);
static guint _geary_imap_deserializer_on_eol_geary_state_transition (guint state,
                                                              guint event,
                                                              void* user,
                                                              GObject* object,
                                                              GError* err,
                                                              gpointer self);
static guint geary_imap_deserializer_on_atom_char (GearyImapDeserializer* self,
                                            guint state,
                                            guint event,
                                            void* user);
static guint _geary_imap_deserializer_on_atom_char_geary_state_transition (guint state,
                                                                    guint event,
                                                                    void* user,
                                                                    GObject* object,
                                                                    GError* err,
                                                                    gpointer self);
static guint geary_imap_deserializer_on_param_eol (GearyImapDeserializer* self,
                                            guint state,
                                            guint event,
                                            void* user);
static guint _geary_imap_deserializer_on_param_eol_geary_state_transition (guint state,
                                                                    guint event,
                                                                    void* user,
                                                                    GObject* object,
                                                                    GError* err,
                                                                    gpointer self);
static guint geary_imap_deserializer_on_flag_char (GearyImapDeserializer* self,
                                            guint state,
                                            guint event,
                                            void* user);
static guint _geary_imap_deserializer_on_flag_char_geary_state_transition (guint state,
                                                                    guint event,
                                                                    void* user,
                                                                    GObject* object,
                                                                    GError* err,
                                                                    gpointer self);
static guint geary_imap_deserializer_on_quoted_char (GearyImapDeserializer* self,
                                              guint state,
                                              guint event,
                                              void* user);
static guint _geary_imap_deserializer_on_quoted_char_geary_state_transition (guint state,
                                                                      guint event,
                                                                      void* user,
                                                                      GObject* object,
                                                                      GError* err,
                                                                      gpointer self);
static guint geary_imap_deserializer_on_quoted_escape_char (GearyImapDeserializer* self,
                                                     guint state,
                                                     guint event,
                                                     void* user);
static guint _geary_imap_deserializer_on_quoted_escape_char_geary_state_transition (guint state,
                                                                             guint event,
                                                                             void* user,
                                                                             GObject* object,
                                                                             GError* err,
                                                                             gpointer self);
static guint geary_imap_deserializer_on_partial_body_atom_char (GearyImapDeserializer* self,
                                                         guint state,
                                                         guint event,
                                                         void* user);
static guint _geary_imap_deserializer_on_partial_body_atom_char_geary_state_transition (guint state,
                                                                                 guint event,
                                                                                 void* user,
                                                                                 GObject* object,
                                                                                 GError* err,
                                                                                 gpointer self);
static guint geary_imap_deserializer_on_partial_body_atom_terminating_char (GearyImapDeserializer* self,
                                                                     guint state,
                                                                     guint event,
                                                                     void* user);
static guint _geary_imap_deserializer_on_partial_body_atom_terminating_char_geary_state_transition (guint state,
                                                                                             guint event,
                                                                                             void* user,
                                                                                             GObject* object,
                                                                                             GError* err,
                                                                                             gpointer self);
static guint geary_imap_deserializer_on_literal_char (GearyImapDeserializer* self,
                                               guint state,
                                               guint event,
                                               void* user);
static guint _geary_imap_deserializer_on_literal_char_geary_state_transition (guint state,
                                                                       guint event,
                                                                       void* user,
                                                                       GObject* object,
                                                                       GError* err,
                                                                       gpointer self);
static guint geary_imap_deserializer_on_literal_data_begin_eol (GearyImapDeserializer* self,
                                                         guint state,
                                                         guint event,
                                                         void* user);
static guint _geary_imap_deserializer_on_literal_data_begin_eol_geary_state_transition (guint state,
                                                                                 guint event,
                                                                                 void* user,
                                                                                 GObject* object,
                                                                                 GError* err,
                                                                                 gpointer self);
static guint geary_imap_deserializer_on_literal_data (GearyImapDeserializer* self,
                                               guint state,
                                               guint event,
                                               void* user);
static guint _geary_imap_deserializer_on_literal_data_geary_state_transition (guint state,
                                                                       guint event,
                                                                       void* user,
                                                                       GObject* object,
                                                                       GError* err,
                                                                       gpointer self);
static guint geary_imap_deserializer_on_response_text_char (GearyImapDeserializer* self,
                                                     guint state,
                                                     guint event,
                                                     void* user);
static guint _geary_imap_deserializer_on_response_text_char_geary_state_transition (guint state,
                                                                             guint event,
                                                                             void* user,
                                                                             GObject* object,
                                                                             GError* err,
                                                                             gpointer self);
static guint geary_imap_deserializer_on_failed_eol (GearyImapDeserializer* self,
                                             guint state,
                                             guint event,
                                             void* user);
static guint _geary_imap_deserializer_on_failed_eol_geary_state_transition (guint state,
                                                                     guint event,
                                                                     void* user,
                                                                     GObject* object,
                                                                     GError* err,
                                                                     gpointer self);
static guint _geary_state_nop_geary_state_transition (guint state,
                                               guint event,
                                               void* user,
                                               GObject* object,
                                               GError* err,
                                               gpointer self);
static guint geary_imap_deserializer_on_bad_transition (GearyImapDeserializer* self,
                                                 guint state,
                                                 guint event,
                                                 void* user);
static guint _geary_imap_deserializer_on_bad_transition_geary_state_transition (guint state,
                                                                         guint event,
                                                                         void* user,
                                                                         GObject* object,
                                                                         GError* err,
                                                                         gpointer self);
static void geary_imap_deserializer_reset_params (GearyImapDeserializer* self);
static void geary_imap_deserializer_start_async_data_free (gpointer _data);
static gboolean geary_imap_deserializer_start_async_co (GearyImapDeserializerStartAsyncData* _data_);
static GearyImapDeserializerMode geary_imap_deserializer_get_mode (GearyImapDeserializer* self);
static void geary_imap_deserializer_next_deserialize_step (GearyImapDeserializer* self);
static void geary_imap_deserializer_stop_async_data_free (gpointer _data);
static gboolean geary_imap_deserializer_stop_async_co (GearyImapDeserializerStopAsyncData* _data_);
static void geary_imap_deserializer_stop_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static GearyLoggingState* geary_imap_deserializer_real_to_logging_state (GearyLoggingSource* base);
VALA_EXTERN void geary_imap_deserializer_set_logging_parent (GearyImapDeserializer* self,
                                                 GearyLoggingSource* parent);
static void geary_imap_deserializer_on_read_line (GearyImapDeserializer* self,
                                           GObject* source,
                                           GAsyncResult* _result_);
static void _geary_imap_deserializer_on_read_line_gasync_ready_callback (GObject* source_object,
                                                                  GAsyncResult* res,
                                                                  gpointer self);
static void geary_imap_deserializer_on_read_block (GearyImapDeserializer* self,
                                            GObject* source,
                                            GAsyncResult* _result_);
static void _geary_imap_deserializer_on_read_block_gasync_ready_callback (GObject* source_object,
                                                                   GAsyncResult* res,
                                                                   gpointer self);
static void geary_imap_deserializer_push_eos (GearyImapDeserializer* self);
static void geary_imap_deserializer_push_line (GearyImapDeserializer* self,
                                        const gchar* line,
                                        gsize count);
static void geary_imap_deserializer_push_error (GearyImapDeserializer* self,
                                         GError* err);
static void geary_imap_deserializer_push_data (GearyImapDeserializer* self,
                                        gsize bytes_read);
static inline gboolean geary_imap_deserializer_is_current_string_empty (GearyImapDeserializer* self);
static inline gboolean geary_imap_deserializer_is_current_string_ci (GearyImapDeserializer* self,
                                                       const gchar* cmp);
static inline void geary_imap_deserializer_append_to_string (GearyImapDeserializer* self,
                                               gchar ch);
static void geary_imap_deserializer_save_string_parameter (GearyImapDeserializer* self,
                                                    gboolean quoted);
static void geary_imap_deserializer_save_parameter (GearyImapDeserializer* self,
                                             GearyImapParameter* param);
static void geary_imap_deserializer_save_literal_parameter (GearyImapDeserializer* self);
static void geary_imap_deserializer_push (GearyImapDeserializer* self,
                                   GearyImapListParameter* child);
static gchar geary_imap_deserializer_get_current_context_terminator (GearyImapDeserializer* self);
static GearyImapDeserializerState geary_imap_deserializer_pop (GearyImapDeserializer* self);
static void geary_imap_deserializer_flush_params (GearyImapDeserializer* self);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void geary_imap_deserializer_finalize (GObject * obj);
static GType geary_imap_deserializer_get_type_once (void);
static void _vala_geary_imap_deserializer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_imap_deserializer_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* GEARY_IMAP_DESERIALIZER_RESPONSE_ATOMS[5] = {"OK", "NO", "BAD", "BYE", "PREAUTH"};

static inline gpointer
geary_imap_deserializer_get_instance_private (GearyImapDeserializer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDeserializer_private_offset);
}

 G_GNUC_NO_INLINE static GType
geary_imap_deserializer_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_DESERIALIZER_MODE_LINE, "GEARY_IMAP_DESERIALIZER_MODE_LINE", "line"}, {GEARY_IMAP_DESERIALIZER_MODE_BLOCK, "GEARY_IMAP_DESERIALIZER_MODE_BLOCK", "block"}, {GEARY_IMAP_DESERIALIZER_MODE_FAILED, "GEARY_IMAP_DESERIALIZER_MODE_FAILED", "failed"}, {GEARY_IMAP_DESERIALIZER_MODE_CLOSED, "GEARY_IMAP_DESERIALIZER_MODE_CLOSED", "closed"}, {0, NULL, NULL}};
	GType geary_imap_deserializer_mode_type_id;
	geary_imap_deserializer_mode_type_id = g_enum_register_static ("GearyImapDeserializerMode", values);
	return geary_imap_deserializer_mode_type_id;
}

static GType
geary_imap_deserializer_mode_get_type (void)
{
	static gsize geary_imap_deserializer_mode_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_deserializer_mode_type_id__once)) {
		GType geary_imap_deserializer_mode_type_id;
		geary_imap_deserializer_mode_type_id = geary_imap_deserializer_mode_get_type_once ();
		g_once_init_leave (&geary_imap_deserializer_mode_type_id__once, geary_imap_deserializer_mode_type_id);
	}
	return geary_imap_deserializer_mode_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_imap_deserializer_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_DESERIALIZER_STATE_TAG, "GEARY_IMAP_DESERIALIZER_STATE_TAG", "tag"}, {GEARY_IMAP_DESERIALIZER_STATE_START_PARAM, "GEARY_IMAP_DESERIALIZER_STATE_START_PARAM", "start-param"}, {GEARY_IMAP_DESERIALIZER_STATE_ATOM, "GEARY_IMAP_DESERIALIZER_STATE_ATOM", "atom"}, {GEARY_IMAP_DESERIALIZER_STATE_FLAG, "GEARY_IMAP_DESERIALIZER_STATE_FLAG", "flag"}, {GEARY_IMAP_DESERIALIZER_STATE_QUOTED, "GEARY_IMAP_DESERIALIZER_STATE_QUOTED", "quoted"}, {GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE, "GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE", "quoted-escape"}, {GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM, "GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM", "partial-body-atom"}, {GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING, "GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING", "partial-body-atom-terminating"}, {GEARY_IMAP_DESERIALIZER_STATE_LITERAL, "GEARY_IMAP_DESERIALIZER_STATE_LITERAL", "literal"}, {GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN, "GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN", "literal-data-begin"}, {GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA, "GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA", "literal-data"}, {GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT, "GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT", "response-text"}, {GEARY_IMAP_DESERIALIZER_STATE_FAILED, "GEARY_IMAP_DESERIALIZER_STATE_FAILED", "failed"}, {GEARY_IMAP_DESERIALIZER_STATE_CLOSED, "GEARY_IMAP_DESERIALIZER_STATE_CLOSED", "closed"}, {GEARY_IMAP_DESERIALIZER_STATE_COUNT, "GEARY_IMAP_DESERIALIZER_STATE_COUNT", "count"}, {0, NULL, NULL}};
	GType geary_imap_deserializer_state_type_id;
	geary_imap_deserializer_state_type_id = g_enum_register_static ("GearyImapDeserializerState", values);
	return geary_imap_deserializer_state_type_id;
}

static GType
geary_imap_deserializer_state_get_type (void)
{
	static gsize geary_imap_deserializer_state_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_deserializer_state_type_id__once)) {
		GType geary_imap_deserializer_state_type_id;
		geary_imap_deserializer_state_type_id = geary_imap_deserializer_state_get_type_once ();
		g_once_init_leave (&geary_imap_deserializer_state_type_id__once, geary_imap_deserializer_state_type_id);
	}
	return geary_imap_deserializer_state_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_imap_deserializer_event_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_DESERIALIZER_EVENT_CHAR, "GEARY_IMAP_DESERIALIZER_EVENT_CHAR", "char"}, {GEARY_IMAP_DESERIALIZER_EVENT_EOL, "GEARY_IMAP_DESERIALIZER_EVENT_EOL", "eol"}, {GEARY_IMAP_DESERIALIZER_EVENT_DATA, "GEARY_IMAP_DESERIALIZER_EVENT_DATA", "data"}, {GEARY_IMAP_DESERIALIZER_EVENT_EOS, "GEARY_IMAP_DESERIALIZER_EVENT_EOS", "eos"}, {GEARY_IMAP_DESERIALIZER_EVENT_ERROR, "GEARY_IMAP_DESERIALIZER_EVENT_ERROR", "error"}, {GEARY_IMAP_DESERIALIZER_EVENT_COUNT, "GEARY_IMAP_DESERIALIZER_EVENT_COUNT", "count"}, {0, NULL, NULL}};
	GType geary_imap_deserializer_event_type_id;
	geary_imap_deserializer_event_type_id = g_enum_register_static ("GearyImapDeserializerEvent", values);
	return geary_imap_deserializer_event_type_id;
}

static GType
geary_imap_deserializer_event_get_type (void)
{
	static gsize geary_imap_deserializer_event_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_deserializer_event_type_id__once)) {
		GType geary_imap_deserializer_event_type_id;
		geary_imap_deserializer_event_type_id = geary_imap_deserializer_event_get_type_once ();
		g_once_init_leave (&geary_imap_deserializer_event_type_id__once, geary_imap_deserializer_event_type_id);
	}
	return geary_imap_deserializer_event_type_id__once;
}

static gchar*
geary_imap_deserializer_state_to_string (guint state)
{
	gchar* result;
	result = g_enum_to_string (GEARY_IMAP_DESERIALIZER_TYPE_STATE, (GearyImapDeserializerState) state);
	return result;
}

static gchar*
geary_imap_deserializer_event_to_string (guint event)
{
	gchar* result;
	result = g_enum_to_string (GEARY_IMAP_DESERIALIZER_TYPE_EVENT, (GearyImapDeserializerEvent) event);
	return result;
}

static gchar*
_geary_imap_deserializer_state_to_string_geary_state_state_event_to_string (guint state_or_event,
                                                                            gpointer self)
{
	gchar* result;
	result = geary_imap_deserializer_state_to_string (state_or_event);
	return result;
}

static gchar*
_geary_imap_deserializer_event_to_string_geary_state_state_event_to_string (guint state_or_event,
                                                                            gpointer self)
{
	gchar* result;
	result = geary_imap_deserializer_event_to_string (state_or_event);
	return result;
}

static const gchar*
geary_imap_deserializer_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearyImapDeserializer* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	result = GEARY_IMAP_CLIENT_SERVICE_DESERIALISATION_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_imap_deserializer_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyImapDeserializer* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

GearyImapQuirks*
geary_imap_deserializer_get_quirks (GearyImapDeserializer* self)
{
	GearyImapQuirks* result;
	GearyImapQuirks* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), NULL);
	_tmp0_ = self->priv->_quirks;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_imap_deserializer_set_quirks (GearyImapDeserializer* self,
                                    GearyImapQuirks* value)
{
	GearyImapQuirks* old_value;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	old_value = geary_imap_deserializer_get_quirks (self);
	if (old_value != value) {
		GearyImapQuirks* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_quirks);
		self->priv->_quirks = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_deserializer_properties[GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY]);
	}
}

static guint
_geary_imap_deserializer_on_tag_char_geary_state_transition (guint state,
                                                             guint event,
                                                             void* user,
                                                             GObject* object,
                                                             GError* err,
                                                             gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_tag_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_eos_geary_state_transition (guint state,
                                                        guint event,
                                                        void* user,
                                                        GObject* object,
                                                        GError* err,
                                                        gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_eos ((GearyImapDeserializer*) self);
	return result;
}

static guint
_geary_imap_deserializer_on_error_geary_state_transition (guint state,
                                                          guint event,
                                                          void* user,
                                                          GObject* object,
                                                          GError* err,
                                                          gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_error ((GearyImapDeserializer*) self, state, event, user, object, err);
	return result;
}

static guint
_geary_imap_deserializer_on_first_param_char_geary_state_transition (guint state,
                                                                     guint event,
                                                                     void* user,
                                                                     GObject* object,
                                                                     GError* err,
                                                                     gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_first_param_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_eol_geary_state_transition (guint state,
                                                        guint event,
                                                        void* user,
                                                        GObject* object,
                                                        GError* err,
                                                        gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_eol ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_atom_char_geary_state_transition (guint state,
                                                              guint event,
                                                              void* user,
                                                              GObject* object,
                                                              GError* err,
                                                              gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_atom_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_param_eol_geary_state_transition (guint state,
                                                              guint event,
                                                              void* user,
                                                              GObject* object,
                                                              GError* err,
                                                              gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_param_eol ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_flag_char_geary_state_transition (guint state,
                                                              guint event,
                                                              void* user,
                                                              GObject* object,
                                                              GError* err,
                                                              gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_flag_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_quoted_char_geary_state_transition (guint state,
                                                                guint event,
                                                                void* user,
                                                                GObject* object,
                                                                GError* err,
                                                                gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_quoted_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_quoted_escape_char_geary_state_transition (guint state,
                                                                       guint event,
                                                                       void* user,
                                                                       GObject* object,
                                                                       GError* err,
                                                                       gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_quoted_escape_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_partial_body_atom_char_geary_state_transition (guint state,
                                                                           guint event,
                                                                           void* user,
                                                                           GObject* object,
                                                                           GError* err,
                                                                           gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_partial_body_atom_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_partial_body_atom_terminating_char_geary_state_transition (guint state,
                                                                                       guint event,
                                                                                       void* user,
                                                                                       GObject* object,
                                                                                       GError* err,
                                                                                       gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_partial_body_atom_terminating_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_literal_char_geary_state_transition (guint state,
                                                                 guint event,
                                                                 void* user,
                                                                 GObject* object,
                                                                 GError* err,
                                                                 gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_literal_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_literal_data_begin_eol_geary_state_transition (guint state,
                                                                           guint event,
                                                                           void* user,
                                                                           GObject* object,
                                                                           GError* err,
                                                                           gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_literal_data_begin_eol ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_literal_data_geary_state_transition (guint state,
                                                                 guint event,
                                                                 void* user,
                                                                 GObject* object,
                                                                 GError* err,
                                                                 gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_literal_data ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_response_text_char_geary_state_transition (guint state,
                                                                       guint event,
                                                                       void* user,
                                                                       GObject* object,
                                                                       GError* err,
                                                                       gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_response_text_char ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_imap_deserializer_on_failed_eol_geary_state_transition (guint state,
                                                               guint event,
                                                               void* user,
                                                               GObject* object,
                                                               GError* err,
                                                               gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_failed_eol ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

static guint
_geary_state_nop_geary_state_transition (guint state,
                                         guint event,
                                         void* user,
                                         GObject* object,
                                         GError* err,
                                         gpointer self)
{
	guint result;
	result = geary_state_nop (state, event);
	return result;
}

static guint
_geary_imap_deserializer_on_bad_transition_geary_state_transition (guint state,
                                                                   guint event,
                                                                   void* user,
                                                                   GObject* object,
                                                                   GError* err,
                                                                   gpointer self)
{
	guint result;
	result = geary_imap_deserializer_on_bad_transition ((GearyImapDeserializer*) self, state, event, user);
	return result;
}

GearyImapDeserializer*
geary_imap_deserializer_construct (GType object_type,
                                   const gchar* identifier,
                                   GInputStream* input,
                                   GearyImapQuirks* quirks)
{
	GearyImapDeserializer * self = NULL;
	gchar* _tmp0_;
	GDataInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GearyStateMapping** mappings = NULL;
	GearyStateMapping* _tmp4_;
	GearyStateMapping* _tmp5_;
	GearyStateMapping* _tmp6_;
	GearyStateMapping* _tmp7_;
	GearyStateMapping* _tmp8_;
	GearyStateMapping* _tmp9_;
	GearyStateMapping* _tmp10_;
	GearyStateMapping* _tmp11_;
	GearyStateMapping* _tmp12_;
	GearyStateMapping* _tmp13_;
	GearyStateMapping* _tmp14_;
	GearyStateMapping* _tmp15_;
	GearyStateMapping* _tmp16_;
	GearyStateMapping* _tmp17_;
	GearyStateMapping* _tmp18_;
	GearyStateMapping* _tmp19_;
	GearyStateMapping* _tmp20_;
	GearyStateMapping* _tmp21_;
	GearyStateMapping* _tmp22_;
	GearyStateMapping* _tmp23_;
	GearyStateMapping* _tmp24_;
	GearyStateMapping* _tmp25_;
	GearyStateMapping* _tmp26_;
	GearyStateMapping* _tmp27_;
	GearyStateMapping* _tmp28_;
	GearyStateMapping* _tmp29_;
	GearyStateMapping* _tmp30_;
	GearyStateMapping* _tmp31_;
	GearyStateMapping* _tmp32_;
	GearyStateMapping* _tmp33_;
	GearyStateMapping* _tmp34_;
	GearyStateMapping* _tmp35_;
	GearyStateMapping* _tmp36_;
	GearyStateMapping* _tmp37_;
	GearyStateMapping* _tmp38_;
	GearyStateMapping* _tmp39_;
	GearyStateMapping* _tmp40_;
	GearyStateMapping* _tmp41_;
	GearyStateMapping* _tmp42_;
	GearyStateMapping* _tmp43_;
	GearyStateMapping* _tmp44_;
	GearyStateMapping* _tmp45_;
	GearyStateMapping* _tmp46_;
	GearyStateMapping* _tmp47_;
	GearyStateMapping* _tmp48_;
	GearyStateMapping** _tmp49_;
	gint mappings_length1;
	gint _mappings_size_;
	GearyStateMachineDescriptor* _tmp50_;
	GearyStateMachine* _tmp51_;
	g_return_val_if_fail (identifier != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (input, g_input_stream_get_type ()), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapDeserializer*) geary_base_object_construct (object_type);
	_tmp0_ = g_strdup (identifier);
	_g_free0 (self->priv->identifier);
	self->priv->identifier = _tmp0_;
	_tmp1_ = g_data_input_stream_new (input);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp1_;
	_tmp2_ = self->priv->input;
	g_filter_input_stream_set_close_base_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_filter_input_stream_get_type (), GFilterInputStream), FALSE);
	_tmp3_ = self->priv->input;
	g_data_input_stream_set_newline_type (_tmp3_, G_DATA_STREAM_NEWLINE_TYPE_CR_LF);
	geary_imap_deserializer_set_quirks (self, quirks);
	_tmp4_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_TAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_tag_char_geary_state_transition, self);
	_tmp5_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_TAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp6_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_TAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp7_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_first_param_char_geary_state_transition, self);
	_tmp8_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_eol_geary_state_transition, self);
	_tmp9_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp10_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp11_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_atom_char_geary_state_transition, self);
	_tmp12_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_param_eol_geary_state_transition, self);
	_tmp13_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp14_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp15_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_flag_char_geary_state_transition, self);
	_tmp16_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_param_eol_geary_state_transition, self);
	_tmp17_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp18_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp19_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_quoted_char_geary_state_transition, self);
	_tmp20_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp21_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp22_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_quoted_escape_char_geary_state_transition, self);
	_tmp23_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp24_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp25_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_partial_body_atom_char_geary_state_transition, self);
	_tmp26_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp27_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp28_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_partial_body_atom_terminating_char_geary_state_transition, self);
	_tmp29_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp30_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp31_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_literal_char_geary_state_transition, self);
	_tmp32_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp33_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp34_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_literal_data_begin_eol_geary_state_transition, self);
	_tmp35_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp36_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp37_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA, (guint) GEARY_IMAP_DESERIALIZER_EVENT_DATA, _geary_imap_deserializer_on_literal_data_geary_state_transition, self);
	_tmp38_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp39_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp40_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, _geary_imap_deserializer_on_response_text_char_geary_state_transition, self);
	_tmp41_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_param_eol_geary_state_transition, self);
	_tmp42_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_imap_deserializer_on_eos_geary_state_transition, self);
	_tmp43_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_imap_deserializer_on_error_geary_state_transition, self);
	_tmp44_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, _geary_imap_deserializer_on_failed_eol_geary_state_transition, self);
	_tmp45_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_state_nop_geary_state_transition, NULL);
	_tmp46_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_state_nop_geary_state_transition, NULL);
	_tmp47_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_CLOSED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, _geary_state_nop_geary_state_transition, NULL);
	_tmp48_ = geary_state_mapping_new ((guint) GEARY_IMAP_DESERIALIZER_STATE_CLOSED, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, _geary_state_nop_geary_state_transition, NULL);
	_tmp49_ = g_new0 (GearyStateMapping*, 45 + 1);
	_tmp49_[0] = _tmp4_;
	_tmp49_[1] = _tmp5_;
	_tmp49_[2] = _tmp6_;
	_tmp49_[3] = _tmp7_;
	_tmp49_[4] = _tmp8_;
	_tmp49_[5] = _tmp9_;
	_tmp49_[6] = _tmp10_;
	_tmp49_[7] = _tmp11_;
	_tmp49_[8] = _tmp12_;
	_tmp49_[9] = _tmp13_;
	_tmp49_[10] = _tmp14_;
	_tmp49_[11] = _tmp15_;
	_tmp49_[12] = _tmp16_;
	_tmp49_[13] = _tmp17_;
	_tmp49_[14] = _tmp18_;
	_tmp49_[15] = _tmp19_;
	_tmp49_[16] = _tmp20_;
	_tmp49_[17] = _tmp21_;
	_tmp49_[18] = _tmp22_;
	_tmp49_[19] = _tmp23_;
	_tmp49_[20] = _tmp24_;
	_tmp49_[21] = _tmp25_;
	_tmp49_[22] = _tmp26_;
	_tmp49_[23] = _tmp27_;
	_tmp49_[24] = _tmp28_;
	_tmp49_[25] = _tmp29_;
	_tmp49_[26] = _tmp30_;
	_tmp49_[27] = _tmp31_;
	_tmp49_[28] = _tmp32_;
	_tmp49_[29] = _tmp33_;
	_tmp49_[30] = _tmp34_;
	_tmp49_[31] = _tmp35_;
	_tmp49_[32] = _tmp36_;
	_tmp49_[33] = _tmp37_;
	_tmp49_[34] = _tmp38_;
	_tmp49_[35] = _tmp39_;
	_tmp49_[36] = _tmp40_;
	_tmp49_[37] = _tmp41_;
	_tmp49_[38] = _tmp42_;
	_tmp49_[39] = _tmp43_;
	_tmp49_[40] = _tmp44_;
	_tmp49_[41] = _tmp45_;
	_tmp49_[42] = _tmp46_;
	_tmp49_[43] = _tmp47_;
	_tmp49_[44] = _tmp48_;
	mappings = _tmp49_;
	mappings_length1 = 45;
	_mappings_size_ = mappings_length1;
	_tmp50_ = geary_imap_deserializer_machine_desc;
	_tmp51_ = geary_state_machine_new (_tmp50_, mappings, mappings_length1, _geary_imap_deserializer_on_bad_transition_geary_state_transition, self);
	_g_object_unref0 (self->priv->fsm);
	self->priv->fsm = _tmp51_;
	geary_imap_deserializer_reset_params (self);
	mappings = (_vala_array_free (mappings, mappings_length1, (GDestroyNotify) g_object_unref), NULL);
	return self;
}

GearyImapDeserializer*
geary_imap_deserializer_new (const gchar* identifier,
                             GInputStream* input,
                             GearyImapQuirks* quirks)
{
	return geary_imap_deserializer_construct (GEARY_IMAP_TYPE_DESERIALIZER, identifier, input, quirks);
}

static void
geary_imap_deserializer_start_async_data_free (gpointer _data)
{
	GearyImapDeserializerStartAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDeserializerStartAsyncData, _data_);
}

void
geary_imap_deserializer_start_async (GearyImapDeserializer* self,
                                     gint priority,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyImapDeserializerStartAsyncData* _data_;
	GearyImapDeserializer* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_data_ = g_slice_new0 (GearyImapDeserializerStartAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_deserializer_start_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->priority = priority;
	geary_imap_deserializer_start_async_co (_data_);
}

void
geary_imap_deserializer_start_finish (GearyImapDeserializer* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyImapDeserializerStartAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Begin deserializing IMAP responses from the input stream.
     *
     * Subscribe to the various signals before starting to ensure that all responses are trapped.
     */
static gboolean
geary_imap_deserializer_start_async_co (GearyImapDeserializerStartAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "Deserializer already open");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->mode = geary_imap_deserializer_get_mode (_data_->self);
	if (_data_->mode == GEARY_IMAP_DESERIALIZER_MODE_FAILED) {
		_data_->_tmp2_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_CLOSED, "Deserializer failed");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->mode == GEARY_IMAP_DESERIALIZER_MODE_CLOSED) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->self->priv->cancellable;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->self->priv->cancellable;
			_data_->_tmp4_ = g_cancellable_is_cancelled (_data_->_tmp6_);
		} else {
			_data_->_tmp4_ = FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp4_;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp7_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_CLOSED, "Deserializer closed");
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp8_;
	_data_->self->priv->ins_priority = _data_->priority;
	geary_imap_deserializer_next_deserialize_step (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_deserializer_stop_async_data_free (gpointer _data)
{
	GearyImapDeserializerStopAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDeserializerStopAsyncData, _data_);
}

void
geary_imap_deserializer_stop_async (GearyImapDeserializer* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GearyImapDeserializerStopAsyncData* _data_;
	GearyImapDeserializer* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_data_ = g_slice_new0 (GearyImapDeserializerStopAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_deserializer_stop_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_deserializer_stop_async_co (_data_);
}

void
geary_imap_deserializer_stop_finish (GearyImapDeserializer* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GearyImapDeserializerStopAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_deserializer_stop_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GearyImapDeserializerStopAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_deserializer_stop_async_co (_data_);
}

static gboolean
geary_imap_deserializer_stop_async_co (GearyImapDeserializerStopAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = _data_->self->priv->cancellable;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->self->priv->cancellable;
		_data_->_tmp1_ = g_cancellable_is_cancelled (_data_->_tmp3_);
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = geary_imap_deserializer_is_halted (_data_->self);
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->cancellable;
	g_cancellable_cancel (_data_->_tmp4_);
	_data_->_tmp5_ = _data_->self->priv->closed_semaphore;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), NULL, geary_imap_deserializer_stop_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->input;
	_data_->_state_ = 2;
	g_input_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_input_stream_get_type (), GInputStream), G_PRIORITY_DEFAULT, NULL, geary_imap_deserializer_stop_async_ready, _data_);
	return FALSE;
	_state_2:
	g_input_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_input_stream_get_type (), GInputStream), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Deserializer closed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Determines if the deserializer is closed.
     */
gboolean
geary_imap_deserializer_is_halted (GearyImapDeserializer* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), FALSE);
	switch (geary_imap_deserializer_get_mode (self)) {
		case GEARY_IMAP_DESERIALIZER_MODE_FAILED:
		case GEARY_IMAP_DESERIALIZER_MODE_CLOSED:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_deserializer_real_to_logging_state (GearyLoggingSource* base)
{
	GearyImapDeserializer * self;
	GearyStateMachine* _tmp0_;
	GearyStateMachine* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GearyLoggingState* _tmp6_;
	GearyLoggingState* _tmp7_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	_tmp0_ = self->priv->fsm;
	_tmp1_ = self->priv->fsm;
	_tmp2_ = geary_state_machine_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_state_machine_get_state_string (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

/** Sets the connection's logging parent. */
void
geary_imap_deserializer_set_logging_parent (GearyImapDeserializer* self,
                                            GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

static void
_geary_imap_deserializer_on_read_line_gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self)
{
	geary_imap_deserializer_on_read_line ((GearyImapDeserializer*) self, source_object, res);
	g_object_unref (self);
}

static void
_geary_imap_deserializer_on_read_block_gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self)
{
	geary_imap_deserializer_on_read_block ((GearyImapDeserializer*) self, source_object, res);
	g_object_unref (self);
}

static void
geary_imap_deserializer_next_deserialize_step (GearyImapDeserializer* self)
{
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	switch (geary_imap_deserializer_get_mode (self)) {
		case GEARY_IMAP_DESERIALIZER_MODE_LINE:
		{
			GDataInputStream* _tmp0_;
			GCancellable* _tmp1_;
			_tmp0_ = self->priv->input;
			_tmp1_ = self->priv->cancellable;
			g_data_input_stream_read_line_async (_tmp0_, self->priv->ins_priority, _tmp1_, _geary_imap_deserializer_on_read_line_gasync_ready_callback, g_object_ref (self));
			break;
		}
		case GEARY_IMAP_DESERIALIZER_MODE_BLOCK:
		{
			GearyMemoryGrowableBuffer* _tmp2_;
			GearyMemoryGrowableBuffer* _tmp4_;
			gint _tmp5_ = 0;
			guint8* _tmp6_;
			GDataInputStream* _tmp7_;
			guint8* _tmp8_;
			gint _tmp8__length1;
			GCancellable* _tmp9_;
			_vala_assert (self->priv->literal_length_remaining >= ((gsize) 0), "literal_length_remaining >= 0");
			_tmp2_ = self->priv->block_buffer;
			if (_tmp2_ == NULL) {
				GearyMemoryGrowableBuffer* _tmp3_;
				_tmp3_ = geary_memory_growable_buffer_new ();
				_g_object_unref0 (self->priv->block_buffer);
				self->priv->block_buffer = _tmp3_;
			}
			_tmp4_ = self->priv->block_buffer;
			_tmp6_ = geary_memory_growable_buffer_allocate (_tmp4_, MIN (GEARY_IMAP_DESERIALIZER_MAX_BLOCK_READ_SIZE, self->priv->literal_length_remaining), &_tmp5_);
			self->priv->current_buffer = _tmp6_;
			self->priv->current_buffer_length1 = _tmp5_;
			self->priv->_current_buffer_size_ = self->priv->current_buffer_length1;
			_tmp7_ = self->priv->input;
			_tmp8_ = self->priv->current_buffer;
			_tmp8__length1 = self->priv->current_buffer_length1;
			_tmp9_ = self->priv->cancellable;
			g_input_stream_read_async (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_input_stream_get_type (), GInputStream), _tmp8_, (gsize) _tmp8__length1, self->priv->ins_priority, _tmp9_, _geary_imap_deserializer_on_read_block_gasync_ready_callback, g_object_ref (self));
			break;
		}
		case GEARY_IMAP_DESERIALIZER_MODE_FAILED:
		case GEARY_IMAP_DESERIALIZER_MODE_CLOSED:
		{
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
geary_imap_deserializer_on_read_line (GearyImapDeserializer* self,
                                      GObject* source,
                                      GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail ((source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (source, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_result_, g_async_result_get_type ()));
	{
		gsize bytes_read = 0UL;
		gchar* line = NULL;
		GDataInputStream* _tmp0_;
		gsize _tmp1_ = 0UL;
		gchar* _tmp2_;
		_tmp0_ = self->priv->input;
		_tmp2_ = g_data_input_stream_read_line_finish (_tmp0_, _result_, &_tmp1_, &_inner_error0_);
		bytes_read = _tmp1_;
		line = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (line == NULL) {
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Line EOS");
			geary_imap_deserializer_push_eos (self);
			_g_free0 (line);
			return;
		}
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Line: %s", line);
		g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_BYTES_RECEIVED_SIGNAL], 0, bytes_read);
		geary_imap_deserializer_push_line (self, line, bytes_read);
		_g_free0 (line);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		geary_imap_deserializer_push_error (self, _tmp3_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	geary_imap_deserializer_next_deserialize_step (self);
}

static void
geary_imap_deserializer_on_read_block (GearyImapDeserializer* self,
                                       GObject* source,
                                       GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail ((source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (source, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_result_, g_async_result_get_type ()));
	{
		gsize bytes_read = 0UL;
		GDataInputStream* _tmp0_;
		gboolean _tmp1_ = FALSE;
		GearyMemoryGrowableBuffer* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		_tmp0_ = self->priv->input;
		bytes_read = (gsize) g_input_stream_read_finish (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (bytes_read == ((gsize) 0)) {
			_tmp1_ = self->priv->literal_length_remaining > ((gsize) 0);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Block EOS");
			geary_imap_deserializer_push_eos (self);
			return;
		}
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Block %lub", (gulong) bytes_read);
		g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_BYTES_RECEIVED_SIGNAL], 0, bytes_read);
		_tmp2_ = self->priv->block_buffer;
		_tmp3_ = self->priv->current_buffer;
		_tmp3__length1 = self->priv->current_buffer_length1;
		geary_memory_growable_buffer_trim (_tmp2_, _tmp3_, (gint) _tmp3__length1, bytes_read);
		geary_imap_deserializer_push_data (self, bytes_read);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		geary_imap_deserializer_push_error (self, _tmp4_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	geary_imap_deserializer_next_deserialize_step (self);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
geary_imap_deserializer_push_line (GearyImapDeserializer* self,
                                   const gchar* line,
                                   gsize count)
{
	GearyStateMachine* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail (line != NULL);
	_vala_assert (geary_imap_deserializer_get_mode (self) == GEARY_IMAP_DESERIALIZER_MODE_LINE, "get_mode() == Mode.LINE");
	{
		glong ctr = 0L;
		ctr = (glong) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar ch = '\0';
				GearyStateMachine* _tmp2_;
				if (!_tmp0_) {
					glong _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gsize) ctr) < count)) {
					break;
				}
				ch = string_get (line, ctr);
				if (ch == '\0') {
					continue;
				}
				_tmp2_ = self->priv->fsm;
				if (geary_state_machine_issue (_tmp2_, (guint) GEARY_IMAP_DESERIALIZER_EVENT_CHAR, &ch, NULL, NULL) == ((guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED)) {
					break;
				}
			}
		}
	}
	_tmp3_ = self->priv->fsm;
	geary_state_machine_issue (_tmp3_, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOL, NULL, NULL, NULL);
}

static void
geary_imap_deserializer_push_data (GearyImapDeserializer* self,
                                   gsize bytes_read)
{
	GearyStateMachine* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_vala_assert (geary_imap_deserializer_get_mode (self) == GEARY_IMAP_DESERIALIZER_MODE_BLOCK, "get_mode() == Mode.BLOCK");
	_tmp0_ = self->priv->fsm;
	geary_state_machine_issue (_tmp0_, (guint) GEARY_IMAP_DESERIALIZER_EVENT_DATA, &bytes_read, NULL, NULL);
}

static void
geary_imap_deserializer_push_eos (GearyImapDeserializer* self)
{
	GearyStateMachine* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_tmp0_ = self->priv->fsm;
	geary_state_machine_issue (_tmp0_, (guint) GEARY_IMAP_DESERIALIZER_EVENT_EOS, NULL, NULL, NULL);
}

static void
geary_imap_deserializer_push_error (GearyImapDeserializer* self,
                                    GError* err)
{
	GearyStateMachine* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail (err != NULL);
	_tmp0_ = self->priv->fsm;
	geary_state_machine_issue (_tmp0_, (guint) GEARY_IMAP_DESERIALIZER_EVENT_ERROR, NULL, NULL, err);
}

static GearyImapDeserializerMode
geary_imap_deserializer_get_mode (GearyImapDeserializer* self)
{
	GearyStateMachine* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GearyImapDeserializerMode result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0);
	_tmp0_ = self->priv->fsm;
	_tmp1_ = geary_state_machine_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA:
		{
			result = GEARY_IMAP_DESERIALIZER_MODE_BLOCK;
			return result;
		}
		case GEARY_IMAP_DESERIALIZER_STATE_FAILED:
		{
			result = GEARY_IMAP_DESERIALIZER_MODE_FAILED;
			return result;
		}
		case GEARY_IMAP_DESERIALIZER_STATE_CLOSED:
		{
			result = GEARY_IMAP_DESERIALIZER_MODE_CLOSED;
			return result;
		}
		default:
		{
			result = GEARY_IMAP_DESERIALIZER_MODE_LINE;
			return result;
		}
	}
}

static inline gboolean
geary_imap_deserializer_is_current_string_empty (GearyImapDeserializer* self)
{
	gboolean _tmp0_ = FALSE;
	GString* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), FALSE);
	_tmp1_ = self->priv->current_string;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GString* _tmp2_;
		_tmp2_ = self->priv->current_string;
		_tmp0_ = _tmp2_->len == ((gssize) 0);
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
geary_imap_deserializer_is_current_string_ci (GearyImapDeserializer* self,
                                              const gchar* cmp)
{
	gboolean _tmp0_ = FALSE;
	GString* _tmp1_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), FALSE);
	g_return_val_if_fail (cmp != NULL, FALSE);
	_tmp1_ = self->priv->current_string;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GString* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->current_string;
		_tmp3_ = strlen (cmp);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp2_->len != ((gssize) _tmp4_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->current_string;
	_tmp6_ = _tmp5_->str;
	result = geary_ascii_stri_equal (_tmp6_, cmp);
	return result;
}

static inline void
geary_imap_deserializer_append_to_string (GearyImapDeserializer* self,
                                          gchar ch)
{
	GString* _tmp0_;
	GString* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_tmp0_ = self->priv->current_string;
	if (_tmp0_ == NULL) {
		GString* _tmp1_;
		_tmp1_ = g_string_new ("");
		_g_string_free0 (self->priv->current_string);
		self->priv->current_string = _tmp1_;
	}
	_tmp2_ = self->priv->current_string;
	g_string_append_c (_tmp2_, ch);
}

static void
geary_imap_deserializer_save_string_parameter (GearyImapDeserializer* self,
                                               gboolean quoted)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* str = NULL;
	gchar* _tmp6_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	if (!quoted) {
		_tmp0_ = geary_imap_deserializer_is_current_string_empty (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (quoted) {
		GString* _tmp3_;
		_tmp3_ = self->priv->current_string;
		_tmp2_ = _tmp3_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = "";
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->current_string;
		_tmp5_ = _tmp4_->str;
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp1_);
	str = _tmp6_;
	if (quoted) {
		const gchar* _tmp7_;
		GearyImapQuotedStringParameter* _tmp8_;
		GearyImapQuotedStringParameter* _tmp9_;
		_tmp7_ = str;
		_tmp8_ = geary_imap_quoted_string_parameter_new (_tmp7_);
		_tmp9_ = _tmp8_;
		geary_imap_deserializer_save_parameter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_g_object_unref0 (_tmp9_);
	} else {
		const gchar* _tmp10_;
		_tmp10_ = str;
		if (geary_imap_number_parameter_is_ascii_numeric (_tmp10_, NULL)) {
			const gchar* _tmp11_;
			GearyImapNumberParameter* _tmp12_;
			GearyImapNumberParameter* _tmp13_;
			_tmp11_ = str;
			_tmp12_ = geary_imap_number_parameter_new_from_ascii (_tmp11_);
			_tmp13_ = _tmp12_;
			geary_imap_deserializer_save_parameter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
			_g_object_unref0 (_tmp13_);
		} else {
			const gchar* _tmp14_;
			GearyImapUnquotedStringParameter* _tmp15_;
			GearyImapUnquotedStringParameter* _tmp16_;
			_tmp14_ = str;
			_tmp15_ = geary_imap_unquoted_string_parameter_new (_tmp14_);
			_tmp16_ = _tmp15_;
			geary_imap_deserializer_save_parameter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
			_g_object_unref0 (_tmp16_);
		}
	}
	_g_string_free0 (self->priv->current_string);
	self->priv->current_string = NULL;
	_g_free0 (str);
}

static void
geary_imap_deserializer_save_literal_parameter (GearyImapDeserializer* self)
{
	GearyImapLiteralParameter* literal = NULL;
	GearyMemoryGrowableBuffer* _tmp0_;
	GearyImapLiteralParameter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GearyImapLiteralParameter* _tmp9_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_tmp0_ = self->priv->block_buffer;
	_tmp1_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	literal = _tmp1_;
	_tmp2_ = geary_logging_source_get_logging_domain (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp3_ = _tmp2_;
	if (!geary_logging_is_suppressed_domain (_tmp3_)) {
		GearyImapLiteralParameter* _tmp4_;
		GearyImapStringParameter* _tmp5_;
		GearyImapStringParameter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = literal;
		_tmp5_ = geary_imap_literal_parameter_coerce_to_string_parameter (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp8_ = _tmp7_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp9_ = literal;
	geary_imap_deserializer_save_parameter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_g_object_unref0 (self->priv->block_buffer);
	self->priv->block_buffer = NULL;
	_g_object_unref0 (literal);
}

static void
geary_imap_deserializer_save_parameter (GearyImapDeserializer* self,
                                        GearyImapParameter* param)
{
	GearyImapListParameter* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail (GEARY_IMAP_IS_PARAMETER (param));
	_tmp0_ = self->priv->context;
	geary_imap_list_parameter_add (_tmp0_, param);
}

static void
geary_imap_deserializer_push (GearyImapDeserializer* self,
                              GearyImapListParameter* child)
{
	GearyImapListParameter* _tmp0_;
	GeeLinkedList* _tmp1_;
	GearyImapListParameter* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	g_return_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (child));
	_tmp0_ = self->priv->context;
	geary_imap_list_parameter_add (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (child, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp1_ = self->priv->context_stack;
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, child);
	_tmp2_ = _g_object_ref0 (child);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp2_;
}

static gchar
geary_imap_deserializer_get_current_context_terminator (GearyImapDeserializer* self)
{
	gchar _tmp0_ = '\0';
	GearyImapListParameter* _tmp1_;
	gchar result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), '\0');
	_tmp1_ = self->priv->context;
	if (GEARY_IMAP_IS_RESPONSE_CODE (_tmp1_)) {
		_tmp0_ = ']';
	} else {
		_tmp0_ = ')';
	}
	result = _tmp0_;
	return result;
}

static GearyImapDeserializerState
geary_imap_deserializer_pop (GearyImapDeserializer* self)
{
	GearyImapDeserializerState ret = 0;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GearyImapDeserializerState result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0);
	ret = GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
	_tmp0_ = self->priv->context_stack;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		GearyImapListParameter* _tmp5_;
		GeeLinkedList* _tmp6_;
		gpointer _tmp7_;
		_tmp3_ = self->priv->context_stack;
		_tmp4_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_tmp5_ = (GearyImapListParameter*) _tmp4_;
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->context_stack;
		_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_g_object_unref0 (self->priv->context);
		self->priv->context = (GearyImapListParameter*) _tmp7_;
	} else {
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Attempt to close unopened list/response code");
		ret = GEARY_IMAP_DESERIALIZER_STATE_FAILED;
	}
	result = ret;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
geary_imap_deserializer_flush_params (GearyImapDeserializer* self)
{
	gboolean okay = FALSE;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	okay = TRUE;
	_tmp0_ = self->priv->context_stack;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unclosed list in parameters");
		okay = FALSE;
	}
	if (!geary_imap_deserializer_is_current_string_empty (self)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->literal_length_remaining > ((gsize) 0);
	}
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = bool_to_string (!geary_imap_deserializer_is_current_string_empty (self));
		_tmp5_ = _tmp4_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unfinished parameter: string=%s literal remaining=%lu", _tmp5_, (gulong) self->priv->literal_length_remaining);
		_g_free0 (_tmp5_);
		okay = FALSE;
	}
	if (okay) {
		GearyImapListParameter* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->priv->context;
		_tmp8_ = geary_imap_list_parameter_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp6_ = _tmp9_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GearyImapListParameter* _tmp10_;
		_tmp10_ = self->priv->context;
		g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_PARAMETERS_READY_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEARY_IMAP_TYPE_ROOT_PARAMETERS, GearyImapRootParameters));
	}
	geary_imap_deserializer_reset_params (self);
}

static void
geary_imap_deserializer_reset_params (GearyImapDeserializer* self)
{
	GearyImapRootParameters* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GearyImapListParameter* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_DESERIALIZER (self));
	_tmp0_ = geary_imap_root_parameters_new ();
	_g_object_unref0 (self->priv->context);
	self->priv->context = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	_tmp1_ = self->priv->context_stack;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = self->priv->context_stack;
	_tmp3_ = self->priv->context;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp3_);
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static guint
geary_imap_deserializer_on_first_param_char (GearyImapDeserializer* self,
                                             guint state,
                                             guint event,
                                             void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	switch (ch) {
		case '[':
		{
			GearyImapResponseCode* response_code = NULL;
			GearyImapResponseCode* _tmp0_;
			GearyImapResponseCode* _tmp1_;
			if (self->priv->is_parsing_flags) {
				geary_imap_deserializer_append_to_string (self, ch);
				result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG;
				return result;
			}
			_tmp0_ = geary_imap_response_code_new ();
			response_code = _tmp0_;
			_tmp1_ = response_code;
			geary_imap_deserializer_push (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
			_g_object_unref0 (response_code);
			return result;
		}
		case ']':
		{
			if (ch != geary_imap_deserializer_get_current_context_terminator (self)) {
				geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Received an unexpected closing brace");
				result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
				return result;
			}
			result = (guint) geary_imap_deserializer_pop (self);
			return result;
		}
		case '{':
		{
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL;
			return result;
		}
		case '\"':
		{
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED;
			return result;
		}
		case '(':
		{
			GearyImapListParameter* list = NULL;
			GearyImapListParameter* _tmp2_;
			GearyImapListParameter* _tmp3_;
			_tmp2_ = geary_imap_list_parameter_new ();
			list = _tmp2_;
			_tmp3_ = list;
			geary_imap_deserializer_push (self, _tmp3_);
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
			_g_object_unref0 (list);
			return result;
		}
		case ')':
		{
			if (ch != geary_imap_deserializer_get_current_context_terminator (self)) {
				geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Received an unexpected closing parens");
				result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
				return result;
			}
			self->priv->is_parsing_flags = FALSE;
			result = (guint) geary_imap_deserializer_pop (self);
			return result;
		}
		case '\\':
		{
			geary_imap_deserializer_append_to_string (self, ch);
			self->priv->is_parsing_flags = TRUE;
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG;
			return result;
		}
		case ' ':
		{
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
			return result;
		}
		default:
		{
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			GeeLinkedList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp6_ = self->priv->context_stack;
			_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp8_ = _tmp7_;
			if (_tmp8_ == 1) {
				GearyImapListParameter* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = self->priv->context;
				_tmp10_ = geary_imap_list_parameter_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp5_ = _tmp11_ >= 2;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				GearyImapListParameter* _tmp12_;
				GearyImapParameter* _tmp13_;
				GearyImapParameter* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp12_ = self->priv->context;
				_tmp13_ = geary_imap_list_parameter_get (_tmp12_, 1);
				_tmp14_ = _tmp13_;
				_tmp15_ = geary_imap_parameter_to_string (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_ascii_strup (_tmp16_, (gssize) -1);
				_tmp18_ = _tmp17_;
				_tmp4_ = _vala_string_array_contains (GEARY_IMAP_DESERIALIZER_RESPONSE_ATOMS, G_N_ELEMENTS (GEARY_IMAP_DESERIALIZER_RESPONSE_ATOMS), _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_g_object_unref0 (_tmp14_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				geary_imap_deserializer_append_to_string (self, ch);
				result = (guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT;
				return result;
			} else {
				if (!self->priv->is_parsing_flags) {
					if (geary_imap_data_format_is_atom_special (ch, NULL)) {
						geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Received an invalid atom-char: %c", (gint) ch);
						result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
						return result;
					}
					geary_imap_deserializer_append_to_string (self, ch);
					result = (guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM;
					return result;
				} else {
					GearyImapQuirks* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = self->priv->_quirks;
					_tmp20_ = geary_imap_quirks_get_flag_atom_exceptions (_tmp19_);
					_tmp21_ = _tmp20_;
					if (geary_imap_data_format_is_atom_special (ch, _tmp21_)) {
						geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Received an invalid flag-char: %c", (gint) ch);
						result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
						return result;
					}
					geary_imap_deserializer_append_to_string (self, ch);
					result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG;
					return result;
				}
			}
		}
	}
}

static guint
geary_imap_deserializer_on_tag_char (GearyImapDeserializer* self,
                                     guint state,
                                     guint event,
                                     void* user)
{
	gchar ch = '\0';
	gboolean _tmp0_ = FALSE;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (geary_imap_deserializer_is_current_string_empty (self)) {
		gboolean _tmp1_ = FALSE;
		if (ch == '*') {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ch == '+';
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		geary_imap_deserializer_append_to_string (self, ch);
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG;
		return result;
	}
	if (geary_imap_data_format_is_tag_special (ch, NULL)) {
		geary_imap_deserializer_save_string_parameter (self, FALSE);
		result = geary_imap_deserializer_on_first_param_char (self, state, event, user);
		return result;
	}
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG;
	return result;
}

static guint
geary_imap_deserializer_on_atom_char (GearyImapDeserializer* self,
                                      guint state,
                                      guint event,
                                      void* user)
{
	gchar ch = '\0';
	gboolean _tmp0_ = FALSE;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (ch == '[') {
		gboolean _tmp1_ = FALSE;
		if (geary_imap_deserializer_is_current_string_ci (self, "body")) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = geary_imap_deserializer_is_current_string_ci (self, "body.peek");
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		geary_imap_deserializer_append_to_string (self, ch);
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM;
		return result;
	}
	if (geary_imap_data_format_is_atom_special (ch, NULL)) {
		geary_imap_deserializer_save_string_parameter (self, FALSE);
		result = geary_imap_deserializer_on_first_param_char (self, state, event, user);
		return result;
	}
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_ATOM;
	return result;
}

static guint
geary_imap_deserializer_on_flag_char (GearyImapDeserializer* self,
                                      guint state,
                                      guint event,
                                      void* user)
{
	gchar ch = '\0';
	GearyImapQuirks* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (geary_imap_deserializer_is_current_string_ci (self, "\\")) {
		GearyImapQuirks* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		if (ch == '*') {
			geary_imap_deserializer_append_to_string (self, ch);
			geary_imap_deserializer_save_string_parameter (self, FALSE);
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
			return result;
		}
		_tmp0_ = self->priv->_quirks;
		_tmp1_ = geary_imap_quirks_get_flag_atom_exceptions (_tmp0_);
		_tmp2_ = _tmp1_;
		if (geary_imap_data_format_is_atom_special (ch, _tmp2_)) {
			geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Empty flag atom");
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
			return result;
		}
	}
	_tmp3_ = self->priv->_quirks;
	_tmp4_ = geary_imap_quirks_get_flag_atom_exceptions (_tmp3_);
	_tmp5_ = _tmp4_;
	if (geary_imap_data_format_is_atom_special (ch, _tmp5_)) {
		geary_imap_deserializer_save_string_parameter (self, FALSE);
		result = geary_imap_deserializer_on_first_param_char (self, state, event, user);
		return result;
	}
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FLAG;
	return result;
}

static guint
geary_imap_deserializer_on_eol (GearyImapDeserializer* self,
                                guint state,
                                guint event,
                                void* user)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	geary_imap_deserializer_flush_params (self);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG;
	return result;
}

static guint
geary_imap_deserializer_on_param_eol (GearyImapDeserializer* self,
                                      guint state,
                                      guint event,
                                      void* user)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	geary_imap_deserializer_save_string_parameter (self, FALSE);
	geary_imap_deserializer_flush_params (self);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG;
	return result;
}

static guint
geary_imap_deserializer_on_failed_eol (GearyImapDeserializer* self,
                                       guint state,
                                       guint event,
                                       void* user)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Syntax error, dropping");
	g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_DESERIALIZE_FAILURE_SIGNAL], 0);
	geary_imap_deserializer_reset_params (self);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG;
	return result;
}

static guint
geary_imap_deserializer_on_quoted_char (GearyImapDeserializer* self,
                                        guint state,
                                        guint event,
                                        void* user)
{
	gchar ch = '\0';
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (((gint) ch) > 0x7F) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = ch == '\0';
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ch == '\r';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ch == '\n';
	}
	if (_tmp0_) {
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED;
		return result;
	}
	if (ch == '\\') {
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED_ESCAPE;
		return result;
	}
	if (ch == '\"') {
		geary_imap_deserializer_save_string_parameter (self, TRUE);
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
		return result;
	}
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED;
	return result;
}

static guint
geary_imap_deserializer_on_quoted_escape_char (GearyImapDeserializer* self,
                                               guint state,
                                               guint event,
                                               void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	switch (ch) {
		case '\"':
		case '\\':
		{
			geary_imap_deserializer_append_to_string (self, ch);
			break;
		}
		default:
		break;
	}
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_QUOTED;
	return result;
}

static guint
geary_imap_deserializer_on_partial_body_atom_char (GearyImapDeserializer* self,
                                                   guint state,
                                                   guint event,
                                                   void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	geary_imap_deserializer_append_to_string (self, ch);
	switch (ch) {
		case ']':
		case '>':
		{
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM_TERMINATING;
			return result;
		}
		default:
		{
			result = state;
			return result;
		}
	}
}

static guint
geary_imap_deserializer_on_partial_body_atom_terminating_char (GearyImapDeserializer* self,
                                                               guint state,
                                                               guint event,
                                                               void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (ch != ' ') {
		result = geary_imap_deserializer_on_partial_body_atom_char (self, (guint) GEARY_IMAP_DESERIALIZER_STATE_PARTIAL_BODY_ATOM, event, user);
		return result;
	}
	geary_imap_deserializer_save_string_parameter (self, FALSE);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
	return result;
}

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

static guint
geary_imap_deserializer_on_literal_char (GearyImapDeserializer* self,
                                         guint state,
                                         guint event,
                                         void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	if (ch == '}') {
		GString* _tmp0_;
		const gchar* _tmp1_;
		if (geary_imap_deserializer_is_current_string_empty (self)) {
			geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Empty flag atom");
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
			return result;
		}
		_tmp0_ = self->priv->current_string;
		_tmp1_ = _tmp0_->str;
		self->priv->literal_length_remaining = (gsize) long_parse (_tmp1_, (guint) 0);
		_g_string_free0 (self->priv->current_string);
		self->priv->current_string = NULL;
		if (self->priv->literal_length_remaining < ((gsize) 0)) {
			geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Negative literal data length %lu", (gulong) self->priv->literal_length_remaining);
			result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
			return result;
		}
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA_BEGIN;
		return result;
	}
	if (!g_ascii_isdigit (ch)) {
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL;
		return result;
	}
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL;
	return result;
}

static guint
geary_imap_deserializer_on_literal_data_begin_eol (GearyImapDeserializer* self,
                                                   guint state,
                                                   guint event,
                                                   void* user)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA;
	return result;
}

static guint
geary_imap_deserializer_on_literal_data (GearyImapDeserializer* self,
                                         guint state,
                                         guint event,
                                         void* user)
{
	gsize* bytes_read = NULL;
	gsize* _tmp0_;
	gsize* _tmp1_;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	bytes_read = (gsize*) user;
	_tmp0_ = bytes_read;
	_vala_assert ((*_tmp0_) <= self->priv->literal_length_remaining, "*bytes_read <= literal_length_remaining");
	_tmp1_ = bytes_read;
	self->priv->literal_length_remaining = self->priv->literal_length_remaining - (*_tmp1_);
	if (self->priv->literal_length_remaining > ((gsize) 0)) {
		result = (guint) GEARY_IMAP_DESERIALIZER_STATE_LITERAL_DATA;
		return result;
	}
	geary_imap_deserializer_save_literal_parameter (self);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_START_PARAM;
	return result;
}

static guint
geary_imap_deserializer_on_response_text_char (GearyImapDeserializer* self,
                                               guint state,
                                               guint event,
                                               void* user)
{
	gchar ch = '\0';
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	ch = *((gchar*) user);
	geary_imap_deserializer_append_to_string (self, ch);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_RESPONSE_TEXT;
	return result;
}

static guint
geary_imap_deserializer_on_eos (GearyImapDeserializer* self)
{
	GearyNonblockingSemaphore* _tmp0_;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "EOS");
	geary_imap_deserializer_flush_params (self);
	_tmp0_ = self->priv->closed_semaphore;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_END_OF_STREAM_SIGNAL], 0);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_CLOSED;
	return result;
}

static guint
geary_imap_deserializer_on_error (GearyImapDeserializer* self,
                                  guint state,
                                  guint event,
                                  void* user,
                                  GObject* object,
                                  GError* err)
{
	GearyNonblockingSemaphore* _tmp1_;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	g_return_val_if_fail ((object == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT), 0U);
	_vala_assert (err != NULL, "err != null");
	if (!g_error_matches (err, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
		const gchar* _tmp0_;
		_tmp0_ = err->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Input error: %s", _tmp0_);
		g_signal_emit (self, geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_RECEIVE_FAILURE_SIGNAL], 0, err);
	}
	_tmp1_ = self->priv->closed_semaphore;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_CLOSED;
	return result;
}

static guint
geary_imap_deserializer_on_bad_transition (GearyImapDeserializer* self,
                                           guint state,
                                           guint event,
                                           void* user)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_DESERIALIZER (self), 0U);
	_tmp0_ = geary_imap_deserializer_event_to_string (event);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_deserializer_state_to_string (state);
	_tmp3_ = _tmp2_;
	geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Bad event %s at state %s", _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = (guint) GEARY_IMAP_DESERIALIZER_STATE_FAILED;
	return result;
}

static void
geary_imap_deserializer_class_init (GearyImapDeserializerClass * klass,
                                    gpointer klass_data)
{
	GearyStateMachineDescriptor* _tmp0_;
	geary_imap_deserializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapDeserializer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_deserializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_deserializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_deserializer_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DESERIALIZER_LOGGING_PARENT_PROPERTY, geary_imap_deserializer_properties[GEARY_IMAP_DESERIALIZER_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The quirks being used by this deserializer. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY, geary_imap_deserializer_properties[GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY] = g_param_spec_object ("quirks", "quirks", "quirks", GEARY_IMAP_TYPE_QUIRKS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Fired when a complete set of IMAP {@link Parameter}s have been received.
	     *
	     * Note that {@link RootParameters} may contain {@link QuotedStringParameter}s,
	     * {@link UnquotedStringParameter}s, {@link ResponseCode}, and {@link ListParameter}s.
	     * Deserializer does not produce any other kind of Parameter due to its inability to deduce
	     * them from syntax alone.  ResponseCode, however, can be.
	     *
	     * All strings are ASCII (7-bit) with control characters stripped (with the exception of
	     * {@link QuotedStringParameter} which allows for some control characters).
	     */
	geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_PARAMETERS_READY_SIGNAL] = g_signal_new ("parameters-ready", GEARY_IMAP_TYPE_DESERIALIZER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_IMAP_TYPE_ROOT_PARAMETERS);
	/**
	     * Fired as data blocks are received during download.
	     *
	     * The bytes themselves may be partial and unusable out of context, so they're not provided,
	     * but their size is, to allow monitoring of speed and such.
	     *
	     * Note that this is fired for both line data (i.e. responses, status, etc.) and literal data
	     * (block transfers).
	     *
	     * In general, this signal is provided to inform subscribers that activity is happening
	     * on the receive channel, especially during long downloads.
	     */
	geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_BYTES_RECEIVED_SIGNAL] = g_signal_new ("bytes-received", GEARY_IMAP_TYPE_DESERIALIZER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ULONG, G_TYPE_NONE, 1, G_TYPE_ULONG);
	/**
	     * Fired when a syntax error has occurred.
	     *
	     * This generally means the data looks like garbage and further
	     * deserialization is unlikely or impossible.
	     */
	geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_DESERIALIZE_FAILURE_SIGNAL] = g_signal_new ("deserialize-failure", GEARY_IMAP_TYPE_DESERIALIZER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired when an Error is trapped on the input stream.
	     *
	     * This is nonrecoverable and means the stream should be closed
	     * and this Deserializer destroyed.
	     */
	geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_RECEIVE_FAILURE_SIGNAL] = g_signal_new ("receive-failure", GEARY_IMAP_TYPE_DESERIALIZER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	/**
	     * Fired when the underlying InputStream is closed.
	     *
	     * This is nonrecoverable and means the stream should be closed
	     * and this Deserializer destroyed.
	     */
	geary_imap_deserializer_signals[GEARY_IMAP_DESERIALIZER_END_OF_STREAM_SIGNAL] = g_signal_new ("end-of-stream", GEARY_IMAP_TYPE_DESERIALIZER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = geary_state_machine_descriptor_new ("Geary.Imap.Deserializer", (guint) GEARY_IMAP_DESERIALIZER_STATE_TAG, (guint) GEARY_IMAP_DESERIALIZER_STATE_COUNT, (guint) GEARY_IMAP_DESERIALIZER_EVENT_COUNT, _geary_imap_deserializer_state_to_string_geary_state_state_event_to_string, NULL, _geary_imap_deserializer_event_to_string_geary_state_state_event_to_string, NULL);
	geary_imap_deserializer_machine_desc = _tmp0_;
}

static void
geary_imap_deserializer_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                             gpointer iface_data)
{
	geary_imap_deserializer_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_imap_deserializer_real_to_logging_state;
	iface->get_logging_domain = geary_imap_deserializer_real_get_logging_domain;
	iface->get_logging_parent = geary_imap_deserializer_real_get_logging_parent;
}

static void
geary_imap_deserializer_instance_init (GearyImapDeserializer * self,
                                       gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	self->priv = geary_imap_deserializer_get_instance_private (self);
	self->priv->_logging_parent = NULL;
	_tmp0_ = gee_linked_list_new (GEARY_IMAP_TYPE_LIST_PARAMETER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->context_stack = _tmp0_;
	self->priv->cancellable = NULL;
	_tmp1_ = geary_nonblocking_semaphore_new (NULL);
	self->priv->closed_semaphore = _tmp1_;
	self->priv->current_string = NULL;
	self->priv->literal_length_remaining = (gsize) 0;
	self->priv->block_buffer = NULL;
	self->priv->current_buffer = NULL;
	self->priv->current_buffer_length1 = 0;
	self->priv->_current_buffer_size_ = self->priv->current_buffer_length1;
	self->priv->ins_priority = G_PRIORITY_DEFAULT;
	self->priv->is_parsing_flags = FALSE;
}

static void
geary_imap_deserializer_finalize (GObject * obj)
{
	GearyImapDeserializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	_g_object_unref0 (self->priv->_quirks);
	_g_free0 (self->priv->identifier);
	_g_object_unref0 (self->priv->input);
	_g_object_unref0 (self->priv->fsm);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->context_stack);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->closed_semaphore);
	_g_string_free0 (self->priv->current_string);
	_g_object_unref0 (self->priv->block_buffer);
	G_OBJECT_CLASS (geary_imap_deserializer_parent_class)->finalize (obj);
}

/**
 * The Deserializer performs asynchronous I/O on a supplied input stream and transforms the raw
 * bytes into IMAP {@link Parameter}s (which can then be converted into {@link ServerResponse}s or
 * {@link ServerData}).
 *
 * The Deserializer will only begin reading from the stream when {@link start_async} is called.
 * Calling {@link stop_async} will halt reading without closing the stream itself.  A Deserializer
 * may not be reused once stop_async has been invoked.
 *
 * Since all results from the Deserializer are reported via signals, those signals should be
 * connected to prior to calling start_async, or the caller risks missing early messages.  (Note
 * that since Deserializer uses async I/O, this isn't technically possible unless the signals are
 * connected after the Idle loop has a chance to run; however, this is an implementation detail and
 * shouldn't be relied upon.)
 *
 * Internally Deserializer uses a DataInputStream to help decode the data.  Since DataInputStream
 * is buffered, there's no need to buffer the InputStream passed to Deserializer's constructor.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_deserializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDeserializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_deserializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDeserializer), 0, (GInstanceInitFunc) geary_imap_deserializer_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_imap_deserializer_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_deserializer_type_id;
	geary_imap_deserializer_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapDeserializer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_deserializer_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyImapDeserializer_private_offset = g_type_add_instance_private (geary_imap_deserializer_type_id, sizeof (GearyImapDeserializerPrivate));
	return geary_imap_deserializer_type_id;
}

GType
geary_imap_deserializer_get_type (void)
{
	static gsize geary_imap_deserializer_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_deserializer_type_id__once)) {
		GType geary_imap_deserializer_type_id;
		geary_imap_deserializer_type_id = geary_imap_deserializer_get_type_once ();
		g_once_init_leave (&geary_imap_deserializer_type_id__once, geary_imap_deserializer_type_id);
	}
	return geary_imap_deserializer_type_id__once;
}

static void
_vala_geary_imap_deserializer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapDeserializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	switch (property_id) {
		case GEARY_IMAP_DESERIALIZER_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		case GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY:
		g_value_set_object (value, geary_imap_deserializer_get_quirks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_deserializer_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapDeserializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_DESERIALIZER, GearyImapDeserializer);
	switch (property_id) {
		case GEARY_IMAP_DESERIALIZER_QUIRKS_PROPERTY:
		geary_imap_deserializer_set_quirks (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

