/* memory-file-buffer.c generated by valac 0.56.3, the Vala compiler
 * generated from memory-file-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/*extern Bytes *g_bytes_new_with_free_func(void *data, size_t size, DestroyNotify destroy, void *user);*/

#include "geary-engine.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_MEMORY_FILE_BUFFER_0_PROPERTY,
	GEARY_MEMORY_FILE_BUFFER_SIZE_PROPERTY,
	GEARY_MEMORY_FILE_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_MEMORY_FILE_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_memory_file_buffer_properties[GEARY_MEMORY_FILE_BUFFER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyMemoryFileBufferPrivate {
	GFile* file;
	GMappedFile* mmap;
};

static gint GearyMemoryFileBuffer_private_offset;
static gpointer geary_memory_file_buffer_parent_class = NULL;
static GearyMemoryUnownedBytesBufferIface * geary_memory_file_buffer_geary_memory_unowned_bytes_buffer_parent_iface = NULL;

static GBytes* geary_memory_file_buffer_real_get_bytes (GearyMemoryBuffer* base);
static guint8* geary_memory_file_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                              gint* result_length1);
static void geary_memory_file_buffer_finalize (GObject * obj);
static GType geary_memory_file_buffer_get_type_once (void);
static void _vala_geary_memory_file_buffer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
geary_memory_file_buffer_get_instance_private (GearyMemoryFileBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMemoryFileBuffer_private_offset);
}

static gsize
geary_memory_file_buffer_real_get_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryFileBuffer* self;
	GMappedFile* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	_tmp0_ = self->priv->mmap;
	result = g_mapped_file_get_length (_tmp0_);
	return result;
}

static gsize
geary_memory_file_buffer_real_get_allocated_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryFileBuffer* self;
	GMappedFile* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	_tmp0_ = self->priv->mmap;
	result = g_mapped_file_get_length (_tmp0_);
	return result;
}

/**
     * The File is immediately opened when this is called.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyMemoryFileBuffer*
geary_memory_file_buffer_construct (GType object_type,
                                    GFile* file,
                                    gboolean readonly,
                                    GError** error)
{
	GearyMemoryFileBuffer * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp4_;
	GMappedFile* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GMappedFile* _tmp8_;
	GMappedFile* _tmp9_;
	GMappedFile* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (GearyMemoryFileBuffer*) geary_memory_buffer_construct (object_type);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "File for Geary.Memory.FileBuffer not found");
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp4_;
	_tmp6_ = g_file_get_path (file);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_mapped_file_new (_tmp7_, !readonly, &_inner_error0_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp5_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp10_ = _tmp5_;
	_tmp5_ = NULL;
	_g_mapped_file_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp10_;
	_g_mapped_file_unref0 (_tmp5_);
	return self;
}

GearyMemoryFileBuffer*
geary_memory_file_buffer_new (GFile* file,
                              gboolean readonly,
                              GError** error)
{
	return geary_memory_file_buffer_construct (GEARY_MEMORY_TYPE_FILE_BUFFER, file, readonly, error);
}

static gpointer
_g_mapped_file_ref0 (gpointer self)
{
	return self ? g_mapped_file_ref (self) : NULL;
}

static GBytes*
geary_memory_file_buffer_real_get_bytes (GearyMemoryBuffer* base)
{
	GearyMemoryFileBuffer * self;
	gint _tmp0_ = 0;
	guint8* _tmp1_;
	GMappedFile* _tmp2_;
	GMappedFile* _tmp3_;
	GBytes* _tmp4_;
	GBytes* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	_tmp1_ = geary_memory_unowned_bytes_buffer_to_unowned_uint8_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, GearyMemoryUnownedBytesBuffer), &_tmp0_);
	_tmp2_ = self->priv->mmap;
	_tmp3_ = _g_mapped_file_ref0 (_tmp2_);
	_tmp4_ = g_bytes_new_with_free_func (_tmp1_, (gsize) _tmp0_, g_mapped_file_unref, _tmp3_);
	result = _tmp4_;
	return result;
}

static guint8*
geary_memory_file_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                      gint* result_length1)
{
	GearyMemoryFileBuffer * self;
	guint8* buffer = NULL;
	GMappedFile* _tmp0_;
	gchar* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	GMappedFile* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	buffer = (guint8*) _tmp1_;
	buffer_length1 = sizeof (gchar) / sizeof (guint8);
	_buffer_size_ = buffer_length1;
	_tmp2_ = self->priv->mmap;
	buffer_length1 = (gint) g_mapped_file_get_length (_tmp2_);
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
geary_memory_file_buffer_class_init (GearyMemoryFileBufferClass * klass,
                                     gpointer klass_data)
{
	geary_memory_file_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMemoryFileBuffer_private_offset);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_memory_file_buffer_real_get_bytes;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_size = geary_memory_file_buffer_real_get_size;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_allocated_size = geary_memory_file_buffer_real_get_allocated_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_memory_file_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_memory_file_buffer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_FILE_BUFFER_SIZE_PROPERTY, geary_memory_file_buffer_properties[GEARY_MEMORY_FILE_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_FILE_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_memory_file_buffer_properties[GEARY_MEMORY_FILE_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_memory_file_buffer_geary_memory_unowned_bytes_buffer_interface_init (GearyMemoryUnownedBytesBufferIface * iface,
                                                                           gpointer iface_data)
{
	geary_memory_file_buffer_geary_memory_unowned_bytes_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_uint8_array = (guint8* (*) (GearyMemoryUnownedBytesBuffer*, gint*)) geary_memory_file_buffer_real_to_unowned_uint8_array;
}

static void
geary_memory_file_buffer_instance_init (GearyMemoryFileBuffer * self,
                                        gpointer klass)
{
	self->priv = geary_memory_file_buffer_get_instance_private (self);
}

static void
geary_memory_file_buffer_finalize (GObject * obj)
{
	GearyMemoryFileBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	_g_object_unref0 (self->priv->file);
	_g_mapped_file_unref0 (self->priv->mmap);
	G_OBJECT_CLASS (geary_memory_file_buffer_parent_class)->finalize (obj);
}

/**
 * Makes a file available as a {@link Memory.Buffer}.
 */
 G_GNUC_NO_INLINE static GType
geary_memory_file_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryFileBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_file_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMemoryFileBuffer), 0, (GInstanceInitFunc) geary_memory_file_buffer_instance_init, NULL };
	static const GInterfaceInfo geary_memory_unowned_bytes_buffer_info = { (GInterfaceInitFunc) geary_memory_file_buffer_geary_memory_unowned_bytes_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_memory_file_buffer_type_id;
	geary_memory_file_buffer_type_id = g_type_register_static (GEARY_MEMORY_TYPE_BUFFER, "GearyMemoryFileBuffer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_memory_file_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, &geary_memory_unowned_bytes_buffer_info);
	GearyMemoryFileBuffer_private_offset = g_type_add_instance_private (geary_memory_file_buffer_type_id, sizeof (GearyMemoryFileBufferPrivate));
	return geary_memory_file_buffer_type_id;
}

GType
geary_memory_file_buffer_get_type (void)
{
	static gsize geary_memory_file_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_file_buffer_type_id__once)) {
		GType geary_memory_file_buffer_type_id;
		geary_memory_file_buffer_type_id = geary_memory_file_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_file_buffer_type_id__once, geary_memory_file_buffer_type_id);
	}
	return geary_memory_file_buffer_type_id__once;
}

static void
_vala_geary_memory_file_buffer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearyMemoryFileBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MEMORY_TYPE_FILE_BUFFER, GearyMemoryFileBuffer);
	switch (property_id) {
		case GEARY_MEMORY_FILE_BUFFER_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		case GEARY_MEMORY_FILE_BUFFER_ALLOCATED_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_allocated_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

