/* util-iterable.c generated by valac 0.56.3, the Vala compiler
 * generated from util-iterable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdarg.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GEARY_ITERABLE_0_PROPERTY,
	GEARY_ITERABLE_G_TYPE,
	GEARY_ITERABLE_G_DUP_FUNC,
	GEARY_ITERABLE_G_DESTROY_FUNC,
	GEARY_ITERABLE_NUM_PROPERTIES
};
static GParamSpec* geary_iterable_properties[GEARY_ITERABLE_NUM_PROPERTIES];
typedef struct _Block119Data Block119Data;
typedef struct _Block120Data Block120Data;

#define GEARY_ITERABLE_TYPE_GEE_ITERABLE (geary_iterable_gee_iterable_get_type ())
#define GEARY_ITERABLE_GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterable))
#define GEARY_ITERABLE_GEE_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterableClass))
#define GEARY_ITERABLE_IS_GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_ITERABLE_TYPE_GEE_ITERABLE))
#define GEARY_ITERABLE_IS_GEE_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_ITERABLE_TYPE_GEE_ITERABLE))
#define GEARY_ITERABLE_GEE_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterableClass))

typedef struct _GearyIterableGeeIterable GearyIterableGeeIterable;
typedef struct _GearyIterableGeeIterableClass GearyIterableGeeIterableClass;
typedef struct _GearyIterableGeeIterablePrivate GearyIterableGeeIterablePrivate;
enum  {
	GEARY_ITERABLE_GEE_ITERABLE_0_PROPERTY,
	GEARY_ITERABLE_GEE_ITERABLE_G_TYPE,
	GEARY_ITERABLE_GEE_ITERABLE_G_DUP_FUNC,
	GEARY_ITERABLE_GEE_ITERABLE_G_DESTROY_FUNC,
	GEARY_ITERABLE_GEE_ITERABLE_NUM_PROPERTIES
};
static GParamSpec* geary_iterable_gee_iterable_properties[GEARY_ITERABLE_GEE_ITERABLE_NUM_PROPERTIES];

struct _GearyIterablePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeIterator* i;
};

struct _Block119Data {
	int _ref_count_;
	GearyIterable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
};

struct _Block120Data {
	int _ref_count_;
	GearyIterable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
};

struct _GearyIterableGeeIterable {
	GearyBaseObject parent_instance;
	GearyIterableGeeIterablePrivate * priv;
};

struct _GearyIterableGeeIterableClass {
	GearyBaseObjectClass parent_class;
	gboolean (*foreach) (GearyIterableGeeIterable* self, GeeForallFunc f, gpointer f_target);
};

struct _GearyIterableGeeIterablePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeIterator* i;
};

static gint GearyIterable_private_offset;
static gpointer geary_iterable_parent_class = NULL;
static gint GearyIterableGeeIterable_private_offset;
static gpointer geary_iterable_gee_iterable_parent_class = NULL;
static GeeTraversableIface * geary_iterable_gee_iterable_gee_traversable_parent_iface = NULL;
static GeeIterableIface * geary_iterable_gee_iterable_gee_iterable_parent_iface = NULL;

VALA_EXTERN GearyIterable* geary_iterable_new (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   GeeIterator* iterator);
VALA_EXTERN GearyIterable* geary_iterable_construct (GType object_type,
                                         GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         GeeIterator* iterator);
static GeeIterator* geary_iterable_real_iterator (GearyIterable* self);
static Block119Data* block119_data_ref (Block119Data* _data119_);
static void block119_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block119Data* _data119_,
                     gconstpointer g);
static gboolean ___lambda7__gee_predicate (gconstpointer g,
                                    gpointer self);
static Block120Data* block120_data_ref (Block120Data* _data120_);
static void block120_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block120Data* _data120_,
                     gconstpointer g);
static gboolean ___lambda8__gee_predicate (gconstpointer g,
                                    gpointer self);
static gpointer __lambda9_ (Block120Data* _data120_,
                     gpointer g);
static gpointer ___lambda9__gee_map_func (gpointer g,
                                   gpointer self);
static GearyIterableGeeIterable* geary_iterable_gee_iterable_new (GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeeIterator* iterator);
static GearyIterableGeeIterable* geary_iterable_gee_iterable_construct (GType object_type,
                                                                 GType g_type,
                                                                 GBoxedCopyFunc g_dup_func,
                                                                 GDestroyNotify g_destroy_func,
                                                                 GeeIterator* iterator);
static GType geary_iterable_gee_iterable_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean geary_iterable_gee_iterable_foreach (GearyIterableGeeIterable* self,
                                              GeeForallFunc f,
                                              gpointer f_target);
static GeeIterator* geary_iterable_gee_iterable_real_iterator (GeeIterable* base);
static gboolean geary_iterable_gee_iterable_real_foreach (GearyIterableGeeIterable* self,
                                                   GeeForallFunc f,
                                                   gpointer f_target);
static void geary_iterable_gee_iterable_finalize (GObject * obj);
static GType geary_iterable_gee_iterable_get_type_once (void);
static void _vala_geary_iterable_gee_iterable_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_geary_iterable_gee_iterable_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void geary_iterable_finalize (GObject * obj);
static GType geary_iterable_get_type_once (void);
static void _vala_geary_iterable_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_geary_iterable_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

/**
     * Take a Gee object and return a Geary.Iterable for convenience.
     */
GearyIterable*
geary_traverse (GType g_type,
                GBoxedCopyFunc g_dup_func,
                GDestroyNotify g_destroy_func,
                GeeIterable* i)
{
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	GearyIterable* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (i, GEE_TYPE_ITERABLE), NULL);
	_tmp0_ = gee_iterable_iterator (i);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Take some non-null items (all must be of type G) and return a
     * Geary.Iterable for convenience.
     */
GearyIterable*
geary_iterate (GType g_type,
               GBoxedCopyFunc g_dup_func,
               GDestroyNotify g_destroy_func,
               gconstpointer g,
               ...)
{
	va_list args = {0};
	gpointer arg = NULL;
	gpointer _tmp0_;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp8_;
	GearyIterable* _tmp9_;
	GearyIterable* result;
	va_start (args, g);
	_tmp0_ = ((g != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) g) : ((gpointer) g);
	arg = _tmp0_;
	_tmp1_ = gee_linked_list_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL);
	list = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			GeeLinkedList* _tmp6_;
			gconstpointer _tmp7_;
			if (!_tmp2_) {
				gconstpointer _tmp3_;
				gpointer _tmp4_;
				gconstpointer _tmp5_;
				_tmp3_ = va_arg (args, gpointer);
				_tmp4_ = ((_tmp3_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
				((arg == NULL) || (g_destroy_func == NULL)) ? NULL : (arg = (g_destroy_func (arg), NULL));
				arg = _tmp4_;
				_tmp5_ = arg;
				if (!(_tmp5_ != NULL)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp6_ = list;
			_tmp7_ = arg;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
		}
	}
	_tmp8_ = list;
	_tmp9_ = geary_traverse (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
	result = _tmp9_;
	_g_object_unref0 (list);
	((arg == NULL) || (g_destroy_func == NULL)) ? NULL : (arg = (g_destroy_func (arg), NULL));
	va_end (args);
	return result;
}

/**
     * Take an array of items and return a Geary.Iterable for convenience.
     */
GearyIterable*
geary_iterate_array (GType g_type,
                     GBoxedCopyFunc g_dup_func,
                     GDestroyNotify g_destroy_func,
                     gpointer* a,
                     gint a_length1,
                     GeeEqualDataFunc equal_func,
                     gpointer equal_func_target,
                     GDestroyNotify equal_func_target_destroy_notify)
{
	GeeLinkedList* list = NULL;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeLinkedList* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* result;
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp1_ = gee_linked_list_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	list = _tmp1_;
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_COLLECTION, GeeCollection), a, (gint) a_length1);
	_tmp2_ = geary_traverse (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ITERABLE, GeeIterable));
	result = _tmp2_;
	_g_object_unref0 (list);
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

static inline gpointer
geary_iterable_get_instance_private (GearyIterable* self)
{
	return G_STRUCT_MEMBER_P (self, GearyIterable_private_offset);
}

/**
     * Internal only constructor.
     *
     * Applications should use {@link traverse}, {@link iterate} or
     * {@link iterate_array} instead.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyIterable*
geary_iterable_construct (GType object_type,
                          GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          GeeIterator* iterator)
{
	GearyIterable * self = NULL;
	GeeIterator* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (iterator, GEE_TYPE_ITERATOR), NULL);
	self = (GearyIterable*) geary_base_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (iterator);
	_g_object_unref0 (self->priv->i);
	self->priv->i = _tmp0_;
	return self;
}

GearyIterable*
geary_iterable_new (GType g_type,
                    GBoxedCopyFunc g_dup_func,
                    GDestroyNotify g_destroy_func,
                    GeeIterator* iterator)
{
	return geary_iterable_construct (GEARY_TYPE_ITERABLE, g_type, g_dup_func, g_destroy_func, iterator);
}

/** Returns the iterable's underlying iterator. */
static GeeIterator*
geary_iterable_real_iterator (GearyIterable* self)
{
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	_tmp0_ = self->priv->i;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeIterator*
geary_iterable_iterator (GearyIterable* self)
{
	GearyIterableClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_klass_ = GEARY_ITERABLE_GET_CLASS (self);
	if (_klass_->iterator) {
		return _klass_->iterator (self);
	}
	return NULL;
}

/**
     * Applies a function to each iterable element.
     *
     * @see Gee.Traversable.map
     */
GearyIterable*
geary_iterable_map (GearyIterable* self,
                    GType a_type,
                    GBoxedCopyFunc a_dup_func,
                    GDestroyNotify a_destroy_func,
                    GeeMapFunc f,
                    gpointer f_target)
{
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GearyIterable* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = self->priv->i;
	_tmp1_ = gee_traversable_map (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, f, f_target);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_iterable_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * Applies a function to each element and previous result.
     *
     * @see Gee.Traversable.scan
     */
GearyIterable*
geary_iterable_scan (GearyIterable* self,
                     GType a_type,
                     GBoxedCopyFunc a_dup_func,
                     GDestroyNotify a_destroy_func,
                     GeeFoldFunc f,
                     gpointer f_target,
                     gpointer seed)
{
	GeeIterator* _tmp0_;
	gpointer _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = self->priv->i;
	_tmp1_ = ((seed != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) seed) : ((gpointer) seed);
	_tmp2_ = gee_traversable_scan (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, f, f_target, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	((seed == NULL) || (a_destroy_func == NULL)) ? NULL : (seed = (a_destroy_func (seed), NULL));
	return result;
}

/**
     * Returns the elements which satisfy the given predicate.
     *
     * @see Gee.Traversable.filter
     */
GearyIterable*
geary_iterable_filter (GearyIterable* self,
                       GeePredicate f,
                       gpointer f_target,
                       GDestroyNotify f_target_destroy_notify)
{
	GeeIterator* _tmp0_;
	GeePredicate _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = self->priv->i;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp1__target_destroy_notify = f_target_destroy_notify;
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_tmp2_ = gee_traversable_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

/**
     * Truncates the start and optionally end of the iterable.
     *
     * @see Gee.Traversable.chop
     */
GearyIterable*
geary_iterable_chop (GearyIterable* self,
                     gint offset,
                     gint length)
{
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GearyIterable* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = self->priv->i;
	_tmp1_ = gee_traversable_chop (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), offset, length);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_iterable_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * Returns the non-null results of a call to {@link map}.
     *
     * @see Gee.Traversable.chop
     */
static Block119Data*
block119_data_ref (Block119Data* _data119_)
{
	g_atomic_int_inc (&_data119_->_ref_count_);
	return _data119_;
}

static void
block119_data_unref (void * _userdata_)
{
	Block119Data* _data119_;
	_data119_ = (Block119Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data119_->_ref_count_)) {
		GearyIterable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data119_->self;
		a_type = _data119_->a_type;
		a_dup_func = _data119_->a_dup_func;
		a_destroy_func = _data119_->a_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block119Data, _data119_);
	}
}

static gboolean
__lambda7_ (Block119Data* _data119_,
            gconstpointer g)
{
	GearyIterable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean result;
	self = _data119_->self;
	a_type = _data119_->a_type;
	a_dup_func = _data119_->a_dup_func;
	a_destroy_func = _data119_->a_destroy_func;
	result = g != NULL;
	return result;
}

static gboolean
___lambda7__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, g);
	return result;
}

GearyIterable*
geary_iterable_map_nonnull (GearyIterable* self,
                            GType a_type,
                            GBoxedCopyFunc a_dup_func,
                            GDestroyNotify a_destroy_func,
                            GeeMapFunc f,
                            gpointer f_target)
{
	Block119Data* _data119_;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* _tmp6_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_data119_ = g_slice_new0 (Block119Data);
	_data119_->_ref_count_ = 1;
	_data119_->self = g_object_ref (self);
	_data119_->a_type = a_type;
	_data119_->a_dup_func = a_dup_func;
	_data119_->a_destroy_func = a_destroy_func;
	_tmp0_ = self->priv->i;
	_tmp1_ = gee_traversable_map (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, f, f_target);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_traversable_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda7__gee_predicate, block119_data_ref (_data119_), block119_data_unref);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_iterable_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	block119_data_unref (_data119_);
	_data119_ = NULL;
	return result;
}

/**
     * Return only objects of the destination type, as that type.
     *
     * Only works on types derived from Object.
     */
static Block120Data*
block120_data_ref (Block120Data* _data120_)
{
	g_atomic_int_inc (&_data120_->_ref_count_);
	return _data120_;
}

static void
block120_data_unref (void * _userdata_)
{
	Block120Data* _data120_;
	_data120_ = (Block120Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data120_->_ref_count_)) {
		GearyIterable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data120_->self;
		a_type = _data120_->a_type;
		a_dup_func = _data120_->a_dup_func;
		a_destroy_func = _data120_->a_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block120Data, _data120_);
	}
}

static gboolean
__lambda8_ (Block120Data* _data120_,
            gconstpointer g)
{
	GearyIterable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean result;
	self = _data120_->self;
	a_type = _data120_->a_type;
	a_dup_func = _data120_->a_dup_func;
	a_destroy_func = _data120_->a_destroy_func;
	result = g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (g, G_TYPE_OBJECT, GObject)), a_type);
	return result;
}

static gboolean
___lambda8__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda8_ (self, g);
	return result;
}

static gpointer
__lambda9_ (Block120Data* _data120_,
            gpointer g)
{
	GearyIterable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer _tmp0_;
	gpointer result;
	self = _data120_->self;
	a_type = _data120_->a_type;
	a_dup_func = _data120_->a_dup_func;
	a_destroy_func = _data120_->a_destroy_func;
	_tmp0_ = ((((gconstpointer) g) != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) ((gconstpointer) g)) : ((gpointer) ((gconstpointer) g));
	result = _tmp0_;
	((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
	return result;
}

static gpointer
___lambda9__gee_map_func (gpointer g,
                          gpointer self)
{
	gpointer result;
	result = __lambda9_ (self, g);
	return result;
}

GearyIterable*
geary_iterable_cast_object (GearyIterable* self,
                            GType a_type,
                            GBoxedCopyFunc a_dup_func,
                            GDestroyNotify a_destroy_func)
{
	Block120Data* _data120_;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* _tmp6_;
	GearyIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_data120_ = g_slice_new0 (Block120Data);
	_data120_->_ref_count_ = 1;
	_data120_->self = g_object_ref (self);
	_data120_->a_type = a_type;
	_data120_->a_dup_func = a_dup_func;
	_data120_->a_destroy_func = a_destroy_func;
	_tmp0_ = self->priv->i;
	_tmp1_ = gee_traversable_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda8__gee_predicate, block120_data_ref (_data120_), block120_data_unref);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_traversable_map (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_TRAVERSABLE, GeeTraversable), a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ___lambda9__gee_map_func, _data120_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_iterable_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	block120_data_unref (_data120_);
	_data120_ = NULL;
	return result;
}

/** Returns the first element of the iterable. */
gpointer
geary_iterable_first (GearyIterable* self)
{
	gpointer _tmp0_ = NULL;
	GeeIterator* _tmp1_;
	gpointer result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp1_ = self->priv->i;
	if (gee_iterator_next (_tmp1_)) {
		GeeIterator* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->i;
		_tmp3_ = gee_iterator_get (_tmp2_);
		((_tmp0_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_ = (self->priv->g_destroy_func (_tmp0_), NULL));
		_tmp0_ = _tmp3_;
	} else {
		((_tmp0_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_ = (self->priv->g_destroy_func (_tmp0_), NULL));
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

/** Returns the first element that satisfies the given predicate. */
gpointer
geary_iterable_first_matching (GearyIterable* self,
                               GeePredicate f,
                               gpointer f_target,
                               GDestroyNotify f_target_destroy_notify)
{
	gpointer result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	{
		GeeIterator* _g_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = geary_iterable_iterator (self);
		_g_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer g = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			_tmp1_ = _g_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _g_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			g = _tmp3_;
			_tmp4_ = g;
			if (f (_tmp4_, f_target)) {
				result = g;
				_g_object_unref0 (_g_it);
				(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
				f = NULL;
				f_target = NULL;
				f_target_destroy_notify = NULL;
				return result;
			}
			((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
		}
		_g_object_unref0 (_g_it);
	}
	result = NULL;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

gboolean
geary_iterable_any (GearyIterable* self,
                    GeePredicate f,
                    gpointer f_target,
                    GDestroyNotify f_target_destroy_notify)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), FALSE);
	{
		GeeIterator* _g_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = geary_iterable_iterator (self);
		_g_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer g = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			_tmp1_ = _g_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _g_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			g = _tmp3_;
			_tmp4_ = g;
			if (f (_tmp4_, f_target)) {
				result = TRUE;
				((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
				_g_object_unref0 (_g_it);
				(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
				f = NULL;
				f_target = NULL;
				f_target_destroy_notify = NULL;
				return result;
			}
			((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
		}
		_g_object_unref0 (_g_it);
	}
	result = FALSE;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

gboolean
geary_iterable_all (GearyIterable* self,
                    GeePredicate f,
                    gpointer f_target,
                    GDestroyNotify f_target_destroy_notify)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), FALSE);
	{
		GeeIterator* _g_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = geary_iterable_iterator (self);
		_g_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer g = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			_tmp1_ = _g_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _g_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			g = _tmp3_;
			_tmp4_ = g;
			if (!f (_tmp4_, f_target)) {
				result = FALSE;
				((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
				_g_object_unref0 (_g_it);
				(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
				f = NULL;
				f_target = NULL;
				f_target_destroy_notify = NULL;
				return result;
			}
			((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
		}
		_g_object_unref0 (_g_it);
	}
	result = TRUE;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

gint
geary_iterable_count_matching (GearyIterable* self,
                               GeePredicate f,
                               gpointer f_target,
                               GDestroyNotify f_target_destroy_notify)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), 0);
	count = 0;
	{
		GeeIterator* _g_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = geary_iterable_iterator (self);
		_g_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer g = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			_tmp1_ = _g_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _g_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			g = _tmp3_;
			_tmp4_ = g;
			if (f (_tmp4_, f_target)) {
				gint _tmp5_;
				_tmp5_ = count;
				count = _tmp5_ + 1;
			}
			((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
		}
		_g_object_unref0 (_g_it);
	}
	result = count;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

/**
     * The resulting Gee.Iterable comes with the same caveat that you may only
     * iterate over it once.
     */
GeeIterable*
geary_iterable_to_gee_iterable (GearyIterable* self)
{
	GeeIterator* _tmp0_;
	GearyIterableGeeIterable* _tmp1_;
	GeeIterable* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = self->priv->i;
	_tmp1_ = geary_iterable_gee_iterable_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable);
	return result;
}

/** Adds all elements to the given collection. */
GeeCollection*
geary_iterable_add_all_to (GearyIterable* self,
                           GeeCollection* c)
{
	GeeCollection* _tmp4_;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (c, GEE_TYPE_COLLECTION), NULL);
	while (TRUE) {
		GeeIterator* _tmp0_;
		GeeIterator* _tmp1_;
		gpointer _tmp2_;
		gpointer _tmp3_;
		_tmp0_ = self->priv->i;
		if (!gee_iterator_next (_tmp0_)) {
			break;
		}
		_tmp1_ = self->priv->i;
		_tmp2_ = gee_iterator_get (_tmp1_);
		_tmp3_ = _tmp2_;
		gee_collection_add (c, _tmp3_);
		((_tmp3_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_ = (self->priv->g_destroy_func (_tmp3_), NULL));
	}
	_tmp4_ = _g_object_ref0 (c);
	result = _tmp4_;
	return result;
}

/** Adds all elements to a map, with keys generated by key_func. */
GeeMap*
geary_iterable_add_all_to_map (GearyIterable* self,
                               GType k_type,
                               GBoxedCopyFunc k_dup_func,
                               GDestroyNotify k_destroy_func,
                               GeeMap* c,
                               GeeMapFunc key_func,
                               gpointer key_func_target)
{
	GeeMap* _tmp8_;
	GeeMap* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (c, GEE_TYPE_MAP), NULL);
	while (TRUE) {
		GeeIterator* _tmp0_;
		gpointer g = NULL;
		GeeIterator* _tmp1_;
		gpointer _tmp2_;
		gconstpointer _tmp3_;
		gpointer _tmp4_;
		gpointer _tmp5_;
		gpointer _tmp6_;
		gconstpointer _tmp7_;
		_tmp0_ = self->priv->i;
		if (!gee_iterator_next (_tmp0_)) {
			break;
		}
		_tmp1_ = self->priv->i;
		_tmp2_ = gee_iterator_get (_tmp1_);
		g = _tmp2_;
		_tmp3_ = g;
		_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
		_tmp5_ = key_func (_tmp4_, key_func_target);
		_tmp6_ = _tmp5_;
		_tmp7_ = g;
		gee_map_set (c, _tmp6_, _tmp7_);
		((_tmp6_ == NULL) || (k_destroy_func == NULL)) ? NULL : (_tmp6_ = (k_destroy_func (_tmp6_), NULL));
		((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
	}
	_tmp8_ = _g_object_ref0 (c);
	result = _tmp8_;
	return result;
}

/** Returns a new array list containing all elements. */
GeeArrayList*
geary_iterable_to_array_list (GearyIterable* self,
                              GeeEqualDataFunc equal_func,
                              gpointer equal_func_target,
                              GDestroyNotify equal_func_target_destroy_notify)
{
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeCollection* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp1_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_iterable_add_all_to (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

/**
     * Returns a new list containing all elements, sorted.
     *
     * The ordering is applied after adding all elements to the list,
     * so as to minimise computational overhead.
     */
GeeArrayList*
geary_iterable_to_sorted_list (GearyIterable* self,
                               GCompareDataFunc comparator,
                               gpointer comparator_target,
                               GDestroyNotify comparator_target_destroy_notify,
                               GeeEqualDataFunc equal_func,
                               gpointer equal_func_target,
                               GDestroyNotify equal_func_target_destroy_notify)
{
	GeeArrayList* list = NULL;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeArrayList* _tmp1_;
	GCompareDataFunc _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	GeeArrayList* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp1_ = geary_iterable_to_array_list (self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	list = _tmp1_;
	_tmp2_ = comparator;
	_tmp2__target = comparator_target;
	_tmp2__target_destroy_notify = comparator_target_destroy_notify;
	comparator = NULL;
	comparator_target = NULL;
	comparator_target_destroy_notify = NULL;
	gee_list_sort (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList), _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
	result = list;
	(comparator_target_destroy_notify == NULL) ? NULL : (comparator_target_destroy_notify (comparator_target), NULL);
	comparator = NULL;
	comparator_target = NULL;
	comparator_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

/** Returns a new linked list containing all elements. */
GeeLinkedList*
geary_iterable_to_linked_list (GearyIterable* self,
                               GeeEqualDataFunc equal_func,
                               gpointer equal_func_target,
                               GDestroyNotify equal_func_target_destroy_notify)
{
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeCollection* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp1_ = gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_iterable_add_all_to (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

/** Returns a new hash set containing all elements. */
GeeHashSet*
geary_iterable_to_hash_set (GearyIterable* self,
                            GeeHashDataFunc hash_func,
                            gpointer hash_func_target,
                            GDestroyNotify hash_func_target_destroy_notify,
                            GeeEqualDataFunc equal_func,
                            gpointer equal_func_target,
                            GDestroyNotify equal_func_target_destroy_notify)
{
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeCollection* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = hash_func;
	_tmp0__target = hash_func_target;
	_tmp0__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	_tmp1_ = equal_func;
	_tmp1__target = equal_func_target;
	_tmp1__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp2_ = gee_hash_set_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_add_all_to (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_HASH_SET, GeeHashSet);
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

/** Returns a new tree set with all elements added to it. */
GeeTreeSet*
geary_iterable_to_tree_set (GearyIterable* self,
                            GCompareDataFunc compare_func,
                            gpointer compare_func_target,
                            GDestroyNotify compare_func_target_destroy_notify)
{
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeTreeSet* _tmp1_;
	GeeTreeSet* _tmp2_;
	GeeCollection* _tmp3_;
	GeeTreeSet* _tmp4_;
	GeeTreeSet* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = compare_func;
	_tmp0__target = compare_func_target;
	_tmp0__target_destroy_notify = compare_func_target_destroy_notify;
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	_tmp1_ = gee_tree_set_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_iterable_add_all_to (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_TREE_SET, GeeTreeSet);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
	return result;
}

/** Returns a new hash map, adding elements with keys generated by key_func. */
GeeHashMap*
geary_iterable_to_hash_map (GearyIterable* self,
                            GType k_type,
                            GBoxedCopyFunc k_dup_func,
                            GDestroyNotify k_destroy_func,
                            GeeMapFunc key_func,
                            gpointer key_func_target,
                            GeeHashDataFunc key_hash_func,
                            gpointer key_hash_func_target,
                            GDestroyNotify key_hash_func_target_destroy_notify,
                            GeeEqualDataFunc key_equal_func,
                            gpointer key_equal_func_target,
                            GDestroyNotify key_equal_func_target_destroy_notify,
                            GeeEqualDataFunc value_equal_func,
                            gpointer value_equal_func_target,
                            GDestroyNotify value_equal_func_target_destroy_notify)
{
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* result;
	g_return_val_if_fail (GEARY_IS_ITERABLE (self), NULL);
	_tmp0_ = key_hash_func;
	_tmp0__target = key_hash_func_target;
	_tmp0__target_destroy_notify = key_hash_func_target_destroy_notify;
	key_hash_func = NULL;
	key_hash_func_target = NULL;
	key_hash_func_target_destroy_notify = NULL;
	_tmp1_ = key_equal_func;
	_tmp1__target = key_equal_func_target;
	_tmp1__target_destroy_notify = key_equal_func_target_destroy_notify;
	key_equal_func = NULL;
	key_equal_func_target = NULL;
	key_equal_func_target_destroy_notify = NULL;
	_tmp2_ = value_equal_func;
	_tmp2__target = value_equal_func_target;
	_tmp2__target_destroy_notify = value_equal_func_target_destroy_notify;
	value_equal_func = NULL;
	value_equal_func_target = NULL;
	value_equal_func_target_destroy_notify = NULL;
	_tmp3_ = gee_hash_map_new (k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_iterable_add_all_to_map (self, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MAP, GeeMap), key_func, key_func_target);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_HASH_MAP, GeeHashMap);
	_g_object_unref0 (_tmp4_);
	result = _tmp6_;
	(key_hash_func_target_destroy_notify == NULL) ? NULL : (key_hash_func_target_destroy_notify (key_hash_func_target), NULL);
	key_hash_func = NULL;
	key_hash_func_target = NULL;
	key_hash_func_target_destroy_notify = NULL;
	(key_equal_func_target_destroy_notify == NULL) ? NULL : (key_equal_func_target_destroy_notify (key_equal_func_target), NULL);
	key_equal_func = NULL;
	key_equal_func_target = NULL;
	key_equal_func_target_destroy_notify = NULL;
	(value_equal_func_target_destroy_notify == NULL) ? NULL : (value_equal_func_target_destroy_notify (value_equal_func_target), NULL);
	value_equal_func = NULL;
	value_equal_func_target = NULL;
	value_equal_func_target_destroy_notify = NULL;
	return result;
}

static inline gpointer
geary_iterable_gee_iterable_get_instance_private (GearyIterableGeeIterable* self)
{
	return G_STRUCT_MEMBER_P (self, GearyIterableGeeIterable_private_offset);
}

static GearyIterableGeeIterable*
geary_iterable_gee_iterable_construct (GType object_type,
                                       GType g_type,
                                       GBoxedCopyFunc g_dup_func,
                                       GDestroyNotify g_destroy_func,
                                       GeeIterator* iterator)
{
	GearyIterableGeeIterable * self = NULL;
	GeeIterator* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (iterator, GEE_TYPE_ITERATOR), NULL);
	self = (GearyIterableGeeIterable*) geary_base_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (iterator);
	_g_object_unref0 (self->priv->i);
	self->priv->i = _tmp0_;
	return self;
}

static GearyIterableGeeIterable*
geary_iterable_gee_iterable_new (GType g_type,
                                 GBoxedCopyFunc g_dup_func,
                                 GDestroyNotify g_destroy_func,
                                 GeeIterator* iterator)
{
	return geary_iterable_gee_iterable_construct (GEARY_ITERABLE_TYPE_GEE_ITERABLE, g_type, g_dup_func, g_destroy_func, iterator);
}

static GeeIterator*
geary_iterable_gee_iterable_real_iterator (GeeIterable* base)
{
	GearyIterableGeeIterable * self;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterable);
	_tmp0_ = self->priv->i;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
geary_iterable_gee_iterable_real_foreach (GearyIterableGeeIterable* self,
                                          GeeForallFunc f,
                                          gpointer f_target)
{
	gboolean result;
	{
		GeeIterator* _g_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERABLE, GeeIterable));
		_g_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer g = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			gpointer _tmp5_;
			_tmp1_ = _g_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _g_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			g = _tmp3_;
			_tmp4_ = g;
			_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
			if (!f (_tmp5_, f_target)) {
				result = FALSE;
				((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
				_g_object_unref0 (_g_it);
				return result;
			}
			((g == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (g = (self->priv->g_destroy_func (g), NULL));
		}
		_g_object_unref0 (_g_it);
	}
	result = TRUE;
	return result;
}

gboolean
geary_iterable_gee_iterable_foreach (GearyIterableGeeIterable* self,
                                     GeeForallFunc f,
                                     gpointer f_target)
{
	GearyIterableGeeIterableClass* _klass_;
	g_return_val_if_fail (GEARY_ITERABLE_IS_GEE_ITERABLE (self), FALSE);
	_klass_ = GEARY_ITERABLE_GEE_ITERABLE_GET_CLASS (self);
	if (_klass_->foreach) {
		return _klass_->foreach (self, f, f_target);
	}
	return FALSE;
}

static void
geary_iterable_gee_iterable_class_init (GearyIterableGeeIterableClass * klass,
                                        gpointer klass_data)
{
	geary_iterable_gee_iterable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyIterableGeeIterable_private_offset);
	((GearyIterableGeeIterableClass *) klass)->foreach = (gboolean (*) (GearyIterableGeeIterable*, GeeForallFunc, gpointer)) geary_iterable_gee_iterable_real_foreach;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_iterable_gee_iterable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_iterable_gee_iterable_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_iterable_gee_iterable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_GEE_ITERABLE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_GEE_ITERABLE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_GEE_ITERABLE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static GType
geary_iterable_gee_iterable_gee_traversable_get_g_type (GearyIterableGeeIterable* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
geary_iterable_gee_iterable_gee_traversable_get_g_dup_func (GearyIterableGeeIterable* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
geary_iterable_gee_iterable_gee_traversable_get_g_destroy_func (GearyIterableGeeIterable* self)
{
	return self->priv->g_destroy_func;
}

static void
geary_iterable_gee_iterable_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                            gpointer iface_data)
{
	geary_iterable_gee_iterable_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) geary_iterable_gee_iterable_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) geary_iterable_gee_iterable_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) geary_iterable_gee_iterable_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) geary_iterable_gee_iterable_gee_traversable_get_g_destroy_func;
}

static GType
geary_iterable_gee_iterable_gee_iterable_get_g_type (GearyIterableGeeIterable* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
geary_iterable_gee_iterable_gee_iterable_get_g_dup_func (GearyIterableGeeIterable* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
geary_iterable_gee_iterable_gee_iterable_get_g_destroy_func (GearyIterableGeeIterable* self)
{
	return self->priv->g_destroy_func;
}

static void
geary_iterable_gee_iterable_gee_iterable_interface_init (GeeIterableIface * iface,
                                                         gpointer iface_data)
{
	geary_iterable_gee_iterable_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*) (GeeIterable*)) geary_iterable_gee_iterable_real_iterator;
	iface->get_g_type = (GType (*) (GeeIterable *)) geary_iterable_gee_iterable_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) geary_iterable_gee_iterable_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) geary_iterable_gee_iterable_gee_iterable_get_g_destroy_func;
}

static void
geary_iterable_gee_iterable_instance_init (GearyIterableGeeIterable * self,
                                           gpointer klass)
{
	self->priv = geary_iterable_gee_iterable_get_instance_private (self);
}

static void
geary_iterable_gee_iterable_finalize (GObject * obj)
{
	GearyIterableGeeIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterable);
	_g_object_unref0 (self->priv->i);
	G_OBJECT_CLASS (geary_iterable_gee_iterable_parent_class)->finalize (obj);
}

/**
     * A private class that lets us take a Geary.Iterable and convert it back
     * into a Gee.Iterable.
     */
 G_GNUC_NO_INLINE static GType
geary_iterable_gee_iterable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyIterableGeeIterableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_iterable_gee_iterable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyIterableGeeIterable), 0, (GInstanceInitFunc) geary_iterable_gee_iterable_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) geary_iterable_gee_iterable_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) geary_iterable_gee_iterable_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_iterable_gee_iterable_type_id;
	geary_iterable_gee_iterable_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyIterableGeeIterable", &g_define_type_info, 0);
	g_type_add_interface_static (geary_iterable_gee_iterable_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (geary_iterable_gee_iterable_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	GearyIterableGeeIterable_private_offset = g_type_add_instance_private (geary_iterable_gee_iterable_type_id, sizeof (GearyIterableGeeIterablePrivate));
	return geary_iterable_gee_iterable_type_id;
}

static GType
geary_iterable_gee_iterable_get_type (void)
{
	static gsize geary_iterable_gee_iterable_type_id__once = 0;
	if (g_once_init_enter (&geary_iterable_gee_iterable_type_id__once)) {
		GType geary_iterable_gee_iterable_type_id;
		geary_iterable_gee_iterable_type_id = geary_iterable_gee_iterable_get_type_once ();
		g_once_init_leave (&geary_iterable_gee_iterable_type_id__once, geary_iterable_gee_iterable_type_id);
	}
	return geary_iterable_gee_iterable_type_id__once;
}

static void
_vala_geary_iterable_gee_iterable_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GearyIterableGeeIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterable);
	switch (property_id) {
		case GEARY_ITERABLE_GEE_ITERABLE_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEARY_ITERABLE_GEE_ITERABLE_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEARY_ITERABLE_GEE_ITERABLE_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_iterable_gee_iterable_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GearyIterableGeeIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_ITERABLE_TYPE_GEE_ITERABLE, GearyIterableGeeIterable);
	switch (property_id) {
		case GEARY_ITERABLE_GEE_ITERABLE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEARY_ITERABLE_GEE_ITERABLE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEARY_ITERABLE_GEE_ITERABLE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
geary_iterable_class_init (GearyIterableClass * klass,
                           gpointer klass_data)
{
	geary_iterable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyIterable_private_offset);
	((GearyIterableClass *) klass)->iterator = (GeeIterator* (*) (GearyIterable*)) geary_iterable_real_iterator;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_iterable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_iterable_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_iterable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ITERABLE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
geary_iterable_instance_init (GearyIterable * self,
                              gpointer klass)
{
	self->priv = geary_iterable_get_instance_private (self);
}

static void
geary_iterable_finalize (GObject * obj)
{
	GearyIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ITERABLE, GearyIterable);
	_g_object_unref0 (self->priv->i);
	G_OBJECT_CLASS (geary_iterable_parent_class)->finalize (obj);
}

/**
 * An Iterable that simply wraps an existing Iterator.  You get one iteration,
 * and only one iteration.  Basically every method triggers one iteration and
 * returns a new object.
 *
 * Note that this can't inherit from Gee.Iterable because its interface
 * requires that map/filter/etc. return Iterators, not Iterables.  It still
 * works in foreach.
 */
 G_GNUC_NO_INLINE static GType
geary_iterable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyIterableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_iterable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyIterable), 0, (GInstanceInitFunc) geary_iterable_instance_init, NULL };
	GType geary_iterable_type_id;
	geary_iterable_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyIterable", &g_define_type_info, 0);
	GearyIterable_private_offset = g_type_add_instance_private (geary_iterable_type_id, sizeof (GearyIterablePrivate));
	return geary_iterable_type_id;
}

GType
geary_iterable_get_type (void)
{
	static gsize geary_iterable_type_id__once = 0;
	if (g_once_init_enter (&geary_iterable_type_id__once)) {
		GType geary_iterable_type_id;
		geary_iterable_type_id = geary_iterable_get_type_once ();
		g_once_init_leave (&geary_iterable_type_id__once, geary_iterable_type_id);
	}
	return geary_iterable_type_id__once;
}

static void
_vala_geary_iterable_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GearyIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ITERABLE, GearyIterable);
	switch (property_id) {
		case GEARY_ITERABLE_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEARY_ITERABLE_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEARY_ITERABLE_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_iterable_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GearyIterable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ITERABLE, GearyIterable);
	switch (property_id) {
		case GEARY_ITERABLE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEARY_ITERABLE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEARY_ITERABLE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

