/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import mediathek.daten.DatenFilmFlags;
import mediathek.daten.FilmResolution;
import mediathek.daten.abo.DatenAbo;
import mediathek.javafx.bookmark.BookmarkData;
import mediathek.tool.FileSize;
import mediathek.tool.FilmSize;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.datum.DatumFilm;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatenFilm
implements Comparable<DatenFilm> {
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_MERKEN = 6;
    public static final int FILM_DATUM = 7;
    public static final int FILM_ZEIT = 8;
    public static final int FILM_DAUER = 9;
    public static final int FILM_GROESSE = 10;
    public static final int FILM_HD = 11;
    public static final int FILM_UT = 12;
    public static final int FILM_GEO = 13;
    public static final int FILM_URL = 14;
    public static final int FILM_DATUM_LONG = 15;
    public static final int FILM_REF = 16;
    public static final int MAX_ELEM = 17;
    private static final AtomicInteger FILM_COUNTER = new AtomicInteger(0);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final Logger logger = LogManager.getLogger(DatenFilm.class);
    private final EnumSet<DatenFilmFlags> flags = EnumSet.noneOf(DatenFilmFlags.class);
    private final int databaseFilmNumber;
    private DatenAbo abo;
    private BookmarkData bookmark;
    private DatumFilm datumFilm = DatumFilm.UNDEFINED_FILM_DATE;
    private FilmSize filmSize;
    private long filmLength;
    private String websiteLink;
    private String description;
    private String url_low_quality = "";
    private Optional<String> url_high_quality = Optional.empty();
    private String datumLong = "";
    private String sender = "";
    private String thema = "";
    private String titel = "";
    private Optional<String> availableInCountries = Optional.empty();
    private Optional<String> subtitle_url = Optional.empty();
    private String datum = "";
    private String sendeZeit = "";
    private String dauer = "";
    private String groesse = "";
    private String url_normal_quality = "";
    private int duration;

    public DatenFilm() {
        this.filmSize = new FilmSize(0);
        this.databaseFilmNumber = FILM_COUNTER.getAndIncrement();
    }

    public DatenFilm(@NotNull DatenFilm other) {
        this.abo = other.abo;
        this.bookmark = other.bookmark;
        this.datumFilm = other.datumFilm;
        this.filmSize = other.filmSize;
        this.filmLength = other.filmLength;
        this.databaseFilmNumber = other.databaseFilmNumber;
        this.websiteLink = other.websiteLink;
        this.description = other.description;
        this.url_low_quality = other.url_low_quality;
        this.url_high_quality = other.url_high_quality;
        this.datumLong = other.datumLong;
        this.sender = other.sender;
        this.thema = other.thema;
        this.titel = other.titel;
        this.availableInCountries = other.availableInCountries;
        this.subtitle_url = other.subtitle_url;
        this.datum = other.datum;
        this.sendeZeit = other.sendeZeit;
        this.dauer = other.dauer;
        this.groesse = other.groesse;
        this.url_normal_quality = other.url_normal_quality;
        this.duration = other.duration;
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public DatenAbo getAbo() {
        return this.abo;
    }

    public void setAbo(DatenAbo abo) {
        this.abo = abo;
    }

    public DatumFilm getDatumFilm() {
        return this.datumFilm;
    }

    public String getUrlLowQuality() {
        return this.url_low_quality;
    }

    public void setUrlLowQuality(String url_low_quality) {
        this.url_low_quality = url_low_quality;
    }

    public String getUrlHighQuality() {
        return this.url_high_quality.orElse("");
    }

    public void setUrlHighQuality(String urlHd) {
        this.url_high_quality = !urlHd.isEmpty() ? Optional.of(urlHd) : Optional.empty();
    }

    public String getDatumLong() {
        return this.datumLong;
    }

    public void setDatumLong(String datumLong) {
        this.datumLong = datumLong;
    }

    public boolean isTrailerTeaser() {
        return this.flags.contains((Object)DatenFilmFlags.TRAILER_TEASER);
    }

    public void setTrailerTeaser(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.TRAILER_TEASER);
        } else {
            this.flags.remove((Object)DatenFilmFlags.TRAILER_TEASER);
        }
    }

    public boolean isAudioVersion() {
        return this.flags.contains((Object)DatenFilmFlags.AUDIO_VERSION);
    }

    public void setAudioVersion(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.AUDIO_VERSION);
        } else {
            this.flags.remove((Object)DatenFilmFlags.AUDIO_VERSION);
        }
    }

    public boolean isPlayList() {
        return this.flags.contains((Object)DatenFilmFlags.PLAYLIST);
    }

    public void setPlayList(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.PLAYLIST);
        } else {
            this.flags.remove((Object)DatenFilmFlags.PLAYLIST);
        }
    }

    public boolean isSignLanguage() {
        return this.flags.contains((Object)DatenFilmFlags.SIGN_LANGUAGE);
    }

    public void setSignLanguage(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.SIGN_LANGUAGE);
        } else {
            this.flags.remove((Object)DatenFilmFlags.SIGN_LANGUAGE);
        }
    }

    public int getFilmNr() {
        return this.databaseFilmNumber;
    }

    public FilmSize getFilmSize() {
        return this.filmSize;
    }

    public String getDescription() {
        return StringUtils.defaultString(this.description);
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.isEmpty()) {
            this.description = desc;
        }
    }

    public String getWebsiteLink() {
        return StringUtils.defaultString(this.websiteLink);
    }

    public void setWebsiteLink(String link) {
        if (link != null && !link.isEmpty()) {
            this.websiteLink = link;
        }
    }

    public boolean isNew() {
        return this.flags.contains((Object)DatenFilmFlags.NEW_ENTRY);
    }

    public void setNew(boolean newFilm) {
        if (newFilm) {
            this.flags.add(DatenFilmFlags.NEW_ENTRY);
        } else {
            this.flags.remove((Object)DatenFilmFlags.NEW_ENTRY);
        }
    }

    public boolean isLivestream() {
        return this.flags.contains((Object)DatenFilmFlags.LIVESTREAM);
    }

    public void setLivestream(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.LIVESTREAM);
        } else {
            this.flags.remove((Object)DatenFilmFlags.LIVESTREAM);
        }
    }

    public void setBurnedInSubtitles(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.BURNED_IN_SUBTITLES);
        } else {
            this.flags.remove((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
        }
    }

    public boolean hasBurnedInSubtitles() {
        return this.flags.contains((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
    }

    public boolean hasSubtitle() {
        return this.subtitle_url.isPresent();
    }

    public String getUrlFuerAufloesung(FilmResolution.Enum resolution) {
        return switch (resolution) {
            case FilmResolution.Enum.LOW, FilmResolution.Enum.HIGH_QUALITY -> this.getUrlNormalOrRequested(resolution);
            default -> this.getUrlNormalQuality();
        };
    }

    public String getDateigroesse(String url) {
        if (url.equalsIgnoreCase(this.getUrlNormalQuality())) {
            return this.getSize();
        }
        return FileSize.getFileLengthFromUrl(url);
    }

    public String getUniqueHash() {
        return (this.getSender() + this.getThema()).toLowerCase() + this.getUrlNormalQuality() + this.getWebsiteLink();
    }

    public boolean isHighQuality() {
        return this.url_high_quality.isPresent();
    }

    @Override
    public int compareTo(@NotNull DatenFilm other) {
        int ret = sorter.compare(this.getSender(), other.getSender());
        if (ret == 0) {
            return sorter.compare(this.getThema(), other.getThema());
        }
        return ret;
    }

    public long getFilmLength() {
        return this.filmLength;
    }

    private long parseTimeToSeconds() {
        long seconds = 0L;
        String[] split = StringUtils.split(this.dauer, ':');
        if (split == null || split.length == 0) {
            return 0L;
        }
        try {
            seconds += Long.parseLong(split[0]) * 3600L;
            seconds += Long.parseLong(split[1]) * 60L;
            seconds += Long.parseLong(split[2]);
        }
        catch (Exception e) {
            seconds = 0L;
        }
        return seconds;
    }

    private void setDatum() {
        if (!this.getSendeDatum().isEmpty()) {
            try {
                long l = Long.parseLong(this.getDatumLong());
                this.datumFilm = new DatumFilm(l * 1000L);
            }
            catch (Exception ex) {
                logger.error("Datum: {}, Zeit: {}, Datum_LONG: {}", (Object)this.getSendeDatum(), (Object)this.getSendeZeit(), (Object)this.getDatumLong(), (Object)ex);
                this.datumFilm = new DatumFilm(0L);
                this.setSendeDatum("");
                this.setSendeZeit("");
            }
        }
    }

    public void init() {
        this.filmSize = new FilmSize(this);
        this.filmLength = this.parseTimeToSeconds();
        this.setDatum();
    }

    private String getUrlNormalOrRequested(@NotNull FilmResolution.Enum resolution) {
        String ret;
        String requestedUrl = this.getUrlByResolution(resolution);
        if (requestedUrl.isEmpty()) {
            ret = this.getUrlNormalQuality();
        } else {
            try {
                int indexPipe = requestedUrl.indexOf(124);
                ret = indexPipe == -1 ? requestedUrl : this.decompressUrl(requestedUrl, indexPipe);
            }
            catch (Exception e) {
                ret = "";
                logger.error("getUrlNormalOrRequested(aufl\u00f6sung: {}, requestedUrl: {})", (Object)resolution, (Object)requestedUrl, (Object)e);
            }
        }
        return ret;
    }

    private String decompressUrl(@NotNull String requestedUrl, int indexPipe) {
        int i = Integer.parseInt(requestedUrl.substring(0, indexPipe));
        return this.getUrlNormalQuality().substring(0, i) + requestedUrl.substring(indexPipe + 1);
    }

    private String getUrlByResolution(@NotNull FilmResolution.Enum resolution) {
        return switch (resolution) {
            case FilmResolution.Enum.HIGH_QUALITY -> this.getUrlHighQuality();
            case FilmResolution.Enum.LOW -> this.getUrlLowQuality();
            default -> this.getUrlNormalQuality();
        };
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getThema() {
        return this.thema;
    }

    public void setThema(String thema) {
        this.thema = thema;
    }

    public String getTitle() {
        return this.titel;
    }

    public void setTitle(String title) {
        this.titel = title;
    }

    public String getSendeDatum() {
        return this.datum;
    }

    public void setSendeDatum(String sendeDatum) {
        this.datum = sendeDatum;
    }

    public String getSendeZeit() {
        return this.sendeZeit;
    }

    public void setSendeZeit(String sendeZeit) {
        this.sendeZeit = sendeZeit;
    }

    public String getDauer() {
        return this.dauer;
    }

    public void setDauer(String dauer) {
        this.dauer = dauer;
        if (dauer == null || dauer.isEmpty()) {
            this.duration = 0;
        } else {
            String[] split = StringUtils.split(this.dauer, ':');
            try {
                this.duration += Integer.parseInt(split[0]) * 3600;
                this.duration += Integer.parseInt(split[1]) * 60;
                this.duration += Integer.parseInt(split[2]);
            }
            catch (Exception e) {
                this.duration = 0;
            }
        }
    }

    public String getSize() {
        return this.groesse;
    }

    public void setSize(String size) {
        this.groesse = size;
    }

    public String getUrlNormalQuality() {
        return this.url_normal_quality;
    }

    public void setUrlNormalQuality(String url_normal_quality) {
        this.url_normal_quality = url_normal_quality;
    }

    public String getUrlSubtitle() {
        return this.subtitle_url.orElse("");
    }

    public void setUrlSubtitle(String urlSubtitle) {
        this.subtitle_url = !urlSubtitle.isEmpty() ? Optional.of(urlSubtitle) : Optional.empty();
    }

    public Optional<String> getGeo() {
        return this.availableInCountries;
    }

    public void setGeo(Optional<String> availableInCountries) {
        this.availableInCountries = availableInCountries;
    }

    public BookmarkData getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(BookmarkData bookmark) {
        this.bookmark = bookmark;
    }

    public boolean isBookmarked() {
        return this.bookmark != null;
    }
}

