/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.ClusterInfo;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.RestoreInProgress;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.RoutingChangesObserver;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.IndexMetadataUpdater;
import org.opensearch.cluster.routing.allocation.RoutingNodesChangedObserver;
import org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.index.shard.ShardId;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotShardSizeInfo;

public class RoutingAllocation {
    private final AllocationDeciders deciders;
    private final RoutingNodes routingNodes;
    private final Metadata metadata;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final ImmutableOpenMap<String, ClusterState.Custom> customs;
    private final ClusterInfo clusterInfo;
    private final SnapshotShardSizeInfo shardSizeInfo;
    private Map<ShardId, Set<String>> ignoredShardToNodes = null;
    private boolean ignoreDisable = false;
    private DebugMode debugDecision = DebugMode.OFF;
    private boolean hasPendingAsyncFetch = false;
    private final long currentNanoTime;
    private final IndexMetadataUpdater indexMetadataUpdater = new IndexMetadataUpdater();
    private final RoutingNodesChangedObserver nodesChangedObserver = new RoutingNodesChangedObserver();
    private final RestoreService.RestoreInProgressUpdater restoreInProgressUpdater = new RestoreService.RestoreInProgressUpdater();
    private final RoutingChangesObserver routingChangesObserver = new RoutingChangesObserver.DelegatingRoutingChangesObserver(this.nodesChangedObserver, this.indexMetadataUpdater, this.restoreInProgressUpdater);

    public RoutingAllocation(AllocationDeciders deciders, RoutingNodes routingNodes, ClusterState clusterState, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime) {
        this.deciders = deciders;
        this.routingNodes = routingNodes;
        this.metadata = clusterState.metadata();
        this.routingTable = clusterState.routingTable();
        this.nodes = clusterState.nodes();
        this.customs = clusterState.customs();
        this.clusterInfo = clusterInfo;
        this.shardSizeInfo = shardSizeInfo;
        this.currentNanoTime = currentNanoTime;
    }

    public long getCurrentNanoTime() {
        return this.currentNanoTime;
    }

    public AllocationDeciders deciders() {
        return this.deciders;
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingNodes routingNodes() {
        return this.routingNodes;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public SnapshotShardSizeInfo snapshotShardSizeInfo() {
        return this.shardSizeInfo;
    }

    public <T extends ClusterState.Custom> T custom(String key) {
        return (T)this.customs.get(key);
    }

    public ImmutableOpenMap<String, ClusterState.Custom> getCustoms() {
        return this.customs;
    }

    public void ignoreDisable(boolean ignoreDisable) {
        this.ignoreDisable = ignoreDisable;
    }

    public boolean ignoreDisable() {
        return this.ignoreDisable;
    }

    public void setDebugMode(DebugMode debug) {
        this.debugDecision = debug;
    }

    public void debugDecision(boolean debug) {
        this.debugDecision = debug ? DebugMode.ON : DebugMode.OFF;
    }

    public boolean debugDecision() {
        return this.debugDecision != DebugMode.OFF;
    }

    public DebugMode getDebugMode() {
        return this.debugDecision;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, Set<String>>();
        }
        this.ignoredShardToNodes.computeIfAbsent(shardId, k -> new HashSet()).add(nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            return false;
        }
        Set<String> nodes = this.ignoredShardToNodes.get(shardId);
        return nodes != null && nodes.contains(nodeId);
    }

    public Set<String> getIgnoreNodes(ShardId shardId) {
        if (this.ignoredShardToNodes == null) {
            return Collections.emptySet();
        }
        Set<String> ignore = this.ignoredShardToNodes.get(shardId);
        if (ignore == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(ignore));
    }

    public void removeAllocationId(ShardRouting shardRouting) {
        this.indexMetadataUpdater.removeAllocationId(shardRouting);
    }

    public RoutingChangesObserver changes() {
        return this.routingChangesObserver;
    }

    public Metadata updateMetadataWithRoutingChanges(RoutingTable newRoutingTable) {
        return this.indexMetadataUpdater.applyChanges(this.metadata, newRoutingTable);
    }

    public RestoreInProgress updateRestoreInfoWithRoutingChanges(RestoreInProgress restoreInProgress) {
        return this.restoreInProgressUpdater.applyChanges(restoreInProgress);
    }

    public boolean routingNodesChanged() {
        return this.nodesChangedObserver.isChanged();
    }

    public Decision decision(Decision decision, String deciderLabel, String reason, Object ... params) {
        if (this.debugDecision()) {
            return Decision.single(decision.type(), deciderLabel, reason, params);
        }
        return decision;
    }

    public boolean hasPendingAsyncFetch() {
        return this.hasPendingAsyncFetch;
    }

    public void setHasPendingAsyncFetch() {
        this.hasPendingAsyncFetch = true;
    }

    public static enum DebugMode {
        OFF,
        ON,
        EXCLUDE_YES_DECISIONS;

    }
}

