/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.support.AbstractXContentParser;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.FieldNamesFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MappingLookup;
import org.opensearch.index.mapper.ParseContext;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    public static final Setting<Boolean> IGNORE_MALFORMED_SETTING = Setting.boolSetting("index.mapping.ignore_malformed", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", false, Setting.Property.IndexScope);
    protected FieldType fieldType;
    protected MappedFieldType mappedFieldType;
    protected MultiFields multiFields;
    protected CopyTo copyTo;

    protected FieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, MultiFields multiFields, CopyTo copyTo) {
        super(simpleName);
        if (mappedFieldType.name().isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        fieldType.freeze();
        this.fieldType = fieldType;
        this.mappedFieldType = mappedFieldType;
        this.multiFields = multiFields;
        this.copyTo = Objects.requireNonNull(copyTo);
    }

    @Override
    public String name() {
        return this.fieldType().name();
    }

    @Override
    public String typeName() {
        return this.mappedFieldType.typeName();
    }

    public MappedFieldType fieldType() {
        return this.mappedFieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    public MultiFields multiFields() {
        return this.multiFields;
    }

    public boolean parsesArrayValue() {
        return false;
    }

    public void parse(ParseContext context) throws IOException {
        block6: {
            try {
                this.parseCreateField(context);
            }
            catch (Exception e) {
                String valuePreview;
                boolean ignore_malformed;
                block5: {
                    ignore_malformed = false;
                    if (context.indexSettings() != null) {
                        ignore_malformed = IGNORE_MALFORMED_SETTING.get(context.indexSettings().getSettings());
                    }
                    valuePreview = "";
                    try {
                        XContentParser parser = context.parser();
                        Object complexValue = AbstractXContentParser.readValue((XContentParser)parser, HashMap::new);
                        valuePreview = complexValue == null ? "null" : complexValue.toString();
                    }
                    catch (Exception innerException) {
                        if (ignore_malformed) break block5;
                        throw new MapperParsingException("failed to parse field [{}] of type [{}] in document with id '{}'. Could not parse field value preview,", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.sourceToParse().id());
                    }
                }
                if (ignore_malformed) break block6;
                throw new MapperParsingException("failed to parse field [{}] of type [{}] in document with id '{}'. Preview of field's value: '{}'", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.sourceToParse().id(), valuePreview);
            }
        }
        this.multiFields.parse(this, context);
    }

    protected abstract void parseCreateField(ParseContext var1) throws IOException;

    protected final void createFieldNamesField(ParseContext context) {
        assert (!this.fieldType().hasDocValues()) : "_field_names should only be used when doc_values are turned off";
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = context.docMapper().metadataMapper(FieldNamesFieldMapper.class).fieldType();
        if (fieldNamesFieldType != null && fieldNamesFieldType.isEnabled()) {
            for (String fieldName : FieldNamesFieldMapper.extractFieldNames(this.fieldType().name())) {
                context.doc().add((IndexableField)new Field("_field_names", (CharSequence)fieldName, (IndexableFieldType)FieldNamesFieldMapper.Defaults.FIELD_TYPE));
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.multiFields.iterator();
    }

    protected FieldMapper clone() {
        try {
            return (FieldMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final void validate(MappingLookup mappers) {
        if (this.copyTo() != null && !this.copyTo().copyToFields().isEmpty()) {
            if (mappers.isMultiField(this.name())) {
                throw new IllegalArgumentException("[copy_to] may not be used to copy from a multi-field: [" + this.name() + "]");
            }
            String sourceScope = mappers.getNestedScope(this.name());
            for (String copyTo : this.copyTo().copyToFields()) {
                if (mappers.isMultiField(copyTo)) {
                    throw new IllegalArgumentException("[copy_to] may not be used to copy to a multi-field: [" + copyTo + "]");
                }
                if (mappers.isObjectField(copyTo)) {
                    throw new IllegalArgumentException("Cannot copy to field [" + copyTo + "] since it is mapped as an object");
                }
                String targetScope = mappers.getNestedScope(copyTo);
                FieldMapper.checkNestedScopeCompatibility(sourceScope, targetScope);
            }
        }
        for (Mapper multiField : this.multiFields()) {
            multiField.validate(mappers);
        }
        this.doValidate(mappers);
    }

    protected void doValidate(MappingLookup mappers) {
    }

    private static void checkNestedScopeCompatibility(String source, String target) {
        boolean targetIsParentOfSource;
        if (source == null || target == null) {
            targetIsParentOfSource = target == null;
        } else {
            boolean bl = targetIsParentOfSource = source.equals(target) || source.startsWith(target + ".");
        }
        if (!targetIsParentOfSource) {
            throw new IllegalArgumentException("Illegal combination of [copy_to] and [nested] mappings: [copy_to] may only copy data to the current nested document or any of its parents, however one [copy_to] directive is trying to copy data from nested object [" + source + "] to [" + target + "]");
        }
    }

    @Override
    public FieldMapper merge(Mapper mergeWith) {
        FieldMapper merged = this.clone();
        ArrayList<String> conflicts = new ArrayList<String>();
        if (!(mergeWith instanceof FieldMapper)) {
            throw new IllegalArgumentException("mapper [" + this.mappedFieldType.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.getClass().getSimpleName() + "]");
        }
        FieldMapper toMerge = (FieldMapper)mergeWith;
        merged.mergeSharedOptions(toMerge, conflicts);
        merged.mergeOptions(toMerge, conflicts);
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Mapper for [" + this.name() + "] conflicts with existing mapping:\n" + ((Object)conflicts).toString());
        }
        merged.multiFields = this.multiFields.merge(toMerge.multiFields);
        merged.mappedFieldType = toMerge.mappedFieldType;
        merged.fieldType = toMerge.fieldType;
        merged.copyTo = toMerge.copyTo;
        return merged;
    }

    private void mergeSharedOptions(FieldMapper mergeWith, List<String> conflicts) {
        boolean mergeWithIndexed;
        if (!Objects.equals(this.contentType(), mergeWith.contentType())) {
            throw new IllegalArgumentException("mapper [" + this.fieldType().name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.contentType() + "]");
        }
        FieldType other = mergeWith.fieldType;
        MappedFieldType otherm = mergeWith.mappedFieldType;
        boolean indexed = this.fieldType.indexOptions() != IndexOptions.NONE;
        boolean bl = mergeWithIndexed = other.indexOptions() != IndexOptions.NONE;
        if (indexed != mergeWithIndexed) {
            conflicts.add("mapper [" + this.name() + "] has different [index] values");
        }
        if (this.fieldType.indexOptions() != other.indexOptions()) {
            conflicts.add("mapper [" + this.name() + "] has different [index_options] values");
        }
        if (this.fieldType.stored() != other.stored()) {
            conflicts.add("mapper [" + this.name() + "] has different [store] values");
        }
        if (this.mappedFieldType.hasDocValues() != otherm.hasDocValues()) {
            conflicts.add("mapper [" + this.name() + "] has different [doc_values] values");
        }
        if (this.fieldType.omitNorms() && !other.omitNorms()) {
            conflicts.add("mapper [" + this.name() + "] has different [norms] values, cannot change from disable to enabled");
        }
        if (this.fieldType.storeTermVectors() != other.storeTermVectors()) {
            conflicts.add("mapper [" + this.name() + "] has different [term_vector] values");
        }
        if (this.fieldType.storeTermVectorOffsets() != other.storeTermVectorOffsets()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_offsets] values");
        }
        if (this.fieldType.storeTermVectorPositions() != other.storeTermVectorPositions()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_positions] values");
        }
        if (this.fieldType.storeTermVectorPayloads() != other.storeTermVectorPayloads()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_payloads] values");
        }
        if (this.mappedFieldType.indexAnalyzer() == null || "default".equals(this.mappedFieldType.indexAnalyzer().name())) {
            if (otherm.indexAnalyzer() != null && !"default".equals(otherm.indexAnalyzer().name())) {
                conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
            }
        } else if (otherm.indexAnalyzer() == null || "default".equals(otherm.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        } else if (!this.mappedFieldType.indexAnalyzer().name().equals(otherm.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        }
    }

    protected abstract void mergeOptions(FieldMapper var1, List<String> var2);

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected boolean indexedByDefault() {
        return true;
    }

    protected boolean docValuesByDefault() {
        return true;
    }

    protected boolean storedByDefault() {
        return false;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        if (includeDefaults || this.fieldType().boost() != 1.0f) {
            builder.field("boost", this.fieldType().boost());
        }
        if (includeDefaults || this.mappedFieldType.isSearchable() != this.indexedByDefault()) {
            builder.field("index", this.mappedFieldType.isSearchable());
        }
        if (includeDefaults || this.mappedFieldType.hasDocValues() != this.docValuesByDefault()) {
            builder.field("doc_values", this.mappedFieldType.hasDocValues());
        }
        if (includeDefaults || this.fieldType.stored() != this.storedByDefault()) {
            builder.field("store", this.fieldType.stored());
        }
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
        if (includeDefaults || !this.fieldType().meta().isEmpty()) {
            builder.field("meta", new TreeMap<String, String>(this.fieldType().meta()));
        }
    }

    protected final void doXContentAnalyzers(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (!this.fieldType.tokenized()) {
            return;
        }
        if (this.fieldType().indexAnalyzer() == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else {
            boolean hasDifferentSearchQuoteAnalyzer;
            boolean hasDefaultIndexAnalyzer = this.fieldType().indexAnalyzer().name().equals("default");
            String searchAnalyzerName = this.fieldType().getTextSearchInfo().getSearchAnalyzer() == null ? "default" : this.fieldType().getTextSearchInfo().getSearchAnalyzer().name();
            String searchQuoteAnalyzerName = this.fieldType().getTextSearchInfo().getSearchQuoteAnalyzer() == null ? searchAnalyzerName : this.fieldType().getTextSearchInfo().getSearchQuoteAnalyzer().name();
            boolean hasDifferentSearchAnalyzer = !searchAnalyzerName.equals(this.fieldType().indexAnalyzer().name());
            boolean bl = hasDifferentSearchQuoteAnalyzer = !Objects.equals(searchAnalyzerName, searchQuoteAnalyzerName);
            if (includeDefaults || !hasDefaultIndexAnalyzer || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                builder.field("analyzer", this.fieldType().indexAnalyzer().name());
                if (includeDefaults || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                    builder.field("search_analyzer", searchAnalyzerName);
                    if (includeDefaults || hasDifferentSearchQuoteAnalyzer) {
                        builder.field("search_quote_analyzer", searchQuoteAnalyzerName);
                    }
                }
            }
        }
    }

    protected static String indexOptionToString(IndexOptions indexOption) {
        switch (indexOption) {
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return "offsets";
            }
            case DOCS_AND_FREQS: {
                return "freqs";
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return "positions";
            }
            case DOCS: {
                return "docs";
            }
        }
        throw new IllegalArgumentException("Unknown IndexOptions [" + indexOption + "]");
    }

    protected abstract String contentType();

    public static class CopyTo {
        private static final CopyTo EMPTY = new CopyTo(Collections.emptyList());
        private final List<String> copyToFields;

        public static CopyTo empty() {
            return EMPTY;
        }

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public CopyTo build() {
                if (this.copyToBuilders.isEmpty()) {
                    return EMPTY;
                }
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }

            public void reset(CopyTo copyTo) {
                this.copyToBuilders.clear();
                this.copyToBuilders.addAll(copyTo.copyToFields);
            }
        }
    }

    public static class MultiFields
    implements Iterable<Mapper> {
        private final ImmutableOpenMap<String, FieldMapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(ImmutableOpenMap.of());
        }

        private MultiFields(ImmutableOpenMap<String, FieldMapper> mappers) {
            ImmutableOpenMap.Builder<String, FieldMapper> builder = new ImmutableOpenMap.Builder<String, FieldMapper>();
            for (ObjectObjectCursor<String, FieldMapper> objectObjectCursor : mappers) {
                builder.put((String)objectObjectCursor.key, (FieldMapper)objectObjectCursor.value);
            }
            this.mappers = builder.build();
        }

        public void parse(FieldMapper mainField, ParseContext context) throws IOException {
            if (this.mappers.isEmpty()) {
                return;
            }
            context = context.createMultiFieldContext();
            context.path().add(mainField.simpleName());
            for (ObjectCursor cursor : this.mappers.values()) {
                ((FieldMapper)cursor.value).parse(context);
            }
            context.path().remove();
        }

        public MultiFields merge(MultiFields mergeWith) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
            for (ObjectCursor cursor : mergeWith.mappers.values()) {
                FieldMapper mergeWithMapper = (FieldMapper)cursor.value;
                FieldMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
                if (mergeIntoMapper == null) {
                    newMappersBuilder.put(mergeWithMapper.simpleName(), mergeWithMapper);
                    continue;
                }
                FieldMapper merged = mergeIntoMapper.merge(mergeWithMapper);
                newMappersBuilder.put(merged.simpleName(), merged);
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(mappers);
        }

        @Override
        public Iterator<Mapper> iterator() {
            return StreamSupport.stream(this.mappers.values().spliterator(), false).map(p -> (Mapper)p.value).iterator();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.mappers.isEmpty()) {
                Mapper[] sortedMappers = (Mapper[])this.mappers.values().toArray(Mapper.class);
                Arrays.sort(sortedMappers, new Comparator<Mapper>(){

                    @Override
                    public int compare(Mapper o1, Mapper o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                builder.startObject("fields");
                for (Mapper mapper : sortedMappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = ImmutableOpenMap.builder();

            public Builder add(Mapper.Builder builder) {
                this.mapperBuilders.put(builder.name(), builder);
                return this;
            }

            public Builder add(final Mapper mapper) {
                this.mapperBuilders.put(mapper.simpleName(), new Mapper.Builder(mapper.simpleName()){

                    @Override
                    public Mapper build(Mapper.BuilderContext context) {
                        return mapper;
                    }
                });
                return this;
            }

            public Builder update(Mapper toMerge, ContentPath contentPath) {
                if (!this.mapperBuilders.containsKey(toMerge.simpleName())) {
                    this.add(toMerge);
                } else {
                    Mapper.Builder builder = this.mapperBuilders.get(toMerge.simpleName());
                    Mapper existing = builder.build(new Mapper.BuilderContext(Settings.EMPTY, contentPath));
                    this.add(existing.merge(toMerge));
                }
                return this;
            }

            public MultiFields build(Mapper.Builder mainFieldBuilder, Mapper.BuilderContext context) {
                if (this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                context.path().add(mainFieldBuilder.name());
                ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = this.mapperBuilders;
                Iterator<ObjectObjectCursor<String, Mapper.Builder>> iterator = this.mapperBuilders.iterator();
                while (iterator.hasNext()) {
                    ObjectObjectCursor<String, Mapper.Builder> cursor = iterator.next();
                    String key = (String)cursor.key;
                    Mapper.Builder value = (Mapper.Builder)cursor.value;
                    Mapper mapper = value.build(context);
                    assert (mapper instanceof FieldMapper);
                    mapperBuilders.put(key, (Mapper.Builder)((Object)mapper));
                }
                context.path().remove();
                ImmutableOpenMap.Builder mappers = mapperBuilders.cast();
                return new MultiFields(mappers.build());
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Mapper.Builder<T> {
        protected final FieldType fieldType;
        protected boolean omitNormsSet = false;
        protected boolean indexOptionsSet = false;
        protected boolean hasDocValues = true;
        protected boolean indexed = true;
        protected final MultiFields.Builder multiFieldsBuilder;
        protected CopyTo copyTo = CopyTo.empty();
        protected float boost = 1.0f;
        protected Map<String, String> meta = Collections.emptyMap();
        protected boolean eagerGlobalOrdinals;
        protected NamedAnalyzer indexAnalyzer;
        protected NamedAnalyzer searchAnalyzer;
        protected NamedAnalyzer searchQuoteAnalyzer;

        protected Builder(String name, FieldType fieldType) {
            super(name);
            this.fieldType = new FieldType((IndexableFieldType)fieldType);
            this.multiFieldsBuilder = new MultiFields.Builder();
        }

        public T index(boolean index) {
            this.indexed = index;
            if (!index) {
                this.fieldType.setIndexOptions(IndexOptions.NONE);
            }
            return (T)((Builder)this.builder);
        }

        public T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        public T docValues(boolean docValues) {
            this.hasDocValues = docValues;
            return (T)((Builder)this.builder);
        }

        public T storeTermVectors(boolean termVectors) {
            if (termVectors != this.fieldType.storeTermVectors()) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        public T boost(float boost) {
            this.boost = boost;
            return (T)((Builder)this.builder);
        }

        public T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexOptions(IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return (T)((Builder)this.builder);
        }

        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return (T)((Builder)this.builder);
        }

        public T searchQuoteAnalyzer(NamedAnalyzer searchQuoteAnalyzer) {
            this.searchQuoteAnalyzer = searchQuoteAnalyzer;
            return (T)((Builder)this.builder);
        }

        public T setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (T)((Builder)this.builder);
        }

        public T addMultiField(Mapper.Builder<?> mapperBuilder) {
            this.multiFieldsBuilder.add(mapperBuilder);
            return (T)((Builder)this.builder);
        }

        public T copyTo(CopyTo copyTo) {
            this.copyTo = copyTo;
            return (T)((Builder)this.builder);
        }

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().pathAsText(this.name);
        }

        public T meta(Map<String, String> meta) {
            this.meta = meta;
            return (T)this;
        }
    }
}

