/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.BoundsOnRatiosInThetaSketchedSets;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Union;

public final class JaccardSimilarity {
    private static final double[] ZEROS = new double[]{0.0, 0.0, 0.0};
    private static final double[] ONES = new double[]{1.0, 1.0, 1.0};

    public static double[] jaccard(Sketch sketchA, Sketch sketchB) {
        if (sketchA == null || sketchB == null) {
            return (double[])ZEROS.clone();
        }
        if (sketchA == sketchB) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return (double[])ZEROS.clone();
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries();
        int minK = 16;
        int maxK = 0x4000000;
        int newK = Math.max(Math.min(Util.ceilingPowerOf2(countA + countB), 0x4000000), 16);
        Union union = SetOperation.builder().setNominalEntries(newK).buildUnion();
        union.update(sketchA);
        union.update(sketchB);
        CompactSketch unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = unionAB.getRetainedEntries();
        if (countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB) {
            return (double[])ONES.clone();
        }
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update(sketchA);
        inter.update(sketchB);
        inter.update(unionAB);
        CompactSketch interABU = inter.getResult(true, null);
        double lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA(unionAB, interABU);
        double est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA(unionAB, interABU);
        double ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA(unionAB, interABU);
        return new double[]{lb, est, ub};
    }

    public static boolean exactlyEqual(Sketch sketchA, Sketch sketchB) {
        if (sketchA == null || sketchB == null) {
            return false;
        }
        if (sketchA == sketchB) {
            return true;
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return true;
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return false;
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries();
        Union union = SetOperation.builder().setNominalEntries(Util.ceilingPowerOf2(countA + countB)).buildUnion();
        union.update(sketchA);
        union.update(sketchB);
        CompactSketch unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = unionAB.getRetainedEntries();
        return countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB;
    }

    public static boolean similarityTest(Sketch measured, Sketch expected, double threshold) {
        double jRatioLB = JaccardSimilarity.jaccard(measured, expected)[0];
        return jRatioLB >= threshold;
    }

    public static boolean dissimilarityTest(Sketch measured, Sketch expected, double threshold) {
        double jRatioUB = JaccardSimilarity.jaccard(measured, expected)[2];
        return jRatioUB <= threshold;
    }
}

