/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.util.HttpTraceUtil;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import javax.annotation.Nullable;

abstract class AbstractHttpHandler<Q, P> {
    @VisibleForTesting
    final HttpExtractor<Q, P> extractor;

    AbstractHttpHandler(HttpExtractor<Q, P> extractor) {
        Preconditions.checkNotNull(extractor, (Object)"extractor");
        this.extractor = extractor;
    }

    static void recordMessageEvent(Span span, long id, MessageEvent.Type type, long uncompressedMessageSize, long compressedMessageSize) {
        MessageEvent messageEvent = MessageEvent.builder((MessageEvent.Type)type, (long)id).setUncompressedMessageSize(uncompressedMessageSize).setCompressedMessageSize(compressedMessageSize).build();
        span.addMessageEvent(messageEvent);
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, @Nullable String value) {
        if (value != null && !value.isEmpty()) {
            span.putAttribute(key, AttributeValue.stringAttributeValue((String)value));
        }
    }

    final void handleMessageSent(Span span, long messageId, long messageSize) {
        Preconditions.checkNotNull((Object)span, (Object)"span");
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(span, messageId, MessageEvent.Type.SENT, messageSize, 0L);
        }
    }

    final void handleMessageReceived(Span span, long messageId, long messageSize) {
        Preconditions.checkNotNull((Object)span, (Object)"span");
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(span, messageId, MessageEvent.Type.RECEIVED, messageSize, 0L);
        }
    }

    void spanEnd(Span span, @Nullable P response, @Nullable Throwable error) {
        Preconditions.checkNotNull((Object)span, (Object)"span");
        int statusCode = this.extractor.getStatusCode(response);
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            span.putAttribute("http.status_code", AttributeValue.longAttributeValue((long)statusCode));
        }
        span.setStatus(HttpTraceUtil.parseResponseStatus(statusCode, error));
        span.end();
    }

    final String getSpanName(Q request, HttpExtractor<Q, P> extractor) {
        String path = extractor.getPath(request);
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    final void addSpanRequestAttributes(Span span, Q request, HttpExtractor<Q, P> extractor) {
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.user_agent", extractor.getUserAgent(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.host", extractor.getHost(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.method", extractor.getMethod(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.path", extractor.getPath(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.route", extractor.getRoute(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.url", extractor.getUrl(request));
    }
}

