/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchQueryRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.OpenSearchScrollRequest;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class OpenSearchRequestBuilder {
    public static final TimeValue DEFAULT_QUERY_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final OpenSearchRequest.IndexName indexName;
    private final Integer maxResultWindow;
    private final SearchSourceBuilder sourceBuilder;
    private final OpenSearchExprValueFactory exprValueFactory;
    private Integer querySize;

    public OpenSearchRequestBuilder(String indexName, Integer maxResultWindow, Settings settings, OpenSearchExprValueFactory exprValueFactory) {
        this(new OpenSearchRequest.IndexName(indexName), maxResultWindow, settings, exprValueFactory);
    }

    public OpenSearchRequestBuilder(OpenSearchRequest.IndexName indexName, Integer maxResultWindow, Settings settings, OpenSearchExprValueFactory exprValueFactory) {
        this.indexName = indexName;
        this.maxResultWindow = maxResultWindow;
        this.sourceBuilder = new SearchSourceBuilder();
        this.exprValueFactory = exprValueFactory;
        this.querySize = (Integer)settings.getSettingValue(Settings.Key.QUERY_SIZE_LIMIT);
        this.sourceBuilder.from(0);
        this.sourceBuilder.size(this.querySize.intValue());
        this.sourceBuilder.timeout(DEFAULT_QUERY_TIMEOUT);
    }

    public OpenSearchRequest build() {
        Integer from = this.sourceBuilder.from();
        Integer size = this.sourceBuilder.size();
        if (from + size <= this.maxResultWindow) {
            return new OpenSearchQueryRequest(this.indexName, this.sourceBuilder, this.exprValueFactory);
        }
        this.sourceBuilder.size(this.maxResultWindow - from);
        return new OpenSearchScrollRequest(this.indexName, this.sourceBuilder, this.exprValueFactory);
    }

    public void pushDown(QueryBuilder query) {
        QueryBuilder current = this.sourceBuilder.query();
        if (current == null) {
            this.sourceBuilder.query(query);
        } else if (this.isBoolFilterQuery(current)) {
            ((BoolQueryBuilder)current).filter(query);
        } else {
            this.sourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().filter(current).filter(query));
        }
        if (this.sourceBuilder.sorts() == null) {
            this.sourceBuilder.sort("_doc", SortOrder.ASC);
        }
    }

    public void pushDownAggregation(Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder) {
        ((List)aggregationBuilder.getLeft()).forEach(builder -> this.sourceBuilder.aggregation(builder));
        this.sourceBuilder.size(0);
        this.exprValueFactory.setParser((OpenSearchAggregationResponseParser)aggregationBuilder.getRight());
    }

    public void pushDownSort(List<SortBuilder<?>> sortBuilders) {
        if (this.isSortByDocOnly()) {
            this.sourceBuilder.sorts().clear();
        }
        for (SortBuilder<?> sortBuilder : sortBuilders) {
            this.sourceBuilder.sort(sortBuilder);
        }
    }

    public void pushDownLimit(Integer limit, Integer offset) {
        this.querySize = limit;
        this.sourceBuilder.from(offset.intValue()).size(limit.intValue());
    }

    public void pushDownHighlight(String field, Map<String, Literal> arguments) {
        String unquotedField = StringUtils.unquoteText((String)field);
        if (this.sourceBuilder.highlighter() != null) {
            if (this.sourceBuilder.highlighter().fields().stream().anyMatch(f -> f.name().equals(unquotedField))) {
                throw new SemanticCheckException(String.format("Duplicate field %s in highlight", field));
            }
            this.sourceBuilder.highlighter().field(unquotedField);
        } else {
            HighlightBuilder highlightBuilder = new HighlightBuilder().field(unquotedField);
            this.sourceBuilder.highlighter(highlightBuilder);
        }
        int lastFieldIndex = this.sourceBuilder.highlighter().fields().size() - 1;
        if (arguments.containsKey("pre_tags")) {
            ((HighlightBuilder.Field)this.sourceBuilder.highlighter().fields().get(lastFieldIndex)).preTags(new String[]{arguments.get("pre_tags").toString()});
        }
        if (arguments.containsKey("post_tags")) {
            ((HighlightBuilder.Field)this.sourceBuilder.highlighter().fields().get(lastFieldIndex)).postTags(new String[]{arguments.get("post_tags").toString()});
        }
    }

    public void pushDownProjects(Set<ReferenceExpression> projects) {
        Set<String> projectsSet = projects.stream().map(ReferenceExpression::getAttr).collect(Collectors.toSet());
        this.sourceBuilder.fetchSource(projectsSet.toArray(new String[0]), new String[0]);
    }

    public void pushTypeMapping(Map<String, ExprType> typeMapping) {
        this.exprValueFactory.setTypeMapping(typeMapping);
    }

    private boolean isBoolFilterQuery(QueryBuilder current) {
        return current instanceof BoolQueryBuilder;
    }

    private boolean isSortByDocOnly() {
        List sorts = this.sourceBuilder.sorts();
        if (sorts != null) {
            return sorts.equals(Arrays.asList(SortBuilders.fieldSort((String)"_doc")));
        }
        return false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchRequestBuilder)) {
            return false;
        }
        OpenSearchRequestBuilder other = (OpenSearchRequestBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxResultWindow = this.getMaxResultWindow();
        Integer other$maxResultWindow = other.getMaxResultWindow();
        if (this$maxResultWindow == null ? other$maxResultWindow != null : !((Object)this$maxResultWindow).equals(other$maxResultWindow)) {
            return false;
        }
        Integer this$querySize = this.getQuerySize();
        Integer other$querySize = other.getQuerySize();
        if (this$querySize == null ? other$querySize != null : !((Object)this$querySize).equals(other$querySize)) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        return !(this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchRequestBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxResultWindow = this.getMaxResultWindow();
        result = result * 59 + ($maxResultWindow == null ? 43 : ((Object)$maxResultWindow).hashCode());
        Integer $querySize = this.getQuerySize();
        result = result * 59 + ($querySize == null ? 43 : ((Object)$querySize).hashCode());
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        return result;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Generated
    public Integer getMaxResultWindow() {
        return this.maxResultWindow;
    }

    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public Integer getQuerySize() {
        return this.querySize;
    }

    @Generated
    public String toString() {
        return "OpenSearchRequestBuilder(indexName=" + this.getIndexName() + ", maxResultWindow=" + this.getMaxResultWindow() + ", sourceBuilder=" + this.getSourceBuilder() + ", querySize=" + this.getQuerySize() + ")";
    }
}

