/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.unoloader.UnoClassLoader;
import com.sun.star.lib.util.UrlToFileMapper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public final class NativeLibraryLoader {
    public static void loadLibrary(ClassLoader loader, String libname) {
        File path;
        String sysname = System.mapLibraryName(libname);
        if (System.getProperty("os.name").startsWith("Mac") && sysname.endsWith(".dylib")) {
            sysname = sysname.substring(0, sysname.length() - "dylib".length()) + "jnilib";
        }
        if ((path = NativeLibraryLoader.getResource(loader, sysname)) == null) {
            System.loadLibrary(libname);
        } else {
            System.load(path.getAbsolutePath());
        }
    }

    public static File getResource(ClassLoader loader, String name) {
        File path;
        if (loader != null && (path = UrlToFileMapper.mapUrlToFile(loader.getResource(name))) != null) {
            return path;
        }
        if (!(loader instanceof URLClassLoader)) {
            return null;
        }
        URL[] urls = ((URLClassLoader)loader).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            File dir;
            File path2 = UrlToFileMapper.mapUrlToFile(urls[i]);
            if (path2 == null) continue;
            File file = dir = path2.isDirectory() ? path2 : path2.getParentFile();
            if (dir == null) continue;
            path2 = new File(dir, name);
            if (path2.exists()) {
                return path2;
            }
            if ((dir = dir.getParentFile()) == null) continue;
            path2 = new File(dir, name);
            if (path2.exists()) {
                return path2;
            }
            if (!System.getProperty("os.name").startsWith("Mac") || !dir.getName().equals("Resources") || !(path2 = new File(dir = dir.getParentFile(), "Frameworks/" + name)).exists()) continue;
            return path2;
        }
        return null;
    }

    private NativeLibraryLoader() {
    }

    static {
        if (!(NativeLibraryLoader.class.getClassLoader() instanceof UnoClassLoader)) {
            System.err.println("warning: com.sun.star.lib.util.NativeLibraryLoader must be loaded by com.sun.star.lib.unoloader.UnoClassLoader for java_uno bridge to work (not a problem if this is using Java remote bridge or unit test)");
        }
    }
}

