/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ImportHandler;
import jakarta.el.ValueExpression;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.NotFoundELResolver;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.ExpressionEvaluatorImpl;
import org.apache.jasper.el.VariableResolverImpl;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspContextWrapper;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDirectives;
import org.apache.jasper.runtime.JspSourceImports;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    private static final JspFactory jspf = JspFactory.getDefaultFactory();
    private BodyContentImpl[] outs = new BodyContentImpl[0];
    private int depth = -1;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspApplicationContextImpl applicationContext;
    private String errorPageURL;
    private boolean limitBodyContentBuffer;
    private int bodyContentTagBufferSize = 512;
    private final transient HashMap<String, Object> attributes = new HashMap(16);
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient HttpSession session;
    private transient ELContextImpl elContext;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;

    PageContextImpl() {
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.errorPageURL = string;
        this.request = servletRequest;
        this.response = servletResponse;
        this.limitBodyContentBuffer = Boolean.parseBoolean(this.config.getInitParameter("limitBodyContentBuffer"));
        String string2 = this.config.getInitParameter("bodyContentTagBufferSize");
        if (string2 != null) {
            this.bodyContentTagBufferSize = Integer.parseInt(string2);
        }
        this.applicationContext = JspApplicationContextImpl.getInstance(this.context);
        if (servletRequest instanceof HttpServletRequest && bl) {
            this.session = ((HttpServletRequest)servletRequest).getSession();
        }
        if (bl && this.session == null) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.page.sessionRequired"));
        }
        this.depth = -1;
        if (n == -1) {
            n = 8192;
        }
        if (this.baseOut == null) {
            this.baseOut = new JspWriterImpl(servletResponse, n, bl2);
        } else {
            this.baseOut.init(servletResponse, n, bl2);
        }
        this.out = this.baseOut;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        this.setAttribute("jakarta.servlet.jsp.jspRequest", servletRequest);
        this.setAttribute("jakarta.servlet.jsp.jspResponse", servletResponse);
        if (this.session != null) {
            this.setAttribute("jakarta.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("jakarta.servlet.jsp.jspPage", servlet);
        this.setAttribute("jakarta.servlet.jsp.jspConfig", this.config);
        this.setAttribute("jakarta.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("jakarta.servlet.jsp.jspApplication", this.context);
    }

    public void release() {
        this.out = this.baseOut;
        try {
            ((JspWriterImpl)this.out).flushBuffer();
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException(Localizer.getMessage("jsp.error.flush"), iOException);
            throw illegalStateException;
        }
        finally {
            this.servlet = null;
            this.config = null;
            this.context = null;
            this.applicationContext = null;
            this.elContext = null;
            this.errorPageURL = null;
            this.request = null;
            this.response = null;
            this.depth = -1;
            this.baseOut.recycle();
            this.session = null;
            this.attributes.clear();
            for (BodyContentImpl bodyContentImpl : this.outs) {
                bodyContentImpl.recycle();
            }
        }
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, 1);
    }

    public Object getAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        switch (n) {
            case 1: {
                return this.attributes.get(string);
            }
            case 2: {
                return this.request.getAttribute(string);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttribute(string);
            }
            case 4: {
                return this.context.getAttribute(string);
            }
        }
        throw new IllegalArgumentException(Localizer.getMessage("jsp.error.page.invalid.scope"));
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, 1);
    }

    public void setAttribute(String string, Object object, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (object == null) {
            this.removeAttribute(string, n);
        } else {
            switch (n) {
                case 1: {
                    this.attributes.put(string, object);
                    break;
                }
                case 2: {
                    this.request.setAttribute(string, object);
                    break;
                }
                case 3: {
                    if (this.session == null) {
                        throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                    }
                    this.session.setAttribute(string, object);
                    break;
                }
                case 4: {
                    this.context.setAttribute(string, object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid scope");
                }
            }
        }
    }

    public void removeAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        switch (n) {
            case 1: {
                this.attributes.remove(string);
                break;
            }
            case 2: {
                this.request.removeAttribute(string);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                this.session.removeAttribute(string);
                break;
            }
            case 4: {
                this.context.removeAttribute(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.page.invalid.scope"));
            }
        }
    }

    public int getAttributesScope(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (this.attributes.get(string) != null) {
            return 1;
        }
        if (this.request.getAttribute(string) != null) {
            return 2;
        }
        if (this.session != null) {
            try {
                if (this.session.getAttribute(string) != null) {
                    return 3;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.context.getAttribute(string) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.session != null) {
            try {
                object = this.session.getAttribute(string);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (object != null) {
                return object;
            }
        }
        return this.context.getAttribute(string);
    }

    public Enumeration<String> getAttributeNamesInScope(int n) {
        switch (n) {
            case 1: {
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException(Localizer.getMessage("jsp.error.page.invalid.scope"));
    }

    public void removeAttribute(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        this.removeAttribute(string, 1);
        this.removeAttribute(string, 2);
        if (this.session != null) {
            try {
                this.removeAttribute(string, 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.removeAttribute(string, 4);
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        Throwable throwable = JspRuntimeLibrary.getThrowable(this.request);
        if (throwable != null && !(throwable instanceof Exception)) {
            throwable = new JspException(throwable);
        }
        return (Exception)throwable;
    }

    public Object getPage() {
        return this.servlet;
    }

    private String getAbsolutePathRelativeToContext(String string) {
        Object object = string;
        if (!((String)object).startsWith("/")) {
            String string2 = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
            if (string2 == null) {
                string2 = ((HttpServletRequest)this.request).getServletPath();
            }
            String string3 = string2.substring(0, string2.lastIndexOf(47));
            object = string3 + "/" + (String)object;
        }
        return object;
    }

    public void include(String string) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, this.out, true);
    }

    public void include(String string, boolean bl) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, this.out, bl);
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl(this.getELContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(String string) throws ServletException, IOException {
        try {
            this.out.clear();
            this.baseOut.clear();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.attempt_to_clear_flushed_buffer"), iOException);
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String string2 = this.getAbsolutePathRelativeToContext(string);
        String string3 = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
        if (string3 != null) {
            this.request.removeAttribute("jakarta.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(string2).forward(this.request, this.response);
        }
        finally {
            if (string3 != null) {
                this.request.setAttribute("jakarta.servlet.include.servlet_path", (Object)string3);
            }
        }
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] bodyContentImplArray = Arrays.copyOf(this.outs, this.depth + 1);
            bodyContentImplArray[this.depth] = new BodyContentImpl(this.out, this.limitBodyContentBuffer, this.bodyContentTagBufferSize);
            this.outs = bodyContentImplArray;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    @Deprecated
    public ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl(this.applicationContext.getExpressionFactory());
    }

    public void handlePageException(Exception exception) throws IOException, ServletException {
        this.handlePageException((Throwable)exception);
    }

    public void handlePageException(Throwable throwable) throws IOException, ServletException {
        if (throwable == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.page.nullThrowable"));
        }
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("jakarta.servlet.jsp.jspException", (Object)throwable);
            this.request.setAttribute("jakarta.servlet.error.status_code", (Object)500);
            this.request.setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("jakarta.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException illegalStateException) {
                this.include(this.errorPageURL);
            }
            Object object = this.request.getAttribute("jakarta.servlet.error.exception");
            if (object != null && object == throwable) {
                this.request.removeAttribute("jakarta.servlet.error.exception");
            }
        } else {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Throwable throwable2 = null;
            if (throwable instanceof JspException || throwable instanceof ELException || throwable instanceof jakarta.servlet.jsp.el.ELException) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 != null) {
                throw new ServletException(throwable.getClass().getName() + ": " + throwable.getMessage(), throwable2);
            }
            throw new ServletException(throwable);
        }
        this.request.removeAttribute("jakarta.servlet.error.status_code");
        this.request.removeAttribute("jakarta.servlet.error.request_uri");
        this.request.removeAttribute("jakarta.servlet.error.servlet_name");
        this.request.removeAttribute("jakarta.servlet.jsp.jspException");
    }

    public static Object proprietaryEvaluate(String string, Class<?> clazz, PageContext pageContext, ProtectedFunctionMapper protectedFunctionMapper) throws ELException {
        ExpressionFactory expressionFactory = jspf.getJspApplicationContext(pageContext.getServletContext()).getExpressionFactory();
        ELContext eLContext = pageContext.getELContext();
        ELContextImpl eLContextImpl = eLContext instanceof JspContextWrapper.ELContextWrapper ? (ELContextImpl)((JspContextWrapper.ELContextWrapper)eLContext).getWrappedELContext() : (ELContextImpl)eLContext;
        eLContextImpl.setFunctionMapper(protectedFunctionMapper);
        ValueExpression valueExpression = expressionFactory.createValueExpression(eLContext, string, clazz);
        return valueExpression.getValue(eLContext);
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.applicationContext.createELContext((JspContext)this);
            if (this.servlet instanceof JspSourceImports) {
                Object object;
                Object object2;
                ImportHandler importHandler = this.elContext.getImportHandler();
                Set<String> set = ((JspSourceImports)this.servlet).getPackageImports();
                if (set != null) {
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        importHandler.importPackage((String)object);
                    }
                }
                if ((object2 = ((JspSourceImports)this.servlet).getClassImports()) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        if (string.startsWith("static ")) {
                            string = string.substring(7);
                            importHandler.importStatic(string);
                            continue;
                        }
                        importHandler.importClass(string);
                    }
                }
            }
            if (this.servlet instanceof JspSourceDirectives && ((JspSourceDirectives)this.servlet).getErrorOnELNotFound()) {
                this.elContext.putContext(NotFoundELResolver.class, Boolean.TRUE);
            }
        }
        return this.elContext;
    }
}

