/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.ToStringUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(WebappLoader.class);
    private WebappClassLoaderBase classLoader = null;
    private Context context = null;
    private boolean delegate = false;
    private String loaderClass = ParallelWebappClassLoader.class.getName();
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    protected static final StringManager sm = StringManager.getManager(WebappLoader.class);
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;

    public WebappLoader() {
        this(null);
    }

    @Deprecated
    public WebappLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == context) {
            return;
        }
        if (this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("webappLoader.setContext.ise"));
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener(this);
        }
        Context context2 = this.context;
        this.context = context;
        this.support.firePropertyChange("context", context2, this.context);
        if (this.context != null) {
            this.setReloadable(this.context.getReloadable());
            this.context.addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean bl) {
        boolean bl2 = this.delegate;
        this.delegate = bl;
        this.support.firePropertyChange("delegate", (Object)bl2, (Object)this.delegate);
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String string) {
        this.loaderClass = string;
    }

    public void setLoaderInstance(WebappClassLoaderBase webappClassLoaderBase) {
        this.classLoader = webappClassLoaderBase;
        this.setLoaderClass(webappClassLoaderBase.getClass().getName());
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", (Object)bl2, (Object)this.reloadable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (this.context != null) {
                    this.context.reload();
                }
            }
            finally {
                if (this.context != null && this.context.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
            }
        }
    }

    public String[] getLoaderRepositories() {
        if (this.classLoader == null) {
            return new String[0];
        }
        URL[] uRLArray = this.classLoader.getURLs();
        String[] stringArray = new String[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            stringArray[i] = uRLArray[i].toExternalForm();
        }
        return stringArray;
    }

    public String getLoaderRepositoriesString() {
        String[] stringArray = this.getLoaderRepositories();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(':');
        }
        return stringBuilder.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return ToStringUtil.toString((Object)this, this.context);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        if (this.context.getResources() == null) {
            log.info((Object)sm.getString("webappLoader.noResources", new Object[]{this.context}));
            this.setState(LifecycleState.STARTING);
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.context.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            String string = this.context.getName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            ObjectName objectName = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + string);
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, objectName, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            throw new LifecycleException(sm.getString("webappLoader.startError"), throwable2);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        ServletContext servletContext = this.context.getServletContext();
        servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        if (this.classLoader != null) {
            try {
                this.classLoader.stop();
            }
            finally {
                this.classLoader.destroy();
            }
            try {
                String string = this.context.getName();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                ObjectName objectName = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + string);
                Registry.getRegistry(null, null).unregisterComponent(objectName);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("webappLoader.stopError"), (Throwable)exception);
            }
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!(propertyChangeEvent.getSource() instanceof Context)) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)propertyChangeEvent.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)sm.getString("webappLoader.reloadable", new Object[]{propertyChangeEvent.getNewValue().toString()}));
            }
        }
    }

    private WebappClassLoaderBase createClassLoader() throws Exception {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.context.getParentClassLoader();
        } else {
            this.context.setParentClassLoader(this.parentClassLoader);
        }
        if (ParallelWebappClassLoader.class.getName().equals(this.loaderClass)) {
            return new ParallelWebappClassLoader(this.parentClassLoader);
        }
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoaderBase webappClassLoaderBase = null;
        Class[] classArray = new Class[]{ClassLoader.class};
        Object[] objectArray = new Object[]{this.parentClassLoader};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        webappClassLoaderBase = (WebappClassLoaderBase)constructor.newInstance(objectArray);
        return webappClassLoaderBase;
    }

    private void setPermissions() {
        if (!Globals.IS_SECURITY_ENABLED) {
            return;
        }
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (file != null) {
            try {
                String string = file.getCanonicalPath();
                this.classLoader.addPermission(new FilePermission(string, "read,write"));
                this.classLoader.addPermission(new FilePermission((String)string + File.separator + "-", "read,write,delete"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (URL uRL : this.context.getResources().getBaseUrls()) {
            this.classLoader.addPermission(uRL);
        }
    }

    private void setClassPath() {
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ClassLoader classLoader = this.getClassLoader();
        if (this.delegate && classLoader != null) {
            classLoader = classLoader.getParent();
        }
        while (classLoader != null && this.buildClassPath(stringBuilder, classLoader)) {
            classLoader = classLoader.getParent();
        }
        if (this.delegate && (classLoader = this.getClassLoader()) != null) {
            this.buildClassPath(stringBuilder, classLoader);
        }
        this.classpath = stringBuilder.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)this.classpath);
    }

    private boolean buildClassPath(StringBuilder stringBuilder, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray;
            for (URL uRL : uRLArray = ((URLClassLoader)classLoader).getURLs()) {
                String string = uRL.toString();
                if (string.startsWith("file://")) {
                    string = UDecoder.URLDecode((String)string.substring(7), (Charset)StandardCharsets.UTF_8);
                } else {
                    if (!string.startsWith("file:")) continue;
                    string = UDecoder.URLDecode((String)string.substring(5), (Charset)StandardCharsets.UTF_8);
                }
                if (string == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparator);
                }
                stringBuilder.append(string);
            }
        } else {
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                String string = System.getProperty("java.class.path");
                if (string != null && string.length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(File.pathSeparator);
                    }
                    stringBuilder.append(string);
                }
                return false;
            }
            if (!JreCompat.isGraalAvailable()) {
                log.info((Object)sm.getString("webappLoader.unknownClassLoader", new Object[]{classLoader, classLoader.getClass()}));
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Loader");
        stringBuilder.append(",host=");
        stringBuilder.append(this.context.getParent().getName());
        stringBuilder.append(",context=");
        String string = this.context.getName();
        if (!string.startsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

