/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.locks;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.graalvm.visualvm.jfr.views.locks.LocksViewSupport;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.ImageUtilities;

abstract class LocksNode
extends CCTNode {
    private static final LocksNode[] NO_NODES = new LocksNode[0];
    private final LocksNode parent;
    private final List<LocksNode> children;
    final String name;
    final Icon icon;
    long count = 0L;
    Duration duration;
    Duration durationMax;

    LocksNode(String name, Icon icon, LocksNode parent, List<LocksNode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    final void processData(Duration duration) {
        if (this.parent != null) {
            ++this.count;
            this.duration = this.duration == null ? duration : this.duration.plus(duration);
            if (this.durationMax == null || this.durationMax.compareTo(duration) < 0) {
                this.durationMax = duration;
            }
            this.parent.processData(duration);
        }
    }

    LocksNode getChild(String name) {
        if (this.children != null) {
            for (LocksNode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    public LocksNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public LocksNode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null ? true : this.children.isEmpty();
    }

    public LocksNode getParent() {
        return this.parent;
    }

    protected void addChild(LocksNode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocksNode)) {
            return false;
        }
        return Objects.equals(this.name, ((LocksNode)((Object)o)).name);
    }

    public String toString() {
        return this.name;
    }

    static final class Root
    extends LocksNode
    implements JFREventVisitor {
        private final int mode;
        private final LocksViewSupport.Aggregation primary;
        private final LocksViewSupport.Aggregation secondary;

        Root() {
            this(0, null, null);
        }

        Root(int mode, LocksViewSupport.Aggregation primary, LocksViewSupport.Aggregation secondary) {
            super(null, null, null, (List<LocksNode>)(primary == null && secondary == null ? null : new ArrayList<LocksNode>()));
            this.mode = mode;
            this.primary = primary;
            this.secondary = LocksViewSupport.Aggregation.NONE.equals((Object)secondary) ? null : secondary;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            Boolean rw = this.mode != 2 && "jdk.JavaMonitorEnter".equals(typeName) ? Boolean.FALSE : (this.mode != 1 && "jdk.JavaMonitorWait".equals(typeName) ? Boolean.TRUE : null);
            if (rw != null) {
                LocksNode primaryNode;
                String primaryName = Root.getName(this.primary, event, rw);
                if (primaryName == null) {
                    primaryName = "<unknown>";
                }
                if ((primaryNode = this.getChild(primaryName)) == null) {
                    primaryNode = Root.createNode(primaryName, this.primary, this, this.secondary == null);
                    this.addChild(primaryNode);
                }
                if (this.secondary != null) {
                    LocksNode secondaryNode;
                    String secondaryName = Root.getName(this.secondary, event, rw);
                    if (secondaryName == null) {
                        secondaryName = "<unknown>";
                    }
                    if ((secondaryNode = primaryNode.getChild(secondaryName)) == null) {
                        secondaryNode = Root.createNode(secondaryName, this.secondary, primaryNode, true);
                        primaryNode.addChild(secondaryNode);
                    }
                    try {
                        secondaryNode.processData(event.getDuration("eventDuration"));
                    }
                    catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {}
                } else {
                    try {
                        primaryNode.processData(event.getDuration("eventDuration"));
                    }
                    catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }

        private static String getName(LocksViewSupport.Aggregation aggregation, JFREvent event, boolean eventMode) {
            try {
                if (LocksViewSupport.Aggregation.CLASS.equals((Object)aggregation)) {
                    return Root.decodeClassName(event.getClass("monitorClass").getName());
                }
                if (LocksViewSupport.Aggregation.OBJECT.equals((Object)aggregation)) {
                    return Root.decodeClassName(event.getClass("monitorClass").getName()) + "(0x" + Long.toHexString(event.getLong("address")) + ")";
                }
                if (LocksViewSupport.Aggregation.THREAD_BLOCKED.equals((Object)aggregation)) {
                    return event.getThread("eventThread").getName();
                }
                if (LocksViewSupport.Aggregation.THREAD_BLOCKING.equals((Object)aggregation)) {
                    return Root.getThreadName(event, eventMode);
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private static String getThreadName(JFREvent event, boolean eventMode) throws JFRPropertyNotAvailableException {
            JFRThread thread;
            JFRThread jFRThread = thread = eventMode ? event.getThread("notifier") : event.getThread("previousOwner");
            return thread == null ? (eventMode ? "<timed out>" : "<unknown thread>") : thread.getName();
        }

        private static LocksNode createNode(String name, LocksViewSupport.Aggregation aggregation, LocksNode parent, boolean terminal) {
            if (LocksViewSupport.Aggregation.CLASS.equals((Object)aggregation)) {
                return new LockClass(name, parent, terminal);
            }
            if (LocksViewSupport.Aggregation.OBJECT.equals((Object)aggregation)) {
                return new LockObject(name, parent, terminal);
            }
            if (LocksViewSupport.Aggregation.THREAD_BLOCKED.equals((Object)aggregation)) {
                return new Thread(name, false, parent, terminal);
            }
            if (LocksViewSupport.Aggregation.THREAD_BLOCKING.equals((Object)aggregation)) {
                return new Thread(name, true, parent, terminal);
            }
            return null;
        }

        private static String decodeClassName(String className) {
            if ((className = StringUtils.userFormClassName((String)className)).startsWith("L") && className.contains(";")) {
                className = className.substring(1, className.length()).replace(";", "");
            }
            return className;
        }
    }

    static final class Label
    extends LocksNode {
        Label(String label, LocksNode parent) {
            super(label, null, parent, null);
        }

        static Label createNoData(LocksNode parent) {
            return new Label("<no data>", parent);
        }
    }

    static final class Thread
    extends LocksNode {
        final boolean blocking;

        Thread(String name, boolean blocking, LocksNode parent, boolean terminal) {
            super(name, "<timed out>".equals(name) ? null : Icons.getIcon((String)"ProfilerIcons.Thread"), parent, terminal ? null : new ArrayList());
            this.blocking = blocking;
        }
    }

    static final class LockObject
    extends LocksNode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/lock.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/lock.png", (boolean)true));

        LockObject(String name, LocksNode parent, boolean terminal) {
            super(name, ICON, parent, terminal ? null : new ArrayList());
        }
    }

    static final class LockClass
    extends LocksNode {
        LockClass(String name, LocksNode parent, boolean terminal) {
            super(name, Icons.getIcon((String)"LanguageIcons.Class"), parent, terminal ? null : new ArrayList());
        }
    }
}

