// Generated from libavfilter/opencl/colorspace_common.cl
const char *ff_opencl_source_colorspace_common =
"#line 1 \"libavfilter/opencl/colorspace_common.cl\"\n"
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"#define ST2084_MAX_LUMINANCE 10000.0f\n"
"#define REFERENCE_WHITE 100.0f\n"
"\n"
"#if chroma_loc == 1\n"
"    #define chroma_sample(a,b,c,d) (((a) + (c)) * 0.5f)\n"
"#elif chroma_loc == 3\n"
"    #define chroma_sample(a,b,c,d) (a)\n"
"#elif chroma_loc == 4\n"
"    #define chroma_sample(a,b,c,d) (((a) + (b)) * 0.5f)\n"
"#elif chroma_loc == 5\n"
"    #define chroma_sample(a,b,c,d) (c)\n"
"#elif chroma_loc == 6\n"
"    #define chroma_sample(a,b,c,d) (((c) + (d)) * 0.5f)\n"
"#else\n"
"    #define chroma_sample(a,b,c,d) (((a) + (b) + (c) + (d)) * 0.25f)\n"
"#endif\n"
"\n"
"constant const float ST2084_M1 = 0.1593017578125f;\n"
"constant const float ST2084_M2 = 78.84375f;\n"
"constant const float ST2084_C1 = 0.8359375f;\n"
"constant const float ST2084_C2 = 18.8515625f;\n"
"constant const float ST2084_C3 = 18.6875f;\n"
"\n"
"float get_luma_dst(float3 c) {\n"
"    return luma_dst.x * c.x + luma_dst.y * c.y + luma_dst.z * c.z;\n"
"}\n"
"\n"
"float get_luma_src(float3 c) {\n"
"    return luma_src.x * c.x + luma_src.y * c.y + luma_src.z * c.z;\n"
"}\n"
"\n"
"float3 get_chroma_sample(float3 a, float3 b, float3 c, float3 d) {\n"
"    return chroma_sample(a, b, c, d);\n"
"}\n"
"\n"
"float eotf_st2084(float x) {\n"
"    float p = powr(x, 1.0f / ST2084_M2);\n"
"    float a = max(p -ST2084_C1, 0.0f);\n"
"    float b = max(ST2084_C2 - ST2084_C3 * p, 1e-6f);\n"
"    float c  = powr(a / b, 1.0f / ST2084_M1);\n"
"    return x > 0.0f ? c * ST2084_MAX_LUMINANCE / REFERENCE_WHITE : 0.0f;\n"
"}\n"
"\n"
"__constant const float HLG_A = 0.17883277f;\n"
"__constant const float HLG_B = 0.28466892f;\n"
"__constant const float HLG_C = 0.55991073f;\n"
"\n"
"// linearizer for HLG\n"
"float inverse_oetf_hlg(float x) {\n"
"    float a = 4.0f * x * x;\n"
"    float b = exp((x - HLG_C) / HLG_A) + HLG_B;\n"
"    return x < 0.5f ? a : b;\n"
"}\n"
"\n"
"// delinearizer for HLG\n"
"float oetf_hlg(float x) {\n"
"    float a = 0.5f * sqrt(x);\n"
"    float b = HLG_A * log(x - HLG_B) + HLG_C;\n"
"    return x <= 1.0f ? a : b;\n"
"}\n"
"\n"
"float3 ootf_hlg(float3 c, float peak) {\n"
"    float luma = get_luma_src(c);\n"
"    float gamma =  1.2f + 0.42f * log10(peak * REFERENCE_WHITE / 1000.0f);\n"
"    gamma = max(1.0f, gamma);\n"
"    float factor = peak * powr(luma, gamma - 1.0f) / powr(12.0f, gamma);\n"
"    return c * factor;\n"
"}\n"
"\n"
"float3 inverse_ootf_hlg(float3 c, float peak) {\n"
"    float gamma = 1.2f + 0.42f * log10(peak * REFERENCE_WHITE / 1000.0f);\n"
"    c *=  powr(12.0f, gamma) / peak;\n"
"    c /= powr(get_luma_dst(c), (gamma - 1.0f) / gamma);\n"
"    return c;\n"
"}\n"
"\n"
"float inverse_eotf_bt1886(float c) {\n"
"    return c < 0.0f ? 0.0f : powr(c, 1.0f / 2.4f);\n"
"}\n"
"\n"
"float oetf_bt709(float c) {\n"
"    c = c < 0.0f ? 0.0f : c;\n"
"    float r1 = 4.5f * c;\n"
"    float r2 = 1.099f * powr(c, 0.45f) - 0.099f;\n"
"    return c < 0.018f ? r1 : r2;\n"
"}\n"
"float inverse_oetf_bt709(float c) {\n"
"    float r1 = c / 4.5f;\n"
"    float r2 = powr((c + 0.099f) / 1.099f, 1.0f / 0.45f);\n"
"    return c < 0.081f ? r1 : r2;\n"
"}\n"
"\n"
"float3 yuv2rgb(float y, float u, float v) {\n"
"#ifdef FULL_RANGE_IN\n"
"    u -= 0.5f; v -= 0.5f;\n"
"#else\n"
"    y = (y * 255.0f -  16.0f) / 219.0f;\n"
"    u = (u * 255.0f - 128.0f) / 224.0f;\n"
"    v = (v * 255.0f - 128.0f) / 224.0f;\n"
"#endif\n"
"    float r = y * rgb_matrix[0] + u * rgb_matrix[1] + v * rgb_matrix[2];\n"
"    float g = y * rgb_matrix[3] + u * rgb_matrix[4] + v * rgb_matrix[5];\n"
"    float b = y * rgb_matrix[6] + u * rgb_matrix[7] + v * rgb_matrix[8];\n"
"    return (float3)(r, g, b);\n"
"}\n"
"\n"
"float3 yuv2lrgb(float3 yuv) {\n"
"    float3 rgb = yuv2rgb(yuv.x, yuv.y, yuv.z);\n"
"#ifdef linearize\n"
"    float r = linearize(rgb.x);\n"
"    float g = linearize(rgb.y);\n"
"    float b = linearize(rgb.z);\n"
"    return (float3)(r, g, b);\n"
"#else\n"
"    return rgb;\n"
"#endif\n"
"}\n"
"\n"
"float3 rgb2yuv(float r, float g, float b) {\n"
"    float y = r*yuv_matrix[0] + g*yuv_matrix[1] + b*yuv_matrix[2];\n"
"    float u = r*yuv_matrix[3] + g*yuv_matrix[4] + b*yuv_matrix[5];\n"
"    float v = r*yuv_matrix[6] + g*yuv_matrix[7] + b*yuv_matrix[8];\n"
"#ifdef FULL_RANGE_OUT\n"
"    u += 0.5f; v += 0.5f;\n"
"#else\n"
"    y = (219.0f * y + 16.0f) / 255.0f;\n"
"    u = (224.0f * u + 128.0f) / 255.0f;\n"
"    v = (224.0f * v + 128.0f) / 255.0f;\n"
"#endif\n"
"    return (float3)(y, u, v);\n"
"}\n"
"\n"
"float rgb2y(float r, float g, float b) {\n"
"    float y = r*yuv_matrix[0] + g*yuv_matrix[1] + b*yuv_matrix[2];\n"
"    y = (219.0f * y + 16.0f) / 255.0f;\n"
"    return y;\n"
"}\n"
"\n"
"float3 lrgb2yuv(float3 c) {\n"
"#ifdef delinearize\n"
"    float r = delinearize(c.x);\n"
"    float g = delinearize(c.y);\n"
"    float b = delinearize(c.z);\n"
"    return rgb2yuv(r, g, b);\n"
"#else\n"
"    return rgb2yuv(c.x, c.y, c.z);\n"
"#endif\n"
"}\n"
"\n"
"float lrgb2y(float3 c) {\n"
"#ifdef delinearize\n"
"    float r = delinearize(c.x);\n"
"    float g = delinearize(c.y);\n"
"    float b = delinearize(c.z);\n"
"    return rgb2y(r, g, b);\n"
"#else\n"
"    return rgb2y(c.x, c.y, c.z);\n"
"#endif\n"
"}\n"
"\n"
"float3 lrgb2lrgb(float3 c) {\n"
"#ifdef RGB2RGB_PASSTHROUGH\n"
"    return c;\n"
"#else\n"
"    float r = c.x, g = c.y, b = c.z;\n"
"    float rr = rgb2rgb[0] * r + rgb2rgb[1] * g + rgb2rgb[2] * b;\n"
"    float gg = rgb2rgb[3] * r + rgb2rgb[4] * g + rgb2rgb[5] * b;\n"
"    float bb = rgb2rgb[6] * r + rgb2rgb[7] * g + rgb2rgb[8] * b;\n"
"    return (float3)(rr, gg, bb);\n"
"#endif\n"
"}\n"
"\n"
"float3 ootf(float3 c, float peak) {\n"
"#ifdef ootf_impl\n"
"    return ootf_impl(c, peak);\n"
"#else\n"
"    return c;\n"
"#endif\n"
"}\n"
"\n"
"float3 inverse_ootf(float3 c, float peak) {\n"
"#ifdef inverse_ootf_impl\n"
"    return inverse_ootf_impl(c, peak);\n"
"#else\n"
"    return c;\n"
"#endif\n"
"}\n"
;
