/* org-bluez-obex-client.c generated by valac 0.56.3, the Vala compiler
 * generated from org-bluez-obex-client.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Arun Raghavan <arun.raghavan@collabora.co.uk>
 *       Gustavo Padovan <gustavo.padovan@collabora.co.uk>
 *       Matthieu Bouron <matthieu.bouron@collabora.com>
 */

#include "bluez.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

typedef GDBusProxy orgbluezobexClientProxy;
typedef GDBusProxyClass orgbluezobexClientProxyClass;
typedef struct _OrgBluezObexClientCreateSessionReadyData OrgBluezObexClientCreateSessionReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _OrgBluezObexClientRemoveSessionReadyData OrgBluezObexClientRemoveSessionReadyData;
typedef GDBusProxy orgbluezobexPhonebookAccessProxy;
typedef GDBusProxyClass orgbluezobexPhonebookAccessProxyClass;
typedef GDBusProxy orgbluezobexTransferProxy;
typedef GDBusProxyClass orgbluezobexTransferProxyClass;

struct _OrgBluezObexClientCreateSessionReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* address;
	GHashTable* args;
};

struct _OrgBluezObexClientRemoveSessionReadyData {
	GDBusMethodInvocation* _invocation_;
	char* session;
};

static GType org_bluez_obex_client_get_type_once (void);
static void org_bluez_obex_client_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void org_bluez_obex_client_proxy_create_session_async (orgbluezobexClient* self,
                                                       const gchar* address,
                                                       GHashTable* args,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static char* org_bluez_obex_client_proxy_create_session_finish (orgbluezobexClient* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void org_bluez_obex_client_proxy_remove_session_async (orgbluezobexClient* self,
                                                       const char* session,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void org_bluez_obex_client_proxy_remove_session_finish (orgbluezobexClient* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void org_bluez_obex_client_proxy_org_bluez_obex_client_interface_init (orgbluezobexClientIface* iface);
static void _dbus_org_bluez_obex_client_create_session (orgbluezobexClient* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_obex_client_create_session_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_org_bluez_obex_client_remove_session (orgbluezobexClient* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_obex_client_remove_session_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void org_bluez_obex_client_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* org_bluez_obex_client_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean org_bluez_obex_client_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _org_bluez_obex_client_unregister_object (gpointer user_data);
static GType org_bluez_obex_phonebook_access_get_type_once (void);
static void org_bluez_obex_phonebook_access_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters);
static void org_bluez_obex_phonebook_access_proxy_select (orgbluezobexPhonebookAccess* self,
                                                   const gchar* location,
                                                   const gchar* phonebook,
                                                   GError** error);
static orgbluezobexPhonebookAccessPhonebookEntry* org_bluez_obex_phonebook_access_proxy_list (orgbluezobexPhonebookAccess* self,
                                                                                       GHashTable* filters,
                                                                                       gint* result_length1,
                                                                                       GError** error);
static gchar** org_bluez_obex_phonebook_access_proxy_list_filter_fields (orgbluezobexPhonebookAccess* self,
                                                                  gint* result_length1,
                                                                  GError** error);
static void org_bluez_obex_phonebook_access_proxy_pull_all (orgbluezobexPhonebookAccess* self,
                                                     const gchar* target,
                                                     GHashTable* filters,
                                                     gchar** path,
                                                     GHashTable** props,
                                                     GError** error);
static void org_bluez_obex_phonebook_access_proxy_org_bluez_obex_phonebook_access_interface_init (orgbluezobexPhonebookAccessIface* iface);
static void _dbus_org_bluez_obex_phonebook_access_select (orgbluezobexPhonebookAccess* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _vala_orgbluezobexPhonebookAccessPhonebookEntry_array_free (orgbluezobexPhonebookAccessPhonebookEntry * array,
                                                                 gssize array_length);
static void _dbus_org_bluez_obex_phonebook_access_list (orgbluezobexPhonebookAccess* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_obex_phonebook_access_list_filter_fields (orgbluezobexPhonebookAccess* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_obex_phonebook_access_pull_all (orgbluezobexPhonebookAccess* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void org_bluez_obex_phonebook_access_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data);
static GVariant* org_bluez_obex_phonebook_access_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data);
static gboolean org_bluez_obex_phonebook_access_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data);
static void _org_bluez_obex_phonebook_access_unregister_object (gpointer user_data);
static GType org_bluez_obex_transfer_get_type_once (void);
static void org_bluez_obex_transfer_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static void org_bluez_obex_transfer_proxy_cancel (orgbluezobexTransfer* self,
                                           GError** error);
static gchar* org_bluez_obex_transfer_dbus_proxy_get_status (orgbluezobexTransfer* self);
static char* org_bluez_obex_transfer_dbus_proxy_get_session (orgbluezobexTransfer* self);
static gchar* org_bluez_obex_transfer_dbus_proxy_get_name (orgbluezobexTransfer* self);
static gchar* org_bluez_obex_transfer_dbus_proxy_get_transfer_type (orgbluezobexTransfer* self);
static gint64 org_bluez_obex_transfer_dbus_proxy_get_time (orgbluezobexTransfer* self);
static guint64 org_bluez_obex_transfer_dbus_proxy_get_size (orgbluezobexTransfer* self);
static guint64 org_bluez_obex_transfer_dbus_proxy_get_transferred (orgbluezobexTransfer* self);
static gchar* org_bluez_obex_transfer_dbus_proxy_get_filename (orgbluezobexTransfer* self);
static void org_bluez_obex_transfer_proxy_org_bluez_obex_transfer_interface_init (orgbluezobexTransferIface* iface);
static void _dbus_org_bluez_obex_transfer_cancel (orgbluezobexTransfer* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void org_bluez_obex_transfer_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* org_bluez_obex_transfer_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static GVariant* _dbus_org_bluez_obex_transfer_get_status (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_session (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_name (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_transfer_type (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_time (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_size (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_transferred (orgbluezobexTransfer* self);
static GVariant* _dbus_org_bluez_obex_transfer_get_filename (orgbluezobexTransfer* self);
static gboolean org_bluez_obex_transfer_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _org_bluez_obex_transfer_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _org_bluez_obex_client_dbus_arg_info_create_session_address = {-1, "address", "s", NULL};
static const GDBusArgInfo _org_bluez_obex_client_dbus_arg_info_create_session_args = {-1, "args", "a{sv}", NULL};
static const GDBusArgInfo _org_bluez_obex_client_dbus_arg_info_create_session_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _org_bluez_obex_client_dbus_arg_info_create_session_in[] = {&_org_bluez_obex_client_dbus_arg_info_create_session_address, &_org_bluez_obex_client_dbus_arg_info_create_session_args, NULL};
static const GDBusArgInfo * const _org_bluez_obex_client_dbus_arg_info_create_session_out[] = {&_org_bluez_obex_client_dbus_arg_info_create_session_result, NULL};
static const GDBusMethodInfo _org_bluez_obex_client_dbus_method_info_create_session = {-1, "CreateSession", (GDBusArgInfo **) (&_org_bluez_obex_client_dbus_arg_info_create_session_in), (GDBusArgInfo **) (&_org_bluez_obex_client_dbus_arg_info_create_session_out), NULL};
static const GDBusArgInfo _org_bluez_obex_client_dbus_arg_info_remove_session_session = {-1, "session", "o", NULL};
static const GDBusArgInfo * const _org_bluez_obex_client_dbus_arg_info_remove_session_in[] = {&_org_bluez_obex_client_dbus_arg_info_remove_session_session, NULL};
static const GDBusArgInfo * const _org_bluez_obex_client_dbus_arg_info_remove_session_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_obex_client_dbus_method_info_remove_session = {-1, "RemoveSession", (GDBusArgInfo **) (&_org_bluez_obex_client_dbus_arg_info_remove_session_in), (GDBusArgInfo **) (&_org_bluez_obex_client_dbus_arg_info_remove_session_out), NULL};
static const GDBusMethodInfo * const _org_bluez_obex_client_dbus_method_info[] = {&_org_bluez_obex_client_dbus_method_info_create_session, &_org_bluez_obex_client_dbus_method_info_remove_session, NULL};
static const GDBusSignalInfo * const _org_bluez_obex_client_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _org_bluez_obex_client_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _org_bluez_obex_client_dbus_interface_info = {-1, "org.bluez.obex.Client1", (GDBusMethodInfo **) (&_org_bluez_obex_client_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_obex_client_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_obex_client_dbus_property_info), NULL};
static const GDBusInterfaceVTable _org_bluez_obex_client_dbus_interface_vtable = {org_bluez_obex_client_dbus_interface_method_call, org_bluez_obex_client_dbus_interface_get_property, org_bluez_obex_client_dbus_interface_set_property};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_select_location = {-1, "location", "s", NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_select_phonebook = {-1, "phonebook", "s", NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_select_in[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_select_location, &_org_bluez_obex_phonebook_access_dbus_arg_info_select_phonebook, NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_select_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_obex_phonebook_access_dbus_method_info_select = {-1, "Select", (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_select_in), (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_select_out), NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_list_filters = {-1, "filters", "a{sv}", NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_list_result = {-1, "result", "a(ss)", NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_list_in[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_list_filters, NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_list_out[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_list_result, NULL};
static const GDBusMethodInfo _org_bluez_obex_phonebook_access_dbus_method_info_list = {-1, "List", (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_list_in), (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_list_out), NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_out[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_result, NULL};
static const GDBusMethodInfo _org_bluez_obex_phonebook_access_dbus_method_info_list_filter_fields = {-1, "ListFilterFields", (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_in), (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_list_filter_fields_out), NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_target = {-1, "target", "s", NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_filters = {-1, "filters", "a{sv}", NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_path = {-1, "path", "s", NULL};
static const GDBusArgInfo _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_props = {-1, "props", "a{sv}", NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_in[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_target, &_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_filters, NULL};
static const GDBusArgInfo * const _org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_out[] = {&_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_path, &_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_props, NULL};
static const GDBusMethodInfo _org_bluez_obex_phonebook_access_dbus_method_info_pull_all = {-1, "PullAll", (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_in), (GDBusArgInfo **) (&_org_bluez_obex_phonebook_access_dbus_arg_info_pull_all_out), NULL};
static const GDBusMethodInfo * const _org_bluez_obex_phonebook_access_dbus_method_info[] = {&_org_bluez_obex_phonebook_access_dbus_method_info_select, &_org_bluez_obex_phonebook_access_dbus_method_info_list, &_org_bluez_obex_phonebook_access_dbus_method_info_list_filter_fields, &_org_bluez_obex_phonebook_access_dbus_method_info_pull_all, NULL};
static const GDBusSignalInfo * const _org_bluez_obex_phonebook_access_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _org_bluez_obex_phonebook_access_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _org_bluez_obex_phonebook_access_dbus_interface_info = {-1, "org.bluez.obex.PhonebookAccess1", (GDBusMethodInfo **) (&_org_bluez_obex_phonebook_access_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_obex_phonebook_access_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_obex_phonebook_access_dbus_property_info), NULL};
static const GDBusInterfaceVTable _org_bluez_obex_phonebook_access_dbus_interface_vtable = {org_bluez_obex_phonebook_access_dbus_interface_method_call, org_bluez_obex_phonebook_access_dbus_interface_get_property, org_bluez_obex_phonebook_access_dbus_interface_set_property};
static const GDBusArgInfo * const _org_bluez_obex_transfer_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_obex_transfer_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_obex_transfer_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_org_bluez_obex_transfer_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_org_bluez_obex_transfer_dbus_arg_info_cancel_out), NULL};
static const GDBusMethodInfo * const _org_bluez_obex_transfer_dbus_method_info[] = {&_org_bluez_obex_transfer_dbus_method_info_cancel, NULL};
static const GDBusSignalInfo * const _org_bluez_obex_transfer_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_status = {-1, "Status", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_session = {-1, "Session", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_transfer_type = {-1, "Type", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_time = {-1, "Time", "x", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_size = {-1, "Size", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_transferred = {-1, "Transferred", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _org_bluez_obex_transfer_dbus_property_info_filename = {-1, "Filename", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _org_bluez_obex_transfer_dbus_property_info[] = {&_org_bluez_obex_transfer_dbus_property_info_status, &_org_bluez_obex_transfer_dbus_property_info_session, &_org_bluez_obex_transfer_dbus_property_info_name, &_org_bluez_obex_transfer_dbus_property_info_transfer_type, &_org_bluez_obex_transfer_dbus_property_info_time, &_org_bluez_obex_transfer_dbus_property_info_size, &_org_bluez_obex_transfer_dbus_property_info_transferred, &_org_bluez_obex_transfer_dbus_property_info_filename, NULL};
static const GDBusInterfaceInfo _org_bluez_obex_transfer_dbus_interface_info = {-1, "org.bluez.obex.Transfer1", (GDBusMethodInfo **) (&_org_bluez_obex_transfer_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_obex_transfer_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_obex_transfer_dbus_property_info), NULL};
static const GDBusInterfaceVTable _org_bluez_obex_transfer_dbus_interface_vtable = {org_bluez_obex_transfer_dbus_interface_method_call, org_bluez_obex_transfer_dbus_interface_get_property, org_bluez_obex_transfer_dbus_interface_set_property};

void
org_bluez_obex_client_create_session (orgbluezobexClient* self,
                                      const gchar* address,
                                      GHashTable* args,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	orgbluezobexClientIface* _iface_;
	_iface_ = ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE (self);
	if (_iface_->create_session) {
		_iface_->create_session (self, address, args, _callback_, _user_data_);
	}
}

char*
org_bluez_obex_client_create_session_finish (orgbluezobexClient* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	orgbluezobexClientIface* _iface_;
	_iface_ = ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE (self);
	if (_iface_->create_session_finish) {
		return _iface_->create_session_finish (self, _res_, error);
	}
	return NULL;
}

void
org_bluez_obex_client_remove_session (orgbluezobexClient* self,
                                      const char* session,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	orgbluezobexClientIface* _iface_;
	_iface_ = ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE (self);
	if (_iface_->remove_session) {
		_iface_->remove_session (self, session, _callback_, _user_data_);
	}
}

void
org_bluez_obex_client_remove_session_finish (orgbluezobexClient* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	orgbluezobexClientIface* _iface_;
	_iface_ = ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE (self);
	if (_iface_->remove_session_finish) {
		_iface_->remove_session_finish (self, _res_, error);
	}
}

static void
org_bluez_obex_client_default_init (orgbluezobexClientIface * iface,
                                    gpointer iface_data)
{
}

static GType
org_bluez_obex_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (orgbluezobexClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) org_bluez_obex_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType org_bluez_obex_client_type_id;
	org_bluez_obex_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezobexClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (org_bluez_obex_client_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (org_bluez_obex_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_obex_client_proxy_get_type);
	g_type_set_qdata (org_bluez_obex_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.Client1");
	g_type_set_qdata (org_bluez_obex_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_obex_client_dbus_interface_info));
	g_type_set_qdata (org_bluez_obex_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_obex_client_register_object);
	return org_bluez_obex_client_type_id;
}

GType
org_bluez_obex_client_get_type (void)
{
	static volatile gsize org_bluez_obex_client_type_id__once = 0;
	if (g_once_init_enter (&org_bluez_obex_client_type_id__once)) {
		GType org_bluez_obex_client_type_id;
		org_bluez_obex_client_type_id = org_bluez_obex_client_get_type_once ();
		g_once_init_leave (&org_bluez_obex_client_type_id__once, org_bluez_obex_client_type_id);
	}
	return org_bluez_obex_client_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (orgbluezobexClientProxy, org_bluez_obex_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_OBEX_TYPE_CLIENT, org_bluez_obex_client_proxy_org_bluez_obex_client_interface_init) )
static void
org_bluez_obex_client_proxy_class_init (orgbluezobexClientProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_obex_client_proxy_g_signal;
}

static void
org_bluez_obex_client_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
org_bluez_obex_client_proxy_init (orgbluezobexClientProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_org_bluez_obex_client_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
org_bluez_obex_client_proxy_create_session_async (orgbluezobexClient* self,
                                                  const gchar* address,
                                                  GHashTable* args,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.Client1", "CreateSession");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (address));
	g_hash_table_iter_init (&_tmp1_, args);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp2_;
		_value = (GVariant*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp0_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static char*
org_bluez_obex_client_proxy_create_session_finish (orgbluezobexClient* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp4_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp4_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	g_object_unref (_reply_message);
	return _result;
}

static void
org_bluez_obex_client_proxy_remove_session_async (orgbluezobexClient* self,
                                                  const char* session,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.Client1", "RemoveSession");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (session));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
org_bluez_obex_client_proxy_remove_session_finish (orgbluezobexClient* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
org_bluez_obex_client_proxy_org_bluez_obex_client_interface_init (orgbluezobexClientIface* iface)
{
	iface->create_session = org_bluez_obex_client_proxy_create_session_async;
	iface->create_session_finish = org_bluez_obex_client_proxy_create_session_finish;
	iface->remove_session = org_bluez_obex_client_proxy_remove_session_async;
	iface->remove_session_finish = org_bluez_obex_client_proxy_remove_session_finish;
}

static void
_dbus_org_bluez_obex_client_create_session (orgbluezobexClient* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	OrgBluezObexClientCreateSessionReadyData* _ready_data;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GHashTable* _tmp7_;
	GVariantIter _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (OrgBluezObexClientCreateSessionReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->address = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp7_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp8_, _tmp6_);
	while (g_variant_iter_loop (&_tmp8_, "{?*}", &_tmp9_, &_tmp10_)) {
		g_hash_table_insert (_tmp7_, g_variant_dup_string (_tmp9_, NULL), g_variant_get_variant (_tmp10_));
	}
	_ready_data->args = _tmp7_;
	g_variant_unref (_tmp6_);
	org_bluez_obex_client_create_session (self, _ready_data->address, _ready_data->args, (GAsyncReadyCallback) _dbus_org_bluez_obex_client_create_session_ready, _ready_data);
	_error:
	;
}

static void
_dbus_org_bluez_obex_client_create_session_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	OrgBluezObexClientCreateSessionReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = org_bluez_obex_client_create_session_finish ((orgbluezobexClient*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->address);
	_g_hash_table_unref0 (_ready_data->args);
	g_slice_free (OrgBluezObexClientCreateSessionReadyData, _ready_data);
}

static void
_dbus_org_bluez_obex_client_remove_session (orgbluezobexClient* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	OrgBluezObexClientRemoveSessionReadyData* _ready_data;
	GVariant* _tmp11_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (OrgBluezObexClientRemoveSessionReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->session = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	org_bluez_obex_client_remove_session (self, _ready_data->session, (GAsyncReadyCallback) _dbus_org_bluez_obex_client_remove_session_ready, _ready_data);
	_error:
	;
}

static void
_dbus_org_bluez_obex_client_remove_session_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	OrgBluezObexClientRemoveSessionReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	org_bluez_obex_client_remove_session_finish ((orgbluezobexClient*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->session);
	g_slice_free (OrgBluezObexClientRemoveSessionReadyData, _ready_data);
}

static void
org_bluez_obex_client_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CreateSession") == 0) {
		_dbus_org_bluez_obex_client_create_session (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveSession") == 0) {
		_dbus_org_bluez_obex_client_remove_session (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
org_bluez_obex_client_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
org_bluez_obex_client_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
org_bluez_obex_client_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_obex_client_dbus_interface_info), &_org_bluez_obex_client_dbus_interface_vtable, data, _org_bluez_obex_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_org_bluez_obex_client_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
org_bluez_obex_phonebook_access_select (orgbluezobexPhonebookAccess* self,
                                        const gchar* location,
                                        const gchar* phonebook,
                                        GError** error)
{
	orgbluezobexPhonebookAccessIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_GET_INTERFACE (self);
	if (_iface_->select) {
		_iface_->select (self, location, phonebook, error);
	}
}

orgbluezobexPhonebookAccessPhonebookEntry*
org_bluez_obex_phonebook_access_list (orgbluezobexPhonebookAccess* self,
                                      GHashTable* filters,
                                      gint* result_length1,
                                      GError** error)
{
	orgbluezobexPhonebookAccessIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_GET_INTERFACE (self);
	if (_iface_->list) {
		return _iface_->list (self, filters, result_length1, error);
	}
	return NULL;
}

gchar**
org_bluez_obex_phonebook_access_list_filter_fields (orgbluezobexPhonebookAccess* self,
                                                    gint* result_length1,
                                                    GError** error)
{
	orgbluezobexPhonebookAccessIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_GET_INTERFACE (self);
	if (_iface_->list_filter_fields) {
		return _iface_->list_filter_fields (self, result_length1, error);
	}
	return NULL;
}

void
org_bluez_obex_phonebook_access_pull_all (orgbluezobexPhonebookAccess* self,
                                          const gchar* target,
                                          GHashTable* filters,
                                          gchar** path,
                                          GHashTable** props,
                                          GError** error)
{
	orgbluezobexPhonebookAccessIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_GET_INTERFACE (self);
	if (_iface_->pull_all) {
		_iface_->pull_all (self, target, filters, path, props, error);
	}
}

void
org_bluez_obex_phonebook_access_phonebook_entry_copy (const orgbluezobexPhonebookAccessPhonebookEntry* self,
                                                      orgbluezobexPhonebookAccessPhonebookEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).vcard;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).vcard);
	(*dest).vcard = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
}

void
org_bluez_obex_phonebook_access_phonebook_entry_destroy (orgbluezobexPhonebookAccessPhonebookEntry* self)
{
	_g_free0 ((*self).vcard);
	_g_free0 ((*self).name);
}

orgbluezobexPhonebookAccessPhonebookEntry*
org_bluez_obex_phonebook_access_phonebook_entry_dup (const orgbluezobexPhonebookAccessPhonebookEntry* self)
{
	orgbluezobexPhonebookAccessPhonebookEntry* dup;
	dup = g_new0 (orgbluezobexPhonebookAccessPhonebookEntry, 1);
	org_bluez_obex_phonebook_access_phonebook_entry_copy (self, dup);
	return dup;
}

void
org_bluez_obex_phonebook_access_phonebook_entry_free (orgbluezobexPhonebookAccessPhonebookEntry* self)
{
	org_bluez_obex_phonebook_access_phonebook_entry_destroy (self);
	g_free (self);
}

static GType
org_bluez_obex_phonebook_access_phonebook_entry_get_type_once (void)
{
	GType org_bluez_obex_phonebook_access_phonebook_entry_type_id;
	org_bluez_obex_phonebook_access_phonebook_entry_type_id = g_boxed_type_register_static ("orgbluezobexPhonebookAccessPhonebookEntry", (GBoxedCopyFunc) org_bluez_obex_phonebook_access_phonebook_entry_dup, (GBoxedFreeFunc) org_bluez_obex_phonebook_access_phonebook_entry_free);
	return org_bluez_obex_phonebook_access_phonebook_entry_type_id;
}

GType
org_bluez_obex_phonebook_access_phonebook_entry_get_type (void)
{
	static volatile gsize org_bluez_obex_phonebook_access_phonebook_entry_type_id__once = 0;
	if (g_once_init_enter (&org_bluez_obex_phonebook_access_phonebook_entry_type_id__once)) {
		GType org_bluez_obex_phonebook_access_phonebook_entry_type_id;
		org_bluez_obex_phonebook_access_phonebook_entry_type_id = org_bluez_obex_phonebook_access_phonebook_entry_get_type_once ();
		g_once_init_leave (&org_bluez_obex_phonebook_access_phonebook_entry_type_id__once, org_bluez_obex_phonebook_access_phonebook_entry_type_id);
	}
	return org_bluez_obex_phonebook_access_phonebook_entry_type_id__once;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
org_bluez_obex_phonebook_access_phonebook_pull_copy (const orgbluezobexPhonebookAccessPhonebookPull* self,
                                                     orgbluezobexPhonebookAccessPhonebookPull* dest)
{
	const char* _tmp0_;
	char* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	_tmp0_ = (*self).path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).props;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).props);
	(*dest).props = _tmp3_;
}

void
org_bluez_obex_phonebook_access_phonebook_pull_destroy (orgbluezobexPhonebookAccessPhonebookPull* self)
{
	_g_free0 ((*self).path);
	_g_hash_table_unref0 ((*self).props);
}

orgbluezobexPhonebookAccessPhonebookPull*
org_bluez_obex_phonebook_access_phonebook_pull_dup (const orgbluezobexPhonebookAccessPhonebookPull* self)
{
	orgbluezobexPhonebookAccessPhonebookPull* dup;
	dup = g_new0 (orgbluezobexPhonebookAccessPhonebookPull, 1);
	org_bluez_obex_phonebook_access_phonebook_pull_copy (self, dup);
	return dup;
}

void
org_bluez_obex_phonebook_access_phonebook_pull_free (orgbluezobexPhonebookAccessPhonebookPull* self)
{
	org_bluez_obex_phonebook_access_phonebook_pull_destroy (self);
	g_free (self);
}

static GType
org_bluez_obex_phonebook_access_phonebook_pull_get_type_once (void)
{
	GType org_bluez_obex_phonebook_access_phonebook_pull_type_id;
	org_bluez_obex_phonebook_access_phonebook_pull_type_id = g_boxed_type_register_static ("orgbluezobexPhonebookAccessPhonebookPull", (GBoxedCopyFunc) org_bluez_obex_phonebook_access_phonebook_pull_dup, (GBoxedFreeFunc) org_bluez_obex_phonebook_access_phonebook_pull_free);
	return org_bluez_obex_phonebook_access_phonebook_pull_type_id;
}

GType
org_bluez_obex_phonebook_access_phonebook_pull_get_type (void)
{
	static volatile gsize org_bluez_obex_phonebook_access_phonebook_pull_type_id__once = 0;
	if (g_once_init_enter (&org_bluez_obex_phonebook_access_phonebook_pull_type_id__once)) {
		GType org_bluez_obex_phonebook_access_phonebook_pull_type_id;
		org_bluez_obex_phonebook_access_phonebook_pull_type_id = org_bluez_obex_phonebook_access_phonebook_pull_get_type_once ();
		g_once_init_leave (&org_bluez_obex_phonebook_access_phonebook_pull_type_id__once, org_bluez_obex_phonebook_access_phonebook_pull_type_id);
	}
	return org_bluez_obex_phonebook_access_phonebook_pull_type_id__once;
}

static void
org_bluez_obex_phonebook_access_default_init (orgbluezobexPhonebookAccessIface * iface,
                                              gpointer iface_data)
{
}

static GType
org_bluez_obex_phonebook_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (orgbluezobexPhonebookAccessIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) org_bluez_obex_phonebook_access_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType org_bluez_obex_phonebook_access_type_id;
	org_bluez_obex_phonebook_access_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezobexPhonebookAccess", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (org_bluez_obex_phonebook_access_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (org_bluez_obex_phonebook_access_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_obex_phonebook_access_proxy_get_type);
	g_type_set_qdata (org_bluez_obex_phonebook_access_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.PhonebookAccess1");
	g_type_set_qdata (org_bluez_obex_phonebook_access_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_obex_phonebook_access_dbus_interface_info));
	g_type_set_qdata (org_bluez_obex_phonebook_access_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_obex_phonebook_access_register_object);
	return org_bluez_obex_phonebook_access_type_id;
}

GType
org_bluez_obex_phonebook_access_get_type (void)
{
	static volatile gsize org_bluez_obex_phonebook_access_type_id__once = 0;
	if (g_once_init_enter (&org_bluez_obex_phonebook_access_type_id__once)) {
		GType org_bluez_obex_phonebook_access_type_id;
		org_bluez_obex_phonebook_access_type_id = org_bluez_obex_phonebook_access_get_type_once ();
		g_once_init_leave (&org_bluez_obex_phonebook_access_type_id__once, org_bluez_obex_phonebook_access_type_id);
	}
	return org_bluez_obex_phonebook_access_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (orgbluezobexPhonebookAccessProxy, org_bluez_obex_phonebook_access_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS, org_bluez_obex_phonebook_access_proxy_org_bluez_obex_phonebook_access_interface_init) )
static void
org_bluez_obex_phonebook_access_proxy_class_init (orgbluezobexPhonebookAccessProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_obex_phonebook_access_proxy_g_signal;
}

static void
org_bluez_obex_phonebook_access_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters)
{
}

static void
org_bluez_obex_phonebook_access_proxy_init (orgbluezobexPhonebookAccessProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_org_bluez_obex_phonebook_access_dbus_interface_info));
}

static void
org_bluez_obex_phonebook_access_proxy_select (orgbluezobexPhonebookAccess* self,
                                              const gchar* location,
                                              const gchar* phonebook,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.PhonebookAccess1", "Select");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (location));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (phonebook));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static orgbluezobexPhonebookAccessPhonebookEntry*
org_bluez_obex_phonebook_access_proxy_list (orgbluezobexPhonebookAccess* self,
                                            GHashTable* filters,
                                            gint* result_length1,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp12_;
	GHashTableIter _tmp13_;
	gpointer _tmp14_;
	gpointer _tmp15_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	orgbluezobexPhonebookAccessPhonebookEntry* _result = NULL;
	gint _result_length1;
	GVariant* _tmp16_;
	orgbluezobexPhonebookAccessPhonebookEntry* _tmp17_;
	gint _tmp17__length;
	gint _tmp17__size;
	gint _tmp17__length1;
	GVariantIter _tmp18_;
	GVariant* _tmp19_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.PhonebookAccess1", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp13_, filters);
	g_variant_builder_init (&_tmp12_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp13_, &_tmp14_, &_tmp15_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp14_;
		_value = (GVariant*) _tmp15_;
		g_variant_builder_add (&_tmp12_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp12_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp16_ = g_variant_iter_next_value (&_reply_iter);
	_tmp17_ = g_new (orgbluezobexPhonebookAccessPhonebookEntry, 5);
	_tmp17__length = 0;
	_tmp17__size = 4;
	_tmp17__length1 = 0;
	g_variant_iter_init (&_tmp18_, _tmp16_);
	for (; (_tmp19_ = g_variant_iter_next_value (&_tmp18_)) != NULL; _tmp17__length1++) {
		orgbluezobexPhonebookAccessPhonebookEntry _tmp20_;
		GVariantIter _tmp21_;
		GVariant* _tmp22_;
		GVariant* _tmp23_;
		if (_tmp17__size == _tmp17__length) {
			_tmp17__size = 2 * _tmp17__size;
			_tmp17_ = g_renew (orgbluezobexPhonebookAccessPhonebookEntry, _tmp17_, _tmp17__size + 1);
		}
		g_variant_iter_init (&_tmp21_, _tmp19_);
		_tmp22_ = g_variant_iter_next_value (&_tmp21_);
		_tmp20_.vcard = g_variant_dup_string (_tmp22_, NULL);
		g_variant_unref (_tmp22_);
		_tmp23_ = g_variant_iter_next_value (&_tmp21_);
		_tmp20_.name = g_variant_dup_string (_tmp23_, NULL);
		g_variant_unref (_tmp23_);
		_tmp17_[_tmp17__length++] = _tmp20_;
		g_variant_unref (_tmp19_);
	}
	_result_length1 = _tmp17__length1;
	_result = _tmp17_;
	g_variant_unref (_tmp16_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
org_bluez_obex_phonebook_access_proxy_list_filter_fields (orgbluezobexPhonebookAccess* self,
                                                          gint* result_length1,
                                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.PhonebookAccess1", "ListFilterFields");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp24_ = g_variant_iter_next_value (&_reply_iter);
	_tmp25_ = g_new (gchar*, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (gchar*, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
	}
	_result_length1 = _tmp25__length1;
	_tmp25_[_tmp25__length] = NULL;
	_result = _tmp25_;
	g_variant_unref (_tmp24_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
org_bluez_obex_phonebook_access_proxy_pull_all (orgbluezobexPhonebookAccess* self,
                                                const gchar* target,
                                                GHashTable* filters,
                                                gchar** path,
                                                GHashTable** props,
                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp28_;
	GHashTableIter _tmp29_;
	gpointer _tmp30_;
	gpointer _tmp31_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_path = NULL;
	GVariant* _tmp32_;
	GHashTable* _vala_props = NULL;
	GVariant* _tmp33_;
	GHashTable* _tmp34_;
	GVariantIter _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.PhonebookAccess1", "PullAll");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (target));
	g_hash_table_iter_init (&_tmp29_, filters);
	g_variant_builder_init (&_tmp28_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp29_, &_tmp30_, &_tmp31_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp30_;
		_value = (GVariant*) _tmp31_;
		g_variant_builder_add (&_tmp28_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp28_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp32_ = g_variant_iter_next_value (&_reply_iter);
	_vala_path = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	*path = _vala_path;
	_tmp33_ = g_variant_iter_next_value (&_reply_iter);
	_tmp34_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp35_, _tmp33_);
	while (g_variant_iter_loop (&_tmp35_, "{?*}", &_tmp36_, &_tmp37_)) {
		g_hash_table_insert (_tmp34_, g_variant_dup_string (_tmp36_, NULL), g_variant_get_variant (_tmp37_));
	}
	_vala_props = _tmp34_;
	g_variant_unref (_tmp33_);
	*props = _vala_props;
	g_object_unref (_reply_message);
}

static void
org_bluez_obex_phonebook_access_proxy_org_bluez_obex_phonebook_access_interface_init (orgbluezobexPhonebookAccessIface* iface)
{
	iface->select = org_bluez_obex_phonebook_access_proxy_select;
	iface->list = org_bluez_obex_phonebook_access_proxy_list;
	iface->list_filter_fields = org_bluez_obex_phonebook_access_proxy_list_filter_fields;
	iface->pull_all = org_bluez_obex_phonebook_access_proxy_pull_all;
}

static void
_dbus_org_bluez_obex_phonebook_access_select (orgbluezobexPhonebookAccess* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* location = NULL;
	GVariant* _tmp38_;
	gchar* phonebook = NULL;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	location = g_variant_dup_string (_tmp38_, NULL);
	g_variant_unref (_tmp38_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	phonebook = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	org_bluez_obex_phonebook_access_select (self, location, phonebook, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (location);
	_g_free0 (phonebook);
	;
}

static void
_vala_orgbluezobexPhonebookAccessPhonebookEntry_array_free (orgbluezobexPhonebookAccessPhonebookEntry * array,
                                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			org_bluez_obex_phonebook_access_phonebook_entry_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_org_bluez_obex_phonebook_access_list (orgbluezobexPhonebookAccess* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* filters = NULL;
	GVariant* _tmp40_;
	GHashTable* _tmp41_;
	GVariantIter _tmp42_;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	orgbluezobexPhonebookAccessPhonebookEntry* result;
	gint result_length1 = 0;
	orgbluezobexPhonebookAccessPhonebookEntry* _tmp45_;
	GVariantBuilder _tmp46_;
	gint _tmp47_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp41_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp42_, _tmp40_);
	while (g_variant_iter_loop (&_tmp42_, "{?*}", &_tmp43_, &_tmp44_)) {
		g_hash_table_insert (_tmp41_, g_variant_dup_string (_tmp43_, NULL), g_variant_get_variant (_tmp44_));
	}
	filters = _tmp41_;
	g_variant_unref (_tmp40_);
	result = org_bluez_obex_phonebook_access_list (self, filters, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp45_ = result;
	g_variant_builder_init (&_tmp46_, G_VARIANT_TYPE ("a(ss)"));
	for (_tmp47_ = 0; _tmp47_ < result_length1; _tmp47_++) {
		GVariantBuilder _tmp48_;
		g_variant_builder_init (&_tmp48_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp48_, g_variant_new_string ((*_tmp45_).vcard));
		g_variant_builder_add_value (&_tmp48_, g_variant_new_string ((*_tmp45_).name));
		g_variant_builder_add_value (&_tmp46_, g_variant_builder_end (&_tmp48_));
		_tmp45_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp46_));
	result = (_vala_orgbluezobexPhonebookAccessPhonebookEntry_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (filters);
	;
}

static void
_dbus_org_bluez_obex_phonebook_access_list_filter_fields (orgbluezobexPhonebookAccess* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp49_;
	GVariantBuilder _tmp50_;
	gint _tmp51_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = org_bluez_obex_phonebook_access_list_filter_fields (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp49_ = result;
	g_variant_builder_init (&_tmp50_, G_VARIANT_TYPE ("as"));
	for (_tmp51_ = 0; _tmp51_ < result_length1; _tmp51_++) {
		g_variant_builder_add_value (&_tmp50_, g_variant_new_string (*_tmp49_));
		_tmp49_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp50_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_org_bluez_obex_phonebook_access_pull_all (orgbluezobexPhonebookAccess* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* target = NULL;
	GVariant* _tmp52_;
	GHashTable* filters = NULL;
	GVariant* _tmp53_;
	GHashTable* _tmp54_;
	GVariantIter _tmp55_;
	GVariant* _tmp56_;
	GVariant* _tmp57_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* path = NULL;
	GHashTable* props = NULL;
	GVariantBuilder _tmp58_;
	GHashTableIter _tmp59_;
	gpointer _tmp60_;
	gpointer _tmp61_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp52_ = g_variant_iter_next_value (&_arguments_iter);
	target = g_variant_dup_string (_tmp52_, NULL);
	g_variant_unref (_tmp52_);
	_tmp53_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp54_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp55_, _tmp53_);
	while (g_variant_iter_loop (&_tmp55_, "{?*}", &_tmp56_, &_tmp57_)) {
		g_hash_table_insert (_tmp54_, g_variant_dup_string (_tmp56_, NULL), g_variant_get_variant (_tmp57_));
	}
	filters = _tmp54_;
	g_variant_unref (_tmp53_);
	org_bluez_obex_phonebook_access_pull_all (self, target, filters, &path, &props, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (path));
	g_hash_table_iter_init (&_tmp59_, props);
	g_variant_builder_init (&_tmp58_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp59_, &_tmp60_, &_tmp61_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp60_;
		_value = (GVariant*) _tmp61_;
		g_variant_builder_add (&_tmp58_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp58_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (target);
	_g_hash_table_unref0 (filters);
	_g_free0 (path);
	_g_hash_table_unref0 (props);
	;
}

static void
org_bluez_obex_phonebook_access_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Select") == 0) {
		_dbus_org_bluez_obex_phonebook_access_select (object, parameters, invocation);
	} else if (strcmp (method_name, "List") == 0) {
		_dbus_org_bluez_obex_phonebook_access_list (object, parameters, invocation);
	} else if (strcmp (method_name, "ListFilterFields") == 0) {
		_dbus_org_bluez_obex_phonebook_access_list_filter_fields (object, parameters, invocation);
	} else if (strcmp (method_name, "PullAll") == 0) {
		_dbus_org_bluez_obex_phonebook_access_pull_all (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
org_bluez_obex_phonebook_access_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
org_bluez_obex_phonebook_access_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
org_bluez_obex_phonebook_access_register_object (gpointer object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_obex_phonebook_access_dbus_interface_info), &_org_bluez_obex_phonebook_access_dbus_interface_vtable, data, _org_bluez_obex_phonebook_access_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_org_bluez_obex_phonebook_access_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
org_bluez_obex_transfer_cancel (orgbluezobexTransfer* self,
                                GError** error)
{
	orgbluezobexTransferIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->cancel) {
		_iface_->cancel (self, error);
	}
}

gchar*
org_bluez_obex_transfer_get_status (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_status) {
		return _iface_->get_status (self);
	}
	return NULL;
}

char*
org_bluez_obex_transfer_get_session (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_session) {
		return _iface_->get_session (self);
	}
	return NULL;
}

gchar*
org_bluez_obex_transfer_get_name (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gchar*
org_bluez_obex_transfer_get_transfer_type (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_transfer_type) {
		return _iface_->get_transfer_type (self);
	}
	return NULL;
}

gint64
org_bluez_obex_transfer_get_time (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0LL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_time) {
		return _iface_->get_time (self);
	}
	return -1LL;
}

guint64
org_bluez_obex_transfer_get_size (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_size) {
		return _iface_->get_size (self);
	}
	return 0ULL;
}

guint64
org_bluez_obex_transfer_get_transferred (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_transferred) {
		return _iface_->get_transferred (self);
	}
	return 0ULL;
}

gchar*
org_bluez_obex_transfer_get_filename (orgbluezobexTransfer* self)
{
	orgbluezobexTransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_filename) {
		return _iface_->get_filename (self);
	}
	return NULL;
}

static void
org_bluez_obex_transfer_default_init (orgbluezobexTransferIface * iface,
                                      gpointer iface_data)
{
}

static GType
org_bluez_obex_transfer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (orgbluezobexTransferIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) org_bluez_obex_transfer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType org_bluez_obex_transfer_type_id;
	org_bluez_obex_transfer_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezobexTransfer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (org_bluez_obex_transfer_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (org_bluez_obex_transfer_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_obex_transfer_proxy_get_type);
	g_type_set_qdata (org_bluez_obex_transfer_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.Transfer1");
	g_type_set_qdata (org_bluez_obex_transfer_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_obex_transfer_dbus_interface_info));
	g_type_set_qdata (org_bluez_obex_transfer_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_obex_transfer_register_object);
	return org_bluez_obex_transfer_type_id;
}

GType
org_bluez_obex_transfer_get_type (void)
{
	static volatile gsize org_bluez_obex_transfer_type_id__once = 0;
	if (g_once_init_enter (&org_bluez_obex_transfer_type_id__once)) {
		GType org_bluez_obex_transfer_type_id;
		org_bluez_obex_transfer_type_id = org_bluez_obex_transfer_get_type_once ();
		g_once_init_leave (&org_bluez_obex_transfer_type_id__once, org_bluez_obex_transfer_type_id);
	}
	return org_bluez_obex_transfer_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (orgbluezobexTransferProxy, org_bluez_obex_transfer_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_OBEX_TYPE_TRANSFER, org_bluez_obex_transfer_proxy_org_bluez_obex_transfer_interface_init) )
static void
org_bluez_obex_transfer_proxy_class_init (orgbluezobexTransferProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_obex_transfer_proxy_g_signal;
}

static void
org_bluez_obex_transfer_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
org_bluez_obex_transfer_proxy_init (orgbluezobexTransferProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_org_bluez_obex_transfer_dbus_interface_info));
}

static void
org_bluez_obex_transfer_proxy_cancel (orgbluezobexTransfer* self,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.Transfer1", "Cancel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
org_bluez_obex_transfer_dbus_proxy_get_status (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Status");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Status"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
org_bluez_obex_transfer_dbus_proxy_get_session (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Session");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Session"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
org_bluez_obex_transfer_dbus_proxy_get_name (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
org_bluez_obex_transfer_dbus_proxy_get_transfer_type (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Type");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Type"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gint64
org_bluez_obex_transfer_dbus_proxy_get_time (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	gint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Time");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Time"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint64 _tmp62_ = 0LL;
			return _tmp62_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
org_bluez_obex_transfer_dbus_proxy_get_size (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Size");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Size"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp63_ = 0ULL;
			return _tmp63_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
org_bluez_obex_transfer_dbus_proxy_get_transferred (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Transferred");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Transferred"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp64_ = 0ULL;
			return _tmp64_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
org_bluez_obex_transfer_dbus_proxy_get_filename (orgbluezobexTransfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Filename");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Filename"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
org_bluez_obex_transfer_proxy_org_bluez_obex_transfer_interface_init (orgbluezobexTransferIface* iface)
{
	iface->cancel = org_bluez_obex_transfer_proxy_cancel;
	iface->get_status = org_bluez_obex_transfer_dbus_proxy_get_status;
	iface->get_session = org_bluez_obex_transfer_dbus_proxy_get_session;
	iface->get_name = org_bluez_obex_transfer_dbus_proxy_get_name;
	iface->get_transfer_type = org_bluez_obex_transfer_dbus_proxy_get_transfer_type;
	iface->get_time = org_bluez_obex_transfer_dbus_proxy_get_time;
	iface->get_size = org_bluez_obex_transfer_dbus_proxy_get_size;
	iface->get_transferred = org_bluez_obex_transfer_dbus_proxy_get_transferred;
	iface->get_filename = org_bluez_obex_transfer_dbus_proxy_get_filename;
}

static void
_dbus_org_bluez_obex_transfer_cancel (orgbluezobexTransfer* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	org_bluez_obex_transfer_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
org_bluez_obex_transfer_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Cancel") == 0) {
		_dbus_org_bluez_obex_transfer_cancel (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_status (orgbluezobexTransfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_status (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_session (orgbluezobexTransfer* self)
{
	char* result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_session (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_name (orgbluezobexTransfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_transfer_type (orgbluezobexTransfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_transfer_type (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_time (orgbluezobexTransfer* self)
{
	gint64 result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_time (self);
	_reply = g_variant_new_int64 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_size (orgbluezobexTransfer* self)
{
	guint64 result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_size (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_transferred (orgbluezobexTransfer* self)
{
	guint64 result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_transferred (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
_dbus_org_bluez_obex_transfer_get_filename (orgbluezobexTransfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = org_bluez_obex_transfer_get_filename (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
org_bluez_obex_transfer_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Status") == 0) {
		return _dbus_org_bluez_obex_transfer_get_status (object);
	} else if (strcmp (property_name, "Session") == 0) {
		return _dbus_org_bluez_obex_transfer_get_session (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_org_bluez_obex_transfer_get_name (object);
	} else if (strcmp (property_name, "Type") == 0) {
		return _dbus_org_bluez_obex_transfer_get_transfer_type (object);
	} else if (strcmp (property_name, "Time") == 0) {
		return _dbus_org_bluez_obex_transfer_get_time (object);
	} else if (strcmp (property_name, "Size") == 0) {
		return _dbus_org_bluez_obex_transfer_get_size (object);
	} else if (strcmp (property_name, "Transferred") == 0) {
		return _dbus_org_bluez_obex_transfer_get_transferred (object);
	} else if (strcmp (property_name, "Filename") == 0) {
		return _dbus_org_bluez_obex_transfer_get_filename (object);
	}
	return NULL;
}

static gboolean
org_bluez_obex_transfer_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
org_bluez_obex_transfer_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_obex_transfer_dbus_interface_info), &_org_bluez_obex_transfer_dbus_interface_vtable, data, _org_bluez_obex_transfer_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_org_bluez_obex_transfer_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

