/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StuckThreadDetectionValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(StuckThreadDetectionValve.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    private final AtomicInteger stuckCount = new AtomicInteger(0);
    private AtomicLong interruptedThreadsCount = new AtomicLong();
    private int threshold = 600;
    private int interruptThreadThreshold;
    private final Map<Long, MonitoredThread> activeThreads = new ConcurrentHashMap<Long, MonitoredThread>();
    private final Queue<CompletedStuckThread> completedStuckThreadsQueue = new ConcurrentLinkedQueue<CompletedStuckThread>();

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getInterruptThreadThreshold() {
        return this.interruptThreadThreshold;
    }

    public void setInterruptThreadThreshold(int n) {
        this.interruptThreadThreshold = n;
    }

    public StuckThreadDetectionValve() {
        super(true);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Monitoring stuck threads with threshold = " + this.threshold + " sec"));
        }
    }

    private void notifyStuckThreadDetected(MonitoredThread monitoredThread, long l, int n) {
        if (log.isWarnEnabled()) {
            String string = sm.getString("stuckThreadDetectionValve.notifyStuckThreadDetected", new Object[]{monitoredThread.getThread().getName(), l, monitoredThread.getStartTime(), n, monitoredThread.getRequestUri(), this.threshold, String.valueOf(monitoredThread.getThread().getId())});
            Throwable throwable = new Throwable();
            throwable.setStackTrace(monitoredThread.getThread().getStackTrace());
            log.warn((Object)string, throwable);
        }
    }

    private void notifyStuckThreadCompleted(CompletedStuckThread completedStuckThread, int n) {
        if (log.isWarnEnabled()) {
            String string = sm.getString("stuckThreadDetectionValve.notifyStuckThreadCompleted", new Object[]{completedStuckThread.getName(), completedStuckThread.getTotalActiveTime(), n, String.valueOf(completedStuckThread.getId())});
            log.warn((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.threshold <= 0) {
            this.getNext().invoke(request, response);
            return;
        }
        Long l = Thread.currentThread().getId();
        StringBuffer stringBuffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            stringBuffer.append('?');
            stringBuffer.append(request.getQueryString());
        }
        MonitoredThread monitoredThread = new MonitoredThread(Thread.currentThread(), stringBuffer.toString(), this.interruptThreadThreshold > 0);
        this.activeThreads.put(l, monitoredThread);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.activeThreads.remove(l);
            if (monitoredThread.markAsDone() == MonitoredThreadState.STUCK) {
                if (monitoredThread.wasInterrupted()) {
                    this.interruptedThreadsCount.incrementAndGet();
                }
                this.completedStuckThreadsQueue.add(new CompletedStuckThread(monitoredThread.getThread(), monitoredThread.getActiveTimeInMillis()));
            }
        }
    }

    @Override
    public void backgroundProcess() {
        super.backgroundProcess();
        long l = (long)this.threshold * 1000L;
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            long l2 = monitoredThread.getActiveTimeInMillis();
            if (l2 >= l && monitoredThread.markAsStuckIfStillRunning()) {
                int n = this.stuckCount.incrementAndGet();
                this.notifyStuckThreadDetected(monitoredThread, l2, n);
            }
            if (this.interruptThreadThreshold <= 0 || l2 < (long)this.interruptThreadThreshold * 1000L) continue;
            monitoredThread.interruptIfStuck(this.interruptThreadThreshold);
        }
        Object object = this.completedStuckThreadsQueue.poll();
        while (object != null) {
            int n = this.stuckCount.decrementAndGet();
            this.notifyStuckThreadCompleted((CompletedStuckThread)object, n);
            object = this.completedStuckThreadsQueue.poll();
        }
    }

    public int getStuckThreadCount() {
        return this.stuckCount.get();
    }

    public long[] getStuckThreadIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            if (!monitoredThread.isMarkedAsStuck()) continue;
            arrayList.add(monitoredThread.getThread().getId());
        }
        Object object = new long[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Long)arrayList.get(i);
        }
        return object;
    }

    public String[] getStuckThreadNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            if (!monitoredThread.isMarkedAsStuck()) continue;
            arrayList.add(monitoredThread.getThread().getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public long getInterruptedThreadsCount() {
        return this.interruptedThreadsCount.get();
    }

    private static enum MonitoredThreadState {
        RUNNING,
        STUCK,
        DONE;

    }

    private static class CompletedStuckThread {
        private final String threadName;
        private final long threadId;
        private final long totalActiveTime;

        CompletedStuckThread(Thread thread, long l) {
            this.threadName = thread.getName();
            this.threadId = thread.getId();
            this.totalActiveTime = l;
        }

        public String getName() {
            return this.threadName;
        }

        public long getId() {
            return this.threadId;
        }

        public long getTotalActiveTime() {
            return this.totalActiveTime;
        }
    }

    private static class MonitoredThread {
        private final Thread thread;
        private final String requestUri;
        private final long start;
        private final AtomicInteger state = new AtomicInteger(MonitoredThreadState.RUNNING.ordinal());
        private final Semaphore interruptionSemaphore;
        private boolean interrupted;

        MonitoredThread(Thread thread, String string, boolean bl) {
            this.thread = thread;
            this.requestUri = string;
            this.start = System.currentTimeMillis();
            this.interruptionSemaphore = bl ? new Semaphore(1) : null;
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public long getActiveTimeInMillis() {
            return System.currentTimeMillis() - this.start;
        }

        public Date getStartTime() {
            return new Date(this.start);
        }

        public boolean markAsStuckIfStillRunning() {
            return this.state.compareAndSet(MonitoredThreadState.RUNNING.ordinal(), MonitoredThreadState.STUCK.ordinal());
        }

        public MonitoredThreadState markAsDone() {
            int n = this.state.getAndSet(MonitoredThreadState.DONE.ordinal());
            MonitoredThreadState monitoredThreadState = MonitoredThreadState.values()[n];
            if (monitoredThreadState == MonitoredThreadState.STUCK && this.interruptionSemaphore != null) {
                try {
                    this.interruptionSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    log.debug((Object)"thread interrupted after the request is finished, ignoring", (Throwable)interruptedException);
                }
            }
            return monitoredThreadState;
        }

        boolean isMarkedAsStuck() {
            return this.state.get() == MonitoredThreadState.STUCK.ordinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean interruptIfStuck(long l) {
            if (!this.isMarkedAsStuck() || this.interruptionSemaphore == null || !this.interruptionSemaphore.tryAcquire()) {
                return false;
            }
            try {
                if (log.isWarnEnabled()) {
                    String string = sm.getString("stuckThreadDetectionValve.notifyStuckThreadInterrupted", new Object[]{this.getThread().getName(), this.getActiveTimeInMillis(), this.getStartTime(), this.getRequestUri(), l, String.valueOf(this.getThread().getId())});
                    Throwable throwable = new Throwable();
                    throwable.setStackTrace(this.getThread().getStackTrace());
                    log.warn((Object)string, throwable);
                }
                this.thread.interrupt();
            }
            finally {
                this.interrupted = true;
                this.interruptionSemaphore.release();
            }
            return true;
        }

        public boolean wasInterrupted() {
            return this.interrupted;
        }
    }
}

