/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.osmand.PlatformUtil;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class BinaryRoutePlanner {
    private static final int TEST_ID = 31370645;
    private static final boolean TEST_SPECIFIC = false;
    private static final int REVERSE_WAY_RESTRICTION_ONLY = 1024;
    static final int STANDARD_ROAD_IN_QUEUE_OVERHEAD = 220;
    static final int STANDARD_ROAD_VISITED_OVERHEAD = 150;
    protected static final Log log = PlatformUtil.getLog(BinaryRoutePlanner.class);
    private static final int ROUTE_POINTS = 11;
    private static final boolean TRACE_ROUTING = false;

    public static double squareRootDist(int x1, int y1, int x2, int y2) {
        double dy = MapUtils.convert31YToMeters(y1, y2);
        double dx = MapUtils.convert31XToMeters(x1, x2);
        return Math.sqrt(dx * dx + dy * dy);
    }

    FinalRouteSegment searchRouteInternal(RoutingContext ctx, RouteSegmentPoint start, RouteSegmentPoint end, RouteSegment recalculationEnd) throws InterruptedException, IOException {
        boolean onlyForward;
        ctx.timeToLoad = 0L;
        ctx.visitedSegments = 0;
        ctx.memoryOverhead = 1000;
        ctx.timeToCalculate = System.nanoTime();
        NonHeuristicSegmentsComparator nonHeuristicSegmentsComparator = new NonHeuristicSegmentsComparator();
        PriorityQueue<RouteSegment> graphDirectSegments = new PriorityQueue<RouteSegment>(50, new SegmentsComparator(ctx));
        PriorityQueue<RouteSegment> graphReverseSegments = new PriorityQueue<RouteSegment>(50, new SegmentsComparator(ctx));
        TLongObjectHashMap visitedDirectSegments = new TLongObjectHashMap();
        TLongObjectHashMap visitedOppositeSegments = new TLongObjectHashMap();
        this.initQueuesWithStartEnd(ctx, start, end, recalculationEnd, graphDirectSegments, graphReverseSegments);
        boolean forwardSearch = true;
        PriorityQueue<RouteSegment> graphSegments = graphDirectSegments;
        FinalRouteSegment finalSegment = null;
        boolean onlyBackward = ctx.getPlanRoadDirection() < 0;
        boolean bl = onlyForward = ctx.getPlanRoadDirection() > 0;
        while (!graphSegments.isEmpty()) {
            boolean doNotAddIntersections;
            RouteSegment segment = graphSegments.poll();
            ctx.memoryOverhead = (visitedDirectSegments.size() + visitedOppositeSegments.size()) * 150 + (graphDirectSegments.size() + graphReverseSegments.size()) * 220;
            if (segment instanceof FinalRouteSegment) {
                finalSegment = (FinalRouteSegment)segment;
                break;
            }
            if ((double)ctx.memoryOverhead > (double)ctx.config.memoryLimitation * 0.95) {
                // empty if block
            }
            if ((double)ctx.memoryOverhead > (double)ctx.config.memoryLimitation * 0.95) {
                throw new IllegalStateException("There is no enough memory " + ctx.config.memoryLimitation / 0x100000 + " Mb");
            }
            ++ctx.visitedSegments;
            if (forwardSearch) {
                doNotAddIntersections = onlyBackward;
                this.processRouteSegment(ctx, false, graphDirectSegments, (TLongObjectHashMap<RouteSegment>)visitedDirectSegments, segment, (TLongObjectHashMap<RouteSegment>)visitedOppositeSegments, doNotAddIntersections);
            } else {
                doNotAddIntersections = onlyForward;
                this.processRouteSegment(ctx, true, graphReverseSegments, (TLongObjectHashMap<RouteSegment>)visitedOppositeSegments, segment, (TLongObjectHashMap<RouteSegment>)visitedDirectSegments, doNotAddIntersections);
            }
            this.updateCalculationProgress(ctx, graphDirectSegments, graphReverseSegments);
            this.checkIfGraphIsEmpty(ctx, ctx.getPlanRoadDirection() <= 0, graphReverseSegments, end, (TLongObjectHashMap<RouteSegment>)visitedOppositeSegments, "Route is not found to selected target point.");
            this.checkIfGraphIsEmpty(ctx, ctx.getPlanRoadDirection() >= 0, graphDirectSegments, start, (TLongObjectHashMap<RouteSegment>)visitedDirectSegments, "Route is not found from selected start point.");
            if (ctx.planRouteIn2Directions()) {
                forwardSearch = nonHeuristicSegmentsComparator.compare(graphDirectSegments.peek(), graphReverseSegments.peek()) < 0;
            } else {
                forwardSearch = onlyForward;
                if (onlyBackward && !graphDirectSegments.isEmpty()) {
                    forwardSearch = true;
                }
                if (onlyForward && !graphReverseSegments.isEmpty()) {
                    forwardSearch = false;
                }
            }
            graphSegments = forwardSearch ? graphDirectSegments : graphReverseSegments;
            if (ctx.calculationProgress == null || !ctx.calculationProgress.isCancelled) continue;
            throw new InterruptedException("Route calculation interrupted");
        }
        this.printDebugMemoryInformation(ctx, graphDirectSegments, graphReverseSegments, (TLongObjectHashMap<RouteSegment>)visitedDirectSegments, (TLongObjectHashMap<RouteSegment>)visitedOppositeSegments);
        return finalSegment;
    }

    protected void checkIfGraphIsEmpty(RoutingContext ctx, boolean allowDirection, PriorityQueue<RouteSegment> graphSegments, RouteSegmentPoint pnt, TLongObjectHashMap<RouteSegment> visited, String msg) {
        if (allowDirection && graphSegments.isEmpty() && pnt.others != null) {
            Iterator<RouteSegmentPoint> pntIterator = pnt.others.iterator();
            while (pntIterator.hasNext()) {
                RouteSegmentPoint next = pntIterator.next();
                boolean visitedAlready = false;
                if (next.getSegmentStart() > 0 && visited.containsKey(this.calculateRoutePointId(next, false))) {
                    visitedAlready = true;
                } else if (next.getSegmentStart() < next.getRoad().getPointsLength() - 1 && visited.containsKey(this.calculateRoutePointId(next, true))) {
                    visitedAlready = true;
                }
                pntIterator.remove();
                if (visitedAlready) continue;
                float estimatedDistance = this.estimatedDistance(ctx, ctx.targetX, ctx.targetY, ctx.startX, ctx.startY);
                RouteSegment pos = next.initRouteSegment(true);
                RouteSegment neg = next.initRouteSegment(false);
                if (pos != null) {
                    pos.distanceToEnd = estimatedDistance;
                    graphSegments.add(pos);
                }
                if (neg != null) {
                    neg.distanceToEnd = estimatedDistance;
                    graphSegments.add(neg);
                }
                BinaryRoutePlanner.println("Reiterate point with new start/destination " + next.getRoad());
                break;
            }
            if (graphSegments.isEmpty()) {
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public RouteSegment initRouteSegment(RoutingContext ctx, RouteSegment segment, boolean positiveDirection) {
        if (segment.getSegmentStart() == 0 && !positiveDirection && segment.getRoad().getPointsLength() > 0) {
            segment = this.loadSameSegment(ctx, segment, 1);
        } else if (segment.getSegmentStart() == segment.getRoad().getPointsLength() - 1 && positiveDirection && segment.getSegmentStart() > 0) {
            segment = this.loadSameSegment(ctx, segment, segment.getSegmentStart() - 1);
        }
        if (segment == null) {
            return null;
        }
        return segment.initRouteSegment(positiveDirection);
    }

    protected RouteSegment loadSameSegment(RoutingContext ctx, RouteSegment segment, int ind) {
        int x31 = segment.getRoad().getPoint31XTile(ind);
        int y31 = segment.getRoad().getPoint31YTile(ind);
        for (RouteSegment s = ctx.loadRouteSegment(x31, y31, 0); s != null; s = s.getNext()) {
            if (s.getRoad().getId() != segment.getRoad().getId()) continue;
            segment = s;
            break;
        }
        return segment;
    }

    private void initQueuesWithStartEnd(RoutingContext ctx, RouteSegment start, RouteSegment end, RouteSegment recalculationEnd, PriorityQueue<RouteSegment> graphDirectSegments, PriorityQueue<RouteSegment> graphReverseSegments) {
        RouteSegment startPos = this.initRouteSegment(ctx, start, true);
        RouteSegment startNeg = this.initRouteSegment(ctx, start, false);
        RouteSegment endPos = this.initRouteSegment(ctx, end, true);
        RouteSegment endNeg = this.initRouteSegment(ctx, end, false);
        if (ctx.config.initialDirection != null) {
            double plusDir = start.getRoad().directionRoute(start.getSegmentStart(), true);
            double diff = plusDir - ctx.config.initialDirection;
            if (Math.abs(MapUtils.alignAngleDifference(diff)) <= 1.0471975511965976) {
                if (startNeg != null) {
                    startNeg.distanceFromStart += 500.0f;
                }
            } else if (Math.abs(MapUtils.alignAngleDifference(diff - Math.PI)) <= 1.0471975511965976 && startPos != null) {
                startPos.distanceFromStart += 500.0f;
            }
        }
        if (recalculationEnd != null) {
            ctx.targetX = recalculationEnd.getRoad().getPoint31XTile(recalculationEnd.getSegmentStart());
            ctx.targetY = recalculationEnd.getRoad().getPoint31YTile(recalculationEnd.getSegmentStart());
        }
        float estimatedDistance = this.estimatedDistance(ctx, ctx.targetX, ctx.targetY, ctx.startX, ctx.startY);
        if (startPos != null) {
            startPos.distanceToEnd = estimatedDistance;
            graphDirectSegments.add(startPos);
        }
        if (startNeg != null) {
            startNeg.distanceToEnd = estimatedDistance;
            graphDirectSegments.add(startNeg);
        }
        if (recalculationEnd != null) {
            graphReverseSegments.add(recalculationEnd);
        } else {
            if (endPos != null) {
                endPos.distanceToEnd = estimatedDistance;
                graphReverseSegments.add(endPos);
            }
            if (endNeg != null) {
                endNeg.distanceToEnd = estimatedDistance;
                graphReverseSegments.add(endNeg);
            }
        }
    }

    private void printMemoryConsumption(String string2) {
        long h1 = RoutingContext.runGCUsedMemory();
        float mb = 1048576.0f;
        log.warn((Object)(string2 + (float)h1 / mb));
    }

    private void updateCalculationProgress(RoutingContext ctx, PriorityQueue<RouteSegment> graphDirectSegments, PriorityQueue<RouteSegment> graphReverseSegments) {
        if (ctx.calculationProgress != null) {
            RouteSegment peek;
            ctx.calculationProgress.reverseSegmentQueueSize = graphReverseSegments.size();
            ctx.calculationProgress.directSegmentQueueSize = graphDirectSegments.size();
            if (graphDirectSegments.size() > 0 && ctx.getPlanRoadDirection() >= 0) {
                peek = graphDirectSegments.peek();
                ctx.calculationProgress.distanceFromBegin = Math.max(peek.distanceFromStart, ctx.calculationProgress.distanceFromBegin);
                ctx.calculationProgress.directDistance = peek.distanceFromStart + peek.distanceToEnd;
            }
            if (graphReverseSegments.size() > 0 && ctx.getPlanRoadDirection() <= 0) {
                peek = graphReverseSegments.peek();
                ctx.calculationProgress.distanceFromEnd = Math.max(peek.distanceFromStart + peek.distanceToEnd, ctx.calculationProgress.distanceFromEnd);
                ctx.calculationProgress.reverseDistance = peek.distanceFromStart + peek.distanceToEnd;
            }
        }
    }

    private void printRoad(String prefix, RouteSegment segment, Boolean reverseWaySearch) {
        String pr = segment.parentRoute != null ? " pend=" + segment.parentSegmentEnd + " parent=" + segment.parentRoute.road : "";
        String p = "";
        if (reverseWaySearch != null) {
            p = reverseWaySearch != false ? "B" : "F";
        }
        BinaryRoutePlanner.println(p + prefix + "" + segment.road + " dir=" + segment.getDirectionAssigned() + " ind=" + segment.getSegmentStart() + " ds=" + segment.distanceFromStart + " es=" + segment.distanceToEnd + pr);
    }

    private float estimatedDistance(RoutingContext ctx, int targetEndX, int targetEndY, int startX, int startY) {
        double distance = BinaryRoutePlanner.squareRootDist(startX, startY, targetEndX, targetEndY);
        return (float)(distance / (double)ctx.getRouter().getMaxDefaultSpeed());
    }

    protected static float h(RoutingContext ctx, int begX, int begY, int endX, int endY) {
        float te;
        double distToFinalPoint = BinaryRoutePlanner.squareRootDist(begX, begY, endX, endY);
        double result = distToFinalPoint / (double)ctx.getRouter().getMaxDefaultSpeed();
        if (ctx.precalculatedRouteDirection != null && (te = ctx.precalculatedRouteDirection.timeEstimate(begX, begY, endX, endY)) > 0.0f) {
            return te;
        }
        return (float)result;
    }

    private static void println(String logMsg) {
        System.out.println(logMsg);
    }

    private static void printInfo(String logMsg) {
        log.warn((Object)logMsg);
    }

    public void printDebugMemoryInformation(RoutingContext ctx, PriorityQueue<RouteSegment> graphDirectSegments, PriorityQueue<RouteSegment> graphReverseSegments, TLongObjectHashMap<RouteSegment> visitedDirectSegments, TLongObjectHashMap<RouteSegment> visitedOppositeSegments) {
        BinaryRoutePlanner.printInfo("Time to calculate : " + (double)(System.nanoTime() - ctx.timeToCalculate) / 1000000.0 + ", time to load : " + (double)ctx.timeToLoad / 1000000.0 + ", time to load headers : " + (double)ctx.timeToLoadHeaders / 1000000.0 + ", time to calc dev : " + (double)ctx.timeNanoToCalcDeviation / 1000000.0);
        int maxLoadedTiles = Math.max(ctx.maxLoadedTiles, ctx.getCurrentlyLoadedTiles());
        BinaryRoutePlanner.printInfo("Current loaded tiles : " + ctx.getCurrentlyLoadedTiles() + ", maximum loaded tiles " + maxLoadedTiles);
        BinaryRoutePlanner.printInfo("Loaded tiles " + ctx.loadedTiles + " (distinct " + ctx.distinctLoadedTiles + "), unloaded tiles " + ctx.unloadedTiles + ", loaded more than once same tiles " + ctx.loadedPrevUnloadedTiles);
        BinaryRoutePlanner.printInfo("Visited roads " + ctx.visitedSegments + ", relaxed roads " + ctx.relaxedSegments);
        if (graphDirectSegments != null && graphReverseSegments != null) {
            BinaryRoutePlanner.printInfo("Priority queues sizes : " + graphDirectSegments.size() + "/" + graphReverseSegments.size());
        }
        if (visitedDirectSegments != null && visitedOppositeSegments != null) {
            BinaryRoutePlanner.printInfo("Visited interval sizes: " + visitedDirectSegments.size() + "/" + visitedOppositeSegments.size());
        }
    }

    private void processRouteSegment(RoutingContext ctx, boolean reverseWaySearch, PriorityQueue<RouteSegment> graphSegments, TLongObjectHashMap<RouteSegment> visitedSegments, RouteSegment segment, TLongObjectHashMap<RouteSegment> oppositeSegments, boolean doNotAddIntersections) throws IOException {
        RouteDataObject road = segment.road;
        boolean initDirectionAllowed = this.checkIfInitialMovementAllowedOnSegment(ctx, reverseWaySearch, visitedSegments, segment, road);
        boolean directionAllowed = initDirectionAllowed;
        if (!directionAllowed) {
            return;
        }
        float obstaclesTime = 0.0f;
        float segmentDist = 0.0f;
        int segmentPoint = segment.getSegmentStart();
        boolean[] processFurther = new boolean[1];
        RouteSegment previous = segment;
        boolean dir = segment.isPositive();
        while (directionAllowed) {
            int prevInd = segmentPoint;
            segmentPoint = dir ? (int)(segmentPoint + 1) : (int)(segmentPoint - 1);
            if (segmentPoint < 0 || segmentPoint >= road.getPointsLength()) {
                directionAllowed = false;
                continue;
            }
            visitedSegments.put(this.calculateRoutePointId(segment.getRoad(), segment.isPositive() ? segmentPoint - 1 : segmentPoint, segment.isPositive()), (Object)(previous != null ? previous : segment));
            int x = road.getPoint31XTile(segmentPoint);
            int y = road.getPoint31YTile(segmentPoint);
            int prevx = road.getPoint31XTile(prevInd);
            int prevy = road.getPoint31YTile(prevInd);
            if (x == prevx && y == prevy) continue;
            segmentDist = (float)((double)segmentDist + BinaryRoutePlanner.squareRootDist(x, y, prevx, prevy));
            double obstacle = ctx.getRouter().defineRoutingObstacle(road, segmentPoint);
            if (obstacle < 0.0) {
                directionAllowed = false;
                continue;
            }
            boolean alreadyVisited = this.checkIfOppositieSegmentWasVisited(ctx, reverseWaySearch, graphSegments, segment, oppositeSegments, segmentPoint, segmentDist, obstaclesTime = (float)((double)obstaclesTime + obstacle));
            if (alreadyVisited) {
                directionAllowed = false;
                continue;
            }
            if (ctx.precalculatedRouteDirection != null) {
                // empty if block
            }
            RouteSegment roadNext = ctx.loadRouteSegment(x, y, ctx.config.memoryLimitation - ctx.memoryOverhead);
            float distStartObstacles = segment.distanceFromStart + this.calculateTimeWithObstacles(ctx, road, segmentDist, obstaclesTime);
            if (ctx.precalculatedRouteDirection != null && ctx.precalculatedRouteDirection.isFollowNext()) {
                distStartObstacles = ctx.precalculatedRouteDirection.getDeviationDistance(x, y) / ctx.getRouter().getMaxDefaultSpeed();
            }
            previous = this.processIntersections(ctx, graphSegments, visitedSegments, distStartObstacles, segment, (short)segmentPoint, roadNext, reverseWaySearch, doNotAddIntersections, processFurther);
            if (processFurther[0]) continue;
            directionAllowed = false;
        }
        if (initDirectionAllowed && ctx.visitor != null) {
            ctx.visitor.visitSegment(segment, segmentPoint, true);
        }
    }

    private boolean checkIfInitialMovementAllowedOnSegment(RoutingContext ctx, boolean reverseWaySearch, TLongObjectHashMap<RouteSegment> visitedSegments, RouteSegment segment, RouteDataObject road) {
        boolean directionAllowed;
        int oneway = ctx.getRouter().isOneWay(road);
        if (!reverseWaySearch) {
            directionAllowed = segment.isPositive() ? oneway >= 0 : oneway <= 0;
        } else if (segment.isPositive()) {
            directionAllowed = oneway <= 0;
        } else {
            boolean bl = directionAllowed = oneway >= 0;
        }
        if (directionAllowed && visitedSegments.containsKey(this.calculateRoutePointId(segment, segment.isPositive()))) {
            directionAllowed = false;
        }
        return directionAllowed;
    }

    private boolean checkViaRestrictions(RouteSegment from, RouteSegment to) {
        if (from != null && to != null) {
            long fid = to.getRoad().getId();
            for (int i = 0; i < from.getRoad().getRestrictionLength(); ++i) {
                long id2 = from.getRoad().getRestrictionId(i);
                if (fid != id2) continue;
                int tp = from.getRoad().getRestrictionType(i);
                if (tp != 2 && tp != 1 && tp != 4 && tp != 3) break;
                return false;
            }
        }
        return true;
    }

    private RouteSegment getParentDiffId(RouteSegment s) {
        while (s.getParentRoute() != null && s.getParentRoute().getRoad().getId() == s.getRoad().getId()) {
            s = s.getParentRoute();
        }
        return s.getParentRoute();
    }

    private boolean checkIfOppositieSegmentWasVisited(RoutingContext ctx, boolean reverseWaySearch, PriorityQueue<RouteSegment> graphSegments, RouteSegment segment, TLongObjectHashMap<RouteSegment> oppositeSegments, int segmentPoint, float segmentDist, float obstaclesTime) {
        RouteDataObject road = segment.getRoad();
        long opp = this.calculateRoutePointId(road, segment.isPositive() ? segmentPoint - 1 : segmentPoint, !segment.isPositive());
        if (oppositeSegments.containsKey(opp)) {
            RouteSegment from;
            RouteSegment opposite = (RouteSegment)oppositeSegments.get(opp);
            RouteSegment to = reverseWaySearch ? this.getParentDiffId(segment) : this.getParentDiffId(opposite);
            RouteSegment routeSegment = from = !reverseWaySearch ? this.getParentDiffId(segment) : this.getParentDiffId(opposite);
            if (this.checkViaRestrictions(from, to)) {
                FinalRouteSegment frs = new FinalRouteSegment(road, segmentPoint);
                float distStartObstacles = segment.distanceFromStart + this.calculateTimeWithObstacles(ctx, road, segmentDist, obstaclesTime);
                frs.setParentRoute(segment);
                frs.setParentSegmentEnd(segmentPoint);
                frs.reverseWaySearch = reverseWaySearch;
                frs.distanceFromStart = opposite.distanceFromStart + distStartObstacles;
                frs.distanceToEnd = 0.0f;
                frs.opposite = opposite;
                graphSegments.add(frs);
                return true;
            }
        }
        return false;
    }

    private float calculateTimeWithObstacles(RoutingContext ctx, RouteDataObject road, float distOnRoadToPass, float obstaclesTime) {
        float priority = ctx.getRouter().defineSpeedPriority(road);
        float speed = ctx.getRouter().defineRoutingSpeed(road) * priority;
        if (speed == 0.0f) {
            speed = ctx.getRouter().getMinDefaultSpeed() * priority;
        }
        if (speed > ctx.getRouter().getMaxDefaultSpeed()) {
            speed = ctx.getRouter().getMaxDefaultSpeed();
        }
        return obstaclesTime + distOnRoadToPass / speed;
    }

    private long calculateRoutePointId(RouteDataObject road, int intervalId, boolean positive) {
        if (intervalId < 0) {
            throw new IllegalStateException("Assert failed");
        }
        return (road.getId() << 11) + (long)(intervalId << 1) + (long)(positive ? 1 : 0);
    }

    private long calculateRoutePointId(RouteSegment segm, boolean direction) {
        if (segm.getSegmentStart() == 0 && !direction) {
            throw new IllegalStateException("Assert failed");
        }
        if (segm.getSegmentStart() == segm.getRoad().getPointsLength() - 1 && direction) {
            throw new IllegalStateException("Assert failed");
        }
        return this.calculateRoutePointId(segm.getRoad(), direction ? segm.getSegmentStart() : segm.getSegmentStart() - 1, direction);
    }

    private boolean proccessRestrictions(RoutingContext ctx, RouteSegment segment, RouteSegment inputNext, boolean reverseWay) {
        if (!ctx.getRouter().restrictionsAware()) {
            return false;
        }
        RouteDataObject road = segment.getRoad();
        RouteSegment parent = this.getParentDiffId(segment);
        if (!(reverseWay || road.getRestrictionLength() != 0 || parent != null && parent.getRoad().getRestrictionLength() != 0)) {
            return false;
        }
        ctx.segmentsToVisitPrescripted.clear();
        ctx.segmentsToVisitNotForbidden.clear();
        this.processRestriction(ctx, inputNext, reverseWay, false, road);
        if (parent != null) {
            this.processRestriction(ctx, inputNext, reverseWay, true, parent.getRoad());
        }
        return true;
    }

    protected void processRestriction(RoutingContext ctx, RouteSegment inputNext, boolean reverseWay, boolean via, RouteDataObject road) {
        RouteSegment next = inputNext;
        boolean exclusiveRestriction = false;
        while (next != null) {
            int i;
            int type = -1;
            if (!reverseWay) {
                for (i = 0; i < road.getRestrictionLength(); ++i) {
                    if (road.getRestrictionId(i) != next.road.id) continue;
                    type = road.getRestrictionType(i);
                    break;
                }
            } else {
                for (i = 0; i < next.road.getRestrictionLength(); ++i) {
                    int rt = next.road.getRestrictionType(i);
                    long restrictedTo = next.road.getRestrictionId(i);
                    if (restrictedTo == road.id) {
                        type = rt;
                        break;
                    }
                    if (rt != 5 && rt != 6 && rt != 7) continue;
                    RouteSegment foundNext = inputNext;
                    while (foundNext != null && foundNext.getRoad().id != restrictedTo) {
                        foundNext = foundNext.next;
                    }
                    if (foundNext == null) continue;
                    type = 1024;
                }
            }
            if (!(type == 1024 || type == -1 && exclusiveRestriction)) {
                if (type == 2 || type == 1 || type == 4 || type == 3) {
                    if (via) {
                        ctx.segmentsToVisitPrescripted.remove(next);
                    }
                } else if (type == -1) {
                    ctx.segmentsToVisitNotForbidden.add(next);
                } else if (!via) {
                    if (!reverseWay) {
                        exclusiveRestriction = true;
                        ctx.segmentsToVisitNotForbidden.clear();
                        ctx.segmentsToVisitPrescripted.add(next);
                    } else {
                        ctx.segmentsToVisitNotForbidden.add(next);
                    }
                }
            }
            next = next.next;
        }
        if (!via) {
            ctx.segmentsToVisitPrescripted.addAll(ctx.segmentsToVisitNotForbidden);
        }
    }

    private RouteSegment processIntersections(RoutingContext ctx, PriorityQueue<RouteSegment> graphSegments, TLongObjectHashMap<RouteSegment> visitedSegments, float distFromStart, RouteSegment segment, short segmentPoint, RouteSegment inputNext, boolean reverseWaySearch, boolean doNotAddIntersections, boolean[] processFurther) {
        boolean hasNext;
        boolean thereAreRestrictions;
        RouteSegment itself = null;
        processFurther[0] = true;
        Iterator<RouteSegment> nextIterator = null;
        if (inputNext != null && inputNext.getRoad().getId() == segment.getRoad().getId() && inputNext.next == null) {
            thereAreRestrictions = false;
        } else {
            thereAreRestrictions = this.proccessRestrictions(ctx, segment, inputNext, reverseWaySearch);
            if (thereAreRestrictions) {
                nextIterator = ctx.segmentsToVisitPrescripted.iterator();
            }
        }
        int targetEndX = reverseWaySearch ? ctx.startX : ctx.targetX;
        int targetEndY = reverseWaySearch ? ctx.startY : ctx.targetY;
        float distanceToEnd = BinaryRoutePlanner.h(ctx, segment.getRoad().getPoint31XTile(segmentPoint), segment.getRoad().getPoint31YTile(segmentPoint), targetEndX, targetEndY);
        RouteSegment next = inputNext;
        boolean bl = hasNext = nextIterator == null || nextIterator.hasNext();
        while (hasNext) {
            if (nextIterator != null) {
                next = nextIterator.next();
            }
            if (next.getSegmentStart() == segmentPoint && next.getRoad().getId() == segment.getRoad().id) {
                itself = next.initRouteSegment(segment.isPositive());
                if (itself != null) {
                    if (itself.getParentRoute() == null || ctx.roadPriorityComparator(itself.distanceFromStart, itself.distanceToEnd, distFromStart, distanceToEnd) > 0) {
                        itself.distanceFromStart = distFromStart;
                        itself.distanceToEnd = distanceToEnd;
                        itself.setParentRoute(segment);
                        itself.setParentSegmentEnd(segmentPoint);
                    } else {
                        processFurther[0] = false;
                    }
                }
            } else if (!doNotAddIntersections) {
                RouteSegment nextPos = next.initRouteSegment(true);
                RouteSegment nextNeg = next.initRouteSegment(false);
                this.processOneRoadIntersection(ctx, graphSegments, visitedSegments, distFromStart, distanceToEnd, segment, segmentPoint, nextPos);
                this.processOneRoadIntersection(ctx, graphSegments, visitedSegments, distFromStart, distanceToEnd, segment, segmentPoint, nextNeg);
            }
            if (nextIterator == null) {
                next = next.next;
                hasNext = next != null;
                continue;
            }
            hasNext = nextIterator.hasNext();
        }
        return itself;
    }

    private void processOneRoadIntersection(RoutingContext ctx, PriorityQueue<RouteSegment> graphSegments, TLongObjectHashMap<RouteSegment> visitedSegments, float distFromStart, float distanceToEnd, RouteSegment segment, int segmentPoint, RouteSegment next) {
        if (next != null) {
            float obstaclesTime = (float)ctx.getRouter().calculateTurnTime(next, next.isPositive() ? next.getRoad().getPointsLength() - 1 : 0, segment, segmentPoint);
            distFromStart += obstaclesTime;
            if (!visitedSegments.containsKey(this.calculateRoutePointId(next, next.isPositive()))) {
                if (next.getParentRoute() == null || ctx.roadPriorityComparator(next.distanceFromStart, next.distanceToEnd, distFromStart, distanceToEnd) > 0) {
                    next.distanceFromStart = distFromStart;
                    next.distanceToEnd = distanceToEnd;
                    next.setParentRoute(segment);
                    next.setParentSegmentEnd(segmentPoint);
                    graphSegments.add(next);
                }
            } else if (distFromStart < next.distanceFromStart) {
                if (ctx.config.heuristicCoefficient <= 1.0f) {
                    System.err.println("! Alert distance from start " + distFromStart + " < " + next.distanceFromStart + " id=" + next.road.id);
                }
                if (ctx.visitor != null) {
                    // empty if block
                }
            }
        }
    }

    static int roadPriorityComparator(double o1DistanceFromStart, double o1DistanceToEnd, double o2DistanceFromStart, double o2DistanceToEnd, double heuristicCoefficient) {
        return Double.compare(o1DistanceFromStart + heuristicCoefficient * o1DistanceToEnd, o2DistanceFromStart + heuristicCoefficient * o2DistanceToEnd);
    }

    static class FinalRouteSegment
    extends RouteSegment {
        boolean reverseWaySearch;
        RouteSegment opposite;

        public FinalRouteSegment(RouteDataObject road, int segmentStart) {
            super(road, segmentStart);
        }
    }

    public static class RouteSegment {
        final short segStart;
        final RouteDataObject road;
        RouteSegment next = null;
        RouteSegment oppositeDirection = null;
        RouteSegment parentRoute = null;
        short parentSegmentEnd = 0;
        byte directionAssgn = 0;
        float distanceFromStart = 0.0f;
        float distanceToEnd = 0.0f;

        public RouteSegment(RouteDataObject road, int segmentStart) {
            this.road = road;
            this.segStart = (short)segmentStart;
        }

        public RouteSegment initRouteSegment(boolean positiveDirection) {
            if (this.segStart == 0 && !positiveDirection) {
                return null;
            }
            if (this.segStart == this.road.getPointsLength() - 1 && positiveDirection) {
                return null;
            }
            RouteSegment rs = this;
            if (this.directionAssgn == 0) {
                rs.directionAssgn = (byte)(positiveDirection ? 1 : -1);
            } else if (positiveDirection != (this.directionAssgn == 1)) {
                if (this.oppositeDirection == null) {
                    this.oppositeDirection = new RouteSegment(this.road, this.segStart);
                    this.oppositeDirection.directionAssgn = (byte)(positiveDirection ? 1 : -1);
                }
                if (this.oppositeDirection.directionAssgn == 1 != positiveDirection) {
                    throw new IllegalStateException();
                }
                rs = this.oppositeDirection;
            }
            return rs;
        }

        public byte getDirectionAssigned() {
            return this.directionAssgn;
        }

        public RouteSegment getParentRoute() {
            return this.parentRoute;
        }

        public boolean isPositive() {
            return this.directionAssgn == 1;
        }

        public void setParentRoute(RouteSegment parentRoute) {
            this.parentRoute = parentRoute;
        }

        public void assignDirection(byte b) {
            this.directionAssgn = b;
        }

        public void setParentSegmentEnd(int parentSegmentEnd) {
            this.parentSegmentEnd = (short)parentSegmentEnd;
        }

        public int getParentSegmentEnd() {
            return this.parentSegmentEnd;
        }

        public RouteSegment getNext() {
            return this.next;
        }

        public short getSegmentStart() {
            return this.segStart;
        }

        public float getDistanceFromStart() {
            return this.distanceFromStart;
        }

        public void setDistanceFromStart(float distanceFromStart) {
            this.distanceFromStart = distanceFromStart;
        }

        public RouteDataObject getRoad() {
            return this.road;
        }

        public String getTestName() {
            return MessageFormat.format("s{0,number,#.##} e{1,number,#.##}", Float.valueOf(this.distanceFromStart), Float.valueOf(this.distanceToEnd));
        }

        public Iterator<RouteSegment> getIterator() {
            return new Iterator<RouteSegment>(){
                RouteSegment next;
                {
                    this.next = this;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public RouteSegment next() {
                    RouteSegment c = this.next;
                    if (this.next != null) {
                        this.next = this.next.next;
                    }
                    return c;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }
            };
        }
    }

    public static class RouteSegmentPoint
    extends RouteSegment {
        public double distSquare;
        public int preciseX;
        public int preciseY;
        public List<RouteSegmentPoint> others;

        public RouteSegmentPoint(RouteDataObject road, int segmentStart, double distSquare) {
            super(road, segmentStart);
            this.distSquare = distSquare;
        }
    }

    public static interface RouteSegmentVisitor {
        public void visitSegment(RouteSegment var1, int var2, boolean var3);
    }

    private static class NonHeuristicSegmentsComparator
    implements Comparator<RouteSegment> {
        @Override
        public int compare(RouteSegment o1, RouteSegment o2) {
            return BinaryRoutePlanner.roadPriorityComparator(o1.distanceFromStart, o1.distanceToEnd, o2.distanceFromStart, o2.distanceToEnd, 0.5);
        }
    }

    private static class SegmentsComparator
    implements Comparator<RouteSegment> {
        final RoutingContext ctx;

        public SegmentsComparator(RoutingContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public int compare(RouteSegment o1, RouteSegment o2) {
            return this.ctx.roadPriorityComparator(o1.distanceFromStart, o1.distanceToEnd, o2.distanceFromStart, o2.distanceToEnd);
        }
    }
}

