/* Panel.c generated by valac 0.56.3, the Vala compiler
 * generated from Panel.vala, do not modify */

/*
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include "wingpanel.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define WINGPANEL_WIDGETS_STYLE_CLASS_PANEL "panel"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WINGPANEL_WIDGETS_TYPE_PANEL (wingpanel_widgets_panel_get_type ())
#define WINGPANEL_WIDGETS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanel))
#define WINGPANEL_WIDGETS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanelClass))
#define WINGPANEL_WIDGETS_IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_WIDGETS_TYPE_PANEL))
#define WINGPANEL_WIDGETS_IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_WIDGETS_TYPE_PANEL))
#define WINGPANEL_WIDGETS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanelClass))

typedef struct _WingpanelWidgetsPanel WingpanelWidgetsPanel;
typedef struct _WingpanelWidgetsPanelClass WingpanelWidgetsPanelClass;
typedef struct _WingpanelWidgetsPanelPrivate WingpanelWidgetsPanelPrivate;

#define WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER (wingpanel_services_popover_manager_get_type ())
#define WINGPANEL_SERVICES_POPOVER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER, WingpanelServicesPopoverManager))
#define WINGPANEL_SERVICES_POPOVER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER, WingpanelServicesPopoverManagerClass))
#define WINGPANEL_SERVICES_IS_POPOVER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER))
#define WINGPANEL_SERVICES_IS_POPOVER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER))
#define WINGPANEL_SERVICES_POPOVER_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER, WingpanelServicesPopoverManagerClass))

typedef struct _WingpanelServicesPopoverManager WingpanelServicesPopoverManager;
typedef struct _WingpanelServicesPopoverManagerClass WingpanelServicesPopoverManagerClass;

#define WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR (wingpanel_widgets_indicator_menu_bar_get_type ())
#define WINGPANEL_WIDGETS_INDICATOR_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR, WingpanelWidgetsIndicatorMenuBar))
#define WINGPANEL_WIDGETS_INDICATOR_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR, WingpanelWidgetsIndicatorMenuBarClass))
#define WINGPANEL_WIDGETS_IS_INDICATOR_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR))
#define WINGPANEL_WIDGETS_IS_INDICATOR_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR))
#define WINGPANEL_WIDGETS_INDICATOR_MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_MENU_BAR, WingpanelWidgetsIndicatorMenuBarClass))

typedef struct _WingpanelWidgetsIndicatorMenuBar WingpanelWidgetsIndicatorMenuBar;
typedef struct _WingpanelWidgetsIndicatorMenuBarClass WingpanelWidgetsIndicatorMenuBarClass;
enum  {
	WINGPANEL_WIDGETS_PANEL_0_PROPERTY,
	WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY,
	WINGPANEL_WIDGETS_PANEL_NUM_PROPERTIES
};
static GParamSpec* wingpanel_widgets_panel_properties[WINGPANEL_WIDGETS_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER (wingpanel_services_background_manager_get_type ())
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManager))
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManagerClass))
#define WINGPANEL_SERVICES_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER))
#define WINGPANEL_SERVICES_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER))
#define WINGPANEL_SERVICES_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_SERVICES_TYPE_BACKGROUND_MANAGER, WingpanelServicesBackgroundManagerClass))

typedef struct _WingpanelServicesBackgroundManager WingpanelServicesBackgroundManager;
typedef struct _WingpanelServicesBackgroundManagerClass WingpanelServicesBackgroundManagerClass;

#define WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY (wingpanel_widgets_indicator_entry_get_type ())
#define WINGPANEL_WIDGETS_INDICATOR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY, WingpanelWidgetsIndicatorEntry))
#define WINGPANEL_WIDGETS_INDICATOR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY, WingpanelWidgetsIndicatorEntryClass))
#define WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY))
#define WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY))
#define WINGPANEL_WIDGETS_INDICATOR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_WIDGETS_TYPE_INDICATOR_ENTRY, WingpanelWidgetsIndicatorEntryClass))

typedef struct _WingpanelWidgetsIndicatorEntry WingpanelWidgetsIndicatorEntry;
typedef struct _WingpanelWidgetsIndicatorEntryClass WingpanelWidgetsIndicatorEntryClass;
typedef enum  {
	WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT,
	WINGPANEL_SERVICES_BACKGROUND_STATE_DARK,
	WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED,
	WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_DARK,
	WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_LIGHT
} WingpanelServicesBackgroundState;

#define WINGPANEL_SERVICES_TYPE_BACKGROUND_STATE (wingpanel_services_background_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WingpanelWidgetsPanel {
	GtkEventBox parent_instance;
	WingpanelWidgetsPanelPrivate * priv;
};

struct _WingpanelWidgetsPanelClass {
	GtkEventBoxClass parent_class;
};

struct _WingpanelWidgetsPanelPrivate {
	WingpanelServicesPopoverManager* _popover_manager;
	WingpanelWidgetsIndicatorMenuBar* right_menubar;
	GtkMenuBar* left_menubar;
	GtkMenuBar* center_menubar;
	GtkStyleContext* style_context;
	GtkCssProvider* style_provider;
};

static gint WingpanelWidgetsPanel_private_offset;
static gpointer wingpanel_widgets_panel_parent_class = NULL;
static GtkCssProvider* wingpanel_widgets_panel_resource_provider;
static GtkCssProvider* wingpanel_widgets_panel_resource_provider = NULL;

VALA_EXTERN GType wingpanel_widgets_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelWidgetsPanel, g_object_unref)
VALA_EXTERN GType wingpanel_services_popover_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelServicesPopoverManager, g_object_unref)
VALA_EXTERN GType wingpanel_widgets_indicator_menu_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelWidgetsIndicatorMenuBar, g_object_unref)
VALA_EXTERN WingpanelWidgetsPanel* wingpanel_widgets_panel_new (WingpanelServicesPopoverManager* popover_manager);
VALA_EXTERN WingpanelWidgetsPanel* wingpanel_widgets_panel_construct (GType object_type,
                                                          WingpanelServicesPopoverManager* popover_manager);
static gboolean wingpanel_widgets_panel_real_button_press_event (GtkWidget* base,
                                                          GdkEventButton* event);
VALA_EXTERN WingpanelServicesPopoverManager* wingpanel_widgets_panel_get_popover_manager (WingpanelWidgetsPanel* self);
VALA_EXTERN void wingpanel_services_popover_manager_close (WingpanelServicesPopoverManager* self);
VALA_EXTERN GType wingpanel_services_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelServicesBackgroundManager, g_object_unref)
VALA_EXTERN WingpanelServicesBackgroundManager* wingpanel_services_background_manager_get_default (void);
VALA_EXTERN gboolean wingpanel_services_background_manager_begin_grab_focused_window (WingpanelServicesBackgroundManager* self,
                                                                          gint x,
                                                                          gint y,
                                                                          gint button,
                                                                          guint time,
                                                                          guint state);
VALA_EXTERN void wingpanel_widgets_panel_cycle (WingpanelWidgetsPanel* self,
                                    gboolean forward);
VALA_EXTERN GType wingpanel_widgets_indicator_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelWidgetsIndicatorEntry, g_object_unref)
VALA_EXTERN WingpanelWidgetsIndicatorEntry* wingpanel_services_popover_manager_get_current_indicator (WingpanelServicesPopoverManager* self);
static WingpanelWidgetsIndicatorEntry* wingpanel_widgets_panel_get_next_sibling (WingpanelWidgetsPanel* self,
                                                                          WingpanelWidgetsIndicatorEntry* current);
static WingpanelWidgetsIndicatorEntry* wingpanel_widgets_panel_get_previous_sibling (WingpanelWidgetsPanel* self,
                                                                              WingpanelWidgetsIndicatorEntry* current);
VALA_EXTERN void wingpanel_services_popover_manager_set_current_indicator (WingpanelServicesPopoverManager* self,
                                                               WingpanelWidgetsIndicatorEntry* value);
VALA_EXTERN WingpanelIndicator* wingpanel_widgets_indicator_entry_get_base_indicator (WingpanelWidgetsIndicatorEntry* self);
static void wingpanel_widgets_panel_add_indicator (WingpanelWidgetsPanel* self,
                                            WingpanelIndicator* indicator);
VALA_EXTERN WingpanelWidgetsIndicatorEntry* wingpanel_widgets_indicator_entry_new (WingpanelIndicator* base_indicator,
                                                                       WingpanelServicesPopoverManager* popover_manager);
VALA_EXTERN WingpanelWidgetsIndicatorEntry* wingpanel_widgets_indicator_entry_construct (GType object_type,
                                                                             WingpanelIndicator* base_indicator,
                                                                             WingpanelServicesPopoverManager* popover_manager);
VALA_EXTERN void wingpanel_widgets_indicator_entry_set_transition_type (WingpanelWidgetsIndicatorEntry* self,
                                                            GtkRevealerTransitionType transition_type);
VALA_EXTERN void wingpanel_widgets_indicator_menu_bar_insert_sorted (WingpanelWidgetsIndicatorMenuBar* self,
                                                         WingpanelWidgetsIndicatorEntry* item);
static void wingpanel_widgets_panel_remove_indicator (WingpanelWidgetsPanel* self,
                                               WingpanelIndicator* indicator);
static void wingpanel_widgets_panel_remove_indicator_from_container (WingpanelWidgetsPanel* self,
                                                              GtkContainer* container,
                                                              WingpanelIndicator* indicator);
VALA_EXTERN GType wingpanel_services_background_state_get_type (void) G_GNUC_CONST ;
static void wingpanel_widgets_panel_update_background (WingpanelWidgetsPanel* self,
                                                WingpanelServicesBackgroundState state,
                                                guint animation_duration);
static void wingpanel_widgets_panel_set_popover_manager (WingpanelWidgetsPanel* self,
                                                  WingpanelServicesPopoverManager* value);
static GObject * wingpanel_widgets_panel_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN WingpanelWidgetsIndicatorMenuBar* wingpanel_widgets_indicator_menu_bar_new (void);
VALA_EXTERN WingpanelWidgetsIndicatorMenuBar* wingpanel_widgets_indicator_menu_bar_construct (GType object_type);
static void _wingpanel_widgets_panel_add_indicator_wingpanel_indicator_manager_indicator_added (WingpanelIndicatorManager* _sender,
                                                                                         WingpanelIndicator* indicator,
                                                                                         gpointer self);
static void _wingpanel_widgets_panel_remove_indicator_wingpanel_indicator_manager_indicator_removed (WingpanelIndicatorManager* _sender,
                                                                                              WingpanelIndicator* indicator,
                                                                                              gpointer self);
static gboolean _wingpanel_widgets_panel___lambda21_ (WingpanelWidgetsPanel* self,
                                               WingpanelIndicator* indicator);
static gboolean __wingpanel_widgets_panel___lambda21__gee_forall_func (gpointer g,
                                                                gpointer self);
static void _wingpanel_widgets_panel_update_background_wingpanel_services_background_manager_background_state_changed (WingpanelServicesBackgroundManager* _sender,
                                                                                                                WingpanelServicesBackgroundState state,
                                                                                                                guint animation_duration,
                                                                                                                gpointer self);
static void wingpanel_widgets_panel_finalize (GObject * obj);
static GType wingpanel_widgets_panel_get_type_once (void);
static void _vala_wingpanel_widgets_panel_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_wingpanel_widgets_panel_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
wingpanel_widgets_panel_get_instance_private (WingpanelWidgetsPanel* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelWidgetsPanel_private_offset);
}

WingpanelWidgetsPanel*
wingpanel_widgets_panel_construct (GType object_type,
                                   WingpanelServicesPopoverManager* popover_manager)
{
	WingpanelWidgetsPanel * self = NULL;
	g_return_val_if_fail (popover_manager != NULL, NULL);
	self = (WingpanelWidgetsPanel*) g_object_new (object_type, "popover-manager", popover_manager, NULL);
	return self;
}

WingpanelWidgetsPanel*
wingpanel_widgets_panel_new (WingpanelServicesPopoverManager* popover_manager)
{
	return wingpanel_widgets_panel_construct (WINGPANEL_WIDGETS_TYPE_PANEL, popover_manager);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
wingpanel_widgets_panel_real_button_press_event (GtkWidget* base,
                                                 GdkEventButton* event)
{
	WingpanelWidgetsPanel * self;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkDevice* _tmp3_;
	guint32 time = 0U;
	GdkWindow* _tmp4_;
	GdkDisplay* _tmp5_;
	GdkSeat* _tmp6_;
	GdkModifierType state = 0U;
	GdkModifierType _tmp7_ = 0U;
	WingpanelServicesPopoverManager* _tmp8_;
	gint scale_factor = 0;
	gint x = 0;
	gint y = 0;
	WingpanelServicesBackgroundManager* background_manager = NULL;
	WingpanelServicesBackgroundManager* _tmp9_;
	WingpanelServicesBackgroundManager* _tmp10_;
	gboolean result;
	self = (WingpanelWidgetsPanel*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) GDK_BUTTON_PRIMARY)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (window);
		return result;
	}
	_tmp3_ = event->device;
	if (gdk_device_get_source (_tmp3_) == GDK_SOURCE_TOUCHSCREEN) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (window);
		return result;
	}
	time = event->time;
	_tmp4_ = window;
	_tmp5_ = gdk_window_get_display (_tmp4_);
	_tmp6_ = gdk_display_get_default_seat (_tmp5_);
	gdk_seat_ungrab (_tmp6_);
	gdk_event_get_state ((GdkEvent*) event, &_tmp7_);
	state = _tmp7_;
	_tmp8_ = self->priv->_popover_manager;
	wingpanel_services_popover_manager_close (_tmp8_);
	scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) self);
	x = ((gint) event->x_root) * scale_factor;
	y = ((gint) event->y_root) * scale_factor;
	_tmp9_ = wingpanel_services_background_manager_get_default ();
	background_manager = _tmp9_;
	_tmp10_ = background_manager;
	result = wingpanel_services_background_manager_begin_grab_focused_window (_tmp10_, x, y, (gint) event->button, (guint) time, (guint) state);
	_g_object_unref0 (background_manager);
	_g_object_unref0 (window);
	return result;
}

void
wingpanel_widgets_panel_cycle (WingpanelWidgetsPanel* self,
                               gboolean forward)
{
	WingpanelWidgetsIndicatorEntry* current = NULL;
	WingpanelServicesPopoverManager* _tmp0_;
	WingpanelWidgetsIndicatorEntry* _tmp1_;
	WingpanelWidgetsIndicatorEntry* _tmp2_;
	WingpanelWidgetsIndicatorEntry* _tmp3_;
	WingpanelWidgetsIndicatorEntry* _tmp4_;
	WingpanelWidgetsIndicatorEntry* sibling = NULL;
	WingpanelWidgetsIndicatorEntry* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_popover_manager;
	_tmp1_ = wingpanel_services_popover_manager_get_current_indicator (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (current);
		return;
	}
	if (forward) {
		WingpanelWidgetsIndicatorEntry* _tmp5_;
		WingpanelWidgetsIndicatorEntry* _tmp6_;
		_tmp5_ = current;
		_tmp6_ = wingpanel_widgets_panel_get_next_sibling (self, _tmp5_);
		_g_object_unref0 (sibling);
		sibling = _tmp6_;
	} else {
		WingpanelWidgetsIndicatorEntry* _tmp7_;
		WingpanelWidgetsIndicatorEntry* _tmp8_;
		_tmp7_ = current;
		_tmp8_ = wingpanel_widgets_panel_get_previous_sibling (self, _tmp7_);
		_g_object_unref0 (sibling);
		sibling = _tmp8_;
	}
	_tmp9_ = sibling;
	if (_tmp9_ != NULL) {
		WingpanelServicesPopoverManager* _tmp10_;
		WingpanelWidgetsIndicatorEntry* _tmp11_;
		_tmp10_ = self->priv->_popover_manager;
		_tmp11_ = sibling;
		wingpanel_services_popover_manager_set_current_indicator (_tmp10_, _tmp11_);
	}
	_g_object_unref0 (sibling);
	_g_object_unref0 (current);
}

static WingpanelWidgetsIndicatorEntry*
wingpanel_widgets_panel_get_next_sibling (WingpanelWidgetsPanel* self,
                                          WingpanelWidgetsIndicatorEntry* current)
{
	WingpanelWidgetsIndicatorEntry* sibling = NULL;
	WingpanelIndicator* _tmp0_;
	WingpanelIndicator* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	WingpanelWidgetsIndicatorEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (current != NULL, NULL);
	sibling = NULL;
	_tmp0_ = wingpanel_widgets_indicator_entry_get_base_indicator (current);
	_tmp1_ = _tmp0_;
	_tmp2_ = wingpanel_indicator_get_code_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string (WINGPANEL_INDICATOR_APP_LAUNCHER)))) {
		switch (0) {
			default:
			{
				GList* children = NULL;
				GtkMenuBar* _tmp7_;
				GList* _tmp8_;
				gint index = 0;
				GList* _tmp9_;
				_tmp7_ = self->priv->left_menubar;
				_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
				children = _tmp8_;
				_tmp9_ = children;
				index = g_list_index (_tmp9_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					GList* _tmp10_;
					_tmp10_ = children;
					if (((guint) index) < (g_list_length (_tmp10_) - 1)) {
						GList* _tmp11_;
						gconstpointer _tmp12_;
						GtkWidget* _tmp13_;
						WingpanelWidgetsIndicatorEntry* _tmp14_;
						_tmp11_ = children;
						_tmp12_ = g_list_nth_data (_tmp11_, (guint) (index + 1));
						_tmp13_ = (GtkWidget*) _tmp12_;
						_tmp14_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp13_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp13_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp14_;
					} else {
						GList* center_children = NULL;
						GtkMenuBar* _tmp15_;
						GList* _tmp16_;
						GList* _tmp17_;
						_tmp15_ = self->priv->center_menubar;
						_tmp16_ = gtk_container_get_children ((GtkContainer*) _tmp15_);
						center_children = _tmp16_;
						_tmp17_ = center_children;
						if (g_list_length (_tmp17_) > ((guint) 0)) {
							GList* _tmp18_;
							GList* _tmp19_;
							gconstpointer _tmp20_;
							GtkWidget* _tmp21_;
							WingpanelWidgetsIndicatorEntry* _tmp22_;
							_tmp18_ = center_children;
							_tmp19_ = g_list_first (_tmp18_);
							_tmp20_ = _tmp19_->data;
							_tmp21_ = (GtkWidget*) _tmp20_;
							_tmp22_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp21_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp21_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp22_;
						}
						(center_children == NULL) ? NULL : (center_children = (g_list_free (center_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string (WINGPANEL_INDICATOR_DATETIME)))) {
		switch (0) {
			default:
			{
				GList* children = NULL;
				GtkMenuBar* _tmp23_;
				GList* _tmp24_;
				gint index = 0;
				GList* _tmp25_;
				_tmp23_ = self->priv->center_menubar;
				_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
				children = _tmp24_;
				_tmp25_ = children;
				index = g_list_index (_tmp25_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					GList* _tmp26_;
					_tmp26_ = children;
					if (((guint) index) < (g_list_length (_tmp26_) - 1)) {
						GList* _tmp27_;
						gconstpointer _tmp28_;
						GtkWidget* _tmp29_;
						WingpanelWidgetsIndicatorEntry* _tmp30_;
						_tmp27_ = children;
						_tmp28_ = g_list_nth_data (_tmp27_, (guint) (index + 1));
						_tmp29_ = (GtkWidget*) _tmp28_;
						_tmp30_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp29_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp29_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp30_;
					} else {
						GList* right_children = NULL;
						WingpanelWidgetsIndicatorMenuBar* _tmp31_;
						GList* _tmp32_;
						GList* _tmp33_;
						_tmp31_ = self->priv->right_menubar;
						_tmp32_ = gtk_container_get_children ((GtkContainer*) _tmp31_);
						right_children = _tmp32_;
						_tmp33_ = right_children;
						if (g_list_length (_tmp33_) > ((guint) 0)) {
							GList* _tmp34_;
							GList* _tmp35_;
							gconstpointer _tmp36_;
							GtkWidget* _tmp37_;
							WingpanelWidgetsIndicatorEntry* _tmp38_;
							_tmp34_ = right_children;
							_tmp35_ = g_list_first (_tmp34_);
							_tmp36_ = _tmp35_->data;
							_tmp37_ = (GtkWidget*) _tmp36_;
							_tmp38_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp37_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp37_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp38_;
						}
						(right_children == NULL) ? NULL : (right_children = (g_list_free (right_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GList* children = NULL;
				WingpanelWidgetsIndicatorMenuBar* _tmp39_;
				GList* _tmp40_;
				gint index = 0;
				GList* _tmp41_;
				_tmp39_ = self->priv->right_menubar;
				_tmp40_ = gtk_container_get_children ((GtkContainer*) _tmp39_);
				children = _tmp40_;
				_tmp41_ = children;
				index = g_list_index (_tmp41_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					GList* _tmp42_;
					_tmp42_ = children;
					if (((guint) index) < (g_list_length (_tmp42_) - 1)) {
						GList* _tmp43_;
						gconstpointer _tmp44_;
						GtkWidget* _tmp45_;
						WingpanelWidgetsIndicatorEntry* _tmp46_;
						_tmp43_ = children;
						_tmp44_ = g_list_nth_data (_tmp43_, (guint) (index + 1));
						_tmp45_ = (GtkWidget*) _tmp44_;
						_tmp46_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp45_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp45_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp46_;
					} else {
						GList* left_children = NULL;
						GtkMenuBar* _tmp47_;
						GList* _tmp48_;
						GList* _tmp49_;
						_tmp47_ = self->priv->left_menubar;
						_tmp48_ = gtk_container_get_children ((GtkContainer*) _tmp47_);
						left_children = _tmp48_;
						_tmp49_ = left_children;
						if (g_list_length (_tmp49_) > ((guint) 0)) {
							GList* _tmp50_;
							GList* _tmp51_;
							gconstpointer _tmp52_;
							GtkWidget* _tmp53_;
							WingpanelWidgetsIndicatorEntry* _tmp54_;
							_tmp50_ = left_children;
							_tmp51_ = g_list_first (_tmp50_);
							_tmp52_ = _tmp51_->data;
							_tmp53_ = (GtkWidget*) _tmp52_;
							_tmp54_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp53_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp53_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp54_;
						}
						(left_children == NULL) ? NULL : (left_children = (g_list_free (left_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	}
	result = sibling;
	return result;
}

static WingpanelWidgetsIndicatorEntry*
wingpanel_widgets_panel_get_previous_sibling (WingpanelWidgetsPanel* self,
                                              WingpanelWidgetsIndicatorEntry* current)
{
	WingpanelWidgetsIndicatorEntry* sibling = NULL;
	WingpanelIndicator* _tmp0_;
	WingpanelIndicator* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	WingpanelWidgetsIndicatorEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (current != NULL, NULL);
	sibling = NULL;
	_tmp0_ = wingpanel_widgets_indicator_entry_get_base_indicator (current);
	_tmp1_ = _tmp0_;
	_tmp2_ = wingpanel_indicator_get_code_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string (WINGPANEL_INDICATOR_APP_LAUNCHER)))) {
		switch (0) {
			default:
			{
				GList* children = NULL;
				GtkMenuBar* _tmp7_;
				GList* _tmp8_;
				gint index = 0;
				GList* _tmp9_;
				_tmp7_ = self->priv->left_menubar;
				_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
				children = _tmp8_;
				_tmp9_ = children;
				index = g_list_index (_tmp9_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					if (index != 0) {
						GList* _tmp10_;
						gconstpointer _tmp11_;
						GtkWidget* _tmp12_;
						WingpanelWidgetsIndicatorEntry* _tmp13_;
						_tmp10_ = children;
						_tmp11_ = g_list_nth_data (_tmp10_, (guint) (index - 1));
						_tmp12_ = (GtkWidget*) _tmp11_;
						_tmp13_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp12_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp12_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp13_;
					} else {
						GList* right_children = NULL;
						WingpanelWidgetsIndicatorMenuBar* _tmp14_;
						GList* _tmp15_;
						GList* _tmp16_;
						_tmp14_ = self->priv->right_menubar;
						_tmp15_ = gtk_container_get_children ((GtkContainer*) _tmp14_);
						right_children = _tmp15_;
						_tmp16_ = right_children;
						if (g_list_length (_tmp16_) > ((guint) 0)) {
							GList* _tmp17_;
							GList* _tmp18_;
							gconstpointer _tmp19_;
							GtkWidget* _tmp20_;
							WingpanelWidgetsIndicatorEntry* _tmp21_;
							_tmp17_ = right_children;
							_tmp18_ = g_list_last (_tmp17_);
							_tmp19_ = _tmp18_->data;
							_tmp20_ = (GtkWidget*) _tmp19_;
							_tmp21_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp20_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp20_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp21_;
						}
						(right_children == NULL) ? NULL : (right_children = (g_list_free (right_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string (WINGPANEL_INDICATOR_DATETIME)))) {
		switch (0) {
			default:
			{
				GList* children = NULL;
				GtkMenuBar* _tmp22_;
				GList* _tmp23_;
				gint index = 0;
				GList* _tmp24_;
				_tmp22_ = self->priv->center_menubar;
				_tmp23_ = gtk_container_get_children ((GtkContainer*) _tmp22_);
				children = _tmp23_;
				_tmp24_ = children;
				index = g_list_index (_tmp24_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					if (index != 0) {
						GList* _tmp25_;
						gconstpointer _tmp26_;
						GtkWidget* _tmp27_;
						WingpanelWidgetsIndicatorEntry* _tmp28_;
						_tmp25_ = children;
						_tmp26_ = g_list_nth_data (_tmp25_, (guint) (index - 1));
						_tmp27_ = (GtkWidget*) _tmp26_;
						_tmp28_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp27_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp27_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp28_;
					} else {
						GList* left_children = NULL;
						GtkMenuBar* _tmp29_;
						GList* _tmp30_;
						GList* _tmp31_;
						_tmp29_ = self->priv->left_menubar;
						_tmp30_ = gtk_container_get_children ((GtkContainer*) _tmp29_);
						left_children = _tmp30_;
						_tmp31_ = left_children;
						if (g_list_length (_tmp31_) > ((guint) 0)) {
							GList* _tmp32_;
							GList* _tmp33_;
							gconstpointer _tmp34_;
							GtkWidget* _tmp35_;
							WingpanelWidgetsIndicatorEntry* _tmp36_;
							_tmp32_ = left_children;
							_tmp33_ = g_list_last (_tmp32_);
							_tmp34_ = _tmp33_->data;
							_tmp35_ = (GtkWidget*) _tmp34_;
							_tmp36_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp35_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp35_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp36_;
						}
						(left_children == NULL) ? NULL : (left_children = (g_list_free (left_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GList* children = NULL;
				WingpanelWidgetsIndicatorMenuBar* _tmp37_;
				GList* _tmp38_;
				gint index = 0;
				GList* _tmp39_;
				_tmp37_ = self->priv->right_menubar;
				_tmp38_ = gtk_container_get_children ((GtkContainer*) _tmp37_);
				children = _tmp38_;
				_tmp39_ = children;
				index = g_list_index (_tmp39_, (GtkWidget*) current);
				if (index == -1) {
					(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
					break;
				} else {
					if (index != 0) {
						GList* _tmp40_;
						gconstpointer _tmp41_;
						GtkWidget* _tmp42_;
						WingpanelWidgetsIndicatorEntry* _tmp43_;
						_tmp40_ = children;
						_tmp41_ = g_list_nth_data (_tmp40_, (guint) (index - 1));
						_tmp42_ = (GtkWidget*) _tmp41_;
						_tmp43_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp42_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp42_) : NULL);
						_g_object_unref0 (sibling);
						sibling = _tmp43_;
					} else {
						GList* center_children = NULL;
						GtkMenuBar* _tmp44_;
						GList* _tmp45_;
						GList* _tmp46_;
						_tmp44_ = self->priv->center_menubar;
						_tmp45_ = gtk_container_get_children ((GtkContainer*) _tmp44_);
						center_children = _tmp45_;
						_tmp46_ = center_children;
						if (g_list_length (_tmp46_) > ((guint) 0)) {
							GList* _tmp47_;
							GList* _tmp48_;
							gconstpointer _tmp49_;
							GtkWidget* _tmp50_;
							WingpanelWidgetsIndicatorEntry* _tmp51_;
							_tmp47_ = center_children;
							_tmp48_ = g_list_last (_tmp47_);
							_tmp49_ = _tmp48_->data;
							_tmp50_ = (GtkWidget*) _tmp49_;
							_tmp51_ = _g_object_ref0 (WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp50_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp50_) : NULL);
							_g_object_unref0 (sibling);
							sibling = _tmp51_;
						}
						(center_children == NULL) ? NULL : (center_children = (g_list_free (center_children), NULL));
					}
				}
				(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
				break;
			}
		}
	}
	result = sibling;
	return result;
}

static void
wingpanel_widgets_panel_add_indicator (WingpanelWidgetsPanel* self,
                                       WingpanelIndicator* indicator)
{
	WingpanelWidgetsIndicatorEntry* indicator_entry = NULL;
	WingpanelServicesPopoverManager* _tmp0_;
	WingpanelWidgetsIndicatorEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	WingpanelWidgetsIndicatorEntry* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (indicator != NULL);
	_tmp0_ = self->priv->_popover_manager;
	_tmp1_ = wingpanel_widgets_indicator_entry_new (indicator, _tmp0_);
	g_object_ref_sink (_tmp1_);
	indicator_entry = _tmp1_;
	_tmp2_ = wingpanel_indicator_get_code_name (indicator);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string (WINGPANEL_INDICATOR_APP_LAUNCHER)))) {
		switch (0) {
			default:
			{
				WingpanelWidgetsIndicatorEntry* _tmp7_;
				GtkMenuBar* _tmp8_;
				WingpanelWidgetsIndicatorEntry* _tmp9_;
				_tmp7_ = indicator_entry;
				wingpanel_widgets_indicator_entry_set_transition_type (_tmp7_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
				_tmp8_ = self->priv->left_menubar;
				_tmp9_ = indicator_entry;
				gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string (WINGPANEL_INDICATOR_DATETIME)))) {
		switch (0) {
			default:
			{
				WingpanelWidgetsIndicatorEntry* _tmp10_;
				GtkMenuBar* _tmp11_;
				WingpanelWidgetsIndicatorEntry* _tmp12_;
				_tmp10_ = indicator_entry;
				wingpanel_widgets_indicator_entry_set_transition_type (_tmp10_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
				_tmp11_ = self->priv->center_menubar;
				_tmp12_ = indicator_entry;
				gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				WingpanelWidgetsIndicatorEntry* _tmp13_;
				WingpanelWidgetsIndicatorMenuBar* _tmp14_;
				WingpanelWidgetsIndicatorEntry* _tmp15_;
				_tmp13_ = indicator_entry;
				wingpanel_widgets_indicator_entry_set_transition_type (_tmp13_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
				_tmp14_ = self->priv->right_menubar;
				_tmp15_ = indicator_entry;
				wingpanel_widgets_indicator_menu_bar_insert_sorted (_tmp14_, _tmp15_);
				break;
			}
		}
	}
	_tmp16_ = indicator_entry;
	gtk_widget_show_all ((GtkWidget*) _tmp16_);
	_g_object_unref0 (indicator_entry);
}

static void
wingpanel_widgets_panel_remove_indicator (WingpanelWidgetsPanel* self,
                                          WingpanelIndicator* indicator)
{
	GtkMenuBar* _tmp0_;
	GtkMenuBar* _tmp1_;
	WingpanelWidgetsIndicatorMenuBar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (indicator != NULL);
	_tmp0_ = self->priv->left_menubar;
	wingpanel_widgets_panel_remove_indicator_from_container (self, (GtkContainer*) _tmp0_, indicator);
	_tmp1_ = self->priv->center_menubar;
	wingpanel_widgets_panel_remove_indicator_from_container (self, (GtkContainer*) _tmp1_, indicator);
	_tmp2_ = self->priv->right_menubar;
	wingpanel_widgets_panel_remove_indicator_from_container (self, (GtkContainer*) _tmp2_, indicator);
}

static void
wingpanel_widgets_panel_remove_indicator_from_container (WingpanelWidgetsPanel* self,
                                                         GtkContainer* container,
                                                         WingpanelIndicator* indicator)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (indicator != NULL);
	_tmp0_ = gtk_container_get_children (container);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				WingpanelWidgetsIndicatorEntry* entry = NULL;
				GtkWidget* _tmp1_;
				gboolean _tmp2_ = FALSE;
				WingpanelWidgetsIndicatorEntry* _tmp3_;
				_tmp1_ = child;
				entry = WINGPANEL_WIDGETS_IS_INDICATOR_ENTRY (_tmp1_) ? ((WingpanelWidgetsIndicatorEntry*) _tmp1_) : NULL;
				_tmp3_ = entry;
				if (_tmp3_ != NULL) {
					WingpanelWidgetsIndicatorEntry* _tmp4_;
					WingpanelIndicator* _tmp5_;
					WingpanelIndicator* _tmp6_;
					_tmp4_ = entry;
					_tmp5_ = wingpanel_widgets_indicator_entry_get_base_indicator (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_ == indicator;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GtkWidget* _tmp7_;
					_tmp7_ = child;
					gtk_container_remove (container, _tmp7_);
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
wingpanel_widgets_panel_update_background (WingpanelWidgetsPanel* self,
                                           WingpanelServicesBackgroundState state,
                                           guint animation_duration)
{
	GtkCssProvider* _tmp0_;
	gchar* css = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->style_provider;
	if (_tmp0_ == NULL) {
		GtkCssProvider* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkCssProvider* _tmp3_;
		_tmp1_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->style_provider);
		self->priv->style_provider = _tmp1_;
		_tmp2_ = self->priv->style_context;
		_tmp3_ = self->priv->style_provider;
		gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp4_ = g_strdup_printf ("\n" \
"            .panel {\n" \
"                transition: all %ums ease-in-out;\n" \
"            }\n" \
"        ", animation_duration);
	css = _tmp4_;
	{
		GtkCssProvider* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp5_ = self->priv->style_provider;
		_tmp6_ = css;
		_tmp7_ = css;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_css_provider_load_from_data (_tmp5_, _tmp6_, (gssize) _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("Panel.vala:300: Parsing own style configuration failed: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	switch (state) {
		case WINGPANEL_SERVICES_BACKGROUND_STATE_DARK:
		{
			GtkStyleContext* _tmp12_;
			GtkStyleContext* _tmp13_;
			GtkStyleContext* _tmp14_;
			GtkStyleContext* _tmp15_;
			_tmp12_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp12_, "color-light");
			_tmp13_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp13_, "color-dark");
			_tmp14_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp14_, "maximized");
			_tmp15_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp15_, "translucent");
			break;
		}
		case WINGPANEL_SERVICES_BACKGROUND_STATE_LIGHT:
		{
			GtkStyleContext* _tmp16_;
			GtkStyleContext* _tmp17_;
			GtkStyleContext* _tmp18_;
			GtkStyleContext* _tmp19_;
			_tmp16_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp16_, "color-dark");
			_tmp17_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp17_, "color-light");
			_tmp18_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp18_, "maximized");
			_tmp19_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp19_, "translucent");
			break;
		}
		case WINGPANEL_SERVICES_BACKGROUND_STATE_MAXIMIZED:
		{
			GtkStyleContext* _tmp20_;
			GtkStyleContext* _tmp21_;
			GtkStyleContext* _tmp22_;
			GtkStyleContext* _tmp23_;
			_tmp20_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp20_, "maximized");
			_tmp21_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp21_, "color-light");
			_tmp22_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp22_, "color-dark");
			_tmp23_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp23_, "translucent");
			break;
		}
		case WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_DARK:
		{
			GtkStyleContext* _tmp24_;
			GtkStyleContext* _tmp25_;
			GtkStyleContext* _tmp26_;
			GtkStyleContext* _tmp27_;
			_tmp24_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp24_, "translucent");
			_tmp25_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp25_, "color-light");
			_tmp26_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp26_, "color-dark");
			_tmp27_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp27_, "maximized");
			break;
		}
		case WINGPANEL_SERVICES_BACKGROUND_STATE_TRANSLUCENT_LIGHT:
		{
			GtkStyleContext* _tmp28_;
			GtkStyleContext* _tmp29_;
			GtkStyleContext* _tmp30_;
			GtkStyleContext* _tmp31_;
			_tmp28_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp28_, "translucent");
			_tmp29_ = self->priv->style_context;
			gtk_style_context_add_class (_tmp29_, "color-dark");
			_tmp30_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp30_, "color-light");
			_tmp31_ = self->priv->style_context;
			gtk_style_context_remove_class (_tmp31_, "maximized");
			break;
		}
		default:
		break;
	}
	_g_free0 (css);
}

WingpanelServicesPopoverManager*
wingpanel_widgets_panel_get_popover_manager (WingpanelWidgetsPanel* self)
{
	WingpanelServicesPopoverManager* result;
	WingpanelServicesPopoverManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_popover_manager;
	result = _tmp0_;
	return result;
}

static void
wingpanel_widgets_panel_set_popover_manager (WingpanelWidgetsPanel* self,
                                             WingpanelServicesPopoverManager* value)
{
	WingpanelServicesPopoverManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = wingpanel_widgets_panel_get_popover_manager (self);
	if (old_value != value) {
		WingpanelServicesPopoverManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_popover_manager);
		self->priv->_popover_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wingpanel_widgets_panel_properties[WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY]);
	}
}

static void
_wingpanel_widgets_panel_add_indicator_wingpanel_indicator_manager_indicator_added (WingpanelIndicatorManager* _sender,
                                                                                    WingpanelIndicator* indicator,
                                                                                    gpointer self)
{
	wingpanel_widgets_panel_add_indicator ((WingpanelWidgetsPanel*) self, indicator);
}

static void
_wingpanel_widgets_panel_remove_indicator_wingpanel_indicator_manager_indicator_removed (WingpanelIndicatorManager* _sender,
                                                                                         WingpanelIndicator* indicator,
                                                                                         gpointer self)
{
	wingpanel_widgets_panel_remove_indicator ((WingpanelWidgetsPanel*) self, indicator);
}

static gboolean
_wingpanel_widgets_panel___lambda21_ (WingpanelWidgetsPanel* self,
                                      WingpanelIndicator* indicator)
{
	gboolean result;
	g_return_val_if_fail (indicator != NULL, FALSE);
	wingpanel_widgets_panel_add_indicator (self, indicator);
	result = TRUE;
	_g_object_unref0 (indicator);
	return result;
}

static gboolean
__wingpanel_widgets_panel___lambda21__gee_forall_func (gpointer g,
                                                       gpointer self)
{
	gboolean result;
	result = _wingpanel_widgets_panel___lambda21_ ((WingpanelWidgetsPanel*) self, (WingpanelIndicator*) g);
	return result;
}

static void
_wingpanel_widgets_panel_update_background_wingpanel_services_background_manager_background_state_changed (WingpanelServicesBackgroundManager* _sender,
                                                                                                           WingpanelServicesBackgroundState state,
                                                                                                           guint animation_duration,
                                                                                                           gpointer self)
{
	wingpanel_widgets_panel_update_background ((WingpanelWidgetsPanel*) self, state, animation_duration);
}

static GObject *
wingpanel_widgets_panel_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WingpanelWidgetsPanel * self;
	GtkMenuBar* _tmp0_ = NULL;
	GtkMenuBar* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* _tmp3_;
	GtkMenuBar* _tmp4_ = NULL;
	GtkMenuBar* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkCssProvider* _tmp7_;
	WingpanelWidgetsIndicatorMenuBar* _tmp8_ = NULL;
	WingpanelWidgetsIndicatorMenuBar* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkCssProvider* _tmp11_;
	GtkBox* box = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkMenuBar* _tmp14_;
	GtkBox* _tmp15_;
	GtkMenuBar* _tmp16_;
	GtkBox* _tmp17_;
	WingpanelWidgetsIndicatorMenuBar* _tmp18_;
	GtkBox* _tmp19_;
	WingpanelIndicatorManager* indicator_manager = NULL;
	WingpanelIndicatorManager* _tmp20_;
	WingpanelIndicatorManager* _tmp21_;
	WingpanelIndicatorManager* _tmp22_;
	WingpanelIndicatorManager* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkCssProvider* _tmp29_;
	WingpanelServicesBackgroundManager* _tmp30_;
	WingpanelServicesBackgroundManager* _tmp31_;
	parent_class = G_OBJECT_CLASS (wingpanel_widgets_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanel);
	g_object_set ((GtkWidget*) self, "height-request", 30, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp0_ = (GtkMenuBar*) gtk_menu_bar_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->left_menubar);
	self->priv->left_menubar = _tmp0_;
	_tmp1_ = self->priv->left_menubar;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = wingpanel_widgets_panel_resource_provider;
	gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = (GtkMenuBar*) gtk_menu_bar_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->center_menubar);
	self->priv->center_menubar = _tmp4_;
	_tmp5_ = self->priv->center_menubar;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = wingpanel_widgets_panel_resource_provider;
	gtk_style_context_add_provider (_tmp6_, (GtkStyleProvider*) _tmp7_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp8_ = wingpanel_widgets_indicator_menu_bar_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp8_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->right_menubar);
	self->priv->right_menubar = _tmp8_;
	_tmp9_ = self->priv->right_menubar;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	_tmp11_ = wingpanel_widgets_panel_resource_provider;
	gtk_style_context_add_provider (_tmp10_, (GtkStyleProvider*) _tmp11_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp12_);
	box = _tmp12_;
	_tmp13_ = box;
	_tmp14_ = self->priv->left_menubar;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_tmp15_ = box;
	_tmp16_ = self->priv->center_menubar;
	gtk_box_set_center_widget (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = box;
	_tmp18_ = self->priv->right_menubar;
	gtk_box_pack_end (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp19_);
	_tmp20_ = wingpanel_indicator_manager_get_default ();
	indicator_manager = _tmp20_;
	_tmp21_ = indicator_manager;
	g_signal_connect_object (_tmp21_, "indicator-added", (GCallback) _wingpanel_widgets_panel_add_indicator_wingpanel_indicator_manager_indicator_added, self, 0);
	_tmp22_ = indicator_manager;
	g_signal_connect_object (_tmp22_, "indicator-removed", (GCallback) _wingpanel_widgets_panel_remove_indicator_wingpanel_indicator_manager_indicator_removed, self, 0);
	_tmp23_ = indicator_manager;
	_tmp24_ = wingpanel_indicator_manager_get_indicators (_tmp23_);
	_tmp25_ = _tmp24_;
	gee_traversable_foreach ((GeeTraversable*) _tmp25_, __wingpanel_widgets_panel___lambda21__gee_forall_func, self);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) self);
	self->priv->style_context = _tmp26_;
	_tmp27_ = self->priv->style_context;
	gtk_style_context_add_class (_tmp27_, WINGPANEL_WIDGETS_STYLE_CLASS_PANEL);
	_tmp28_ = self->priv->style_context;
	_tmp29_ = wingpanel_widgets_panel_resource_provider;
	gtk_style_context_add_provider (_tmp28_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp30_ = wingpanel_services_background_manager_get_default ();
	_tmp31_ = _tmp30_;
	g_signal_connect_object (_tmp31_, "background-state-changed", (GCallback) _wingpanel_widgets_panel_update_background_wingpanel_services_background_manager_background_state_changed, self, 0);
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (box);
	return obj;
}

static void
wingpanel_widgets_panel_class_init (WingpanelWidgetsPanelClass * klass,
                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	wingpanel_widgets_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelWidgetsPanel_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) wingpanel_widgets_panel_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_wingpanel_widgets_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wingpanel_widgets_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = wingpanel_widgets_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = wingpanel_widgets_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY, wingpanel_widgets_panel_properties[WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY] = g_param_spec_object ("popover-manager", "popover-manager", "popover-manager", WINGPANEL_SERVICES_TYPE_POPOVER_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (wingpanel_widgets_panel_resource_provider);
	wingpanel_widgets_panel_resource_provider = _tmp0_;
	_tmp1_ = wingpanel_widgets_panel_resource_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/wingpanel/panel.css");
}

static void
wingpanel_widgets_panel_instance_init (WingpanelWidgetsPanel * self,
                                       gpointer klass)
{
	self->priv = wingpanel_widgets_panel_get_instance_private (self);
	self->priv->style_provider = NULL;
}

static void
wingpanel_widgets_panel_finalize (GObject * obj)
{
	WingpanelWidgetsPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanel);
	_g_object_unref0 (self->priv->_popover_manager);
	_g_object_unref0 (self->priv->right_menubar);
	_g_object_unref0 (self->priv->left_menubar);
	_g_object_unref0 (self->priv->center_menubar);
	_g_object_unref0 (self->priv->style_provider);
	G_OBJECT_CLASS (wingpanel_widgets_panel_parent_class)->finalize (obj);
}

static GType
wingpanel_widgets_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelWidgetsPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_widgets_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelWidgetsPanel), 0, (GInstanceInitFunc) wingpanel_widgets_panel_instance_init, NULL };
	GType wingpanel_widgets_panel_type_id;
	wingpanel_widgets_panel_type_id = g_type_register_static (gtk_event_box_get_type (), "WingpanelWidgetsPanel", &g_define_type_info, 0);
	WingpanelWidgetsPanel_private_offset = g_type_add_instance_private (wingpanel_widgets_panel_type_id, sizeof (WingpanelWidgetsPanelPrivate));
	return wingpanel_widgets_panel_type_id;
}

GType
wingpanel_widgets_panel_get_type (void)
{
	static volatile gsize wingpanel_widgets_panel_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_widgets_panel_type_id__once)) {
		GType wingpanel_widgets_panel_type_id;
		wingpanel_widgets_panel_type_id = wingpanel_widgets_panel_get_type_once ();
		g_once_init_leave (&wingpanel_widgets_panel_type_id__once, wingpanel_widgets_panel_type_id);
	}
	return wingpanel_widgets_panel_type_id__once;
}

static void
_vala_wingpanel_widgets_panel_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	WingpanelWidgetsPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanel);
	switch (property_id) {
		case WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY:
		g_value_set_object (value, wingpanel_widgets_panel_get_popover_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wingpanel_widgets_panel_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	WingpanelWidgetsPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_WIDGETS_TYPE_PANEL, WingpanelWidgetsPanel);
	switch (property_id) {
		case WINGPANEL_WIDGETS_PANEL_POPOVER_MANAGER_PROPERTY:
		wingpanel_widgets_panel_set_popover_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

