"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImagePuller = void 0;
const child_process = require("child_process");
class ImagePuller {
    constructor(connection, context, containerEngine, containerImage, pullPolicy, pullArguments) {
        var _a;
        this.useProgressTracker = false;
        this.connection = connection;
        this.context = context;
        this._containerEngine = containerEngine;
        this._containerImage = containerImage;
        this._pullPolicy = pullPolicy;
        this._pullArguments = pullArguments;
        this.useProgressTracker =
            !!((_a = context.clientCapabilities.window) === null || _a === void 0 ? void 0 : _a.workDoneProgress);
    }
    setupImage() {
        return __awaiter(this, void 0, void 0, function* () {
            let setupComplete = false;
            const imageTag = this._containerImage.split(":", 2)[1] || "latest";
            const imagePresent = this.checkForImage();
            const pullRequired = this.determinePull(imagePresent, imageTag);
            let progressTracker;
            if (this.useProgressTracker) {
                progressTracker = yield this.connection.window.createWorkDoneProgress();
            }
            if (pullRequired) {
                this.connection.console.log(`Pulling image '${this._containerImage}' with pull-policy '${this._pullPolicy}' and image-tag '${imageTag}'`);
                try {
                    let pullCommand;
                    if (this._pullArguments && this._pullArguments !== "") {
                        pullCommand = `${this._containerEngine} pull ${this._containerImage} ${this._pullArguments}`;
                    }
                    else {
                        pullCommand = `${this._containerEngine} pull ${this._containerImage}`;
                    }
                    this.connection.console.log(`Running pull command: '${pullCommand}'`);
                    if (progressTracker) {
                        progressTracker.begin("execution-environment", undefined, "Pulling Ansible execution environment image...");
                    }
                    child_process.execSync(pullCommand, {
                        encoding: "utf-8",
                    });
                    this.connection.console.info(`Container image '${this._containerImage}' pull successful`);
                    setupComplete = true;
                }
                catch (error) {
                    let errorMsg = `Failed to pull container image ${this._containerEngine} with error '${error}'`;
                    errorMsg +=
                        "Check the execution environment image name, connectivity to and permissions for the registry, and try again";
                    this.connection.console.error(errorMsg);
                    setupComplete = false;
                }
            }
            else {
                setupComplete = true;
            }
            if (progressTracker) {
                progressTracker.done();
            }
            return setupComplete;
        });
    }
    determinePull(imagePresent, imageTag) {
        let pull;
        if (this._pullPolicy === "missing" && !imagePresent) {
            pull = true;
        }
        else if (this._pullPolicy === "always") {
            pull = true;
        }
        else if (this._pullPolicy === "tag" && imageTag === "latest") {
            pull = true;
        }
        else if (this._pullPolicy === "tag" && !imagePresent) {
            pull = true;
        }
        else {
            pull = false;
        }
        return pull;
    }
    checkForImage() {
        try {
            const command = `${this._containerEngine} image inspect ${this._containerImage}`;
            this.connection.console.log(`check for container image with command: '${command}'`);
            child_process.execSync(command, {
                encoding: "utf-8",
            });
            return true;
        }
        catch (error) {
            this.connection.console.log(`'${this._containerImage}' image inspection failed, image assumed to be corrupted or missing`);
            return false;
        }
    }
}
exports.ImagePuller = ImagePuller;
//# sourceMappingURL=imagePuller.js.map