/* components-info-bar.c generated by valac 0.56.3, the Vala compiler
 * generated from components-info-bar.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include "geary-engine.h"
#include <gee.h>
#include <gio/gio.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>

enum  {
	COMPONENTS_INFO_BAR_0_PROPERTY,
	COMPONENTS_INFO_BAR_STATUS_PROPERTY,
	COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY,
	COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY,
	COMPONENTS_INFO_BAR_REVEALED_PROPERTY,
	COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY,
	COMPONENTS_INFO_BAR_NUM_PROPERTIES
};
static GParamSpec* components_info_bar_properties[COMPONENTS_INFO_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _Block55Data Block55Data;
typedef struct _Block56Data Block56Data;
enum  {
	COMPONENTS_INFO_BAR_RESPONSE_SIGNAL,
	COMPONENTS_INFO_BAR_NUM_SIGNALS
};
static guint components_info_bar_signals[COMPONENTS_INFO_BAR_NUM_SIGNALS] = {0};

struct _ComponentsInfoBarPrivate {
	GtkLabel* _status;
	GtkLabel* _description;
	gboolean _show_close_button;
	gboolean _revealed;
	GtkMessageType _message_type;
	PluginInfoBar* plugin;
	gchar* plugin_action_group_name;
	GtkButton* plugin_primary_button;
	GtkRevealer* revealer;
	GtkBox* action_area;
	GtkBox* content_area;
	GtkButton* close_button;
};

struct _Block55Data {
	int _ref_count_;
	ComponentsInfoBar* self;
	PluginInfoBar* plugin;
};

struct _Block56Data {
	int _ref_count_;
	ComponentsInfoBar* self;
	gint response_id;
};

static gint ComponentsInfoBar_private_offset;
static gpointer components_info_bar_parent_class = NULL;

static void components_info_bar_set_status (ComponentsInfoBar* self,
                                     GtkLabel* value);
static void components_info_bar_set_description (ComponentsInfoBar* self,
                                          GtkLabel* value);
static void _components_info_bar_set_message_type (ComponentsInfoBar* self,
                                            GtkMessageType message_type);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda63_ (Block55Data* _data55_);
static void ___lambda63__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda64_ (Block55Data* _data55_);
static void ___lambda64__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda65_ (ComponentsInfoBar* self);
static void components_info_bar_update_plugin_primary_button (ComponentsInfoBar* self);
static void ___lambda65__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GtkButton* components_info_bar_new_plugin_button (ComponentsInfoBar* self,
                                                  PluginActionable* ui);
static void _components_info_bar_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void components_info_bar_real_destroy (GtkWidget* base);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void __lambda66_ (Block56Data* _data56_);
static void ___lambda66__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void components_info_bar_finalize (GObject * obj);
static GType components_info_bar_get_type_once (void);
static void _vala_components_info_bar_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_components_info_bar_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
components_info_bar_get_instance_private (ComponentsInfoBar* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInfoBar_private_offset);
}

GtkLabel*
components_info_bar_get_status (ComponentsInfoBar* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
components_info_bar_set_status (ComponentsInfoBar* self,
                                GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	old_value = components_info_bar_get_status (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_status);
		self->priv->_status = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_info_bar_properties[COMPONENTS_INFO_BAR_STATUS_PROPERTY]);
	}
}

GtkLabel*
components_info_bar_get_description (ComponentsInfoBar* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
components_info_bar_set_description (ComponentsInfoBar* self,
                                     GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	old_value = components_info_bar_get_description (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_info_bar_properties[COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY]);
	}
}

gboolean
components_info_bar_get_show_close_button (ComponentsInfoBar* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), FALSE);
	result = self->priv->_show_close_button;
	return result;
}

void
components_info_bar_set_show_close_button (ComponentsInfoBar* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	old_value = components_info_bar_get_show_close_button (self);
	if (old_value != value) {
		self->priv->_show_close_button = value;
		g_object_notify_by_pspec ((GObject *) self, components_info_bar_properties[COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY]);
	}
}

gboolean
components_info_bar_get_revealed (ComponentsInfoBar* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), FALSE);
	result = self->priv->_revealed;
	return result;
}

void
components_info_bar_set_revealed (ComponentsInfoBar* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	old_value = components_info_bar_get_revealed (self);
	if (old_value != value) {
		self->priv->_revealed = value;
		g_object_notify_by_pspec ((GObject *) self, components_info_bar_properties[COMPONENTS_INFO_BAR_REVEALED_PROPERTY]);
	}
}

GtkMessageType
components_info_bar_get_message_type (ComponentsInfoBar* self)
{
	GtkMessageType result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), 0);
	result = self->priv->_message_type;
	return result;
}

void
components_info_bar_set_message_type (ComponentsInfoBar* self,
                                      GtkMessageType value)
{
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	_components_info_bar_set_message_type (self, value);
	g_object_notify_by_pspec ((GObject *) self, components_info_bar_properties[COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY]);
}

/**
     * Constructs a new info bar.
     *
     * @param status a short, human-readable status message, ideally
     * less than 20 characters long
     * @param description an optional, longer human-readable
     * explanation of {@link status}.
     */
ComponentsInfoBar*
components_info_bar_construct (GType object_type,
                               const gchar* status,
                               const gchar* description)
{
	ComponentsInfoBar * self = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkButton* _tmp5_;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp6_;
	PangoAttrList* _tmp7_;
	PangoAttribute* _tmp8_;
	GtkLabel* _tmp9_;
	PangoAttrList* _tmp10_;
	GtkGrid* container = NULL;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GtkGrid* _tmp29_;
	g_return_val_if_fail (status != NULL, NULL);
	self = (ComponentsInfoBar*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (status);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	components_info_bar_set_status (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_status;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp3_ = self->priv->_status;
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	_components_info_bar_set_message_type (self, GTK_MESSAGE_INFO);
	_tmp4_ = self->priv->revealer;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "revealed", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "reveal-child", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->close_button;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "show-close-button", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject), "visible", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = pango_attr_list_new ();
	attrs = _tmp6_;
	_tmp7_ = attrs;
	_tmp8_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_change (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->_status;
	_tmp10_ = attrs;
	gtk_label_set_attributes (_tmp9_, _tmp10_);
	if (!geary_string_is_empty_or_whitespace (description)) {
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		GtkLabel* _tmp18_;
		_tmp11_ = self->priv->_status;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
		_tmp12_ = (GtkLabel*) gtk_label_new (description);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		components_info_bar_set_description (self, _tmp13_);
		_g_object_unref0 (_tmp13_);
		_tmp14_ = self->priv->_description;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
		_tmp15_ = self->priv->_description;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
		_tmp16_ = self->priv->_description;
		gtk_label_set_xalign (_tmp16_, (gfloat) 0);
		_tmp17_ = self->priv->_description;
		g_object_set (_tmp17_, "wrap", TRUE, NULL);
		_tmp18_ = self->priv->_description;
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), description);
	}
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp19_);
	container = _tmp19_;
	_tmp20_ = container;
	gtk_orientable_set_orientation (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_orientable_get_type (), GtkOrientable), GTK_ORIENTATION_VERTICAL);
	_tmp21_ = container;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp22_ = container;
	_tmp23_ = self->priv->_status;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
	_tmp24_ = self->priv->_description;
	if (_tmp24_ != NULL) {
		GtkGrid* _tmp25_;
		GtkLabel* _tmp26_;
		_tmp25_ = container;
		_tmp26_ = self->priv->_description;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp27_ = components_info_bar_get_content_area (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = container;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp28_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (container);
	_pango_attr_list_unref0 (attrs);
	return self;
}

ComponentsInfoBar*
components_info_bar_new (const gchar* status,
                         const gchar* description)
{
	return components_info_bar_construct (COMPONENTS_TYPE_INFO_BAR, status, description);
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		ComponentsInfoBar* self;
		self = _data55_->self;
		_g_object_unref0 (_data55_->plugin);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
__lambda63_ (Block55Data* _data55_)
{
	ComponentsInfoBar* self;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data55_->self;
	_tmp0_ = self->priv->_status;
	_tmp1_ = plugin_info_bar_get_status (_data55_->plugin);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
}

static void
___lambda63__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda63_ (self);
}

static void
__lambda64_ (Block55Data* _data55_)
{
	ComponentsInfoBar* self;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data55_->self;
	_tmp0_ = self->priv->_description;
	_tmp1_ = plugin_info_bar_get_description (_data55_->plugin);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
}

static void
___lambda64__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda64_ (self);
}

static void
__lambda65_ (ComponentsInfoBar* self)
{
	components_info_bar_update_plugin_primary_button (self);
}

static void
___lambda65__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda65_ ((ComponentsInfoBar*) self);
}

ComponentsInfoBar*
components_info_bar_construct_for_plugin (GType object_type,
                                          PluginInfoBar* plugin,
                                          const gchar* action_group_name,
                                          gint priority)
{
	ComponentsInfoBar * self = NULL;
	Block55Data* _data55_;
	PluginInfoBar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	PluginInfoBar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GtkRevealer* _tmp9_;
	GtkButton* _tmp10_;
	GeeBidirListIterator* secondaries = NULL;
	GeeBidirList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirListIterator* _tmp13_;
	gboolean has_prev = FALSE;
	GeeBidirListIterator* _tmp14_;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (plugin), NULL);
	g_return_val_if_fail (action_group_name != NULL, NULL);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (plugin);
	_g_object_unref0 (_data55_->plugin);
	_data55_->plugin = _tmp0_;
	_tmp1_ = plugin_info_bar_get_status (_data55_->plugin);
	_tmp2_ = _tmp1_;
	_tmp3_ = plugin_info_bar_get_description (_data55_->plugin);
	_tmp4_ = _tmp3_;
	self = (ComponentsInfoBar*) components_info_bar_construct (object_type, _tmp2_, _tmp4_);
	_data55_->self = g_object_ref (self);
	_tmp5_ = _g_object_ref0 (_data55_->plugin);
	_g_object_unref0 (self->priv->plugin);
	self->priv->plugin = _tmp5_;
	_tmp6_ = g_strdup (action_group_name);
	_g_free0 (self->priv->plugin_action_group_name);
	self->priv->plugin_action_group_name = _tmp6_;
	_tmp7_ = plugin_info_bar_get_show_close_button (_data55_->plugin);
	_tmp8_ = _tmp7_;
	components_info_bar_set_show_close_button (self, _tmp8_);
	self->priv->_message_type = GTK_MESSAGE_OTHER;
	_components_info_bar_set_message_type (self, GTK_MESSAGE_INFO);
	_tmp9_ = self->priv->revealer;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "revealed", G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "reveal-child", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->close_button;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "show-close-button", G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), "visible", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data55_->plugin, G_TYPE_OBJECT, GObject), "notify::status", (GCallback) ___lambda63__g_object_notify, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data55_->plugin, G_TYPE_OBJECT, GObject), "notify::description", (GCallback) ___lambda64__g_object_notify, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data55_->plugin, G_TYPE_OBJECT, GObject), "notify::primary-button", (GCallback) ___lambda65__g_object_notify, self, 0);
	_tmp11_ = plugin_info_bar_get_secondary_buttons (_data55_->plugin);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_bidir_list_bidir_list_iterator (_tmp12_);
	secondaries = _tmp13_;
	_tmp14_ = secondaries;
	has_prev = gee_bidir_iterator_last (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator));
	while (TRUE) {
		GtkBox* _tmp15_;
		GtkBox* _tmp16_;
		GeeBidirListIterator* _tmp17_;
		gpointer _tmp18_;
		PluginActionable* _tmp19_;
		GtkButton* _tmp20_;
		GtkButton* _tmp21_;
		GeeBidirListIterator* _tmp22_;
		if (!has_prev) {
			break;
		}
		_tmp15_ = components_info_bar_get_action_area (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = secondaries;
		_tmp18_ = gee_iterator_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ITERATOR, GeeIterator));
		_tmp19_ = (PluginActionable*) _tmp18_;
		_tmp20_ = components_info_bar_new_plugin_button (self, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp16_);
		_tmp22_ = secondaries;
		has_prev = gee_bidir_iterator_previous (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator));
	}
	components_info_bar_update_plugin_primary_button (self);
	g_object_set_data_full (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), COMPONENTS_INFO_BAR_STACK_PRIORITY_QUEUE_KEY, (gpointer) ((gintptr) priority), NULL);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (secondaries);
	block55_data_unref (_data55_);
	_data55_ = NULL;
	return self;
}

ComponentsInfoBar*
components_info_bar_new_for_plugin (PluginInfoBar* plugin,
                                    const gchar* action_group_name,
                                    gint priority)
{
	return components_info_bar_construct_for_plugin (COMPONENTS_TYPE_INFO_BAR, plugin, action_group_name, priority);
}

void
components_info_bar_on_close_button_clicked (ComponentsInfoBar* self)
{
	PluginInfoBar* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	_tmp0_ = self->priv->plugin;
	if (_tmp0_ != NULL) {
		PluginInfoBar* _tmp1_;
		_tmp1_ = self->priv->plugin;
		g_signal_emit_by_name (_tmp1_, "close-activated");
	}
	g_signal_emit (self, components_info_bar_signals[COMPONENTS_INFO_BAR_RESPONSE_SIGNAL], 0, (gint) GTK_RESPONSE_CLOSE);
}

static void
_components_info_bar_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	components_info_bar_on_close_button_clicked ((ComponentsInfoBar*) self);
}

static void
components_info_bar_real_destroy (GtkWidget* base)
{
	ComponentsInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar);
	_g_object_unref0 (self->priv->plugin);
	self->priv->plugin = NULL;
	GTK_WIDGET_CLASS (components_info_bar_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), gtk_widget_get_type (), GtkWidget));
}

GtkBox*
components_info_bar_get_action_area (ComponentsInfoBar* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->action_area;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GtkBox*
components_info_bar_get_content_area (ComponentsInfoBar* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->content_area;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		ComponentsInfoBar* self;
		self = _data56_->self;
		_g_object_unref0 (self);
		g_slice_free (Block56Data, _data56_);
	}
}

static void
__lambda66_ (Block56Data* _data56_)
{
	ComponentsInfoBar* self;
	self = _data56_->self;
	g_signal_emit (self, components_info_bar_signals[COMPONENTS_INFO_BAR_RESPONSE_SIGNAL], 0, _data56_->response_id);
}

static void
___lambda66__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda66_ (self);
}

GtkButton*
components_info_bar_add_button (ComponentsInfoBar* self,
                                const gchar* button_text,
                                gint response_id)
{
	Block56Data* _data56_;
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkButton* result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	g_return_val_if_fail (button_text != NULL, NULL);
	_data56_ = g_slice_new0 (Block56Data);
	_data56_->_ref_count_ = 1;
	_data56_->self = g_object_ref (self);
	_data56_->response_id = response_id;
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (button_text);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	g_signal_connect_data (button, "clicked", (GCallback) ___lambda66__gtk_button_clicked, block56_data_ref (_data56_), (GClosureNotify) block56_data_unref, 0);
	_tmp1_ = components_info_bar_get_action_area (self);
	_tmp2_ = _tmp1_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp2_);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget), TRUE);
	result = button;
	block56_data_unref (_data56_);
	_data56_ = NULL;
	return result;
}

static void
components_info_bar_update_plugin_primary_button (ComponentsInfoBar* self)
{
	GtkButton* new_button = NULL;
	gboolean _tmp0_ = FALSE;
	PluginInfoBar* _tmp1_;
	GtkButton* _tmp9_;
	GtkButton* _tmp13_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	new_button = NULL;
	_tmp1_ = self->priv->plugin;
	if (_tmp1_ != NULL) {
		PluginInfoBar* _tmp2_;
		PluginActionable* _tmp3_;
		PluginActionable* _tmp4_;
		_tmp2_ = self->priv->plugin;
		_tmp3_ = plugin_info_bar_get_primary_button (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PluginInfoBar* _tmp5_;
		PluginActionable* _tmp6_;
		PluginActionable* _tmp7_;
		GtkButton* _tmp8_;
		_tmp5_ = self->priv->plugin;
		_tmp6_ = plugin_info_bar_get_primary_button (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = components_info_bar_new_plugin_button (self, _tmp7_);
		_g_object_unref0 (new_button);
		new_button = _tmp8_;
	}
	_tmp9_ = self->priv->plugin_primary_button;
	if (_tmp9_ != NULL) {
		GtkBox* _tmp10_;
		GtkBox* _tmp11_;
		GtkButton* _tmp12_;
		_tmp10_ = components_info_bar_get_action_area (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->plugin_primary_button;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp11_);
	}
	_tmp13_ = new_button;
	if (_tmp13_ != NULL) {
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		GtkButton* _tmp16_;
		_tmp14_ = components_info_bar_get_action_area (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = new_button;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp15_);
	}
	_tmp17_ = new_button;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->plugin_primary_button);
	self->priv->plugin_primary_button = _tmp18_;
	_g_object_unref0 (new_button);
}

static GtkButton*
components_info_bar_new_plugin_button (ComponentsInfoBar* self,
                                       PluginActionable* ui)
{
	GtkButton* button = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkButton* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GAction* _tmp18_;
	GAction* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GtkButton* _tmp29_;
	GtkButton* result;
	g_return_val_if_fail (COMPONENTS_IS_INFO_BAR (self), NULL);
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (ui), NULL);
	button = NULL;
	_tmp0_ = plugin_actionable_get_icon_name (ui);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GtkButton* _tmp4_;
		_tmp2_ = plugin_actionable_get_label (ui);
		_tmp3_ = _tmp2_;
		_tmp4_ = (GtkButton*) gtk_button_new_with_label (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (button);
		button = _tmp4_;
	} else {
		GtkImage* icon = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GtkImage* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		GtkImage* _tmp10_;
		GtkButton* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp5_ = plugin_actionable_get_icon_name (ui);
		_tmp6_ = _tmp5_;
		_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp6_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp7_);
		icon = _tmp7_;
		_tmp8_ = (GtkButton*) gtk_button_new ();
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (button);
		button = _tmp8_;
		_tmp9_ = button;
		_tmp10_ = icon;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = button;
		_tmp12_ = plugin_actionable_get_label (ui);
		_tmp13_ = _tmp12_;
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), _tmp13_);
		_g_object_unref0 (icon);
	}
	_tmp14_ = button;
	_tmp15_ = self->priv->plugin_action_group_name;
	_tmp16_ = g_strconcat (_tmp15_, ".", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = plugin_actionable_get_action (ui);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_action_get_name (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_actionable_get_type (), GtkActionable), _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp17_);
	_tmp24_ = plugin_actionable_get_action_target (ui);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		GtkButton* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		_tmp26_ = button;
		_tmp27_ = plugin_actionable_get_action_target (ui);
		_tmp28_ = _tmp27_;
		gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_actionable_get_type (), GtkActionable), _tmp28_);
	}
	_tmp29_ = button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	result = button;
	return result;
}

static void
_components_info_bar_set_message_type (ComponentsInfoBar* self,
                                       GtkMessageType message_type)
{
	g_return_if_fail (COMPONENTS_IS_INFO_BAR (self));
	if (self->priv->_message_type != message_type) {
		GtkStyleContext* context = NULL;
		GtkStyleContext* _tmp0_;
		GtkStyleContext* _tmp1_;
		static const gchar* type_class[5] = {GTK_STYLE_CLASS_INFO, GTK_STYLE_CLASS_WARNING, GTK_STYLE_CLASS_QUESTION, GTK_STYLE_CLASS_ERROR, NULL};
		const gchar* _tmp2_;
		AtkObject* atk_obj = NULL;
		AtkObject* _tmp5_;
		AtkObject* _tmp6_;
		AtkObject* _tmp7_;
		const gchar* _tmp16_;
		_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp1_ = _g_object_ref0 (_tmp0_);
		context = _tmp1_;
		_tmp2_ = type_class[self->priv->_message_type];
		if (_tmp2_ != NULL) {
			GtkStyleContext* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = context;
			_tmp4_ = type_class[self->priv->_message_type];
			gtk_style_context_remove_class (_tmp3_, _tmp4_);
		}
		self->priv->_message_type = message_type;
		_tmp5_ = gtk_widget_get_accessible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = _g_object_ref0 (_tmp5_);
		atk_obj = _tmp6_;
		_tmp7_ = atk_obj;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, atk_object_get_type ())) {
			gchar* name = NULL;
			AtkObject* _tmp8_;
			const gchar* _tmp13_;
			name = NULL;
			_tmp8_ = atk_obj;
			atk_object_set_role (_tmp8_, ATK_ROLE_INFO_BAR);
			switch (message_type) {
				case GTK_MESSAGE_INFO:
				{
					gchar* _tmp9_;
					_tmp9_ = g_strdup (_ ("Information"));
					_g_free0 (name);
					name = _tmp9_;
					break;
				}
				case GTK_MESSAGE_QUESTION:
				{
					gchar* _tmp10_;
					_tmp10_ = g_strdup (_ ("Question"));
					_g_free0 (name);
					name = _tmp10_;
					break;
				}
				case GTK_MESSAGE_WARNING:
				{
					gchar* _tmp11_;
					_tmp11_ = g_strdup (_ ("Warning"));
					_g_free0 (name);
					name = _tmp11_;
					break;
				}
				case GTK_MESSAGE_ERROR:
				{
					gchar* _tmp12_;
					_tmp12_ = g_strdup (_ ("Error"));
					_g_free0 (name);
					name = _tmp12_;
					break;
				}
				case GTK_MESSAGE_OTHER:
				{
					break;
				}
				default:
				{
					g_warning ("components-info-bar.vala:267: Unknown GtkMessageType %u", (guint) message_type);
					break;
				}
			}
			_tmp13_ = name;
			if (_tmp13_ != NULL) {
				AtkObject* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = atk_obj;
				_tmp15_ = name;
				atk_object_set_name (_tmp14_, _tmp15_);
			}
			_g_free0 (name);
		}
		_tmp16_ = type_class[self->priv->_message_type];
		if (_tmp16_ != NULL) {
			GtkStyleContext* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = context;
			_tmp18_ = type_class[self->priv->_message_type];
			gtk_style_context_add_class (_tmp17_, _tmp18_);
		}
		_g_object_unref0 (atk_obj);
		_g_object_unref0 (context);
	}
}

static void
components_info_bar_class_init (ComponentsInfoBarClass * klass,
                                gpointer klass_data)
{
	components_info_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInfoBar_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) components_info_bar_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_info_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_info_bar_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_info_bar_finalize;
	/**
	     * A short, human-readable status message.
	     *
	     * This should ideally be less than 20 characters long.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_STATUS_PROPERTY, components_info_bar_properties[COMPONENTS_INFO_BAR_STATUS_PROPERTY] = g_param_spec_object ("status", "status", "status", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * An optional, longer human-readable explanation of the status.
	     *
	     * This provides additional information and context for {@link
	     * status}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY, components_info_bar_properties[COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY] = g_param_spec_object ("description", "description", "description", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY, components_info_bar_properties[COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY] = g_param_spec_boolean ("show-close-button", "show-close-button", "show-close-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_REVEALED_PROPERTY, components_info_bar_properties[COMPONENTS_INFO_BAR_REVEALED_PROPERTY] = g_param_spec_boolean ("revealed", "revealed", "revealed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY, components_info_bar_properties[COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY] = g_param_spec_enum ("message-type", "message-type", "message-type", gtk_message_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-info-bar.ui");
	components_info_bar_signals[COMPONENTS_INFO_BAR_RESPONSE_SIGNAL] = g_signal_new ("response", COMPONENTS_TYPE_INFO_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, ComponentsInfoBar_private_offset + G_STRUCT_OFFSET (ComponentsInfoBarPrivate, revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_area", FALSE, ComponentsInfoBar_private_offset + G_STRUCT_OFFSET (ComponentsInfoBarPrivate, action_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_area", FALSE, ComponentsInfoBar_private_offset + G_STRUCT_OFFSET (ComponentsInfoBarPrivate, content_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "close_button", FALSE, ComponentsInfoBar_private_offset + G_STRUCT_OFFSET (ComponentsInfoBarPrivate, close_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_close_button_clicked", G_CALLBACK(_components_info_bar_on_close_button_clicked_gtk_button_clicked));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "infobar");
}

static void
components_info_bar_instance_init (ComponentsInfoBar * self,
                                   gpointer klass)
{
	self->priv = components_info_bar_get_instance_private (self);
	self->priv->_description = NULL;
	self->priv->_show_close_button = FALSE;
	self->priv->_message_type = GTK_MESSAGE_OTHER;
	self->priv->plugin = NULL;
	self->priv->plugin_action_group_name = NULL;
	self->priv->plugin_primary_button = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_info_bar_finalize (GObject * obj)
{
	ComponentsInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar);
	_g_object_unref0 (self->priv->_status);
	_g_object_unref0 (self->priv->_description);
	_g_object_unref0 (self->priv->plugin);
	_g_free0 (self->priv->plugin_action_group_name);
	_g_object_unref0 (self->priv->plugin_primary_button);
	G_OBJECT_CLASS (components_info_bar_parent_class)->finalize (obj);
}

/**
 * A standard info bar widget with status message and description.
 */
static GType
components_info_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInfoBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_info_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInfoBar), 0, (GInstanceInitFunc) components_info_bar_instance_init, NULL };
	GType components_info_bar_type_id;
	components_info_bar_type_id = g_type_register_static (gtk_box_get_type (), "ComponentsInfoBar", &g_define_type_info, 0);
	ComponentsInfoBar_private_offset = g_type_add_instance_private (components_info_bar_type_id, sizeof (ComponentsInfoBarPrivate));
	return components_info_bar_type_id;
}

GType
components_info_bar_get_type (void)
{
	static volatile gsize components_info_bar_type_id__once = 0;
	if (g_once_init_enter (&components_info_bar_type_id__once)) {
		GType components_info_bar_type_id;
		components_info_bar_type_id = components_info_bar_get_type_once ();
		g_once_init_leave (&components_info_bar_type_id__once, components_info_bar_type_id);
	}
	return components_info_bar_type_id__once;
}

static void
_vala_components_info_bar_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ComponentsInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar);
	switch (property_id) {
		case COMPONENTS_INFO_BAR_STATUS_PROPERTY:
		g_value_set_object (value, components_info_bar_get_status (self));
		break;
		case COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY:
		g_value_set_object (value, components_info_bar_get_description (self));
		break;
		case COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY:
		g_value_set_boolean (value, components_info_bar_get_show_close_button (self));
		break;
		case COMPONENTS_INFO_BAR_REVEALED_PROPERTY:
		g_value_set_boolean (value, components_info_bar_get_revealed (self));
		break;
		case COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY:
		g_value_set_enum (value, components_info_bar_get_message_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_info_bar_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ComponentsInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INFO_BAR, ComponentsInfoBar);
	switch (property_id) {
		case COMPONENTS_INFO_BAR_STATUS_PROPERTY:
		components_info_bar_set_status (self, g_value_get_object (value));
		break;
		case COMPONENTS_INFO_BAR_DESCRIPTION_PROPERTY:
		components_info_bar_set_description (self, g_value_get_object (value));
		break;
		case COMPONENTS_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY:
		components_info_bar_set_show_close_button (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_INFO_BAR_REVEALED_PROPERTY:
		components_info_bar_set_revealed (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_INFO_BAR_MESSAGE_TYPE_PROPERTY:
		components_info_bar_set_message_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

