/* conversation-email.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-email.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2016,2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <webkit2/webkit2.h>

#define CONVERSATION_EMAIL_MANUAL_READ_CLASS "geary-manual-read"
#define CONVERSATION_EMAIL_SENT_CLASS "geary-sent"
#define CONVERSATION_EMAIL_STARRED_CLASS "geary-starred"
#define CONVERSATION_EMAIL_UNREAD_CLASS "geary-unread"
#define CONVERSATION_EMAIL_REQUIRED_FOR_CONSTRUCT ((GEARY_EMAIL_FIELD_ENVELOPE | GEARY_EMAIL_FIELD_PREVIEW) | GEARY_EMAIL_FIELD_FLAGS)
#define CONVERSATION_EMAIL_REQUIRED_FOR_LOAD (CONVERSATION_EMAIL_REQUIRED_FOR_CONSTRUCT | GEARY_EMAIL_REQUIRED_FOR_MESSAGE)
#define CONVERSATION_EMAIL_BODY_LOAD_TIMEOUT_MSEC 250
#define CONVERSATION_LIST_BOX_EMAIL_ACTION_GROUP_NAME "eml"
#define CONVERSATION_LIST_BOX_ACTION_MARK_UNREAD "mark-unread"
#define CONVERSATION_LIST_BOX_ACTION_MARK_UNREAD_DOWN "mark-unread-down"
#define CONVERSATION_LIST_BOX_ACTION_MARK_READ "mark-read"
#define CONVERSATION_LIST_BOX_ACTION_MARK_LOAD_REMOTE "mark-load-remote"

enum  {
	CONVERSATION_EMAIL_0_PROPERTY,
	CONVERSATION_EMAIL_EMAIL_PROPERTY,
	CONVERSATION_EMAIL_IS_UNREAD_PROPERTY,
	CONVERSATION_EMAIL_IS_STARRED_PROPERTY,
	CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY,
	CONVERSATION_EMAIL_IS_DRAFT_PROPERTY,
	CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY,
	CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY,
	CONVERSATION_EMAIL_ATTACHED_MESSAGES_PROPERTY,
	CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY,
	CONVERSATION_EMAIL_NUM_PROPERTIES
};
static GParamSpec* conversation_email_properties[CONVERSATION_EMAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConversationEmailLoadContactsData ConversationEmailLoadContactsData;
typedef struct _ConversationEmailLoadBodyData ConversationEmailLoadBodyData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ConversationEmailGetSelectionForQuotingData ConversationEmailGetSelectionForQuotingData;
typedef struct _ConversationEmailGetSelectionForFindData ConversationEmailGetSelectionForFindData;
typedef struct _Block79Data Block79Data;
typedef struct _Block80Data Block80Data;

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;

#define COMPOSER_TYPE_APPLICATION_INTERFACE (composer_application_interface_get_type ())
#define COMPOSER_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface))
#define COMPOSER_IS_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE))
#define COMPOSER_APPLICATION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterfaceIface))

typedef struct _ComposerApplicationInterface ComposerApplicationInterface;
typedef struct _ComposerApplicationInterfaceIface ComposerApplicationInterfaceIface;

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;
typedef struct _ConversationEmailViewSourceData ConversationEmailViewSourceData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ConversationEmailPrintData ConversationEmailPrintData;

#define CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR (conversation_email_message_view_iterator_get_type ())
#define CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator))
#define CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIteratorClass))
#define CONVERSATION_EMAIL_IS_MESSAGE_VIEW_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR))
#define CONVERSATION_EMAIL_IS_MESSAGE_VIEW_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR))
#define CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIteratorClass))

typedef struct _ConversationEmailMessageViewIterator ConversationEmailMessageViewIterator;
typedef struct _ConversationEmailMessageViewIteratorClass ConversationEmailMessageViewIteratorClass;
typedef struct _Block81Data Block81Data;
typedef struct _ConversationEmailFetchRemoteBodyData ConversationEmailFetchRemoteBodyData;
typedef struct _ConversationEmailUpdateBodyData ConversationEmailUpdateBodyData;
typedef struct _Block82Data Block82Data;
typedef struct _ConversationEmailMessageViewIteratorPrivate ConversationEmailMessageViewIteratorPrivate;
enum  {
	CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_0_PROPERTY,
	CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_READ_ONLY_PROPERTY,
	CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_VALID_PROPERTY,
	CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* conversation_email_message_view_iterator_properties[CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_NUM_PROPERTIES];
enum  {
	CONVERSATION_EMAIL_INTERNAL_LINK_ACTIVATED_SIGNAL,
	CONVERSATION_EMAIL_BODY_SELECTION_CHANGED_SIGNAL,
	CONVERSATION_EMAIL_NUM_SIGNALS
};
static guint conversation_email_signals[CONVERSATION_EMAIL_NUM_SIGNALS] = {0};

struct _ConversationEmailPrivate {
	GearyEmail* _email;
	gboolean _is_draft;
	ConversationMessage* _primary_message;
	ComponentsAttachmentPane* _attachments_pane;
	GeeList* _attached_messages;
	ConversationEmailLoadState _message_body_state;
	GearyAppEmailStore* email_store;
	ApplicationContactStore* contacts;
	GCancellable* load_cancellable;
	ApplicationConfiguration* config;
	GearyTimeoutManager* body_loading_timeout;
	GearyNonblockingSpinlock* message_bodies_loaded_lock;
	ConversationMessage* body_selection_message;
	GeeList* displayed_attachments;
	gboolean shift_handler_installed;
	GtkGrid* actions;
	GtkButton* attachments_button;
	GtkButton* star_button;
	GtkButton* unstar_button;
	GtkMenuButton* email_menubutton;
	GtkGrid* sub_messages;
};

struct _ConversationEmailLoadContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	ConversationMessage* _tmp0_;
	GCancellable* _tmp1_;
	GError* err;
	GearyRFC822MailboxAddress* from;
	ConversationMessage* _tmp2_;
	GearyRFC822MailboxAddress* _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	GearyRFC822MailboxAddress* _tmp5_;
	gchar* _tmp6_;
	GearyRFC822MailboxAddress* _tmp7_;
	GearyRFC822MailboxAddress* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GCancellable* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _ConversationEmailLoadBodyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	gboolean loaded;
	GearyEmail* _tmp0_;
	GearyEmailField _tmp1_;
	GearyEmailField _tmp2_;
	GearyTimeoutManager* _tmp3_;
	GearyEmail* _tmp4_;
	GearyAppEmailStore* _tmp5_;
	GearyEmail* _tmp6_;
	GearyEmailIdentifier* _tmp7_;
	GearyEmailIdentifier* _tmp8_;
	GCancellable* _tmp9_;
	GearyEmail* _tmp10_;
	GearyTimeoutManager* _tmp11_;
	GError* err;
	GearyTimeoutManager* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _vala1_err;
	GearyTimeoutManager* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	GError* _vala2_err;
	GearyTimeoutManager* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _vala3_err;
	GearyTimeoutManager* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	GError* _tmp25_;
	GearyNonblockingSpinlock* _tmp26_;
	GCancellable* _tmp27_;
	GError* _inner_error0_;
};

struct _ConversationEmailGetSelectionForQuotingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	gchar* result;
	gchar* selection;
	ConversationMessage* _tmp0_;
	gchar* _tmp1_;
	ConversationMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _ConversationEmailGetSelectionForFindData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	gchar* result;
	gchar* selection;
	ConversationMessage* _tmp0_;
	gchar* _tmp1_;
	ConversationMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _Block79Data {
	int _ref_count_;
	ConversationEmail* self;
	ApplicationMainWindow* main;
	gpointer _async_data_;
};

struct _Block80Data {
	int _ref_count_;
	Block79Data * _data79_;
	GearyEmail* email;
};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

struct _ComposerApplicationInterfaceIface {
	GTypeInterface parent_iface;
	void (*report_problem) (ComposerApplicationInterface* self, GearyProblemReport* report);
	void (*send_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*send_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*save_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*discard_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*discard_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
};

struct _ConversationEmailViewSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	Block79Data* _data79_;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	Block80Data* _data80_;
	GearyEmail* _tmp3_;
	GearyEmail* _tmp4_;
	GearyNonblockingConcurrent* _tmp5_;
	GearyNonblockingConcurrent* _tmp6_;
	GError* _error_;
	ApplicationMainWindow* _tmp7_;
	ApplicationClient* _tmp8_;
	ApplicationClient* _tmp9_;
	ApplicationController* _tmp10_;
	ApplicationController* _tmp11_;
	GError* _tmp12_;
	GearyProblemReport* _tmp13_;
	GearyProblemReport* _tmp14_;
	GError* _inner_error0_;
};

struct _ConversationEmailPrintData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	JsonBuilder* builder;
	JsonBuilder* _tmp0_;
	JsonBuilder* _tmp1_;
	GearyEmail* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyRFC822MailboxAddresses* _tmp4_;
	JsonBuilder* _tmp5_;
	JsonBuilder* _tmp6_;
	GearyEmail* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	GearyRFC822MailboxAddresses* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GearyEmail* _tmp12_;
	GearyRFC822MailboxAddresses* _tmp13_;
	GearyRFC822MailboxAddresses* _tmp14_;
	JsonBuilder* _tmp15_;
	JsonBuilder* _tmp16_;
	GearyEmail* _tmp17_;
	GearyRFC822MailboxAddresses* _tmp18_;
	GearyRFC822MailboxAddresses* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GearyEmail* _tmp22_;
	GearyRFC822MailboxAddresses* _tmp23_;
	GearyRFC822MailboxAddresses* _tmp24_;
	JsonBuilder* _tmp25_;
	JsonBuilder* _tmp26_;
	GearyEmail* _tmp27_;
	GearyRFC822MailboxAddresses* _tmp28_;
	GearyRFC822MailboxAddresses* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GearyEmail* _tmp32_;
	GearyRFC822MailboxAddresses* _tmp33_;
	GearyRFC822MailboxAddresses* _tmp34_;
	JsonBuilder* _tmp35_;
	JsonBuilder* _tmp36_;
	GearyEmail* _tmp37_;
	GearyRFC822MailboxAddresses* _tmp38_;
	GearyRFC822MailboxAddresses* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GearyEmail* _tmp42_;
	GearyRFC822Date* _tmp43_;
	GearyRFC822Date* _tmp44_;
	JsonBuilder* _tmp45_;
	JsonBuilder* _tmp46_;
	GearyEmail* _tmp47_;
	GearyRFC822Date* _tmp48_;
	GearyRFC822Date* _tmp49_;
	GDateTime* _tmp50_;
	GDateTime* _tmp51_;
	GDateTime* _tmp52_;
	GDateTime* _tmp53_;
	ApplicationConfiguration* _tmp54_;
	UtilDateClockFormat _tmp55_;
	UtilDateClockFormat _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GearyEmail* _tmp59_;
	GearyRFC822Subject* _tmp60_;
	GearyRFC822Subject* _tmp61_;
	JsonBuilder* _tmp62_;
	JsonBuilder* _tmp63_;
	GearyEmail* _tmp64_;
	GearyRFC822Subject* _tmp65_;
	GearyRFC822Subject* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	JsonBuilder* _tmp69_;
	JsonGenerator* generator;
	JsonGenerator* _tmp70_;
	JsonBuilder* _tmp71_;
	JsonNode* _tmp72_;
	JsonNode* _tmp73_;
	gchar* js;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	ConversationMessage* _tmp80_;
	GtkWindow* window;
	GtkWidget* _tmp81_;
	GtkWindow* _tmp82_;
	WebKitPrintOperation* op;
	ConversationMessage* _tmp83_;
	WebKitPrintOperation* _tmp84_;
	GtkPrintSettings* settings;
	GtkPrintSettings* _tmp85_;
	gchar* download_dir;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	GtkPrintSettings* _tmp89_;
	const gchar* _tmp90_;
	GearyEmail* _tmp91_;
	GearyRFC822Subject* _tmp92_;
	GearyRFC822Subject* _tmp93_;
	gchar* file_name;
	GearyEmail* _tmp94_;
	GearyRFC822Subject* _tmp95_;
	GearyRFC822Subject* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	const gchar* _tmp102_;
	const gchar* _tmp103_;
	gchar* _tmp104_;
	const gchar* _tmp105_;
	GtkPrintSettings* _tmp106_;
	const gchar* _tmp107_;
	WebKitPrintOperation* _tmp108_;
	GtkPrintSettings* _tmp109_;
	WebKitPrintOperation* _tmp110_;
	GtkWindow* _tmp111_;
	GError* _inner_error0_;
};

struct _Block81Data {
	int _ref_count_;
	ConversationEmail* self;
	ConversationMessage* view;
};

struct _ConversationEmailFetchRemoteBodyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	GearyTimeoutManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GearyTimeoutManager* _tmp3_;
	GearyEmail* loaded;
	GearyEmail* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GearyEmail* _tmp7_;
	GearyAppEmailStore* _tmp8_;
	GearyEmail* _tmp9_;
	GearyEmailIdentifier* _tmp10_;
	GearyEmailIdentifier* _tmp11_;
	GCancellable* _tmp12_;
	GearyEmail* _tmp13_;
	GearyEmail* _tmp14_;
	GError* err;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GearyTimeoutManager* _tmp18_;
	gboolean _tmp19_;
	GearyEmail* _tmp20_;
	GCancellable* _tmp21_;
	GearyEmail* _tmp22_;
	GError* _vala1_err;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GearyTimeoutManager* _tmp26_;
	GError* _inner_error0_;
};

struct _ConversationEmailUpdateBodyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationEmail* self;
	GearyRFC822Message* message;
	GearyEmail* _tmp0_;
	GearyRFC822Message* _tmp1_;
	GeeMap* cid_resources;
	GeeHashMap* _tmp2_;
	GeeList* _attachment_list;
	GearyEmail* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	gint _attachment_size;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _attachment_index;
	gint _tmp9_;
	gint _tmp10_;
	GearyAttachment* attachment;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GeeList* _tmp13_;
	GearyAttachment* _tmp14_;
	GearyAttachment* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GearyMemoryFileBuffer* _tmp18_;
	GearyAttachment* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GearyMemoryFileBuffer* _tmp22_;
	GeeMap* _tmp23_;
	GearyAttachment* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* err;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GtkButton* _tmp29_;
	GeeList* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	ConversationMessage* _tmp33_;
	GeeMap* _tmp34_;
	ConversationMessage* _tmp35_;
	GearyRFC822Message* _tmp36_;
	GCancellable* _tmp37_;
	GeeList* sub_messages;
	GearyRFC822Message* _tmp38_;
	GeeList* _tmp39_;
	GeeList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	ConversationMessage* _tmp43_;
	GtkGrid* _tmp44_;
	GtkGrid* _tmp45_;
	GtkGrid* _tmp46_;
	GeeList* _sub_message_list;
	GeeList* _tmp47_;
	gint _sub_message_size;
	GeeList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _sub_message_index;
	gint _tmp51_;
	gint _tmp52_;
	GearyRFC822Message* sub_message;
	GeeList* _tmp53_;
	gpointer _tmp54_;
	ConversationMessage* attached_message;
	GearyRFC822Message* _tmp55_;
	GearyEmail* _tmp56_;
	ApplicationContactStore* _tmp57_;
	ApplicationConfiguration* _tmp58_;
	ConversationMessage* _tmp59_;
	ConversationMessage* _tmp60_;
	ConversationMessage* _tmp61_;
	GeeMap* _tmp62_;
	GtkGrid* _tmp63_;
	ConversationMessage* _tmp64_;
	GeeList* _tmp65_;
	ConversationMessage* _tmp66_;
	ConversationMessage* _tmp67_;
	GCancellable* _tmp68_;
	ConversationMessage* _tmp69_;
	GearyRFC822Message* _tmp70_;
	GCancellable* _tmp71_;
	ConversationMessage* _tmp72_;
	GError* _inner_error0_;
};

struct _Block82Data {
	int _ref_count_;
	ConversationEmail* self;
	gchar** blacklist;
	gint blacklist_length1;
	gint _blacklist_size_;
	gboolean show_trash;
	gboolean show_delete;
	GVariant* email_target;
};

struct _ConversationEmailMessageViewIterator {
	GearyBaseObject parent_instance;
	ConversationEmailMessageViewIteratorPrivate * priv;
};

struct _ConversationEmailMessageViewIteratorClass {
	GearyBaseObjectClass parent_class;
};

struct _ConversationEmailMessageViewIteratorPrivate {
	ConversationEmail* parent_view;
	gint pos;
	GeeIterator* attached_views;
};

static gint ConversationEmail_private_offset;
static gpointer conversation_email_parent_class = NULL;
static GMenuModel* conversation_email_email_menu_template;
static GMenuModel* conversation_email_email_menu_template = NULL;
static GMenuModel* conversation_email_email_menu_trash_section;
static GMenuModel* conversation_email_email_menu_trash_section = NULL;
static GMenuModel* conversation_email_email_menu_delete_section;
static GMenuModel* conversation_email_email_menu_delete_section = NULL;
static gint ConversationEmailMessageViewIterator_private_offset;
static gpointer conversation_email_message_view_iterator_parent_class = NULL;
static GeeTraversableIface * conversation_email_message_view_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * conversation_email_message_view_iterator_gee_iterator_parent_iface = NULL;
static GearyBaseInterfaceIface * conversation_email_geary_base_interface_parent_iface = NULL;

static void conversation_email_set_email (ConversationEmail* self,
                                   GearyEmail* value);
static void conversation_email_set_is_draft (ConversationEmail* self,
                                      gboolean value);
static void conversation_email_set_primary_message (ConversationEmail* self,
                                             ConversationMessage* value);
static void conversation_email_set_attachments_pane (ConversationEmail* self,
                                              ComponentsAttachmentPane* value);
static void conversation_email_set_message_body_state (ConversationEmail* self,
                                                ConversationEmailLoadState value);
VALA_EXTERN GtkGrid* conversation_message_get_summary (ConversationMessage* self);
static void conversation_email_connect_message_view_signals (ConversationEmail* self,
                                                      ConversationMessage* view);
static void conversation_email_on_service_status_change (ConversationEmail* self);
static void _conversation_email_on_service_status_change_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void conversation_email_on_load_cancelled (ConversationEmail* self);
static void _conversation_email_on_load_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                                    gpointer self);
static void conversation_email_on_body_loading_timeout (ConversationEmail* self);
static void _conversation_email_on_body_loading_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                     gpointer self);
static void conversation_email_update_email_state (ConversationEmail* self);
static void conversation_email_load_contacts_data_free (gpointer _data);
static gboolean conversation_email_load_contacts_co (ConversationEmailLoadContactsData* _data_);
static void conversation_email_load_contacts_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN GearyRFC822MailboxAddress* conversation_message_get_primary_originator (ConversationMessage* self);
static void conversation_email_load_body_data_free (gpointer _data);
static gboolean conversation_email_load_body_co (ConversationEmailLoadBodyData* _data_);
static void conversation_email_load_body_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void conversation_email_fetch_remote_body (ConversationEmail* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void conversation_email_fetch_remote_body_finish (ConversationEmail* self,
                                                  GAsyncResult* _res_);
static void conversation_email_handle_load_failure (ConversationEmail* self,
                                             GError* _error_);
static void conversation_email_update_body (ConversationEmail* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void conversation_email_update_body_finish (ConversationEmail* self,
                                            GAsyncResult* _res_,
                                            GError** error);
VALA_EXTERN GeeIterator* conversation_email_iterator (ConversationEmail* self);
static void conversation_email_get_selection_for_quoting_data_free (gpointer _data);
static gboolean conversation_email_get_selection_for_quoting_co (ConversationEmailGetSelectionForQuotingData* _data_);
static void conversation_email_get_selection_for_quoting_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void conversation_email_get_selection_for_find_data_free (gpointer _data);
static gboolean conversation_email_get_selection_for_find_co (ConversationEmailGetSelectionForFindData* _data_);
static void conversation_email_get_selection_for_find_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void conversation_email_view_source_data_free (gpointer _data);
static gboolean conversation_email_view_source_co (ConversationEmailViewSourceData* _data_);
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
static Block80Data* block80_data_ref (Block80Data* _data80_);
static void block80_data_unref (void * _userdata_);
static void ____lambda126_ (Block80Data* _data80_,
                     GError** error);
static void _____lambda126__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                       gpointer self,
                                                                       GError** error);
static void conversation_email_view_source_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType composer_application_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void composer_application_interface_report_problem (ComposerApplicationInterface* self,
                                                    GearyProblemReport* report);
static void conversation_email_print_data_free (gpointer _data);
static gboolean conversation_email_print_co (ConversationEmailPrintData* _data_);
static void _vala_JsonNode_free (JsonNode* self);
static void conversation_email_print_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static ConversationEmailMessageViewIterator* conversation_email_message_view_iterator_new (ConversationEmail* parent_view);
static ConversationEmailMessageViewIterator* conversation_email_message_view_iterator_construct (GType object_type,
                                                                                          ConversationEmail* parent_view);
static GType conversation_email_message_view_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block81Data* block81_data_ref (Block81Data* _data81_);
static void block81_data_unref (void * _userdata_);
static void conversation_email_on_content_loaded (ConversationEmail* self);
static void _conversation_email_on_content_loaded_conversation_message_content_loaded (ConversationMessage* _sender,
                                                                                gpointer self);
static void conversation_email_on_flag_remote_images (ConversationEmail* self);
static void _conversation_email_on_flag_remote_images_conversation_message_flag_remote_images (ConversationMessage* _sender,
                                                                                        gpointer self);
static void __lambda123_ (ConversationEmail* self,
                   gint y);
static void ___lambda123__conversation_message_internal_link_activated (ConversationMessage* _sender,
                                                                 gint y,
                                                                 gpointer self);
static void conversation_email_on_resource_loaded (ConversationEmail* self,
                                            const gchar* id);
static void _conversation_email_on_resource_loaded_conversation_message_internal_resource_loaded (ConversationMessage* _sender,
                                                                                           const gchar* name,
                                                                                           gpointer self);
static void conversation_email_on_save_image (ConversationEmail* self,
                                       const gchar* uri,
                                       const gchar* alt_text,
                                       GearyMemoryBuffer* content);
static void _conversation_email_on_save_image_conversation_message_save_image (ConversationMessage* _sender,
                                                                        const gchar* uri,
                                                                        const gchar* alt_text,
                                                                        GearyMemoryBuffer* buffer,
                                                                        gpointer self);
static void __lambda124_ (Block81Data* _data81_,
                   gboolean has_selection);
static void ___lambda124__conversation_message_selection_changed (ConversationMessage* _sender,
                                                           gboolean has_selection,
                                                           gpointer self);
static void conversation_email_fetch_remote_body_data_free (gpointer _data);
static gboolean conversation_email_fetch_remote_body_co (ConversationEmailFetchRemoteBodyData* _data_);
static inline gboolean conversation_email_is_online (ConversationEmail* self);
static void conversation_email_fetch_remote_body_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void conversation_email_handle_load_offline (ConversationEmail* self);
static void conversation_email_update_body_data_free (gpointer _data);
static gboolean conversation_email_update_body_co (ConversationEmailUpdateBodyData* _data_);
static void conversation_email_update_body_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN GtkGrid* conversation_message_get_body_container (ConversationMessage* self);
static void conversation_email_update_email_menu (ConversationEmail* self);
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
VALA_EXTERN gboolean application_controller_does_folder_support_trash (GearyFolder* target);
static void conversation_email_on_shift_changed (ConversationEmail* self);
static void _conversation_email_on_shift_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean ___lambda125_ (Block82Data* _data82_,
                        GMenuModel* menu,
                        GMenuModel* submenu,
                        const gchar* action,
                        GMenuItem* item);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean ____lambda125__util_gtk_menu_visitor (GMenuModel* existing_menu,
                                               GMenuModel* existing_child_menu,
                                               const gchar* existing_action,
                                               GMenuItem* new_item,
                                               gpointer self);
static void conversation_email_update_displayed_attachments (ConversationEmail* self);
static void conversation_email_activate_email_action (ConversationEmail* self,
                                               const gchar* name);
static void conversation_email_on_email_menu (ConversationEmail* self);
static void _conversation_email_on_email_menu_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
VALA_EXTERN gboolean conversation_message_get_is_content_loaded (ConversationMessage* self);
static gboolean conversation_email_message_view_iterator_real_next (GeeIterator* base);
static gboolean conversation_email_message_view_iterator_real_has_next (GeeIterator* base);
static ConversationMessage* conversation_email_message_view_iterator_real_get (GeeIterator* base);
static void conversation_email_message_view_iterator_real_remove (GeeIterator* base);
static gboolean conversation_email_message_view_iterator_real_foreach (GeeTraversable* base,
                                                                GeeForallFunc f,
                                                                gpointer f_target);
static void conversation_email_message_view_iterator_finalize (GObject * obj);
static GType conversation_email_message_view_iterator_get_type_once (void);
static void _vala_conversation_email_message_view_iterator_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void conversation_email_finalize (GObject * obj);
static GType conversation_email_get_type_once (void);
static void _vala_conversation_email_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_conversation_email_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
conversation_email_get_instance_private (ConversationEmail* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationEmail_private_offset);
}

/** Specifies the loading state for a message part. */
static GType
conversation_email_load_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CONVERSATION_EMAIL_LOAD_STATE_NOT_STARTED, "CONVERSATION_EMAIL_LOAD_STATE_NOT_STARTED", "not-started"}, {CONVERSATION_EMAIL_LOAD_STATE_STARTED, "CONVERSATION_EMAIL_LOAD_STATE_STARTED", "started"}, {CONVERSATION_EMAIL_LOAD_STATE_COMPLETED, "CONVERSATION_EMAIL_LOAD_STATE_COMPLETED", "completed"}, {CONVERSATION_EMAIL_LOAD_STATE_FAILED, "CONVERSATION_EMAIL_LOAD_STATE_FAILED", "failed"}, {0, NULL, NULL}};
	GType conversation_email_load_state_type_id;
	conversation_email_load_state_type_id = g_enum_register_static ("ConversationEmailLoadState", values);
	return conversation_email_load_state_type_id;
}

GType
conversation_email_load_state_get_type (void)
{
	static volatile gsize conversation_email_load_state_type_id__once = 0;
	if (g_once_init_enter (&conversation_email_load_state_type_id__once)) {
		GType conversation_email_load_state_type_id;
		conversation_email_load_state_type_id = conversation_email_load_state_get_type_once ();
		g_once_init_leave (&conversation_email_load_state_type_id__once, conversation_email_load_state_type_id);
	}
	return conversation_email_load_state_type_id__once;
}

GearyEmail*
conversation_email_get_email (ConversationEmail* self)
{
	GearyEmail* result;
	GearyEmail* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), NULL);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
conversation_email_set_email (ConversationEmail* self,
                              GearyEmail* value)
{
	GearyEmail* old_value;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	old_value = conversation_email_get_email (self);
	if (old_value != value) {
		GearyEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_EMAIL_PROPERTY]);
	}
}

gboolean
conversation_email_get_is_unread (ConversationEmail* self)
{
	gboolean result;
	GearyEmailFlags* flags = NULL;
	GearyEmail* _tmp0_;
	GearyEmailFlags* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GearyEmailFlags* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyEmailFlags* _tmp5_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), FALSE);
	_tmp0_ = self->priv->_email;
	_tmp1_ = geary_email_get_email_flags (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	flags = _tmp3_;
	_tmp5_ = flags;
	if (_tmp5_ != NULL) {
		GearyEmailFlags* _tmp6_;
		_tmp6_ = flags;
		_tmp4_ = geary_email_flags_is_unread (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	_g_object_unref0 (flags);
	return result;
}

gboolean
conversation_email_get_is_starred (ConversationEmail* self)
{
	gboolean result;
	GearyEmailFlags* flags = NULL;
	GearyEmail* _tmp0_;
	GearyEmailFlags* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GearyEmailFlags* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyEmailFlags* _tmp5_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), FALSE);
	_tmp0_ = self->priv->_email;
	_tmp1_ = geary_email_get_email_flags (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	flags = _tmp3_;
	_tmp5_ = flags;
	if (_tmp5_ != NULL) {
		GearyEmailFlags* _tmp6_;
		_tmp6_ = flags;
		_tmp4_ = geary_email_flags_is_flagged (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	_g_object_unref0 (flags);
	return result;
}

gboolean
conversation_email_get_is_manually_read (ConversationEmail* self)
{
	gboolean result;
	GtkStyleContext* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = gtk_style_context_has_class (_tmp0_, CONVERSATION_EMAIL_MANUAL_READ_CLASS);
	return result;
}

void
conversation_email_set_is_manually_read (ConversationEmail* self,
                                         gboolean value)
{
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	if (value) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp0_, CONVERSATION_EMAIL_MANUAL_READ_CLASS);
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp1_, CONVERSATION_EMAIL_MANUAL_READ_CLASS);
	}
	g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY]);
}

gboolean
conversation_email_get_is_draft (ConversationEmail* self)
{
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), FALSE);
	result = self->priv->_is_draft;
	return result;
}

static void
conversation_email_set_is_draft (ConversationEmail* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	old_value = conversation_email_get_is_draft (self);
	if (old_value != value) {
		self->priv->_is_draft = value;
		g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_IS_DRAFT_PROPERTY]);
	}
}

ConversationMessage*
conversation_email_get_primary_message (ConversationEmail* self)
{
	ConversationMessage* result;
	ConversationMessage* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), NULL);
	_tmp0_ = self->priv->_primary_message;
	result = _tmp0_;
	return result;
}

static void
conversation_email_set_primary_message (ConversationEmail* self,
                                        ConversationMessage* value)
{
	ConversationMessage* old_value;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	old_value = conversation_email_get_primary_message (self);
	if (old_value != value) {
		ConversationMessage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_message);
		self->priv->_primary_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY]);
	}
}

ComponentsAttachmentPane*
conversation_email_get_attachments_pane (ConversationEmail* self)
{
	ComponentsAttachmentPane* result;
	ComponentsAttachmentPane* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), NULL);
	_tmp0_ = self->priv->_attachments_pane;
	result = _tmp0_;
	return result;
}

static void
conversation_email_set_attachments_pane (ConversationEmail* self,
                                         ComponentsAttachmentPane* value)
{
	ComponentsAttachmentPane* old_value;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	old_value = conversation_email_get_attachments_pane (self);
	if (old_value != value) {
		ComponentsAttachmentPane* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attachments_pane);
		self->priv->_attachments_pane = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY]);
	}
}

GeeList*
conversation_email_get_attached_messages (ConversationEmail* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), NULL);
	_tmp0_ = self->priv->_attached_messages;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ConversationEmailLoadState
conversation_email_get_message_body_state (ConversationEmail* self)
{
	ConversationEmailLoadState result;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), 0);
	result = self->priv->_message_body_state;
	return result;
}

static void
conversation_email_set_message_body_state (ConversationEmail* self,
                                           ConversationEmailLoadState value)
{
	ConversationEmailLoadState old_value;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	old_value = conversation_email_get_message_body_state (self);
	if (old_value != value) {
		self->priv->_message_body_state = value;
		g_object_notify_by_pspec ((GObject *) self, conversation_email_properties[CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY]);
	}
}

/**
     * Constructs a new view to display an email.
     *
     * This method sets up most of the user interface for displaying
     * the complete email, but does not attempt any possibly
     * long-running loading processes.
     */
static void
_conversation_email_on_service_status_change_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	conversation_email_on_service_status_change ((ConversationEmail*) self);
}

static void
_conversation_email_on_load_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                               gpointer self)
{
	conversation_email_on_load_cancelled ((ConversationEmail*) self);
}

static void
_conversation_email_on_body_loading_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                gpointer self)
{
	conversation_email_on_body_loading_timeout ((ConversationEmail*) self);
}

ConversationEmail*
conversation_email_construct (GType object_type,
                              GearyAppConversation* conversation,
                              GearyEmail* email,
                              GearyAppEmailStore* email_store,
                              ApplicationContactStore* contacts,
                              ApplicationConfiguration* config,
                              gboolean is_sent,
                              gboolean is_draft,
                              GCancellable* load_cancellable)
{
	ConversationEmail * self = NULL;
	GearyAppConversation* _tmp0_;
	GearyAppEmailStore* _tmp1_;
	ApplicationContactStore* _tmp2_;
	ApplicationConfiguration* _tmp3_;
	GCancellable* _tmp4_;
	GearyNonblockingSpinlock* _tmp5_;
	ApplicationContactStore* _tmp7_;
	ApplicationConfiguration* _tmp8_;
	ConversationMessage* _tmp9_;
	ConversationMessage* _tmp10_;
	ConversationMessage* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	ConversationMessage* _tmp15_;
	GearyAccount* _tmp16_;
	GearyAccount* _tmp17_;
	GearyClientService* _tmp18_;
	GearyClientService* _tmp19_;
	GCancellable* _tmp20_;
	GearyTimeoutManager* _tmp21_;
	ConversationMessage* _tmp22_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_store, GEARY_APP_TYPE_EMAIL_STORE), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (contacts), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (load_cancellable, g_cancellable_get_type ()), NULL);
	self = (ConversationEmail*) g_object_new (object_type, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_tmp0_ = _g_object_ref0 (conversation);
	_g_object_unref0 (self->conversation);
	self->conversation = _tmp0_;
	conversation_email_set_email (self, email);
	conversation_email_set_is_draft (self, is_draft);
	_tmp1_ = _g_object_ref0 (email_store);
	_g_object_unref0 (self->priv->email_store);
	self->priv->email_store = _tmp1_;
	_tmp2_ = _g_object_ref0 (contacts);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp2_;
	_tmp3_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp3_;
	_tmp4_ = _g_object_ref0 (load_cancellable);
	_g_object_unref0 (self->priv->load_cancellable);
	self->priv->load_cancellable = _tmp4_;
	_tmp5_ = geary_nonblocking_spinlock_new (load_cancellable);
	_g_object_unref0 (self->priv->message_bodies_loaded_lock);
	self->priv->message_bodies_loaded_lock = _tmp5_;
	if (is_sent) {
		GtkStyleContext* _tmp6_;
		_tmp6_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp6_, CONVERSATION_EMAIL_SENT_CLASS);
	}
	_tmp7_ = self->priv->contacts;
	_tmp8_ = self->priv->config;
	_tmp9_ = conversation_message_new_from_email (email, geary_trillian_is_certain (geary_email_load_remote_images (email)), _tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	conversation_email_set_primary_message (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->_primary_message;
	_tmp12_ = conversation_message_get_summary (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->actions;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->_primary_message;
	conversation_email_connect_message_view_signals (self, _tmp15_);
	_tmp16_ = geary_app_email_store_get_account (email_store);
	_tmp17_ = _tmp16_;
	_tmp18_ = geary_account_get_incoming (_tmp17_);
	_tmp19_ = _tmp18_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, G_TYPE_OBJECT, GObject), "notify::current-status", (GCallback) _conversation_email_on_service_status_change_g_object_notify, self, 0);
	_tmp20_ = self->priv->load_cancellable;
	g_signal_connect_object (_tmp20_, "cancelled", (GCallback) _conversation_email_on_load_cancelled_g_cancellable_cancelled, self, 0);
	_tmp21_ = geary_timeout_manager_new_milliseconds ((guint) CONVERSATION_EMAIL_BODY_LOAD_TIMEOUT_MSEC, _conversation_email_on_body_loading_timeout_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->body_loading_timeout);
	self->priv->body_loading_timeout = _tmp21_;
	_tmp22_ = self->priv->_primary_message;
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	conversation_email_update_email_state (self);
	return self;
}

ConversationEmail*
conversation_email_new (GearyAppConversation* conversation,
                        GearyEmail* email,
                        GearyAppEmailStore* email_store,
                        ApplicationContactStore* contacts,
                        ApplicationConfiguration* config,
                        gboolean is_sent,
                        gboolean is_draft,
                        GCancellable* load_cancellable)
{
	return conversation_email_construct (TYPE_CONVERSATION_EMAIL, conversation, email, email_store, contacts, config, is_sent, is_draft, load_cancellable);
}

static void
conversation_email_load_contacts_data_free (gpointer _data)
{
	ConversationEmailLoadContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailLoadContactsData, _data_);
}

void
conversation_email_load_contacts (ConversationEmail* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ConversationEmailLoadContactsData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailLoadContactsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_load_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_load_contacts_co (_data_);
}

void
conversation_email_load_contacts_finish (ConversationEmail* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	ConversationEmailLoadContactsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Loads the contacts for the primary message.
     */
static void
conversation_email_load_contacts_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ConversationEmailLoadContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_load_contacts_co (_data_);
}

static gboolean
conversation_email_load_contacts_co (ConversationEmailLoadContactsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_primary_message;
		_data_->_tmp1_ = _data_->self->priv->load_cancellable;
		_data_->_state_ = 1;
		conversation_message_load_contacts (_data_->_tmp0_, _data_->_tmp1_, conversation_email_load_contacts_ready, _data_);
		return FALSE;
		_state_1:
		conversation_message_load_contacts_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->_primary_message;
		_data_->_tmp3_ = conversation_message_get_primary_originator (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_data_->from = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->from;
		if (_data_->_tmp7_ != NULL) {
			_data_->_tmp8_ = _data_->from;
			_data_->_tmp9_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp6_ = _data_->_tmp9_;
		} else {
			_data_->_tmp10_ = g_strdup ("<unknown>");
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp6_ = _data_->_tmp10_;
		}
		_data_->_tmp11_ = _data_->err;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_debug ("conversation-email.vala:333: Contact load failed for \"%s\": %s", _data_->_tmp6_, _data_->_tmp12_);
		_g_free0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->from);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->self->priv->load_cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp13_)) {
		_data_->_tmp14_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Contact load was cancelled");
		_data_->_inner_error0_ = _data_->_tmp14_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_load_body_data_free (gpointer _data)
{
	ConversationEmailLoadBodyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailLoadBodyData, _data_);
}

void
conversation_email_load_body (ConversationEmail* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ConversationEmailLoadBodyData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailLoadBodyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_load_body_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_load_body_co (_data_);
}

void
conversation_email_load_body_finish (ConversationEmail* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	ConversationEmailLoadBodyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Loads the message body and attachments.
     *
     * This potentially hits the database if the email that the view
     * was constructed from doesn't satisfy requirements, loads
     * attachments, including views and avatars for any attached
     * messages, and waits for the primary message body content to
     * have been loaded by its web view before returning.
     */
static void
conversation_email_load_body_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	ConversationEmailLoadBodyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_load_body_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
conversation_email_load_body_co (ConversationEmailLoadBodyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	conversation_email_set_message_body_state (_data_->self, CONVERSATION_EMAIL_LOAD_STATE_STARTED);
	_data_->_tmp0_ = _data_->self->priv->_email;
	_data_->_tmp1_ = geary_email_get_fields (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->loaded = geary_email_field_fulfills (_data_->_tmp2_, CONVERSATION_EMAIL_REQUIRED_FOR_LOAD);
	if (!_data_->loaded) {
		_data_->_tmp3_ = _data_->self->priv->body_loading_timeout;
		geary_timeout_manager_start (_data_->_tmp3_);
		{
			_data_->_tmp5_ = _data_->self->priv->email_store;
			_data_->_tmp6_ = _data_->self->priv->_email;
			_data_->_tmp7_ = geary_email_get_id (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = _data_->self->priv->load_cancellable;
			_data_->_state_ = 1;
			geary_app_email_store_fetch_email_async (_data_->_tmp5_, _data_->_tmp8_, CONVERSATION_EMAIL_REQUIRED_FOR_LOAD, GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY, _data_->_tmp9_, conversation_email_load_body_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp10_ = geary_app_email_store_fetch_email_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp4_ = _data_->_tmp10_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_INCOMPLETE_MESSAGE)) {
					goto __catch0_geary_engine_error_incomplete_message;
				}
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch0_g_io_error_cancelled;
				}
				goto __catch0_g_error;
			}
			conversation_email_set_email (_data_->self, _data_->_tmp4_);
			_data_->loaded = TRUE;
			_data_->_tmp11_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_reset (_data_->_tmp11_);
			_g_object_unref0 (_data_->_tmp4_);
		}
		goto __finally0;
		__catch0_geary_engine_error_incomplete_message:
		{
			g_clear_error (&_data_->_inner_error0_);
			conversation_email_fetch_remote_body (_data_->self, NULL, NULL);
		}
		goto __finally0;
		__catch0_g_io_error_cancelled:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_reset (_data_->_tmp12_);
			_data_->_tmp13_ = _data_->err;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp15_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_reset (_data_->_tmp15_);
			_data_->_tmp16_ = _data_->_vala1_err;
			conversation_email_handle_load_failure (_data_->self, _data_->_tmp16_);
			_data_->_tmp17_ = _data_->_vala1_err;
			_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
			_data_->_inner_error0_ = _data_->_tmp18_;
			_g_error_free0 (_data_->_vala1_err);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->loaded) {
		{
			_data_->_state_ = 2;
			conversation_email_update_body (_data_->self, conversation_email_load_body_ready, _data_);
			return FALSE;
			_state_2:
			conversation_email_update_body_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch1_g_io_error_cancelled;
				}
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_io_error_cancelled:
		{
			_data_->_vala2_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp19_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_reset (_data_->_tmp19_);
			_data_->_tmp20_ = _data_->_vala2_err;
			_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
			_data_->_inner_error0_ = _data_->_tmp21_;
			_g_error_free0 (_data_->_vala2_err);
			goto __finally1;
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala3_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp22_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_reset (_data_->_tmp22_);
			_data_->_tmp23_ = _data_->_vala3_err;
			conversation_email_handle_load_failure (_data_->self, _data_->_tmp23_);
			_data_->_tmp24_ = _data_->_vala3_err;
			_data_->_tmp25_ = _g_error_copy0 (_data_->_tmp24_);
			_data_->_inner_error0_ = _data_->_tmp25_;
			_g_error_free0 (_data_->_vala3_err);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp26_ = _data_->self->priv->message_bodies_loaded_lock;
		_data_->_tmp27_ = _data_->self->priv->load_cancellable;
		_data_->_state_ = 3;
		geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_tmp27_, conversation_email_load_body_ready, _data_);
		return FALSE;
		_state_3:
		geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Shows the complete message: headers, body and attachments.
     */
void
conversation_email_expand_email (ConversationEmail* self,
                                 gboolean include_transitions)
{
	GtkButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GVariant* email_target = NULL;
	GearyEmail* _tmp4_;
	GearyEmailIdentifier* _tmp5_;
	GearyEmailIdentifier* _tmp6_;
	GVariant* _tmp7_;
	GtkButton* _tmp8_;
	GVariant* _tmp9_;
	GtkButton* _tmp10_;
	GVariant* _tmp11_;
	GtkButton* _tmp12_;
	GVariant* _tmp13_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	self->is_collapsed = FALSE;
	conversation_email_update_email_state (self);
	_tmp0_ = self->priv->attachments_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp1_ = self->priv->email_menubutton;
	_tmp2_ = g_menu_new ();
	_tmp3_ = _tmp2_;
	gtk_menu_button_set_menu_model (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_email;
	_tmp5_ = geary_email_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_email_identifier_to_variant (_tmp6_);
	email_target = _tmp7_;
	_tmp8_ = self->priv->attachments_button;
	_tmp9_ = email_target;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_actionable_get_type (), GtkActionable), _tmp9_);
	_tmp10_ = self->priv->star_button;
	_tmp11_ = email_target;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_actionable_get_type (), GtkActionable), _tmp11_);
	_tmp12_ = self->priv->unstar_button;
	_tmp13_ = email_target;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_actionable_get_type (), GtkActionable), _tmp13_);
	{
		GeeIterator* _message_it = NULL;
		GeeIterator* _tmp14_;
		_tmp14_ = conversation_email_iterator (self);
		_message_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			ConversationMessage* message = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			ConversationMessage* _tmp18_;
			_tmp15_ = _message_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _message_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			message = (ConversationMessage*) _tmp17_;
			_tmp18_ = message;
			conversation_message_show_message_body (_tmp18_, include_transitions);
			_g_object_unref0 (message);
		}
		_g_object_unref0 (_message_it);
	}
	_g_variant_unref0 (email_target);
}

/**
     * Hides the complete message, just showing the header preview.
     */
void
conversation_email_collapse_email (ConversationEmail* self)
{
	GtkButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	ConversationMessage* _tmp5_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	self->is_collapsed = TRUE;
	conversation_email_update_email_state (self);
	_tmp0_ = self->priv->attachments_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->email_menubutton;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->attachments_button;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_actionable_get_type (), GtkActionable), NULL);
	_tmp3_ = self->priv->star_button;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_actionable_get_type (), GtkActionable), NULL);
	_tmp4_ = self->priv->unstar_button;
	gtk_actionable_set_action_target_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_actionable_get_type (), GtkActionable), NULL);
	_tmp5_ = self->priv->_primary_message;
	conversation_message_hide_message_body (_tmp5_);
	{
		GeeList* _attached_list = NULL;
		GeeList* _tmp6_;
		gint _attached_size = 0;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _attached_index = 0;
		_tmp6_ = self->priv->_attached_messages;
		_attached_list = _tmp6_;
		_tmp7_ = _attached_list;
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		_attached_size = _tmp9_;
		_attached_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ConversationMessage* attached = NULL;
			GeeList* _tmp12_;
			gpointer _tmp13_;
			ConversationMessage* _tmp14_;
			_attached_index = _attached_index + 1;
			_tmp10_ = _attached_index;
			_tmp11_ = _attached_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _attached_list;
			_tmp13_ = gee_list_get (_tmp12_, _attached_index);
			attached = (ConversationMessage*) _tmp13_;
			_tmp14_ = attached;
			conversation_message_hide_message_body (_tmp14_);
			_g_object_unref0 (attached);
		}
	}
}

/**
     * Updates the current email's flags and dependent UI state.
     */
void
conversation_email_update_flags (ConversationEmail* self,
                                 GearyEmail* email)
{
	GearyEmail* _tmp0_;
	GearyEmailFlags* _tmp1_;
	GearyEmailFlags* _tmp2_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->_email;
	_tmp1_ = geary_email_get_email_flags (email);
	_tmp2_ = _tmp1_;
	geary_email_set_flags (_tmp0_, _tmp2_);
	conversation_email_update_email_state (self);
}

static void
conversation_email_get_selection_for_quoting_data_free (gpointer _data)
{
	ConversationEmailGetSelectionForQuotingData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailGetSelectionForQuotingData, _data_);
}

void
conversation_email_get_selection_for_quoting (ConversationEmail* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ConversationEmailGetSelectionForQuotingData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailGetSelectionForQuotingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_get_selection_for_quoting_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_get_selection_for_quoting_co (_data_);
}

gchar*
conversation_email_get_selection_for_quoting_finish (ConversationEmail* self,
                                                     GAsyncResult* _res_)
{
	gchar* result;
	ConversationEmailGetSelectionForQuotingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns user-selected body HTML from a message, if any.
     */
static void
conversation_email_get_selection_for_quoting_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	ConversationEmailGetSelectionForQuotingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_get_selection_for_quoting_co (_data_);
}

static gboolean
conversation_email_get_selection_for_quoting_co (ConversationEmailGetSelectionForQuotingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->selection = NULL;
	_data_->_tmp0_ = _data_->self->priv->body_selection_message;
	if (_data_->_tmp0_ != NULL) {
		{
			_data_->_tmp2_ = _data_->self->priv->body_selection_message;
			_data_->_state_ = 1;
			conversation_message_get_selection_for_quoting (_data_->_tmp2_, conversation_email_get_selection_for_quoting_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = conversation_message_get_selection_for_quoting_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_free0 (_data_->selection);
			_data_->selection = _data_->_tmp4_;
			_g_free0 (_data_->_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = _data_->err;
			_data_->_tmp6_ = _data_->_tmp5_->message;
			g_debug ("conversation-email.vala:461: Failed to get selection for quoting: %s", _data_->_tmp6_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->selection);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->selection;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_get_selection_for_find_data_free (gpointer _data)
{
	ConversationEmailGetSelectionForFindData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailGetSelectionForFindData, _data_);
}

void
conversation_email_get_selection_for_find (ConversationEmail* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ConversationEmailGetSelectionForFindData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailGetSelectionForFindData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_get_selection_for_find_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_get_selection_for_find_co (_data_);
}

gchar*
conversation_email_get_selection_for_find_finish (ConversationEmail* self,
                                                  GAsyncResult* _res_)
{
	gchar* result;
	ConversationEmailGetSelectionForFindData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns user-selected body text from a message, if any.
     */
static void
conversation_email_get_selection_for_find_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	ConversationEmailGetSelectionForFindData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_get_selection_for_find_co (_data_);
}

static gboolean
conversation_email_get_selection_for_find_co (ConversationEmailGetSelectionForFindData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->selection = NULL;
	_data_->_tmp0_ = _data_->self->priv->body_selection_message;
	if (_data_->_tmp0_ != NULL) {
		{
			_data_->_tmp2_ = _data_->self->priv->body_selection_message;
			_data_->_state_ = 1;
			conversation_message_get_selection_for_find (_data_->_tmp2_, conversation_email_get_selection_for_find_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = conversation_message_get_selection_for_find_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_free0 (_data_->selection);
			_data_->selection = _data_->_tmp4_;
			_g_free0 (_data_->_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = _data_->err;
			_data_->_tmp6_ = _data_->_tmp5_->message;
			g_debug ("conversation-email.vala:477: Failed to get selection for find: %s", _data_->_tmp6_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->selection);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->selection;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_view_source_data_free (gpointer _data)
{
	ConversationEmailViewSourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailViewSourceData, _data_);
}

void
conversation_email_view_source (ConversationEmail* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ConversationEmailViewSourceData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailViewSourceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_view_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_view_source_co (_data_);
}

void
conversation_email_view_source_finish (ConversationEmail* self,
                                       GAsyncResult* _res_)
{
	ConversationEmailViewSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Displays the raw RFC 822 source for this email. */
static Block79Data*
block79_data_ref (Block79Data* _data79_)
{
	g_atomic_int_inc (&_data79_->_ref_count_);
	return _data79_;
}

static void
block79_data_unref (void * _userdata_)
{
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
		ConversationEmail* self;
		self = _data79_->self;
		_g_object_unref0 (_data79_->main);
		_g_object_unref0 (self);
		g_slice_free (Block79Data, _data79_);
	}
}

static Block80Data*
block80_data_ref (Block80Data* _data80_)
{
	g_atomic_int_inc (&_data80_->_ref_count_);
	return _data80_;
}

static void
block80_data_unref (void * _userdata_)
{
	Block80Data* _data80_;
	_data80_ = (Block80Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data80_->_ref_count_)) {
		ConversationEmail* self;
		self = _data80_->_data79_->self;
		_g_object_unref0 (_data80_->email);
		block79_data_unref (_data80_->_data79_);
		_data80_->_data79_ = NULL;
		g_slice_free (Block80Data, _data80_);
	}
}

static void
____lambda126_ (Block80Data* _data80_,
                GError** error)
{
	Block79Data* _data79_;
	ConversationEmail* self;
	gchar* source = NULL;
	GearyEmail* _tmp0_;
	GearyRFC822Header* _tmp1_;
	GearyRFC822Header* _tmp2_;
	GearyMemoryBuffer* _tmp3_;
	GearyMemoryBuffer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GearyEmail* _tmp7_;
	GearyRFC822Text* _tmp8_;
	GearyRFC822Text* _tmp9_;
	GearyMemoryBuffer* _tmp10_;
	GearyMemoryBuffer* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* temporary_filename = NULL;
	gint temporary_handle = 0;
	gchar* _tmp16_ = NULL;
	gint _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* temporary_uri = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	ApplicationMainWindow* _tmp23_;
	ApplicationClient* _tmp24_;
	ApplicationClient* _tmp25_;
	const gchar* _tmp26_;
	GError* _inner_error0_ = NULL;
	_data79_ = _data80_->_data79_;
	self = _data79_->self;
	_tmp0_ = _data80_->email;
	_tmp1_ = geary_email_get_header (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_memory_buffer_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _data80_->email;
	_tmp8_ = geary_email_get_body (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_memory_buffer_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp6_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp6_);
	source = _tmp15_;
	_tmp17_ = g_file_open_tmp ("geary-message-XXXXXX.txt", &_tmp16_, &_inner_error0_);
	_g_free0 (temporary_filename);
	temporary_filename = _tmp16_;
	temporary_handle = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (temporary_filename);
		_g_free0 (source);
		return;
	}
	_tmp18_ = temporary_filename;
	_tmp19_ = source;
	g_file_set_contents (_tmp18_, _tmp19_, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (temporary_filename);
		_g_free0 (source);
		return;
	}
	close (temporary_handle);
	_tmp20_ = temporary_filename;
	g_chmod (_tmp20_, (gint) (S_IRUSR | S_IWUSR));
	_tmp21_ = temporary_filename;
	_tmp22_ = g_filename_to_uri (_tmp21_, NULL, &_inner_error0_);
	temporary_uri = _tmp22_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (temporary_filename);
		_g_free0 (source);
		return;
	}
	_tmp23_ = _data79_->main;
	_tmp24_ = application_main_window_get_application (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = temporary_uri;
	application_client_show_uri (_tmp25_, _tmp26_, NULL, NULL);
	_g_free0 (temporary_uri);
	_g_free0 (temporary_filename);
	_g_free0 (source);
}

static void
_____lambda126__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                  gpointer self,
                                                                  GError** error)
{
	____lambda126_ (self, error);
}

static void
conversation_email_view_source_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ConversationEmailViewSourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_view_source_co (_data_);
}

static gboolean
conversation_email_view_source_co (ConversationEmailViewSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data79_ = g_slice_new0 (Block79Data);
	_data_->_data79_->_ref_count_ = 1;
	_data_->_data79_->self = g_object_ref (_data_->self);
	_data_->_data79_->_async_data_ = _data_;
	_data_->_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_data_->_tmp0_) ? ((ApplicationMainWindow*) _data_->_tmp0_) : NULL);
	_data_->_data79_->main = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->_data79_->main;
	if (_data_->_tmp2_ != NULL) {
		_data_->_data80_ = g_slice_new0 (Block80Data);
		_data_->_data80_->_ref_count_ = 1;
		_data_->_data80_->_data79_ = block79_data_ref (_data_->_data79_);
		_data_->_tmp3_ = _data_->self->priv->_email;
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
		_data_->_data80_->email = _data_->_tmp4_;
		{
			_data_->_tmp5_ = geary_nonblocking_concurrent_get_global ();
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_state_ = 1;
			geary_nonblocking_concurrent_schedule_async (_data_->_tmp6_, _____lambda126__geary_nonblocking_concurrent_concurrent_callback, _data_->_data80_, NULL, conversation_email_view_source_ready, _data_);
			return FALSE;
			_state_1:
			geary_nonblocking_concurrent_schedule_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->_data79_->main;
			_data_->_tmp8_ = application_main_window_get_application (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = application_client_get_controller (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->_error_;
			_data_->_tmp13_ = geary_problem_report_new (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), _data_->_tmp14_);
			_g_object_unref0 (_data_->_tmp14_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block80_data_unref (_data_->_data80_);
			_data_->_data80_ = NULL;
			block79_data_unref (_data_->_data79_);
			_data_->_data79_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		block80_data_unref (_data_->_data80_);
		_data_->_data80_ = NULL;
	}
	block79_data_unref (_data_->_data79_);
	_data_->_data79_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_print_data_free (gpointer _data)
{
	ConversationEmailPrintData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailPrintData, _data_);
}

void
conversation_email_print (ConversationEmail* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	ConversationEmailPrintData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailPrintData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_print_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_print_co (_data_);
}

void
conversation_email_print_finish (ConversationEmail* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	ConversationEmailPrintData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Print this view's email. */
static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
conversation_email_print_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	ConversationEmailPrintData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_print_co (_data_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
conversation_email_print_co (ConversationEmailPrintData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = json_builder_new ();
	_data_->builder = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->builder;
	json_builder_begin_object (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_email;
	_data_->_tmp3_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp5_, _ ("From:"));
		_data_->_tmp6_ = _data_->builder;
		_data_->_tmp7_ = _data_->self->priv->_email;
		_data_->_tmp8_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp11_ = _data_->_tmp10_;
		json_builder_add_string_value (_data_->_tmp6_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp11_);
	}
	_data_->_tmp12_ = _data_->self->priv->_email;
	_data_->_tmp13_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp14_ = _data_->_tmp13_;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp15_, _ ("To:"));
		_data_->_tmp16_ = _data_->builder;
		_data_->_tmp17_ = _data_->self->priv->_email;
		_data_->_tmp18_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp21_ = _data_->_tmp20_;
		json_builder_add_string_value (_data_->_tmp16_, _data_->_tmp21_);
		_g_free0 (_data_->_tmp21_);
	}
	_data_->_tmp22_ = _data_->self->priv->_email;
	_data_->_tmp23_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp24_ = _data_->_tmp23_;
	if (_data_->_tmp24_ != NULL) {
		_data_->_tmp25_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp25_, _ ("Cc:"));
		_data_->_tmp26_ = _data_->builder;
		_data_->_tmp27_ = _data_->self->priv->_email;
		_data_->_tmp28_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp31_ = _data_->_tmp30_;
		json_builder_add_string_value (_data_->_tmp26_, _data_->_tmp31_);
		_g_free0 (_data_->_tmp31_);
	}
	_data_->_tmp32_ = _data_->self->priv->_email;
	_data_->_tmp33_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp34_ = _data_->_tmp33_;
	if (_data_->_tmp34_ != NULL) {
		_data_->_tmp35_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp35_, _ ("Bcc:"));
		_data_->_tmp36_ = _data_->builder;
		_data_->_tmp37_ = _data_->self->priv->_email;
		_data_->_tmp38_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp41_ = _data_->_tmp40_;
		json_builder_add_string_value (_data_->_tmp36_, _data_->_tmp41_);
		_g_free0 (_data_->_tmp41_);
	}
	_data_->_tmp42_ = _data_->self->priv->_email;
	_data_->_tmp43_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp44_ = _data_->_tmp43_;
	if (_data_->_tmp44_ != NULL) {
		_data_->_tmp45_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp45_, _ ("Date:"));
		_data_->_tmp46_ = _data_->builder;
		_data_->_tmp47_ = _data_->self->priv->_email;
		_data_->_tmp48_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp47_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = geary_rf_c822_date_get_value (_data_->_tmp49_);
		_data_->_tmp51_ = _data_->_tmp50_;
		_data_->_tmp52_ = g_date_time_to_local (_data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		_data_->_tmp54_ = _data_->self->priv->config;
		_data_->_tmp55_ = application_configuration_get_clock_format (_data_->_tmp54_);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = util_date_pretty_print_verbose (_data_->_tmp53_, _data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		json_builder_add_string_value (_data_->_tmp46_, _data_->_tmp58_);
		_g_free0 (_data_->_tmp58_);
		_g_date_time_unref0 (_data_->_tmp53_);
	}
	_data_->_tmp59_ = _data_->self->priv->_email;
	_data_->_tmp60_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp59_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp61_ = _data_->_tmp60_;
	if (_data_->_tmp61_ != NULL) {
		_data_->_tmp62_ = _data_->builder;
		json_builder_set_member_name (_data_->_tmp62_, _ ("Subject:"));
		_data_->_tmp63_ = _data_->builder;
		_data_->_tmp64_ = _data_->self->priv->_email;
		_data_->_tmp65_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp64_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp66_ = _data_->_tmp65_;
		_data_->_tmp67_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp66_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp68_ = _data_->_tmp67_;
		json_builder_add_string_value (_data_->_tmp63_, _data_->_tmp68_);
		_g_free0 (_data_->_tmp68_);
	}
	_data_->_tmp69_ = _data_->builder;
	json_builder_end_object (_data_->_tmp69_);
	_data_->_tmp70_ = json_generator_new ();
	_data_->generator = _data_->_tmp70_;
	_data_->_tmp71_ = _data_->builder;
	_data_->_tmp72_ = json_builder_get_root (_data_->_tmp71_);
	_data_->_tmp73_ = _data_->_tmp72_;
	json_generator_set_root (_data_->generator, _data_->_tmp73_);
	__vala_JsonNode_free0 (_data_->_tmp73_);
	_data_->_tmp74_ = json_generator_to_data (_data_->generator, NULL);
	_data_->_tmp75_ = _data_->_tmp74_;
	_data_->_tmp76_ = g_strconcat ("geary.addPrintHeaders(", _data_->_tmp75_, NULL);
	_data_->_tmp77_ = _data_->_tmp76_;
	_data_->_tmp78_ = g_strconcat (_data_->_tmp77_, ");", NULL);
	_data_->_tmp79_ = _data_->_tmp78_;
	_g_free0 (_data_->_tmp77_);
	_g_free0 (_data_->_tmp75_);
	_data_->js = _data_->_tmp79_;
	_data_->_tmp80_ = _data_->self->priv->_primary_message;
	_data_->_state_ = 1;
	conversation_message_run_javascript (_data_->_tmp80_, _data_->js, NULL, conversation_email_print_ready, _data_);
	return FALSE;
	_state_1:
	conversation_message_run_javascript_finish (_data_->_tmp80_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->js);
		_g_object_unref0 (_data_->generator);
		_g_object_unref0 (_data_->builder);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp81_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp81_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp81_) : NULL);
	_data_->window = _data_->_tmp82_;
	_data_->_tmp83_ = _data_->self->priv->_primary_message;
	_data_->_tmp84_ = conversation_message_new_print_operation (_data_->_tmp83_);
	_data_->op = _data_->_tmp84_;
	_data_->_tmp85_ = gtk_print_settings_new ();
	_data_->settings = _data_->_tmp85_;
	_data_->_tmp86_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_data_->_tmp87_ = g_strdup (_data_->_tmp86_);
	_data_->download_dir = _data_->_tmp87_;
	_data_->_tmp88_ = _data_->download_dir;
	if (!geary_string_is_empty_or_whitespace (_data_->_tmp88_)) {
		_data_->_tmp89_ = _data_->settings;
		_data_->_tmp90_ = _data_->download_dir;
		gtk_print_settings_set (_data_->_tmp89_, GTK_PRINT_SETTINGS_OUTPUT_DIR, _data_->_tmp90_);
	}
	_data_->_tmp91_ = _data_->self->priv->_email;
	_data_->_tmp92_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp91_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp93_ = _data_->_tmp92_;
	if (_data_->_tmp93_ != NULL) {
		_data_->_tmp94_ = _data_->self->priv->_email;
		_data_->_tmp95_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp94_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp96_ = _data_->_tmp95_;
		_data_->_tmp97_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp96_, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_data_->_tmp98_ = _data_->_tmp97_;
		_data_->_tmp99_ = geary_string_reduce_whitespace (_data_->_tmp98_);
		_data_->file_name = _data_->_tmp99_;
		_data_->_tmp100_ = _data_->file_name;
		_data_->_tmp101_ = string_replace (_data_->_tmp100_, "/", "_");
		_g_free0 (_data_->file_name);
		_data_->file_name = _data_->_tmp101_;
		_data_->_tmp102_ = _data_->file_name;
		if (g_utf8_strlen (_data_->_tmp102_, (gssize) -1) > 128) {
			_data_->_tmp103_ = _data_->file_name;
			_data_->_tmp104_ = geary_string_safe_byte_substring (_data_->_tmp103_, (gssize) 128);
			_g_free0 (_data_->file_name);
			_data_->file_name = _data_->_tmp104_;
		}
		_data_->_tmp105_ = _data_->file_name;
		if (!geary_string_is_empty (_data_->_tmp105_)) {
			_data_->_tmp106_ = _data_->settings;
			_data_->_tmp107_ = _data_->file_name;
			gtk_print_settings_set (_data_->_tmp106_, GTK_PRINT_SETTINGS_OUTPUT_BASENAME, _data_->_tmp107_);
		}
		_g_free0 (_data_->file_name);
	}
	_data_->_tmp108_ = _data_->op;
	_data_->_tmp109_ = _data_->settings;
	webkit_print_operation_set_print_settings (_data_->_tmp108_, _data_->_tmp109_);
	_data_->_tmp110_ = _data_->op;
	_data_->_tmp111_ = _data_->window;
	webkit_print_operation_run_dialog (_data_->_tmp110_, _data_->_tmp111_);
	_g_free0 (_data_->download_dir);
	_g_object_unref0 (_data_->settings);
	_g_object_unref0 (_data_->op);
	_g_object_unref0 (_data_->window);
	_g_free0 (_data_->js);
	_g_object_unref0 (_data_->generator);
	_g_object_unref0 (_data_->builder);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Returns a new Iterable over all message views in this email view
     */
GeeIterator*
conversation_email_iterator (ConversationEmail* self)
{
	ConversationEmailMessageViewIterator* _tmp0_;
	GeeIterator* result;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), NULL);
	_tmp0_ = conversation_email_message_view_iterator_new (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERATOR, GeeIterator);
	return result;
}

static Block81Data*
block81_data_ref (Block81Data* _data81_)
{
	g_atomic_int_inc (&_data81_->_ref_count_);
	return _data81_;
}

static void
block81_data_unref (void * _userdata_)
{
	Block81Data* _data81_;
	_data81_ = (Block81Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data81_->_ref_count_)) {
		ConversationEmail* self;
		self = _data81_->self;
		_g_object_unref0 (_data81_->view);
		_g_object_unref0 (self);
		g_slice_free (Block81Data, _data81_);
	}
}

static void
_conversation_email_on_content_loaded_conversation_message_content_loaded (ConversationMessage* _sender,
                                                                           gpointer self)
{
	conversation_email_on_content_loaded ((ConversationEmail*) self);
}

static void
_conversation_email_on_flag_remote_images_conversation_message_flag_remote_images (ConversationMessage* _sender,
                                                                                   gpointer self)
{
	conversation_email_on_flag_remote_images ((ConversationEmail*) self);
}

static void
__lambda123_ (ConversationEmail* self,
              gint y)
{
	g_signal_emit (self, conversation_email_signals[CONVERSATION_EMAIL_INTERNAL_LINK_ACTIVATED_SIGNAL], 0, y);
}

static void
___lambda123__conversation_message_internal_link_activated (ConversationMessage* _sender,
                                                            gint y,
                                                            gpointer self)
{
	__lambda123_ ((ConversationEmail*) self, y);
}

static void
_conversation_email_on_resource_loaded_conversation_message_internal_resource_loaded (ConversationMessage* _sender,
                                                                                      const gchar* name,
                                                                                      gpointer self)
{
	conversation_email_on_resource_loaded ((ConversationEmail*) self, name);
}

static void
_conversation_email_on_save_image_conversation_message_save_image (ConversationMessage* _sender,
                                                                   const gchar* uri,
                                                                   const gchar* alt_text,
                                                                   GearyMemoryBuffer* buffer,
                                                                   gpointer self)
{
	conversation_email_on_save_image ((ConversationEmail*) self, uri, alt_text, buffer);
}

static void
__lambda124_ (Block81Data* _data81_,
              gboolean has_selection)
{
	ConversationEmail* self;
	ConversationMessage* _tmp0_ = NULL;
	ConversationMessage* _tmp1_;
	self = _data81_->self;
	if (has_selection) {
		_tmp0_ = _data81_->view;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->body_selection_message);
	self->priv->body_selection_message = _tmp1_;
	g_signal_emit (self, conversation_email_signals[CONVERSATION_EMAIL_BODY_SELECTION_CHANGED_SIGNAL], 0, has_selection);
}

static void
___lambda124__conversation_message_selection_changed (ConversationMessage* _sender,
                                                      gboolean has_selection,
                                                      gpointer self)
{
	__lambda124_ (self, has_selection);
}

static void
conversation_email_connect_message_view_signals (ConversationEmail* self,
                                                 ConversationMessage* view)
{
	Block81Data* _data81_;
	ConversationMessage* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (IS_CONVERSATION_MESSAGE (view));
	_data81_ = g_slice_new0 (Block81Data);
	_data81_->_ref_count_ = 1;
	_data81_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (view);
	_g_object_unref0 (_data81_->view);
	_data81_->view = _tmp0_;
	g_signal_connect_object (_data81_->view, "content-loaded", (GCallback) _conversation_email_on_content_loaded_conversation_message_content_loaded, self, 0);
	g_signal_connect_object (_data81_->view, "flag-remote-images", (GCallback) _conversation_email_on_flag_remote_images_conversation_message_flag_remote_images, self, 0);
	g_signal_connect_object (_data81_->view, "internal-link-activated", (GCallback) ___lambda123__conversation_message_internal_link_activated, self, 0);
	g_signal_connect_object (_data81_->view, "internal-resource-loaded", (GCallback) _conversation_email_on_resource_loaded_conversation_message_internal_resource_loaded, self, 0);
	g_signal_connect_object (_data81_->view, "save-image", (GCallback) _conversation_email_on_save_image_conversation_message_save_image, self, 0);
	g_signal_connect_data (_data81_->view, "selection-changed", (GCallback) ___lambda124__conversation_message_selection_changed, block81_data_ref (_data81_), (GClosureNotify) block81_data_unref, 0);
	block81_data_unref (_data81_);
	_data81_ = NULL;
}

static void
conversation_email_fetch_remote_body_data_free (gpointer _data)
{
	ConversationEmailFetchRemoteBodyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailFetchRemoteBodyData, _data_);
}

static void
conversation_email_fetch_remote_body (ConversationEmail* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ConversationEmailFetchRemoteBodyData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailFetchRemoteBodyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_fetch_remote_body_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_fetch_remote_body_co (_data_);
}

static void
conversation_email_fetch_remote_body_finish (ConversationEmail* self,
                                             GAsyncResult* _res_)
{
	ConversationEmailFetchRemoteBodyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_email_fetch_remote_body_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ConversationEmailFetchRemoteBodyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_fetch_remote_body_co (_data_);
}

static gboolean
conversation_email_fetch_remote_body_co (ConversationEmailFetchRemoteBodyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (conversation_email_is_online (_data_->self)) {
		_data_->_tmp0_ = _data_->self->priv->body_loading_timeout;
		_data_->_tmp1_ = geary_timeout_manager_get_is_running (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (!_data_->_tmp2_) {
			_data_->_tmp3_ = _data_->self->priv->body_loading_timeout;
			geary_timeout_manager_start (_data_->_tmp3_);
		}
		_data_->loaded = NULL;
		{
			_data_->_tmp4_ = _data_->self->priv->_email;
			_data_->_tmp5_ = geary_email_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			g_debug ("conversation-email.vala:630: Downloading remote message: %s", _data_->_tmp6_);
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->self->priv->email_store;
			_data_->_tmp9_ = _data_->self->priv->_email;
			_data_->_tmp10_ = geary_email_get_id (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->self->priv->load_cancellable;
			_data_->_state_ = 1;
			geary_app_email_store_fetch_email_async (_data_->_tmp8_, _data_->_tmp11_, CONVERSATION_EMAIL_REQUIRED_FOR_LOAD, GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE, _data_->_tmp12_, conversation_email_fetch_remote_body_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp13_ = geary_app_email_store_fetch_email_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp7_ = _data_->_tmp13_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch0_g_io_error_cancelled;
				}
				goto __catch0_g_error;
			}
			_data_->_tmp14_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_object_unref0 (_data_->loaded);
			_data_->loaded = _data_->_tmp14_;
			_g_object_unref0 (_data_->_tmp7_);
		}
		goto __finally0;
		__catch0_g_io_error_cancelled:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp15_ = _data_->err;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_debug ("conversation-email.vala:640: Remote message download failed: %s", _data_->_tmp16_);
			_data_->_tmp17_ = _data_->err;
			conversation_email_handle_load_failure (_data_->self, _data_->_tmp17_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->loaded);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp18_ = _data_->self->priv->body_loading_timeout;
		geary_timeout_manager_reset (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->loaded;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = _data_->self->priv->load_cancellable;
			_data_->_tmp19_ = !g_cancellable_is_cancelled (_data_->_tmp21_);
		} else {
			_data_->_tmp19_ = FALSE;
		}
		if (_data_->_tmp19_) {
			{
				_data_->_tmp22_ = _data_->loaded;
				conversation_email_set_email (_data_->self, _data_->_tmp22_);
				_data_->_state_ = 2;
				conversation_email_update_body (_data_->self, conversation_email_fetch_remote_body_ready, _data_);
				return FALSE;
				_state_2:
				conversation_email_update_body_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
						goto __catch1_g_io_error_cancelled;
					}
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_io_error_cancelled:
			{
				g_clear_error (&_data_->_inner_error0_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp23_ = _data_->_vala1_err;
				_data_->_tmp24_ = _data_->_tmp23_->message;
				g_debug ("conversation-email.vala:653: Remote message update failed: %s", _data_->_tmp24_);
				_data_->_tmp25_ = _data_->_vala1_err;
				conversation_email_handle_load_failure (_data_->self, _data_->_tmp25_);
				_g_error_free0 (_data_->_vala1_err);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->loaded);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->loaded);
	} else {
		_data_->_tmp26_ = _data_->self->priv->body_loading_timeout;
		geary_timeout_manager_reset (_data_->_tmp26_);
		conversation_email_handle_load_offline (_data_->self);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_update_body_data_free (gpointer _data)
{
	ConversationEmailUpdateBodyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationEmailUpdateBodyData, _data_);
}

static void
conversation_email_update_body (ConversationEmail* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ConversationEmailUpdateBodyData* _data_;
	ConversationEmail* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_data_ = g_slice_new0 (ConversationEmailUpdateBodyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_email_update_body_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_email_update_body_co (_data_);
}

static void
conversation_email_update_body_finish (ConversationEmail* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	ConversationEmailUpdateBodyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
conversation_email_update_body_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ConversationEmailUpdateBodyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_email_update_body_co (_data_);
}

static gboolean
conversation_email_update_body_co (ConversationEmailUpdateBodyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_email;
	_data_->_tmp1_ = geary_email_get_message (_data_->_tmp0_, &_data_->_inner_error0_);
	_data_->message = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->cid_resources = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_MAP, GeeMap);
	{
		_data_->_tmp3_ = _data_->self->priv->_email;
		_data_->_tmp4_ = geary_email_get_attachments (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_attachment_list = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->_attachment_list;
		_data_->_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_attachment_size = _data_->_tmp8_;
		_data_->_attachment_index = -1;
		while (TRUE) {
			_data_->_attachment_index = _data_->_attachment_index + 1;
			_data_->_tmp9_ = _data_->_attachment_index;
			_data_->_tmp10_ = _data_->_attachment_size;
			if (!(_data_->_tmp9_ < _data_->_tmp10_)) {
				break;
			}
			_data_->_tmp11_ = _data_->_attachment_list;
			_data_->_tmp12_ = gee_list_get (_data_->_tmp11_, _data_->_attachment_index);
			_data_->attachment = (GearyAttachment*) _data_->_tmp12_;
			_data_->_tmp13_ = _data_->self->priv->displayed_attachments;
			_data_->_tmp14_ = _data_->attachment;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp14_);
			_data_->_tmp15_ = _data_->attachment;
			_data_->_tmp16_ = geary_attachment_get_content_id (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			if (_data_->_tmp17_ != NULL) {
				{
					_data_->_tmp19_ = _data_->attachment;
					_data_->_tmp20_ = geary_attachment_get_file (_data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->_tmp22_ = geary_memory_file_buffer_new (_data_->_tmp21_, TRUE, &_data_->_inner_error0_);
					_data_->_tmp18_ = _data_->_tmp22_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp23_ = _data_->cid_resources;
					_data_->_tmp24_ = _data_->attachment;
					_data_->_tmp25_ = geary_attachment_get_content_id (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					gee_map_set (_data_->_tmp23_, _data_->_tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
					_g_object_unref0 (_data_->_tmp18_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->err = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp27_ = _data_->err;
					_data_->_tmp28_ = _data_->_tmp27_->message;
					g_debug ("conversation-email.vala:682: Could not open attachment: %s", _data_->_tmp28_);
					_g_error_free0 (_data_->err);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->attachment);
					_g_object_unref0 (_data_->cid_resources);
					_g_object_unref0 (_data_->message);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->attachment);
		}
	}
	_data_->_tmp29_ = _data_->self->priv->attachments_button;
	_data_->_tmp30_ = _data_->self->priv->displayed_attachments;
	_data_->_tmp31_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp32_ = _data_->_tmp31_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, gtk_widget_get_type (), GtkWidget), !_data_->_tmp32_);
	_data_->_tmp33_ = _data_->self->priv->_primary_message;
	_data_->_tmp34_ = _data_->cid_resources;
	conversation_message_add_internal_resources (_data_->_tmp33_, _data_->_tmp34_);
	_data_->_tmp35_ = _data_->self->priv->_primary_message;
	_data_->_tmp36_ = _data_->message;
	_data_->_tmp37_ = _data_->self->priv->load_cancellable;
	_data_->_state_ = 1;
	conversation_message_load_message_body (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_, conversation_email_update_body_ready, _data_);
	return FALSE;
	_state_1:
	conversation_message_load_message_body_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cid_resources);
		_g_object_unref0 (_data_->message);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->message;
	_data_->_tmp39_ = geary_rf_c822_message_get_sub_messages (_data_->_tmp38_, &_data_->_inner_error0_);
	_data_->sub_messages = _data_->_tmp39_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cid_resources);
		_g_object_unref0 (_data_->message);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp40_ = _data_->sub_messages;
	_data_->_tmp41_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp42_ = _data_->_tmp41_;
	if (_data_->_tmp42_ > 0) {
		_data_->_tmp43_ = _data_->self->priv->_primary_message;
		_data_->_tmp44_ = conversation_message_get_body_container (_data_->_tmp43_);
		_data_->_tmp45_ = _data_->_tmp44_;
		_data_->_tmp46_ = _data_->self->priv->sub_messages;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, gtk_widget_get_type (), GtkWidget));
	}
	{
		_data_->_tmp47_ = _data_->sub_messages;
		_data_->_sub_message_list = _data_->_tmp47_;
		_data_->_tmp48_ = _data_->_sub_message_list;
		_data_->_tmp49_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_sub_message_size = _data_->_tmp50_;
		_data_->_sub_message_index = -1;
		while (TRUE) {
			_data_->_sub_message_index = _data_->_sub_message_index + 1;
			_data_->_tmp51_ = _data_->_sub_message_index;
			_data_->_tmp52_ = _data_->_sub_message_size;
			if (!(_data_->_tmp51_ < _data_->_tmp52_)) {
				break;
			}
			_data_->_tmp53_ = _data_->_sub_message_list;
			_data_->_tmp54_ = gee_list_get (_data_->_tmp53_, _data_->_sub_message_index);
			_data_->sub_message = (GearyRFC822Message*) _data_->_tmp54_;
			_data_->_tmp55_ = _data_->sub_message;
			_data_->_tmp56_ = _data_->self->priv->_email;
			_data_->_tmp57_ = _data_->self->priv->contacts;
			_data_->_tmp58_ = _data_->self->priv->config;
			_data_->_tmp59_ = conversation_message_new_from_message (_data_->_tmp55_, geary_trillian_is_certain (geary_email_load_remote_images (_data_->_tmp56_)), _data_->_tmp57_, _data_->_tmp58_);
			g_object_ref_sink (_data_->_tmp59_);
			_data_->attached_message = _data_->_tmp59_;
			_data_->_tmp60_ = _data_->attached_message;
			conversation_email_connect_message_view_signals (_data_->self, _data_->_tmp60_);
			_data_->_tmp61_ = _data_->attached_message;
			_data_->_tmp62_ = _data_->cid_resources;
			conversation_message_add_internal_resources (_data_->_tmp61_, _data_->_tmp62_);
			_data_->_tmp63_ = _data_->self->priv->sub_messages;
			_data_->_tmp64_ = _data_->attached_message;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp63_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp64_, gtk_widget_get_type (), GtkWidget));
			_data_->_tmp65_ = _data_->self->priv->_attached_messages;
			_data_->_tmp66_ = _data_->attached_message;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp65_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp66_);
			_data_->_tmp67_ = _data_->attached_message;
			_data_->_tmp68_ = _data_->self->priv->load_cancellable;
			conversation_message_load_contacts (_data_->_tmp67_, _data_->_tmp68_, NULL, NULL);
			_data_->_tmp69_ = _data_->attached_message;
			_data_->_tmp70_ = _data_->sub_message;
			_data_->_tmp71_ = _data_->self->priv->load_cancellable;
			_data_->_state_ = 2;
			conversation_message_load_message_body (_data_->_tmp69_, _data_->_tmp70_, _data_->_tmp71_, conversation_email_update_body_ready, _data_);
			return FALSE;
			_state_2:
			conversation_message_load_message_body_finish (_data_->_tmp69_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->attached_message);
				_g_object_unref0 (_data_->sub_message);
				_g_object_unref0 (_data_->sub_messages);
				_g_object_unref0 (_data_->cid_resources);
				_g_object_unref0 (_data_->message);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (!_data_->self->is_collapsed) {
				_data_->_tmp72_ = _data_->attached_message;
				conversation_message_show_message_body (_data_->_tmp72_, FALSE);
			}
			_g_object_unref0 (_data_->attached_message);
			_g_object_unref0 (_data_->sub_message);
		}
	}
	_g_object_unref0 (_data_->sub_messages);
	_g_object_unref0 (_data_->cid_resources);
	_g_object_unref0 (_data_->message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_email_update_email_state (ConversationEmail* self)
{
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style = _tmp1_;
	_tmp2_ = conversation_email_get_is_unread (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkStyleContext* _tmp4_;
		_tmp4_ = style;
		gtk_style_context_add_class (_tmp4_, CONVERSATION_EMAIL_UNREAD_CLASS);
	} else {
		GtkStyleContext* _tmp5_;
		_tmp5_ = style;
		gtk_style_context_remove_class (_tmp5_, CONVERSATION_EMAIL_UNREAD_CLASS);
	}
	_tmp6_ = conversation_email_get_is_starred (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkStyleContext* _tmp8_;
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
		_tmp8_ = style;
		gtk_style_context_add_class (_tmp8_, CONVERSATION_EMAIL_STARRED_CLASS);
		_tmp9_ = self->priv->star_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = self->priv->unstar_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkStyleContext* _tmp11_;
		GtkButton* _tmp12_;
		GtkButton* _tmp13_;
		_tmp11_ = style;
		gtk_style_context_remove_class (_tmp11_, CONVERSATION_EMAIL_STARRED_CLASS);
		_tmp12_ = self->priv->star_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = self->priv->unstar_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	}
	conversation_email_update_email_menu (self);
	_g_object_unref0 (style);
}

static Block82Data*
block82_data_ref (Block82Data* _data82_)
{
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}

static void
block82_data_unref (void * _userdata_)
{
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		ConversationEmail* self;
		self = _data82_->self;
		_g_variant_unref0 (_data82_->email_target);
		_data82_->blacklist = (_vala_array_free (_data82_->blacklist, _data82_->blacklist_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}

static void
_conversation_email_on_shift_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	conversation_email_on_shift_changed ((ConversationEmail*) self);
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
___lambda125_ (Block82Data* _data82_,
               GMenuModel* menu,
               GMenuModel* submenu,
               const gchar* action,
               GMenuItem* item)
{
	ConversationEmail* self;
	gboolean accept = FALSE;
	gboolean _tmp0_ = FALSE;
	GMenuModel* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GMenuModel* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	self = _data82_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (menu, g_menu_model_get_type ()), FALSE);
	g_return_val_if_fail ((submenu == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (submenu, g_menu_model_get_type ()), FALSE);
	g_return_val_if_fail ((item == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (item, g_menu_item_get_type ()), FALSE);
	accept = TRUE;
	_tmp1_ = conversation_email_email_menu_trash_section;
	if (submenu == _tmp1_) {
		_tmp0_ = !_data82_->show_trash;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		accept = FALSE;
	}
	_tmp3_ = conversation_email_email_menu_delete_section;
	if (submenu == _tmp3_) {
		_tmp2_ = !_data82_->show_delete;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		accept = FALSE;
	}
	if (action != NULL) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = _data82_->blacklist;
		_tmp5__length1 = _data82_->blacklist_length1;
		_tmp4_ = !_vala_string_array_contains (_tmp5_, _tmp5__length1, action);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GVariant* _tmp6_;
		_tmp6_ = _data82_->email_target;
		g_menu_item_set_action_and_target_value (item, action, _tmp6_);
	}
	result = accept;
	return result;
}

static gboolean
____lambda125__util_gtk_menu_visitor (GMenuModel* existing_menu,
                                      GMenuModel* existing_child_menu,
                                      const gchar* existing_action,
                                      GMenuItem* new_item,
                                      gpointer self)
{
	gboolean result;
	result = ___lambda125_ (self, existing_menu, existing_child_menu, existing_action, new_item);
	return result;
}

static void
conversation_email_update_email_menu (ConversationEmail* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp0_ = self->priv->email_menubutton;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Block82Data* _data82_;
		gboolean in_base_folder = FALSE;
		GearyAppConversation* _tmp3_;
		GearyEmail* _tmp4_;
		GearyEmailIdentifier* _tmp5_;
		GearyEmailIdentifier* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean supports_trash = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean supports_delete = FALSE;
		gboolean is_shift_down = FALSE;
		ApplicationMainWindow* main = NULL;
		GtkWidget* _tmp15_;
		ApplicationMainWindow* _tmp16_;
		ApplicationMainWindow* _tmp17_;
		gchar** _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		GearyEmail* _tmp30_;
		GearyEmailIdentifier* _tmp31_;
		GearyEmailIdentifier* _tmp32_;
		GVariant* _tmp33_;
		GMenu* new_model = NULL;
		GMenuModel* _tmp34_;
		GMenu* _tmp35_;
		GtkMenuButton* _tmp36_;
		GtkPopover* _tmp37_;
		GtkPopover* _tmp38_;
		GMenu* _tmp39_;
		GtkMenuButton* _tmp40_;
		GtkPopover* _tmp41_;
		GtkPopover* _tmp42_;
		_data82_ = g_slice_new0 (Block82Data);
		_data82_->_ref_count_ = 1;
		_data82_->self = g_object_ref (self);
		_tmp3_ = self->conversation;
		_tmp4_ = self->priv->_email;
		_tmp5_ = geary_email_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		in_base_folder = geary_app_conversation_is_in_base_folder (_tmp3_, _tmp6_);
		if (in_base_folder) {
			GearyAppConversation* _tmp8_;
			GearyFolder* _tmp9_;
			GearyFolder* _tmp10_;
			_tmp8_ = self->conversation;
			_tmp9_ = geary_app_conversation_get_base_folder (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp7_ = application_controller_does_folder_support_trash (_tmp10_);
		} else {
			_tmp7_ = FALSE;
		}
		supports_trash = _tmp7_;
		if (in_base_folder) {
			GearyAppConversation* _tmp12_;
			GearyFolder* _tmp13_;
			GearyFolder* _tmp14_;
			_tmp12_ = self->conversation;
			_tmp13_ = geary_app_conversation_get_base_folder (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GEARY_FOLDER_SUPPORT_TYPE_REMOVE);
		} else {
			_tmp11_ = FALSE;
		}
		supports_delete = _tmp11_;
		is_shift_down = FALSE;
		_tmp15_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp16_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp15_) ? ((ApplicationMainWindow*) _tmp15_) : NULL);
		main = _tmp16_;
		_tmp17_ = main;
		if (_tmp17_ != NULL) {
			ApplicationMainWindow* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = main;
			_tmp19_ = application_main_window_get_is_shift_down (_tmp18_);
			_tmp20_ = _tmp19_;
			is_shift_down = _tmp20_;
			if (!self->priv->shift_handler_installed) {
				ApplicationMainWindow* _tmp21_;
				self->priv->shift_handler_installed = TRUE;
				_tmp21_ = main;
				g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, G_TYPE_OBJECT, GObject), "notify::is-shift-down", (GCallback) _conversation_email_on_shift_changed_g_object_notify, self, 0);
			}
		}
		_tmp22_ = g_new0 (gchar*, 0 + 1);
		_data82_->blacklist = _tmp22_;
		_data82_->blacklist_length1 = 0;
		_data82_->_blacklist_size_ = _data82_->blacklist_length1;
		_tmp23_ = conversation_email_get_is_unread (self);
		_tmp24_ = _tmp23_;
		if (_tmp24_) {
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = g_strdup (CONVERSATION_LIST_BOX_EMAIL_ACTION_GROUP_NAME "." CONVERSATION_LIST_BOX_ACTION_MARK_UNREAD);
			_vala_array_add18 (&_data82_->blacklist, &_data82_->blacklist_length1, &_data82_->_blacklist_size_, _tmp25_);
			_tmp26_ = g_strdup (CONVERSATION_LIST_BOX_EMAIL_ACTION_GROUP_NAME "." CONVERSATION_LIST_BOX_ACTION_MARK_UNREAD_DOWN);
			_vala_array_add19 (&_data82_->blacklist, &_data82_->blacklist_length1, &_data82_->_blacklist_size_, _tmp26_);
		} else {
			gchar* _tmp27_;
			_tmp27_ = g_strdup (CONVERSATION_LIST_BOX_EMAIL_ACTION_GROUP_NAME "." CONVERSATION_LIST_BOX_ACTION_MARK_READ);
			_vala_array_add20 (&_data82_->blacklist, &_data82_->blacklist_length1, &_data82_->_blacklist_size_, _tmp27_);
		}
		if (!is_shift_down) {
			_tmp28_ = supports_trash;
		} else {
			_tmp28_ = FALSE;
		}
		_data82_->show_trash = _tmp28_;
		if (!_data82_->show_trash) {
			_tmp29_ = supports_delete;
		} else {
			_tmp29_ = FALSE;
		}
		_data82_->show_delete = _tmp29_;
		_tmp30_ = self->priv->_email;
		_tmp31_ = geary_email_get_id (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = geary_email_identifier_to_variant (_tmp32_);
		_data82_->email_target = _tmp33_;
		_tmp34_ = conversation_email_email_menu_template;
		_tmp35_ = util_gtk_construct_menu (_tmp34_, ____lambda125__util_gtk_menu_visitor, _data82_);
		new_model = _tmp35_;
		_tmp36_ = self->priv->email_menubutton;
		_tmp37_ = gtk_menu_button_get_popover (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = new_model;
		gtk_popover_bind_model (_tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, g_menu_model_get_type (), GMenuModel), NULL);
		_tmp40_ = self->priv->email_menubutton;
		_tmp41_ = gtk_menu_button_get_popover (_tmp40_);
		_tmp42_ = _tmp41_;
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (new_model);
		_g_object_unref0 (main);
		block82_data_unref (_data82_);
		_data82_ = NULL;
	}
}

static void
conversation_email_update_displayed_attachments (ConversationEmail* self)
{
	gboolean has_attachments = FALSE;
	GeeList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkButton* _tmp3_;
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp4_;
	ApplicationMainWindow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp0_ = self->priv->displayed_attachments;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	has_attachments = !_tmp2_;
	_tmp3_ = self->priv->attachments_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), has_attachments);
	_tmp4_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp4_) ? ((ApplicationMainWindow*) _tmp4_) : NULL);
	main = _tmp5_;
	if (has_attachments) {
		ApplicationMainWindow* _tmp7_;
		_tmp7_ = main;
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ApplicationMainWindow* _tmp8_;
		ApplicationAttachmentManager* _tmp9_;
		ApplicationAttachmentManager* _tmp10_;
		ComponentsAttachmentPane* _tmp11_;
		ComponentsAttachmentPane* _tmp12_;
		ConversationMessage* _tmp13_;
		GtkGrid* _tmp14_;
		GtkGrid* _tmp15_;
		ComponentsAttachmentPane* _tmp16_;
		_tmp8_ = main;
		_tmp9_ = application_main_window_get_attachments (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = components_attachment_pane_new (FALSE, _tmp10_);
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		conversation_email_set_attachments_pane (self, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = self->priv->_primary_message;
		_tmp14_ = conversation_message_get_body_container (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_attachments_pane;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		{
			GeeList* _attachment_list = NULL;
			GeeList* _tmp17_;
			gint _attachment_size = 0;
			GeeList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _attachment_index = 0;
			_tmp17_ = self->priv->displayed_attachments;
			_attachment_list = _tmp17_;
			_tmp18_ = _attachment_list;
			_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp20_ = _tmp19_;
			_attachment_size = _tmp20_;
			_attachment_index = -1;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				GearyAttachment* attachment = NULL;
				GeeList* _tmp23_;
				gpointer _tmp24_;
				ComponentsAttachmentPane* _tmp25_;
				GearyAttachment* _tmp26_;
				GCancellable* _tmp27_;
				_attachment_index = _attachment_index + 1;
				_tmp21_ = _attachment_index;
				_tmp22_ = _attachment_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _attachment_list;
				_tmp24_ = gee_list_get (_tmp23_, _attachment_index);
				attachment = (GearyAttachment*) _tmp24_;
				_tmp25_ = self->priv->_attachments_pane;
				_tmp26_ = attachment;
				_tmp27_ = self->priv->load_cancellable;
				components_attachment_pane_add_attachment (_tmp25_, _tmp26_, _tmp27_);
				_g_object_unref0 (attachment);
			}
		}
	}
	_g_object_unref0 (main);
}

static void
conversation_email_handle_load_failure (ConversationEmail* self,
                                        GError* _error_)
{
	ConversationMessage* _tmp0_;
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	ApplicationMainWindow* _tmp3_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (_error_ != NULL);
	conversation_email_set_message_body_state (self, CONVERSATION_EMAIL_LOAD_STATE_FAILED);
	_tmp0_ = self->priv->_primary_message;
	conversation_message_show_load_error_pane (_tmp0_);
	_tmp1_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp1_) ? ((ApplicationMainWindow*) _tmp1_) : NULL);
	main = _tmp2_;
	_tmp3_ = main;
	if (_tmp3_ != NULL) {
		GearyAccountInformation* account = NULL;
		GearyAppEmailStore* _tmp4_;
		GearyAccount* _tmp5_;
		GearyAccount* _tmp6_;
		GearyAccountInformation* _tmp7_;
		GearyAccountInformation* _tmp8_;
		GearyAccountInformation* _tmp9_;
		ApplicationMainWindow* _tmp10_;
		ApplicationClient* _tmp11_;
		ApplicationClient* _tmp12_;
		ApplicationController* _tmp13_;
		ApplicationController* _tmp14_;
		GearyAccountInformation* _tmp15_;
		GearyAccountInformation* _tmp16_;
		GearyServiceInformation* _tmp17_;
		GearyServiceInformation* _tmp18_;
		GearyServiceProblemReport* _tmp19_;
		GearyServiceProblemReport* _tmp20_;
		_tmp4_ = self->priv->email_store;
		_tmp5_ = geary_app_email_store_get_account (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_account_get_information (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		account = _tmp9_;
		_tmp10_ = main;
		_tmp11_ = application_main_window_get_application (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = application_client_get_controller (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = account;
		_tmp16_ = account;
		_tmp17_ = geary_account_information_get_incoming (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = geary_service_problem_report_new (_tmp15_, _tmp18_, _error_);
		_tmp20_ = _tmp19_;
		composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (account);
	}
	_g_object_unref0 (main);
}

static void
conversation_email_handle_load_offline (ConversationEmail* self)
{
	ConversationMessage* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	conversation_email_set_message_body_state (self, CONVERSATION_EMAIL_LOAD_STATE_FAILED);
	_tmp0_ = self->priv->_primary_message;
	conversation_message_show_offline_pane (_tmp0_);
}

static inline gboolean
conversation_email_is_online (ConversationEmail* self)
{
	GearyAppEmailStore* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GearyClientService* _tmp3_;
	GearyClientService* _tmp4_;
	GearyClientServiceStatus _tmp5_;
	GearyClientServiceStatus _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (self), FALSE);
	_tmp0_ = self->priv->email_store;
	_tmp1_ = geary_app_email_store_get_account (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_account_get_incoming (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_client_service_get_current_status (_tmp4_);
	_tmp6_ = _tmp5_;
	result = _tmp6_ == GEARY_CLIENT_SERVICE_STATUS_CONNECTED;
	return result;
}

static void
conversation_email_activate_email_action (ConversationEmail* self,
                                          const gchar* name)
{
	GActionGroup* email_actions = NULL;
	GActionGroup* _tmp0_;
	GActionGroup* _tmp1_;
	GActionGroup* _tmp2_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = gtk_widget_get_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), CONVERSATION_LIST_BOX_EMAIL_ACTION_GROUP_NAME);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	email_actions = _tmp1_;
	_tmp2_ = email_actions;
	if (_tmp2_ != NULL) {
		GActionGroup* _tmp3_;
		GearyEmail* _tmp4_;
		GearyEmailIdentifier* _tmp5_;
		GearyEmailIdentifier* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		_tmp3_ = email_actions;
		_tmp4_ = self->priv->_email;
		_tmp5_ = geary_email_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_email_identifier_to_variant (_tmp6_);
		_tmp8_ = _tmp7_;
		g_action_group_activate_action (_tmp3_, name, _tmp8_);
		_g_variant_unref0 (_tmp8_);
	}
	_g_object_unref0 (email_actions);
}

static void
conversation_email_on_email_menu (ConversationEmail* self)
{
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	conversation_email_update_email_menu (self);
}

static void
_conversation_email_on_email_menu_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	conversation_email_on_email_menu ((ConversationEmail*) self);
}

static void
conversation_email_on_shift_changed (ConversationEmail* self)
{
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	conversation_email_update_email_menu (self);
}

static void
conversation_email_on_body_loading_timeout (ConversationEmail* self)
{
	ConversationMessage* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp0_ = self->priv->_primary_message;
	conversation_message_show_loading_pane (_tmp0_);
}

static void
conversation_email_on_load_cancelled (ConversationEmail* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp0_ = self->priv->body_loading_timeout;
	geary_timeout_manager_reset (_tmp0_);
}

static void
conversation_email_on_flag_remote_images (ConversationEmail* self)
{
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	conversation_email_activate_email_action (self, CONVERSATION_LIST_BOX_ACTION_MARK_LOAD_REMOTE);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
conversation_email_on_save_image (ConversationEmail* self,
                                  const gchar* uri,
                                  const gchar* alt_text,
                                  GearyMemoryBuffer* content)
{
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (uri != NULL);
	g_return_if_fail ((content == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (content, GEARY_MEMORY_TYPE_BUFFER));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	main = _tmp1_;
	_tmp2_ = main;
	if (_tmp2_ != NULL) {
		if (g_str_has_prefix (uri, COMPONENTS_WEB_VIEW_CID_URL_PREFIX)) {
			gchar* cid = NULL;
			gint _tmp3_;
			gint _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = strlen (COMPONENTS_WEB_VIEW_CID_URL_PREFIX);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_substring (uri, (glong) _tmp4_, (glong) -1);
			cid = _tmp5_;
			{
				GearyAttachment* attachment = NULL;
				GearyEmail* _tmp6_;
				const gchar* _tmp7_;
				GearyAttachment* _tmp8_;
				ApplicationMainWindow* _tmp9_;
				ApplicationAttachmentManager* _tmp10_;
				ApplicationAttachmentManager* _tmp11_;
				GearyAttachment* _tmp12_;
				_tmp6_ = self->priv->_email;
				_tmp7_ = cid;
				_tmp8_ = geary_email_get_attachment_by_content_id (_tmp6_, _tmp7_, &_inner_error0_);
				attachment = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp9_ = main;
				_tmp10_ = application_main_window_get_attachments (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = attachment;
				application_attachment_manager_save_attachment (_tmp11_, _tmp12_, alt_text, NULL, NULL, NULL);
				_g_object_unref0 (attachment);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				const gchar* _tmp13_;
				GError* _tmp14_;
				const gchar* _tmp15_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = cid;
				_tmp14_ = err;
				_tmp15_ = _tmp14_->message;
				g_debug ("conversation-email.vala:902: Could not get attachment \"%s\": %s", _tmp13_, _tmp15_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (cid);
				_g_object_unref0 (main);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (cid);
		} else {
			if (content != NULL) {
				GFile* source = NULL;
				GFile* _tmp16_;
				gchar* display_name = NULL;
				GFile* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				ApplicationMainWindow* _tmp22_;
				ApplicationAttachmentManager* _tmp23_;
				ApplicationAttachmentManager* _tmp24_;
				const gchar* _tmp25_;
				_tmp16_ = g_file_new_for_uri (uri);
				source = _tmp16_;
				_tmp17_ = source;
				_tmp18_ = g_file_get_basename (_tmp17_);
				display_name = _tmp18_;
				_tmp19_ = display_name;
				if (geary_string_is_empty_or_whitespace (_tmp19_)) {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = application_attachment_manager_untitled_file_name;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (display_name);
					display_name = _tmp21_;
				}
				_tmp22_ = main;
				_tmp23_ = application_main_window_get_attachments (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = display_name;
				application_attachment_manager_save_buffer (_tmp24_, _tmp25_, content, NULL, NULL, NULL);
				_g_free0 (display_name);
				_g_object_unref0 (source);
			}
		}
	}
	_g_object_unref0 (main);
}

static void
conversation_email_on_resource_loaded (ConversationEmail* self,
                                       const gchar* id)
{
	GeeIterator* displayed = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->displayed_attachments;
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
	displayed = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		GearyAttachment* attachment = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		GearyAttachment* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp2_ = displayed;
		if (!gee_iterator_has_next (_tmp2_)) {
			break;
		}
		_tmp3_ = displayed;
		gee_iterator_next (_tmp3_);
		_tmp4_ = displayed;
		_tmp5_ = gee_iterator_get (_tmp4_);
		attachment = (GearyAttachment*) _tmp5_;
		_tmp6_ = attachment;
		_tmp7_ = geary_attachment_get_content_id (_tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, id) == 0) {
			GeeIterator* _tmp9_;
			_tmp9_ = displayed;
			gee_iterator_remove (_tmp9_);
		}
		_g_object_unref0 (attachment);
	}
	_g_object_unref0 (displayed);
}

static void
conversation_email_on_content_loaded (ConversationEmail* self)
{
	gboolean all_loaded = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	all_loaded = TRUE;
	{
		GeeIterator* _message_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = conversation_email_iterator (self);
		_message_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ConversationMessage* message = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ConversationMessage* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = _message_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _message_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			message = (ConversationMessage*) _tmp3_;
			_tmp4_ = message;
			_tmp5_ = conversation_message_get_is_content_loaded (_tmp4_);
			_tmp6_ = _tmp5_;
			if (!_tmp6_) {
				all_loaded = FALSE;
				_g_object_unref0 (message);
				break;
			}
			_g_object_unref0 (message);
		}
		_g_object_unref0 (_message_it);
	}
	if (all_loaded) {
		ConversationEmailLoadState _tmp8_;
		_tmp8_ = self->priv->_message_body_state;
		_tmp7_ = _tmp8_ != CONVERSATION_EMAIL_LOAD_STATE_COMPLETED;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GearyNonblockingSpinlock* _tmp9_;
		conversation_email_set_message_body_state (self, CONVERSATION_EMAIL_LOAD_STATE_COMPLETED);
		_tmp9_ = self->priv->message_bodies_loaded_lock;
		geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
		conversation_email_update_displayed_attachments (self);
	}
}

static void
conversation_email_on_service_status_change (ConversationEmail* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ConversationEmailLoadState _tmp2_;
	g_return_if_fail (IS_CONVERSATION_EMAIL (self));
	_tmp2_ = self->priv->_message_body_state;
	if (_tmp2_ == CONVERSATION_EMAIL_LOAD_STATE_FAILED) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->load_cancellable;
		_tmp1_ = !g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = conversation_email_is_online (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		conversation_email_fetch_remote_body (self, NULL, NULL);
	}
}

static inline gpointer
conversation_email_message_view_iterator_get_instance_private (ConversationEmailMessageViewIterator* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationEmailMessageViewIterator_private_offset);
}

static gboolean
conversation_email_message_view_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	ConversationEmailMessageViewIterator* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	result = TRUE;
	return result;
}

static gboolean
conversation_email_message_view_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	ConversationEmailMessageViewIterator* self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	if (self->priv->pos == 0) {
		_tmp0_ = TRUE;
	} else {
		GeeIterator* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->attached_views;
		_tmp2_ = gee_iterator_get_valid (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static ConversationEmailMessageViewIterator*
conversation_email_message_view_iterator_construct (GType object_type,
                                                    ConversationEmail* parent_view)
{
	ConversationEmailMessageViewIterator * self = NULL;
	ConversationEmail* _tmp0_;
	GeeList* _tmp1_;
	GeeIterator* _tmp2_;
	g_return_val_if_fail (IS_CONVERSATION_EMAIL (parent_view), NULL);
	self = (ConversationEmailMessageViewIterator*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (parent_view);
	_g_object_unref0 (self->priv->parent_view);
	self->priv->parent_view = _tmp0_;
	_tmp1_ = parent_view->priv->_attached_messages;
	_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
	_g_object_unref0 (self->priv->attached_views);
	self->priv->attached_views = _tmp2_;
	return self;
}

static ConversationEmailMessageViewIterator*
conversation_email_message_view_iterator_new (ConversationEmail* parent_view)
{
	return conversation_email_message_view_iterator_construct (CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, parent_view);
}

static gboolean
conversation_email_message_view_iterator_real_next (GeeIterator* base)
{
	ConversationEmailMessageViewIterator * self;
	gboolean has_next = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	has_next = FALSE;
	self->priv->pos = self->priv->pos + 1;
	if (self->priv->pos == 0) {
		has_next = TRUE;
	} else {
		GeeIterator* _tmp0_;
		_tmp0_ = self->priv->attached_views;
		has_next = gee_iterator_next (_tmp0_);
	}
	result = has_next;
	return result;
}

static gboolean
conversation_email_message_view_iterator_real_has_next (GeeIterator* base)
{
	ConversationEmailMessageViewIterator * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	if (self->priv->pos == -1) {
		_tmp0_ = TRUE;
	} else {
		GeeIterator* _tmp1_;
		_tmp1_ = self->priv->attached_views;
		_tmp0_ = gee_iterator_next (_tmp1_);
	}
	result = _tmp0_;
	return result;
}

static ConversationMessage*
conversation_email_message_view_iterator_real_get (GeeIterator* base)
{
	ConversationEmailMessageViewIterator * self;
	ConversationMessage* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	switch (self->priv->pos) {
		case -1:
		{
			g_assert_not_reached ();
		}
		case 0:
		{
			ConversationEmail* _tmp0_;
			ConversationMessage* _tmp1_;
			ConversationMessage* _tmp2_;
			ConversationMessage* _tmp3_;
			_tmp0_ = self->priv->parent_view;
			_tmp1_ = conversation_email_get_primary_message (_tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
		default:
		{
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			_tmp4_ = self->priv->attached_views;
			_tmp5_ = gee_iterator_get (_tmp4_);
			result = (ConversationMessage*) _tmp5_;
			return result;
		}
	}
}

static void
conversation_email_message_view_iterator_real_remove (GeeIterator* base)
{
	ConversationEmailMessageViewIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	g_assert_not_reached ();
}

static gboolean
conversation_email_message_view_iterator_real_foreach (GeeTraversable* base,
                                                       GeeForallFunc f,
                                                       gpointer f_target)
{
	ConversationEmailMessageViewIterator * self;
	gboolean cont = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	cont = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gpointer _tmp1_;
		if (cont) {
			_tmp0_ = gee_iterator_has_next (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator));
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		gee_iterator_next (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator));
		_tmp1_ = gee_iterator_get (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator));
		cont = f ((ConversationMessage*) _tmp1_, f_target);
	}
	result = cont;
	return result;
}

static void
conversation_email_message_view_iterator_class_init (ConversationEmailMessageViewIteratorClass * klass,
                                                     gpointer klass_data)
{
	conversation_email_message_view_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationEmailMessageViewIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_email_message_view_iterator_get_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_email_message_view_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_READ_ONLY_PROPERTY, conversation_email_message_view_iterator_properties[CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_VALID_PROPERTY, conversation_email_message_view_iterator_properties[CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
conversation_email_message_view_iterator_gee_traversable_get_g_type (ConversationEmailMessageViewIterator* self)
{
	return TYPE_CONVERSATION_MESSAGE;
}

static GBoxedCopyFunc
conversation_email_message_view_iterator_gee_traversable_get_g_dup_func (ConversationEmailMessageViewIterator* self)
{
	return g_object_ref;
}

static GDestroyNotify
conversation_email_message_view_iterator_gee_traversable_get_g_destroy_func (ConversationEmailMessageViewIterator* self)
{
	return g_object_unref;
}

static void
conversation_email_message_view_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                                         gpointer iface_data)
{
	conversation_email_message_view_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) conversation_email_message_view_iterator_real_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) conversation_email_message_view_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) conversation_email_message_view_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) conversation_email_message_view_iterator_gee_traversable_get_g_destroy_func;
}

static void
conversation_email_message_view_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                                      gpointer iface_data)
{
	conversation_email_message_view_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) conversation_email_message_view_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) conversation_email_message_view_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) conversation_email_message_view_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) conversation_email_message_view_iterator_real_remove;
	iface->get_read_only = conversation_email_message_view_iterator_real_get_read_only;
	iface->get_valid = conversation_email_message_view_iterator_real_get_valid;
}

static void
conversation_email_message_view_iterator_instance_init (ConversationEmailMessageViewIterator * self,
                                                        gpointer klass)
{
	self->priv = conversation_email_message_view_iterator_get_instance_private (self);
	self->priv->pos = -1;
	self->priv->attached_views = NULL;
}

static void
conversation_email_message_view_iterator_finalize (GObject * obj)
{
	ConversationEmailMessageViewIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	_g_object_unref0 (self->priv->parent_view);
	_g_object_unref0 (self->priv->attached_views);
	G_OBJECT_CLASS (conversation_email_message_view_iterator_parent_class)->finalize (obj);
}

/**
     * Iterator that returns all message views in an email view.
     */
static GType
conversation_email_message_view_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationEmailMessageViewIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_email_message_view_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationEmailMessageViewIterator), 0, (GInstanceInitFunc) conversation_email_message_view_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) conversation_email_message_view_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) conversation_email_message_view_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_email_message_view_iterator_type_id;
	conversation_email_message_view_iterator_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ConversationEmailMessageViewIterator", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_email_message_view_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (conversation_email_message_view_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	ConversationEmailMessageViewIterator_private_offset = g_type_add_instance_private (conversation_email_message_view_iterator_type_id, sizeof (ConversationEmailMessageViewIteratorPrivate));
	return conversation_email_message_view_iterator_type_id;
}

static GType
conversation_email_message_view_iterator_get_type (void)
{
	static volatile gsize conversation_email_message_view_iterator_type_id__once = 0;
	if (g_once_init_enter (&conversation_email_message_view_iterator_type_id__once)) {
		GType conversation_email_message_view_iterator_type_id;
		conversation_email_message_view_iterator_type_id = conversation_email_message_view_iterator_get_type_once ();
		g_once_init_leave (&conversation_email_message_view_iterator_type_id__once, conversation_email_message_view_iterator_type_id);
	}
	return conversation_email_message_view_iterator_type_id__once;
}

static void
_vala_conversation_email_message_view_iterator_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	ConversationEmailMessageViewIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_EMAIL_TYPE_MESSAGE_VIEW_ITERATOR, ConversationEmailMessageViewIterator);
	switch (property_id) {
		case CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
		break;
		case CONVERSATION_EMAIL_MESSAGE_VIEW_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
conversation_email_class_init (ConversationEmailClass * klass,
                               gpointer klass_data)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GMenuModel* _tmp3_;
	GtkBuilder* _tmp4_;
	GObject* _tmp5_;
	GMenuModel* _tmp6_;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_;
	GMenuModel* _tmp9_;
	conversation_email_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationEmail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_email_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_email_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_email_finalize;
	/**
	     * The specific email that is displayed by this view.
	     *
	     * This object is updated as additional fields are loaded, so it
	     * should not be relied on to a) contain required fields without
	     * testing or b) assumed to be the same over the life of this view
	     * object.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_EMAIL_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_EMAIL_PROPERTY] = g_param_spec_object ("email", "email", "email", GEARY_TYPE_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this email currently flagged as unread. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_IS_UNREAD_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_IS_UNREAD_PROPERTY] = g_param_spec_boolean ("is-unread", "is-unread", "is-unread", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this email currently flagged as starred. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_IS_STARRED_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_IS_STARRED_PROPERTY] = g_param_spec_boolean ("is-starred", "is-starred", "is-starred", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the email has been manually marked as being read. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY] = g_param_spec_boolean ("is-manually-read", "is-manually-read", "is-manually-read", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if the email is a draft message. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_IS_DRAFT_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_IS_DRAFT_PROPERTY] = g_param_spec_boolean ("is-draft", "is-draft", "is-draft", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The view displaying the email's primary message headers and body. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY] = g_param_spec_object ("primary-message", "primary-message", "primary-message", TYPE_CONVERSATION_MESSAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY] = g_param_spec_object ("attachments-pane", "attachments-pane", "attachments-pane", COMPONENTS_TYPE_ATTACHMENT_PANE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Views for attached messages. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_ATTACHED_MESSAGES_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_ATTACHED_MESSAGES_PROPERTY] = g_param_spec_object ("attached-messages", "attached-messages", "attached-messages", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines the message body loading state. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY, conversation_email_properties[CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY] = g_param_spec_enum ("message-body-state", "message-body-state", "message-body-state", CONVERSATION_EMAIL_TYPE_LOAD_STATE, CONVERSATION_EMAIL_LOAD_STATE_NOT_STARTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/conversation-email.ui");
	/** Fired when a internal link is activated */
	conversation_email_signals[CONVERSATION_EMAIL_INTERNAL_LINK_ACTIVATED_SIGNAL] = g_signal_new ("internal-link-activated", TYPE_CONVERSATION_EMAIL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	/** Fired when the user selects text in a message. */
	conversation_email_signals[CONVERSATION_EMAIL_BODY_SELECTION_CHANGED_SIGNAL] = g_signal_new ("body-selection-changed", TYPE_CONVERSATION_EMAIL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actions", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, actions));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "attachments_button", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, attachments_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "star_button", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, star_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unstar_button", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, unstar_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "email_menubutton", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, email_menubutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sub_messages", FALSE, ConversationEmail_private_offset + G_STRUCT_OFFSET (ConversationEmailPrivate, sub_messages));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_email_menu", G_CALLBACK(_conversation_email_on_email_menu_gtk_toggle_button_toggled));
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Geary/conversation-email-menus.ui");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "email_menu");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (conversation_email_email_menu_template);
	conversation_email_email_menu_template = _tmp3_;
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "email_menu_trash");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (conversation_email_email_menu_trash_section);
	conversation_email_email_menu_trash_section = _tmp6_;
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "email_menu_delete");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (conversation_email_email_menu_delete_section);
	conversation_email_email_menu_delete_section = _tmp9_;
	_g_object_unref0 (builder);
}

static void
conversation_email_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                        gpointer iface_data)
{
	conversation_email_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
conversation_email_instance_init (ConversationEmail * self,
                                  gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	self->priv = conversation_email_get_instance_private (self);
	self->is_collapsed = TRUE;
	self->priv->_attachments_pane = NULL;
	_tmp0_ = gee_linked_list_new (TYPE_CONVERSATION_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_attached_messages = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	self->priv->_message_body_state = CONVERSATION_EMAIL_LOAD_STATE_NOT_STARTED;
	self->priv->body_selection_message = NULL;
	_tmp1_ = gee_linked_list_new (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->displayed_attachments = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	self->priv->shift_handler_installed = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversation_email_finalize (GObject * obj)
{
	ConversationEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSATION_EMAIL, ConversationEmail);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->_email);
	_g_object_unref0 (self->priv->_primary_message);
	_g_object_unref0 (self->priv->_attachments_pane);
	_g_object_unref0 (self->priv->_attached_messages);
	_g_object_unref0 (self->conversation);
	_g_object_unref0 (self->priv->email_store);
	_g_object_unref0 (self->priv->contacts);
	_g_object_unref0 (self->priv->load_cancellable);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->body_loading_timeout);
	_g_object_unref0 (self->priv->message_bodies_loaded_lock);
	_g_object_unref0 (self->priv->body_selection_message);
	_g_object_unref0 (self->priv->displayed_attachments);
	G_OBJECT_CLASS (conversation_email_parent_class)->finalize (obj);
}

/**
 * A widget for displaying an email in a conversation.
 *
 * This view corresponds to {@link Geary.Email}, displaying the
 * email's primary message (a {@link Geary.RFC822.Message}), any
 * sub-messages (also instances of {@link Geary.RFC822.Message}) and
 * attachments. The RFC822 messages are themselves displayed by {@link
 * ConversationMessage}.
 */
static GType
conversation_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationEmailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_email_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationEmail), 0, (GInstanceInitFunc) conversation_email_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) conversation_email_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_email_type_id;
	conversation_email_type_id = g_type_register_static (gtk_box_get_type (), "ConversationEmail", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_email_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ConversationEmail_private_offset = g_type_add_instance_private (conversation_email_type_id, sizeof (ConversationEmailPrivate));
	return conversation_email_type_id;
}

GType
conversation_email_get_type (void)
{
	static volatile gsize conversation_email_type_id__once = 0;
	if (g_once_init_enter (&conversation_email_type_id__once)) {
		GType conversation_email_type_id;
		conversation_email_type_id = conversation_email_get_type_once ();
		g_once_init_leave (&conversation_email_type_id__once, conversation_email_type_id);
	}
	return conversation_email_type_id__once;
}

static void
_vala_conversation_email_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ConversationEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_EMAIL, ConversationEmail);
	switch (property_id) {
		case CONVERSATION_EMAIL_EMAIL_PROPERTY:
		g_value_set_object (value, conversation_email_get_email (self));
		break;
		case CONVERSATION_EMAIL_IS_UNREAD_PROPERTY:
		g_value_set_boolean (value, conversation_email_get_is_unread (self));
		break;
		case CONVERSATION_EMAIL_IS_STARRED_PROPERTY:
		g_value_set_boolean (value, conversation_email_get_is_starred (self));
		break;
		case CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY:
		g_value_set_boolean (value, conversation_email_get_is_manually_read (self));
		break;
		case CONVERSATION_EMAIL_IS_DRAFT_PROPERTY:
		g_value_set_boolean (value, conversation_email_get_is_draft (self));
		break;
		case CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY:
		g_value_set_object (value, conversation_email_get_primary_message (self));
		break;
		case CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY:
		g_value_set_object (value, conversation_email_get_attachments_pane (self));
		break;
		case CONVERSATION_EMAIL_ATTACHED_MESSAGES_PROPERTY:
		g_value_take_object (value, conversation_email_get_attached_messages (self));
		break;
		case CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY:
		g_value_set_enum (value, conversation_email_get_message_body_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_email_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ConversationEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_EMAIL, ConversationEmail);
	switch (property_id) {
		case CONVERSATION_EMAIL_EMAIL_PROPERTY:
		conversation_email_set_email (self, g_value_get_object (value));
		break;
		case CONVERSATION_EMAIL_IS_MANUALLY_READ_PROPERTY:
		conversation_email_set_is_manually_read (self, g_value_get_boolean (value));
		break;
		case CONVERSATION_EMAIL_IS_DRAFT_PROPERTY:
		conversation_email_set_is_draft (self, g_value_get_boolean (value));
		break;
		case CONVERSATION_EMAIL_PRIMARY_MESSAGE_PROPERTY:
		conversation_email_set_primary_message (self, g_value_get_object (value));
		break;
		case CONVERSATION_EMAIL_ATTACHMENTS_PANE_PROPERTY:
		conversation_email_set_attachments_pane (self, g_value_get_object (value));
		break;
		case CONVERSATION_EMAIL_MESSAGE_BODY_STATE_PROPERTY:
		conversation_email_set_message_body_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

