/* imap-engine.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include "geary-engine.h"
#include <gio/gio.h>

VALA_EXTERN gboolean geary_imap_engine_is_recoverable_failure (GError* err);
VALA_EXTERN gboolean geary_imap_engine_is_remote_error (GError* err);

/**
     * Determines if retrying an operation might succeed or not.
     *
     * A recoverable failure is defined as one that may not occur
     * again if the operation that caused it is retried, without
     * needing to make some change in the mean time. For example,
     * recoverable failures may occur due to transient network
     * connectivity issues or server rate limiting. On the other hand,
     * an unrecoverable failure is due to some problem that will not
     * succeed if tried again unless some action is taken, such as
     * authentication failures, protocol parsing errors, and so on.
     */
gboolean
geary_imap_engine_is_recoverable_failure (GError* err)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (err != NULL, FALSE);
	if (g_error_matches (err, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_SERVER_UNAVAILABLE)) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_BROKEN_PIPE);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_BUSY);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_CONNECTION_CLOSED);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_NOT_CONNECTED);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_TIMED_OUT);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_error_matches (err, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_error_matches (err, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TIMED_OUT);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_error_matches (err, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_UNAVAILABLE);
	}
	result = _tmp0_;
	return result;
}

/**
     * Determines if an error was caused by the remote host or not.
     */
gboolean
geary_imap_engine_is_remote_error (GError* err)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean result;
	g_return_val_if_fail (err != NULL, FALSE);
	if (g_error_matches (err, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = g_error_matches (err, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_SERVER_UNAVAILABLE);
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_CONNECTION_CLOSED);
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_CONNECTION_REFUSED);
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_HOST_UNREACHABLE);
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_MESSAGE_TOO_LARGE);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_NETWORK_UNREACHABLE);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_NOT_CONNECTED);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_PROXY_AUTH_FAILED);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_PROXY_FAILED);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_PROXY_NEED_AUTH);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_error_matches (err, G_IO_ERROR, G_IO_ERROR_PROXY_NOT_ALLOWED);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = err->domain == GEARY_IMAP_ERROR;
	}
	result = _tmp0_;
	return result;
}

