/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.lang.ref.WeakReference;
import java.util.Objects;
import org.gephi.appearance.RankingImpl;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;

public class AttributeRankingImpl
extends RankingImpl {
    protected final WeakReference<Column> column;

    public AttributeRankingImpl(Column column) {
        this.column = new WeakReference<Column>(column);
    }

    @Override
    public Number getMinValue(Graph graph) {
        return this.getIndex(graph).getMinValue((Column)this.column.get());
    }

    @Override
    public Number getMaxValue(Graph graph) {
        return this.getIndex(graph).getMaxValue((Column)this.column.get());
    }

    private Index<Element> getIndex(Graph graph) {
        return graph.getModel().getElementIndex(((Column)this.column.get()).getTable(), graph.getView());
    }

    @Override
    public Number getValue(Element element, Graph graph) {
        return (Number)element.getAttribute((Column)this.column.get(), graph.getView());
    }

    @Override
    public boolean isValid(Graph graph) {
        Column col = (Column)this.column.get();
        if (col != null && col.getIndex() != -1) {
            return col.isNumber() && !col.isArray();
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.column != null ? this.column.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeRankingImpl other = (AttributeRankingImpl)obj;
        return Objects.equals(this.column, other.column);
    }

    @Override
    public Column getColumn() {
        return (Column)this.column.get();
    }
}

