/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.type.RuntimeTypeInformation;
import io.micronaut.core.type.TypeInformation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public interface ReturnType<T>
extends TypeInformation<T>,
AnnotationMetadataProvider,
ArgumentCoercible<T> {
    @Override
    @NonNull
    default public Argument<T> asArgument() {
        Collection<Argument<?>> values = this.getTypeVariables().values();
        return Argument.of(this.getType(), values.toArray(Argument.ZERO_ARGUMENTS));
    }

    default public boolean isSuspended() {
        return false;
    }

    default public boolean isSingleResult() {
        if (this.isSpecifiedSingle()) {
            return true;
        }
        if (this.isReactive()) {
            Class returnType = this.getType();
            return RuntimeTypeInformation.isSingle(returnType);
        }
        return true;
    }

    public static <T1> ReturnType<T1> of(final Class<T1> type, final Argument<?> ... typeArguments) {
        final LinkedHashMap argumentMap = new LinkedHashMap(typeArguments.length);
        for (Argument<?> argument : typeArguments) {
            argumentMap.put(argument.getName(), argument);
        }
        return new ReturnType<T1>(){

            @Override
            public Class<T1> getType() {
                return type;
            }

            @Override
            public Argument[] getTypeParameters() {
                return typeArguments;
            }

            @Override
            public Map<String, Argument<?>> getTypeVariables() {
                return argumentMap;
            }
        };
    }
}

